from datetime import datetime
import re


def gen_valid_name(prefix: str = "autogenerated") -> str:
    """Generate a name for anyscale resources."""
    INVALID_NAME_REGEX_PATTERN = r"[^A-Za-z0-9_-]"

    generated_name = f"{prefix}-{datetime.now().isoformat()}"
    generated_name = re.sub(INVALID_NAME_REGEX_PATTERN, "-", generated_name)
    return generated_name
