"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deployArtifactBounds = exports.sourceArtifactBounds = void 0;
/**
 * The ArtifactBounds that make sense for source Actions -
 * they don't have any inputs, and have exactly one output.
 */
function sourceArtifactBounds() {
    return {
        minInputs: 0,
        maxInputs: 0,
        minOutputs: 1,
        maxOutputs: 1,
    };
}
exports.sourceArtifactBounds = sourceArtifactBounds;
/**
 * The ArtifactBounds that make sense for deploy Actions -
 * they have exactly one input, and don't produce any outputs.
 */
function deployArtifactBounds() {
    return {
        minInputs: 1,
        maxInputs: 1,
        minOutputs: 0,
        maxOutputs: 0,
    };
}
exports.deployArtifactBounds = deployArtifactBounds;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBOzs7R0FHRztBQUNILFNBQWdCLG9CQUFvQjtJQUNsQyxPQUFPO1FBQ0wsU0FBUyxFQUFFLENBQUM7UUFDWixTQUFTLEVBQUUsQ0FBQztRQUNaLFVBQVUsRUFBRSxDQUFDO1FBQ2IsVUFBVSxFQUFFLENBQUM7S0FDZCxDQUFDO0FBQ0osQ0FBQztBQVBELG9EQU9DO0FBRUQ7OztHQUdHO0FBQ0gsU0FBZ0Isb0JBQW9CO0lBQ2xDLE9BQU87UUFDTCxTQUFTLEVBQUUsQ0FBQztRQUNaLFNBQVMsRUFBRSxDQUFDO1FBQ1osVUFBVSxFQUFFLENBQUM7UUFDYixVQUFVLEVBQUUsQ0FBQztLQUNkLENBQUM7QUFDSixDQUFDO0FBUEQsb0RBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2RlcGlwZWxpbmUgZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSc7XG5cbi8qKlxuICogVGhlIEFydGlmYWN0Qm91bmRzIHRoYXQgbWFrZSBzZW5zZSBmb3Igc291cmNlIEFjdGlvbnMgLVxuICogdGhleSBkb24ndCBoYXZlIGFueSBpbnB1dHMsIGFuZCBoYXZlIGV4YWN0bHkgb25lIG91dHB1dC5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNvdXJjZUFydGlmYWN0Qm91bmRzKCk6IGNvZGVwaXBlbGluZS5BY3Rpb25BcnRpZmFjdEJvdW5kcyB7XG4gIHJldHVybiB7XG4gICAgbWluSW5wdXRzOiAwLFxuICAgIG1heElucHV0czogMCxcbiAgICBtaW5PdXRwdXRzOiAxLFxuICAgIG1heE91dHB1dHM6IDEsXG4gIH07XG59XG5cbi8qKlxuICogVGhlIEFydGlmYWN0Qm91bmRzIHRoYXQgbWFrZSBzZW5zZSBmb3IgZGVwbG95IEFjdGlvbnMgLVxuICogdGhleSBoYXZlIGV4YWN0bHkgb25lIGlucHV0LCBhbmQgZG9uJ3QgcHJvZHVjZSBhbnkgb3V0cHV0cy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGRlcGxveUFydGlmYWN0Qm91bmRzKCk6IGNvZGVwaXBlbGluZS5BY3Rpb25BcnRpZmFjdEJvdW5kcyB7XG4gIHJldHVybiB7XG4gICAgbWluSW5wdXRzOiAxLFxuICAgIG1heElucHV0czogMSxcbiAgICBtaW5PdXRwdXRzOiAwLFxuICAgIG1heE91dHB1dHM6IDAsXG4gIH07XG59XG4iXX0=