/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class DoubleArray {
    private int capacity = 10;
    private int increment = 0;
    private double[] doubles = null;
    private int length = 0;

    public DoubleArray() {
        this.doubles = new double[this.capacity];
    }

    public DoubleArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.doubles = new double[n];
        this.capacity = n;
    }

    public DoubleArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.doubles = new double[n];
        this.capacity = n;
        this.increment = n2;
    }

    public DoubleArray(double[] dArray) {
        this.doubles = dArray;
        this.capacity = this.length = dArray.length;
    }

    public double[] array() {
        return this.doubles;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            double[] dArray = new double[n];
            for (int i = 0; i < this.length; ++i) {
                dArray[i] = this.doubles[i];
            }
            this.doubles = dArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public double[] get() {
        return this.doubles;
    }

    public double get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.doubles[n];
    }

    public double first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.doubles[0];
    }

    public double last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.doubles[this.length - 1];
    }

    public void add(double d) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.doubles[this.length++] = d;
    }

    public void append(double d) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.doubles[this.length++] = d;
    }

    public void insert(double d, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n; --i) {
            this.doubles[i] = this.doubles[i - 1];
        }
        this.doubles[n] = d;
        ++this.length;
    }

    public void set(double d, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.doubles[n] = d;
    }

    public void set(double[] dArray) {
        this.doubles = dArray;
        this.capacity = this.length = dArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        double[] dArray = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            dArray[i] = this.doubles[i];
        }
        this.doubles = dArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.doubles[i - 1] = this.doubles[i];
        }
        --this.length;
    }

    public DoubleArray duplicate() {
        DoubleArray doubleArray = new DoubleArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            doubleArray.doubles[i] = this.doubles[i];
        }
        doubleArray.length = this.length;
        return doubleArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            double[] dArray = new double[n];
            for (int i = 0; i < this.length; ++i) {
                dArray[i] = this.doubles[i];
            }
            this.doubles = dArray;
        }
    }

    public boolean equals(DoubleArray doubleArray) {
        if (doubleArray != null && doubleArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (doubleArray.doubles[i] == this.doubles[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        double[] dArray = new double[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            dArray[i] = this.doubles[i];
        }
        this.doubles = dArray;
    }
}

