/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class FloatArray {
    private int capacity = 10;
    private int increment = 0;
    private float[] floats = null;
    private int length = 0;

    public FloatArray() {
        this.floats = new float[this.capacity];
    }

    public FloatArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.floats = new float[n];
        this.capacity = n;
    }

    public FloatArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.floats = new float[n];
        this.capacity = n;
        this.increment = n2;
    }

    public FloatArray(float[] fArray) {
        this.floats = fArray;
        this.capacity = this.length = fArray.length;
    }

    public float[] array() {
        return this.floats;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            float[] fArray = new float[n];
            for (int i = 0; i < this.length; ++i) {
                fArray[i] = this.floats[i];
            }
            this.floats = fArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public float[] get() {
        return this.floats;
    }

    public float get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.floats[n];
    }

    public float first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.floats[0];
    }

    public float last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.floats[this.length - 1];
    }

    public void add(float f) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.floats[this.length++] = f;
    }

    public void append(float f) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.floats[this.length++] = f;
    }

    public void insert(float f, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n; --i) {
            this.floats[i] = this.floats[i - 1];
        }
        this.floats[n] = f;
        ++this.length;
    }

    public void set(float f, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.floats[n] = f;
    }

    public void set(float[] fArray) {
        this.floats = fArray;
        this.capacity = this.length = fArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        float[] fArray = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            fArray[i] = this.floats[i];
        }
        this.floats = fArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.floats[i - 1] = this.floats[i];
        }
        --this.length;
    }

    public FloatArray duplicate() {
        FloatArray floatArray = new FloatArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            floatArray.floats[i] = this.floats[i];
        }
        floatArray.length = this.length;
        return floatArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            float[] fArray = new float[n];
            for (int i = 0; i < this.length; ++i) {
                fArray[i] = this.floats[i];
            }
            this.floats = fArray;
        }
    }

    public boolean equals(FloatArray floatArray) {
        if (floatArray != null && floatArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (floatArray.floats[i] == this.floats[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        float[] fArray = new float[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            fArray[i] = this.floats[i];
        }
        this.floats = fArray;
    }
}

