/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class IntArray {
    private int capacity = 10;
    private int increment = 0;
    private int[] ints = null;
    private int length = 0;

    public IntArray() {
        this.ints = new int[this.capacity];
    }

    public IntArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.ints = new int[n];
        this.capacity = n;
    }

    public IntArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.ints = new int[n];
        this.capacity = n;
        this.increment = n2;
    }

    public IntArray(int[] nArray) {
        this.ints = nArray;
        this.capacity = this.length = nArray.length;
    }

    public int[] array() {
        return this.ints;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            int[] nArray = new int[n];
            for (int i = 0; i < this.length; ++i) {
                nArray[i] = this.ints[i];
            }
            this.ints = nArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public int[] get() {
        return this.ints;
    }

    public int get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ints[n];
    }

    public int first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.ints[0];
    }

    public int last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.ints[this.length - 1];
    }

    public void add(int n) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.ints[this.length++] = n;
    }

    public void append(int n) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.ints[this.length++] = n;
    }

    public void insert(int n, int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n2; --i) {
            this.ints[i] = this.ints[i - 1];
        }
        this.ints[n2] = n;
        ++this.length;
    }

    public void set(int n, int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ints[n2] = n;
    }

    public void set(int[] nArray) {
        this.ints = nArray;
        this.capacity = this.length = nArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        int[] nArray = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            nArray[i] = this.ints[i];
        }
        this.ints = nArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.ints[i - 1] = this.ints[i];
        }
        --this.length;
    }

    public IntArray duplicate() {
        IntArray intArray = new IntArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            intArray.ints[i] = this.ints[i];
        }
        intArray.length = this.length;
        return intArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            int[] nArray = new int[n];
            for (int i = 0; i < this.length; ++i) {
                nArray[i] = this.ints[i];
            }
            this.ints = nArray;
        }
    }

    public boolean equals(IntArray intArray) {
        if (intArray != null && intArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (intArray.ints[i] == this.ints[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        int[] nArray = new int[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            nArray[i] = this.ints[i];
        }
        this.ints = nArray;
    }
}

