/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class ShortArray {
    private int capacity = 10;
    private int increment = 0;
    private short[] shorts = null;
    private int length = 0;

    public ShortArray() {
        this.shorts = new short[this.capacity];
    }

    public ShortArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.shorts = new short[n];
        this.capacity = n;
    }

    public ShortArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.shorts = new short[n];
        this.capacity = n;
        this.increment = n2;
    }

    public ShortArray(short[] sArray) {
        this.shorts = sArray;
        this.capacity = this.length = sArray.length;
    }

    public short[] array() {
        return this.shorts;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            short[] sArray = new short[n];
            for (int i = 0; i < this.length; ++i) {
                sArray[i] = this.shorts[i];
            }
            this.shorts = sArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public short[] get() {
        return this.shorts;
    }

    public short get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.shorts[n];
    }

    public short first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.shorts[0];
    }

    public short last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.shorts[this.length - 1];
    }

    public void add(short s) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.shorts[this.length++] = s;
    }

    public void append(short s) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.shorts[this.length++] = s;
    }

    public void insert(short s, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n; --i) {
            this.shorts[i] = this.shorts[i - 1];
        }
        this.shorts[n] = s;
        ++this.length;
    }

    public void set(short s, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.shorts[n] = s;
    }

    public void set(short[] sArray) {
        this.shorts = sArray;
        this.capacity = this.length = sArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        short[] sArray = new short[this.length];
        for (int i = 0; i < this.length; ++i) {
            sArray[i] = this.shorts[i];
        }
        this.shorts = sArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.shorts[i - 1] = this.shorts[i];
        }
        --this.length;
    }

    public ShortArray duplicate() {
        ShortArray shortArray = new ShortArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            shortArray.shorts[i] = this.shorts[i];
        }
        shortArray.length = this.length;
        return shortArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            short[] sArray = new short[n];
            for (int i = 0; i < this.length; ++i) {
                sArray[i] = this.shorts[i];
            }
            this.shorts = sArray;
        }
    }

    public boolean equals(ShortArray shortArray) {
        if (shortArray != null && shortArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (shortArray.shorts[i] == this.shorts[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        short[] sArray = new short[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            sArray[i] = this.shorts[i];
        }
        this.shorts = sArray;
    }
}

