/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.image.Aspects;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Differentiator {
    public static final int MAX_ORDER = 10;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();

    public Image run(Image image, double d, int n, int n2, int n3) {
        Coordinates coordinates;
        double[] dArray;
        double[] dArray2;
        int n4;
        double[] dArray3;
        double d2;
        this.messenger.log(ImageScience.prelude() + "Differentiator");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.check(d, n, n2, n3);
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        Aspects aspects = image.aspects();
        this.messenger.log("Element aspect ratios: (" + aspects.x + "," + aspects.y + "," + aspects.z + "," + aspects.t + "," + aspects.c + ")");
        if (aspects.x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (aspects.y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (aspects.z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        Image image2 = image instanceof FloatImage ? image : new FloatImage(image);
        this.progressor.steps((dimensions.x > 1 ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0) + (dimensions.y > 1 ? dimensions.c * dimensions.t * dimensions.z * dimensions.x : 0) + (dimensions.z > 1 ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0));
        this.progressor.start();
        if (dimensions.x == 1) {
            if (n == 0) {
                this.messenger.log("No operation in x-dimension");
            } else {
                this.messenger.log("Zeroing in x-dimension");
                image2.set(0.0);
            }
        } else {
            d2 = d / aspects.x;
            this.messenger.log("Operating at scale " + d + "/" + aspects.x + " = " + d2 + " pixels");
            this.logus(this.info(n) + " in x-dimension");
            dArray3 = this.kernel(d2, n, dimensions.x);
            n4 = dArray3.length - 1;
            dArray2 = new double[dimensions.x + 2 * n4];
            dArray = new double[dimensions.x];
            coordinates = new Coordinates();
            image2.axes(1);
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            coordinates.x = -n4;
                            image2.get(coordinates, dArray2);
                            this.convolve(dArray2, dArray, dArray3);
                            coordinates.x = 0;
                            image2.set(coordinates, dArray);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (dimensions.y == 1) {
            if (n2 == 0) {
                this.messenger.log("No operation in y-dimension");
            } else {
                this.messenger.log("Zeroing in y-dimension");
                image2.set(0.0);
            }
        } else {
            d2 = d / aspects.y;
            this.messenger.log("Operating at scale " + d + "/" + aspects.y + " = " + d2 + " pixels");
            this.logus(this.info(n2) + " in y-dimension");
            dArray3 = this.kernel(d2, n2, dimensions.y);
            n4 = dArray3.length - 1;
            dArray2 = new double[dimensions.y + 2 * n4];
            dArray = new double[dimensions.y];
            coordinates = new Coordinates();
            image2.axes(2);
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            coordinates.y = -n4;
                            image2.get(coordinates, dArray2);
                            this.convolve(dArray2, dArray, dArray3);
                            coordinates.y = 0;
                            image2.set(coordinates, dArray);
                            this.progressor.step();
                            ++coordinates.x;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (dimensions.z == 1) {
            if (n3 == 0) {
                this.messenger.log("No operation in z-dimension");
            } else {
                this.messenger.log("Zeroing in z-dimension");
                image2.set(0.0);
            }
        } else {
            d2 = d / aspects.z;
            this.messenger.log("Operating at scale " + d + "/" + aspects.z + " = " + d2 + " slices");
            this.logus(this.info(n3) + " in z-dimension");
            dArray3 = this.kernel(d2, n3, dimensions.z);
            n4 = dArray3.length - 1;
            dArray2 = new double[dimensions.z + 2 * n4];
            dArray = new double[dimensions.z];
            coordinates = new Coordinates();
            image2.axes(4);
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            coordinates.z = -n4;
                            image2.get(coordinates, dArray2);
                            this.convolve(dArray2, dArray, dArray3);
                            coordinates.z = 0;
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        this.progressor.step(dimensions.z);
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        this.progressor.stop();
        timer.stop();
        image2.name(image.name() + " dx" + n + " dy" + n2 + " dz" + n3);
        return image2;
    }

    private double[] kernel(double d, int n, int n2) {
        double d2 = 5.0;
        if (n == 0) {
            d2 = 3.0;
        } else if (n <= 2) {
            d2 = 4.0;
        }
        int n3 = (int)(d * d2) + 1;
        if (n3 > n2) {
            n3 = n2;
        }
        double[] dArray = new double[n3];
        double d3 = dArray[0] = n == 0 ? 1.0 : 0.0;
        if (n3 > 1) {
            double d4 = 1.0 / (d * d);
            double d5 = d4 * d4;
            double d6 = d5 * d4;
            double d7 = d6 * d4;
            double d8 = d7 * d4;
            double d9 = -0.5 * d4;
            double d10 = Math.sqrt(Math.PI * 2);
            switch (n) {
                case 0: {
                    int n4;
                    double d11 = 0.0;
                    for (n4 = 0; n4 < n3; ++n4) {
                        dArray[n4] = Math.exp((double)(n4 * n4) * d9);
                        d11 += dArray[n4];
                    }
                    d11 *= 2.0;
                    d11 -= dArray[0];
                    n4 = 0;
                    while (n4 < n3) {
                        int n5 = n4++;
                        dArray[n5] = dArray[n5] / d11;
                    }
                    break;
                }
                case 1: {
                    double d12 = -d4 / (d10 * d);
                    for (int i = 1; i < n3; ++i) {
                        double d13 = i * i;
                        dArray[i] = d12 * (double)i * Math.exp(d13 * d9);
                    }
                    break;
                }
                case 2: {
                    double d14 = d4 / (d10 * d);
                    for (int i = 0; i < n3; ++i) {
                        double d15 = i * i;
                        dArray[i] = d14 * (d15 * d4 - 1.0) * Math.exp(d15 * d9);
                    }
                    break;
                }
                case 3: {
                    double d16 = -d5 / (d10 * d);
                    for (int i = 1; i < n3; ++i) {
                        double d17 = i * i;
                        dArray[i] = d16 * (double)i * (d17 * d4 - 3.0) * Math.exp(d17 * d9);
                    }
                    break;
                }
                case 4: {
                    double d18 = d5 / (d10 * d);
                    for (int i = 0; i < n3; ++i) {
                        double d19 = i * i;
                        dArray[i] = d18 * (d19 * d19 * d5 - 6.0 * d19 * d4 + 3.0) * Math.exp(d19 * d9);
                    }
                    break;
                }
                case 5: {
                    double d20 = -d6 / (d10 * d);
                    for (int i = 1; i < n3; ++i) {
                        double d21 = i * i;
                        dArray[i] = d20 * (double)i * (d21 * d21 * d5 - 10.0 * d21 * d4 + 15.0) * Math.exp(d21 * d9);
                    }
                    break;
                }
                case 6: {
                    double d22 = d6 / (d10 * d);
                    for (int i = 0; i < n3; ++i) {
                        double d23 = i * i;
                        double d24 = d23 * d23;
                        dArray[i] = d22 * (d24 * d23 * d6 - 15.0 * d24 * d5 + 45.0 * d23 * d4 - 15.0) * Math.exp(d23 * d9);
                    }
                    break;
                }
                case 7: {
                    double d25 = -d7 / (d10 * d);
                    for (int i = 1; i < n3; ++i) {
                        double d26 = i * i;
                        double d27 = d26 * d26;
                        dArray[i] = d25 * (double)i * (d27 * d26 * d6 - 21.0 * d27 * d5 + 105.0 * d26 * d4 - 105.0) * Math.exp(d26 * d9);
                    }
                    break;
                }
                case 8: {
                    double d28 = d7 / (d10 * d);
                    for (int i = 0; i < n3; ++i) {
                        double d29 = i * i;
                        double d30 = d29 * d29;
                        dArray[i] = d28 * (d30 * d30 * d7 - 28.0 * d30 * d29 * d6 + 210.0 * d30 * d5 - 420.0 * d29 * d4 + 105.0) * Math.exp(d29 * d9);
                    }
                    break;
                }
                case 9: {
                    double d31 = -d8 / (d10 * d);
                    for (int i = 1; i < n3; ++i) {
                        double d32 = i * i;
                        double d33 = d32 * d32;
                        dArray[i] = d31 * (double)i * (d33 * d33 * d7 - 36.0 * d33 * d32 * d6 + 378.0 * d33 * d5 - 1260.0 * d32 * d4 + 945.0) * Math.exp(d32 * d9);
                    }
                    break;
                }
                case 10: {
                    double d34 = d8 / (d10 * d);
                    for (int i = 0; i < n3; ++i) {
                        double d35 = i * i;
                        double d36 = d35 * d35;
                        double d37 = d36 * d35;
                        dArray[i] = d34 * (d37 * d36 * d8 - 45.0 * d36 * d36 * d7 + 630.0 * d37 * d6 - 3150.0 * d36 * d5 + 4725.0 * d35 * d4 - 945.0) * Math.exp(d35 * d9);
                    }
                    break;
                }
            }
        }
        return dArray;
    }

    private void convolve(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray3.length - 1;
        int n2 = dArray2.length - 1;
        int n3 = n;
        int n4 = n;
        int n5 = n + n2;
        int n6 = n + n2;
        for (int i = 0; i < n; ++i) {
            dArray[--n3] = dArray[++n4];
            dArray[++n6] = dArray[--n5];
        }
        double d = dArray3[0] == 0.0 ? -1.0 : 1.0;
        n4 = 0;
        n5 = n;
        while (n4 <= n2) {
            double d2 = dArray[n5] * dArray3[0];
            int n7 = n5;
            int n8 = n5;
            for (int i = 1; i <= n; ++i) {
                d2 += (dArray[--n7] + d * dArray[++n8]) * dArray3[i];
            }
            dArray2[n4] = d2;
            ++n4;
            ++n5;
        }
    }

    private String info(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Smoothing";
                break;
            }
            case 1: {
                string = "First";
                break;
            }
            case 2: {
                string = "Second";
                break;
            }
            case 3: {
                string = "Third";
                break;
            }
            case 4: {
                string = "Fourth";
                break;
            }
            case 5: {
                string = "Fifth";
                break;
            }
            case 6: {
                string = "Sixth";
                break;
            }
            case 7: {
                string = "Seventh";
                break;
            }
            case 8: {
                string = "Eighth";
                break;
            }
            case 9: {
                string = "Nineth";
                break;
            }
            case 10: {
                string = "Tenth";
            }
        }
        if (n > 0) {
            string = string + "-order differentiation";
        }
        return string;
    }

    private void check(double d, int n, int n2, int n3) {
        this.messenger.log("Checking arguments");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Smoothing scale less than or equal to 0");
        }
        if (n < 0 || n > 10) {
            throw new IllegalArgumentException("Differentiation order out of range in x-dimension");
        }
        if (n2 < 0 || n2 > 10) {
            throw new IllegalArgumentException("Differentiation order out of range in y-dimension");
        }
        if (n3 < 0 || n3 > 10) {
            throw new IllegalArgumentException("Differentiation order out of range in z-dimension");
        }
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

