/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.feature.Differentiator;
import imagescience.image.Aspects;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;
import java.util.Vector;

public class Hessian {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    public final Differentiator differentiator = new Differentiator();
    private static final double TWOPI = Math.PI * 2;

    public Vector<Image> run(Image image, double d, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Hessian");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Smoothing scale less than or equal to 0");
        }
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        Aspects aspects = image.aspects();
        this.messenger.log("Element aspect ratios: (" + aspects.x + "," + aspects.y + "," + aspects.z + "," + aspects.t + "," + aspects.c + ")");
        if (aspects.x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (aspects.y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (aspects.z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        Image image2 = image instanceof FloatImage ? image : new FloatImage(image);
        Vector<Image> vector = null;
        String string = image.name();
        this.differentiator.messenger.log(this.messenger.log());
        this.differentiator.progressor.parent(this.progressor);
        if (dimensions.z == 1) {
            double[] dArray = new double[]{0.0, 0.32, 0.64, 0.96, 1.0};
            int n = 0;
            this.logus("Computing Hxx");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image3 = this.differentiator.run(image2.duplicate(), d, 2, 0, 0);
            this.logus("Computing Hxy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image4 = this.differentiator.run(image2.duplicate(), d, 1, 1, 0);
            this.logus("Computing Hyy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image5 = this.differentiator.run(image2, d, 0, 2, 0);
            this.logus("Computing eigenimages");
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.y);
            this.progressor.range(dArray[n], dArray[++n]);
            image3.axes(1);
            image4.axes(1);
            image5.axes(1);
            double[] dArray2 = new double[dimensions.x];
            double[] dArray3 = new double[dimensions.x];
            double[] dArray4 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.progressor.start();
            if (bl) {
                this.messenger.log("Comparing and storing absolute eigenvalues");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            image3.get(coordinates, dArray2);
                            image4.get(coordinates, dArray3);
                            image5.get(coordinates, dArray4);
                            for (int i = 0; i < dimensions.x; ++i) {
                                double d2;
                                double d3;
                                double d4;
                                double d5 = -(dArray2[i] + dArray4[i]);
                                double d6 = -0.5 * (d5 + (double)(d5 < 0.0 ? -1 : 1) * Math.sqrt(d5 * d5 - 4.0 * (d4 = dArray2[i] * dArray4[i] - dArray3[i] * dArray3[i])));
                                if (d6 == 0.0) {
                                    d3 = 0.0;
                                    d2 = 0.0;
                                } else {
                                    d3 = Math.abs(d6);
                                    d2 = Math.abs(d4 / d6);
                                }
                                if (d3 > d2) {
                                    dArray2[i] = d3;
                                    dArray4[i] = d2;
                                    continue;
                                }
                                dArray2[i] = d2;
                                dArray4[i] = d3;
                            }
                            image3.set(coordinates, dArray2);
                            image5.set(coordinates, dArray4);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
            } else {
                this.messenger.log("Comparing and storing actual eigenvalues");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            image3.get(coordinates, dArray2);
                            image4.get(coordinates, dArray3);
                            image5.get(coordinates, dArray4);
                            for (int i = 0; i < dimensions.x; ++i) {
                                double d7;
                                double d8;
                                double d9;
                                double d10 = -(dArray2[i] + dArray4[i]);
                                double d11 = -0.5 * (d10 + (double)(d10 < 0.0 ? -1 : 1) * Math.sqrt(d10 * d10 - 4.0 * (d9 = dArray2[i] * dArray4[i] - dArray3[i] * dArray3[i])));
                                if (d11 == 0.0) {
                                    d8 = 0.0;
                                    d7 = 0.0;
                                } else {
                                    d8 = d11;
                                    d7 = d9 / d11;
                                }
                                if (d8 > d7) {
                                    dArray2[i] = d8;
                                    dArray4[i] = d7;
                                    continue;
                                }
                                dArray2[i] = d7;
                                dArray4[i] = d8;
                            }
                            image3.set(coordinates, dArray2);
                            image5.set(coordinates, dArray4);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
            }
            this.progressor.stop();
            image3.name(string + " largest Hessian eigenvalues");
            image5.name(string + " smallest Hessian eigenvalues");
            image3.aspects(aspects.duplicate());
            image5.aspects(aspects.duplicate());
            vector = new Vector<Image>(2);
            vector.add(image3);
            vector.add(image5);
        } else {
            double[] dArray = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0};
            int n = 0;
            this.logus("Computing Hxx");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image6 = this.differentiator.run(image2.duplicate(), d, 2, 0, 0);
            this.logus("Computing Hxy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image7 = this.differentiator.run(image2.duplicate(), d, 1, 1, 0);
            this.logus("Computing Hxz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image8 = this.differentiator.run(image2.duplicate(), d, 1, 0, 1);
            this.logus("Computing Hyy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image9 = this.differentiator.run(image2.duplicate(), d, 0, 2, 0);
            this.logus("Computing Hyz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image10 = this.differentiator.run(image2.duplicate(), d, 0, 1, 1);
            this.logus("Computing Hzz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image11 = this.differentiator.run(image2, d, 0, 0, 2);
            this.logus("Computing eigenimages");
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
            this.progressor.range(dArray[n], dArray[++n]);
            image6.axes(1);
            image7.axes(1);
            image8.axes(1);
            image9.axes(1);
            image10.axes(1);
            image11.axes(1);
            double[] dArray5 = new double[dimensions.x];
            double[] dArray6 = new double[dimensions.x];
            double[] dArray7 = new double[dimensions.x];
            double[] dArray8 = new double[dimensions.x];
            double[] dArray9 = new double[dimensions.x];
            double[] dArray10 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.progressor.start();
            if (bl) {
                this.messenger.log("Comparing and storing absolute eigenvalues");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        while (coordinates.z < dimensions.z) {
                            coordinates.y = 0;
                            while (coordinates.y < dimensions.y) {
                                image6.get(coordinates, dArray5);
                                image7.get(coordinates, dArray6);
                                image8.get(coordinates, dArray7);
                                image9.get(coordinates, dArray8);
                                image10.get(coordinates, dArray9);
                                image11.get(coordinates, dArray10);
                                for (int i = 0; i < dimensions.x; ++i) {
                                    double d12;
                                    double d13;
                                    double d14;
                                    double d15;
                                    double d16;
                                    double d17 = dArray5[i];
                                    double d18 = dArray6[i];
                                    double d19 = dArray7[i];
                                    double d20 = dArray8[i];
                                    double d21 = dArray9[i];
                                    double d22 = dArray10[i];
                                    double d23 = -(d17 + d20 + d22);
                                    double d24 = d17 * d20 + d17 * d22 + d20 * d22 - d18 * d18 - d19 * d19 - d21 * d21;
                                    double d25 = d17 * (d21 * d21 - d20 * d22) + d20 * d19 * d19 + d22 * d18 * d18 - 2.0 * d18 * d19 * d21;
                                    double d26 = (d23 * d23 - 3.0 * d24) / 9.0;
                                    double d27 = (d23 * d23 * d23 - 4.5 * d23 * d24 + 13.5 * d25) / 27.0;
                                    double d28 = d26 > 0.0 ? Math.sqrt(d26) : 0.0;
                                    double d29 = d28 * d28 * d28;
                                    if (d29 == 0.0) {
                                        d16 = 0.0;
                                        d15 = 0.0;
                                        d14 = 0.0;
                                    } else {
                                        d13 = d27 / d29;
                                        d12 = d13 * d13 <= 1.0 ? Math.acos(d13) : Math.acos(d13 < 0.0 ? -1.0 : 1.0);
                                        d16 = Math.abs(-2.0 * d28 * Math.cos(d12 / 3.0) - d23 / 3.0);
                                        d15 = Math.abs(-2.0 * d28 * Math.cos((d12 + Math.PI * 2) / 3.0) - d23 / 3.0);
                                        d14 = Math.abs(-2.0 * d28 * Math.cos((d12 - Math.PI * 2) / 3.0) - d23 / 3.0);
                                    }
                                    if (d15 < d14) {
                                        d13 = d15;
                                        d15 = d14;
                                        d14 = d13;
                                    }
                                    if (d16 < d15) {
                                        d13 = d16;
                                        d16 = d15;
                                        d15 = d13;
                                        if (d15 < d14) {
                                            d12 = d15;
                                            d15 = d14;
                                            d14 = d12;
                                        }
                                    }
                                    dArray5[i] = d16;
                                    dArray8[i] = d15;
                                    dArray10[i] = d14;
                                }
                                image6.set(coordinates, dArray5);
                                image9.set(coordinates, dArray8);
                                image11.set(coordinates, dArray10);
                                this.progressor.step();
                                ++coordinates.y;
                            }
                            ++coordinates.z;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
            } else {
                this.messenger.log("Comparing and storing actual eigenvalues");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        while (coordinates.z < dimensions.z) {
                            coordinates.y = 0;
                            while (coordinates.y < dimensions.y) {
                                image6.get(coordinates, dArray5);
                                image7.get(coordinates, dArray6);
                                image8.get(coordinates, dArray7);
                                image9.get(coordinates, dArray8);
                                image10.get(coordinates, dArray9);
                                image11.get(coordinates, dArray10);
                                for (int i = 0; i < dimensions.x; ++i) {
                                    double d30;
                                    double d31;
                                    double d32;
                                    double d33;
                                    double d34;
                                    double d35 = dArray5[i];
                                    double d36 = dArray6[i];
                                    double d37 = dArray7[i];
                                    double d38 = dArray8[i];
                                    double d39 = dArray9[i];
                                    double d40 = dArray10[i];
                                    double d41 = -(d35 + d38 + d40);
                                    double d42 = d35 * d38 + d35 * d40 + d38 * d40 - d36 * d36 - d37 * d37 - d39 * d39;
                                    double d43 = d35 * (d39 * d39 - d38 * d40) + d38 * d37 * d37 + d40 * d36 * d36 - 2.0 * d36 * d37 * d39;
                                    double d44 = (d41 * d41 - 3.0 * d42) / 9.0;
                                    double d45 = (d41 * d41 * d41 - 4.5 * d41 * d42 + 13.5 * d43) / 27.0;
                                    double d46 = d44 > 0.0 ? Math.sqrt(d44) : 0.0;
                                    double d47 = d46 * d46 * d46;
                                    if (d47 == 0.0) {
                                        d34 = 0.0;
                                        d33 = 0.0;
                                        d32 = 0.0;
                                    } else {
                                        d31 = d45 / d47;
                                        d30 = d31 * d31 <= 1.0 ? Math.acos(d31) : Math.acos(d31 < 0.0 ? -1.0 : 1.0);
                                        d34 = -2.0 * d46 * Math.cos(d30 / 3.0) - d41 / 3.0;
                                        d33 = -2.0 * d46 * Math.cos((d30 + Math.PI * 2) / 3.0) - d41 / 3.0;
                                        d32 = -2.0 * d46 * Math.cos((d30 - Math.PI * 2) / 3.0) - d41 / 3.0;
                                    }
                                    if (d33 < d32) {
                                        d31 = d33;
                                        d33 = d32;
                                        d32 = d31;
                                    }
                                    if (d34 < d33) {
                                        d31 = d34;
                                        d34 = d33;
                                        d33 = d31;
                                        if (d33 < d32) {
                                            d30 = d33;
                                            d33 = d32;
                                            d32 = d30;
                                        }
                                    }
                                    dArray5[i] = d34;
                                    dArray8[i] = d33;
                                    dArray10[i] = d32;
                                }
                                image6.set(coordinates, dArray5);
                                image9.set(coordinates, dArray8);
                                image11.set(coordinates, dArray10);
                                this.progressor.step();
                                ++coordinates.y;
                            }
                            ++coordinates.z;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
            }
            this.progressor.stop();
            image6.name(string + " largest Hessian eigenvalues");
            image9.name(string + " middle Hessian eigenvalues");
            image11.name(string + " smallest Hessian eigenvalues");
            image6.aspects(aspects.duplicate());
            image9.aspects(aspects.duplicate());
            image11.aspects(aspects.duplicate());
            vector = new Vector(3);
            vector.add(image6);
            vector.add(image9);
            vector.add(image11);
        }
        timer.stop();
        return vector;
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

