/*
 * Decompiled with CFR 0.152.
 */
package imagescience.image;

import ij.ImagePlus;
import imagescience.image.Aspects;
import imagescience.image.Borders;
import imagescience.image.ByteImage;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.ShortImage;
import java.lang.reflect.Constructor;

public abstract class Image {
    final Dimensions dims;
    Aspects aspects = new Aspects();
    String name = "";
    int axes = 0;
    static int lastID = 0;
    final int thisID;

    Image(Dimensions dimensions) {
        this.dims = dimensions;
        this.thisID = ++lastID;
    }

    public abstract String type();

    public abstract Image border(Borders var1);

    public static Image create(Dimensions dimensions, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{dimensions.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{dimensions};
            return (Image)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Non-supported image type");
        }
        catch (Throwable throwable) {
            throw new UnknownError("Could not create new image");
        }
    }

    public static Image wrap(ImagePlus imagePlus) {
        Object[] objectArray = imagePlus.getImageStack().getImageArray();
        if (objectArray[0] instanceof byte[]) {
            return new ByteImage(imagePlus);
        }
        if (objectArray[0] instanceof short[]) {
            return new ShortImage(imagePlus);
        }
        if (objectArray[0] instanceof float[]) {
            return new FloatImage(imagePlus);
        }
        if (objectArray[0] instanceof int[]) {
            return new ColorImage(imagePlus);
        }
        throw new IllegalArgumentException("Non-supported data type");
    }

    public abstract ImagePlus imageplus();

    public int elements() {
        return this.dims.x * this.dims.y * this.dims.z * this.dims.t * this.dims.c;
    }

    public void aspects(Aspects aspects) {
        if (aspects == null) {
            throw new NullPointerException();
        }
        this.aspects = aspects;
    }

    public Aspects aspects() {
        return this.aspects;
    }

    public int id() {
        return this.thisID;
    }

    public abstract int memory();

    public Dimensions dimensions() {
        return this.dims;
    }

    public abstract Image duplicate();

    public double[] extrema() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            double d3 = dArray[i];
                            if (d3 < d) {
                                d = d3;
                            }
                            if (!(d3 > d2)) continue;
                            d2 = d3;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
        return new double[]{d, d2};
    }

    public double minimum() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        double d = Double.MAX_VALUE;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            if (!(dArray[i] < d)) continue;
                            d = dArray[i];
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
        return d;
    }

    public double maximum() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        double d = -1.7976931348623157E308;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            if (!(dArray[i] > d)) continue;
                            d = dArray[i];
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
        return d;
    }

    public void axes(int n) {
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException("Invalid (combination of) axes");
        }
        this.axes = n;
    }

    public int axes() {
        return this.axes;
    }

    public abstract double get(Coordinates var1);

    public abstract void get(Coordinates var1, float[] var2);

    public abstract void get(Coordinates var1, double[] var2);

    public abstract void get(Coordinates var1, float[][] var2);

    public abstract void get(Coordinates var1, double[][] var2);

    public abstract void get(Coordinates var1, float[][][] var2);

    public abstract void get(Coordinates var1, double[][][] var2);

    public abstract void get(Coordinates var1, float[][][][] var2);

    public abstract void get(Coordinates var1, double[][][][] var2);

    public abstract void get(Coordinates var1, float[][][][][] var2);

    public abstract void get(Coordinates var1, double[][][][][] var2);

    public abstract void set(double var1);

    public abstract void mirror(Borders var1);

    public abstract void set(Borders var1, double var2);

    public abstract void set(Coordinates var1, double var2);

    public abstract void set(Coordinates var1, float[] var2);

    public abstract void set(Coordinates var1, double[] var2);

    public abstract void set(Coordinates var1, float[][] var2);

    public abstract void set(Coordinates var1, double[][] var2);

    public abstract void set(Coordinates var1, float[][][] var2);

    public abstract void set(Coordinates var1, double[][][] var2);

    public abstract void set(Coordinates var1, float[][][][] var2);

    public abstract void set(Coordinates var1, double[][][][] var2);

    public abstract void set(Coordinates var1, float[][][][][] var2);

    public abstract void set(Coordinates var1, double[][][][][] var2);

    public void absolute() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            dArray[i] = Math.abs(dArray[i]);
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void add(double d) {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        int n2 = 0;
                        while (n2 < this.dims.x) {
                            int n3 = n2++;
                            dArray[n3] = dArray[n3] + d;
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void add(Image image) {
        if (!image.dimensions().equals(this.dims)) {
            throw new IllegalStateException("Unequal image dimensions");
        }
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        double[] dArray2 = new double[this.dims.x];
        int n = image.axes;
        image.axes = 1;
        int n2 = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        image.get(coordinates, dArray);
                        this.get(coordinates, dArray2);
                        for (int i = 0; i < this.dims.x; ++i) {
                            int n3 = i;
                            dArray2[n3] = dArray2[n3] + dArray[i];
                        }
                        this.set(coordinates, dArray2);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.axes = n;
        this.axes = n2;
    }

    public void subtract(double d) {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        int n2 = 0;
                        while (n2 < this.dims.x) {
                            int n3 = n2++;
                            dArray[n3] = dArray[n3] - d;
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void subtract(Image image) {
        if (!image.dimensions().equals(this.dims)) {
            throw new IllegalStateException("Unequal image dimensions");
        }
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        double[] dArray2 = new double[this.dims.x];
        int n = image.axes;
        image.axes = 1;
        int n2 = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        image.get(coordinates, dArray);
                        this.get(coordinates, dArray2);
                        for (int i = 0; i < this.dims.x; ++i) {
                            int n3 = i;
                            dArray2[n3] = dArray2[n3] - dArray[i];
                        }
                        this.set(coordinates, dArray2);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.axes = n;
        this.axes = n2;
    }

    public void multiply(double d) {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        int n2 = 0;
                        while (n2 < this.dims.x) {
                            int n3 = n2++;
                            dArray[n3] = dArray[n3] * d;
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void multiply(Image image) {
        if (!image.dimensions().equals(this.dims)) {
            throw new IllegalStateException("Unequal image dimensions");
        }
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        double[] dArray2 = new double[this.dims.x];
        int n = image.axes;
        image.axes = 1;
        int n2 = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        image.get(coordinates, dArray);
                        this.get(coordinates, dArray2);
                        for (int i = 0; i < this.dims.x; ++i) {
                            int n3 = i;
                            dArray2[n3] = dArray2[n3] * dArray[i];
                        }
                        this.set(coordinates, dArray2);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.axes = n;
        this.axes = n2;
    }

    public void divide(double d) {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        int n2 = 0;
                        while (n2 < this.dims.x) {
                            int n3 = n2++;
                            dArray[n3] = dArray[n3] / d;
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void divide(Image image) {
        if (!image.dimensions().equals(this.dims)) {
            throw new IllegalStateException("Unequal image dimensions");
        }
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        double[] dArray2 = new double[this.dims.x];
        int n = image.axes;
        image.axes = 1;
        int n2 = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        image.get(coordinates, dArray);
                        this.get(coordinates, dArray2);
                        for (int i = 0; i < this.dims.x; ++i) {
                            int n3 = i;
                            dArray2[n3] = dArray2[n3] / dArray[i];
                        }
                        this.set(coordinates, dArray2);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.axes = n;
        this.axes = n2;
    }

    public void square() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            int n2 = i;
                            dArray[n2] = dArray[n2] * dArray[i];
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void squareroot() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            dArray[i] = Math.sqrt(dArray[i]);
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void power(double d) {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            dArray[i] = Math.pow(dArray[i], d);
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void invert() {
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        double[] dArray2 = this.extrema();
        int n = this.axes;
        this.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        this.get(coordinates, dArray);
                        for (int i = 0; i < this.dims.x; ++i) {
                            dArray[i] = dArray2[1] - (dArray[i] - dArray2[0]);
                        }
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        this.axes = n;
    }

    public void name(String string) {
        this.name = string == null ? "" : string;
    }

    public String name() {
        return this.name;
    }
}

