/*
 * Decompiled with CFR 0.152.
 */
package imagescience.image;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import imagescience.image.Aspects;
import imagescience.image.Borders;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.utility.FMath;

public class ShortImage
extends Image {
    final short[][][][] elements;

    public ShortImage(Dimensions dimensions) {
        super(dimensions.duplicate());
        this.elements = new short[dimensions.c][dimensions.t][dimensions.z][dimensions.y * dimensions.x];
    }

    public ShortImage(ImagePlus imagePlus) {
        super(new Dimensions(imagePlus.getWidth(), imagePlus.getHeight(), imagePlus.getNSlices(), imagePlus.getNFrames(), imagePlus.getNChannels()));
        Calibration calibration = imagePlus.getCalibration();
        this.aspects = new Aspects(calibration.pixelWidth, calibration.pixelHeight, calibration.pixelDepth, calibration.frameInterval, 1.0);
        this.name = imagePlus.getTitle();
        Object[] objectArray = imagePlus.getImageStack().getImageArray();
        if (!(objectArray[0] instanceof short[])) {
            throw new IllegalArgumentException("Wrong input type");
        }
        this.elements = new short[this.dims.c][this.dims.t][this.dims.z][];
        for (int i = 0; i < this.dims.t; ++i) {
            for (int j = 0; j < this.dims.z; ++j) {
                for (int k = 0; k < this.dims.c; ++k) {
                    this.elements[k][i][j] = (short[])objectArray[i * this.dims.z * this.dims.c + j * this.dims.c + k];
                }
            }
        }
    }

    public ShortImage(Image image) {
        super(image.dimensions().duplicate());
        this.aspects = image.aspects().duplicate();
        this.elements = new short[this.dims.c][this.dims.t][this.dims.z][this.dims.y * this.dims.x];
        this.name = new String(image.name);
        Coordinates coordinates = new Coordinates();
        double[] dArray = new double[this.dims.x];
        int n = image.axes;
        this.axes = 1;
        image.axes = 1;
        coordinates.c = 0;
        while (coordinates.c < this.dims.c) {
            coordinates.t = 0;
            while (coordinates.t < this.dims.t) {
                coordinates.z = 0;
                while (coordinates.z < this.dims.z) {
                    coordinates.y = 0;
                    while (coordinates.y < this.dims.y) {
                        image.get(coordinates, dArray);
                        this.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.axes = this.axes = n;
    }

    public ShortImage(Image image, Borders borders) {
        super(new Dimensions(image.dimensions().x + 2 * borders.x, image.dimensions().y + 2 * borders.y, image.dimensions().z + 2 * borders.z, image.dimensions().t + 2 * borders.t, image.dimensions().c + 2 * borders.c));
        this.aspects = image.aspects().duplicate();
        this.elements = new short[this.dims.c][this.dims.t][this.dims.z][this.dims.y * this.dims.x];
        this.name = new String(image.name);
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[dimensions.x];
        int n = image.axes;
        this.axes = 1;
        image.axes = 1;
        coordinates2.x = borders.x;
        coordinates.c = 0;
        coordinates2.c = borders.c;
        while (coordinates.c < dimensions.c) {
            coordinates.t = 0;
            coordinates2.t = borders.t;
            while (coordinates.t < dimensions.t) {
                coordinates.z = 0;
                coordinates2.z = borders.z;
                while (coordinates.z < dimensions.z) {
                    coordinates.y = 0;
                    coordinates2.y = borders.y;
                    while (coordinates.y < dimensions.y) {
                        image.get(coordinates, dArray);
                        this.set(coordinates2, dArray);
                        ++coordinates.y;
                        ++coordinates2.y;
                    }
                    ++coordinates.z;
                    ++coordinates2.z;
                }
                ++coordinates.t;
                ++coordinates2.t;
            }
            ++coordinates.c;
            ++coordinates2.c;
        }
        image.axes = this.axes = n;
    }

    @Override
    public Image border(Borders borders) {
        return new ShortImage(this, borders);
    }

    @Override
    public ImagePlus imageplus() {
        ImageStack imageStack = new ImageStack(this.dims.x, this.dims.y);
        for (int i = 0; i < this.dims.t; ++i) {
            for (int j = 0; j < this.dims.z; ++j) {
                for (int k = 0; k < this.dims.c; ++k) {
                    imageStack.addSlice("", (Object)this.elements[k][i][j]);
                }
            }
        }
        FloatProcessor floatProcessor = new FloatProcessor(2, 1);
        double[] dArray = this.extrema();
        floatProcessor.putPixelValue(0, 0, dArray[0]);
        floatProcessor.putPixelValue(1, 0, dArray[1]);
        floatProcessor.resetMinAndMax();
        imageStack.update((ImageProcessor)floatProcessor);
        Calibration calibration = new Calibration();
        calibration.pixelWidth = this.aspects.x;
        calibration.pixelHeight = this.aspects.y;
        calibration.pixelDepth = this.aspects.z;
        calibration.frameInterval = this.aspects.t;
        ImagePlus imagePlus = new ImagePlus(this.name, imageStack);
        imagePlus.setDimensions(this.dims.c, this.dims.z, this.dims.t);
        imagePlus.setCalibration(calibration);
        return imagePlus;
    }

    @Override
    public String type() {
        return "imagescience.image.ShortImage";
    }

    @Override
    public int memory() {
        return 2 * this.elements();
    }

    @Override
    public Image duplicate() {
        ShortImage shortImage = new ShortImage(this.dims);
        shortImage.aspects = this.aspects.duplicate();
        shortImage.name = new String(this.name);
        shortImage.axes = this.axes;
        int n = this.dims.x * this.dims.y;
        for (int i = 0; i < this.dims.c; ++i) {
            for (int j = 0; j < this.dims.t; ++j) {
                for (int k = 0; k < this.dims.z; ++k) {
                    short[] sArray = this.elements[i][j][k];
                    short[] sArray2 = shortImage.elements[i][j][k];
                    for (int i2 = 0; i2 < n; ++i2) {
                        sArray2[i2] = sArray[i2];
                    }
                }
            }
        }
        return shortImage;
    }

    @Override
    public double get(Coordinates coordinates) {
        return 0xFFFF & this.elements[coordinates.c][coordinates.t][coordinates.z][this.dims.x * coordinates.y + coordinates.x];
    }

    @Override
    public void get(Coordinates coordinates, double[] dArray) {
        switch (this.axes) {
            case 1: {
                int n;
                int n2 = 0;
                int n3 = coordinates.x;
                if (n3 < 0) {
                    n3 = 0;
                    n2 = -coordinates.x;
                }
                if ((n = coordinates.x + dArray.length) > this.dims.x) {
                    n = this.dims.x;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n4 = n3;
                int n5 = coordinates.y * this.dims.x + n3;
                int n6 = n2;
                while (n4 < n) {
                    dArray[n6] = 0xFFFF & sArray[n5];
                    ++n4;
                    ++n5;
                    ++n6;
                }
                break;
            }
            case 2: {
                int n;
                int n7 = 0;
                int n8 = coordinates.y;
                if (n8 < 0) {
                    n8 = 0;
                    n7 = -coordinates.y;
                }
                if ((n = coordinates.y + dArray.length) > this.dims.y) {
                    n = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n9 = n8;
                int n10 = n8 * this.dims.x + coordinates.x;
                int n11 = n7;
                while (n9 < n) {
                    dArray[n11] = 0xFFFF & sArray[n10];
                    ++n9;
                    n10 += this.dims.x;
                    ++n11;
                }
                break;
            }
            case 4: {
                int n;
                int n12 = 0;
                int n13 = coordinates.z;
                if (n13 < 0) {
                    n13 = 0;
                    n12 = -coordinates.z;
                }
                if ((n = coordinates.z + dArray.length) > this.dims.z) {
                    n = this.dims.z;
                }
                int n14 = coordinates.y * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n15 = n13;
                int n16 = n12;
                while (n15 < n) {
                    dArray[n16] = 0xFFFF & sArray[n15][n14];
                    ++n15;
                    ++n16;
                }
                break;
            }
            case 8: {
                int n;
                int n17 = 0;
                int n18 = coordinates.t;
                if (n18 < 0) {
                    n18 = 0;
                    n17 = -coordinates.t;
                }
                if ((n = coordinates.t + dArray.length) > this.dims.t) {
                    n = this.dims.t;
                }
                int n19 = coordinates.y * this.dims.x + coordinates.x;
                int n20 = n18;
                int n21 = n17;
                while (n20 < n) {
                    dArray[n21] = 0xFFFF & this.elements[coordinates.c][n20][coordinates.z][n19];
                    ++n20;
                    ++n21;
                }
                break;
            }
            case 16: {
                int n;
                int n22 = 0;
                int n23 = coordinates.c;
                if (n23 < 0) {
                    n23 = 0;
                    n22 = -coordinates.c;
                }
                if ((n = coordinates.c + dArray.length) > this.dims.c) {
                    n = this.dims.c;
                }
                int n24 = coordinates.y * this.dims.x + coordinates.x;
                int n25 = n23;
                int n26 = n22;
                while (n25 < n) {
                    dArray[n26] = 0xFFFF & this.elements[n25][coordinates.t][coordinates.z][n24];
                    ++n25;
                    ++n26;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, double[][] dArray) {
        switch (this.axes) {
            case 3: {
                int n = 0;
                int n2 = 0;
                int n3 = coordinates.x;
                int n4 = coordinates.y;
                if (n3 < 0) {
                    n3 = 0;
                    n = -coordinates.x;
                }
                if (n4 < 0) {
                    n4 = 0;
                    n2 = -coordinates.y;
                }
                int n5 = coordinates.x + dArray[0].length;
                int n6 = coordinates.y + dArray.length;
                if (n5 > this.dims.x) {
                    n5 = this.dims.x;
                }
                if (n6 > this.dims.y) {
                    n6 = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n7 = n4;
                int n8 = n4 * this.dims.x + n3;
                int n9 = n2;
                while (n7 < n6) {
                    int n10 = n3;
                    int n11 = n8;
                    int n12 = n;
                    while (n10 < n5) {
                        dArray[n9][n12] = 0xFFFF & sArray[n11];
                        ++n10;
                        ++n11;
                        ++n12;
                    }
                    ++n7;
                    n8 += this.dims.x;
                    ++n9;
                }
                break;
            }
            case 5: {
                int n = 0;
                int n13 = 0;
                int n14 = coordinates.x;
                int n15 = coordinates.z;
                if (n14 < 0) {
                    n14 = 0;
                    n = -coordinates.x;
                }
                if (n15 < 0) {
                    n15 = 0;
                    n13 = -coordinates.z;
                }
                int n16 = coordinates.x + dArray[0].length;
                int n17 = coordinates.z + dArray.length;
                if (n16 > this.dims.x) {
                    n16 = this.dims.x;
                }
                if (n17 > this.dims.z) {
                    n17 = this.dims.z;
                }
                int n18 = coordinates.y * this.dims.x + n14;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n19 = n15;
                int n20 = n13;
                while (n19 < n17) {
                    int n21 = n14;
                    int n22 = n18;
                    int n23 = n;
                    while (n21 < n16) {
                        dArray[n20][n23] = 0xFFFF & sArray[n19][n22];
                        ++n21;
                        ++n22;
                        ++n23;
                    }
                    ++n19;
                    ++n20;
                }
                break;
            }
            case 6: {
                int n = 0;
                int n24 = 0;
                int n25 = coordinates.y;
                int n26 = coordinates.z;
                if (n25 < 0) {
                    n25 = 0;
                    n = -coordinates.y;
                }
                if (n26 < 0) {
                    n26 = 0;
                    n24 = -coordinates.z;
                }
                int n27 = coordinates.y + dArray[0].length;
                int n28 = coordinates.z + dArray.length;
                if (n27 > this.dims.y) {
                    n27 = this.dims.y;
                }
                if (n28 > this.dims.z) {
                    n28 = this.dims.z;
                }
                int n29 = n25 * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n30 = n26;
                int n31 = n24;
                while (n30 < n28) {
                    int n32 = n25;
                    int n33 = n29;
                    int n34 = n;
                    while (n32 < n27) {
                        dArray[n31][n34] = 0xFFFF & sArray[n30][n33];
                        ++n32;
                        n33 += this.dims.x;
                        ++n34;
                    }
                    ++n30;
                    ++n31;
                }
                break;
            }
            case 9: {
                int n = 0;
                int n35 = 0;
                int n36 = coordinates.x;
                int n37 = coordinates.t;
                if (n36 < 0) {
                    n36 = 0;
                    n = -coordinates.x;
                }
                if (n37 < 0) {
                    n37 = 0;
                    n35 = -coordinates.t;
                }
                int n38 = coordinates.x + dArray[0].length;
                int n39 = coordinates.t + dArray.length;
                if (n38 > this.dims.x) {
                    n38 = this.dims.x;
                }
                if (n39 > this.dims.t) {
                    n39 = this.dims.t;
                }
                int n40 = coordinates.y * this.dims.x + n36;
                int n41 = n37;
                int n42 = n35;
                while (n41 < n39) {
                    int n43 = n36;
                    int n44 = n40;
                    int n45 = n;
                    while (n43 < n38) {
                        dArray[n42][n45] = 0xFFFF & this.elements[coordinates.c][n41][coordinates.z][n44];
                        ++n43;
                        ++n44;
                        ++n45;
                    }
                    ++n41;
                    ++n42;
                }
                break;
            }
            case 10: {
                int n = 0;
                int n46 = 0;
                int n47 = coordinates.y;
                int n48 = coordinates.t;
                if (n47 < 0) {
                    n47 = 0;
                    n = -coordinates.y;
                }
                if (n48 < 0) {
                    n48 = 0;
                    n46 = -coordinates.t;
                }
                int n49 = coordinates.y + dArray[0].length;
                int n50 = coordinates.t + dArray.length;
                if (n49 > this.dims.y) {
                    n49 = this.dims.y;
                }
                if (n50 > this.dims.t) {
                    n50 = this.dims.t;
                }
                int n51 = n47 * this.dims.x + coordinates.x;
                int n52 = n48;
                int n53 = n46;
                while (n52 < n50) {
                    int n54 = n47;
                    int n55 = n51;
                    int n56 = n;
                    while (n54 < n49) {
                        dArray[n53][n56] = 0xFFFF & this.elements[coordinates.c][n52][coordinates.z][n55];
                        ++n54;
                        n55 += this.dims.x;
                        ++n56;
                    }
                    ++n52;
                    ++n53;
                }
                break;
            }
            case 12: {
                int n = 0;
                int n57 = 0;
                int n58 = coordinates.z;
                int n59 = coordinates.t;
                if (n58 < 0) {
                    n58 = 0;
                    n = -coordinates.z;
                }
                if (n59 < 0) {
                    n59 = 0;
                    n57 = -coordinates.t;
                }
                int n60 = coordinates.z + dArray[0].length;
                int n61 = coordinates.t + dArray.length;
                if (n60 > this.dims.z) {
                    n60 = this.dims.z;
                }
                if (n61 > this.dims.t) {
                    n61 = this.dims.t;
                }
                int n62 = coordinates.y * this.dims.x + coordinates.x;
                int n63 = n59;
                int n64 = n57;
                while (n63 < n61) {
                    int n65 = n58;
                    int n66 = n;
                    while (n65 < n60) {
                        dArray[n64][n66] = 0xFFFF & this.elements[coordinates.c][n63][n65][n62];
                        ++n65;
                        ++n66;
                    }
                    ++n63;
                    ++n64;
                }
                break;
            }
            case 17: {
                int n = 0;
                int n67 = 0;
                int n68 = coordinates.x;
                int n69 = coordinates.c;
                if (n68 < 0) {
                    n68 = 0;
                    n = -coordinates.x;
                }
                if (n69 < 0) {
                    n69 = 0;
                    n67 = -coordinates.c;
                }
                int n70 = coordinates.x + dArray[0].length;
                int n71 = coordinates.c + dArray.length;
                if (n70 > this.dims.x) {
                    n70 = this.dims.x;
                }
                if (n71 > this.dims.c) {
                    n71 = this.dims.c;
                }
                int n72 = coordinates.y * this.dims.x + n68;
                int n73 = n69;
                int n74 = n67;
                while (n73 < n71) {
                    int n75 = n68;
                    int n76 = n72;
                    int n77 = n;
                    while (n75 < n70) {
                        dArray[n74][n77] = 0xFFFF & this.elements[n73][coordinates.t][coordinates.z][n76];
                        ++n75;
                        ++n76;
                        ++n77;
                    }
                    ++n73;
                    ++n74;
                }
                break;
            }
            case 18: {
                int n = 0;
                int n78 = 0;
                int n79 = coordinates.y;
                int n80 = coordinates.c;
                if (n79 < 0) {
                    n79 = 0;
                    n = -coordinates.y;
                }
                if (n80 < 0) {
                    n80 = 0;
                    n78 = -coordinates.c;
                }
                int n81 = coordinates.y + dArray[0].length;
                int n82 = coordinates.c + dArray.length;
                if (n81 > this.dims.y) {
                    n81 = this.dims.y;
                }
                if (n82 > this.dims.c) {
                    n82 = this.dims.c;
                }
                int n83 = n79 * this.dims.x + coordinates.x;
                int n84 = n80;
                int n85 = n78;
                while (n84 < n82) {
                    int n86 = n79;
                    int n87 = n83;
                    int n88 = n;
                    while (n86 < n81) {
                        dArray[n85][n88] = 0xFFFF & this.elements[n84][coordinates.t][coordinates.z][n87];
                        ++n86;
                        n87 += this.dims.x;
                        ++n88;
                    }
                    ++n84;
                    ++n85;
                }
                break;
            }
            case 20: {
                int n = 0;
                int n89 = 0;
                int n90 = coordinates.z;
                int n91 = coordinates.c;
                if (n90 < 0) {
                    n90 = 0;
                    n = -coordinates.z;
                }
                if (n91 < 0) {
                    n91 = 0;
                    n89 = -coordinates.c;
                }
                int n92 = coordinates.z + dArray[0].length;
                int n93 = coordinates.c + dArray.length;
                if (n92 > this.dims.z) {
                    n92 = this.dims.z;
                }
                if (n93 > this.dims.c) {
                    n93 = this.dims.c;
                }
                int n94 = coordinates.y * this.dims.x + coordinates.x;
                int n95 = n91;
                int n96 = n89;
                while (n95 < n93) {
                    int n97 = n90;
                    int n98 = n;
                    while (n97 < n92) {
                        dArray[n96][n98] = 0xFFFF & this.elements[n95][coordinates.t][n97][n94];
                        ++n97;
                        ++n98;
                    }
                    ++n95;
                    ++n96;
                }
                break;
            }
            case 24: {
                int n = 0;
                int n99 = 0;
                int n100 = coordinates.t;
                int n101 = coordinates.c;
                if (n100 < 0) {
                    n100 = 0;
                    n = -coordinates.t;
                }
                if (n101 < 0) {
                    n101 = 0;
                    n99 = -coordinates.c;
                }
                int n102 = coordinates.t + dArray[0].length;
                int n103 = coordinates.c + dArray.length;
                if (n102 > this.dims.t) {
                    n102 = this.dims.t;
                }
                if (n103 > this.dims.c) {
                    n103 = this.dims.c;
                }
                int n104 = coordinates.y * this.dims.x + coordinates.x;
                int n105 = n101;
                int n106 = n99;
                while (n105 < n103) {
                    int n107 = n100;
                    int n108 = n;
                    while (n107 < n102) {
                        dArray[n106][n108] = 0xFFFF & this.elements[n105][n107][coordinates.z][n104];
                        ++n107;
                        ++n108;
                    }
                    ++n105;
                    ++n106;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, double[][][] dArray) {
        switch (this.axes) {
            case 7: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = coordinates.x;
                int n5 = coordinates.y;
                int n6 = coordinates.z;
                if (n4 < 0) {
                    n4 = 0;
                    n = -coordinates.x;
                }
                if (n5 < 0) {
                    n5 = 0;
                    n2 = -coordinates.y;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n3 = -coordinates.z;
                }
                int n7 = coordinates.x + dArray[0][0].length;
                int n8 = coordinates.y + dArray[0].length;
                int n9 = coordinates.z + dArray.length;
                if (n7 > this.dims.x) {
                    n7 = this.dims.x;
                }
                if (n8 > this.dims.y) {
                    n8 = this.dims.y;
                }
                if (n9 > this.dims.z) {
                    n9 = this.dims.z;
                }
                int n10 = n5 * this.dims.x + n4;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n11 = n6;
                int n12 = n3;
                while (n11 < n9) {
                    int n13 = n5;
                    int n14 = n10;
                    int n15 = n2;
                    while (n13 < n8) {
                        int n16 = n4;
                        int n17 = n14;
                        int n18 = n;
                        while (n16 < n7) {
                            dArray[n12][n15][n18] = 0xFFFF & sArray[n11][n17];
                            ++n16;
                            ++n17;
                            ++n18;
                        }
                        ++n13;
                        n14 += this.dims.x;
                        ++n15;
                    }
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 11: {
                int n = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = coordinates.x;
                int n22 = coordinates.y;
                int n23 = coordinates.t;
                if (n21 < 0) {
                    n21 = 0;
                    n = -coordinates.x;
                }
                if (n22 < 0) {
                    n22 = 0;
                    n19 = -coordinates.y;
                }
                if (n23 < 0) {
                    n23 = 0;
                    n20 = -coordinates.t;
                }
                int n24 = coordinates.x + dArray[0][0].length;
                int n25 = coordinates.y + dArray[0].length;
                int n26 = coordinates.t + dArray.length;
                if (n24 > this.dims.x) {
                    n24 = this.dims.x;
                }
                if (n25 > this.dims.y) {
                    n25 = this.dims.y;
                }
                if (n26 > this.dims.t) {
                    n26 = this.dims.t;
                }
                int n27 = n22 * this.dims.x + n21;
                int n28 = n23;
                int n29 = n20;
                while (n28 < n26) {
                    int n30 = n22;
                    int n31 = n27;
                    int n32 = n19;
                    while (n30 < n25) {
                        int n33 = n21;
                        int n34 = n31;
                        int n35 = n;
                        while (n33 < n24) {
                            dArray[n29][n32][n35] = 0xFFFF & this.elements[coordinates.c][n28][coordinates.z][n34];
                            ++n33;
                            ++n34;
                            ++n35;
                        }
                        ++n30;
                        n31 += this.dims.x;
                        ++n32;
                    }
                    ++n28;
                    ++n29;
                }
                break;
            }
            case 19: {
                int n = 0;
                int n36 = 0;
                int n37 = 0;
                int n38 = coordinates.x;
                int n39 = coordinates.y;
                int n40 = coordinates.c;
                if (n38 < 0) {
                    n38 = 0;
                    n = -coordinates.x;
                }
                if (n39 < 0) {
                    n39 = 0;
                    n36 = -coordinates.y;
                }
                if (n40 < 0) {
                    n40 = 0;
                    n37 = -coordinates.c;
                }
                int n41 = coordinates.x + dArray[0][0].length;
                int n42 = coordinates.y + dArray[0].length;
                int n43 = coordinates.c + dArray.length;
                if (n41 > this.dims.x) {
                    n41 = this.dims.x;
                }
                if (n42 > this.dims.y) {
                    n42 = this.dims.y;
                }
                if (n43 > this.dims.c) {
                    n43 = this.dims.c;
                }
                int n44 = n39 * this.dims.x + n38;
                int n45 = n40;
                int n46 = n37;
                while (n45 < n43) {
                    int n47 = n39;
                    int n48 = n44;
                    int n49 = n36;
                    while (n47 < n42) {
                        int n50 = n38;
                        int n51 = n48;
                        int n52 = n;
                        while (n50 < n41) {
                            dArray[n46][n49][n52] = 0xFFFF & this.elements[n45][coordinates.t][coordinates.z][n51];
                            ++n50;
                            ++n51;
                            ++n52;
                        }
                        ++n47;
                        n48 += this.dims.x;
                        ++n49;
                    }
                    ++n45;
                    ++n46;
                }
                break;
            }
            case 13: {
                int n = 0;
                int n53 = 0;
                int n54 = 0;
                int n55 = coordinates.x;
                int n56 = coordinates.z;
                int n57 = coordinates.t;
                if (n55 < 0) {
                    n55 = 0;
                    n = -coordinates.x;
                }
                if (n56 < 0) {
                    n56 = 0;
                    n53 = -coordinates.z;
                }
                if (n57 < 0) {
                    n57 = 0;
                    n54 = -coordinates.t;
                }
                int n58 = coordinates.x + dArray[0][0].length;
                int n59 = coordinates.z + dArray[0].length;
                int n60 = coordinates.t + dArray.length;
                if (n58 > this.dims.x) {
                    n58 = this.dims.x;
                }
                if (n59 > this.dims.z) {
                    n59 = this.dims.z;
                }
                if (n60 > this.dims.t) {
                    n60 = this.dims.t;
                }
                int n61 = coordinates.y * this.dims.x + n55;
                int n62 = n57;
                int n63 = n54;
                while (n62 < n60) {
                    int n64 = n56;
                    int n65 = n53;
                    while (n64 < n59) {
                        int n66 = n55;
                        int n67 = n61;
                        int n68 = n;
                        while (n66 < n58) {
                            dArray[n63][n65][n68] = 0xFFFF & this.elements[coordinates.c][n62][n64][n67];
                            ++n66;
                            ++n67;
                            ++n68;
                        }
                        ++n64;
                        ++n65;
                    }
                    ++n62;
                    ++n63;
                }
                break;
            }
            case 21: {
                int n = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n69 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n70 = -coordinates.c;
                }
                int n74 = coordinates.x + dArray[0][0].length;
                int n75 = coordinates.z + dArray[0].length;
                int n76 = coordinates.c + dArray.length;
                if (n74 > this.dims.x) {
                    n74 = this.dims.x;
                }
                if (n75 > this.dims.z) {
                    n75 = this.dims.z;
                }
                if (n76 > this.dims.c) {
                    n76 = this.dims.c;
                }
                int n77 = coordinates.y * this.dims.x + n71;
                int n78 = n73;
                int n79 = n70;
                while (n78 < n76) {
                    int n80 = n72;
                    int n81 = n69;
                    while (n80 < n75) {
                        int n82 = n71;
                        int n83 = n77;
                        int n84 = n;
                        while (n82 < n74) {
                            dArray[n79][n81][n84] = 0xFFFF & this.elements[n78][coordinates.t][n80][n83];
                            ++n82;
                            ++n83;
                            ++n84;
                        }
                        ++n80;
                        ++n81;
                    }
                    ++n78;
                    ++n79;
                }
                break;
            }
            case 25: {
                int n = 0;
                int n85 = 0;
                int n86 = 0;
                int n87 = coordinates.x;
                int n88 = coordinates.t;
                int n89 = coordinates.c;
                if (n87 < 0) {
                    n87 = 0;
                    n = -coordinates.x;
                }
                if (n88 < 0) {
                    n88 = 0;
                    n85 = -coordinates.t;
                }
                if (n89 < 0) {
                    n89 = 0;
                    n86 = -coordinates.c;
                }
                int n90 = coordinates.x + dArray[0][0].length;
                int n91 = coordinates.t + dArray[0].length;
                int n92 = coordinates.c + dArray.length;
                if (n90 > this.dims.x) {
                    n90 = this.dims.x;
                }
                if (n91 > this.dims.t) {
                    n91 = this.dims.t;
                }
                if (n92 > this.dims.c) {
                    n92 = this.dims.c;
                }
                int n93 = coordinates.y * this.dims.x + n87;
                int n94 = n89;
                int n95 = n86;
                while (n94 < n92) {
                    int n96 = n88;
                    int n97 = n85;
                    while (n96 < n91) {
                        int n98 = n87;
                        int n99 = n93;
                        int n100 = n;
                        while (n98 < n90) {
                            dArray[n95][n97][n100] = 0xFFFF & this.elements[n94][n96][coordinates.z][n99];
                            ++n98;
                            ++n99;
                            ++n100;
                        }
                        ++n96;
                        ++n97;
                    }
                    ++n94;
                    ++n95;
                }
                break;
            }
            case 14: {
                int n = 0;
                int n101 = 0;
                int n102 = 0;
                int n103 = coordinates.y;
                int n104 = coordinates.z;
                int n105 = coordinates.t;
                if (n103 < 0) {
                    n103 = 0;
                    n = -coordinates.y;
                }
                if (n104 < 0) {
                    n104 = 0;
                    n101 = -coordinates.z;
                }
                if (n105 < 0) {
                    n105 = 0;
                    n102 = -coordinates.t;
                }
                int n106 = coordinates.y + dArray[0][0].length;
                int n107 = coordinates.z + dArray[0].length;
                int n108 = coordinates.t + dArray.length;
                if (n106 > this.dims.y) {
                    n106 = this.dims.y;
                }
                if (n107 > this.dims.z) {
                    n107 = this.dims.z;
                }
                if (n108 > this.dims.t) {
                    n108 = this.dims.t;
                }
                int n109 = n103 * this.dims.x + coordinates.x;
                int n110 = n105;
                int n111 = n102;
                while (n110 < n108) {
                    int n112 = n104;
                    int n113 = n101;
                    while (n112 < n107) {
                        int n114 = n103;
                        int n115 = n109;
                        int n116 = n;
                        while (n114 < n106) {
                            dArray[n111][n113][n116] = 0xFFFF & this.elements[coordinates.c][n110][n112][n115];
                            ++n114;
                            n115 += this.dims.x;
                            ++n116;
                        }
                        ++n112;
                        ++n113;
                    }
                    ++n110;
                    ++n111;
                }
                break;
            }
            case 22: {
                int n = 0;
                int n117 = 0;
                int n118 = 0;
                int n119 = coordinates.y;
                int n120 = coordinates.z;
                int n121 = coordinates.c;
                if (n119 < 0) {
                    n119 = 0;
                    n = -coordinates.y;
                }
                if (n120 < 0) {
                    n120 = 0;
                    n117 = -coordinates.z;
                }
                if (n121 < 0) {
                    n121 = 0;
                    n118 = -coordinates.c;
                }
                int n122 = coordinates.y + dArray[0][0].length;
                int n123 = coordinates.z + dArray[0].length;
                int n124 = coordinates.c + dArray.length;
                if (n122 > this.dims.y) {
                    n122 = this.dims.y;
                }
                if (n123 > this.dims.z) {
                    n123 = this.dims.z;
                }
                if (n124 > this.dims.c) {
                    n124 = this.dims.c;
                }
                int n125 = n119 * this.dims.x + coordinates.x;
                int n126 = n121;
                int n127 = n118;
                while (n126 < n124) {
                    int n128 = n120;
                    int n129 = n117;
                    while (n128 < n123) {
                        int n130 = n119;
                        int n131 = n125;
                        int n132 = n;
                        while (n130 < n122) {
                            dArray[n127][n129][n132] = 0xFFFF & this.elements[n126][coordinates.t][n128][n131];
                            ++n130;
                            n131 += this.dims.x;
                            ++n132;
                        }
                        ++n128;
                        ++n129;
                    }
                    ++n126;
                    ++n127;
                }
                break;
            }
            case 26: {
                int n = 0;
                int n133 = 0;
                int n134 = 0;
                int n135 = coordinates.y;
                int n136 = coordinates.t;
                int n137 = coordinates.c;
                if (n135 < 0) {
                    n135 = 0;
                    n = -coordinates.y;
                }
                if (n136 < 0) {
                    n136 = 0;
                    n133 = -coordinates.t;
                }
                if (n137 < 0) {
                    n137 = 0;
                    n134 = -coordinates.c;
                }
                int n138 = coordinates.y + dArray[0][0].length;
                int n139 = coordinates.t + dArray[0].length;
                int n140 = coordinates.c + dArray.length;
                if (n138 > this.dims.y) {
                    n138 = this.dims.y;
                }
                if (n139 > this.dims.t) {
                    n139 = this.dims.t;
                }
                if (n140 > this.dims.c) {
                    n140 = this.dims.c;
                }
                int n141 = n135 * this.dims.x + coordinates.x;
                int n142 = n137;
                int n143 = n134;
                while (n142 < n140) {
                    int n144 = n136;
                    int n145 = n133;
                    while (n144 < n139) {
                        int n146 = n135;
                        int n147 = n141;
                        int n148 = n;
                        while (n146 < n138) {
                            dArray[n143][n145][n148] = 0xFFFF & this.elements[n142][n144][coordinates.z][n147];
                            ++n146;
                            n147 += this.dims.x;
                            ++n148;
                        }
                        ++n144;
                        ++n145;
                    }
                    ++n142;
                    ++n143;
                }
                break;
            }
            case 28: {
                int n = 0;
                int n149 = 0;
                int n150 = 0;
                int n151 = coordinates.z;
                int n152 = coordinates.t;
                int n153 = coordinates.c;
                if (n151 < 0) {
                    n151 = 0;
                    n = -coordinates.z;
                }
                if (n152 < 0) {
                    n152 = 0;
                    n149 = -coordinates.t;
                }
                if (n153 < 0) {
                    n153 = 0;
                    n150 = -coordinates.c;
                }
                int n154 = coordinates.z + dArray[0][0].length;
                int n155 = coordinates.t + dArray[0].length;
                int n156 = coordinates.c + dArray.length;
                if (n154 > this.dims.z) {
                    n154 = this.dims.z;
                }
                if (n155 > this.dims.t) {
                    n155 = this.dims.t;
                }
                if (n156 > this.dims.c) {
                    n156 = this.dims.c;
                }
                int n157 = coordinates.y * this.dims.x + coordinates.x;
                int n158 = n153;
                int n159 = n150;
                while (n158 < n156) {
                    int n160 = n152;
                    int n161 = n149;
                    while (n160 < n155) {
                        int n162 = n151;
                        int n163 = n;
                        while (n162 < n154) {
                            dArray[n159][n161][n163] = 0xFFFF & this.elements[n158][n160][n162][n157];
                            ++n162;
                            ++n163;
                        }
                        ++n160;
                        ++n161;
                    }
                    ++n158;
                    ++n159;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, double[][][][] dArray) {
        switch (this.axes) {
            case 15: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = coordinates.x;
                int n6 = coordinates.y;
                int n7 = coordinates.z;
                int n8 = coordinates.t;
                if (n5 < 0) {
                    n5 = 0;
                    n = -coordinates.x;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n2 = -coordinates.y;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n3 = -coordinates.z;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n4 = -coordinates.t;
                }
                int n9 = coordinates.x + dArray[0][0][0].length;
                int n10 = coordinates.y + dArray[0][0].length;
                int n11 = coordinates.z + dArray[0].length;
                int n12 = coordinates.t + dArray.length;
                if (n9 > this.dims.x) {
                    n9 = this.dims.x;
                }
                if (n10 > this.dims.y) {
                    n10 = this.dims.y;
                }
                if (n11 > this.dims.z) {
                    n11 = this.dims.z;
                }
                if (n12 > this.dims.t) {
                    n12 = this.dims.t;
                }
                int n13 = n6 * this.dims.x + n5;
                int n14 = n8;
                int n15 = n4;
                while (n14 < n12) {
                    int n16 = n7;
                    int n17 = n3;
                    while (n16 < n11) {
                        int n18 = n6;
                        int n19 = n13;
                        int n20 = n2;
                        while (n18 < n10) {
                            int n21 = n5;
                            int n22 = n19;
                            int n23 = n;
                            while (n21 < n9) {
                                dArray[n15][n17][n20][n23] = 0xFFFF & this.elements[coordinates.c][n14][n16][n22];
                                ++n21;
                                ++n22;
                                ++n23;
                            }
                            ++n18;
                            n19 += this.dims.x;
                            ++n20;
                        }
                        ++n16;
                        ++n17;
                    }
                    ++n14;
                    ++n15;
                }
                break;
            }
            case 23: {
                int n = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = coordinates.x;
                int n28 = coordinates.y;
                int n29 = coordinates.z;
                int n30 = coordinates.c;
                if (n27 < 0) {
                    n27 = 0;
                    n = -coordinates.x;
                }
                if (n28 < 0) {
                    n28 = 0;
                    n24 = -coordinates.y;
                }
                if (n29 < 0) {
                    n29 = 0;
                    n25 = -coordinates.z;
                }
                if (n30 < 0) {
                    n30 = 0;
                    n26 = -coordinates.c;
                }
                int n31 = coordinates.x + dArray[0][0][0].length;
                int n32 = coordinates.y + dArray[0][0].length;
                int n33 = coordinates.z + dArray[0].length;
                int n34 = coordinates.c + dArray.length;
                if (n31 > this.dims.x) {
                    n31 = this.dims.x;
                }
                if (n32 > this.dims.y) {
                    n32 = this.dims.y;
                }
                if (n33 > this.dims.z) {
                    n33 = this.dims.z;
                }
                if (n34 > this.dims.c) {
                    n34 = this.dims.c;
                }
                int n35 = n28 * this.dims.x + n27;
                int n36 = n30;
                int n37 = n26;
                while (n36 < n34) {
                    int n38 = n29;
                    int n39 = n25;
                    while (n38 < n33) {
                        int n40 = n28;
                        int n41 = n35;
                        int n42 = n24;
                        while (n40 < n32) {
                            int n43 = n27;
                            int n44 = n41;
                            int n45 = n;
                            while (n43 < n31) {
                                dArray[n37][n39][n42][n45] = 0xFFFF & this.elements[n36][coordinates.t][n38][n44];
                                ++n43;
                                ++n44;
                                ++n45;
                            }
                            ++n40;
                            n41 += this.dims.x;
                            ++n42;
                        }
                        ++n38;
                        ++n39;
                    }
                    ++n36;
                    ++n37;
                }
                break;
            }
            case 27: {
                int n = 0;
                int n46 = 0;
                int n47 = 0;
                int n48 = 0;
                int n49 = coordinates.x;
                int n50 = coordinates.y;
                int n51 = coordinates.t;
                int n52 = coordinates.c;
                if (n49 < 0) {
                    n49 = 0;
                    n = -coordinates.x;
                }
                if (n50 < 0) {
                    n50 = 0;
                    n46 = -coordinates.y;
                }
                if (n51 < 0) {
                    n51 = 0;
                    n47 = -coordinates.t;
                }
                if (n52 < 0) {
                    n52 = 0;
                    n48 = -coordinates.c;
                }
                int n53 = coordinates.x + dArray[0][0][0].length;
                int n54 = coordinates.y + dArray[0][0].length;
                int n55 = coordinates.t + dArray[0].length;
                int n56 = coordinates.c + dArray.length;
                if (n53 > this.dims.x) {
                    n53 = this.dims.x;
                }
                if (n54 > this.dims.y) {
                    n54 = this.dims.y;
                }
                if (n55 > this.dims.t) {
                    n55 = this.dims.t;
                }
                if (n56 > this.dims.c) {
                    n56 = this.dims.c;
                }
                int n57 = n50 * this.dims.x + n49;
                int n58 = n52;
                int n59 = n48;
                while (n58 < n56) {
                    int n60 = n51;
                    int n61 = n47;
                    while (n60 < n55) {
                        int n62 = n50;
                        int n63 = n57;
                        int n64 = n46;
                        while (n62 < n54) {
                            int n65 = n49;
                            int n66 = n63;
                            int n67 = n;
                            while (n65 < n53) {
                                dArray[n59][n61][n64][n67] = 0xFFFF & this.elements[n58][n60][coordinates.z][n66];
                                ++n65;
                                ++n66;
                                ++n67;
                            }
                            ++n62;
                            n63 += this.dims.x;
                            ++n64;
                        }
                        ++n60;
                        ++n61;
                    }
                    ++n58;
                    ++n59;
                }
                break;
            }
            case 29: {
                int n = 0;
                int n68 = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.t;
                int n74 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n68 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n69 = -coordinates.t;
                }
                if (n74 < 0) {
                    n74 = 0;
                    n70 = -coordinates.c;
                }
                int n75 = coordinates.x + dArray[0][0][0].length;
                int n76 = coordinates.z + dArray[0][0].length;
                int n77 = coordinates.t + dArray[0].length;
                int n78 = coordinates.c + dArray.length;
                if (n75 > this.dims.x) {
                    n75 = this.dims.x;
                }
                if (n76 > this.dims.z) {
                    n76 = this.dims.z;
                }
                if (n77 > this.dims.t) {
                    n77 = this.dims.t;
                }
                if (n78 > this.dims.c) {
                    n78 = this.dims.c;
                }
                int n79 = coordinates.y * this.dims.x + n71;
                int n80 = n74;
                int n81 = n70;
                while (n80 < n78) {
                    int n82 = n73;
                    int n83 = n69;
                    while (n82 < n77) {
                        int n84 = n72;
                        int n85 = n68;
                        while (n84 < n76) {
                            int n86 = n71;
                            int n87 = n79;
                            int n88 = n;
                            while (n86 < n75) {
                                dArray[n81][n83][n85][n88] = 0xFFFF & this.elements[n80][n82][n84][n87];
                                ++n86;
                                ++n87;
                                ++n88;
                            }
                            ++n84;
                            ++n85;
                        }
                        ++n82;
                        ++n83;
                    }
                    ++n80;
                    ++n81;
                }
                break;
            }
            case 30: {
                int n = 0;
                int n89 = 0;
                int n90 = 0;
                int n91 = 0;
                int n92 = coordinates.y;
                int n93 = coordinates.z;
                int n94 = coordinates.t;
                int n95 = coordinates.c;
                if (n92 < 0) {
                    n92 = 0;
                    n = -coordinates.y;
                }
                if (n93 < 0) {
                    n93 = 0;
                    n89 = -coordinates.z;
                }
                if (n94 < 0) {
                    n94 = 0;
                    n90 = -coordinates.t;
                }
                if (n95 < 0) {
                    n95 = 0;
                    n91 = -coordinates.c;
                }
                int n96 = coordinates.y + dArray[0][0][0].length;
                int n97 = coordinates.z + dArray[0][0].length;
                int n98 = coordinates.t + dArray[0].length;
                int n99 = coordinates.c + dArray.length;
                if (n96 > this.dims.y) {
                    n96 = this.dims.y;
                }
                if (n97 > this.dims.z) {
                    n97 = this.dims.z;
                }
                if (n98 > this.dims.t) {
                    n98 = this.dims.t;
                }
                if (n99 > this.dims.c) {
                    n99 = this.dims.c;
                }
                int n100 = n92 * this.dims.x + coordinates.x;
                int n101 = n95;
                int n102 = n91;
                while (n101 < n99) {
                    int n103 = n94;
                    int n104 = n90;
                    while (n103 < n98) {
                        int n105 = n93;
                        int n106 = n89;
                        while (n105 < n97) {
                            int n107 = n92;
                            int n108 = n100;
                            int n109 = n;
                            while (n107 < n96) {
                                dArray[n102][n104][n106][n109] = 0xFFFF & this.elements[n101][n103][n105][n108];
                                ++n107;
                                n108 += this.dims.x;
                                ++n109;
                            }
                            ++n105;
                            ++n106;
                        }
                        ++n103;
                        ++n104;
                    }
                    ++n101;
                    ++n102;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, double[][][][][] dArray) {
        switch (this.axes) {
            case 31: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = coordinates.x;
                int n7 = coordinates.y;
                int n8 = coordinates.z;
                int n9 = coordinates.t;
                int n10 = coordinates.c;
                if (n6 < 0) {
                    n6 = 0;
                    n = -coordinates.x;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n2 = -coordinates.y;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n3 = -coordinates.z;
                }
                if (n9 < 0) {
                    n9 = 0;
                    n4 = -coordinates.t;
                }
                if (n10 < 0) {
                    n10 = 0;
                    n5 = -coordinates.c;
                }
                int n11 = coordinates.x + dArray[0][0][0][0].length;
                int n12 = coordinates.y + dArray[0][0][0].length;
                int n13 = coordinates.z + dArray[0][0].length;
                int n14 = coordinates.t + dArray[0].length;
                int n15 = coordinates.c + dArray.length;
                if (n11 > this.dims.x) {
                    n11 = this.dims.x;
                }
                if (n12 > this.dims.y) {
                    n12 = this.dims.y;
                }
                if (n13 > this.dims.z) {
                    n13 = this.dims.z;
                }
                if (n14 > this.dims.t) {
                    n14 = this.dims.t;
                }
                if (n15 > this.dims.c) {
                    n15 = this.dims.c;
                }
                int n16 = n7 * this.dims.x + n6;
                int n17 = n10;
                int n18 = n5;
                while (n17 < n15) {
                    int n19 = n9;
                    int n20 = n4;
                    while (n19 < n14) {
                        int n21 = n8;
                        int n22 = n3;
                        while (n21 < n13) {
                            int n23 = n7;
                            int n24 = n16;
                            int n25 = n2;
                            while (n23 < n12) {
                                int n26 = n6;
                                int n27 = n24;
                                int n28 = n;
                                while (n26 < n11) {
                                    dArray[n18][n20][n22][n25][n28] = 0xFFFF & this.elements[n17][n19][n21][n27];
                                    ++n26;
                                    ++n27;
                                    ++n28;
                                }
                                ++n23;
                                n24 += this.dims.x;
                                ++n25;
                            }
                            ++n21;
                            ++n22;
                        }
                        ++n19;
                        ++n20;
                    }
                    ++n17;
                    ++n18;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, float[] fArray) {
        switch (this.axes) {
            case 1: {
                int n;
                int n2 = 0;
                int n3 = coordinates.x;
                if (n3 < 0) {
                    n3 = 0;
                    n2 = -coordinates.x;
                }
                if ((n = coordinates.x + fArray.length) > this.dims.x) {
                    n = this.dims.x;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n4 = n3;
                int n5 = coordinates.y * this.dims.x + n3;
                int n6 = n2;
                while (n4 < n) {
                    fArray[n6] = 0xFFFF & sArray[n5];
                    ++n4;
                    ++n5;
                    ++n6;
                }
                break;
            }
            case 2: {
                int n;
                int n7 = 0;
                int n8 = coordinates.y;
                if (n8 < 0) {
                    n8 = 0;
                    n7 = -coordinates.y;
                }
                if ((n = coordinates.y + fArray.length) > this.dims.y) {
                    n = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n9 = n8;
                int n10 = n8 * this.dims.x + coordinates.x;
                int n11 = n7;
                while (n9 < n) {
                    fArray[n11] = 0xFFFF & sArray[n10];
                    ++n9;
                    n10 += this.dims.x;
                    ++n11;
                }
                break;
            }
            case 4: {
                int n;
                int n12 = 0;
                int n13 = coordinates.z;
                if (n13 < 0) {
                    n13 = 0;
                    n12 = -coordinates.z;
                }
                if ((n = coordinates.z + fArray.length) > this.dims.z) {
                    n = this.dims.z;
                }
                int n14 = coordinates.y * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n15 = n13;
                int n16 = n12;
                while (n15 < n) {
                    fArray[n16] = 0xFFFF & sArray[n15][n14];
                    ++n15;
                    ++n16;
                }
                break;
            }
            case 8: {
                int n;
                int n17 = 0;
                int n18 = coordinates.t;
                if (n18 < 0) {
                    n18 = 0;
                    n17 = -coordinates.t;
                }
                if ((n = coordinates.t + fArray.length) > this.dims.t) {
                    n = this.dims.t;
                }
                int n19 = coordinates.y * this.dims.x + coordinates.x;
                int n20 = n18;
                int n21 = n17;
                while (n20 < n) {
                    fArray[n21] = 0xFFFF & this.elements[coordinates.c][n20][coordinates.z][n19];
                    ++n20;
                    ++n21;
                }
                break;
            }
            case 16: {
                int n;
                int n22 = 0;
                int n23 = coordinates.c;
                if (n23 < 0) {
                    n23 = 0;
                    n22 = -coordinates.c;
                }
                if ((n = coordinates.c + fArray.length) > this.dims.c) {
                    n = this.dims.c;
                }
                int n24 = coordinates.y * this.dims.x + coordinates.x;
                int n25 = n23;
                int n26 = n22;
                while (n25 < n) {
                    fArray[n26] = 0xFFFF & this.elements[n25][coordinates.t][coordinates.z][n24];
                    ++n25;
                    ++n26;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, float[][] fArray) {
        switch (this.axes) {
            case 3: {
                int n = 0;
                int n2 = 0;
                int n3 = coordinates.x;
                int n4 = coordinates.y;
                if (n3 < 0) {
                    n3 = 0;
                    n = -coordinates.x;
                }
                if (n4 < 0) {
                    n4 = 0;
                    n2 = -coordinates.y;
                }
                int n5 = coordinates.x + fArray[0].length;
                int n6 = coordinates.y + fArray.length;
                if (n5 > this.dims.x) {
                    n5 = this.dims.x;
                }
                if (n6 > this.dims.y) {
                    n6 = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n7 = n4;
                int n8 = n4 * this.dims.x + n3;
                int n9 = n2;
                while (n7 < n6) {
                    int n10 = n3;
                    int n11 = n8;
                    int n12 = n;
                    while (n10 < n5) {
                        fArray[n9][n12] = 0xFFFF & sArray[n11];
                        ++n10;
                        ++n11;
                        ++n12;
                    }
                    ++n7;
                    n8 += this.dims.x;
                    ++n9;
                }
                break;
            }
            case 5: {
                int n = 0;
                int n13 = 0;
                int n14 = coordinates.x;
                int n15 = coordinates.z;
                if (n14 < 0) {
                    n14 = 0;
                    n = -coordinates.x;
                }
                if (n15 < 0) {
                    n15 = 0;
                    n13 = -coordinates.z;
                }
                int n16 = coordinates.x + fArray[0].length;
                int n17 = coordinates.z + fArray.length;
                if (n16 > this.dims.x) {
                    n16 = this.dims.x;
                }
                if (n17 > this.dims.z) {
                    n17 = this.dims.z;
                }
                int n18 = coordinates.y * this.dims.x + n14;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n19 = n15;
                int n20 = n13;
                while (n19 < n17) {
                    int n21 = n14;
                    int n22 = n18;
                    int n23 = n;
                    while (n21 < n16) {
                        fArray[n20][n23] = 0xFFFF & sArray[n19][n22];
                        ++n21;
                        ++n22;
                        ++n23;
                    }
                    ++n19;
                    ++n20;
                }
                break;
            }
            case 6: {
                int n = 0;
                int n24 = 0;
                int n25 = coordinates.y;
                int n26 = coordinates.z;
                if (n25 < 0) {
                    n25 = 0;
                    n = -coordinates.y;
                }
                if (n26 < 0) {
                    n26 = 0;
                    n24 = -coordinates.z;
                }
                int n27 = coordinates.y + fArray[0].length;
                int n28 = coordinates.z + fArray.length;
                if (n27 > this.dims.y) {
                    n27 = this.dims.y;
                }
                if (n28 > this.dims.z) {
                    n28 = this.dims.z;
                }
                int n29 = n25 * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n30 = n26;
                int n31 = n24;
                while (n30 < n28) {
                    int n32 = n25;
                    int n33 = n29;
                    int n34 = n;
                    while (n32 < n27) {
                        fArray[n31][n34] = 0xFFFF & sArray[n30][n33];
                        ++n32;
                        n33 += this.dims.x;
                        ++n34;
                    }
                    ++n30;
                    ++n31;
                }
                break;
            }
            case 9: {
                int n = 0;
                int n35 = 0;
                int n36 = coordinates.x;
                int n37 = coordinates.t;
                if (n36 < 0) {
                    n36 = 0;
                    n = -coordinates.x;
                }
                if (n37 < 0) {
                    n37 = 0;
                    n35 = -coordinates.t;
                }
                int n38 = coordinates.x + fArray[0].length;
                int n39 = coordinates.t + fArray.length;
                if (n38 > this.dims.x) {
                    n38 = this.dims.x;
                }
                if (n39 > this.dims.t) {
                    n39 = this.dims.t;
                }
                int n40 = coordinates.y * this.dims.x + n36;
                int n41 = n37;
                int n42 = n35;
                while (n41 < n39) {
                    int n43 = n36;
                    int n44 = n40;
                    int n45 = n;
                    while (n43 < n38) {
                        fArray[n42][n45] = 0xFFFF & this.elements[coordinates.c][n41][coordinates.z][n44];
                        ++n43;
                        ++n44;
                        ++n45;
                    }
                    ++n41;
                    ++n42;
                }
                break;
            }
            case 10: {
                int n = 0;
                int n46 = 0;
                int n47 = coordinates.y;
                int n48 = coordinates.t;
                if (n47 < 0) {
                    n47 = 0;
                    n = -coordinates.y;
                }
                if (n48 < 0) {
                    n48 = 0;
                    n46 = -coordinates.t;
                }
                int n49 = coordinates.y + fArray[0].length;
                int n50 = coordinates.t + fArray.length;
                if (n49 > this.dims.y) {
                    n49 = this.dims.y;
                }
                if (n50 > this.dims.t) {
                    n50 = this.dims.t;
                }
                int n51 = n47 * this.dims.x + coordinates.x;
                int n52 = n48;
                int n53 = n46;
                while (n52 < n50) {
                    int n54 = n47;
                    int n55 = n51;
                    int n56 = n;
                    while (n54 < n49) {
                        fArray[n53][n56] = 0xFFFF & this.elements[coordinates.c][n52][coordinates.z][n55];
                        ++n54;
                        n55 += this.dims.x;
                        ++n56;
                    }
                    ++n52;
                    ++n53;
                }
                break;
            }
            case 12: {
                int n = 0;
                int n57 = 0;
                int n58 = coordinates.z;
                int n59 = coordinates.t;
                if (n58 < 0) {
                    n58 = 0;
                    n = -coordinates.z;
                }
                if (n59 < 0) {
                    n59 = 0;
                    n57 = -coordinates.t;
                }
                int n60 = coordinates.z + fArray[0].length;
                int n61 = coordinates.t + fArray.length;
                if (n60 > this.dims.z) {
                    n60 = this.dims.z;
                }
                if (n61 > this.dims.t) {
                    n61 = this.dims.t;
                }
                int n62 = coordinates.y * this.dims.x + coordinates.x;
                int n63 = n59;
                int n64 = n57;
                while (n63 < n61) {
                    int n65 = n58;
                    int n66 = n;
                    while (n65 < n60) {
                        fArray[n64][n66] = 0xFFFF & this.elements[coordinates.c][n63][n65][n62];
                        ++n65;
                        ++n66;
                    }
                    ++n63;
                    ++n64;
                }
                break;
            }
            case 17: {
                int n = 0;
                int n67 = 0;
                int n68 = coordinates.x;
                int n69 = coordinates.c;
                if (n68 < 0) {
                    n68 = 0;
                    n = -coordinates.x;
                }
                if (n69 < 0) {
                    n69 = 0;
                    n67 = -coordinates.c;
                }
                int n70 = coordinates.x + fArray[0].length;
                int n71 = coordinates.c + fArray.length;
                if (n70 > this.dims.x) {
                    n70 = this.dims.x;
                }
                if (n71 > this.dims.c) {
                    n71 = this.dims.c;
                }
                int n72 = coordinates.y * this.dims.x + n68;
                int n73 = n69;
                int n74 = n67;
                while (n73 < n71) {
                    int n75 = n68;
                    int n76 = n72;
                    int n77 = n;
                    while (n75 < n70) {
                        fArray[n74][n77] = 0xFFFF & this.elements[n73][coordinates.t][coordinates.z][n76];
                        ++n75;
                        ++n76;
                        ++n77;
                    }
                    ++n73;
                    ++n74;
                }
                break;
            }
            case 18: {
                int n = 0;
                int n78 = 0;
                int n79 = coordinates.y;
                int n80 = coordinates.c;
                if (n79 < 0) {
                    n79 = 0;
                    n = -coordinates.y;
                }
                if (n80 < 0) {
                    n80 = 0;
                    n78 = -coordinates.c;
                }
                int n81 = coordinates.y + fArray[0].length;
                int n82 = coordinates.c + fArray.length;
                if (n81 > this.dims.y) {
                    n81 = this.dims.y;
                }
                if (n82 > this.dims.c) {
                    n82 = this.dims.c;
                }
                int n83 = n79 * this.dims.x + coordinates.x;
                int n84 = n80;
                int n85 = n78;
                while (n84 < n82) {
                    int n86 = n79;
                    int n87 = n83;
                    int n88 = n;
                    while (n86 < n81) {
                        fArray[n85][n88] = 0xFFFF & this.elements[n84][coordinates.t][coordinates.z][n87];
                        ++n86;
                        n87 += this.dims.x;
                        ++n88;
                    }
                    ++n84;
                    ++n85;
                }
                break;
            }
            case 20: {
                int n = 0;
                int n89 = 0;
                int n90 = coordinates.z;
                int n91 = coordinates.c;
                if (n90 < 0) {
                    n90 = 0;
                    n = -coordinates.z;
                }
                if (n91 < 0) {
                    n91 = 0;
                    n89 = -coordinates.c;
                }
                int n92 = coordinates.z + fArray[0].length;
                int n93 = coordinates.c + fArray.length;
                if (n92 > this.dims.z) {
                    n92 = this.dims.z;
                }
                if (n93 > this.dims.c) {
                    n93 = this.dims.c;
                }
                int n94 = coordinates.y * this.dims.x + coordinates.x;
                int n95 = n91;
                int n96 = n89;
                while (n95 < n93) {
                    int n97 = n90;
                    int n98 = n;
                    while (n97 < n92) {
                        fArray[n96][n98] = 0xFFFF & this.elements[n95][coordinates.t][n97][n94];
                        ++n97;
                        ++n98;
                    }
                    ++n95;
                    ++n96;
                }
                break;
            }
            case 24: {
                int n = 0;
                int n99 = 0;
                int n100 = coordinates.t;
                int n101 = coordinates.c;
                if (n100 < 0) {
                    n100 = 0;
                    n = -coordinates.t;
                }
                if (n101 < 0) {
                    n101 = 0;
                    n99 = -coordinates.c;
                }
                int n102 = coordinates.t + fArray[0].length;
                int n103 = coordinates.c + fArray.length;
                if (n102 > this.dims.t) {
                    n102 = this.dims.t;
                }
                if (n103 > this.dims.c) {
                    n103 = this.dims.c;
                }
                int n104 = coordinates.y * this.dims.x + coordinates.x;
                int n105 = n101;
                int n106 = n99;
                while (n105 < n103) {
                    int n107 = n100;
                    int n108 = n;
                    while (n107 < n102) {
                        fArray[n106][n108] = 0xFFFF & this.elements[n105][n107][coordinates.z][n104];
                        ++n107;
                        ++n108;
                    }
                    ++n105;
                    ++n106;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, float[][][] fArray) {
        switch (this.axes) {
            case 7: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = coordinates.x;
                int n5 = coordinates.y;
                int n6 = coordinates.z;
                if (n4 < 0) {
                    n4 = 0;
                    n = -coordinates.x;
                }
                if (n5 < 0) {
                    n5 = 0;
                    n2 = -coordinates.y;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n3 = -coordinates.z;
                }
                int n7 = coordinates.x + fArray[0][0].length;
                int n8 = coordinates.y + fArray[0].length;
                int n9 = coordinates.z + fArray.length;
                if (n7 > this.dims.x) {
                    n7 = this.dims.x;
                }
                if (n8 > this.dims.y) {
                    n8 = this.dims.y;
                }
                if (n9 > this.dims.z) {
                    n9 = this.dims.z;
                }
                int n10 = n5 * this.dims.x + n4;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n11 = n6;
                int n12 = n3;
                while (n11 < n9) {
                    int n13 = n5;
                    int n14 = n10;
                    int n15 = n2;
                    while (n13 < n8) {
                        int n16 = n4;
                        int n17 = n14;
                        int n18 = n;
                        while (n16 < n7) {
                            fArray[n12][n15][n18] = 0xFFFF & sArray[n11][n17];
                            ++n16;
                            ++n17;
                            ++n18;
                        }
                        ++n13;
                        n14 += this.dims.x;
                        ++n15;
                    }
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 11: {
                int n = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = coordinates.x;
                int n22 = coordinates.y;
                int n23 = coordinates.t;
                if (n21 < 0) {
                    n21 = 0;
                    n = -coordinates.x;
                }
                if (n22 < 0) {
                    n22 = 0;
                    n19 = -coordinates.y;
                }
                if (n23 < 0) {
                    n23 = 0;
                    n20 = -coordinates.t;
                }
                int n24 = coordinates.x + fArray[0][0].length;
                int n25 = coordinates.y + fArray[0].length;
                int n26 = coordinates.t + fArray.length;
                if (n24 > this.dims.x) {
                    n24 = this.dims.x;
                }
                if (n25 > this.dims.y) {
                    n25 = this.dims.y;
                }
                if (n26 > this.dims.t) {
                    n26 = this.dims.t;
                }
                int n27 = n22 * this.dims.x + n21;
                int n28 = n23;
                int n29 = n20;
                while (n28 < n26) {
                    int n30 = n22;
                    int n31 = n27;
                    int n32 = n19;
                    while (n30 < n25) {
                        int n33 = n21;
                        int n34 = n31;
                        int n35 = n;
                        while (n33 < n24) {
                            fArray[n29][n32][n35] = 0xFFFF & this.elements[coordinates.c][n28][coordinates.z][n34];
                            ++n33;
                            ++n34;
                            ++n35;
                        }
                        ++n30;
                        n31 += this.dims.x;
                        ++n32;
                    }
                    ++n28;
                    ++n29;
                }
                break;
            }
            case 19: {
                int n = 0;
                int n36 = 0;
                int n37 = 0;
                int n38 = coordinates.x;
                int n39 = coordinates.y;
                int n40 = coordinates.c;
                if (n38 < 0) {
                    n38 = 0;
                    n = -coordinates.x;
                }
                if (n39 < 0) {
                    n39 = 0;
                    n36 = -coordinates.y;
                }
                if (n40 < 0) {
                    n40 = 0;
                    n37 = -coordinates.c;
                }
                int n41 = coordinates.x + fArray[0][0].length;
                int n42 = coordinates.y + fArray[0].length;
                int n43 = coordinates.c + fArray.length;
                if (n41 > this.dims.x) {
                    n41 = this.dims.x;
                }
                if (n42 > this.dims.y) {
                    n42 = this.dims.y;
                }
                if (n43 > this.dims.c) {
                    n43 = this.dims.c;
                }
                int n44 = n39 * this.dims.x + n38;
                int n45 = n40;
                int n46 = n37;
                while (n45 < n43) {
                    int n47 = n39;
                    int n48 = n44;
                    int n49 = n36;
                    while (n47 < n42) {
                        int n50 = n38;
                        int n51 = n48;
                        int n52 = n;
                        while (n50 < n41) {
                            fArray[n46][n49][n52] = 0xFFFF & this.elements[n45][coordinates.t][coordinates.z][n51];
                            ++n50;
                            ++n51;
                            ++n52;
                        }
                        ++n47;
                        n48 += this.dims.x;
                        ++n49;
                    }
                    ++n45;
                    ++n46;
                }
                break;
            }
            case 13: {
                int n = 0;
                int n53 = 0;
                int n54 = 0;
                int n55 = coordinates.x;
                int n56 = coordinates.z;
                int n57 = coordinates.t;
                if (n55 < 0) {
                    n55 = 0;
                    n = -coordinates.x;
                }
                if (n56 < 0) {
                    n56 = 0;
                    n53 = -coordinates.z;
                }
                if (n57 < 0) {
                    n57 = 0;
                    n54 = -coordinates.t;
                }
                int n58 = coordinates.x + fArray[0][0].length;
                int n59 = coordinates.z + fArray[0].length;
                int n60 = coordinates.t + fArray.length;
                if (n58 > this.dims.x) {
                    n58 = this.dims.x;
                }
                if (n59 > this.dims.z) {
                    n59 = this.dims.z;
                }
                if (n60 > this.dims.t) {
                    n60 = this.dims.t;
                }
                int n61 = coordinates.y * this.dims.x + n55;
                int n62 = n57;
                int n63 = n54;
                while (n62 < n60) {
                    int n64 = n56;
                    int n65 = n53;
                    while (n64 < n59) {
                        int n66 = n55;
                        int n67 = n61;
                        int n68 = n;
                        while (n66 < n58) {
                            fArray[n63][n65][n68] = 0xFFFF & this.elements[coordinates.c][n62][n64][n67];
                            ++n66;
                            ++n67;
                            ++n68;
                        }
                        ++n64;
                        ++n65;
                    }
                    ++n62;
                    ++n63;
                }
                break;
            }
            case 21: {
                int n = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n69 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n70 = -coordinates.c;
                }
                int n74 = coordinates.x + fArray[0][0].length;
                int n75 = coordinates.z + fArray[0].length;
                int n76 = coordinates.c + fArray.length;
                if (n74 > this.dims.x) {
                    n74 = this.dims.x;
                }
                if (n75 > this.dims.z) {
                    n75 = this.dims.z;
                }
                if (n76 > this.dims.c) {
                    n76 = this.dims.c;
                }
                int n77 = coordinates.y * this.dims.x + n71;
                int n78 = n73;
                int n79 = n70;
                while (n78 < n76) {
                    int n80 = n72;
                    int n81 = n69;
                    while (n80 < n75) {
                        int n82 = n71;
                        int n83 = n77;
                        int n84 = n;
                        while (n82 < n74) {
                            fArray[n79][n81][n84] = 0xFFFF & this.elements[n78][coordinates.t][n80][n83];
                            ++n82;
                            ++n83;
                            ++n84;
                        }
                        ++n80;
                        ++n81;
                    }
                    ++n78;
                    ++n79;
                }
                break;
            }
            case 25: {
                int n = 0;
                int n85 = 0;
                int n86 = 0;
                int n87 = coordinates.x;
                int n88 = coordinates.t;
                int n89 = coordinates.c;
                if (n87 < 0) {
                    n87 = 0;
                    n = -coordinates.x;
                }
                if (n88 < 0) {
                    n88 = 0;
                    n85 = -coordinates.t;
                }
                if (n89 < 0) {
                    n89 = 0;
                    n86 = -coordinates.c;
                }
                int n90 = coordinates.x + fArray[0][0].length;
                int n91 = coordinates.t + fArray[0].length;
                int n92 = coordinates.c + fArray.length;
                if (n90 > this.dims.x) {
                    n90 = this.dims.x;
                }
                if (n91 > this.dims.t) {
                    n91 = this.dims.t;
                }
                if (n92 > this.dims.c) {
                    n92 = this.dims.c;
                }
                int n93 = coordinates.y * this.dims.x + n87;
                int n94 = n89;
                int n95 = n86;
                while (n94 < n92) {
                    int n96 = n88;
                    int n97 = n85;
                    while (n96 < n91) {
                        int n98 = n87;
                        int n99 = n93;
                        int n100 = n;
                        while (n98 < n90) {
                            fArray[n95][n97][n100] = 0xFFFF & this.elements[n94][n96][coordinates.z][n99];
                            ++n98;
                            ++n99;
                            ++n100;
                        }
                        ++n96;
                        ++n97;
                    }
                    ++n94;
                    ++n95;
                }
                break;
            }
            case 14: {
                int n = 0;
                int n101 = 0;
                int n102 = 0;
                int n103 = coordinates.y;
                int n104 = coordinates.z;
                int n105 = coordinates.t;
                if (n103 < 0) {
                    n103 = 0;
                    n = -coordinates.y;
                }
                if (n104 < 0) {
                    n104 = 0;
                    n101 = -coordinates.z;
                }
                if (n105 < 0) {
                    n105 = 0;
                    n102 = -coordinates.t;
                }
                int n106 = coordinates.y + fArray[0][0].length;
                int n107 = coordinates.z + fArray[0].length;
                int n108 = coordinates.t + fArray.length;
                if (n106 > this.dims.y) {
                    n106 = this.dims.y;
                }
                if (n107 > this.dims.z) {
                    n107 = this.dims.z;
                }
                if (n108 > this.dims.t) {
                    n108 = this.dims.t;
                }
                int n109 = n103 * this.dims.x + coordinates.x;
                int n110 = n105;
                int n111 = n102;
                while (n110 < n108) {
                    int n112 = n104;
                    int n113 = n101;
                    while (n112 < n107) {
                        int n114 = n103;
                        int n115 = n109;
                        int n116 = n;
                        while (n114 < n106) {
                            fArray[n111][n113][n116] = 0xFFFF & this.elements[coordinates.c][n110][n112][n115];
                            ++n114;
                            n115 += this.dims.x;
                            ++n116;
                        }
                        ++n112;
                        ++n113;
                    }
                    ++n110;
                    ++n111;
                }
                break;
            }
            case 22: {
                int n = 0;
                int n117 = 0;
                int n118 = 0;
                int n119 = coordinates.y;
                int n120 = coordinates.z;
                int n121 = coordinates.c;
                if (n119 < 0) {
                    n119 = 0;
                    n = -coordinates.y;
                }
                if (n120 < 0) {
                    n120 = 0;
                    n117 = -coordinates.z;
                }
                if (n121 < 0) {
                    n121 = 0;
                    n118 = -coordinates.c;
                }
                int n122 = coordinates.y + fArray[0][0].length;
                int n123 = coordinates.z + fArray[0].length;
                int n124 = coordinates.c + fArray.length;
                if (n122 > this.dims.y) {
                    n122 = this.dims.y;
                }
                if (n123 > this.dims.z) {
                    n123 = this.dims.z;
                }
                if (n124 > this.dims.c) {
                    n124 = this.dims.c;
                }
                int n125 = n119 * this.dims.x + coordinates.x;
                int n126 = n121;
                int n127 = n118;
                while (n126 < n124) {
                    int n128 = n120;
                    int n129 = n117;
                    while (n128 < n123) {
                        int n130 = n119;
                        int n131 = n125;
                        int n132 = n;
                        while (n130 < n122) {
                            fArray[n127][n129][n132] = 0xFFFF & this.elements[n126][coordinates.t][n128][n131];
                            ++n130;
                            n131 += this.dims.x;
                            ++n132;
                        }
                        ++n128;
                        ++n129;
                    }
                    ++n126;
                    ++n127;
                }
                break;
            }
            case 26: {
                int n = 0;
                int n133 = 0;
                int n134 = 0;
                int n135 = coordinates.y;
                int n136 = coordinates.t;
                int n137 = coordinates.c;
                if (n135 < 0) {
                    n135 = 0;
                    n = -coordinates.y;
                }
                if (n136 < 0) {
                    n136 = 0;
                    n133 = -coordinates.t;
                }
                if (n137 < 0) {
                    n137 = 0;
                    n134 = -coordinates.c;
                }
                int n138 = coordinates.y + fArray[0][0].length;
                int n139 = coordinates.t + fArray[0].length;
                int n140 = coordinates.c + fArray.length;
                if (n138 > this.dims.y) {
                    n138 = this.dims.y;
                }
                if (n139 > this.dims.t) {
                    n139 = this.dims.t;
                }
                if (n140 > this.dims.c) {
                    n140 = this.dims.c;
                }
                int n141 = n135 * this.dims.x + coordinates.x;
                int n142 = n137;
                int n143 = n134;
                while (n142 < n140) {
                    int n144 = n136;
                    int n145 = n133;
                    while (n144 < n139) {
                        int n146 = n135;
                        int n147 = n141;
                        int n148 = n;
                        while (n146 < n138) {
                            fArray[n143][n145][n148] = 0xFFFF & this.elements[n142][n144][coordinates.z][n147];
                            ++n146;
                            n147 += this.dims.x;
                            ++n148;
                        }
                        ++n144;
                        ++n145;
                    }
                    ++n142;
                    ++n143;
                }
                break;
            }
            case 28: {
                int n = 0;
                int n149 = 0;
                int n150 = 0;
                int n151 = coordinates.z;
                int n152 = coordinates.t;
                int n153 = coordinates.c;
                if (n151 < 0) {
                    n151 = 0;
                    n = -coordinates.z;
                }
                if (n152 < 0) {
                    n152 = 0;
                    n149 = -coordinates.t;
                }
                if (n153 < 0) {
                    n153 = 0;
                    n150 = -coordinates.c;
                }
                int n154 = coordinates.z + fArray[0][0].length;
                int n155 = coordinates.t + fArray[0].length;
                int n156 = coordinates.c + fArray.length;
                if (n154 > this.dims.z) {
                    n154 = this.dims.z;
                }
                if (n155 > this.dims.t) {
                    n155 = this.dims.t;
                }
                if (n156 > this.dims.c) {
                    n156 = this.dims.c;
                }
                int n157 = coordinates.y * this.dims.x + coordinates.x;
                int n158 = n153;
                int n159 = n150;
                while (n158 < n156) {
                    int n160 = n152;
                    int n161 = n149;
                    while (n160 < n155) {
                        int n162 = n151;
                        int n163 = n;
                        while (n162 < n154) {
                            fArray[n159][n161][n163] = 0xFFFF & this.elements[n158][n160][n162][n157];
                            ++n162;
                            ++n163;
                        }
                        ++n160;
                        ++n161;
                    }
                    ++n158;
                    ++n159;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, float[][][][] fArray) {
        switch (this.axes) {
            case 15: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = coordinates.x;
                int n6 = coordinates.y;
                int n7 = coordinates.z;
                int n8 = coordinates.t;
                if (n5 < 0) {
                    n5 = 0;
                    n = -coordinates.x;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n2 = -coordinates.y;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n3 = -coordinates.z;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n4 = -coordinates.t;
                }
                int n9 = coordinates.x + fArray[0][0][0].length;
                int n10 = coordinates.y + fArray[0][0].length;
                int n11 = coordinates.z + fArray[0].length;
                int n12 = coordinates.t + fArray.length;
                if (n9 > this.dims.x) {
                    n9 = this.dims.x;
                }
                if (n10 > this.dims.y) {
                    n10 = this.dims.y;
                }
                if (n11 > this.dims.z) {
                    n11 = this.dims.z;
                }
                if (n12 > this.dims.t) {
                    n12 = this.dims.t;
                }
                int n13 = n6 * this.dims.x + n5;
                int n14 = n8;
                int n15 = n4;
                while (n14 < n12) {
                    int n16 = n7;
                    int n17 = n3;
                    while (n16 < n11) {
                        int n18 = n6;
                        int n19 = n13;
                        int n20 = n2;
                        while (n18 < n10) {
                            int n21 = n5;
                            int n22 = n19;
                            int n23 = n;
                            while (n21 < n9) {
                                fArray[n15][n17][n20][n23] = 0xFFFF & this.elements[coordinates.c][n14][n16][n22];
                                ++n21;
                                ++n22;
                                ++n23;
                            }
                            ++n18;
                            n19 += this.dims.x;
                            ++n20;
                        }
                        ++n16;
                        ++n17;
                    }
                    ++n14;
                    ++n15;
                }
                break;
            }
            case 23: {
                int n = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = coordinates.x;
                int n28 = coordinates.y;
                int n29 = coordinates.z;
                int n30 = coordinates.c;
                if (n27 < 0) {
                    n27 = 0;
                    n = -coordinates.x;
                }
                if (n28 < 0) {
                    n28 = 0;
                    n24 = -coordinates.y;
                }
                if (n29 < 0) {
                    n29 = 0;
                    n25 = -coordinates.z;
                }
                if (n30 < 0) {
                    n30 = 0;
                    n26 = -coordinates.c;
                }
                int n31 = coordinates.x + fArray[0][0][0].length;
                int n32 = coordinates.y + fArray[0][0].length;
                int n33 = coordinates.z + fArray[0].length;
                int n34 = coordinates.c + fArray.length;
                if (n31 > this.dims.x) {
                    n31 = this.dims.x;
                }
                if (n32 > this.dims.y) {
                    n32 = this.dims.y;
                }
                if (n33 > this.dims.z) {
                    n33 = this.dims.z;
                }
                if (n34 > this.dims.c) {
                    n34 = this.dims.c;
                }
                int n35 = n28 * this.dims.x + n27;
                int n36 = n30;
                int n37 = n26;
                while (n36 < n34) {
                    int n38 = n29;
                    int n39 = n25;
                    while (n38 < n33) {
                        int n40 = n28;
                        int n41 = n35;
                        int n42 = n24;
                        while (n40 < n32) {
                            int n43 = n27;
                            int n44 = n41;
                            int n45 = n;
                            while (n43 < n31) {
                                fArray[n37][n39][n42][n45] = 0xFFFF & this.elements[n36][coordinates.t][n38][n44];
                                ++n43;
                                ++n44;
                                ++n45;
                            }
                            ++n40;
                            n41 += this.dims.x;
                            ++n42;
                        }
                        ++n38;
                        ++n39;
                    }
                    ++n36;
                    ++n37;
                }
                break;
            }
            case 27: {
                int n = 0;
                int n46 = 0;
                int n47 = 0;
                int n48 = 0;
                int n49 = coordinates.x;
                int n50 = coordinates.y;
                int n51 = coordinates.t;
                int n52 = coordinates.c;
                if (n49 < 0) {
                    n49 = 0;
                    n = -coordinates.x;
                }
                if (n50 < 0) {
                    n50 = 0;
                    n46 = -coordinates.y;
                }
                if (n51 < 0) {
                    n51 = 0;
                    n47 = -coordinates.t;
                }
                if (n52 < 0) {
                    n52 = 0;
                    n48 = -coordinates.c;
                }
                int n53 = coordinates.x + fArray[0][0][0].length;
                int n54 = coordinates.y + fArray[0][0].length;
                int n55 = coordinates.t + fArray[0].length;
                int n56 = coordinates.c + fArray.length;
                if (n53 > this.dims.x) {
                    n53 = this.dims.x;
                }
                if (n54 > this.dims.y) {
                    n54 = this.dims.y;
                }
                if (n55 > this.dims.t) {
                    n55 = this.dims.t;
                }
                if (n56 > this.dims.c) {
                    n56 = this.dims.c;
                }
                int n57 = n50 * this.dims.x + n49;
                int n58 = n52;
                int n59 = n48;
                while (n58 < n56) {
                    int n60 = n51;
                    int n61 = n47;
                    while (n60 < n55) {
                        int n62 = n50;
                        int n63 = n57;
                        int n64 = n46;
                        while (n62 < n54) {
                            int n65 = n49;
                            int n66 = n63;
                            int n67 = n;
                            while (n65 < n53) {
                                fArray[n59][n61][n64][n67] = 0xFFFF & this.elements[n58][n60][coordinates.z][n66];
                                ++n65;
                                ++n66;
                                ++n67;
                            }
                            ++n62;
                            n63 += this.dims.x;
                            ++n64;
                        }
                        ++n60;
                        ++n61;
                    }
                    ++n58;
                    ++n59;
                }
                break;
            }
            case 29: {
                int n = 0;
                int n68 = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.t;
                int n74 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n68 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n69 = -coordinates.t;
                }
                if (n74 < 0) {
                    n74 = 0;
                    n70 = -coordinates.c;
                }
                int n75 = coordinates.x + fArray[0][0][0].length;
                int n76 = coordinates.z + fArray[0][0].length;
                int n77 = coordinates.t + fArray[0].length;
                int n78 = coordinates.c + fArray.length;
                if (n75 > this.dims.x) {
                    n75 = this.dims.x;
                }
                if (n76 > this.dims.z) {
                    n76 = this.dims.z;
                }
                if (n77 > this.dims.t) {
                    n77 = this.dims.t;
                }
                if (n78 > this.dims.c) {
                    n78 = this.dims.c;
                }
                int n79 = coordinates.y * this.dims.x + n71;
                int n80 = n74;
                int n81 = n70;
                while (n80 < n78) {
                    int n82 = n73;
                    int n83 = n69;
                    while (n82 < n77) {
                        int n84 = n72;
                        int n85 = n68;
                        while (n84 < n76) {
                            int n86 = n71;
                            int n87 = n79;
                            int n88 = n;
                            while (n86 < n75) {
                                fArray[n81][n83][n85][n88] = 0xFFFF & this.elements[n80][n82][n84][n87];
                                ++n86;
                                ++n87;
                                ++n88;
                            }
                            ++n84;
                            ++n85;
                        }
                        ++n82;
                        ++n83;
                    }
                    ++n80;
                    ++n81;
                }
                break;
            }
            case 30: {
                int n = 0;
                int n89 = 0;
                int n90 = 0;
                int n91 = 0;
                int n92 = coordinates.y;
                int n93 = coordinates.z;
                int n94 = coordinates.t;
                int n95 = coordinates.c;
                if (n92 < 0) {
                    n92 = 0;
                    n = -coordinates.y;
                }
                if (n93 < 0) {
                    n93 = 0;
                    n89 = -coordinates.z;
                }
                if (n94 < 0) {
                    n94 = 0;
                    n90 = -coordinates.t;
                }
                if (n95 < 0) {
                    n95 = 0;
                    n91 = -coordinates.c;
                }
                int n96 = coordinates.y + fArray[0][0][0].length;
                int n97 = coordinates.z + fArray[0][0].length;
                int n98 = coordinates.t + fArray[0].length;
                int n99 = coordinates.c + fArray.length;
                if (n96 > this.dims.y) {
                    n96 = this.dims.y;
                }
                if (n97 > this.dims.z) {
                    n97 = this.dims.z;
                }
                if (n98 > this.dims.t) {
                    n98 = this.dims.t;
                }
                if (n99 > this.dims.c) {
                    n99 = this.dims.c;
                }
                int n100 = n92 * this.dims.x + coordinates.x;
                int n101 = n95;
                int n102 = n91;
                while (n101 < n99) {
                    int n103 = n94;
                    int n104 = n90;
                    while (n103 < n98) {
                        int n105 = n93;
                        int n106 = n89;
                        while (n105 < n97) {
                            int n107 = n92;
                            int n108 = n100;
                            int n109 = n;
                            while (n107 < n96) {
                                fArray[n102][n104][n106][n109] = 0xFFFF & this.elements[n101][n103][n105][n108];
                                ++n107;
                                n108 += this.dims.x;
                                ++n109;
                            }
                            ++n105;
                            ++n106;
                        }
                        ++n103;
                        ++n104;
                    }
                    ++n101;
                    ++n102;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void get(Coordinates coordinates, float[][][][][] fArray) {
        switch (this.axes) {
            case 31: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = coordinates.x;
                int n7 = coordinates.y;
                int n8 = coordinates.z;
                int n9 = coordinates.t;
                int n10 = coordinates.c;
                if (n6 < 0) {
                    n6 = 0;
                    n = -coordinates.x;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n2 = -coordinates.y;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n3 = -coordinates.z;
                }
                if (n9 < 0) {
                    n9 = 0;
                    n4 = -coordinates.t;
                }
                if (n10 < 0) {
                    n10 = 0;
                    n5 = -coordinates.c;
                }
                int n11 = coordinates.x + fArray[0][0][0][0].length;
                int n12 = coordinates.y + fArray[0][0][0].length;
                int n13 = coordinates.z + fArray[0][0].length;
                int n14 = coordinates.t + fArray[0].length;
                int n15 = coordinates.c + fArray.length;
                if (n11 > this.dims.x) {
                    n11 = this.dims.x;
                }
                if (n12 > this.dims.y) {
                    n12 = this.dims.y;
                }
                if (n13 > this.dims.z) {
                    n13 = this.dims.z;
                }
                if (n14 > this.dims.t) {
                    n14 = this.dims.t;
                }
                if (n15 > this.dims.c) {
                    n15 = this.dims.c;
                }
                int n16 = n7 * this.dims.x + n6;
                int n17 = n10;
                int n18 = n5;
                while (n17 < n15) {
                    int n19 = n9;
                    int n20 = n4;
                    while (n19 < n14) {
                        int n21 = n8;
                        int n22 = n3;
                        while (n21 < n13) {
                            int n23 = n7;
                            int n24 = n16;
                            int n25 = n2;
                            while (n23 < n12) {
                                int n26 = n6;
                                int n27 = n24;
                                int n28 = n;
                                while (n26 < n11) {
                                    fArray[n18][n20][n22][n25][n28] = 0xFFFF & this.elements[n17][n19][n21][n27];
                                    ++n26;
                                    ++n27;
                                    ++n28;
                                }
                                ++n23;
                                n24 += this.dims.x;
                                ++n25;
                            }
                            ++n21;
                            ++n22;
                        }
                        ++n19;
                        ++n20;
                    }
                    ++n17;
                    ++n18;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(double d) {
        int n = this.dims.x * this.dims.y;
        short s = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
        for (int i = 0; i < this.dims.c; ++i) {
            for (int j = 0; j < this.dims.t; ++j) {
                for (int k = 0; k < this.dims.z; ++k) {
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.elements[i][j][k][i2] = s;
                    }
                }
            }
        }
    }

    @Override
    public void mirror(Borders borders) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (borders.x > (this.dims.x - 1) / 2 || borders.y > (this.dims.y - 1) / 2 || borders.z > (this.dims.z - 1) / 2 || borders.t > (this.dims.t - 1) / 2 || borders.c > (this.dims.c - 1) / 2) {
            throw new IllegalArgumentException("Border(s) too large");
        }
        int n11 = this.dims.x - borders.x;
        int n12 = this.dims.y - borders.y;
        int n13 = this.dims.z - borders.z;
        int n14 = this.dims.t - borders.t;
        int n15 = this.dims.c - borders.c;
        int n16 = this.dims.x - 2 * borders.x;
        int n17 = this.dims.y - 2 * borders.y;
        int n18 = this.dims.z - 2 * borders.z;
        int n19 = this.dims.t - 2 * borders.t;
        int n20 = this.dims.c - 2 * borders.c;
        int n21 = n16 == 1 ? n16 : n16 - 1;
        int n22 = n17 == 1 ? n17 : n17 - 1;
        int n23 = n18 == 1 ? n18 : n18 - 1;
        int n24 = n19 == 1 ? n19 : n19 - 1;
        int n25 = n20 == 1 ? n20 : n20 - 1;
        int n26 = n16 == 1 ? 1 : 2;
        int n27 = n17 == 1 ? 1 : 2;
        int n28 = n18 == 1 ? 1 : 2;
        int n29 = n19 == 1 ? 1 : 2;
        int n30 = n20 == 1 ? 1 : 2;
        int n31 = this.dims.x * this.dims.y;
        int n32 = borders.y * this.dims.x;
        for (n10 = borders.c; n10 < n15; ++n10) {
            for (n9 = borders.t; n9 < n14; ++n9) {
                for (n8 = borders.z; n8 < n13; ++n8) {
                    for (n7 = 0; n7 < borders.x; ++n7) {
                        n6 = n7 - borders.x;
                        n5 = n6 / n21;
                        n5 += n5 % n26;
                        n4 = borders.x + Math.abs(n6 - n5 * n21);
                        n3 = borders.y;
                        n2 = n32 + n7;
                        n = n32 + n4;
                        while (n3 < n12) {
                            this.elements[n10][n9][n8][n2] = this.elements[n10][n9][n8][n];
                            ++n3;
                            n2 += this.dims.x;
                            n += this.dims.x;
                        }
                    }
                    for (n7 = n11; n7 < this.dims.x; ++n7) {
                        n6 = n7 - borders.x;
                        n5 = n6 / n21;
                        n5 += n5 % n26;
                        n4 = borders.x + Math.abs(n6 - n5 * n21);
                        n3 = borders.y;
                        n2 = n32 + n7;
                        n = n32 + n4;
                        while (n3 < n12) {
                            this.elements[n10][n9][n8][n2] = this.elements[n10][n9][n8][n];
                            ++n3;
                            n2 += this.dims.x;
                            n += this.dims.x;
                        }
                    }
                }
            }
        }
        for (n10 = borders.c; n10 < n15; ++n10) {
            for (n9 = borders.t; n9 < n14; ++n9) {
                for (n8 = borders.z; n8 < n13; ++n8) {
                    for (n7 = 0; n7 < borders.y; ++n7) {
                        n6 = n7 - borders.y;
                        n5 = n6 / n22;
                        n5 += n5 % n27;
                        n4 = borders.y + Math.abs(n6 - n5 * n22);
                        n3 = 0;
                        n2 = n7 * this.dims.x;
                        n = n4 * this.dims.x;
                        while (n3 < this.dims.x) {
                            this.elements[n10][n9][n8][n2] = this.elements[n10][n9][n8][n];
                            ++n3;
                            ++n2;
                            ++n;
                        }
                    }
                    for (n7 = n12; n7 < this.dims.y; ++n7) {
                        n6 = n7 - borders.y;
                        n5 = n6 / n22;
                        n5 += n5 % n27;
                        n4 = borders.y + Math.abs(n6 - n5 * n22);
                        n3 = 0;
                        n2 = n7 * this.dims.x;
                        n = n4 * this.dims.x;
                        while (n3 < this.dims.x) {
                            this.elements[n10][n9][n8][n2] = this.elements[n10][n9][n8][n];
                            ++n3;
                            ++n2;
                            ++n;
                        }
                    }
                }
            }
        }
        for (n10 = borders.c; n10 < n15; ++n10) {
            for (n9 = borders.t; n9 < n14; ++n9) {
                for (n8 = 0; n8 < borders.z; ++n8) {
                    n7 = n8 - borders.z;
                    n6 = n7 / n23;
                    n6 += n6 % n28;
                    n5 = borders.z + Math.abs(n7 - n6 * n23);
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n9][n8][n4] = this.elements[n10][n9][n5][n4];
                    }
                }
                for (n8 = n13; n8 < this.dims.z; ++n8) {
                    n7 = n8 - borders.z;
                    n6 = n7 / n23;
                    n6 += n6 % n28;
                    n5 = borders.z + Math.abs(n7 - n6 * n23);
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n9][n8][n4] = this.elements[n10][n9][n5][n4];
                    }
                }
            }
        }
        for (n10 = borders.c; n10 < n15; ++n10) {
            for (n9 = 0; n9 < borders.t; ++n9) {
                n8 = n9 - borders.t;
                n7 = n8 / n24;
                n7 += n7 % n29;
                n6 = borders.t + Math.abs(n8 - n7 * n24);
                for (n5 = 0; n5 < this.dims.z; ++n5) {
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n9][n5][n4] = this.elements[n10][n6][n5][n4];
                    }
                }
            }
            for (n9 = n14; n9 < this.dims.t; ++n9) {
                n8 = n9 - borders.t;
                n7 = n8 / n24;
                n7 += n7 % n29;
                n6 = borders.t + Math.abs(n8 - n7 * n24);
                for (n5 = 0; n5 < this.dims.z; ++n5) {
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n9][n5][n4] = this.elements[n10][n6][n5][n4];
                    }
                }
            }
        }
        for (n10 = 0; n10 < borders.c; ++n10) {
            n9 = n10 - borders.c;
            n8 = n9 / n25;
            n8 += n8 % n30;
            n7 = borders.c + Math.abs(n9 - n8 * n25);
            for (n6 = 0; n6 < this.dims.t; ++n6) {
                for (n5 = 0; n5 < this.dims.z; ++n5) {
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n6][n5][n4] = this.elements[n7][n6][n5][n4];
                    }
                }
            }
        }
        for (n10 = n15; n10 < this.dims.c; ++n10) {
            n9 = n10 - borders.c;
            n8 = n9 / n25;
            n8 += n8 % n30;
            n7 = borders.c + Math.abs(n9 - n8 * n25);
            for (n6 = 0; n6 < this.dims.t; ++n6) {
                for (n5 = 0; n5 < this.dims.z; ++n5) {
                    for (n4 = 0; n4 < n31; ++n4) {
                        this.elements[n10][n6][n5][n4] = this.elements[n7][n6][n5][n4];
                    }
                }
            }
        }
    }

    @Override
    public void set(Borders borders, double d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (borders.x > this.dims.x / 2 || borders.y > this.dims.y / 2 || borders.z > this.dims.z / 2 || borders.t > this.dims.t / 2 || borders.c > this.dims.c / 2) {
            throw new IllegalArgumentException("Border(s) too large");
        }
        int n7 = this.dims.c - borders.c;
        int n8 = this.dims.t - borders.t;
        int n9 = this.dims.z - borders.z;
        int n10 = this.dims.y - borders.y;
        int n11 = this.dims.x - borders.x;
        int n12 = this.dims.x * this.dims.y;
        short s = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
        for (n6 = 0; n6 < borders.c; ++n6) {
            for (n5 = 0; n5 < this.dims.t; ++n5) {
                for (n4 = 0; n4 < this.dims.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
            }
        }
        for (n6 = n7; n6 < this.dims.c; ++n6) {
            for (n5 = 0; n5 < this.dims.t; ++n5) {
                for (n4 = 0; n4 < this.dims.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
            }
        }
        for (n6 = borders.c; n6 < n7; ++n6) {
            for (n5 = 0; n5 < borders.t; ++n5) {
                for (n4 = 0; n4 < this.dims.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
            }
            for (n5 = n8; n5 < this.dims.t; ++n5) {
                for (n4 = 0; n4 < this.dims.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
            }
        }
        for (n6 = borders.c; n6 < n7; ++n6) {
            for (n5 = borders.t; n5 < n8; ++n5) {
                for (n4 = 0; n4 < borders.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
                for (n4 = n9; n4 < this.dims.z; ++n4) {
                    for (n3 = 0; n3 < n12; ++n3) {
                        this.elements[n6][n5][n4][n3] = s;
                    }
                }
            }
        }
        for (n6 = borders.c; n6 < n7; ++n6) {
            for (n5 = borders.t; n5 < n8; ++n5) {
                for (n4 = borders.z; n4 < n9; ++n4) {
                    n2 = 0;
                    for (n3 = 0; n3 < borders.y; ++n3) {
                        n = 0;
                        while (n < this.dims.x) {
                            this.elements[n6][n5][n4][n2] = s;
                            ++n;
                            ++n2;
                        }
                    }
                    n2 = n10 * this.dims.x;
                    for (n3 = n10; n3 < this.dims.y; ++n3) {
                        n = 0;
                        while (n < this.dims.x) {
                            this.elements[n6][n5][n4][n2] = s;
                            ++n;
                            ++n2;
                        }
                    }
                }
            }
        }
        for (n6 = borders.c; n6 < n7; ++n6) {
            for (n5 = borders.t; n5 < n8; ++n5) {
                for (n4 = borders.z; n4 < n9; ++n4) {
                    for (n3 = borders.y; n3 < n10; ++n3) {
                        n2 = 0;
                        n = n3 * this.dims.x;
                        while (n2 < borders.x) {
                            this.elements[n6][n5][n4][n] = s;
                            ++n2;
                            ++n;
                        }
                        n2 = n11;
                        n = n3 * this.dims.x + n11;
                        while (n2 < this.dims.x) {
                            this.elements[n6][n5][n4][n] = s;
                            ++n2;
                            ++n;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, double d) {
        this.elements[coordinates.c][coordinates.t][coordinates.z][coordinates.y * this.dims.x + coordinates.x] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
    }

    @Override
    public void set(Coordinates coordinates, double[] dArray) {
        switch (this.axes) {
            case 1: {
                int n;
                int n2 = 0;
                int n3 = coordinates.x;
                if (n3 < 0) {
                    n3 = 0;
                    n2 = -coordinates.x;
                }
                if ((n = coordinates.x + dArray.length) > this.dims.x) {
                    n = this.dims.x;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n4 = n3;
                int n5 = coordinates.y * this.dims.x + n3;
                int n6 = n2;
                while (n4 < n) {
                    double d = dArray[n6];
                    sArray[n5] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n4;
                    ++n5;
                    ++n6;
                }
                break;
            }
            case 2: {
                int n;
                int n7 = 0;
                int n8 = coordinates.y;
                if (n8 < 0) {
                    n8 = 0;
                    n7 = -coordinates.y;
                }
                if ((n = coordinates.y + dArray.length) > this.dims.y) {
                    n = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n9 = n8;
                int n10 = n8 * this.dims.x + coordinates.x;
                int n11 = n7;
                while (n9 < n) {
                    double d = dArray[n11];
                    sArray[n10] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n9;
                    n10 += this.dims.x;
                    ++n11;
                }
                break;
            }
            case 4: {
                int n;
                int n12 = 0;
                int n13 = coordinates.z;
                if (n13 < 0) {
                    n13 = 0;
                    n12 = -coordinates.z;
                }
                if ((n = coordinates.z + dArray.length) > this.dims.z) {
                    n = this.dims.z;
                }
                int n14 = coordinates.y * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n15 = n13;
                int n16 = n12;
                while (n15 < n) {
                    double d = dArray[n16];
                    sArray[n15][n14] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n15;
                    ++n16;
                }
                break;
            }
            case 8: {
                int n;
                int n17 = 0;
                int n18 = coordinates.t;
                if (n18 < 0) {
                    n18 = 0;
                    n17 = -coordinates.t;
                }
                if ((n = coordinates.t + dArray.length) > this.dims.t) {
                    n = this.dims.t;
                }
                int n19 = coordinates.y * this.dims.x + coordinates.x;
                int n20 = n18;
                int n21 = n17;
                while (n20 < n) {
                    double d = dArray[n21];
                    this.elements[coordinates.c][n20][coordinates.z][n19] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n20;
                    ++n21;
                }
                break;
            }
            case 16: {
                int n;
                int n22 = 0;
                int n23 = coordinates.c;
                if (n23 < 0) {
                    n23 = 0;
                    n22 = -coordinates.c;
                }
                if ((n = coordinates.c + dArray.length) > this.dims.c) {
                    n = this.dims.c;
                }
                int n24 = coordinates.y * this.dims.x + coordinates.x;
                int n25 = n23;
                int n26 = n22;
                while (n25 < n) {
                    double d = dArray[n26];
                    this.elements[n25][coordinates.t][coordinates.z][n24] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n25;
                    ++n26;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, double[][] dArray) {
        switch (this.axes) {
            case 3: {
                int n = 0;
                int n2 = 0;
                int n3 = coordinates.x;
                int n4 = coordinates.y;
                if (n3 < 0) {
                    n3 = 0;
                    n = -coordinates.x;
                }
                if (n4 < 0) {
                    n4 = 0;
                    n2 = -coordinates.y;
                }
                int n5 = coordinates.x + dArray[0].length;
                int n6 = coordinates.y + dArray.length;
                if (n5 > this.dims.x) {
                    n5 = this.dims.x;
                }
                if (n6 > this.dims.y) {
                    n6 = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n7 = n4;
                int n8 = n4 * this.dims.x + n3;
                int n9 = n2;
                while (n7 < n6) {
                    int n10 = n3;
                    int n11 = n8;
                    int n12 = n;
                    while (n10 < n5) {
                        double d = dArray[n9][n12];
                        sArray[n11] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n10;
                        ++n11;
                        ++n12;
                    }
                    ++n7;
                    n8 += this.dims.x;
                    ++n9;
                }
                break;
            }
            case 5: {
                int n = 0;
                int n13 = 0;
                int n14 = coordinates.x;
                int n15 = coordinates.z;
                if (n14 < 0) {
                    n14 = 0;
                    n = -coordinates.x;
                }
                if (n15 < 0) {
                    n15 = 0;
                    n13 = -coordinates.z;
                }
                int n16 = coordinates.x + dArray[0].length;
                int n17 = coordinates.z + dArray.length;
                if (n16 > this.dims.x) {
                    n16 = this.dims.x;
                }
                if (n17 > this.dims.z) {
                    n17 = this.dims.z;
                }
                int n18 = coordinates.y * this.dims.x + n14;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n19 = n15;
                int n20 = n13;
                while (n19 < n17) {
                    int n21 = n14;
                    int n22 = n18;
                    int n23 = n;
                    while (n21 < n16) {
                        double d = dArray[n20][n23];
                        sArray[n19][n22] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n21;
                        ++n22;
                        ++n23;
                    }
                    ++n19;
                    ++n20;
                }
                break;
            }
            case 9: {
                int n = 0;
                int n24 = 0;
                int n25 = coordinates.x;
                int n26 = coordinates.t;
                if (n25 < 0) {
                    n25 = 0;
                    n = -coordinates.x;
                }
                if (n26 < 0) {
                    n26 = 0;
                    n24 = -coordinates.t;
                }
                int n27 = coordinates.x + dArray[0].length;
                int n28 = coordinates.t + dArray.length;
                if (n27 > this.dims.x) {
                    n27 = this.dims.x;
                }
                if (n28 > this.dims.t) {
                    n28 = this.dims.t;
                }
                int n29 = coordinates.y * this.dims.x + n25;
                int n30 = n26;
                int n31 = n24;
                while (n30 < n28) {
                    int n32 = n25;
                    int n33 = n29;
                    int n34 = n;
                    while (n32 < n27) {
                        double d = dArray[n31][n34];
                        this.elements[coordinates.c][n30][coordinates.z][n33] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n32;
                        ++n33;
                        ++n34;
                    }
                    ++n30;
                    ++n31;
                }
                break;
            }
            case 6: {
                int n = 0;
                int n35 = 0;
                int n36 = coordinates.y;
                int n37 = coordinates.z;
                if (n36 < 0) {
                    n36 = 0;
                    n = -coordinates.y;
                }
                if (n37 < 0) {
                    n37 = 0;
                    n35 = -coordinates.z;
                }
                int n38 = coordinates.y + dArray[0].length;
                int n39 = coordinates.z + dArray.length;
                if (n38 > this.dims.y) {
                    n38 = this.dims.y;
                }
                if (n39 > this.dims.z) {
                    n39 = this.dims.z;
                }
                int n40 = n36 * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n41 = n37;
                int n42 = n35;
                while (n41 < n39) {
                    int n43 = n36;
                    int n44 = n40;
                    int n45 = n;
                    while (n43 < n38) {
                        double d = dArray[n42][n45];
                        sArray[n41][n44] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n43;
                        n44 += this.dims.x;
                        ++n45;
                    }
                    ++n41;
                    ++n42;
                }
                break;
            }
            case 10: {
                int n = 0;
                int n46 = 0;
                int n47 = coordinates.y;
                int n48 = coordinates.t;
                if (n47 < 0) {
                    n47 = 0;
                    n = -coordinates.y;
                }
                if (n48 < 0) {
                    n48 = 0;
                    n46 = -coordinates.t;
                }
                int n49 = coordinates.y + dArray[0].length;
                int n50 = coordinates.t + dArray.length;
                if (n49 > this.dims.y) {
                    n49 = this.dims.y;
                }
                if (n50 > this.dims.t) {
                    n50 = this.dims.t;
                }
                int n51 = n47 * this.dims.x + coordinates.x;
                int n52 = n48;
                int n53 = n46;
                while (n52 < n50) {
                    int n54 = n47;
                    int n55 = n51;
                    int n56 = n;
                    while (n54 < n49) {
                        double d = dArray[n53][n56];
                        this.elements[coordinates.c][n52][coordinates.z][n55] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n54;
                        n55 += this.dims.x;
                        ++n56;
                    }
                    ++n52;
                    ++n53;
                }
                break;
            }
            case 12: {
                int n = 0;
                int n57 = 0;
                int n58 = coordinates.z;
                int n59 = coordinates.t;
                if (n58 < 0) {
                    n58 = 0;
                    n = -coordinates.z;
                }
                if (n59 < 0) {
                    n59 = 0;
                    n57 = -coordinates.t;
                }
                int n60 = coordinates.z + dArray[0].length;
                int n61 = coordinates.t + dArray.length;
                if (n60 > this.dims.z) {
                    n60 = this.dims.z;
                }
                if (n61 > this.dims.t) {
                    n61 = this.dims.t;
                }
                int n62 = coordinates.y * this.dims.x + coordinates.x;
                int n63 = n59;
                int n64 = n57;
                while (n63 < n61) {
                    int n65 = n58;
                    int n66 = n;
                    while (n65 < n60) {
                        double d = dArray[n64][n66];
                        this.elements[coordinates.c][n63][n65][n62] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n65;
                        ++n66;
                    }
                    ++n63;
                    ++n64;
                }
                break;
            }
            case 17: {
                int n = 0;
                int n67 = 0;
                int n68 = coordinates.x;
                int n69 = coordinates.c;
                if (n68 < 0) {
                    n68 = 0;
                    n = -coordinates.x;
                }
                if (n69 < 0) {
                    n69 = 0;
                    n67 = -coordinates.c;
                }
                int n70 = coordinates.x + dArray[0].length;
                int n71 = coordinates.c + dArray.length;
                if (n70 > this.dims.x) {
                    n70 = this.dims.x;
                }
                if (n71 > this.dims.c) {
                    n71 = this.dims.c;
                }
                int n72 = coordinates.y * this.dims.x + n68;
                int n73 = n69;
                int n74 = n67;
                while (n73 < n71) {
                    int n75 = n68;
                    int n76 = n72;
                    int n77 = n;
                    while (n75 < n70) {
                        double d = dArray[n74][n77];
                        this.elements[n73][coordinates.t][coordinates.z][n76] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n75;
                        ++n76;
                        ++n77;
                    }
                    ++n73;
                    ++n74;
                }
                break;
            }
            case 18: {
                int n = 0;
                int n78 = 0;
                int n79 = coordinates.y;
                int n80 = coordinates.c;
                if (n79 < 0) {
                    n79 = 0;
                    n = -coordinates.y;
                }
                if (n80 < 0) {
                    n80 = 0;
                    n78 = -coordinates.c;
                }
                int n81 = coordinates.y + dArray[0].length;
                int n82 = coordinates.c + dArray.length;
                if (n81 > this.dims.y) {
                    n81 = this.dims.y;
                }
                if (n82 > this.dims.c) {
                    n82 = this.dims.c;
                }
                int n83 = n79 * this.dims.x + coordinates.x;
                int n84 = n80;
                int n85 = n78;
                while (n84 < n82) {
                    int n86 = n79;
                    int n87 = n83;
                    int n88 = n;
                    while (n86 < n81) {
                        double d = dArray[n85][n88];
                        this.elements[n84][coordinates.t][coordinates.z][n87] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n86;
                        n87 += this.dims.x;
                        ++n88;
                    }
                    ++n84;
                    ++n85;
                }
                break;
            }
            case 20: {
                int n = 0;
                int n89 = 0;
                int n90 = coordinates.z;
                int n91 = coordinates.c;
                if (n90 < 0) {
                    n90 = 0;
                    n = -coordinates.z;
                }
                if (n91 < 0) {
                    n91 = 0;
                    n89 = -coordinates.c;
                }
                int n92 = coordinates.z + dArray[0].length;
                int n93 = coordinates.c + dArray.length;
                if (n92 > this.dims.z) {
                    n92 = this.dims.z;
                }
                if (n93 > this.dims.c) {
                    n93 = this.dims.c;
                }
                int n94 = coordinates.y * this.dims.x + coordinates.x;
                int n95 = n91;
                int n96 = n89;
                while (n95 < n93) {
                    int n97 = n90;
                    int n98 = n;
                    while (n97 < n92) {
                        double d = dArray[n96][n98];
                        this.elements[n95][coordinates.t][n97][n94] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n97;
                        ++n98;
                    }
                    ++n95;
                    ++n96;
                }
                break;
            }
            case 24: {
                int n = 0;
                int n99 = 0;
                int n100 = coordinates.t;
                int n101 = coordinates.c;
                if (n100 < 0) {
                    n100 = 0;
                    n = -coordinates.t;
                }
                if (n101 < 0) {
                    n101 = 0;
                    n99 = -coordinates.c;
                }
                int n102 = coordinates.t + dArray[0].length;
                int n103 = coordinates.c + dArray.length;
                if (n102 > this.dims.t) {
                    n102 = this.dims.t;
                }
                if (n103 > this.dims.c) {
                    n103 = this.dims.c;
                }
                int n104 = coordinates.y * this.dims.x + coordinates.x;
                int n105 = n101;
                int n106 = n99;
                while (n105 < n103) {
                    int n107 = n100;
                    int n108 = n;
                    while (n107 < n102) {
                        double d = dArray[n106][n108];
                        this.elements[n105][n107][coordinates.z][n104] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n107;
                        ++n108;
                    }
                    ++n105;
                    ++n106;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, double[][][] dArray) {
        switch (this.axes) {
            case 7: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = coordinates.x;
                int n5 = coordinates.y;
                int n6 = coordinates.z;
                if (n4 < 0) {
                    n4 = 0;
                    n = -coordinates.x;
                }
                if (n5 < 0) {
                    n5 = 0;
                    n2 = -coordinates.y;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n3 = -coordinates.z;
                }
                int n7 = coordinates.x + dArray[0][0].length;
                int n8 = coordinates.y + dArray[0].length;
                int n9 = coordinates.z + dArray.length;
                if (n7 > this.dims.x) {
                    n7 = this.dims.x;
                }
                if (n8 > this.dims.y) {
                    n8 = this.dims.y;
                }
                if (n9 > this.dims.z) {
                    n9 = this.dims.z;
                }
                int n10 = n5 * this.dims.x + n4;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n11 = n6;
                int n12 = n3;
                while (n11 < n9) {
                    int n13 = n5;
                    int n14 = n10;
                    int n15 = n2;
                    while (n13 < n8) {
                        int n16 = n4;
                        int n17 = n14;
                        int n18 = n;
                        while (n16 < n7) {
                            double d = dArray[n12][n15][n18];
                            sArray[n11][n17] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n16;
                            ++n17;
                            ++n18;
                        }
                        ++n13;
                        n14 += this.dims.x;
                        ++n15;
                    }
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 11: {
                int n = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = coordinates.x;
                int n22 = coordinates.y;
                int n23 = coordinates.t;
                if (n21 < 0) {
                    n21 = 0;
                    n = -coordinates.x;
                }
                if (n22 < 0) {
                    n22 = 0;
                    n19 = -coordinates.y;
                }
                if (n23 < 0) {
                    n23 = 0;
                    n20 = -coordinates.t;
                }
                int n24 = coordinates.x + dArray[0][0].length;
                int n25 = coordinates.y + dArray[0].length;
                int n26 = coordinates.t + dArray.length;
                if (n24 > this.dims.x) {
                    n24 = this.dims.x;
                }
                if (n25 > this.dims.y) {
                    n25 = this.dims.y;
                }
                if (n26 > this.dims.t) {
                    n26 = this.dims.t;
                }
                int n27 = n22 * this.dims.x + n21;
                int n28 = n23;
                int n29 = n20;
                while (n28 < n26) {
                    int n30 = n22;
                    int n31 = n27;
                    int n32 = n19;
                    while (n30 < n25) {
                        int n33 = n21;
                        int n34 = n31;
                        int n35 = n;
                        while (n33 < n24) {
                            double d = dArray[n29][n32][n35];
                            this.elements[coordinates.c][n28][coordinates.z][n34] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n33;
                            ++n34;
                            ++n35;
                        }
                        ++n30;
                        n31 += this.dims.x;
                        ++n32;
                    }
                    ++n28;
                    ++n29;
                }
                break;
            }
            case 19: {
                int n = 0;
                int n36 = 0;
                int n37 = 0;
                int n38 = coordinates.x;
                int n39 = coordinates.y;
                int n40 = coordinates.c;
                if (n38 < 0) {
                    n38 = 0;
                    n = -coordinates.x;
                }
                if (n39 < 0) {
                    n39 = 0;
                    n36 = -coordinates.y;
                }
                if (n40 < 0) {
                    n40 = 0;
                    n37 = -coordinates.c;
                }
                int n41 = coordinates.x + dArray[0][0].length;
                int n42 = coordinates.y + dArray[0].length;
                int n43 = coordinates.c + dArray.length;
                if (n41 > this.dims.x) {
                    n41 = this.dims.x;
                }
                if (n42 > this.dims.y) {
                    n42 = this.dims.y;
                }
                if (n43 > this.dims.c) {
                    n43 = this.dims.c;
                }
                int n44 = n39 * this.dims.x + n38;
                int n45 = n40;
                int n46 = n37;
                while (n45 < n43) {
                    int n47 = n39;
                    int n48 = n44;
                    int n49 = n36;
                    while (n47 < n42) {
                        int n50 = n38;
                        int n51 = n48;
                        int n52 = n;
                        while (n50 < n41) {
                            double d = dArray[n46][n49][n52];
                            this.elements[n45][coordinates.t][coordinates.z][n51] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n50;
                            ++n51;
                            ++n52;
                        }
                        ++n47;
                        n48 += this.dims.x;
                        ++n49;
                    }
                    ++n45;
                    ++n46;
                }
                break;
            }
            case 13: {
                int n = 0;
                int n53 = 0;
                int n54 = 0;
                int n55 = coordinates.x;
                int n56 = coordinates.z;
                int n57 = coordinates.t;
                if (n55 < 0) {
                    n55 = 0;
                    n = -coordinates.x;
                }
                if (n56 < 0) {
                    n56 = 0;
                    n53 = -coordinates.z;
                }
                if (n57 < 0) {
                    n57 = 0;
                    n54 = -coordinates.t;
                }
                int n58 = coordinates.x + dArray[0][0].length;
                int n59 = coordinates.z + dArray[0].length;
                int n60 = coordinates.t + dArray.length;
                if (n58 > this.dims.x) {
                    n58 = this.dims.x;
                }
                if (n59 > this.dims.z) {
                    n59 = this.dims.z;
                }
                if (n60 > this.dims.t) {
                    n60 = this.dims.t;
                }
                int n61 = coordinates.y * this.dims.x + n55;
                int n62 = n57;
                int n63 = n54;
                while (n62 < n60) {
                    int n64 = n56;
                    int n65 = n53;
                    while (n64 < n59) {
                        int n66 = n55;
                        int n67 = n61;
                        int n68 = n;
                        while (n66 < n58) {
                            double d = dArray[n63][n65][n68];
                            this.elements[coordinates.c][n62][n64][n67] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n66;
                            ++n67;
                            ++n68;
                        }
                        ++n64;
                        ++n65;
                    }
                    ++n62;
                    ++n63;
                }
                break;
            }
            case 21: {
                int n = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n69 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n70 = -coordinates.c;
                }
                int n74 = coordinates.x + dArray[0][0].length;
                int n75 = coordinates.z + dArray[0].length;
                int n76 = coordinates.c + dArray.length;
                if (n74 > this.dims.x) {
                    n74 = this.dims.x;
                }
                if (n75 > this.dims.z) {
                    n75 = this.dims.z;
                }
                if (n76 > this.dims.c) {
                    n76 = this.dims.c;
                }
                int n77 = coordinates.y * this.dims.x + n71;
                int n78 = n73;
                int n79 = n70;
                while (n78 < n76) {
                    int n80 = n72;
                    int n81 = n69;
                    while (n80 < n75) {
                        int n82 = n71;
                        int n83 = n77;
                        int n84 = n;
                        while (n82 < n74) {
                            double d = dArray[n79][n81][n84];
                            this.elements[n78][coordinates.t][n80][n83] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n82;
                            ++n83;
                            ++n84;
                        }
                        ++n80;
                        ++n81;
                    }
                    ++n78;
                    ++n79;
                }
                break;
            }
            case 25: {
                int n = 0;
                int n85 = 0;
                int n86 = 0;
                int n87 = coordinates.x;
                int n88 = coordinates.t;
                int n89 = coordinates.c;
                if (n87 < 0) {
                    n87 = 0;
                    n = -coordinates.x;
                }
                if (n88 < 0) {
                    n88 = 0;
                    n85 = -coordinates.t;
                }
                if (n89 < 0) {
                    n89 = 0;
                    n86 = -coordinates.c;
                }
                int n90 = coordinates.x + dArray[0][0].length;
                int n91 = coordinates.t + dArray[0].length;
                int n92 = coordinates.c + dArray.length;
                if (n90 > this.dims.x) {
                    n90 = this.dims.x;
                }
                if (n91 > this.dims.t) {
                    n91 = this.dims.t;
                }
                if (n92 > this.dims.c) {
                    n92 = this.dims.c;
                }
                int n93 = coordinates.y * this.dims.x + n87;
                int n94 = n89;
                int n95 = n86;
                while (n94 < n92) {
                    int n96 = n88;
                    int n97 = n85;
                    while (n96 < n91) {
                        int n98 = n87;
                        int n99 = n93;
                        int n100 = n;
                        while (n98 < n90) {
                            double d = dArray[n95][n97][n100];
                            this.elements[n94][n96][coordinates.z][n99] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n98;
                            ++n99;
                            ++n100;
                        }
                        ++n96;
                        ++n97;
                    }
                    ++n94;
                    ++n95;
                }
                break;
            }
            case 14: {
                int n = 0;
                int n101 = 0;
                int n102 = 0;
                int n103 = coordinates.y;
                int n104 = coordinates.z;
                int n105 = coordinates.t;
                if (n103 < 0) {
                    n103 = 0;
                    n = -coordinates.y;
                }
                if (n104 < 0) {
                    n104 = 0;
                    n101 = -coordinates.z;
                }
                if (n105 < 0) {
                    n105 = 0;
                    n102 = -coordinates.t;
                }
                int n106 = coordinates.y + dArray[0][0].length;
                int n107 = coordinates.z + dArray[0].length;
                int n108 = coordinates.t + dArray.length;
                if (n106 > this.dims.y) {
                    n106 = this.dims.y;
                }
                if (n107 > this.dims.z) {
                    n107 = this.dims.z;
                }
                if (n108 > this.dims.t) {
                    n108 = this.dims.t;
                }
                int n109 = n103 * this.dims.x + coordinates.x;
                int n110 = n105;
                int n111 = n102;
                while (n110 < n108) {
                    int n112 = n104;
                    int n113 = n101;
                    while (n112 < n107) {
                        int n114 = n103;
                        int n115 = n109;
                        int n116 = n;
                        while (n114 < n106) {
                            double d = dArray[n111][n113][n116];
                            this.elements[coordinates.c][n110][n112][n115] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n114;
                            n115 += this.dims.x;
                            ++n116;
                        }
                        ++n112;
                        ++n113;
                    }
                    ++n110;
                    ++n111;
                }
                break;
            }
            case 22: {
                int n = 0;
                int n117 = 0;
                int n118 = 0;
                int n119 = coordinates.y;
                int n120 = coordinates.z;
                int n121 = coordinates.c;
                if (n119 < 0) {
                    n119 = 0;
                    n = -coordinates.y;
                }
                if (n120 < 0) {
                    n120 = 0;
                    n117 = -coordinates.z;
                }
                if (n121 < 0) {
                    n121 = 0;
                    n118 = -coordinates.c;
                }
                int n122 = coordinates.y + dArray[0][0].length;
                int n123 = coordinates.z + dArray[0].length;
                int n124 = coordinates.c + dArray.length;
                if (n122 > this.dims.y) {
                    n122 = this.dims.y;
                }
                if (n123 > this.dims.z) {
                    n123 = this.dims.z;
                }
                if (n124 > this.dims.c) {
                    n124 = this.dims.c;
                }
                int n125 = n119 * this.dims.x + coordinates.x;
                int n126 = n121;
                int n127 = n118;
                while (n126 < n124) {
                    int n128 = n120;
                    int n129 = n117;
                    while (n128 < n123) {
                        int n130 = n119;
                        int n131 = n125;
                        int n132 = n;
                        while (n130 < n122) {
                            double d = dArray[n127][n129][n132];
                            this.elements[n126][coordinates.t][n128][n131] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n130;
                            n131 += this.dims.x;
                            ++n132;
                        }
                        ++n128;
                        ++n129;
                    }
                    ++n126;
                    ++n127;
                }
                break;
            }
            case 26: {
                int n = 0;
                int n133 = 0;
                int n134 = 0;
                int n135 = coordinates.y;
                int n136 = coordinates.t;
                int n137 = coordinates.c;
                if (n135 < 0) {
                    n135 = 0;
                    n = -coordinates.y;
                }
                if (n136 < 0) {
                    n136 = 0;
                    n133 = -coordinates.t;
                }
                if (n137 < 0) {
                    n137 = 0;
                    n134 = -coordinates.c;
                }
                int n138 = coordinates.y + dArray[0][0].length;
                int n139 = coordinates.t + dArray[0].length;
                int n140 = coordinates.c + dArray.length;
                if (n138 > this.dims.y) {
                    n138 = this.dims.y;
                }
                if (n139 > this.dims.t) {
                    n139 = this.dims.t;
                }
                if (n140 > this.dims.c) {
                    n140 = this.dims.c;
                }
                int n141 = n135 * this.dims.x + coordinates.x;
                int n142 = n137;
                int n143 = n134;
                while (n142 < n140) {
                    int n144 = n136;
                    int n145 = n133;
                    while (n144 < n139) {
                        int n146 = n135;
                        int n147 = n141;
                        int n148 = n;
                        while (n146 < n138) {
                            double d = dArray[n143][n145][n148];
                            this.elements[n142][n144][coordinates.z][n147] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n146;
                            n147 += this.dims.x;
                            ++n148;
                        }
                        ++n144;
                        ++n145;
                    }
                    ++n142;
                    ++n143;
                }
                break;
            }
            case 28: {
                int n = 0;
                int n149 = 0;
                int n150 = 0;
                int n151 = coordinates.z;
                int n152 = coordinates.t;
                int n153 = coordinates.c;
                if (n151 < 0) {
                    n151 = 0;
                    n = -coordinates.z;
                }
                if (n152 < 0) {
                    n152 = 0;
                    n149 = -coordinates.t;
                }
                if (n153 < 0) {
                    n153 = 0;
                    n150 = -coordinates.c;
                }
                int n154 = coordinates.z + dArray[0][0].length;
                int n155 = coordinates.t + dArray[0].length;
                int n156 = coordinates.c + dArray.length;
                if (n154 > this.dims.z) {
                    n154 = this.dims.z;
                }
                if (n155 > this.dims.t) {
                    n155 = this.dims.t;
                }
                if (n156 > this.dims.c) {
                    n156 = this.dims.c;
                }
                int n157 = coordinates.y * this.dims.x + coordinates.x;
                int n158 = n153;
                int n159 = n150;
                while (n158 < n156) {
                    int n160 = n152;
                    int n161 = n149;
                    while (n160 < n155) {
                        int n162 = n151;
                        int n163 = n;
                        while (n162 < n154) {
                            double d = dArray[n159][n161][n163];
                            this.elements[n158][n160][n162][n157] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n162;
                            ++n163;
                        }
                        ++n160;
                        ++n161;
                    }
                    ++n158;
                    ++n159;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, double[][][][] dArray) {
        switch (this.axes) {
            case 15: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = coordinates.x;
                int n6 = coordinates.y;
                int n7 = coordinates.z;
                int n8 = coordinates.t;
                if (n5 < 0) {
                    n5 = 0;
                    n = -coordinates.x;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n2 = -coordinates.y;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n3 = -coordinates.z;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n4 = -coordinates.t;
                }
                int n9 = coordinates.x + dArray[0][0][0].length;
                int n10 = coordinates.y + dArray[0][0].length;
                int n11 = coordinates.z + dArray[0].length;
                int n12 = coordinates.t + dArray.length;
                if (n9 > this.dims.x) {
                    n9 = this.dims.x;
                }
                if (n10 > this.dims.y) {
                    n10 = this.dims.y;
                }
                if (n11 > this.dims.z) {
                    n11 = this.dims.z;
                }
                if (n12 > this.dims.t) {
                    n12 = this.dims.t;
                }
                int n13 = n6 * this.dims.x + n5;
                int n14 = n8;
                int n15 = n4;
                while (n14 < n12) {
                    int n16 = n7;
                    int n17 = n3;
                    while (n16 < n11) {
                        int n18 = n6;
                        int n19 = n13;
                        int n20 = n2;
                        while (n18 < n10) {
                            int n21 = n5;
                            int n22 = n19;
                            int n23 = n;
                            while (n21 < n9) {
                                double d = dArray[n15][n17][n20][n23];
                                this.elements[coordinates.c][n14][n16][n22] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n21;
                                ++n22;
                                ++n23;
                            }
                            ++n18;
                            n19 += this.dims.x;
                            ++n20;
                        }
                        ++n16;
                        ++n17;
                    }
                    ++n14;
                    ++n15;
                }
                break;
            }
            case 23: {
                int n = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = coordinates.x;
                int n28 = coordinates.y;
                int n29 = coordinates.z;
                int n30 = coordinates.c;
                if (n27 < 0) {
                    n27 = 0;
                    n = -coordinates.x;
                }
                if (n28 < 0) {
                    n28 = 0;
                    n24 = -coordinates.y;
                }
                if (n29 < 0) {
                    n29 = 0;
                    n25 = -coordinates.z;
                }
                if (n30 < 0) {
                    n30 = 0;
                    n26 = -coordinates.c;
                }
                int n31 = coordinates.x + dArray[0][0][0].length;
                int n32 = coordinates.y + dArray[0][0].length;
                int n33 = coordinates.z + dArray[0].length;
                int n34 = coordinates.c + dArray.length;
                if (n31 > this.dims.x) {
                    n31 = this.dims.x;
                }
                if (n32 > this.dims.y) {
                    n32 = this.dims.y;
                }
                if (n33 > this.dims.z) {
                    n33 = this.dims.z;
                }
                if (n34 > this.dims.c) {
                    n34 = this.dims.c;
                }
                int n35 = n28 * this.dims.x + n27;
                int n36 = n30;
                int n37 = n26;
                while (n36 < n34) {
                    int n38 = n29;
                    int n39 = n25;
                    while (n38 < n33) {
                        int n40 = n28;
                        int n41 = n35;
                        int n42 = n24;
                        while (n40 < n32) {
                            int n43 = n27;
                            int n44 = n41;
                            int n45 = n;
                            while (n43 < n31) {
                                double d = dArray[n37][n39][n42][n45];
                                this.elements[n36][coordinates.t][n38][n44] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n43;
                                ++n44;
                                ++n45;
                            }
                            ++n40;
                            n41 += this.dims.x;
                            ++n42;
                        }
                        ++n38;
                        ++n39;
                    }
                    ++n36;
                    ++n37;
                }
                break;
            }
            case 27: {
                int n = 0;
                int n46 = 0;
                int n47 = 0;
                int n48 = 0;
                int n49 = coordinates.x;
                int n50 = coordinates.y;
                int n51 = coordinates.t;
                int n52 = coordinates.c;
                if (n49 < 0) {
                    n49 = 0;
                    n = -coordinates.x;
                }
                if (n50 < 0) {
                    n50 = 0;
                    n46 = -coordinates.y;
                }
                if (n51 < 0) {
                    n51 = 0;
                    n47 = -coordinates.t;
                }
                if (n52 < 0) {
                    n52 = 0;
                    n48 = -coordinates.c;
                }
                int n53 = coordinates.x + dArray[0][0][0].length;
                int n54 = coordinates.y + dArray[0][0].length;
                int n55 = coordinates.t + dArray[0].length;
                int n56 = coordinates.c + dArray.length;
                if (n53 > this.dims.x) {
                    n53 = this.dims.x;
                }
                if (n54 > this.dims.y) {
                    n54 = this.dims.y;
                }
                if (n55 > this.dims.t) {
                    n55 = this.dims.t;
                }
                if (n56 > this.dims.c) {
                    n56 = this.dims.c;
                }
                int n57 = n50 * this.dims.x + n49;
                int n58 = n52;
                int n59 = n48;
                while (n58 < n56) {
                    int n60 = n51;
                    int n61 = n47;
                    while (n60 < n55) {
                        int n62 = n50;
                        int n63 = n57;
                        int n64 = n46;
                        while (n62 < n54) {
                            int n65 = n49;
                            int n66 = n63;
                            int n67 = n;
                            while (n65 < n53) {
                                double d = dArray[n59][n61][n64][n67];
                                this.elements[n58][n60][coordinates.z][n66] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n65;
                                ++n66;
                                ++n67;
                            }
                            ++n62;
                            n63 += this.dims.x;
                            ++n64;
                        }
                        ++n60;
                        ++n61;
                    }
                    ++n58;
                    ++n59;
                }
                break;
            }
            case 29: {
                int n = 0;
                int n68 = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.t;
                int n74 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n68 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n69 = -coordinates.t;
                }
                if (n74 < 0) {
                    n74 = 0;
                    n70 = -coordinates.c;
                }
                int n75 = coordinates.x + dArray[0][0][0].length;
                int n76 = coordinates.z + dArray[0][0].length;
                int n77 = coordinates.t + dArray[0].length;
                int n78 = coordinates.c + dArray.length;
                if (n75 > this.dims.x) {
                    n75 = this.dims.x;
                }
                if (n76 > this.dims.z) {
                    n76 = this.dims.z;
                }
                if (n77 > this.dims.t) {
                    n77 = this.dims.t;
                }
                if (n78 > this.dims.c) {
                    n78 = this.dims.c;
                }
                int n79 = coordinates.y * this.dims.x + n71;
                int n80 = n74;
                int n81 = n70;
                while (n80 < n78) {
                    int n82 = n73;
                    int n83 = n69;
                    while (n82 < n77) {
                        int n84 = n72;
                        int n85 = n68;
                        while (n84 < n76) {
                            int n86 = n71;
                            int n87 = n79;
                            int n88 = n;
                            while (n86 < n75) {
                                double d = dArray[n81][n83][n85][n88];
                                this.elements[n80][n82][n84][n87] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n86;
                                ++n87;
                                ++n88;
                            }
                            ++n84;
                            ++n85;
                        }
                        ++n82;
                        ++n83;
                    }
                    ++n80;
                    ++n81;
                }
                break;
            }
            case 30: {
                int n = 0;
                int n89 = 0;
                int n90 = 0;
                int n91 = 0;
                int n92 = coordinates.y;
                int n93 = coordinates.z;
                int n94 = coordinates.t;
                int n95 = coordinates.c;
                if (n92 < 0) {
                    n92 = 0;
                    n = -coordinates.y;
                }
                if (n93 < 0) {
                    n93 = 0;
                    n89 = -coordinates.z;
                }
                if (n94 < 0) {
                    n94 = 0;
                    n90 = -coordinates.t;
                }
                if (n95 < 0) {
                    n95 = 0;
                    n91 = -coordinates.c;
                }
                int n96 = coordinates.y + dArray[0][0][0].length;
                int n97 = coordinates.z + dArray[0][0].length;
                int n98 = coordinates.t + dArray[0].length;
                int n99 = coordinates.c + dArray.length;
                if (n96 > this.dims.y) {
                    n96 = this.dims.y;
                }
                if (n97 > this.dims.z) {
                    n97 = this.dims.z;
                }
                if (n98 > this.dims.t) {
                    n98 = this.dims.t;
                }
                if (n99 > this.dims.c) {
                    n99 = this.dims.c;
                }
                int n100 = n92 * this.dims.x + coordinates.x;
                int n101 = n95;
                int n102 = n91;
                while (n101 < n99) {
                    int n103 = n94;
                    int n104 = n90;
                    while (n103 < n98) {
                        int n105 = n93;
                        int n106 = n89;
                        while (n105 < n97) {
                            int n107 = n92;
                            int n108 = n100;
                            int n109 = n;
                            while (n107 < n96) {
                                double d = dArray[n102][n104][n106][n109];
                                this.elements[n101][n103][n105][n108] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n107;
                                n108 += this.dims.x;
                                ++n109;
                            }
                            ++n105;
                            ++n106;
                        }
                        ++n103;
                        ++n104;
                    }
                    ++n101;
                    ++n102;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, double[][][][][] dArray) {
        switch (this.axes) {
            case 31: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = coordinates.x;
                int n7 = coordinates.y;
                int n8 = coordinates.z;
                int n9 = coordinates.t;
                int n10 = coordinates.c;
                if (n6 < 0) {
                    n6 = 0;
                    n = -coordinates.x;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n2 = -coordinates.y;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n3 = -coordinates.z;
                }
                if (n9 < 0) {
                    n9 = 0;
                    n4 = -coordinates.t;
                }
                if (n10 < 0) {
                    n10 = 0;
                    n5 = -coordinates.c;
                }
                int n11 = coordinates.x + dArray[0][0][0][0].length;
                int n12 = coordinates.y + dArray[0][0][0].length;
                int n13 = coordinates.z + dArray[0][0].length;
                int n14 = coordinates.t + dArray[0].length;
                int n15 = coordinates.c + dArray.length;
                if (n11 > this.dims.x) {
                    n11 = this.dims.x;
                }
                if (n12 > this.dims.y) {
                    n12 = this.dims.y;
                }
                if (n13 > this.dims.z) {
                    n13 = this.dims.z;
                }
                if (n14 > this.dims.t) {
                    n14 = this.dims.t;
                }
                if (n15 > this.dims.c) {
                    n15 = this.dims.c;
                }
                int n16 = n7 * this.dims.x + n6;
                int n17 = n10;
                int n18 = n5;
                while (n17 < n15) {
                    int n19 = n9;
                    int n20 = n4;
                    while (n19 < n14) {
                        int n21 = n8;
                        int n22 = n3;
                        while (n21 < n13) {
                            int n23 = n7;
                            int n24 = n16;
                            int n25 = n2;
                            while (n23 < n12) {
                                int n26 = n6;
                                int n27 = n24;
                                int n28 = n;
                                while (n26 < n11) {
                                    double d = dArray[n18][n20][n22][n25][n28];
                                    this.elements[n17][n19][n21][n27] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                    ++n26;
                                    ++n27;
                                    ++n28;
                                }
                                ++n23;
                                n24 += this.dims.x;
                                ++n25;
                            }
                            ++n21;
                            ++n22;
                        }
                        ++n19;
                        ++n20;
                    }
                    ++n17;
                    ++n18;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, float[] fArray) {
        switch (this.axes) {
            case 1: {
                int n;
                int n2 = 0;
                int n3 = coordinates.x;
                if (n3 < 0) {
                    n3 = 0;
                    n2 = -coordinates.x;
                }
                if ((n = coordinates.x + fArray.length) > this.dims.x) {
                    n = this.dims.x;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n4 = n3;
                int n5 = coordinates.y * this.dims.x + n3;
                int n6 = n2;
                while (n4 < n) {
                    double d = fArray[n6];
                    sArray[n5] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n4;
                    ++n5;
                    ++n6;
                }
                break;
            }
            case 2: {
                int n;
                int n7 = 0;
                int n8 = coordinates.y;
                if (n8 < 0) {
                    n8 = 0;
                    n7 = -coordinates.y;
                }
                if ((n = coordinates.y + fArray.length) > this.dims.y) {
                    n = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n9 = n8;
                int n10 = n8 * this.dims.x + coordinates.x;
                int n11 = n7;
                while (n9 < n) {
                    double d = fArray[n11];
                    sArray[n10] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n9;
                    n10 += this.dims.x;
                    ++n11;
                }
                break;
            }
            case 4: {
                int n;
                int n12 = 0;
                int n13 = coordinates.z;
                if (n13 < 0) {
                    n13 = 0;
                    n12 = -coordinates.z;
                }
                if ((n = coordinates.z + fArray.length) > this.dims.z) {
                    n = this.dims.z;
                }
                int n14 = coordinates.y * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n15 = n13;
                int n16 = n12;
                while (n15 < n) {
                    double d = fArray[n16];
                    sArray[n15][n14] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n15;
                    ++n16;
                }
                break;
            }
            case 8: {
                int n;
                int n17 = 0;
                int n18 = coordinates.t;
                if (n18 < 0) {
                    n18 = 0;
                    n17 = -coordinates.t;
                }
                if ((n = coordinates.t + fArray.length) > this.dims.t) {
                    n = this.dims.t;
                }
                int n19 = coordinates.y * this.dims.x + coordinates.x;
                int n20 = n18;
                int n21 = n17;
                while (n20 < n) {
                    double d = fArray[n21];
                    this.elements[coordinates.c][n20][coordinates.z][n19] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n20;
                    ++n21;
                }
                break;
            }
            case 16: {
                int n;
                int n22 = 0;
                int n23 = coordinates.c;
                if (n23 < 0) {
                    n23 = 0;
                    n22 = -coordinates.c;
                }
                if ((n = coordinates.c + fArray.length) > this.dims.c) {
                    n = this.dims.c;
                }
                int n24 = coordinates.y * this.dims.x + coordinates.x;
                int n25 = n23;
                int n26 = n22;
                while (n25 < n) {
                    double d = fArray[n26];
                    this.elements[n25][coordinates.t][coordinates.z][n24] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                    ++n25;
                    ++n26;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, float[][] fArray) {
        switch (this.axes) {
            case 3: {
                int n = 0;
                int n2 = 0;
                int n3 = coordinates.x;
                int n4 = coordinates.y;
                if (n3 < 0) {
                    n3 = 0;
                    n = -coordinates.x;
                }
                if (n4 < 0) {
                    n4 = 0;
                    n2 = -coordinates.y;
                }
                int n5 = coordinates.x + fArray[0].length;
                int n6 = coordinates.y + fArray.length;
                if (n5 > this.dims.x) {
                    n5 = this.dims.x;
                }
                if (n6 > this.dims.y) {
                    n6 = this.dims.y;
                }
                short[] sArray = this.elements[coordinates.c][coordinates.t][coordinates.z];
                int n7 = n4;
                int n8 = n4 * this.dims.x + n3;
                int n9 = n2;
                while (n7 < n6) {
                    int n10 = n3;
                    int n11 = n8;
                    int n12 = n;
                    while (n10 < n5) {
                        double d = fArray[n9][n12];
                        sArray[n11] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n10;
                        ++n11;
                        ++n12;
                    }
                    ++n7;
                    n8 += this.dims.x;
                    ++n9;
                }
                break;
            }
            case 5: {
                int n = 0;
                int n13 = 0;
                int n14 = coordinates.x;
                int n15 = coordinates.z;
                if (n14 < 0) {
                    n14 = 0;
                    n = -coordinates.x;
                }
                if (n15 < 0) {
                    n15 = 0;
                    n13 = -coordinates.z;
                }
                int n16 = coordinates.x + fArray[0].length;
                int n17 = coordinates.z + fArray.length;
                if (n16 > this.dims.x) {
                    n16 = this.dims.x;
                }
                if (n17 > this.dims.z) {
                    n17 = this.dims.z;
                }
                int n18 = coordinates.y * this.dims.x + n14;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n19 = n15;
                int n20 = n13;
                while (n19 < n17) {
                    int n21 = n14;
                    int n22 = n18;
                    int n23 = n;
                    while (n21 < n16) {
                        double d = fArray[n20][n23];
                        sArray[n19][n22] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n21;
                        ++n22;
                        ++n23;
                    }
                    ++n19;
                    ++n20;
                }
                break;
            }
            case 9: {
                int n = 0;
                int n24 = 0;
                int n25 = coordinates.x;
                int n26 = coordinates.t;
                if (n25 < 0) {
                    n25 = 0;
                    n = -coordinates.x;
                }
                if (n26 < 0) {
                    n26 = 0;
                    n24 = -coordinates.t;
                }
                int n27 = coordinates.x + fArray[0].length;
                int n28 = coordinates.t + fArray.length;
                if (n27 > this.dims.x) {
                    n27 = this.dims.x;
                }
                if (n28 > this.dims.t) {
                    n28 = this.dims.t;
                }
                int n29 = coordinates.y * this.dims.x + n25;
                int n30 = n26;
                int n31 = n24;
                while (n30 < n28) {
                    int n32 = n25;
                    int n33 = n29;
                    int n34 = n;
                    while (n32 < n27) {
                        double d = fArray[n31][n34];
                        this.elements[coordinates.c][n30][coordinates.z][n33] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n32;
                        ++n33;
                        ++n34;
                    }
                    ++n30;
                    ++n31;
                }
                break;
            }
            case 6: {
                int n = 0;
                int n35 = 0;
                int n36 = coordinates.y;
                int n37 = coordinates.z;
                if (n36 < 0) {
                    n36 = 0;
                    n = -coordinates.y;
                }
                if (n37 < 0) {
                    n37 = 0;
                    n35 = -coordinates.z;
                }
                int n38 = coordinates.y + fArray[0].length;
                int n39 = coordinates.z + fArray.length;
                if (n38 > this.dims.y) {
                    n38 = this.dims.y;
                }
                if (n39 > this.dims.z) {
                    n39 = this.dims.z;
                }
                int n40 = n36 * this.dims.x + coordinates.x;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n41 = n37;
                int n42 = n35;
                while (n41 < n39) {
                    int n43 = n36;
                    int n44 = n40;
                    int n45 = n;
                    while (n43 < n38) {
                        double d = fArray[n42][n45];
                        sArray[n41][n44] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n43;
                        n44 += this.dims.x;
                        ++n45;
                    }
                    ++n41;
                    ++n42;
                }
                break;
            }
            case 10: {
                int n = 0;
                int n46 = 0;
                int n47 = coordinates.y;
                int n48 = coordinates.t;
                if (n47 < 0) {
                    n47 = 0;
                    n = -coordinates.y;
                }
                if (n48 < 0) {
                    n48 = 0;
                    n46 = -coordinates.t;
                }
                int n49 = coordinates.y + fArray[0].length;
                int n50 = coordinates.t + fArray.length;
                if (n49 > this.dims.y) {
                    n49 = this.dims.y;
                }
                if (n50 > this.dims.t) {
                    n50 = this.dims.t;
                }
                int n51 = n47 * this.dims.x + coordinates.x;
                int n52 = n48;
                int n53 = n46;
                while (n52 < n50) {
                    int n54 = n47;
                    int n55 = n51;
                    int n56 = n;
                    while (n54 < n49) {
                        double d = fArray[n53][n56];
                        this.elements[coordinates.c][n52][coordinates.z][n55] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n54;
                        n55 += this.dims.x;
                        ++n56;
                    }
                    ++n52;
                    ++n53;
                }
                break;
            }
            case 12: {
                int n = 0;
                int n57 = 0;
                int n58 = coordinates.z;
                int n59 = coordinates.t;
                if (n58 < 0) {
                    n58 = 0;
                    n = -coordinates.z;
                }
                if (n59 < 0) {
                    n59 = 0;
                    n57 = -coordinates.t;
                }
                int n60 = coordinates.z + fArray[0].length;
                int n61 = coordinates.t + fArray.length;
                if (n60 > this.dims.z) {
                    n60 = this.dims.z;
                }
                if (n61 > this.dims.t) {
                    n61 = this.dims.t;
                }
                int n62 = coordinates.y * this.dims.x + coordinates.x;
                int n63 = n59;
                int n64 = n57;
                while (n63 < n61) {
                    int n65 = n58;
                    int n66 = n;
                    while (n65 < n60) {
                        double d = fArray[n64][n66];
                        this.elements[coordinates.c][n63][n65][n62] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n65;
                        ++n66;
                    }
                    ++n63;
                    ++n64;
                }
                break;
            }
            case 17: {
                int n = 0;
                int n67 = 0;
                int n68 = coordinates.x;
                int n69 = coordinates.c;
                if (n68 < 0) {
                    n68 = 0;
                    n = -coordinates.x;
                }
                if (n69 < 0) {
                    n69 = 0;
                    n67 = -coordinates.c;
                }
                int n70 = coordinates.x + fArray[0].length;
                int n71 = coordinates.c + fArray.length;
                if (n70 > this.dims.x) {
                    n70 = this.dims.x;
                }
                if (n71 > this.dims.c) {
                    n71 = this.dims.c;
                }
                int n72 = coordinates.y * this.dims.x + n68;
                int n73 = n69;
                int n74 = n67;
                while (n73 < n71) {
                    int n75 = n68;
                    int n76 = n72;
                    int n77 = n;
                    while (n75 < n70) {
                        double d = fArray[n74][n77];
                        this.elements[n73][coordinates.t][coordinates.z][n76] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n75;
                        ++n76;
                        ++n77;
                    }
                    ++n73;
                    ++n74;
                }
                break;
            }
            case 18: {
                int n = 0;
                int n78 = 0;
                int n79 = coordinates.y;
                int n80 = coordinates.c;
                if (n79 < 0) {
                    n79 = 0;
                    n = -coordinates.y;
                }
                if (n80 < 0) {
                    n80 = 0;
                    n78 = -coordinates.c;
                }
                int n81 = coordinates.y + fArray[0].length;
                int n82 = coordinates.c + fArray.length;
                if (n81 > this.dims.y) {
                    n81 = this.dims.y;
                }
                if (n82 > this.dims.c) {
                    n82 = this.dims.c;
                }
                int n83 = n79 * this.dims.x + coordinates.x;
                int n84 = n80;
                int n85 = n78;
                while (n84 < n82) {
                    int n86 = n79;
                    int n87 = n83;
                    int n88 = n;
                    while (n86 < n81) {
                        double d = fArray[n85][n88];
                        this.elements[n84][coordinates.t][coordinates.z][n87] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n86;
                        n87 += this.dims.x;
                        ++n88;
                    }
                    ++n84;
                    ++n85;
                }
                break;
            }
            case 20: {
                int n = 0;
                int n89 = 0;
                int n90 = coordinates.z;
                int n91 = coordinates.c;
                if (n90 < 0) {
                    n90 = 0;
                    n = -coordinates.z;
                }
                if (n91 < 0) {
                    n91 = 0;
                    n89 = -coordinates.c;
                }
                int n92 = coordinates.z + fArray[0].length;
                int n93 = coordinates.c + fArray.length;
                if (n92 > this.dims.z) {
                    n92 = this.dims.z;
                }
                if (n93 > this.dims.c) {
                    n93 = this.dims.c;
                }
                int n94 = coordinates.y * this.dims.x + coordinates.x;
                int n95 = n91;
                int n96 = n89;
                while (n95 < n93) {
                    int n97 = n90;
                    int n98 = n;
                    while (n97 < n92) {
                        double d = fArray[n96][n98];
                        this.elements[n95][coordinates.t][n97][n94] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n97;
                        ++n98;
                    }
                    ++n95;
                    ++n96;
                }
                break;
            }
            case 24: {
                int n = 0;
                int n99 = 0;
                int n100 = coordinates.t;
                int n101 = coordinates.c;
                if (n100 < 0) {
                    n100 = 0;
                    n = -coordinates.t;
                }
                if (n101 < 0) {
                    n101 = 0;
                    n99 = -coordinates.c;
                }
                int n102 = coordinates.t + fArray[0].length;
                int n103 = coordinates.c + fArray.length;
                if (n102 > this.dims.t) {
                    n102 = this.dims.t;
                }
                if (n103 > this.dims.c) {
                    n103 = this.dims.c;
                }
                int n104 = coordinates.y * this.dims.x + coordinates.x;
                int n105 = n101;
                int n106 = n99;
                while (n105 < n103) {
                    int n107 = n100;
                    int n108 = n;
                    while (n107 < n102) {
                        double d = fArray[n106][n108];
                        this.elements[n105][n107][coordinates.z][n104] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                        ++n107;
                        ++n108;
                    }
                    ++n105;
                    ++n106;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, float[][][] fArray) {
        switch (this.axes) {
            case 7: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = coordinates.x;
                int n5 = coordinates.y;
                int n6 = coordinates.z;
                if (n4 < 0) {
                    n4 = 0;
                    n = -coordinates.x;
                }
                if (n5 < 0) {
                    n5 = 0;
                    n2 = -coordinates.y;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n3 = -coordinates.z;
                }
                int n7 = coordinates.x + fArray[0][0].length;
                int n8 = coordinates.y + fArray[0].length;
                int n9 = coordinates.z + fArray.length;
                if (n7 > this.dims.x) {
                    n7 = this.dims.x;
                }
                if (n8 > this.dims.y) {
                    n8 = this.dims.y;
                }
                if (n9 > this.dims.z) {
                    n9 = this.dims.z;
                }
                int n10 = n5 * this.dims.x + n4;
                short[][] sArray = this.elements[coordinates.c][coordinates.t];
                int n11 = n6;
                int n12 = n3;
                while (n11 < n9) {
                    int n13 = n5;
                    int n14 = n10;
                    int n15 = n2;
                    while (n13 < n8) {
                        int n16 = n4;
                        int n17 = n14;
                        int n18 = n;
                        while (n16 < n7) {
                            double d = fArray[n12][n15][n18];
                            sArray[n11][n17] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n16;
                            ++n17;
                            ++n18;
                        }
                        ++n13;
                        n14 += this.dims.x;
                        ++n15;
                    }
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 11: {
                int n = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = coordinates.x;
                int n22 = coordinates.y;
                int n23 = coordinates.t;
                if (n21 < 0) {
                    n21 = 0;
                    n = -coordinates.x;
                }
                if (n22 < 0) {
                    n22 = 0;
                    n19 = -coordinates.y;
                }
                if (n23 < 0) {
                    n23 = 0;
                    n20 = -coordinates.t;
                }
                int n24 = coordinates.x + fArray[0][0].length;
                int n25 = coordinates.y + fArray[0].length;
                int n26 = coordinates.t + fArray.length;
                if (n24 > this.dims.x) {
                    n24 = this.dims.x;
                }
                if (n25 > this.dims.y) {
                    n25 = this.dims.y;
                }
                if (n26 > this.dims.t) {
                    n26 = this.dims.t;
                }
                int n27 = n22 * this.dims.x + n21;
                int n28 = n23;
                int n29 = n20;
                while (n28 < n26) {
                    int n30 = n22;
                    int n31 = n27;
                    int n32 = n19;
                    while (n30 < n25) {
                        int n33 = n21;
                        int n34 = n31;
                        int n35 = n;
                        while (n33 < n24) {
                            double d = fArray[n29][n32][n35];
                            this.elements[coordinates.c][n28][coordinates.z][n34] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n33;
                            ++n34;
                            ++n35;
                        }
                        ++n30;
                        n31 += this.dims.x;
                        ++n32;
                    }
                    ++n28;
                    ++n29;
                }
                break;
            }
            case 19: {
                int n = 0;
                int n36 = 0;
                int n37 = 0;
                int n38 = coordinates.x;
                int n39 = coordinates.y;
                int n40 = coordinates.c;
                if (n38 < 0) {
                    n38 = 0;
                    n = -coordinates.x;
                }
                if (n39 < 0) {
                    n39 = 0;
                    n36 = -coordinates.y;
                }
                if (n40 < 0) {
                    n40 = 0;
                    n37 = -coordinates.c;
                }
                int n41 = coordinates.x + fArray[0][0].length;
                int n42 = coordinates.y + fArray[0].length;
                int n43 = coordinates.c + fArray.length;
                if (n41 > this.dims.x) {
                    n41 = this.dims.x;
                }
                if (n42 > this.dims.y) {
                    n42 = this.dims.y;
                }
                if (n43 > this.dims.c) {
                    n43 = this.dims.c;
                }
                int n44 = n39 * this.dims.x + n38;
                int n45 = n40;
                int n46 = n37;
                while (n45 < n43) {
                    int n47 = n39;
                    int n48 = n44;
                    int n49 = n36;
                    while (n47 < n42) {
                        int n50 = n38;
                        int n51 = n48;
                        int n52 = n;
                        while (n50 < n41) {
                            double d = fArray[n46][n49][n52];
                            this.elements[n45][coordinates.t][coordinates.z][n51] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n50;
                            ++n51;
                            ++n52;
                        }
                        ++n47;
                        n48 += this.dims.x;
                        ++n49;
                    }
                    ++n45;
                    ++n46;
                }
                break;
            }
            case 13: {
                int n = 0;
                int n53 = 0;
                int n54 = 0;
                int n55 = coordinates.x;
                int n56 = coordinates.z;
                int n57 = coordinates.t;
                if (n55 < 0) {
                    n55 = 0;
                    n = -coordinates.x;
                }
                if (n56 < 0) {
                    n56 = 0;
                    n53 = -coordinates.z;
                }
                if (n57 < 0) {
                    n57 = 0;
                    n54 = -coordinates.t;
                }
                int n58 = coordinates.x + fArray[0][0].length;
                int n59 = coordinates.z + fArray[0].length;
                int n60 = coordinates.t + fArray.length;
                if (n58 > this.dims.x) {
                    n58 = this.dims.x;
                }
                if (n59 > this.dims.z) {
                    n59 = this.dims.z;
                }
                if (n60 > this.dims.t) {
                    n60 = this.dims.t;
                }
                int n61 = coordinates.y * this.dims.x + n55;
                int n62 = n57;
                int n63 = n54;
                while (n62 < n60) {
                    int n64 = n56;
                    int n65 = n53;
                    while (n64 < n59) {
                        int n66 = n55;
                        int n67 = n61;
                        int n68 = n;
                        while (n66 < n58) {
                            double d = fArray[n63][n65][n68];
                            this.elements[coordinates.c][n62][n64][n67] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n66;
                            ++n67;
                            ++n68;
                        }
                        ++n64;
                        ++n65;
                    }
                    ++n62;
                    ++n63;
                }
                break;
            }
            case 21: {
                int n = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n69 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n70 = -coordinates.c;
                }
                int n74 = coordinates.x + fArray[0][0].length;
                int n75 = coordinates.z + fArray[0].length;
                int n76 = coordinates.c + fArray.length;
                if (n74 > this.dims.x) {
                    n74 = this.dims.x;
                }
                if (n75 > this.dims.z) {
                    n75 = this.dims.z;
                }
                if (n76 > this.dims.c) {
                    n76 = this.dims.c;
                }
                int n77 = coordinates.y * this.dims.x + n71;
                int n78 = n73;
                int n79 = n70;
                while (n78 < n76) {
                    int n80 = n72;
                    int n81 = n69;
                    while (n80 < n75) {
                        int n82 = n71;
                        int n83 = n77;
                        int n84 = n;
                        while (n82 < n74) {
                            double d = fArray[n79][n81][n84];
                            this.elements[n78][coordinates.t][n80][n83] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n82;
                            ++n83;
                            ++n84;
                        }
                        ++n80;
                        ++n81;
                    }
                    ++n78;
                    ++n79;
                }
                break;
            }
            case 25: {
                int n = 0;
                int n85 = 0;
                int n86 = 0;
                int n87 = coordinates.x;
                int n88 = coordinates.t;
                int n89 = coordinates.c;
                if (n87 < 0) {
                    n87 = 0;
                    n = -coordinates.x;
                }
                if (n88 < 0) {
                    n88 = 0;
                    n85 = -coordinates.t;
                }
                if (n89 < 0) {
                    n89 = 0;
                    n86 = -coordinates.c;
                }
                int n90 = coordinates.x + fArray[0][0].length;
                int n91 = coordinates.t + fArray[0].length;
                int n92 = coordinates.c + fArray.length;
                if (n90 > this.dims.x) {
                    n90 = this.dims.x;
                }
                if (n91 > this.dims.t) {
                    n91 = this.dims.t;
                }
                if (n92 > this.dims.c) {
                    n92 = this.dims.c;
                }
                int n93 = coordinates.y * this.dims.x + n87;
                int n94 = n89;
                int n95 = n86;
                while (n94 < n92) {
                    int n96 = n88;
                    int n97 = n85;
                    while (n96 < n91) {
                        int n98 = n87;
                        int n99 = n93;
                        int n100 = n;
                        while (n98 < n90) {
                            double d = fArray[n95][n97][n100];
                            this.elements[n94][n96][coordinates.z][n99] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n98;
                            ++n99;
                            ++n100;
                        }
                        ++n96;
                        ++n97;
                    }
                    ++n94;
                    ++n95;
                }
                break;
            }
            case 14: {
                int n = 0;
                int n101 = 0;
                int n102 = 0;
                int n103 = coordinates.y;
                int n104 = coordinates.z;
                int n105 = coordinates.t;
                if (n103 < 0) {
                    n103 = 0;
                    n = -coordinates.y;
                }
                if (n104 < 0) {
                    n104 = 0;
                    n101 = -coordinates.z;
                }
                if (n105 < 0) {
                    n105 = 0;
                    n102 = -coordinates.t;
                }
                int n106 = coordinates.y + fArray[0][0].length;
                int n107 = coordinates.z + fArray[0].length;
                int n108 = coordinates.t + fArray.length;
                if (n106 > this.dims.y) {
                    n106 = this.dims.y;
                }
                if (n107 > this.dims.z) {
                    n107 = this.dims.z;
                }
                if (n108 > this.dims.t) {
                    n108 = this.dims.t;
                }
                int n109 = n103 * this.dims.x + coordinates.x;
                int n110 = n105;
                int n111 = n102;
                while (n110 < n108) {
                    int n112 = n104;
                    int n113 = n101;
                    while (n112 < n107) {
                        int n114 = n103;
                        int n115 = n109;
                        int n116 = n;
                        while (n114 < n106) {
                            double d = fArray[n111][n113][n116];
                            this.elements[coordinates.c][n110][n112][n115] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n114;
                            n115 += this.dims.x;
                            ++n116;
                        }
                        ++n112;
                        ++n113;
                    }
                    ++n110;
                    ++n111;
                }
                break;
            }
            case 22: {
                int n = 0;
                int n117 = 0;
                int n118 = 0;
                int n119 = coordinates.y;
                int n120 = coordinates.z;
                int n121 = coordinates.c;
                if (n119 < 0) {
                    n119 = 0;
                    n = -coordinates.y;
                }
                if (n120 < 0) {
                    n120 = 0;
                    n117 = -coordinates.z;
                }
                if (n121 < 0) {
                    n121 = 0;
                    n118 = -coordinates.c;
                }
                int n122 = coordinates.y + fArray[0][0].length;
                int n123 = coordinates.z + fArray[0].length;
                int n124 = coordinates.c + fArray.length;
                if (n122 > this.dims.y) {
                    n122 = this.dims.y;
                }
                if (n123 > this.dims.z) {
                    n123 = this.dims.z;
                }
                if (n124 > this.dims.c) {
                    n124 = this.dims.c;
                }
                int n125 = n119 * this.dims.x + coordinates.x;
                int n126 = n121;
                int n127 = n118;
                while (n126 < n124) {
                    int n128 = n120;
                    int n129 = n117;
                    while (n128 < n123) {
                        int n130 = n119;
                        int n131 = n125;
                        int n132 = n;
                        while (n130 < n122) {
                            double d = fArray[n127][n129][n132];
                            this.elements[n126][coordinates.t][n128][n131] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n130;
                            n131 += this.dims.x;
                            ++n132;
                        }
                        ++n128;
                        ++n129;
                    }
                    ++n126;
                    ++n127;
                }
                break;
            }
            case 26: {
                int n = 0;
                int n133 = 0;
                int n134 = 0;
                int n135 = coordinates.y;
                int n136 = coordinates.t;
                int n137 = coordinates.c;
                if (n135 < 0) {
                    n135 = 0;
                    n = -coordinates.y;
                }
                if (n136 < 0) {
                    n136 = 0;
                    n133 = -coordinates.t;
                }
                if (n137 < 0) {
                    n137 = 0;
                    n134 = -coordinates.c;
                }
                int n138 = coordinates.y + fArray[0][0].length;
                int n139 = coordinates.t + fArray[0].length;
                int n140 = coordinates.c + fArray.length;
                if (n138 > this.dims.y) {
                    n138 = this.dims.y;
                }
                if (n139 > this.dims.t) {
                    n139 = this.dims.t;
                }
                if (n140 > this.dims.c) {
                    n140 = this.dims.c;
                }
                int n141 = n135 * this.dims.x + coordinates.x;
                int n142 = n137;
                int n143 = n134;
                while (n142 < n140) {
                    int n144 = n136;
                    int n145 = n133;
                    while (n144 < n139) {
                        int n146 = n135;
                        int n147 = n141;
                        int n148 = n;
                        while (n146 < n138) {
                            double d = fArray[n143][n145][n148];
                            this.elements[n142][n144][coordinates.z][n147] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n146;
                            n147 += this.dims.x;
                            ++n148;
                        }
                        ++n144;
                        ++n145;
                    }
                    ++n142;
                    ++n143;
                }
                break;
            }
            case 28: {
                int n = 0;
                int n149 = 0;
                int n150 = 0;
                int n151 = coordinates.z;
                int n152 = coordinates.t;
                int n153 = coordinates.c;
                if (n151 < 0) {
                    n151 = 0;
                    n = -coordinates.z;
                }
                if (n152 < 0) {
                    n152 = 0;
                    n149 = -coordinates.t;
                }
                if (n153 < 0) {
                    n153 = 0;
                    n150 = -coordinates.c;
                }
                int n154 = coordinates.z + fArray[0][0].length;
                int n155 = coordinates.t + fArray[0].length;
                int n156 = coordinates.c + fArray.length;
                if (n154 > this.dims.z) {
                    n154 = this.dims.z;
                }
                if (n155 > this.dims.t) {
                    n155 = this.dims.t;
                }
                if (n156 > this.dims.c) {
                    n156 = this.dims.c;
                }
                int n157 = coordinates.y * this.dims.x + coordinates.x;
                int n158 = n153;
                int n159 = n150;
                while (n158 < n156) {
                    int n160 = n152;
                    int n161 = n149;
                    while (n160 < n155) {
                        int n162 = n151;
                        int n163 = n;
                        while (n162 < n154) {
                            double d = fArray[n159][n161][n163];
                            this.elements[n158][n160][n162][n157] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                            ++n162;
                            ++n163;
                        }
                        ++n160;
                        ++n161;
                    }
                    ++n158;
                    ++n159;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, float[][][][] fArray) {
        switch (this.axes) {
            case 15: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = coordinates.x;
                int n6 = coordinates.y;
                int n7 = coordinates.z;
                int n8 = coordinates.t;
                if (n5 < 0) {
                    n5 = 0;
                    n = -coordinates.x;
                }
                if (n6 < 0) {
                    n6 = 0;
                    n2 = -coordinates.y;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n3 = -coordinates.z;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n4 = -coordinates.t;
                }
                int n9 = coordinates.x + fArray[0][0][0].length;
                int n10 = coordinates.y + fArray[0][0].length;
                int n11 = coordinates.z + fArray[0].length;
                int n12 = coordinates.t + fArray.length;
                if (n9 > this.dims.x) {
                    n9 = this.dims.x;
                }
                if (n10 > this.dims.y) {
                    n10 = this.dims.y;
                }
                if (n11 > this.dims.z) {
                    n11 = this.dims.z;
                }
                if (n12 > this.dims.t) {
                    n12 = this.dims.t;
                }
                int n13 = n6 * this.dims.x + n5;
                int n14 = n8;
                int n15 = n4;
                while (n14 < n12) {
                    int n16 = n7;
                    int n17 = n3;
                    while (n16 < n11) {
                        int n18 = n6;
                        int n19 = n13;
                        int n20 = n2;
                        while (n18 < n10) {
                            int n21 = n5;
                            int n22 = n19;
                            int n23 = n;
                            while (n21 < n9) {
                                double d = fArray[n15][n17][n20][n23];
                                this.elements[coordinates.c][n14][n16][n22] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n21;
                                ++n22;
                                ++n23;
                            }
                            ++n18;
                            n19 += this.dims.x;
                            ++n20;
                        }
                        ++n16;
                        ++n17;
                    }
                    ++n14;
                    ++n15;
                }
                break;
            }
            case 23: {
                int n = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = coordinates.x;
                int n28 = coordinates.y;
                int n29 = coordinates.z;
                int n30 = coordinates.c;
                if (n27 < 0) {
                    n27 = 0;
                    n = -coordinates.x;
                }
                if (n28 < 0) {
                    n28 = 0;
                    n24 = -coordinates.y;
                }
                if (n29 < 0) {
                    n29 = 0;
                    n25 = -coordinates.z;
                }
                if (n30 < 0) {
                    n30 = 0;
                    n26 = -coordinates.c;
                }
                int n31 = coordinates.x + fArray[0][0][0].length;
                int n32 = coordinates.y + fArray[0][0].length;
                int n33 = coordinates.z + fArray[0].length;
                int n34 = coordinates.c + fArray.length;
                if (n31 > this.dims.x) {
                    n31 = this.dims.x;
                }
                if (n32 > this.dims.y) {
                    n32 = this.dims.y;
                }
                if (n33 > this.dims.z) {
                    n33 = this.dims.z;
                }
                if (n34 > this.dims.c) {
                    n34 = this.dims.c;
                }
                int n35 = n28 * this.dims.x + n27;
                int n36 = n30;
                int n37 = n26;
                while (n36 < n34) {
                    int n38 = n29;
                    int n39 = n25;
                    while (n38 < n33) {
                        int n40 = n28;
                        int n41 = n35;
                        int n42 = n24;
                        while (n40 < n32) {
                            int n43 = n27;
                            int n44 = n41;
                            int n45 = n;
                            while (n43 < n31) {
                                double d = fArray[n37][n39][n42][n45];
                                this.elements[n36][coordinates.t][n38][n44] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n43;
                                ++n44;
                                ++n45;
                            }
                            ++n40;
                            n41 += this.dims.x;
                            ++n42;
                        }
                        ++n38;
                        ++n39;
                    }
                    ++n36;
                    ++n37;
                }
                break;
            }
            case 27: {
                int n = 0;
                int n46 = 0;
                int n47 = 0;
                int n48 = 0;
                int n49 = coordinates.x;
                int n50 = coordinates.y;
                int n51 = coordinates.t;
                int n52 = coordinates.c;
                if (n49 < 0) {
                    n49 = 0;
                    n = -coordinates.x;
                }
                if (n50 < 0) {
                    n50 = 0;
                    n46 = -coordinates.y;
                }
                if (n51 < 0) {
                    n51 = 0;
                    n47 = -coordinates.t;
                }
                if (n52 < 0) {
                    n52 = 0;
                    n48 = -coordinates.c;
                }
                int n53 = coordinates.x + fArray[0][0][0].length;
                int n54 = coordinates.y + fArray[0][0].length;
                int n55 = coordinates.t + fArray[0].length;
                int n56 = coordinates.c + fArray.length;
                if (n53 > this.dims.x) {
                    n53 = this.dims.x;
                }
                if (n54 > this.dims.y) {
                    n54 = this.dims.y;
                }
                if (n55 > this.dims.t) {
                    n55 = this.dims.t;
                }
                if (n56 > this.dims.c) {
                    n56 = this.dims.c;
                }
                int n57 = n50 * this.dims.x + n49;
                int n58 = n52;
                int n59 = n48;
                while (n58 < n56) {
                    int n60 = n51;
                    int n61 = n47;
                    while (n60 < n55) {
                        int n62 = n50;
                        int n63 = n57;
                        int n64 = n46;
                        while (n62 < n54) {
                            int n65 = n49;
                            int n66 = n63;
                            int n67 = n;
                            while (n65 < n53) {
                                double d = fArray[n59][n61][n64][n67];
                                this.elements[n58][n60][coordinates.z][n66] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n65;
                                ++n66;
                                ++n67;
                            }
                            ++n62;
                            n63 += this.dims.x;
                            ++n64;
                        }
                        ++n60;
                        ++n61;
                    }
                    ++n58;
                    ++n59;
                }
                break;
            }
            case 29: {
                int n = 0;
                int n68 = 0;
                int n69 = 0;
                int n70 = 0;
                int n71 = coordinates.x;
                int n72 = coordinates.z;
                int n73 = coordinates.t;
                int n74 = coordinates.c;
                if (n71 < 0) {
                    n71 = 0;
                    n = -coordinates.x;
                }
                if (n72 < 0) {
                    n72 = 0;
                    n68 = -coordinates.z;
                }
                if (n73 < 0) {
                    n73 = 0;
                    n69 = -coordinates.t;
                }
                if (n74 < 0) {
                    n74 = 0;
                    n70 = -coordinates.c;
                }
                int n75 = coordinates.x + fArray[0][0][0].length;
                int n76 = coordinates.z + fArray[0][0].length;
                int n77 = coordinates.t + fArray[0].length;
                int n78 = coordinates.c + fArray.length;
                if (n75 > this.dims.x) {
                    n75 = this.dims.x;
                }
                if (n76 > this.dims.z) {
                    n76 = this.dims.z;
                }
                if (n77 > this.dims.t) {
                    n77 = this.dims.t;
                }
                if (n78 > this.dims.c) {
                    n78 = this.dims.c;
                }
                int n79 = coordinates.y * this.dims.x + n71;
                int n80 = n74;
                int n81 = n70;
                while (n80 < n78) {
                    int n82 = n73;
                    int n83 = n69;
                    while (n82 < n77) {
                        int n84 = n72;
                        int n85 = n68;
                        while (n84 < n76) {
                            int n86 = n71;
                            int n87 = n79;
                            int n88 = n;
                            while (n86 < n75) {
                                double d = fArray[n81][n83][n85][n88];
                                this.elements[n80][n82][n84][n87] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n86;
                                ++n87;
                                ++n88;
                            }
                            ++n84;
                            ++n85;
                        }
                        ++n82;
                        ++n83;
                    }
                    ++n80;
                    ++n81;
                }
                break;
            }
            case 30: {
                int n = 0;
                int n89 = 0;
                int n90 = 0;
                int n91 = 0;
                int n92 = coordinates.y;
                int n93 = coordinates.z;
                int n94 = coordinates.t;
                int n95 = coordinates.c;
                if (n92 < 0) {
                    n92 = 0;
                    n = -coordinates.y;
                }
                if (n93 < 0) {
                    n93 = 0;
                    n89 = -coordinates.z;
                }
                if (n94 < 0) {
                    n94 = 0;
                    n90 = -coordinates.t;
                }
                if (n95 < 0) {
                    n95 = 0;
                    n91 = -coordinates.c;
                }
                int n96 = coordinates.y + fArray[0][0][0].length;
                int n97 = coordinates.z + fArray[0][0].length;
                int n98 = coordinates.t + fArray[0].length;
                int n99 = coordinates.c + fArray.length;
                if (n96 > this.dims.y) {
                    n96 = this.dims.y;
                }
                if (n97 > this.dims.z) {
                    n97 = this.dims.z;
                }
                if (n98 > this.dims.t) {
                    n98 = this.dims.t;
                }
                if (n99 > this.dims.c) {
                    n99 = this.dims.c;
                }
                int n100 = n92 * this.dims.x + coordinates.x;
                int n101 = n95;
                int n102 = n91;
                while (n101 < n99) {
                    int n103 = n94;
                    int n104 = n90;
                    while (n103 < n98) {
                        int n105 = n93;
                        int n106 = n89;
                        while (n105 < n97) {
                            int n107 = n92;
                            int n108 = n100;
                            int n109 = n;
                            while (n107 < n96) {
                                double d = fArray[n102][n104][n106][n109];
                                this.elements[n101][n103][n105][n108] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                ++n107;
                                n108 += this.dims.x;
                                ++n109;
                            }
                            ++n105;
                            ++n106;
                        }
                        ++n103;
                        ++n104;
                    }
                    ++n101;
                    ++n102;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }

    @Override
    public void set(Coordinates coordinates, float[][][][][] fArray) {
        switch (this.axes) {
            case 31: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = coordinates.x;
                int n7 = coordinates.y;
                int n8 = coordinates.z;
                int n9 = coordinates.t;
                int n10 = coordinates.c;
                if (n6 < 0) {
                    n6 = 0;
                    n = -coordinates.x;
                }
                if (n7 < 0) {
                    n7 = 0;
                    n2 = -coordinates.y;
                }
                if (n8 < 0) {
                    n8 = 0;
                    n3 = -coordinates.z;
                }
                if (n9 < 0) {
                    n9 = 0;
                    n4 = -coordinates.t;
                }
                if (n10 < 0) {
                    n10 = 0;
                    n5 = -coordinates.c;
                }
                int n11 = coordinates.x + fArray[0][0][0][0].length;
                int n12 = coordinates.y + fArray[0][0][0].length;
                int n13 = coordinates.z + fArray[0][0].length;
                int n14 = coordinates.t + fArray[0].length;
                int n15 = coordinates.c + fArray.length;
                if (n11 > this.dims.x) {
                    n11 = this.dims.x;
                }
                if (n12 > this.dims.y) {
                    n12 = this.dims.y;
                }
                if (n13 > this.dims.z) {
                    n13 = this.dims.z;
                }
                if (n14 > this.dims.t) {
                    n14 = this.dims.t;
                }
                if (n15 > this.dims.c) {
                    n15 = this.dims.c;
                }
                int n16 = n7 * this.dims.x + n6;
                int n17 = n10;
                int n18 = n5;
                while (n17 < n15) {
                    int n19 = n9;
                    int n20 = n4;
                    while (n19 < n14) {
                        int n21 = n8;
                        int n22 = n3;
                        while (n21 < n13) {
                            int n23 = n7;
                            int n24 = n16;
                            int n25 = n2;
                            while (n23 < n12) {
                                int n26 = n6;
                                int n27 = n24;
                                int n28 = n;
                                while (n26 < n11) {
                                    double d = fArray[n18][n20][n22][n25][n28];
                                    this.elements[n17][n19][n21][n27] = (short)FMath.round(d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d));
                                    ++n26;
                                    ++n27;
                                    ++n28;
                                }
                                ++n23;
                                n24 += this.dims.x;
                                ++n25;
                            }
                            ++n21;
                            ++n22;
                        }
                        ++n19;
                        ++n20;
                    }
                    ++n17;
                    ++n18;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of active axes");
            }
        }
    }
}

