/*
 * Decompiled with CFR 0.152.
 */
package imagescience.mesh;

import java.util.Vector;
import javax.vecmath.Point3f;

public class Cylinder {
    private Point3f[] v = null;
    private int[] t = null;
    private int lod = 0;
    private boolean cap = true;

    public Cylinder(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Level of detail less than 0");
        }
        this.lod = n;
        this.cap = bl;
        int n2 = 16 * (int)Math.pow(2.0, n);
        int n3 = bl ? 2 : 0;
        int n4 = 2 * n2 + n3;
        int n5 = 3 * (2 + n3) * n2;
        this.v = new Point3f[n4];
        int n6 = 0;
        this.t = new int[n5];
        int n7 = 0;
        if (bl) {
            this.v[n6++] = new Point3f(0.0f, 0.0f, 0.0f);
            this.v[n6++] = new Point3f(1.0f, 0.0f, 0.0f);
        }
        double d = Math.PI * 2 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d2 = (double)i * d;
            float f = (float)Math.cos(d2);
            float f2 = (float)Math.sin(d2);
            this.v[n6++] = new Point3f(0.0f, f, f2);
            this.v[n6++] = new Point3f(1.0f, f, f2);
            if (i <= 0) continue;
            this.t[n7++] = n6 - 4;
            this.t[n7++] = n6 - 2;
            this.t[n7++] = n6 - 3;
            this.t[n7++] = n6 - 3;
            this.t[n7++] = n6 - 2;
            this.t[n7++] = n6 - 1;
            if (!bl) continue;
            this.t[n7++] = n6 - 4;
            this.t[n7++] = 0;
            this.t[n7++] = n6 - 2;
            this.t[n7++] = n6 - 3;
            this.t[n7++] = n6 - 1;
            this.t[n7++] = 1;
        }
        this.t[n7++] = n6 - 2;
        this.t[n7++] = n3;
        this.t[n7++] = n6 - 1;
        this.t[n7++] = n6 - 1;
        this.t[n7++] = n3;
        this.t[n7++] = n3 + 1;
        if (bl) {
            this.t[n7++] = n6 - 2;
            this.t[n7++] = 0;
            this.t[n7++] = 2;
            this.t[n7++] = n6 - 1;
            this.t[n7++] = 3;
            this.t[n7++] = 1;
        }
    }

    public Vector<Point3f> render(Point3f point3f, float f, Point3f point3f2, float f2) {
        Object object;
        int n;
        if (f < 0.0f) {
            throw new IllegalArgumentException("Base radius less than 0");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("End radius less than 0");
        }
        int n2 = this.v.length;
        Point3f[] point3fArray = new Point3f[n2];
        double d = point3f2.x - point3f.x;
        double d2 = point3f2.y - point3f.y;
        double d3 = point3f2.z - point3f.z;
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d6 = Math.atan2(d2, d);
        double d7 = Math.atan2(d3, d4);
        float f3 = (float)Math.cos(d6);
        float f4 = (float)Math.sin(d6);
        float f5 = (float)Math.cos(d7);
        float f6 = (float)Math.sin(d7);
        if (this.cap) {
            point3fArray[0] = new Point3f(point3f);
            point3fArray[1] = new Point3f(point3f2);
        }
        int n3 = n = this.cap ? 2 : 0;
        while (n < n2) {
            object = new Point3f(this.v[n]);
            Point3f point3f3 = new Point3f(this.v[n + 1]);
            ((Point3f)object).x = (float)((double)((Point3f)object).x * d5);
            ((Point3f)object).y *= f;
            ((Point3f)object).z *= f;
            point3f3.x = (float)((double)point3f3.x * d5);
            point3f3.y *= f2;
            point3f3.z *= f2;
            float f7 = ((Point3f)object).x * f5 - ((Point3f)object).z * f6;
            float f8 = ((Point3f)object).z * f5 + ((Point3f)object).x * f6;
            ((Point3f)object).x = f7;
            ((Point3f)object).z = f8;
            float f9 = point3f3.x * f5 - point3f3.z * f6;
            float f10 = point3f3.z * f5 + point3f3.x * f6;
            point3f3.x = f9;
            point3f3.z = f10;
            f7 = ((Point3f)object).x * f3 - ((Point3f)object).y * f4;
            float f11 = ((Point3f)object).x * f4 + ((Point3f)object).y * f3;
            ((Point3f)object).x = f7;
            ((Point3f)object).y = f11;
            f9 = point3f3.x * f3 - point3f3.y * f4;
            float f12 = point3f3.x * f4 + point3f3.y * f3;
            point3f3.x = f9;
            point3f3.y = f12;
            ((Point3f)object).x += point3f.x;
            ((Point3f)object).y += point3f.y;
            ((Point3f)object).z += point3f.z;
            point3f3.x += point3f.x;
            point3f3.y += point3f.y;
            point3f3.z += point3f.z;
            point3fArray[n] = object;
            point3fArray[n + 1] = point3f3;
            n += 2;
        }
        n = this.t.length;
        object = new Vector(n);
        for (int i = 0; i < n; ++i) {
            ((Vector)object).add(point3fArray[this.t[i]]);
        }
        return object;
    }
}

