/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;
import imagescience.utility.FMath;

public class BinomialGenerator
implements RandomGenerator {
    private final int trials;
    private final double probability;
    private final UniformGenerator unigen;
    private int previousTrials = -1;
    private double previousProbability = -1.0;
    private double previousComp;
    private double previousLogProb;
    private double previousLogInvProb;

    public BinomialGenerator() {
        this(1, 0.5);
    }

    public BinomialGenerator(int n) {
        this(1, 0.5, n);
    }

    public BinomialGenerator(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of trials less than 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability outside range [0,1]");
        }
        this.trials = n;
        this.probability = d;
        this.unigen = new UniformGenerator();
    }

    public BinomialGenerator(int n, double d, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of trials less than 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability outside range [0,1]");
        }
        this.trials = n;
        this.probability = d;
        this.unigen = new UniformGenerator(n2);
    }

    @Override
    public double next() {
        return this.next(this.trials, this.probability);
    }

    public double next(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of trials less than 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability outside range [0,1]");
        }
        double d2 = d <= 0.5 ? d : 1.0 - d;
        double d3 = (double)n * d2;
        double d4 = 0.0;
        if (n < 25) {
            for (int i = 0; i < n; ++i) {
                if (!(this.unigen.next() < d2)) continue;
                d4 += 1.0;
            }
        } else if (d3 < 1.0) {
            double d5 = Math.exp(-d3);
            double d6 = 1.0;
            for (int i = 0; i <= n; ++i) {
                if (!((d6 *= this.unigen.next()) < d5)) continue;
                d4 = i <= n ? (double)i : (double)n;
                break;
            }
        } else {
            double d7;
            if (n != this.previousTrials) {
                this.previousComp = FMath.lngamma((double)n + 1.0);
                this.previousTrials = n;
            }
            if (d2 != this.previousProbability) {
                this.previousLogProb = Math.log(d2);
                this.previousLogInvProb = Math.log(1.0 - d2);
                this.previousProbability = d2;
            }
            double d8 = Math.sqrt(2.0 * d3 * (1.0 - d2));
            while (true) {
                double d9;
                if ((d7 = d8 * (d9 = Math.tan(Math.PI * this.unigen.next())) + d3) < 0.0 || d7 >= (double)n + 1.0) {
                    continue;
                }
                d7 = Math.floor(d7);
                if (!(this.unigen.next() > 1.2 * d8 * (1.0 + d9 * d9) * Math.exp(this.previousComp + d7 * this.previousLogProb + ((double)n - d7) * this.previousLogInvProb - FMath.lngamma(d7 + 1.0) - FMath.lngamma((double)n - d7 + 1.0)))) break;
            }
            d4 = d7;
        }
        if (d2 != d) {
            d4 = (double)n - d4;
        }
        return d4;
    }
}

