/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class Polygon
implements Shape {
    private static final int CONTOUR_RESOLUTION = 10;
    private static final int MINCAP = 10;
    private Point[] p = new Point[10];
    private int np = 0;

    public Polygon() {
    }

    public Polygon(Vector<Point> vector) {
        this.set(vector);
    }

    public Polygon(Polygon polygon) {
        this.np = polygon.np;
        int n = this.np + 1;
        if (n > this.p.length) {
            this.p = new Point[n + 10];
        }
        for (int i = 0; i < this.np; ++i) {
            this.p[i] = polygon.p[i].duplicate();
        }
        this.p[this.np] = this.p[0];
    }

    public void set(Vector<Point> vector) {
        if (vector == null) {
            throw new NullPointerException("Vertices is null");
        }
        this.np = vector.size();
        int n = this.np + 1;
        if (n > this.p.length) {
            this.p = new Point[n + 10];
        }
        for (int i = 0; i < this.np; ++i) {
            Point point = vector.get(i);
            if (point == null) {
                throw new NullPointerException("Vertex " + i + " is null");
            }
            this.p[i] = point;
        }
        this.p[this.np] = this.p[0];
    }

    public void vertices(Vector<Point> vector) {
        this.set(vector);
    }

    public Vector<Point> vertices() {
        Vector<Point> vector = new Vector<Point>(this.np);
        for (int i = 0; i < this.np; ++i) {
            vector.add(this.p[i]);
        }
        return vector;
    }

    @Override
    public Shape duplicate() {
        return new Polygon(this);
    }

    public void translate(double d, double d2) {
        for (int i = 0; i < this.np; ++i) {
            this.p[i].translate(d, d2);
        }
    }

    public double perimeter() {
        double d = 0.0;
        if (this.np > 1) {
            int n = 0;
            int n2 = 1;
            while (n2 <= this.np) {
                double d2 = this.p[n2].x - this.p[n].x;
                double d3 = this.p[n2].y - this.p[n].y;
                d += Math.sqrt(d2 * d2 + d3 * d3);
                ++n2;
                ++n;
            }
        }
        return d;
    }

    public double area() {
        double d = 0.0;
        if (this.np > 2) {
            int n = 0;
            int n2 = 1;
            while (n < this.np) {
                d += this.p[n].x * this.p[n2].y - this.p[n2].x * this.p[n].y;
                ++n;
                ++n2;
            }
        }
        return d < 0.0 ? -0.5 * d : 0.5 * d;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        if (this.np == 0) {
            return false;
        }
        if (this.p[0].y == d2 && this.p[0].x == d) {
            return true;
        }
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n2 < this.np) {
            if (this.p[n3].y == d2 && (this.p[n3].x == d || this.p[n2].y == d2 && this.p[n3].x > d == this.p[n2].x < d)) {
                return true;
            }
            if (this.p[n2].y < d2 != this.p[n3].y < d2) {
                if (this.p[n2].x >= d) {
                    if (this.p[n3].x > d) {
                        n = this.p[n3].y > this.p[n2].y ? ++n : --n;
                    } else {
                        d3 = (this.p[n2].x - d) * (this.p[n3].y - d2) - (this.p[n3].x - d) * (this.p[n2].y - d2);
                        if (d3 == 0.0) {
                            return true;
                        }
                        if (d3 > 0.0 == this.p[n3].y > this.p[n2].y) {
                            n = this.p[n3].y > this.p[n2].y ? ++n : --n;
                        }
                    }
                } else if (this.p[n3].x > d) {
                    d3 = (this.p[n2].x - d) * (this.p[n3].y - d2) - (this.p[n3].x - d) * (this.p[n2].y - d2);
                    if (d3 == 0.0) {
                        return true;
                    }
                    if (d3 > 0.0 == this.p[n3].y > this.p[n2].y) {
                        n = this.p[n3].y > this.p[n2].y ? ++n : --n;
                    }
                }
            }
            ++n2;
            ++n3;
        }
        return n != 0;
    }

    public GeneralPath contour() {
        GeneralPath generalPath = new GeneralPath();
        if (this.np > 0) {
            generalPath.moveTo((float)this.p[0].x, (float)this.p[0].y);
            for (int i = 0; i < this.np; ++i) {
                generalPath.lineTo((float)this.p[i].x, (float)this.p[i].y);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    @Override
    public Image bitmap(boolean bl) {
        Bounds bounds = this.bounds();
        int n = FMath.floor(bounds.lower.x);
        int n2 = FMath.floor(bounds.lower.y);
        int n3 = 1 + FMath.floor(bounds.upper.x) - n;
        int n4 = 1 + FMath.floor(bounds.upper.y) - n2;
        ByteImage byteImage = new ByteImage(new Dimensions(n3, n4));
        if (this.np > 2) {
            Coordinates coordinates = new Coordinates();
            double[] dArray = new double[n3];
            byteImage.axes(1);
            coordinates.y = 0;
            while (coordinates.y < n4) {
                double d = (double)(n2 + coordinates.y) + 0.5;
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = this.contains((double)(n + i) + 0.5, d) ? 255.0 : 0.0;
                }
                byteImage.set(coordinates, dArray);
                ++coordinates.y;
            }
            if (!bl) {
                double[] dArray2 = new double[10];
                for (int i = 0; i < 10; ++i) {
                    dArray2[i] = ((double)i + 1.0) / 11.0;
                }
                Coordinates coordinates2 = new Coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
                Coordinates coordinates3 = new Coordinates();
                Coordinates coordinates4 = new Coordinates();
                int n5 = 0;
                int n6 = 1;
                while (n5 < this.np) {
                    Point point = this.p[n5];
                    double d = this.p[n6].x - point.x;
                    double d2 = this.p[n6].y - point.y;
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    if (d3 > 0.0) {
                        int n7 = FMath.ceil(10.0 * d3);
                        double d4 = d / (double)n7;
                        double d5 = d2 / (double)n7;
                        for (int i = 0; i < n7; ++i) {
                            coordinates3.x = FMath.floor(point.x + (double)i * d4);
                            coordinates3.y = FMath.floor(point.y + (double)i * d5);
                            if (coordinates3.x == coordinates2.x && coordinates3.y == coordinates2.y) continue;
                            int n8 = 0;
                            for (int j = 0; j < 10; ++j) {
                                double d6 = (double)coordinates3.y + dArray2[j];
                                for (int k = 0; k < 10; ++k) {
                                    if (!this.contains((double)coordinates3.x + dArray2[k], d6)) continue;
                                    ++n8;
                                }
                            }
                            coordinates4.x = coordinates3.x - n;
                            coordinates4.y = coordinates3.y - n2;
                            byteImage.set(coordinates4, (double)(255 * n8) / 100.0);
                            coordinates2.x = coordinates3.x;
                            coordinates2.y = coordinates3.y;
                        }
                    }
                    ++n5;
                    ++n6;
                }
            }
        }
        return byteImage;
    }

    @Override
    public Bounds bounds() {
        Point point = new Point();
        Point point2 = new Point();
        if (this.np > 0) {
            point.x = point2.x = this.p[0].x;
            point.y = point2.y = this.p[0].y;
            for (int i = 1; i < this.np; ++i) {
                Point point3 = this.p[i];
                if (point3.x > point2.x) {
                    point2.x = point3.x;
                } else if (point3.x < point.x) {
                    point.x = point3.x;
                }
                if (point3.y > point2.y) {
                    point2.y = point3.y;
                    continue;
                }
                if (!(point3.y < point.y)) continue;
                point.y = point3.y;
            }
        }
        return new Bounds(point, point2);
    }

    @Override
    public boolean equals(Shape shape) {
        if (shape != null && shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            if (polygon.np == this.np) {
                for (int i = 0; i < this.np; ++i) {
                    if (polygon.p[i].equals(this.p[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean empty() {
        return this.area() == 0.0;
    }
}

