/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Rectangle
implements Shape {
    private double x = 0.0;
    private double y = 0.0;
    private double width = 1.0;
    private double height = 1.0;

    public Rectangle() {
    }

    public Rectangle(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Width less than 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Height less than 0");
        }
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public Rectangle(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public void x(double d) {
        this.x = d;
    }

    public void y(double d) {
        this.y = d;
    }

    public void width(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Width less than 0");
        }
        this.width = d;
    }

    public void height(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Height less than 0");
        }
        this.height = d;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public double perimeter() {
        return 2.0 * (this.width + this.height);
    }

    public double area() {
        return this.width * this.height;
    }

    public void position(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    @Override
    public Shape duplicate() {
        return new Rectangle(this);
    }

    public void set(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Width less than 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Height less than 0");
        }
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void size(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Width less than 0");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Height less than 0");
        }
        this.width = d;
        this.height = d2;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        return d3 >= 0.0 && d3 <= this.width && d4 >= 0.0 && d4 <= this.height;
    }

    public GeneralPath contour() {
        return new GeneralPath(new Rectangle2D.Double(this.x, this.y, this.width, this.height));
    }

    @Override
    public Image bitmap(boolean bl) {
        double d = this.x + this.width;
        double d2 = this.y + this.height;
        int n = FMath.floor(this.x);
        int n2 = FMath.floor(this.y);
        int n3 = 1 + FMath.floor(d) - n;
        int n4 = 1 + FMath.floor(d2) - n2;
        ByteImage byteImage = new ByteImage(new Dimensions(n3, n4));
        if (this.width > 0.0 && this.height > 0.0) {
            int n5;
            int n6;
            double[] dArray;
            int n7 = FMath.ceil(this.x);
            int n8 = FMath.ceil(this.y);
            int n9 = FMath.floor(d);
            int n10 = FMath.floor(d2);
            double d3 = FMath.min(n2 + 1, d2) - this.y;
            double d4 = d2 - FMath.max(n10, this.y);
            double d5 = FMath.min(n + 1, d) - this.x;
            double d6 = d - FMath.max(n9, this.x);
            Coordinates coordinates = new Coordinates();
            double d7 = 0.0;
            if (n9 > n7) {
                dArray = new double[n3];
                n6 = n7;
                n5 = n7 - n;
                while (n6 < n9) {
                    dArray[n5] = 255.0;
                    ++n6;
                    ++n5;
                }
                coordinates.y = n8 - n2;
                byteImage.axes(1);
                n6 = n8;
                while (n6 < n10) {
                    byteImage.set(coordinates, dArray);
                    ++n6;
                    ++coordinates.y;
                }
                if (this.y > (double)n2) {
                    d7 = 255.0 * d3;
                    if (bl) {
                        d7 = d3 >= 0.5 ? 255.0 : 0.0;
                    }
                    n6 = n7;
                    n5 = n7 - n;
                    while (n6 < n9) {
                        dArray[n5] = d7;
                        ++n6;
                        ++n5;
                    }
                    coordinates.y = 0;
                    byteImage.set(coordinates, dArray);
                }
                if (d2 > (double)n10) {
                    d7 = 255.0 * d4;
                    if (bl) {
                        d7 = d4 >= 0.5 ? 255.0 : 0.0;
                    }
                    n6 = n7;
                    n5 = n7 - n;
                    while (n6 < n9) {
                        dArray[n5] = d7;
                        ++n6;
                        ++n5;
                    }
                    coordinates.y = n10 - n2;
                    byteImage.set(coordinates, dArray);
                }
            }
            if (n10 > n8) {
                dArray = new double[n4];
                coordinates.y = 0;
                byteImage.axes(2);
                if (this.x > (double)n) {
                    d7 = 255.0 * d5;
                    if (bl) {
                        d7 = d5 >= 0.5 ? 255.0 : 0.0;
                    }
                    n6 = n8;
                    n5 = n8 - n2;
                    while (n6 < n10) {
                        dArray[n5] = d7;
                        ++n6;
                        ++n5;
                    }
                    coordinates.x = 0;
                    byteImage.set(coordinates, dArray);
                }
                if (d > (double)n9) {
                    d7 = 255.0 * d6;
                    if (bl) {
                        d7 = d6 >= 0.5 ? 255.0 : 0.0;
                    }
                    n6 = n8;
                    n5 = n8 - n2;
                    while (n6 < n10) {
                        dArray[n5] = d7;
                        ++n6;
                        ++n5;
                    }
                    coordinates.x = n9 - n;
                    byteImage.set(coordinates, dArray);
                }
                byteImage.axes(1);
            }
            coordinates.y = 0;
            coordinates.x = 0;
            d7 = 255.0 * d3 * d5;
            if (bl) {
                d7 = d3 * d5 >= 0.5 ? 255.0 : 0.0;
            }
            byteImage.set(coordinates, d7);
            coordinates.y = n10 - n2;
            d7 = 255.0 * d4 * d5;
            if (bl) {
                d7 = d4 * d5 >= 0.5 ? 255.0 : 0.0;
            }
            byteImage.set(coordinates, d7);
            coordinates.x = n9 - n;
            d7 = 255.0 * d4 * d6;
            if (bl) {
                d7 = d4 * d6 >= 0.5 ? 255.0 : 0.0;
            }
            byteImage.set(coordinates, d7);
            coordinates.y = 0;
            d7 = 255.0 * d3 * d6;
            if (bl) {
                d7 = d3 * d6 >= 0.5 ? 255.0 : 0.0;
            }
            byteImage.set(coordinates, d7);
        }
        return byteImage;
    }

    @Override
    public Bounds bounds() {
        Bounds bounds = new Bounds();
        bounds.lower.x = this.x;
        bounds.upper.x = this.x + this.width;
        bounds.lower.y = this.y;
        bounds.upper.y = this.y + this.height;
        return bounds;
    }

    @Override
    public boolean equals(Shape shape) {
        if (shape != null && shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            if (this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean empty() {
        return this.area() == 0.0;
    }
}

