/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class Region
implements Shape {
    private final Area area = new Area();

    public Region() {
    }

    public Region(Image image) {
        GeneralPath generalPath = new GeneralPath();
        Coordinates coordinates = new Coordinates();
        Dimensions dimensions = image.dimensions();
        double[] dArray = new double[dimensions.x];
        int n = image.axes();
        image.axes(1);
        coordinates.y = 0;
        while (coordinates.y < dimensions.y) {
            image.get(coordinates, dArray);
            int n2 = -1;
            for (int i = 0; i < dimensions.x; ++i) {
                if (dArray[i] > 0.0) {
                    if (n2 >= 0) continue;
                    n2 = i;
                    continue;
                }
                if (n2 < 0) continue;
                generalPath.moveTo(n2, coordinates.y);
                generalPath.lineTo(i, coordinates.y);
                generalPath.lineTo(i, coordinates.y + 1);
                generalPath.lineTo(n2, coordinates.y + 1);
                generalPath.closePath();
                n2 = -1;
            }
            if (n2 >= 0) {
                generalPath.moveTo(n2, coordinates.y);
                generalPath.lineTo(dimensions.x, coordinates.y);
                generalPath.lineTo(dimensions.x, coordinates.y + 1);
                generalPath.lineTo(n2, coordinates.y + 1);
                generalPath.closePath();
            }
            ++coordinates.y;
        }
        this.area.add(new Area(generalPath));
        image.axes(n);
    }

    public Region(Region region) {
        this.area.add(region.area);
    }

    public void add(Region region) {
        this.area.add(region.area);
    }

    public void exclusive(Region region) {
        this.area.exclusiveOr(region.area);
    }

    public void intersect(Region region) {
        this.area.intersect(region.area);
    }

    public void subtract(Region region) {
        this.area.subtract(region.area);
    }

    public void reset() {
        this.area.reset();
    }

    public double area() {
        int n = 0;
        Image image = this.bitmap(true);
        Coordinates coordinates = new Coordinates();
        Dimensions dimensions = image.dimensions();
        double[] dArray = new double[dimensions.x];
        image.axes(1);
        coordinates.y = 0;
        while (coordinates.y < dimensions.y) {
            image.get(coordinates, dArray);
            for (int i = 0; i < dimensions.x; ++i) {
                if (!(dArray[i] > 0.0)) continue;
                ++n;
            }
            ++coordinates.y;
        }
        return n;
    }

    @Override
    public Image bitmap(boolean bl) {
        Bounds bounds = this.bounds();
        int n = FMath.floor(bounds.lower.x);
        int n2 = FMath.floor(bounds.lower.y);
        int n3 = FMath.round(bounds.upper.x) - n;
        int n4 = FMath.round(bounds.upper.y) - n2;
        int n5 = n3 > 0 ? n3 : 1;
        int n6 = n4 > 0 ? n4 : 1;
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 255, 255));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-n, -n2);
        graphics2D.fill(affineTransform.createTransformedShape(this.contour()));
        WritableRaster writableRaster = bufferedImage.getRaster();
        double[] dArray = new double[n5];
        ByteImage byteImage = new ByteImage(new Dimensions(n5, n6));
        byteImage.axes(1);
        Coordinates coordinates = new Coordinates();
        coordinates.y = 0;
        while (coordinates.y < n6) {
            writableRaster.getPixels(0, coordinates.y, n5, 1, dArray);
            byteImage.set(coordinates, dArray);
            ++coordinates.y;
        }
        return byteImage;
    }

    public void translate(int n, int n2) {
        this.area.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2));
    }

    @Override
    public Shape duplicate() {
        return new Region(this);
    }

    @Override
    public boolean contains(Point point) {
        return this.area.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        return this.area.contains(d, d2);
    }

    public GeneralPath contour() {
        return new GeneralPath(this.area);
    }

    @Override
    public Bounds bounds() {
        Rectangle rectangle = this.area.getBounds();
        Bounds bounds = new Bounds();
        bounds.lower.x = rectangle.getMinX();
        bounds.upper.x = rectangle.getMaxX();
        bounds.lower.y = rectangle.getMinY();
        bounds.upper.y = rectangle.getMaxY();
        return bounds;
    }

    @Override
    public boolean equals(Shape shape) {
        return shape != null && shape instanceof Region && this.area.equals(((Region)shape).area);
    }

    @Override
    public boolean empty() {
        return this.area.isEmpty();
    }
}

