/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Borders;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.transform.Prefilter;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Scale {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int CUBIC = 2;
    public static final int BSPLINE3 = 3;
    public static final int OMOMS3 = 4;
    public static final int BSPLINE5 = 5;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private final Prefilter prefilter = new Prefilter();
    private Dimensions newdims;
    private Borders borders;
    private double[][] kernel;
    private int[] pos;
    private double xfactor;
    private double yfactor;
    private double zfactor;
    private double tfactor;
    private double cfactor;
    private double xshift;
    private double yshift;
    private double zshift;
    private double tshift;
    private double cshift;
    private int xscheme;
    private int yscheme;
    private int zscheme;
    private int tscheme;
    private int cscheme;
    private String component = "";

    public synchronized Image run(Image image, double d, double d2, double d3, double d4, double d5, int n) {
        this.messenger.log(ImageScience.prelude() + "Scale");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.initialize(image, d, d2, d3, d4, d5, n);
        this.messenger.log("Scaling " + image.type());
        Image image2 = null;
        if (image instanceof ColorImage) {
            this.messenger.log("Processing RGB-color components separately");
            ColorImage colorImage = (ColorImage)image;
            this.progressor.range(0.0, 0.33);
            this.component = " red component";
            this.messenger.log("Scaling" + this.component);
            colorImage.component(1);
            Image image3 = colorImage.get();
            image3 = this.scale(image3);
            ColorImage colorImage2 = new ColorImage(image3.dimensions());
            colorImage2.component(1);
            colorImage2.set(image3);
            this.progressor.range(0.33, 0.67);
            this.component = " green component";
            this.messenger.log("Scaling" + this.component);
            colorImage.component(2);
            image3 = colorImage.get();
            image3 = this.scale(image3);
            colorImage2.component(2);
            colorImage2.set(image3);
            this.progressor.range(0.67, 1.0);
            this.component = " blue component";
            this.messenger.log("Scaling" + this.component);
            colorImage.component(3);
            image3 = colorImage.get();
            image3 = this.scale(image3);
            colorImage2.component(3);
            colorImage2.set(image3);
            image2 = colorImage2;
        } else {
            this.component = "";
            this.progressor.range(0.0, 1.0);
            image2 = this.scale(image);
        }
        image2.name(image.name() + " scaled");
        image2.aspects(image.aspects().duplicate());
        timer.stop();
        return image2;
    }

    private Image scale(Image image) {
        int n;
        int n2;
        int n3;
        Coordinates coordinates;
        Coordinates coordinates2;
        double[] dArray;
        double[] dArray2;
        if (this.xfactor == 1.0 && this.yfactor == 1.0 && this.zfactor == 1.0 && this.tfactor == 1.0 && this.cfactor == 1.0) {
            this.messenger.log("All scaling factors are unity");
            this.messenger.log("Returning a copy of the input image");
            return image.duplicate();
        }
        Dimensions dimensions = image.dimensions();
        Image image2 = null;
        Image image3 = null;
        Image image4 = null;
        Image image5 = null;
        Image image6 = null;
        this.progressor.steps((this.xfactor != 1.0 ? dimensions.c * dimensions.t * dimensions.z * dimensions.y * this.newdims.x : 0) + (this.yfactor != 1.0 ? dimensions.c * dimensions.t * dimensions.z * this.newdims.y * this.newdims.x : 0) + (this.zfactor != 1.0 ? dimensions.c * dimensions.t * this.newdims.z * this.newdims.y * this.newdims.x : 0) + (this.tfactor != 1.0 ? dimensions.c * this.newdims.t * this.newdims.z * this.newdims.y * this.newdims.x : 0) + (this.cfactor != 1.0 ? this.newdims.c * this.newdims.t * this.newdims.z * this.newdims.y * this.newdims.x : 0));
        this.progressor.status("Scaling...");
        this.progressor.start();
        if (this.xfactor == 1.0) {
            this.messenger.log("Skipping scaling in x-dimension");
            image2 = image;
        } else {
            this.logus("Scaling" + this.component + " in x-dimension");
            this.initialize(this.xscheme, this.newdims.x, this.xfactor, this.xshift);
            dArray2 = new double[dimensions.x + 2 * this.borders.x];
            dArray = new double[this.newdims.x];
            coordinates2 = new Coordinates();
            coordinates2.x = -this.borders.x;
            coordinates = new Coordinates();
            n3 = dimensions.x + 2 * this.borders.x - 1;
            image2 = Image.create(new Dimensions(this.newdims.x, dimensions.y, dimensions.z, dimensions.t, dimensions.c), image.type());
            image2.axes(1);
            image.axes(1);
            switch (this.xscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        dArray[n2] = dArray2[this.pos[n2]];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[2];
                                    dArray2[n3] = dArray2[n3 - 2];
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        n = this.borders.x + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n] + this.kernel[n2][1] * dArray2[n + 1];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        n = this.borders.x + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.x);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        n = this.borders.x + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.x);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        n = this.borders.x + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in x-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.x);
                                    dArray2[0] = dArray2[6];
                                    dArray2[n3] = dArray2[n3 - 6];
                                    dArray2[1] = dArray2[5];
                                    dArray2[n3 - 1] = dArray2[n3 - 5];
                                    dArray2[2] = dArray2[4];
                                    dArray2[n3 - 2] = dArray2[n3 - 4];
                                    for (n2 = 0; n2 < this.newdims.x; ++n2) {
                                        n = this.borders.x + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 2] + this.kernel[n2][1] * dArray2[n - 1] + this.kernel[n2][2] * dArray2[n] + this.kernel[n2][3] * dArray2[n + 1] + this.kernel[n2][4] * dArray2[n + 2] + this.kernel[n2][5] * dArray2[n + 3];
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        if (this.yfactor == 1.0) {
            this.messenger.log("Skipping scaling in y-dimension");
            image3 = image2;
        } else {
            this.logus("Scaling" + this.component + " in y-dimension");
            this.initialize(this.yscheme, this.newdims.y, this.yfactor, this.yshift);
            dArray2 = new double[dimensions.y + 2 * this.borders.y];
            dArray = new double[this.newdims.y];
            coordinates2 = new Coordinates();
            coordinates2.y = -this.borders.y;
            coordinates = new Coordinates();
            n3 = dimensions.y + 2 * this.borders.y - 1;
            image3 = Image.create(new Dimensions(this.newdims.x, this.newdims.y, dimensions.z, dimensions.t, dimensions.c), image.type());
            image3.axes(2);
            image2.axes(2);
            switch (this.yscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        dArray[n2] = dArray2[this.pos[n2]];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[2];
                                    dArray2[n3] = dArray2[n3 - 2];
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        n = this.borders.y + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n] + this.kernel[n2][1] * dArray2[n + 1];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        n = this.borders.y + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.y);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        n = this.borders.y + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.y);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        n = this.borders.y + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in y-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.z = 0;
                            coordinates.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.y);
                                    dArray2[0] = dArray2[6];
                                    dArray2[n3] = dArray2[n3 - 6];
                                    dArray2[1] = dArray2[5];
                                    dArray2[n3 - 1] = dArray2[n3 - 5];
                                    dArray2[2] = dArray2[4];
                                    dArray2[n3 - 2] = dArray2[n3 - 4];
                                    for (n2 = 0; n2 < this.newdims.y; ++n2) {
                                        n = this.borders.y + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 2] + this.kernel[n2][1] * dArray2[n - 1] + this.kernel[n2][2] * dArray2[n] + this.kernel[n2][3] * dArray2[n + 1] + this.kernel[n2][4] * dArray2[n + 2] + this.kernel[n2][5] * dArray2[n + 3];
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        image2 = null;
        if (this.zfactor == 1.0) {
            this.messenger.log("Skipping scaling in z-dimension");
            image4 = image3;
        } else {
            this.logus("Scaling" + this.component + " in z-dimension");
            this.initialize(this.zscheme, this.newdims.z, this.zfactor, this.zshift);
            dArray2 = new double[dimensions.z + 2 * this.borders.z];
            dArray = new double[this.newdims.z];
            coordinates2 = new Coordinates();
            coordinates2.z = -this.borders.z;
            coordinates = new Coordinates();
            n3 = dimensions.z + 2 * this.borders.z - 1;
            image4 = Image.create(new Dimensions(this.newdims.x, this.newdims.y, this.newdims.z, dimensions.t, dimensions.c), image.type());
            image4.axes(4);
            image3.axes(4);
            switch (this.zscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        dArray[n2] = dArray2[this.pos[n2]];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[2];
                                    dArray2[n3] = dArray2[n3 - 2];
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        n = this.borders.z + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n] + this.kernel[n2][1] * dArray2[n + 1];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        n = this.borders.z + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.z);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        n = this.borders.z + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.z);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        n = this.borders.z + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in z-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.t = 0;
                        coordinates.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image3.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.z);
                                    dArray2[0] = dArray2[6];
                                    dArray2[n3] = dArray2[n3 - 6];
                                    dArray2[1] = dArray2[5];
                                    dArray2[n3 - 1] = dArray2[n3 - 5];
                                    dArray2[2] = dArray2[4];
                                    dArray2[n3 - 2] = dArray2[n3 - 4];
                                    for (n2 = 0; n2 < this.newdims.z; ++n2) {
                                        n = this.borders.z + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 2] + this.kernel[n2][1] * dArray2[n - 1] + this.kernel[n2][2] * dArray2[n] + this.kernel[n2][3] * dArray2[n + 1] + this.kernel[n2][4] * dArray2[n + 2] + this.kernel[n2][5] * dArray2[n + 3];
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.z);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        image3 = null;
        if (this.tfactor == 1.0) {
            this.messenger.log("Skipping scaling in t-dimension");
            image5 = image4;
        } else {
            this.logus("Scaling" + this.component + " in t-dimension");
            this.initialize(this.tscheme, this.newdims.t, this.tfactor, this.tshift);
            dArray2 = new double[dimensions.t + 2 * this.borders.t];
            dArray = new double[this.newdims.t];
            coordinates2 = new Coordinates();
            coordinates2.t = -this.borders.t;
            coordinates = new Coordinates();
            n3 = dimensions.t + 2 * this.borders.t - 1;
            image5 = Image.create(new Dimensions(this.newdims.x, this.newdims.y, this.newdims.z, this.newdims.t, dimensions.c), image.type());
            image5.axes(8);
            image4.axes(8);
            switch (this.tscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        dArray[n2] = dArray2[this.pos[n2]];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[2];
                                    dArray2[n3] = dArray2[n3 - 2];
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        n = this.borders.t + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n] + this.kernel[n2][1] * dArray2[n + 1];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        n = this.borders.t + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.t);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        n = this.borders.t + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.t);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        n = this.borders.t + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in t-dimension");
                    coordinates2.c = 0;
                    coordinates.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image4.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.t);
                                    dArray2[0] = dArray2[6];
                                    dArray2[n3] = dArray2[n3 - 6];
                                    dArray2[1] = dArray2[5];
                                    dArray2[n3 - 1] = dArray2[n3 - 5];
                                    dArray2[2] = dArray2[4];
                                    dArray2[n3 - 2] = dArray2[n3 - 4];
                                    for (n2 = 0; n2 < this.newdims.t; ++n2) {
                                        n = this.borders.t + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 2] + this.kernel[n2][1] * dArray2[n - 1] + this.kernel[n2][2] * dArray2[n] + this.kernel[n2][3] * dArray2[n + 1] + this.kernel[n2][4] * dArray2[n + 2] + this.kernel[n2][5] * dArray2[n + 3];
                                    }
                                    image5.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.t);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        image4 = null;
        if (this.cfactor == 1.0) {
            this.messenger.log("Skipping scaling in c-dimension");
            image6 = image5;
        } else {
            this.logus("Scaling" + this.component + " in c-dimension");
            this.initialize(this.cscheme, this.newdims.c, this.cfactor, this.cshift);
            dArray2 = new double[dimensions.c + 2 * this.borders.c];
            dArray = new double[this.newdims.c];
            coordinates2 = new Coordinates();
            coordinates2.c = -this.borders.c;
            coordinates = new Coordinates();
            n3 = dimensions.c + 2 * this.borders.c - 1;
            image6 = Image.create(this.newdims, image.type());
            image6.axes(16);
            image5.axes(16);
            switch (this.cscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        dArray[n2] = dArray2[this.pos[n2]];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[2];
                                    dArray2[n3] = dArray2[n3 - 2];
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        n = this.borders.c + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n] + this.kernel[n2][1] * dArray2[n + 1];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        n = this.borders.c + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.c);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        n = this.borders.c + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.c);
                                    dArray2[0] = dArray2[4];
                                    dArray2[n3] = dArray2[n3 - 4];
                                    dArray2[1] = dArray2[3];
                                    dArray2[n3 - 1] = dArray2[n3 - 3];
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        n = this.borders.c + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 1] + this.kernel[n2][1] * dArray2[n] + this.kernel[n2][2] * dArray2[n + 1] + this.kernel[n2][3] * dArray2[n + 2];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in c-dimension");
                    coordinates2.t = 0;
                    coordinates.t = 0;
                    while (coordinates2.t < this.newdims.t) {
                        coordinates2.z = 0;
                        coordinates.z = 0;
                        while (coordinates2.z < this.newdims.z) {
                            coordinates2.y = 0;
                            coordinates.y = 0;
                            while (coordinates2.y < this.newdims.y) {
                                coordinates2.x = 0;
                                coordinates.x = 0;
                                while (coordinates2.x < this.newdims.x) {
                                    image5.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.c);
                                    dArray2[0] = dArray2[6];
                                    dArray2[n3] = dArray2[n3 - 6];
                                    dArray2[1] = dArray2[5];
                                    dArray2[n3 - 1] = dArray2[n3 - 5];
                                    dArray2[2] = dArray2[4];
                                    dArray2[n3 - 2] = dArray2[n3 - 4];
                                    for (n2 = 0; n2 < this.newdims.c; ++n2) {
                                        n = this.borders.c + this.pos[n2];
                                        dArray[n2] = this.kernel[n2][0] * dArray2[n - 2] + this.kernel[n2][1] * dArray2[n - 1] + this.kernel[n2][2] * dArray2[n] + this.kernel[n2][3] * dArray2[n + 1] + this.kernel[n2][4] * dArray2[n + 2] + this.kernel[n2][5] * dArray2[n + 3];
                                    }
                                    image6.set(coordinates, dArray);
                                    this.progressor.step(this.newdims.c);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.y;
                                ++coordinates.y;
                            }
                            ++coordinates2.z;
                            ++coordinates.z;
                        }
                        ++coordinates2.t;
                        ++coordinates.t;
                    }
                    break;
                }
            }
        }
        this.progressor.stop();
        return image6;
    }

    private void initialize(int n, int n2, double d, double d2) {
        this.pos = new int[n2];
        switch (n) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    this.pos[i] = FMath.round((double)i / d + d2);
                }
                break;
            }
            case 1: {
                this.kernel = new double[n2][2];
                for (int i = 0; i < n2; ++i) {
                    double d3 = (double)i / d + d2;
                    this.pos[i] = FMath.floor(d3);
                    this.kernel[i][1] = d3 - (double)this.pos[i];
                    this.kernel[i][0] = 1.0 - this.kernel[i][1];
                }
                break;
            }
            case 2: {
                this.kernel = new double[n2][4];
                for (int i = 0; i < n2; ++i) {
                    double d4 = (double)i / d + d2;
                    this.pos[i] = FMath.floor(d4);
                    double d5 = d4 - (double)this.pos[i];
                    double d6 = 1.0 - d5;
                    this.kernel[i][0] = -0.5 * d5 * d6 * d6;
                    this.kernel[i][1] = 1.0 + (1.5 * d5 - 2.5) * d5 * d5;
                    this.kernel[i][2] = 1.0 + (1.5 * d6 - 2.5) * d6 * d6;
                    this.kernel[i][3] = -0.5 * d6 * d5 * d5;
                }
                break;
            }
            case 3: {
                this.kernel = new double[n2][4];
                for (int i = 0; i < n2; ++i) {
                    double d7 = (double)i / d + d2;
                    this.pos[i] = FMath.floor(d7);
                    double d8 = d7 - (double)this.pos[i];
                    double d9 = 1.0 - d8;
                    this.kernel[i][0] = 0.16666666666666666 * d9 * d9 * d9;
                    this.kernel[i][1] = 0.6666666666666666 + (0.5 * d8 - 1.0) * d8 * d8;
                    this.kernel[i][2] = 0.6666666666666666 + (0.5 * d9 - 1.0) * d9 * d9;
                    this.kernel[i][3] = 0.16666666666666666 * d8 * d8 * d8;
                }
                break;
            }
            case 4: {
                this.kernel = new double[n2][4];
                for (int i = 0; i < n2; ++i) {
                    double d10 = (double)i / d + d2;
                    this.pos[i] = FMath.floor(d10);
                    double d11 = d10 - (double)this.pos[i];
                    double d12 = 1.0 - d11;
                    this.kernel[i][0] = d12 * (0.023809523809523808 + 0.16666666666666666 * d12 * d12);
                    this.kernel[i][1] = 0.6190476190476191 + d11 * (0.07142857142857142 + d11 * (0.5 * d11 - 1.0));
                    this.kernel[i][2] = 0.6190476190476191 + d12 * (0.07142857142857142 + d12 * (0.5 * d12 - 1.0));
                    this.kernel[i][3] = d11 * (0.023809523809523808 + 0.16666666666666666 * d11 * d11);
                }
                break;
            }
            case 5: {
                this.kernel = new double[n2][6];
                for (int i = 0; i < n2; ++i) {
                    double d13 = (double)i / d + d2;
                    this.pos[i] = FMath.floor(d13);
                    double d14 = d13 - (double)this.pos[i];
                    double d15 = d14 * d14;
                    double d16 = 1.0 - d14;
                    double d17 = d16 * d16;
                    this.kernel[i][0] = 0.008333333333333333 * d17 * d17 * d16;
                    this.kernel[i][1] = 0.008333333333333333 + 0.041666666666666664 * d16 * (1.0 + d16 * (2.0 + d16 * (2.0 + d16 - d17)));
                    this.kernel[i][2] = 0.55 + d15 * ((0.25 - 0.08333333333333333 * d14) * d15 - 0.5);
                    this.kernel[i][3] = 0.55 + d17 * ((0.25 - 0.08333333333333333 * d16) * d17 - 0.5);
                    this.kernel[i][4] = 0.008333333333333333 + 0.041666666666666664 * d14 * (1.0 + d14 * (2.0 + d14 * (2.0 + d14 - d15)));
                    this.kernel[i][5] = 0.008333333333333333 * d15 * d15 * d14;
                }
                break;
            }
        }
    }

    private void initialize(Image image, double d, double d2, double d3, double d4, double d5, int n) {
        if (image.aspects().x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (image.aspects().y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (image.aspects().z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        this.xfactor = d;
        if (d <= 0.0) {
            throw new IllegalArgumentException("Scaling factor in x-dimension less than or equal to 0");
        }
        this.yfactor = d2;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Scaling factor in y-dimension less than or equal to 0");
        }
        this.zfactor = d3;
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Scaling factor in z-dimension less than or equal to 0");
        }
        this.tfactor = d4;
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Scaling factor in t-dimension less than or equal to 0");
        }
        this.cfactor = d5;
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("Scaling factor in c-dimension less than or equal to 0");
        }
        this.messenger.log("Scaling factors: (x,y,z,t,c) = (" + d + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        int n2 = FMath.round((double)dimensions.x * d);
        int n3 = FMath.round((double)dimensions.y * d2);
        int n4 = FMath.round((double)dimensions.z * d3);
        int n5 = FMath.round((double)dimensions.t * d4);
        int n6 = FMath.round((double)dimensions.c * d5);
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        if (n6 == 0) {
            n6 = 1;
        }
        this.newdims = new Dimensions(n2, n3, n4, n5, n6);
        this.messenger.log("Output image dimensions: (x,y,z,t,c) = (" + this.newdims.x + "," + this.newdims.y + "," + this.newdims.z + "," + this.newdims.t + "," + this.newdims.c + ")");
        this.xshift = 0.5 * ((double)(dimensions.x - 1) - (double)(this.newdims.x - 1) / d);
        this.yshift = 0.5 * ((double)(dimensions.y - 1) - (double)(this.newdims.y - 1) / d2);
        this.zshift = 0.5 * ((double)(dimensions.z - 1) - (double)(this.newdims.z - 1) / d3);
        this.tshift = 0.5 * ((double)(dimensions.t - 1) - (double)(this.newdims.t - 1) / d4);
        this.cshift = 0.5 * ((double)(dimensions.c - 1) - (double)(this.newdims.c - 1) / d5);
        this.messenger.log("Selecting " + this.schemes(n));
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Non-supported interpolation scheme");
        }
        this.tscheme = this.cscheme = n;
        this.zscheme = this.cscheme;
        this.yscheme = this.cscheme;
        this.xscheme = this.cscheme;
        if (d != 1.0 && dimensions.x == 1 && this.xscheme >= 1) {
            this.messenger.log("Size of input image in x-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in x-dimension");
            this.xscheme = 0;
        } else if (d != 1.0 && dimensions.x < 4 && this.xscheme >= 2) {
            this.messenger.log("Size of input image in x-dimension too small");
            this.messenger.log("Using linear interpolation in x-dimension");
            this.xscheme = 1;
        }
        if (d2 != 1.0 && dimensions.y == 1 && this.yscheme >= 1) {
            this.messenger.log("Size of input image in y-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in y-dimension");
            this.yscheme = 0;
        } else if (d2 != 1.0 && dimensions.y < 4 && this.yscheme >= 2) {
            this.messenger.log("Size of input image in y-dimension too small");
            this.messenger.log("Using linear interpolation in y-dimension");
            this.yscheme = 1;
        }
        if (d3 != 1.0 && dimensions.z == 1 && this.zscheme >= 1) {
            this.messenger.log("Size of input image in z-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in z-dimension");
            this.zscheme = 0;
        } else if (d3 != 1.0 && dimensions.z < 4 && this.zscheme >= 2) {
            this.messenger.log("Size of input image in z-dimension too small");
            this.messenger.log("Using linear interpolation in z-dimension");
            this.zscheme = 1;
        }
        if (d4 != 1.0 && dimensions.t == 1 && this.tscheme >= 1) {
            this.messenger.log("Size of input image in t-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in t-dimension");
            this.tscheme = 0;
        } else if (d4 != 1.0 && dimensions.t < 4 && this.tscheme >= 2) {
            this.messenger.log("Size of input image in t-dimension too small");
            this.messenger.log("Using linear interpolation in t-dimension");
            this.tscheme = 1;
        }
        if (d5 != 1.0 && dimensions.c == 1 && this.cscheme >= 1) {
            this.messenger.log("Size of input image in c-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in c-dimension");
            this.cscheme = 0;
        } else if (d5 != 1.0 && dimensions.c < 4 && this.cscheme >= 2) {
            this.messenger.log("Size of input image in c-dimension too small");
            this.messenger.log("Using linear interpolation in c-dimension");
            this.cscheme = 1;
        }
        int n7 = 0;
        switch (this.xscheme) {
            case 0: {
                n7 = 0;
                break;
            }
            case 1: {
                n7 = 1;
                break;
            }
            case 2: {
                n7 = 2;
                break;
            }
            case 3: {
                n7 = 2;
                break;
            }
            case 4: {
                n7 = 2;
                break;
            }
            case 5: {
                n7 = 3;
            }
        }
        int n8 = 0;
        switch (this.yscheme) {
            case 0: {
                n8 = 0;
                break;
            }
            case 1: {
                n8 = 1;
                break;
            }
            case 2: {
                n8 = 2;
                break;
            }
            case 3: {
                n8 = 2;
                break;
            }
            case 4: {
                n8 = 2;
                break;
            }
            case 5: {
                n8 = 3;
            }
        }
        int n9 = 0;
        switch (this.zscheme) {
            case 0: {
                n9 = 0;
                break;
            }
            case 1: {
                n9 = 1;
                break;
            }
            case 2: {
                n9 = 2;
                break;
            }
            case 3: {
                n9 = 2;
                break;
            }
            case 4: {
                n9 = 2;
                break;
            }
            case 5: {
                n9 = 3;
            }
        }
        int n10 = 0;
        switch (this.tscheme) {
            case 0: {
                n10 = 0;
                break;
            }
            case 1: {
                n10 = 1;
                break;
            }
            case 2: {
                n10 = 2;
                break;
            }
            case 3: {
                n10 = 2;
                break;
            }
            case 4: {
                n10 = 2;
                break;
            }
            case 5: {
                n10 = 3;
            }
        }
        int n11 = 0;
        switch (this.cscheme) {
            case 0: {
                n11 = 0;
                break;
            }
            case 1: {
                n11 = 1;
                break;
            }
            case 2: {
                n11 = 2;
                break;
            }
            case 3: {
                n11 = 2;
                break;
            }
            case 4: {
                n11 = 2;
                break;
            }
            case 5: {
                n11 = 3;
            }
        }
        this.borders = new Borders(n7, n8, n9, n10, n11);
    }

    private String schemes(int n) {
        switch (n) {
            case 0: {
                return "nearest-neighbor interpolation";
            }
            case 1: {
                return "linear interpolation";
            }
            case 2: {
                return "cubic convolution interpolation";
            }
            case 3: {
                return "cubic B-spline interpolation";
            }
            case 4: {
                return "cubic O-MOMS interpolation";
            }
            case 5: {
                return "quintic B-spline interpolation";
            }
        }
        return "unknown interpolation";
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

