/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Borders;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.transform.Prefilter;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Translate {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int CUBIC = 2;
    public static final int BSPLINE3 = 3;
    public static final int OMOMS3 = 4;
    public static final int BSPLINE5 = 5;
    public double background = 0.0;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private final Prefilter prefilter = new Prefilter();
    private Borders borders;
    private double dx;
    private double dy;
    private double dz;
    private int xscheme;
    private int yscheme;
    private int zscheme;
    private String component = "";
    private static final double D1O2 = 0.5;
    private static final double D1O4 = 0.25;
    private static final double D1O6 = 0.16666666666666666;
    private static final double D1O12 = 0.08333333333333333;
    private static final double D1O14 = 0.07142857142857142;
    private static final double D1O24 = 0.041666666666666664;
    private static final double D1O42 = 0.023809523809523808;
    private static final double D1O120 = 0.008333333333333333;
    private static final double D2O3 = 0.6666666666666666;
    private static final double D3O2 = 1.5;
    private static final double D5O2 = 2.5;
    private static final double D11O20 = 0.55;
    private static final double D13O21 = 0.6190476190476191;

    public synchronized Image run(Image image, double d, double d2, double d3, int n) {
        this.messenger.log(ImageScience.prelude() + "Translate");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.initialize(image, d, d2, d3, n);
        this.messenger.log("Translating " + image.type());
        Image image2 = null;
        if (image instanceof ColorImage) {
            this.messenger.log("Processing RGB-color components separately");
            ColorImage colorImage = (ColorImage)image;
            this.progressor.range(0.0, 0.33);
            this.component = " red component";
            this.messenger.log("Translating" + this.component);
            colorImage.component(1);
            Image image3 = colorImage.get();
            image3 = this.translate(image3);
            ColorImage colorImage2 = new ColorImage(image3.dimensions());
            colorImage2.component(1);
            colorImage2.set(image3);
            this.progressor.range(0.33, 0.67);
            this.component = " green component";
            this.messenger.log("Translating" + this.component);
            colorImage.component(2);
            image3 = colorImage.get();
            image3 = this.translate(image3);
            colorImage2.component(2);
            colorImage2.set(image3);
            this.progressor.range(0.67, 1.0);
            this.component = " blue component";
            this.messenger.log("Translating" + this.component);
            colorImage.component(3);
            image3 = colorImage.get();
            image3 = this.translate(image3);
            colorImage2.component(3);
            colorImage2.set(image3);
            image2 = colorImage2;
        } else {
            this.component = "";
            this.progressor.range(0.0, 1.0);
            image2 = this.translate(image);
        }
        image2.name(image.name() + " translated");
        image2.aspects(image.aspects().duplicate());
        timer.stop();
        return image2;
    }

    private Image translate(Image image) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        double d;
        double d2;
        int n13;
        int n14;
        Coordinates coordinates;
        Coordinates coordinates2;
        double[] dArray;
        double[] dArray2;
        if (this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0) {
            this.messenger.log("All translation distances are zero");
            this.messenger.log("Returning a copy of the input image");
            return image.duplicate();
        }
        Dimensions dimensions = image.dimensions();
        int n15 = dimensions.c * dimensions.t * dimensions.z * dimensions.y * dimensions.x;
        Image image2 = null;
        Image image3 = null;
        Image image4 = null;
        this.progressor.steps((this.dx != 0.0 ? n15 : 0) + (this.dy != 0.0 ? n15 : 0) + (this.dz != 0.0 ? n15 : 0));
        this.progressor.status("Translating...");
        this.progressor.start();
        if (this.dx == 0.0) {
            this.messenger.log("Skipping translation in x-dimension");
            image2 = image;
        } else {
            this.logus("Translating" + this.component + " in x-dimension");
            dArray2 = new double[dimensions.x + 2 * this.borders.x];
            dArray = new double[dimensions.x];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.background;
            }
            coordinates2 = new Coordinates();
            coordinates2.x = -this.borders.x;
            coordinates = new Coordinates();
            n14 = dimensions.x + 2 * this.borders.x - 1;
            n13 = FMath.floor(-this.dx);
            d2 = -this.dx - (double)n13;
            d = 1.0 - d2;
            n12 = this.dx > 0.0 ? FMath.floor(this.dx) : 0;
            n11 = this.dx > 0.0 ? dimensions.x - 1 : dimensions.x - 1 + FMath.ceil(this.dx);
            n10 = n11 - n12 + 1;
            image2 = Image.create(dimensions, image.type());
            image2.axes(1);
            image.axes(1);
            switch (this.xscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in x-dimension");
                    n9 = -FMath.round(this.dx);
                    n8 = this.dx > 0.0 ? -n9 : 0;
                    n7 = this.dx > 0.0 ? dimensions.x - 1 : dimensions.x - 1 - n9;
                    n6 = n7 - n8 + 1;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.y = 0;
                                coordinates2.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    int n16 = 0;
                                    n5 = n8 + n9;
                                    int n17 = n8;
                                    while (n16 < n6) {
                                        dArray[n17] = dArray2[n5];
                                        ++n16;
                                        ++n5;
                                        ++n17;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in x-dimension");
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.y = 0;
                                coordinates2.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    int n18 = 0;
                                    n8 = this.borders.x + n12 + n13;
                                    int n19 = n12;
                                    while (n18 < n10) {
                                        dArray[n19] = d * dArray2[n8] + d2 * dArray2[n8 + 1];
                                        ++n18;
                                        ++n8;
                                        ++n19;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in x-dimension");
                    double d3 = -0.5 * d2 * d * d;
                    double d4 = 1.0 + (1.5 * d2 - 2.5) * d2 * d2;
                    double d5 = 1.0 + (1.5 * d - 2.5) * d * d;
                    double d6 = -0.5 * d * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.y = 0;
                                coordinates2.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    int n20 = 0;
                                    n4 = this.borders.x + n12 + n13;
                                    int n21 = n12;
                                    while (n20 < n10) {
                                        dArray[n21] = d4 * dArray2[n4] + d3 * dArray2[n4 - 1] + d5 * dArray2[n4 + 1] + d6 * dArray2[n4 + 2];
                                        ++n20;
                                        ++n4;
                                        ++n21;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in x-dimension");
                    double d7 = 0.16666666666666666 * d * d * d;
                    double d8 = 0.6666666666666666 + (0.5 * d2 - 1.0) * d2 * d2;
                    double d9 = 0.6666666666666666 + (0.5 * d - 1.0) * d * d;
                    double d10 = 0.16666666666666666 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.y = 0;
                                coordinates2.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.x);
                                    int n22 = 0;
                                    n4 = this.borders.x + n12 + n13;
                                    int n23 = n12;
                                    while (n22 < n10) {
                                        dArray[n23] = d8 * dArray2[n4] + d7 * dArray2[n4 - 1] + d9 * dArray2[n4 + 1] + d10 * dArray2[n4 + 2];
                                        ++n22;
                                        ++n4;
                                        ++n23;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-dimension");
                    double d11 = d * (0.023809523809523808 + 0.16666666666666666 * d * d);
                    double d12 = 0.6190476190476191 + d2 * (0.07142857142857142 + d2 * (0.5 * d2 - 1.0));
                    double d13 = 0.6190476190476191 + d * (0.07142857142857142 + d * (0.5 * d - 1.0));
                    double d14 = d2 * (0.023809523809523808 + 0.16666666666666666 * d2 * d2);
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.y = 0;
                                coordinates2.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.x);
                                    int n24 = 0;
                                    n4 = this.borders.x + n12 + n13;
                                    int n25 = n12;
                                    while (n24 < n10) {
                                        dArray[n25] = d12 * dArray2[n4] + d11 * dArray2[n4 - 1] + d13 * dArray2[n4 + 1] + d14 * dArray2[n4 + 2];
                                        ++n24;
                                        ++n4;
                                        ++n25;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in x-dimension");
                    double d15 = 0.008333333333333333 * d * d * d * d * d;
                    double d16 = 0.008333333333333333 + 0.041666666666666664 * d * (1.0 + d * (2.0 + d * (2.0 + d - d * d)));
                    double d17 = 0.55 + d2 * d2 * ((0.25 - 0.08333333333333333 * d2) * d2 * d2 - 0.5);
                    double d18 = 0.55 + d * d * ((0.25 - 0.08333333333333333 * d) * d * d - 0.5);
                    double d19 = 0.008333333333333333 + 0.041666666666666664 * d2 * (1.0 + d2 * (2.0 + d2 * (2.0 + d2 - d2 * d2)));
                    double d20 = 0.008333333333333333 * d2 * d2 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates2.y = 0;
                                coordinates.y = 0;
                                while (coordinates2.y < dimensions.y) {
                                    image.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.x);
                                    n3 = 0;
                                    n2 = this.borders.x + n12 + n13;
                                    n = n12;
                                    while (n3 < n10) {
                                        dArray[n] = d17 * dArray2[n2] + d16 * dArray2[n2 - 1] + d15 * dArray2[n2 - 2] + d18 * dArray2[n2 + 1] + d19 * dArray2[n2 + 2] + d20 * dArray2[n2 + 3];
                                        ++n3;
                                        ++n2;
                                        ++n;
                                    }
                                    image2.set(coordinates, dArray);
                                    this.progressor.step(dimensions.x);
                                    ++coordinates2.y;
                                    ++coordinates.y;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        if (this.dy == 0.0) {
            this.messenger.log("Skipping translation in y-dimension");
            image3 = image2;
        } else {
            this.logus("Translating" + this.component + " in y-dimension");
            dArray2 = new double[dimensions.y + 2 * this.borders.y];
            dArray = new double[dimensions.y];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.background;
            }
            coordinates2 = new Coordinates();
            coordinates2.y = -this.borders.y;
            coordinates = new Coordinates();
            n14 = dimensions.y + 2 * this.borders.y - 1;
            n13 = FMath.floor(-this.dy);
            d2 = -this.dy - (double)n13;
            d = 1.0 - d2;
            n12 = this.dy > 0.0 ? FMath.floor(this.dy) : 0;
            n11 = this.dy > 0.0 ? dimensions.y - 1 : dimensions.y - 1 + FMath.ceil(this.dy);
            n10 = n11 - n12 + 1;
            image3 = Image.create(dimensions, image.type());
            image3.axes(2);
            image2.axes(2);
            switch (this.yscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in y-dimension");
                    n9 = -FMath.round(this.dy);
                    n8 = this.dy > 0.0 ? -n9 : 0;
                    n7 = this.dy > 0.0 ? dimensions.y - 1 : dimensions.y - 1 - n9;
                    n6 = n7 - n8 + 1;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    int n26 = 0;
                                    n5 = n8 + n9;
                                    int n27 = n8;
                                    while (n26 < n6) {
                                        dArray[n27] = dArray2[n5];
                                        ++n26;
                                        ++n5;
                                        ++n27;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in y-dimension");
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    n9 = 0;
                                    n8 = this.borders.y + n12 + n13;
                                    n7 = n12;
                                    while (n9 < n10) {
                                        dArray[n7] = d * dArray2[n8] + d2 * dArray2[n8 + 1];
                                        ++n9;
                                        ++n8;
                                        ++n7;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in y-dimension");
                    double d21 = -0.5 * d2 * d * d;
                    double d22 = 1.0 + (1.5 * d2 - 2.5) * d2 * d2;
                    double d23 = 1.0 + (1.5 * d - 2.5) * d * d;
                    double d24 = -0.5 * d * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    int n28 = 0;
                                    n4 = this.borders.y + n12 + n13;
                                    int n29 = n12;
                                    while (n28 < n10) {
                                        dArray[n29] = d22 * dArray2[n4] + d21 * dArray2[n4 - 1] + d23 * dArray2[n4 + 1] + d24 * dArray2[n4 + 2];
                                        ++n28;
                                        ++n4;
                                        ++n29;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in y-dimension");
                    double d25 = 0.16666666666666666 * d * d * d;
                    double d26 = 0.6666666666666666 + (0.5 * d2 - 1.0) * d2 * d2;
                    double d27 = 0.6666666666666666 + (0.5 * d - 1.0) * d * d;
                    double d28 = 0.16666666666666666 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.y);
                                    int n30 = 0;
                                    n4 = this.borders.y + n12 + n13;
                                    int n31 = n12;
                                    while (n30 < n10) {
                                        dArray[n31] = d26 * dArray2[n4] + d25 * dArray2[n4 - 1] + d27 * dArray2[n4 + 1] + d28 * dArray2[n4 + 2];
                                        ++n30;
                                        ++n4;
                                        ++n31;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in y-dimension");
                    double d29 = d * (0.023809523809523808 + 0.16666666666666666 * d * d);
                    double d30 = 0.6190476190476191 + d2 * (0.07142857142857142 + d2 * (0.5 * d2 - 1.0));
                    double d31 = 0.6190476190476191 + d * (0.07142857142857142 + d * (0.5 * d - 1.0));
                    double d32 = d2 * (0.023809523809523808 + 0.16666666666666666 * d2 * d2);
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.y);
                                    int n32 = 0;
                                    n4 = this.borders.y + n12 + n13;
                                    int n33 = n12;
                                    while (n32 < n10) {
                                        dArray[n33] = d30 * dArray2[n4] + d29 * dArray2[n4 - 1] + d31 * dArray2[n4 + 1] + d32 * dArray2[n4 + 2];
                                        ++n32;
                                        ++n4;
                                        ++n33;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in y-dimension");
                    double d33 = 0.008333333333333333 * d * d * d * d * d;
                    double d34 = 0.008333333333333333 + 0.041666666666666664 * d * (1.0 + d * (2.0 + d * (2.0 + d - d * d)));
                    double d35 = 0.55 + d2 * d2 * ((0.25 - 0.08333333333333333 * d2) * d2 * d2 - 0.5);
                    double d36 = 0.55 + d * d * ((0.25 - 0.08333333333333333 * d) * d * d - 0.5);
                    double d37 = 0.008333333333333333 + 0.041666666666666664 * d2 * (1.0 + d2 * (2.0 + d2 * (2.0 + d2 - d2 * d2)));
                    double d38 = 0.008333333333333333 * d2 * d2 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates2.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates2.t < dimensions.t) {
                            coordinates.z = 0;
                            coordinates2.z = 0;
                            while (coordinates2.z < dimensions.z) {
                                coordinates.x = 0;
                                coordinates2.x = 0;
                                while (coordinates2.x < dimensions.x) {
                                    image2.get(coordinates2, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.y);
                                    n3 = 0;
                                    n2 = this.borders.y + n12 + n13;
                                    n = n12;
                                    while (n3 < n10) {
                                        dArray[n] = d35 * dArray2[n2] + d34 * dArray2[n2 - 1] + d33 * dArray2[n2 - 2] + d36 * dArray2[n2 + 1] + d37 * dArray2[n2 + 2] + d38 * dArray2[n2 + 3];
                                        ++n3;
                                        ++n2;
                                        ++n;
                                    }
                                    image3.set(coordinates, dArray);
                                    this.progressor.step(dimensions.y);
                                    ++coordinates2.x;
                                    ++coordinates.x;
                                }
                                ++coordinates2.z;
                                ++coordinates.z;
                            }
                            ++coordinates2.t;
                            ++coordinates.t;
                        }
                        ++coordinates2.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        image2 = null;
        if (this.dz == 0.0) {
            this.messenger.log("Skipping translation in z-dimension");
            image4 = image3;
        } else {
            this.logus("Translating" + this.component + " in z-dimension");
            dArray2 = new double[dimensions.z + 2 * this.borders.z];
            dArray = new double[dimensions.z];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.background;
            }
            Coordinates coordinates3 = new Coordinates();
            coordinates3.z = -this.borders.z;
            coordinates = new Coordinates();
            n14 = dimensions.z + 2 * this.borders.z - 1;
            n13 = FMath.floor(-this.dz);
            d2 = -this.dz - (double)n13;
            d = 1.0 - d2;
            n12 = this.dz > 0.0 ? FMath.floor(this.dz) : 0;
            n11 = this.dz > 0.0 ? dimensions.z - 1 : dimensions.z - 1 + FMath.ceil(this.dz);
            n10 = n11 - n12 + 1;
            image4 = Image.create(dimensions, image.type());
            image4.axes(4);
            image3.axes(4);
            switch (this.zscheme) {
                case 0: {
                    this.messenger.log("Nearest-neighbor sampling in z-dimension");
                    int n34 = -FMath.round(this.dz);
                    n8 = this.dz > 0.0 ? -n34 : 0;
                    int n35 = this.dz > 0.0 ? dimensions.z - 1 : dimensions.z - 1 - n34;
                    n6 = n35 - n8 + 1;
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    int n36 = 0;
                                    n5 = n8 + n34;
                                    int n37 = n8;
                                    while (n36 < n6) {
                                        dArray[n37] = dArray2[n5];
                                        ++n36;
                                        ++n5;
                                        ++n37;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 1: {
                    this.messenger.log("Linear sampling in z-dimension");
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    int n38 = 0;
                                    n8 = this.borders.z + n12 + n13;
                                    int n39 = n12;
                                    while (n38 < n10) {
                                        dArray[n39] = d * dArray2[n8] + d2 * dArray2[n8 + 1];
                                        ++n38;
                                        ++n8;
                                        ++n39;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 2: {
                    this.messenger.log("Cubic convolution sampling in z-dimension");
                    double d39 = -0.5 * d2 * d * d;
                    double d40 = 1.0 + (1.5 * d2 - 2.5) * d2 * d2;
                    double d41 = 1.0 + (1.5 * d - 2.5) * d * d;
                    double d42 = -0.5 * d * d2 * d2;
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    int n40 = 0;
                                    n4 = this.borders.z + n12 + n13;
                                    int n41 = n12;
                                    while (n40 < n10) {
                                        dArray[n41] = d40 * dArray2[n4] + d39 * dArray2[n4 - 1] + d41 * dArray2[n4 + 1] + d42 * dArray2[n4 + 2];
                                        ++n40;
                                        ++n4;
                                        ++n41;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 3: {
                    this.messenger.log("Cubic B-spline prefiltering and sampling in z-dimension");
                    double d43 = 0.16666666666666666 * d * d * d;
                    double d44 = 0.6666666666666666 + (0.5 * d2 - 1.0) * d2 * d2;
                    double d45 = 0.6666666666666666 + (0.5 * d - 1.0) * d * d;
                    double d46 = 0.16666666666666666 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    this.prefilter.bspline3(dArray2, this.borders.z);
                                    int n42 = 0;
                                    n4 = this.borders.z + n12 + n13;
                                    int n43 = n12;
                                    while (n42 < n10) {
                                        dArray[n43] = d44 * dArray2[n4] + d43 * dArray2[n4 - 1] + d45 * dArray2[n4 + 1] + d46 * dArray2[n4 + 2];
                                        ++n42;
                                        ++n4;
                                        ++n43;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 4: {
                    this.messenger.log("Cubic O-MOMS prefiltering and sampling in z-dimension");
                    double d47 = d * (0.023809523809523808 + 0.16666666666666666 * d * d);
                    double d48 = 0.6190476190476191 + d2 * (0.07142857142857142 + d2 * (0.5 * d2 - 1.0));
                    double d49 = 0.6190476190476191 + d * (0.07142857142857142 + d * (0.5 * d - 1.0));
                    double d50 = d2 * (0.023809523809523808 + 0.16666666666666666 * d2 * d2);
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    this.prefilter.omoms3(dArray2, this.borders.z);
                                    int n44 = 0;
                                    n4 = this.borders.z + n12 + n13;
                                    int n45 = n12;
                                    while (n44 < n10) {
                                        dArray[n45] = d48 * dArray2[n4] + d47 * dArray2[n4 - 1] + d49 * dArray2[n4 + 1] + d50 * dArray2[n4 + 2];
                                        ++n44;
                                        ++n4;
                                        ++n45;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
                case 5: {
                    this.messenger.log("Quintic B-spline prefiltering and sampling in z-dimension");
                    double d51 = 0.008333333333333333 * d * d * d * d * d;
                    double d52 = 0.008333333333333333 + 0.041666666666666664 * d * (1.0 + d * (2.0 + d * (2.0 + d - d * d)));
                    double d53 = 0.55 + d2 * d2 * ((0.25 - 0.08333333333333333 * d2) * d2 * d2 - 0.5);
                    double d54 = 0.55 + d * d * ((0.25 - 0.08333333333333333 * d) * d * d - 0.5);
                    double d55 = 0.008333333333333333 + 0.041666666666666664 * d2 * (1.0 + d2 * (2.0 + d2 * (2.0 + d2 - d2 * d2)));
                    double d56 = 0.008333333333333333 * d2 * d2 * d2 * d2 * d2;
                    coordinates.c = 0;
                    coordinates3.c = 0;
                    while (coordinates3.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates3.t = 0;
                        while (coordinates3.t < dimensions.t) {
                            coordinates.y = 0;
                            coordinates3.y = 0;
                            while (coordinates3.y < dimensions.y) {
                                coordinates.x = 0;
                                coordinates3.x = 0;
                                while (coordinates3.x < dimensions.x) {
                                    image3.get(coordinates3, dArray2);
                                    this.prefilter.bspline5(dArray2, this.borders.z);
                                    n3 = 0;
                                    n2 = this.borders.z + n12 + n13;
                                    n = n12;
                                    while (n3 < n10) {
                                        dArray[n] = d53 * dArray2[n2] + d52 * dArray2[n2 - 1] + d51 * dArray2[n2 - 2] + d54 * dArray2[n2 + 1] + d55 * dArray2[n2 + 2] + d56 * dArray2[n2 + 3];
                                        ++n3;
                                        ++n2;
                                        ++n;
                                    }
                                    image4.set(coordinates, dArray);
                                    this.progressor.step(dimensions.z);
                                    ++coordinates3.x;
                                    ++coordinates.x;
                                }
                                ++coordinates3.y;
                                ++coordinates.y;
                            }
                            ++coordinates3.t;
                            ++coordinates.t;
                        }
                        ++coordinates3.c;
                        ++coordinates.c;
                    }
                    break;
                }
            }
        }
        this.progressor.stop();
        return image4;
    }

    private void initialize(Image image, double d, double d2, double d3, int n) {
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        double d4 = image.aspects().x;
        double d5 = image.aspects().y;
        double d6 = image.aspects().z;
        if (d4 <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (d6 <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        this.messenger.log("Input voxel dimensions: (x,y,z) = (" + d4 + "," + d5 + "," + d6 + ")");
        this.dx = d / d4;
        this.dy = d2 / d5;
        this.dz = d3 / d6;
        this.messenger.log("Translation distances: (x,y,z) = (" + d + "," + d2 + "," + d3 + ")");
        this.messenger.log("Translation in voxel units: (x,y,z) = (" + this.dx + "," + this.dy + "," + this.dz + ")");
        double d7 = dimensions.x - 1;
        double d8 = dimensions.y - 1;
        double d9 = dimensions.z - 1;
        if (this.dx > d7 || this.dx < -d7) {
            throw new IllegalArgumentException("Translation distance out of range in x-dimension");
        }
        if (this.dy > d8 || this.dy < -d8) {
            throw new IllegalArgumentException("Translation distance out of range in y-dimension");
        }
        if (this.dz > d9 || this.dz < -d9) {
            throw new IllegalArgumentException("Translation distance out of range in z-dimension");
        }
        this.messenger.log("Selecting " + this.schemes(n));
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Non-supported interpolation scheme");
        }
        this.yscheme = this.zscheme = n;
        this.xscheme = this.zscheme;
        if (this.dx != 0.0 && dimensions.x == 1 && this.xscheme >= 1) {
            this.messenger.log("Size of input image in x-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in x-dimension");
            this.xscheme = 0;
        } else if (this.dx != 0.0 && dimensions.x < 4 && this.xscheme >= 2) {
            this.messenger.log("Size of input image in x-dimension too small");
            this.messenger.log("Using linear interpolation in x-dimension");
            this.xscheme = 1;
        }
        if (this.dy != 0.0 && dimensions.y == 1 && this.yscheme >= 1) {
            this.messenger.log("Size of input image in y-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in y-dimension");
            this.yscheme = 0;
        } else if (this.dy != 0.0 && dimensions.y < 4 && this.yscheme >= 2) {
            this.messenger.log("Size of input image in y-dimension too small");
            this.messenger.log("Using linear interpolation in y-dimension");
            this.yscheme = 1;
        }
        if (this.dz != 0.0 && dimensions.z == 1 && this.zscheme >= 1) {
            this.messenger.log("Size of input image in z-dimension too small");
            this.messenger.log("Using nearest-neighbor interpolation in z-dimension");
            this.zscheme = 0;
        } else if (this.dz != 0.0 && dimensions.z < 4 && this.zscheme >= 2) {
            this.messenger.log("Size of input image in z-dimension too small");
            this.messenger.log("Using linear interpolation in z-dimension");
            this.zscheme = 1;
        }
        int n2 = 0;
        switch (this.xscheme) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
            }
        }
        int n3 = 0;
        switch (this.yscheme) {
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
            case 5: {
                n3 = 3;
            }
        }
        int n4 = 0;
        switch (this.zscheme) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 3: {
                n4 = 2;
                break;
            }
            case 4: {
                n4 = 2;
                break;
            }
            case 5: {
                n4 = 3;
            }
        }
        this.borders = new Borders(n2, n3, n4, 0, 0);
        this.messenger.log("Background filling with value " + this.background);
    }

    private String schemes(int n) {
        switch (n) {
            case 0: {
                return "nearest-neighbor interpolation";
            }
            case 1: {
                return "linear interpolation";
            }
            case 2: {
                return "cubic convolution interpolation";
            }
            case 3: {
                return "cubic B-spline interpolation";
            }
            case 4: {
                return "cubic O-MOMS interpolation";
            }
            case 5: {
                return "quintic B-spline interpolation";
            }
        }
        return "unknown interpolation";
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

