/*
 * Decompiled with CFR 0.152.
 */
package imagescience.utility;

import java.io.IOException;
import java.io.Reader;

public class LineReader {
    private final Reader reader;
    private final char[] cb = new char[8192];
    private int nChars = 0;
    private int nextChar = 0;
    private boolean skip = false;
    private long charCount = 0L;
    private long lineCount = 0L;

    public LineReader(Reader reader) {
        this.reader = reader;
    }

    private void fill() throws IOException {
        int n;
        while ((n = this.reader.read(this.cb, 0, this.cb.length)) == 0) {
        }
        if (n > 0) {
            this.nChars = n;
            this.nextChar = 0;
        }
    }

    public String read() throws IOException {
        StringBuffer stringBuffer = null;
        int n = 0;
        ++this.lineCount;
        while (true) {
            int n2;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    return stringBuffer.toString();
                }
                return null;
            }
            boolean bl = false;
            char c = '\u0000';
            if (this.skip && this.cb[this.nextChar] == '\n') {
                ++this.charCount;
            }
            this.skip = false;
            for (n2 = ++this.nextChar; n2 < this.nChars; ++n2) {
                ++this.charCount;
                c = this.cb[n2];
                if (c != '\n' && c != '\r') continue;
                bl = true;
                break;
            }
            n = this.nextChar;
            this.nextChar = n2;
            if (bl) {
                String string;
                if (stringBuffer == null) {
                    string = new String(this.cb, n, n2 - n);
                } else {
                    stringBuffer.append(this.cb, n, n2 - n);
                    string = stringBuffer.toString();
                }
                ++this.nextChar;
                if (c == '\r') {
                    this.skip = true;
                }
                return string;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            stringBuffer.append(this.cb, n, n2 - n);
        }
    }

    public long chars() {
        return this.charCount;
    }

    public long lines() {
        return this.lineCount;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

