/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SingleTileRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxEncoder;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_GROUP3_1D = 2;
    private static final int COMP_GROUP3_2D = 3;
    private static final int COMP_GROUP4 = 4;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private boolean isLittleEndian = false;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    private static final char[] intsToChars(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(nArray[i] & 0xFFFF);
        }
        return cArray;
    }

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        this.isLittleEndian = tIFFEncodeParam.getLittleEndian();
        this.writeFileHeader();
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        Object object2;
        Object object3;
        int n9;
        int[] nArray;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n16;
        int n17;
        if (CodecUtils.isPackedByteImage(renderedImage)) {
            ColorModel colorModel = renderedImage.getColorModel();
            ComponentColorModel componentColorModel = RasterFactory.createComponentColorModel(0, colorModel.getColorSpace(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency());
            Point point = new Point(renderedImage.getMinX(), renderedImage.getMinY());
            WritableRaster writableRaster = Raster.createWritableRaster(((ColorModel)componentColorModel).createCompatibleSampleModel(renderedImage.getWidth(), renderedImage.getHeight()), point);
            writableRaster.setRect(renderedImage.getData());
            renderedImage = new SingleTileRenderedImage(writableRaster, componentColorModel);
        }
        int n18 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n19 = renderedImage.getMinX();
        int n20 = renderedImage.getMinY();
        int n21 = renderedImage.getWidth();
        int n22 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray2 = sampleModel.getSampleSize();
        for (n17 = 1; n17 < nArray2.length; ++n17) {
            if (nArray2[n17] == nArray2[0]) continue;
            throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
        }
        n17 = sampleModel.getNumBands();
        if ((nArray2[0] == 1 || nArray2[0] == 4) && n17 != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder1"));
        }
        int n23 = sampleModel.getDataType();
        switch (n23) {
            case 0: {
                if (nArray2[0] == 1 || nArray2[0] == 4 || nArray2[0] == 8) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray2[0] == 16) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray2[0] == 32) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n23 == 2 || n23 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n23 != 0) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n24 = 0;
        int[] nArray3 = null;
        int n25 = -1;
        int n26 = 0;
        int n27 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n16 = indexColorModel.getMapSize();
            if (nArray2[0] == 1 && n17 == 1) {
                if (n16 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder7"));
                }
                byArray2 = new byte[n16];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n16];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n16];
                indexColorModel.getBlues((byte[])object4);
                n25 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n17 == 1) {
                n25 = 3;
            }
        } else if (colorModel == null) {
            if (nArray2[0] == 1 && n17 == 1) {
                n25 = 1;
            } else {
                n25 = 8;
                if (n17 > 1) {
                    n26 = n17 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n25 = 5;
                    break;
                }
                case 6: {
                    n25 = 2;
                    break;
                }
                case 1: {
                    n25 = 7;
                    break;
                }
                case 5: {
                    if (n18 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n25 = 6;
                        break;
                    }
                    n25 = 4;
                    break;
                }
                case 3: {
                    n25 = 6;
                    break;
                }
                default: {
                    n25 = 8;
                }
            }
            if (n25 == 8) {
                n26 = n17 - 1;
            } else if (n17 > 1) {
                n26 = n17 - colorSpace.getNumComponents();
            }
            if (n26 == 1 && colorModel.hasAlpha()) {
                int n28 = n27 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n25 == -1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
        }
        if (n18 == 7) {
            if (n25 == 3) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder11"));
            }
            if (nArray2[0] != 8 || n25 != 2 && n25 != 4 && n25 != 6) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder9"));
            }
        }
        if (n25 != 0 && n25 != 1 && (n18 == 2 || n18 == 3 || n18 == 4)) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder12"));
        }
        n16 = -1;
        switch (n25) {
            case 0: {
                n16 = 0;
                break;
            }
            case 1: {
                n16 = 1;
                break;
            }
            case 2: 
            case 8: {
                n16 = 1;
                break;
            }
            case 3: {
                n16 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n24 = indexColorModel.getMapSize();
                byArray2 = new byte[n24];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n24];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n24];
                indexColorModel.getBlues((byte[])object4);
                n15 = 0;
                n14 = n24;
                n13 = 2 * n24;
                nArray3 = new int[n24 * 3];
                for (n12 = 0; n12 < n24; ++n12) {
                    nArray3[n15++] = byArray2[n12] << 8 & 0xFFFF;
                    nArray3[n14++] = byArray[n12] << 8 & 0xFFFF;
                    nArray3[n13++] = object4[n12] << 8 & 0xFFFF;
                }
                n24 *= 3;
                break;
            }
            case 4: {
                n16 = 2;
                break;
            }
            case 5: {
                n16 = 5;
                break;
            }
            case 6: {
                n16 = 6;
                break;
            }
            case 7: {
                n16 = 8;
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n11 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n10 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n11 = n21;
            n10 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n18 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n15 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
            n14 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
            for (n13 = 1; n13 < n17; ++n13) {
                int n29;
                n12 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(n13);
                if (n12 > n15) {
                    n15 = n12;
                }
                if ((n29 = ((JPEGEncodeParam)object4).getVerticalSubsampling(n13)) <= n14) continue;
                n14 = n29;
            }
            n13 = 8 * n14;
            if ((n10 = (int)((float)n10 / (float)n13 + 0.5f) * n13) < n13) {
                n10 = n13;
            }
            if (bl2 && (n11 = (int)((float)n11 / (float)(n12 = 8 * n15) + 0.5f) * n12) < n12) {
                n11 = n12;
            }
        }
        n15 = bl2 ? (n21 + n11 - 1) / n11 * ((n22 + n10 - 1) / n10) : (int)Math.ceil((double)n22 / (double)n10);
        long[] lArray = new long[n15];
        long l = (long)Math.ceil((double)nArray2[0] / 8.0 * (double)n11 * (double)n17);
        long l2 = l * (long)n10;
        for (int i = 0; i < n15; ++i) {
            lArray[i] = l2;
        }
        if (!bl2) {
            long l3 = n22 - n10 * (n15 - 1);
            lArray[n15 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n15 - 1) + lArray[n15 - 1];
        long[] lArray2 = new long[n15];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n21}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n22}));
        treeSet.add(new TIFFField(258, 3, n17, TIFFImageEncoder.intsToChars(nArray2)));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n18}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n16}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n15, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n17}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(279, 4, n15, lArray));
        }
        if (nArray3 != null) {
            treeSet.add(new TIFFField(320, 3, n24, TIFFImageEncoder.intsToChars(nArray3)));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(324, 4, n15, lArray2));
            treeSet.add(new TIFFField(325, 4, n15, lArray));
        }
        if (n26 > 0) {
            nArray = new int[n26];
            for (n9 = 0; n9 < n26; ++n9) {
                nArray[n9] = n27;
            }
            treeSet.add(new TIFFField(338, 3, n26, TIFFImageEncoder.intsToChars(nArray)));
        }
        if (n23 != 0) {
            nArray = new int[n17];
            nArray[0] = n23 == 4 ? 3 : (n23 == 1 ? 1 : 2);
            for (n9 = 1; n9 < n17; ++n9) {
                nArray[n9] = nArray[0];
            }
            treeSet.add(new TIFFField(339, 3, n17, TIFFImageEncoder.intsToChars(nArray)));
        }
        boolean bl4 = tIFFEncodeParam.getReverseFillOrder();
        n9 = tIFFEncodeParam.getT4Encode2D() ? 1 : 0;
        boolean bl5 = tIFFEncodeParam.getT4PadEOLs();
        TIFFFaxEncoder tIFFFaxEncoder = null;
        if (!(n25 != 1 && n25 != 0 || n18 != 2 && n18 != 3 && n18 != 4)) {
            tIFFFaxEncoder = new TIFFFaxEncoder(bl4);
            treeSet.add(new TIFFField(266, 3, 1, new char[]{bl4 ? (char)'\u0002' : '\u0001'}));
            if (n18 == 3) {
                long l5 = 0L;
                if (n9 != 0) {
                    l5 |= 1L;
                }
                if (bl5) {
                    l5 |= 4L;
                }
                treeSet.add(new TIFFField(292, 4, 1, new long[]{l5}));
            } else if (n18 == 4) {
                treeSet.add(new TIFFField(293, 4, 1, new long[]{0L}));
            }
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        com.sun.image.codec.jpeg.JPEGImageEncoder jPEGImageEncoder = null;
        int n30 = 0;
        if (n18 == 7) {
            n30 = 0;
            switch (n25) {
                case 2: 
                case 3: {
                    n30 = 1;
                    break;
                }
                case 4: {
                    n30 = 2;
                    break;
                }
                case 6: {
                    n30 = 3;
                }
            }
            object3 = renderedImage.getTile(0, 0);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n30);
            JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n17);
            if (((JPEGEncodeParam)object4).getWriteImageOnly()) {
                jPEGEncodeParam.setImageInfoValid(false);
                jPEGEncodeParam.setTableInfoValid(true);
                object2 = new ByteArrayOutputStream();
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                jPEGImageEncoder.encode((Raster)object3);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
                jPEGImageEncoder = null;
            }
        }
        if (n25 == 6) {
            int n31 = 1;
            int n32 = 1;
            if (n18 == 7) {
                n31 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
                n32 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
                for (int i = 1; i < n17; ++i) {
                    n8 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(i);
                    if (n8 > n31) {
                        n31 = n8;
                    }
                    if ((n7 = ((JPEGEncodeParam)object4).getVerticalSubsampling(i)) <= n32) continue;
                    n32 = n7;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{(char)n31, (char)n32}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{n18 == 7 ? (char)'\u0001' : '\u0002'}));
            object = n18 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((object3 = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            object = treeSet.iterator();
            while (object.hasNext()) {
                TIFFField tIFFField = (TIFFField)object.next();
                ((ArrayList)object2).add(new Integer(tIFFField.getTag()));
            }
            n8 = ((TIFFField[])object3).length;
            for (n7 = 0; n7 < n8; ++n7) {
                TIFFField tIFFField = object3[n7];
                Integer n33 = new Integer(tIFFField.getTag());
                if (((ArrayList)object2).contains(n33)) continue;
                treeSet.add(tIFFField);
                ((ArrayList)object2).add(n33);
            }
        }
        int n34 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n34;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n35 = 0;
        boolean bl6 = false;
        Deflater deflater = null;
        int n36 = -1;
        boolean bl7 = false;
        if (n18 == 1) {
            int n37;
            n6 = 0;
            if (nArray2[0] == 16 && lArray2[0] % 2L != 0L) {
                n6 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray2[0] == 32 && lArray2[0] % 4L != 0L) {
                n6 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n6;
            }
            for (n37 = 1; n37 < n15; ++n37) {
                lArray2[n37] = lArray2[n37 - 1] + lArray[n37 - 1];
            }
            if (!bl && (n35 = (int)(lArray2[0] + l4)) % 2 != 0) {
                ++n35;
                bl6 = true;
            }
            this.writeDirectory(n, treeSet, n35);
            if (n6 != 0) {
                for (n37 = 0; n37 < n6; ++n37) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    file = null;
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            n6 = 0;
            switch (n18) {
                case 2: {
                    n6 = (int)Math.ceil((double)((n11 + 1) / 2 * 9 + 2) / 8.0);
                    break;
                }
                case 3: 
                case 4: {
                    n6 = (int)Math.ceil((double)((n11 + 1) / 2 * 9 + 2) / 8.0);
                    n6 = n10 * (n6 + 2) + 12;
                    break;
                }
                case 32773: {
                    n6 = (int)(l2 + (l + 127L) / 128L * (long)n10);
                    break;
                }
                case 7: {
                    n6 = 0;
                    if (n25 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl7 = true;
                    break;
                }
                case 32946: {
                    n6 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n6 != 0) {
                byArray3 = new byte[n6];
            }
        }
        int[] nArray4 = null;
        float[] fArray = null;
        boolean bl8 = nArray2[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n23 == 0 || nArray2[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n18 != 7) {
            if (n23 == 0) {
                byArray4 = new byte[n10 * n11 * n17];
            } else if (bl3) {
                byArray4 = new byte[2 * n10 * n11 * n17];
            } else if (n23 == 3 || n23 == 4) {
                byArray4 = new byte[4 * n10 * n11 * n17];
            }
        }
        int n38 = n20 + n22;
        int n39 = n19 + n21;
        int n40 = 0;
        for (n5 = n20; n5 < n38; n5 += n10) {
            n4 = bl2 ? n10 : Math.min(n10, n38 - n5);
            n3 = n4 * n11 * n17;
            block55: for (n2 = n19; n2 < n39; n2 += n11) {
                int n41;
                int n42;
                int n43;
                Raster raster = renderedImage.getData(new Rectangle(n2, n5, n11, n4));
                boolean bl9 = false;
                if (n18 != 7) {
                    if (bl8) {
                        if (nArray2[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray5 = componentSampleModel.getBankIndices();
                            int[] nArray6 = componentSampleModel.getBandOffsets();
                            n43 = componentSampleModel.getPixelStride();
                            n42 = componentSampleModel.getScanlineStride();
                            if (n43 != n17 || (long)n42 != l) {
                                bl9 = false;
                            } else {
                                bl9 = true;
                                for (n41 = 0; bl9 && n41 < n17; ++n41) {
                                    if (nArray5[n41] == 0 && nArray6[n41] == n41) continue;
                                    bl9 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl9 = true;
                            }
                        }
                    }
                    if (!bl9) {
                        if (n23 == 4) {
                            fArray = raster.getPixels(n2, n5, n11, n4, fArray);
                        } else {
                            nArray4 = raster.getPixels(n2, n5, n11, n4, nArray4);
                        }
                    }
                }
                int n44 = 0;
                int n45 = 0;
                switch (nArray2[0]) {
                    case 1: {
                        int n46;
                        int n47;
                        int n48;
                        if (bl9) {
                            byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n41 = multiPixelPackedSampleModel.getScanlineStride();
                            n48 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                            if (n41 == (int)l) {
                                System.arraycopy(byArray5, n48, byArray4, 0, (int)l * n4);
                            } else {
                                n47 = 0;
                                for (n46 = 0; n46 < n4; ++n46) {
                                    System.arraycopy(byArray5, n48, byArray4, n47, (int)l);
                                    n48 += n41;
                                    n47 += (int)l;
                                }
                            }
                        } else {
                            int n49 = 0;
                            for (n43 = 0; n43 < n4; ++n43) {
                                for (n42 = 0; n42 < n11 / 8; ++n42) {
                                    n44 = nArray4[n49++] << 7 | nArray4[n49++] << 6 | nArray4[n49++] << 5 | nArray4[n49++] << 4 | nArray4[n49++] << 3 | nArray4[n49++] << 2 | nArray4[n49++] << 1 | nArray4[n49++];
                                    byArray4[n45++] = (byte)n44;
                                }
                                if (n11 % 8 <= 0) continue;
                                n44 = 0;
                                for (n42 = 0; n42 < n11 % 8; ++n42) {
                                    n44 |= nArray4[n49++] << 7 - n42;
                                }
                                byArray4[n45++] = (byte)n44;
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n11 + 7) / 8));
                            continue block55;
                        }
                        if (n18 == 2) {
                            int n50 = (n11 + 7) / 8;
                            int n51 = 0;
                            n41 = 0;
                            for (n48 = 0; n48 < n4; ++n48) {
                                n47 = tIFFFaxEncoder.encodeRLE(byArray4, n51, 0, n11, byArray3);
                                this.output.write(byArray3, 0, n47);
                                n51 += n50;
                                n41 += n47;
                            }
                            lArray[n40++] = n41;
                            continue block55;
                        }
                        if (n18 == 3) {
                            int n52 = tIFFFaxEncoder.encodeT4(n9 == 0, bl5, byArray4, (n11 + 7) / 8, 0, n11, n4, byArray3);
                            lArray[n40++] = n52;
                            this.output.write(byArray3, 0, n52);
                            continue block55;
                        }
                        if (n18 == 4) {
                            int n53 = tIFFFaxEncoder.encodeT6(byArray4, (n11 + 7) / 8, 0, n11, n4, byArray3);
                            lArray[n40++] = n53;
                            this.output.write(byArray3, 0, n53);
                            continue block55;
                        }
                        if (n18 == 32773) {
                            int n54 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n54;
                            this.output.write(byArray3, 0, n54);
                            continue block55;
                        }
                        if (n18 != 32946) continue block55;
                        int n55 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n55;
                        this.output.write(byArray3, 0, n55);
                        continue block55;
                    }
                    case 4: {
                        int n56 = 0;
                        for (n43 = 0; n43 < n4; ++n43) {
                            for (n42 = 0; n42 < n11 / 2; ++n42) {
                                n44 = nArray4[n56++] << 4 | nArray4[n56++];
                                byArray4[n45++] = (byte)n44;
                            }
                            if (n11 % 2 != 1) continue;
                            n44 = nArray4[n56++] << 4;
                            byArray4[n45++] = (byte)n44;
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n4 * ((n11 + 1) / 2));
                            continue block55;
                        }
                        if (n18 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n43;
                            this.output.write(byArray3, 0, n43);
                            continue block55;
                        }
                        if (n18 != 32946) continue block55;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n43;
                        this.output.write(byArray3, 0, n43);
                        continue block55;
                    }
                    case 8: {
                        int n46;
                        int n47;
                        if (n18 != 7) {
                            if (bl9) {
                                byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n41 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                                int n57 = componentSampleModel.getScanlineStride();
                                if (n57 == (int)l) {
                                    System.arraycopy(byArray6, n41, byArray4, 0, (int)l * n4);
                                } else {
                                    n47 = 0;
                                    for (n46 = 0; n46 < n4; ++n46) {
                                        System.arraycopy(byArray6, n41, byArray4, n47, (int)l);
                                        n41 += n57;
                                        n47 += (int)l;
                                    }
                                }
                            } else {
                                for (n43 = 0; n43 < n3; ++n43) {
                                    byArray4[n43] = (byte)nArray4[n43];
                                }
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3);
                            continue block55;
                        }
                        if (n18 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n43;
                            this.output.write(byArray3, 0, n43);
                            continue block55;
                        }
                        if (n18 == 7) {
                            long l6 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n30);
                                JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n17);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl7) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l7 = this.getOffset(this.output);
                            lArray[n40++] = (int)(l7 - l6);
                            continue block55;
                        }
                        if (n18 != 32946) continue block55;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n43;
                        this.output.write(byArray3, 0, n43);
                        continue block55;
                    }
                    case 16: {
                        n43 = 0;
                        for (n42 = 0; n42 < n3; ++n42) {
                            n41 = (short)nArray4[n42];
                            byArray4[n43++] = (byte)((n41 & 0xFF00) >> 8);
                            byArray4[n43++] = (byte)(n41 & 0xFF);
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3 * 2);
                            continue block55;
                        }
                        if (n18 == 32773) {
                            n42 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n42;
                            this.output.write(byArray3, 0, n42);
                            continue block55;
                        }
                        if (n18 != 32946) continue block55;
                        n42 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n42;
                        this.output.write(byArray3, 0, n42);
                        continue block55;
                    }
                    case 32: {
                        if (n23 == 3) {
                            n42 = 0;
                            for (n41 = 0; n41 < n3; ++n41) {
                                int n58 = nArray4[n41];
                                byArray4[n42++] = (byte)((n58 & 0xFF000000) >> 24);
                                byArray4[n42++] = (byte)((n58 & 0xFF0000) >> 16);
                                byArray4[n42++] = (byte)((n58 & 0xFF00) >> 8);
                                byArray4[n42++] = (byte)(n58 & 0xFF);
                            }
                        } else {
                            n42 = 0;
                            for (n41 = 0; n41 < n3; ++n41) {
                                int n59 = Float.floatToIntBits(fArray[n41]);
                                byArray4[n42++] = (byte)((n59 & 0xFF000000) >> 24);
                                byArray4[n42++] = (byte)((n59 & 0xFF0000) >> 16);
                                byArray4[n42++] = (byte)((n59 & 0xFF00) >> 8);
                                byArray4[n42++] = (byte)(n59 & 0xFF);
                            }
                        }
                        if (n18 == 1) {
                            this.output.write(byArray4, 0, n3 * 4);
                            continue block55;
                        }
                        if (n18 == 32773) {
                            n42 = TIFFImageEncoder.compressPackBits(byArray4, n4, (int)l, byArray3);
                            lArray[n40++] = n42;
                            this.output.write(byArray3, 0, n42);
                            continue block55;
                        }
                        if (n18 != 32946) continue block55;
                        n42 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n40++] = n42;
                        this.output.write(byArray3, 0, n42);
                    }
                }
            }
        }
        if (n18 == 1) {
            if (bl6) {
                this.output.write(0);
            }
        } else {
            n5 = 0;
            for (n4 = 1; n4 < n15; ++n4) {
                n3 = (int)lArray[n4 - 1];
                n5 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
            }
            int n60 = n35 = bl ? 0 : n + n34 + (n5 += (int)lArray[n15 - 1]);
            if (n35 % 2 != 0) {
                ++n35;
                bl6 = true;
            }
            if (object == null) {
                if (bl6) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l8 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n35);
                seekableOutputStream.seek(l8);
            } else if (file != null) {
                int n61;
                this.output.close();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output = object;
                this.writeDirectory(n, treeSet, n35);
                byte[] byArray7 = new byte[8192];
                for (n2 = 0; n2 < n5 && (n61 = fileInputStream.read(byArray7)) != -1; n2 += n61) {
                    this.output.write(byArray7, 0, n61);
                }
                fileInputStream.close();
                file.delete();
                if (bl6) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n35);
                byteArrayOutputStream.writeTo(this.output);
                if (bl6) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n35;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n3 = TIFFImageEncoder.getValueSize(tIFFField);
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        if (this.isLittleEndian) {
            this.output.write(73);
            this.output.write(73);
        } else {
            this.output.write(77);
            this.output.write(77);
        }
        this.writeUnsignedShort(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 8: {
                int n5;
                short[] sArray = tIFFField.getAsShorts();
                for (n5 = 0; n5 < n2; ++n5) {
                    this.writeUnsignedShort(sArray[n5]);
                }
                for (n5 = 0; n5 < 2 - n2; ++n5) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                this.writeLong(tIFFField.getAsLong(0));
                break;
            }
            case 9: {
                this.writeLong(tIFFField.getAsInt(0));
                break;
            }
            case 11: {
                this.writeLong(Float.floatToIntBits(tIFFField.getAsFloat(0)));
                break;
            }
            case 2: {
                int n6;
                int n7 = 0;
                for (n6 = 0; n6 < n2; ++n6) {
                    byte[] byArray = tIFFField.getAsString(n6).getBytes();
                    this.output.write(byArray);
                    n7 += byArray.length;
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                    ++n7;
                }
                for (n6 = 0; n6 < 4 - n7; ++n6) {
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 9: {
                int[] nArray = tIFFField.getAsInts();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(nArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong((int)(l >> 32));
                    this.writeLong((int)(l & 0xFFFFFFFFFFFFFFFFL));
                }
                break;
            }
            case 5: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 10: {
                int[][] nArray = tIFFField.getAsSRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(nArray[i][0]);
                    this.writeLong(nArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        if (this.isLittleEndian) {
            this.output.write(n & 0xFF);
            this.output.write((n & 0xFF00) >>> 8);
        } else {
            this.output.write((n & 0xFF00) >>> 8);
            this.output.write(n & 0xFF);
        }
    }

    private void writeLong(long l) throws IOException {
        if (this.isLittleEndian) {
            this.output.write((int)l & 0xFF);
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        } else {
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)l & 0xFF);
        }
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }
}

