/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.ImageUtil;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class JDKWorkarounds {
    private JDKWorkarounds() {
    }

    private static boolean setRectBilevel(WritableRaster writableRaster, Raster raster, int n, int n2) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n + n5;
        int n8 = n2 + n6;
        int n9 = writableRaster.getMinX();
        int n10 = writableRaster.getMinY();
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        if (n7 + n3 > n9 + n11) {
            n3 = n9 + n11 - n7;
        }
        if (n8 + n4 > n10 + n12) {
            n4 = n10 + n12 - n8;
        }
        Rectangle rectangle = new Rectangle(n7, n8, n3, n4);
        byte[] byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
        ImageUtil.setPackedBinaryData(byArray, writableRaster, rectangle);
        return true;
    }

    public static void setRect(WritableRaster writableRaster, Raster raster) {
        JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
    }

    public static void setRect(WritableRaster writableRaster, Raster raster, int n, int n2) {
        int n3;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel2 instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
            DataBuffer dataBuffer = raster.getDataBuffer();
            DataBuffer dataBuffer2 = raster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte && multiPixelPackedSampleModel.getPixelBitStride() == 1 && multiPixelPackedSampleModel2.getPixelBitStride() == 1 && JDKWorkarounds.setRectBilevel(writableRaster, raster, n, n2)) {
                return;
            }
        }
        if ((n3 = writableRaster.getSampleModel().getDataType()) != 4 && n3 != 5) {
            writableRaster.setRect(n, n2, raster);
            return;
        }
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        int n10 = writableRaster.getMinX();
        int n11 = writableRaster.getMinY();
        int n12 = writableRaster.getWidth();
        int n13 = writableRaster.getHeight();
        if (n8 + n4 > n10 + n12) {
            n4 = n10 + n12 - n8;
        }
        if (n9 + n5 > n11 + n13) {
            n5 = n11 + n13 - n9;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = null;
                for (int i = 0; i < n5; ++i) {
                    nArray = raster.getPixels(n6, n7 + i, n4, 1, nArray);
                    writableRaster.setPixels(n8, n9 + i, n4, 1, nArray);
                }
                break;
            }
            case 4: {
                float[] fArray = null;
                for (int i = 0; i < n5; ++i) {
                    fArray = raster.getPixels(n6, n7 + i, n4, 1, fArray);
                    writableRaster.setPixels(n8, n9 + i, n4, 1, fArray);
                }
                break;
            }
            case 5: {
                double[] dArray = null;
                for (int i = 0; i < n5; ++i) {
                    dArray = raster.getPixels(n6, n7 + i, n4, 1, dArray);
                    writableRaster.setPixels(n8, n9 + i, n4, 1, dArray);
                }
                break;
            }
        }
    }

    public static boolean areCompatibleDataModels(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null || colorModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JDKWorkarounds0"));
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            return false;
        }
        if (colorModel instanceof ComponentColorModel) {
            int n = sampleModel.getNumBands();
            if (n != colorModel.getNumComponents()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (sampleModel.getSampleSize(i) >= colorModel.getComponentSize(i)) continue;
                return false;
            }
        }
        return true;
    }
}

