/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import java.util.Random;

public class PolyWarpSolver {
    private static Random myRandom = new Random(0L);
    private static double[] c0 = new double[6];
    private static double[] c1 = new double[6];
    private static double noise = 0.0;

    private static double sign(double d, double d2) {
        d = Math.abs(d);
        if (d2 >= 0.0) {
            return d;
        }
        return -d;
    }

    private static final double square(double d) {
        return d * d;
    }

    private static final double sqrt(double d) {
        return Math.sqrt(d);
    }

    private static final double hypot(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            return d4 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d3 / d4) + 1.0);
        }
        if (d3 != 0.0) {
            return d3 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d4 / d3) + 1.0);
        }
        return d4;
    }

    public static double[][] matmul_t(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        int n4 = dArray2.length;
        double[][] dArray3 = new double[n][n4];
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = dArray3[i];
            double[] dArray5 = dArray[i];
            for (int j = 0; j < n4; ++j) {
                double d = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d += dArray5[k] * dArray2[j][k];
                }
                dArray4[j] = d;
            }
        }
        return dArray3;
    }

    private static boolean SVD(double[][] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4) {
        double d;
        double d2;
        int n;
        double d3;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        double[] dArray5 = new double[n7];
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n7; ++n2) {
                dArray3[n3][n2] = dArray[n3][n2];
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n3 = 0; n3 < n7; ++n3) {
            n4 = n3 + 1;
            dArray5[n3] = d5 * d4;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n3 < n6) {
                for (n = n3; n < n6; ++n) {
                    d5 += Math.abs(dArray3[n][n3]);
                }
                if (d5 != 0.0) {
                    for (n = n3; n < n6; ++n) {
                        double[] dArray6 = dArray3[n];
                        int n8 = n3;
                        dArray6[n8] = dArray6[n8] / d5;
                        d3 += PolyWarpSolver.square(dArray3[n][n3]);
                    }
                    d2 = dArray3[n3][n3];
                    d4 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d3), d2);
                    d = d2 * d4 - d3;
                    dArray3[n3][n3] = d2 - d4;
                    for (n2 = n4; n2 < n7; ++n2) {
                        d3 = 0.0;
                        for (n = n3; n < n6; ++n) {
                            d3 += dArray3[n][n3] * dArray3[n][n2];
                        }
                        d2 = d3 / d;
                        for (n = n3; n < n6; ++n) {
                            double[] dArray7 = dArray3[n];
                            int n9 = n2;
                            dArray7[n9] = dArray7[n9] + d2 * dArray3[n][n3];
                        }
                    }
                    for (n = n3; n < n6; ++n) {
                        double[] dArray8 = dArray3[n];
                        int n10 = n3;
                        dArray8[n10] = dArray8[n10] * d5;
                    }
                }
            }
            dArray2[n3] = d5 * d4;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n3 < n6 && n3 != n7 - 1) {
                for (n = n4; n < n7; ++n) {
                    d5 += Math.abs(dArray3[n3][n]);
                }
                if (d5 != 0.0) {
                    for (n = n4; n < n7; ++n) {
                        double[] dArray9 = dArray3[n3];
                        int n11 = n;
                        dArray9[n11] = dArray9[n11] / d5;
                        d3 += PolyWarpSolver.square(dArray3[n3][n]);
                    }
                    d2 = dArray3[n3][n4];
                    d4 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d3), d2);
                    d = d2 * d4 - d3;
                    dArray3[n3][n4] = d2 - d4;
                    for (n = n4; n < n7; ++n) {
                        dArray5[n] = dArray3[n3][n] / d;
                    }
                    for (n2 = n4; n2 < n6; ++n2) {
                        d3 = 0.0;
                        for (n = n4; n < n7; ++n) {
                            d3 += dArray3[n2][n] * dArray3[n3][n];
                        }
                        for (n = n4; n < n7; ++n) {
                            double[] dArray10 = dArray3[n2];
                            int n12 = n;
                            dArray10[n12] = dArray10[n12] + d3 * dArray5[n];
                        }
                    }
                    n = n4;
                    while (n < n7) {
                        double[] dArray11 = dArray3[n3];
                        int n13 = n++;
                        dArray11[n13] = dArray11[n13] * d5;
                    }
                }
            }
            d6 = Math.max(d6, Math.abs(dArray2[n3]) + Math.abs(dArray5[n3]));
        }
        n3 = n7 - 1;
        while (n3 >= 0) {
            if (n3 != n7 - 1) {
                if (d4 != 0.0) {
                    for (n2 = n4; n2 < n7; ++n2) {
                        dArray4[n2][n3] = dArray3[n3][n2] / dArray3[n3][n4] / d4;
                    }
                    for (n2 = n4; n2 < n7; ++n2) {
                        d3 = 0.0;
                        for (n = n4; n < n7; ++n) {
                            d3 += dArray3[n3][n] * dArray4[n][n2];
                        }
                        for (n = n4; n < n7; ++n) {
                            double[] dArray12 = dArray4[n];
                            int n14 = n2;
                            dArray12[n14] = dArray12[n14] + d3 * dArray4[n][n3];
                        }
                    }
                }
                for (n2 = n4; n2 < n7; ++n2) {
                    dArray4[n2][n3] = 0.0;
                    dArray4[n3][n2] = 0.0;
                }
            }
            dArray4[n3][n3] = 1.0;
            d4 = dArray5[n3];
            n4 = n3--;
        }
        int n15 = Math.min(n6, n7);
        n3 = n15 - 1;
        while (n3 >= 0) {
            n4 = n3 + 1;
            d4 = dArray2[n3];
            if (n3 != n7 - 1) {
                for (n2 = n4; n2 < n7; ++n2) {
                    dArray3[n3][n2] = 0.0;
                }
            }
            if (d4 != 0.0) {
                if (n3 != n15 - 1) {
                    for (n2 = n4; n2 < n7; ++n2) {
                        d3 = 0.0;
                        for (n = n4; n < n6; ++n) {
                            d3 += dArray3[n][n3] * dArray3[n][n2];
                        }
                        d2 = d3 / dArray3[n3][n3] / d4;
                        for (n = n3; n < n6; ++n) {
                            double[] dArray13 = dArray3[n];
                            int n16 = n2;
                            dArray13[n16] = dArray13[n16] + d2 * dArray3[n][n3];
                        }
                    }
                }
                for (n2 = n3; n2 < n6; ++n2) {
                    double[] dArray14 = dArray3[n2];
                    int n17 = n3;
                    dArray14[n17] = dArray14[n17] / d4;
                }
            } else {
                for (n2 = n3; n2 < n6; ++n2) {
                    dArray3[n2][n3] = 0.0;
                }
            }
            double[] dArray15 = dArray3[n3];
            int n18 = n3--;
            dArray15[n18] = dArray15[n18] + 1.0;
        }
        double d7 = d6;
        block29: for (n = n7 - 1; n >= 0; --n) {
            int n19 = n - 1;
            int n20 = 0;
            while (true) {
                double d8;
                double d9;
                double d10;
                double d11;
                boolean bl = true;
                for (n4 = n; n4 >= 0; --n4) {
                    n5 = n4 - 1;
                    d11 = d7 + Math.abs(dArray5[n4]);
                    if (d11 == d7) {
                        bl = false;
                        break;
                    }
                    d11 = d7 + Math.abs(dArray2[n5]);
                    if (d11 != d7) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    d10 = 0.0;
                    d3 = 1.0;
                    for (n3 = n4; n3 < n + 1; ++n3) {
                        d2 = d3 * dArray5[n3];
                        int n21 = n3;
                        dArray5[n21] = dArray5[n21] * d10;
                        d11 = d7 + Math.abs(d2);
                        if (d11 == d7) continue;
                        d4 = dArray2[n3];
                        dArray2[n3] = d = PolyWarpSolver.hypot(d2, d4);
                        d10 = d4 / d;
                        d3 = -d2 / d;
                        for (n2 = 0; n2 < n6; ++n2) {
                            d9 = dArray3[n2][n5];
                            d8 = dArray3[n2][n3];
                            dArray3[n2][n5] = d9 * d10 + d8 * d3;
                            dArray3[n2][n3] = -d9 * d3 + d8 * d10;
                        }
                    }
                }
                d8 = dArray2[n];
                if (n4 == n) {
                    if (!(d8 < 0.0)) continue block29;
                    dArray2[n] = -d8;
                    for (n2 = 0; n2 < n7; ++n2) {
                        dArray4[n2][n] = -dArray4[n2][n];
                    }
                    continue block29;
                }
                if (n20 == 30) {
                    return false;
                }
                ++n20;
                d6 = dArray2[n4];
                d9 = dArray2[n19];
                d4 = dArray5[n19];
                d = dArray5[n];
                d2 = 0.5 * ((d4 + d8) / d * ((d4 - d8) / d9) + d9 / d - d / d9);
                d4 = PolyWarpSolver.hypot(d2, 1.0);
                d2 = d6 - d8 / d6 * d8 + d / d6 * (d9 / (d2 + PolyWarpSolver.sign(d4, d2)) - d);
                d10 = 1.0;
                d3 = 1.0;
                for (int i = n4; i <= n19; ++i) {
                    n3 = i + 1;
                    d4 = dArray5[n3];
                    d9 = dArray2[n3];
                    d = d3 * d4;
                    d4 = d10 * d4;
                    dArray5[i] = d8 = PolyWarpSolver.hypot(d2, d);
                    d10 = d2 / d8;
                    d3 = d / d8;
                    d2 = d6 * d10 + d4 * d3;
                    d4 = -d6 * d3 + d4 * d10;
                    d = d9 * d3;
                    d9 *= d10;
                    for (n2 = 0; n2 < n7; ++n2) {
                        d6 = dArray4[n2][i];
                        d8 = dArray4[n2][n3];
                        dArray4[n2][i] = d6 * d10 + d8 * d3;
                        dArray4[n2][n3] = -d6 * d3 + d8 * d10;
                    }
                    dArray2[i] = d8 = PolyWarpSolver.hypot(d2, d);
                    if (d8 != 0.0) {
                        d10 = d2 / d8;
                        d3 = d / d8;
                    }
                    d2 = d10 * d4 + d3 * d9;
                    d6 = -d3 * d4 + d10 * d9;
                    for (n2 = 0; n2 < n6; ++n2) {
                        d9 = dArray3[n2][i];
                        d8 = dArray3[n2][n3];
                        dArray3[n2][i] = d9 * d10 + d8 * d3;
                        dArray3[n2][n3] = -d9 * d3 + d8 * d10;
                    }
                }
                dArray5[n4] = 0.0;
                dArray5[n] = d2;
                dArray2[n] = d6;
            }
        }
        return true;
    }

    public static float[] getCoeffs(float[] fArray, int n, float[] fArray2, int n2, int n3, float f, float f2, float f3, float f4, int n4) {
        int n5;
        double d;
        Object object;
        int n6;
        int n7 = n3 / 2;
        int n8 = (n4 + 1) * (n4 + 2) / 2;
        float[] fArray3 = new float[2 * n8];
        if (n4 == 1 && n3 == 3) {
            double d2 = fArray[0] * f;
            double d3 = fArray[1] * f2;
            double d4 = fArray[2] * f;
            double d5 = fArray[3] * f2;
            double d6 = fArray[4] * f2;
            double d7 = fArray[5] * f2;
            double d8 = fArray2[0] / f3;
            double d9 = fArray2[1] / f4;
            double d10 = fArray2[2] / f3;
            double d11 = fArray2[3] / f4;
            double d12 = fArray2[4] / f3;
            double d13 = fArray2[5] / f4;
            double d14 = d9 - d11;
            double d15 = d11 - d13;
            double d16 = d13 - d9;
            double d17 = d10 - d8;
            double d18 = d12 - d10;
            double d19 = d8 - d12;
            double d20 = d10 * d13 - d12 * d11;
            double d21 = d12 * d9 - d8 * d13;
            double d22 = d8 * d11 - d10 * d9;
            double d23 = 1.0 / (d8 * d15 + d9 * d18 + d20);
            fArray3[0] = (float)((d15 * d2 + d16 * d4 + d14 * d6) * d23);
            fArray3[1] = (float)((d18 * d2 + d19 * d4 + d17 * d6) * d23);
            fArray3[2] = (float)((d20 * d2 + d21 * d4 + d22 * d6) * d23);
            fArray3[3] = (float)((d15 * d3 + d16 * d5 + d14 * d7) * d23);
            fArray3[4] = (float)((d18 * d3 + d19 * d5 + d17 * d7) * d23);
            fArray3[5] = (float)((d20 * d3 + d21 * d5 + d22 * d7) * d23);
            return fArray3;
        }
        double[][] dArray = new double[n7][n8];
        double[] dArray2 = new double[n4 + 1];
        double[] dArray3 = new double[n4 + 1];
        for (n6 = 0; n6 < n7; ++n6) {
            int n9;
            object = dArray[n6];
            double d24 = fArray2[2 * n6 + n2] / f3;
            d = fArray2[2 * n6 + 1 + n2] / f4;
            double d25 = 1.0;
            double d26 = 1.0;
            for (n9 = 0; n9 <= n4; ++n9) {
                dArray2[n9] = d25;
                dArray3[n9] = d26;
                d25 *= d24;
                d26 *= d;
            }
            n9 = 0;
            for (int i = 0; i <= n4; ++i) {
                for (int j = 0; j <= i; ++j) {
                    object[n9++] = dArray2[i - j] * dArray3[j];
                }
            }
        }
        object = new double[n8][n8];
        double[] dArray4 = new double[n8];
        double[][] dArray5 = new double[n7][n8];
        PolyWarpSolver.SVD(dArray, dArray4, dArray5, (double[][])object);
        for (n5 = 0; n5 < n8; ++n5) {
            d = dArray4[n5];
            if (d != 0.0) {
                d = 1.0 / d;
            }
            for (n6 = 0; n6 < n8; ++n6) {
                double d27 = object[n6];
                int n10 = n5;
                d27[n10] = d27[n10] * d;
            }
        }
        double[][] dArray6 = PolyWarpSolver.matmul_t((double[][])object, dArray5);
        for (n6 = 0; n6 < n8; ++n6) {
            double d28 = 0.0;
            double d29 = 0.0;
            for (n5 = 0; n5 < n7; ++n5) {
                double d30 = dArray6[n6][n5];
                d28 += d30 * (double)fArray[2 * n5 + n] * (double)f;
                d29 += d30 * (double)fArray[2 * n5 + 1 + n] * (double)f2;
            }
            fArray3[n6] = (float)d28;
            fArray3[n6 + n8] = (float)d29;
        }
        return fArray3;
    }

    private static float xpoly(float f, float f2) {
        return (float)(c0[0] + c0[1] * (double)f + c0[2] * (double)f2 + c0[3] * (double)f * (double)f + c0[4] * (double)f * (double)f2 + c0[5] * (double)f2 * (double)f2 + myRandom.nextDouble() * noise);
    }

    private static float ypoly(float f, float f2) {
        return (float)(c1[0] + c1[1] * (double)f + c1[2] * (double)f2 + c1[3] * (double)f * (double)f + c1[4] * (double)f * (double)f2 + c1[5] * (double)f2 * (double)f2 + myRandom.nextDouble() * noise);
    }

    private static void doTest(int n, boolean bl) {
        for (int i = 0; i < 6; ++i) {
            PolyWarpSolver.c0[i] = myRandom.nextDouble() * 100.0;
            PolyWarpSolver.c1[i] = myRandom.nextDouble() * 100.0;
        }
        float[] fArray = new float[2 * n];
        for (int i = 0; i < 2 * n; ++i) {
            fArray[i] = myRandom.nextFloat() * 100.0f;
        }
        float[] fArray2 = new float[2 * n];
        for (int i = 0; i < n; ++i) {
            fArray2[2 * i] = PolyWarpSolver.xpoly(fArray[2 * i], fArray[2 * i + 1]);
            fArray2[2 * i + 1] = PolyWarpSolver.ypoly(fArray[2 * i], fArray[2 * i + 1]);
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray2, 0, fArray, 0, fArray2.length, 0.5f, 0.5f, 2.0f, 2.0f, 2);
        if (bl) {
            System.out.println("Using " + n + " equations:");
            for (int i = 0; i < 6; ++i) {
                System.out.println("c0[" + i + "] = " + c0[i] + ", recovered as " + fArray3[i] + " (ratio = " + c0[i] / (double)fArray3[i] + ")");
                System.out.println("c1[" + i + "] = " + c1[i] + ", recovered as " + fArray3[i + 6] + " (ratio = " + c1[i] / (double)fArray3[i + 6] + ")");
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        for (n = 0; n < 3; ++n) {
            PolyWarpSolver.doTest(6 + 50 * n, true);
            System.out.println();
        }
        n = 10000;
        int n2 = 6;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            PolyWarpSolver.doTest(n2, false);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Did " + n + " " + n2 + "-point solutions in " + (float)(l2 - l) / 1000.0f + " seconds.");
        System.out.println("Rate = " + (float)n * 1000.0f / (float)(l2 - l) + " trials/second");
    }
}

