/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import mathematics.Maths;

public final class ArrayArithmetic {
    public static int[] Abs(int[] array) {
        int[] result = ArrayNew.Same(array);
        ArrayArithmetic.Abs(array, result);
        return result;
    }

    public static void Abs(int[] array, int[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = Math.abs(array[i]);
        }
    }

    public static int[][] Abs(int[][] array) {
        int[][] result = ArrayNew.Same(array);
        ArrayArithmetic.Abs(array, result);
        return result;
    }

    public static void Abs(int[][] array, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                result[y][x] = Math.abs(array[y][x]);
            }
        }
    }

    public static float[] Abs(float[] array) {
        float[] result = ArrayNew.Same(array);
        ArrayArithmetic.Abs(array, result);
        return result;
    }

    public static void Abs(float[] array, float[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = Math.abs(array[i]);
        }
    }

    public static double[] Abs(double[] array) {
        double[] result = ArrayNew.Same(array);
        ArrayArithmetic.Abs(array, result);
        return result;
    }

    public static void Abs(double[] array, double[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = Math.abs(array[i]);
        }
    }

    public static double[][] Abs(double[][] array) {
        double[][] result = ArrayNew.Same(array);
        ArrayArithmetic.Abs(array, result);
        return result;
    }

    public static void Abs(double[][] array, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int y = 0; y < array.length; ++y) {
            for (int x = 0; x < array[0].length; ++x) {
                result[y][x] = Math.abs(array[y][x]);
            }
        }
    }

    public static int[][] Add(int[][] Tab1, int[][] Tab2) {
        int[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(int[][] Tab1, int[][] Tab2, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab1[y][x] + Tab2[y][x];
            }
        }
    }

    public static double[][] Add(double[][] Tab1, double[][] Tab2) {
        double[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(double[][] Tab1, double[][] Tab2, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab1[y][x] + Tab2[y][x];
            }
        }
    }

    public static float[][] Add(float[][] Tab1, float[][] Tab2) {
        float[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(float[][] Tab1, float[][] Tab2, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab1[y][x] + Tab2[y][x];
            }
        }
    }

    public static int[][] Add(int[][] Tab, int Value) {
        int[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(int[][] Tab, int Value, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab[y][x] + Value;
            }
        }
    }

    public static double[][] Add(double[][] Tab, double Value) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(double[][] Tab, double Value, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab[y][x] + Value;
            }
        }
    }

    public static float[][] Add(float[][] Tab, float Value) {
        float[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(float[][] Tab, float Value, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab[y][x] + Value;
            }
        }
    }

    public static int[] Add(int[] Tab, int Value) {
        int[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(int[] Tab, int Value, int[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] + Value;
        }
    }

    public static int[] Add(int[] Tab1, int[] Tab2) {
        int[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(int[] Tab1, int[] Tab2, int[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] + Tab2[x];
        }
    }

    public static int[] Add(int[] Tab, int Value, int MaxValue, int SafeValue) {
        int[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(int[] Tab, int Value, int[] Result, int MaxValue, int SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        long add = 0L;
        for (int x = 0; x < Tab.length; ++x) {
            add = (long)Tab[x] + (long)Value;
            Result[x] = (long)MaxValue < add ? SafeValue : (int)add;
        }
    }

    public static int[] Add(int[] Tab1, int[] Tab2, int MaxValue, int SafeValue) {
        int[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(int[] Tab1, int[] Tab2, int[] Result, int MaxValue, int SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        long add = 0L;
        for (int x = 0; x < Tab1.length; ++x) {
            add = Tab1[x] + Tab2[x];
            Result[x] = (long)MaxValue < add ? SafeValue : (int)add;
        }
    }

    public static void Add(int[] Tab1, boolean[] Tab2, int[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] + (Tab2[x] ? 1 : 0);
        }
    }

    public static double[] Add(double[] Tab, double Value) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(double[] Tab, double Value, double[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] + Value;
        }
    }

    public static double[] Add(double[] Tab1, double[] Tab2) {
        double[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(double[] Tab1, double[] Tab2, double[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] + Tab2[x];
        }
    }

    public static double[] Add(double[] Tab, double Value, double MaxValue, double SafeValue) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(double[] Tab, double Value, double[] Result, double MaxValue, double SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        double add = 0.0;
        for (int x = 0; x < Tab.length; ++x) {
            add = Tab[x] + Value;
            Result[x] = MaxValue < add ? SafeValue : add;
        }
    }

    public static double[] Add(double[] Tab1, double[] Tab2, double MaxValue, double SafeValue) {
        double[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(double[] Tab1, double[] Tab2, double[] Result, double MaxValue, double SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        double add = 0.0;
        for (int x = 0; x < Tab1.length; ++x) {
            add = Tab1[x] + Tab2[x];
            Result[x] = MaxValue < add ? SafeValue : add;
        }
    }

    public static float[] Add(float[] Tab, float Value) {
        float[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res);
        return res;
    }

    public static void Add(float[] Tab, float Value, float[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] + Value;
        }
    }

    public static float[] Add(float[] Tab1, float[] Tab2) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(float[] Tab1, float[] Tab2, float[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] + Tab2[x];
        }
    }

    public static float[] Add(float[] Tab1, byte[] Tab2) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res);
        return res;
    }

    public static void Add(float[] Tab1, byte[] Tab2, float[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] + (float)(Tab2[x] & 0xFF);
        }
    }

    public static float[] Add(float[] Tab, float Value, float MaxValue, float SafeValue) {
        float[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Add(Tab, Value, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(float[] Tab, float Value, float[] Result, float MaxValue, float SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        double add = 0.0;
        for (int x = 0; x < Tab.length; ++x) {
            add = Tab[x] + Value;
            Result[x] = (double)MaxValue < add ? SafeValue : (float)add;
        }
    }

    public static float[] Add(float[] Tab1, float[] Tab2, float MaxValue, float SafeValue) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(float[] Tab1, float[] Tab2, float[] Result, float MaxValue, float SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        double add = 0.0;
        for (int x = 0; x < Tab1.length; ++x) {
            add = Tab1[x] + Tab2[x];
            Result[x] = (double)MaxValue < add ? SafeValue : (float)add;
        }
    }

    public static float[] Add(float[] Tab1, byte[] Tab2, float MaxValue, float SafeValue) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Add(Tab1, Tab2, res, MaxValue, SafeValue);
        return res;
    }

    public static void Add(float[] Tab1, byte[] Tab2, float[] Result, float MaxValue, float SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        double add = 0.0;
        for (int x = 0; x < Tab1.length; ++x) {
            add = (double)Tab1[x] + (double)(Tab2[x] & 0xFF);
            Result[x] = (double)MaxValue < add ? SafeValue : (float)add;
        }
    }

    public static byte[] AddUnsigned(byte[] Tab1, byte[] Tab2, byte Threshold, byte SafeValue) {
        byte[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[] Tab1, byte[] Tab2, byte[] Result, byte Threshold, byte SafeValue) {
        int thres = Threshold & 0xFF;
        int safe = SafeValue & 0xFF;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            int sum = (Tab1[x] & 0xFF) + (Tab2[x] & 0xFF);
            Result[x] = (byte)(thres < sum ? safe : sum);
        }
    }

    public static byte[] AddUnsigned(byte[] Tab, byte Value, byte Threshold, byte SafeValue) {
        byte[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[] Tab, byte Value, byte[] Result, byte Threshold, byte SafeValue) {
        int thres = Threshold & 0xFF;
        int safe = SafeValue & 0xFF;
        int val = Value & 0xFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            int sum = (Tab[x] & 0xFF) + val;
            Result[x] = (byte)(thres < sum ? safe : sum);
        }
    }

    public static byte[] AddUnsigned(byte[] Tab1, byte[] Tab2) {
        byte[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void AddUnsigned(byte[] Tab1, byte[] Tab2, byte[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (byte)((Tab1[x] & 0xFF) + (Tab2[x] & 0xFF));
        }
    }

    public static byte[] AddUnsigned(byte[] Tab, byte Value) {
        byte[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res);
        return res;
    }

    public static void AddUnsigned(byte[] Tab, byte Value, byte[] Result) {
        int val = Value & 0xFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (byte)((Tab[x] & 0xFF) + val);
        }
    }

    public static short[] AddUnsigned(short[] Tab1, short[] Tab2) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void AddUnsigned(short[] Tab1, short[] Tab2, short[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) + (Tab2[x] & 0xFFFF));
        }
    }

    public static short[] AddUnsigned(short[] Tab, short Value) {
        short[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res);
        return res;
    }

    public static void AddUnsigned(short[] Tab, short Value, short[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int val = Value & 0xFFFF;
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (short)((Tab[x] & 0xFFFF) + val);
        }
    }

    public static short[] AddUnsigned(short[] Tab1, short[] Tab2, short Threshold, short SafeValue) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[] Tab1, short[] Tab2, short[] Result, short Threshold, short SafeValue) {
        int thre = Threshold & 0xFFFF;
        int safe = SafeValue & 0xFFFF;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            int sum = (Tab1[x] & 0xFFFF) + (Tab2[x] & 0xFFFF);
            Result[x] = (short)(thre < sum ? safe : sum);
        }
    }

    public static short[] AddUnsigned(short[] Tab1, byte[] Tab2, int Threshold, int SafeValue) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[] Tab1, byte[] Tab2, short[] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            sum = (Tab1[x] & 0xFFFF) + (Tab2[x] & 0xFF);
            Result[x] = (short)(Threshold < sum ? SafeValue : sum);
        }
    }

    public static short[] AddUnsigned(short[] Tab1, byte[] Tab2) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void AddUnsigned(short[] Tab1, byte[] Tab2, short[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) + (Tab2[x] & 0xFF));
        }
    }

    public static short[] AddUnsigned(short[] Tab, short Value, short Threshold, short SafeValue) {
        short[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[] Tab, short Value, short[] Result, short Threshold, short SafeValue) {
        int thre = Threshold & 0xFFFF;
        int safe = SafeValue & 0xFFFF;
        int val = Value & 0xFFFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            int sum = (Tab[x] & 0xFFFF) + val;
            Result[x] = (short)(thre < sum ? safe : sum);
        }
    }

    public static void AddUnsigned(byte[] Tab1, byte[] Tab2, short[] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            sum = (Tab1[x] & 0xFF) + (Tab2[x] & 0xFF);
            Result[x] = (short)(Threshold < sum ? SafeValue : sum);
        }
    }

    public static short[] AddUnsigned(byte[] Tab1, short[] Tab2, int Threshold, int SafeValue) {
        short[] res = ArrayNew.Same(Tab2);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[] Tab1, short[] Tab2, short[] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            sum = (Tab1[x] & 0xFF) + (Tab2[x] & 0xFFFF);
            Result[x] = (short)(Threshold < sum ? SafeValue : sum);
        }
    }

    public static byte[][] AddUnsigned(byte[][] Tab1, byte[][] Tab2, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[][] Tab1, byte[][] Tab2, byte[][] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum = (Tab1[y][x] & 0xFF) + (Tab2[y][x] & 0xFF);
                Result[y][x] = (byte)(Threshold < sum ? SafeValue : sum);
            }
        }
    }

    public static byte[][] AddUnsigned(byte[][] Tab, int Value, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[][] Tab, int Value, byte[][] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum = (Tab[y][x] & 0xFF) + Value;
                Result[y][x] = (byte)(Threshold < sum ? SafeValue : sum);
            }
        }
    }

    public static short[][] AddUnsigned(short[][] Tab1, short[][] Tab2, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.AddUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[][] Tab1, short[][] Tab2, short[][] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum = (Tab1[y][x] & 0xFFFF) + (Tab2[y][x] & 0xFFFF);
                Result[y][x] = (short)(Threshold < sum ? SafeValue : sum);
            }
        }
    }

    public static short[][] AddUnsigned(short[][] Tab, int Value, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[][] Tab, int Value, short[][] Result, int Threshold, int SafeValue) {
        int sum = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum = (Tab[y][x] & 0xFFFF) + Value;
                Result[y][x] = (short)(Threshold < sum ? SafeValue : sum);
            }
        }
    }

    public static byte[] AddUnsigned(byte[] Tab, int[][] Array, int Threshold, int SafeValue) {
        byte[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Array, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(byte[] Tab, int[][] Array, byte[] Result, int Threshold, int SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int sum = 0;
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                sum = (Tab[pos] & 0xFF) + Array[y][x];
                Result[pos] = (byte)(Threshold < sum ? SafeValue : sum);
                ++x;
                ++pos;
            }
        }
    }

    public static short[] AddUnsigned(short[] Tab, int[][] Array, int Threshold, int SafeValue) {
        short[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.AddUnsigned(Tab, Array, res, Threshold, SafeValue);
        return res;
    }

    public static void AddUnsigned(short[] Tab, int[][] Array, short[] Result, int Threshold, int SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int sum = 0;
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                sum = (Tab[pos] & 0xFFFF) + Array[y][x];
                Result[pos] = (short)(Threshold < sum ? SafeValue : sum);
                ++x;
                ++pos;
            }
        }
    }

    public static void AddUnsigned(byte[] Tab, int[][] Array, int[][] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Result[y][x] = (Tab[pos] & 0xFF) + Array[y][x];
                ++x;
                ++pos;
            }
        }
    }

    public static void AddUnsigned(short[] Tab, int[][] Array, int[][] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Result[y][x] = (Tab[pos] & 0xFFFF) + Array[y][x];
                ++x;
                ++pos;
            }
        }
    }

    public static void AddUnsigned(byte[] Tab, double[][] Array, double[][] Result) {
        if (Array.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Result[y][x] = (double)(Tab[pos] & 0xFF) + Array[y][x];
                ++x;
                ++pos;
            }
        }
    }

    public static void AddUnsigned(short[] Tab, double[][] Array, double[][] Result) {
        if (Array.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Array[0].length != Result[0].length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Result[y][x] = (double)(Tab[pos] & 0xFFFF) + Array[y][x];
                ++x;
                ++pos;
            }
        }
    }

    public static void AddUnsigned(byte[] Tab, int[] Array, int[] Result) {
        if (Tab.length != Result.length || Tab.length != Array.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        ArrayArithmetic.AddUnsigned(Tab, 0, Array, 0, Result, 0, Result.length);
    }

    public static void AddUnsigned(short[] Tab, int[] Array, int[] Result) {
        if (Tab.length != Result.length || Tab.length != Array.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        ArrayArithmetic.AddUnsigned(Tab, 0, Array, 0, Result, 0, Result.length);
    }

    public static void AddUnsigned(byte[] Tab, double[] Array, double[] Result) {
        if (Tab.length != Result.length || Tab.length != Array.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (double)(Tab[x] & 0xFF) + Array[x];
        }
    }

    public static void AddUnsigned(short[] Tab, double[] Array, double[] Result) {
        if (Tab.length != Result.length || Tab.length != Array.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (double)(Tab[x] & 0xFFFF) + Array[x];
        }
    }

    public static void AddBinary(byte[] Tab, int[][] Array, int[][] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        byte tmp = 0;
        int width = Array[0].length;
        int height = Array.length;
        if (Tab.length != width * height) {
            throw new IllegalArgumentException("Arrays have different lengths (Tab.length != width*height).");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (x % 8 == 0) {
                    tmp = Tab[pos++];
                }
                Result[y][x] = ((tmp & 1 << 7 - x % 8) != 0 ? 1 : 0) + Array[y][x];
                ++x;
                ++pos;
            }
        }
    }

    public static int[][] Subtract(int[][] Tab1, int[][] Tab2) {
        int[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res);
        return res;
    }

    public static void Subtract(int[][] Tab1, int[][] Tab2, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab1[y][x] - Tab2[y][x];
            }
        }
    }

    public static double[][] Subtract(double[][] Tab1, double[][] Tab2) {
        double[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res);
        return res;
    }

    public static void Subtract(double[][] Tab1, double[][] Tab2, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab1[y][x] - Tab2[y][x];
            }
        }
    }

    public static int[] Subtract(int[] Tab, int Value) {
        int[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res);
        return res;
    }

    public static void Subtract(int[] Tab, int Value, int[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] - Value;
        }
    }

    public static int[] Subtract(int[] Tab1, int[] Tab2) {
        int[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res);
        return res;
    }

    public static void Subtract(int[] Tab1, int[] Tab2, int[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] - Tab2[x];
        }
    }

    public static int[] Subtract(int[] Tab, int Value, int MinValue, int SafeValue) {
        int[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(int[] Tab, int Value, int[] Result, int MinValue, int SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            long sub = Tab[x] - Value;
            Result[x] = sub < (long)MinValue ? SafeValue : (int)sub;
        }
    }

    public static int[] Subtract(int[] Tab1, int[] Tab2, int MinValue, int SafeValue) {
        int[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(int[] Tab1, int[] Tab2, int[] Result, int MinValue, int SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            long sub = Tab1[x] - Tab2[x];
            Result[x] = sub < (long)MinValue ? SafeValue : (int)sub;
        }
    }

    public static float[] Subtract(float[] Tab, float Value) {
        float[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res);
        return res;
    }

    public static void Subtract(float[] Tab, float Value, float[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] - Value;
        }
    }

    public static float[] Subtract(float[] Tab1, float[] Tab2) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res);
        return res;
    }

    public static void Subtract(float[] Tab1, float[] Tab2, float[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] - Tab2[x];
        }
    }

    public static float[] Subtract(float[] Tab, float Value, float MinValue, float SafeValue) {
        float[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(float[] Tab, float Value, float[] Result, float MinValue, float SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            double sub = Tab[x] - Value;
            Result[x] = sub < (double)MinValue ? SafeValue : (float)sub;
        }
    }

    public static float[] Subtract(float[] Tab1, float[] Tab2, float MinValue, float SafeValue) {
        float[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(float[] Tab1, float[] Tab2, float[] Result, float MinValue, float SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            double sub = Tab1[x] - Tab2[x];
            Result[x] = sub < (double)MinValue ? SafeValue : (float)sub;
        }
    }

    public static double[] Subtract(double[] Tab, double Value) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res);
        return res;
    }

    public static void Subtract(double[] Tab, double Value, double[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Tab[x] - Value;
        }
    }

    public static double[] Subtract(double[] Tab1, double[] Tab2) {
        double[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res);
        return res;
    }

    public static void Subtract(double[] Tab1, double[] Tab2, double[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = Tab1[x] - Tab2[x];
        }
    }

    public static double[] Subtract(double[] Tab, double Value, double MinValue, double SafeValue) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(double[] Tab, double Value, double[] Result, double MinValue, double SafeValue) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            double sub = Tab[x] - Value;
            Result[x] = sub < MinValue ? SafeValue : sub;
        }
    }

    public static double[] Subtract(double[] Tab1, double[] Tab2, double MinValue, double SafeValue) {
        double[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.Subtract(Tab1, Tab2, res, MinValue, SafeValue);
        return res;
    }

    public static void Subtract(double[] Tab1, double[] Tab2, double[] Result, double MinValue, double SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            double sub = Tab1[x] - Tab2[x];
            Result[x] = sub < MinValue ? SafeValue : sub;
        }
    }

    public static int[][] Subtract(int[][] Tab, int Value) {
        int[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res);
        return res;
    }

    public static void Subtract(int[][] Tab, int Value, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab[y][x] - Value;
            }
        }
    }

    public static double[][] Subtract(double[][] Tab, double Value) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Subtract(Tab, Value, res);
        return res;
    }

    public static void Subtract(double[][] Tab, double Value, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(Tab, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Tab[y][x] - Value;
            }
        }
    }

    public static byte[] SubtractUnsigned(byte[] Tab1, byte[] Tab2) {
        byte[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void SubtractUnsigned(byte[] Tab1, byte[] Tab2, byte[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (byte)((Tab1[x] & 0xFF) - (Tab2[x] & 0xFF));
        }
    }

    public static void SubtractUnsigned(byte[] Tab1, byte[] Tab2, float[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (Tab1[x] & 0xFF) - (Tab2[x] & 0xFF);
        }
    }

    public static void SubtractUnsigned(byte[] Tab1, byte[] Tab2, double[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (Tab1[x] & 0xFF) - (Tab2[x] & 0xFF);
        }
    }

    public static byte[] SubtractUnsigned(byte[] Tab1, byte[] Tab2, byte Threshold, byte SafeValue) {
        byte[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(byte[] Tab1, byte[] Tab2, byte[] Result, byte Threshold, byte SafeValue) {
        int thre = Threshold & 0xFF;
        int safe = SafeValue & 0xFF;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            int sub = (Tab1[x] & 0xFF) - (Tab2[x] & 0xFF);
            Result[x] = (byte)(sub < thre ? safe : sub);
        }
    }

    public static byte[] SubtractUnsigned(byte[] Tab, byte Value) {
        byte[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res);
        return res;
    }

    public static void SubtractUnsigned(byte[] Tab, byte Value, byte[] Result) {
        int val = Value & 0xFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (byte)((Tab[x] & 0xFF) - val);
        }
    }

    public static byte[] SubtractUnsigned(byte[] Tab, byte Value, byte Threshold, byte SafeValue) {
        byte[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(byte[] Tab, byte Value, byte[] Result, byte Threshold, byte SafeValue) {
        int val = Value & 0xFF;
        int thre = Threshold & 0xFF;
        int safe = SafeValue & 0xFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            int sub = (Tab[x] & 0xFF) - val;
            Result[x] = (byte)(sub < thre ? safe : sub);
        }
    }

    public static short[] SubtractUnsigned(short[] Tab1, short[] Tab2) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab1, short[] Tab2, short[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFFFF));
        }
    }

    public static void SubtractUnsigned(short[] Tab1, short[] Tab2, float[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFFFF));
        }
    }

    public static void SubtractUnsigned(short[] Tab1, short[] Tab2, double[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFFFF));
        }
    }

    public static short[] SubtractUnsigned(short[] Tab1, short[] Tab2, short Threshold, short SafeValue) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab1, short[] Tab2, short[] Result, short Threshold, short SafeValue) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int thre = Threshold & 0xFFFF;
        int safe = SafeValue & 0xFFFF;
        for (int x = 0; x < Tab1.length; ++x) {
            int sub = (Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFFFF);
            Result[x] = (short)(sub < thre ? safe : sub);
        }
    }

    public static short[] SubtractUnsigned(short[] Tab1, byte[] Tab2) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab1, byte[] Tab2, short[] Result) {
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Result[x] = (short)((Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFF));
        }
    }

    public static short[] SubtractUnsigned(short[] Tab1, byte[] Tab2, int Threshold, int SafeValue) {
        short[] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab1, byte[] Tab2, short[] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            sub = (Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFF);
            Result[x] = (short)(sub < Threshold ? SafeValue : sub);
        }
    }

    public static short[] SubtractUnsigned(short[] Tab, short Value) {
        short[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab, short Value, short[] Result) {
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        int val = Value & 0xFFFF;
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = (short)((Tab[x] & 0xFFFF) - val);
        }
    }

    public static short[] SubtractUnsigned(short[] Tab, short Value, short Threshold, short SafeValue) {
        short[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(short[] Tab, short Value, short[] Result, short Threshold, short SafeValue) {
        int val = Value & 0xFFFF;
        int thre = Threshold & 0xFFFF;
        int safe = SafeValue & 0xFFFF;
        if (Tab.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab.length; ++x) {
            int sub = (Tab[x] & 0xFFFF) - val;
            Result[x] = (short)(sub < thre ? safe : sub);
        }
    }

    public static byte[][] SubtractUnsigned(byte[][] Tab1, byte[][] Tab2, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(byte[][] Tab1, byte[][] Tab2, byte[][] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sub = (Tab1[y][x] & 0xFF) - (Tab2[y][x] & 0xFF);
                Result[y][x] = (byte)(sub < Threshold ? SafeValue : sub);
            }
        }
    }

    public static byte[][] SubtractUnsigned(byte[][] Tab, int Value, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(byte[][] Tab, int Value, byte[][] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sub = (Tab[y][x] & 0xFF) - Value;
                Result[y][x] = (byte)(sub < Threshold ? SafeValue : sub);
            }
        }
    }

    public static short[][] SubtractUnsigned(short[][] Tab1, short[][] Tab2, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(short[][] Tab1, short[][] Tab2, short[][] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sub = (Tab1[y][x] & 0xFFFF) - (Tab2[y][x] & 0xFFFF);
                Result[y][x] = (short)(sub < Threshold ? SafeValue : sub);
            }
        }
    }

    public static short[][] SubtractUnsigned(short[][] Tab, int Value, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.SubtractUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void SubtractUnsigned(short[][] Tab, int Value, short[][] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sub = (Tab[y][x] & 0xFFFF) - Value;
                Result[y][x] = (short)(sub < Threshold ? SafeValue : sub);
            }
        }
    }

    public static void SubtractUnsigned(short[] Tab1, byte[] Tab2, byte[] Result, int Threshold, int SafeValue) {
        int sub = 0;
        if (Tab1.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (Tab1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            sub = (Tab1[x] & 0xFFFF) - (Tab2[x] & 0xFF);
            Result[x] = (byte)(sub < Threshold ? SafeValue : sub);
        }
    }

    public static byte[] MultiplyUnsigned(byte[] Tab1, int val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        byte[] res = new byte[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(byte[] source, int Value, byte[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            int val = (source[x] & 0xFF) * Value;
            result[x] = val < minvalue ? (byte)safetymin : (maxvalue < val ? (byte)safetymax : (byte)val);
        }
    }

    public static byte[] MultiplyUnsigned(byte[] Tab1, int val) {
        byte[] res = new byte[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res);
        return res;
    }

    public static void MultiplyUnsigned(byte[] source, int Value, byte[] result) {
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)((source[x] & 0xFF) * Value);
        }
    }

    public static byte[] MultiplyUnsigned(byte[] Tab1, double val) {
        byte[] res = new byte[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res);
        return res;
    }

    public static void MultiplyUnsigned(byte[] source, double Value, byte[] result) {
        for (int x = 0; x < source.length; ++x) {
            result[x] = (byte)((double)(source[x] & 0xFF) * Value + 0.5);
        }
    }

    public static short[] MultiplyUnsigned(short[] Tab1, int val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        short[] res = new short[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(short[] source, int Value, short[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            int val = (source[x] & 0xFFFF) * Value;
            result[x] = val < minvalue ? (short)safetymin : (maxvalue < val ? (short)safetymax : (short)val);
        }
    }

    public static short[] MultiplyUnsigned(short[] Tab1, int val) {
        short[] res = new short[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res);
        return res;
    }

    public static void MultiplyUnsigned(short[] source, int Value, short[] result) {
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)((source[x] & 0xFFFF) * Value);
        }
    }

    public static short[] MultiplyUnsigned(short[] Tab1, double val) {
        short[] res = new short[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res);
        return res;
    }

    public static void MultiplyUnsigned(short[] source, double Value, short[] result) {
        for (int x = 0; x < source.length; ++x) {
            result[x] = (short)((double)(source[x] & 0xFFFF) * Value + 0.5);
        }
    }

    public static void MultiplyUnsigned(byte[] source, int Value, short[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            int val = (source[x] & 0xFF) * Value;
            result[x] = val < minvalue ? (short)safetymin : (maxvalue < val ? (short)safetymax : (short)val);
        }
    }

    public static int[] Multiply(int[] Tab1, int val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        int[] res = new int[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(int[] source, int Value, int[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            int val = source[x] * Value;
            result[x] = val < minvalue ? safetymin : (maxvalue < val ? safetymax : val);
        }
    }

    public static byte[] MultiplyUnsigned(byte[] Tab1, double val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        byte[] res = new byte[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(byte[] source, double Value, byte[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            double v = (double)(source[x] & 0xFF) * Value;
            int val = (int)(v < 0.0 ? v - 0.5 : v + 0.5);
            result[x] = val < minvalue ? (byte)safetymin : (maxvalue < val ? (byte)safetymax : (byte)val);
        }
    }

    public static short[] MultiplyUnsigned(short[] Tab1, double val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        short[] res = new short[Tab1.length];
        ArrayArithmetic.MultiplyUnsigned(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(short[] source, double Value, short[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            double v = (double)(source[x] & 0xFFFF) * Value;
            int val = (int)(v < 0.0 ? v - 0.5 : v + 0.5);
            result[x] = val < minvalue ? (short)safetymin : (maxvalue < val ? (short)safetymax : (short)val);
        }
    }

    public static void MultiplyUnsigned(byte[] source, double Value, short[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            double v = (double)(source[x] & 0xFF) * Value;
            int val = (int)(v < 0.0 ? v - 0.5 : v + 0.5);
            result[x] = val < minvalue ? (short)safetymin : (maxvalue < val ? (short)safetymax : (short)val);
        }
    }

    public static int[] Multiply(int[] Tab1, double val, int minvalue, int safetymin, int maxvalue, int safetymax) {
        int[] res = new int[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(int[] source, double Value, int[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < source.length; ++x) {
            double v = (double)source[x] * Value;
            int val = (int)(v < 0.0 ? v - 0.5 : v + 0.5);
            result[x] = val < minvalue ? safetymin : (maxvalue < val ? safetymax : val);
        }
    }

    public static float[] Multiply(float[] Tab1, float val, float minvalue, float safetymin, float maxvalue, float safetymax) {
        float[] res = new float[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(float[] source, float Value, float[] result, float minvalue, float safetymin, float maxvalue, float safetymax) {
        for (int x = 0; x < source.length; ++x) {
            float v = source[x] * Value;
            result[x] = v < minvalue ? safetymin : (maxvalue < v ? safetymax : v);
        }
    }

    public static double[] Multiply(double[] Tab1, double val, double minvalue, double safetymin, double maxvalue, double safetymax) {
        double[] res = new double[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(double[] source, double Value, double[] result, double minvalue, double safetymin, double maxvalue, double safetymax) {
        for (int x = 0; x < source.length; ++x) {
            double v = source[x] * Value;
            result[x] = v < minvalue ? safetymin : (maxvalue < v ? safetymax : v);
        }
    }

    public static byte[] MultiplyUnsigned(byte[] src1, byte[] src2, int maxvalue, int safetymax) {
        byte[] res = new byte[src2.length];
        ArrayArithmetic.MultiplyUnsigned(src1, src2, res, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(byte[] src1, byte[] src2, byte[] result, int maxvalue, int safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            int v = (src1[x] & 0xFF) * (src2[x] & 0xFF);
            result[x] = maxvalue < v ? (byte)safetymax : (byte)v;
        }
    }

    public static short[] MultiplyUnsigned(short[] src1, short[] src2, int maxvalue, int safetymax) {
        short[] res = new short[src2.length];
        ArrayArithmetic.MultiplyUnsigned(src1, src2, res, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(short[] src1, short[] src2, short[] result, int maxvalue, int safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            int v = (src1[x] & 0xFFFF) * (src2[x] & 0xFFFF);
            result[x] = maxvalue < v ? (short)safetymax : (short)v;
        }
    }

    public static int[] Multiply(int[] src1, int[] src2, int minvalue, int safetymin, int maxvalue, int safetymax) {
        int[] res = new int[src2.length];
        ArrayArithmetic.Multiply(src1, src2, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(int[] src1, int[] src2, int[] result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            int v = src1[x] * src2[x];
            result[x] = v < minvalue ? safetymin : (maxvalue < v ? safetymax : v);
        }
    }

    public static float[] Multiply(float[] src1, float[] src2, float minvalue, float safetymin, float maxvalue, float safetymax) {
        float[] res = new float[src2.length];
        ArrayArithmetic.Multiply(src1, src2, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(float[] src1, float[] src2, float[] result, float minvalue, float safetymin, float maxvalue, float safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            float v = src1[x] * src2[x];
            result[x] = v < minvalue ? safetymin : (maxvalue < v ? safetymax : v);
        }
    }

    public static double[] Multiply(double[] src1, double[] src2, double minvalue, double safetymin, double maxvalue, double safetymax) {
        double[] res = new double[src2.length];
        ArrayArithmetic.Multiply(src1, src2, res, minvalue, safetymin, maxvalue, safetymax);
        return res;
    }

    public static void Multiply(double[] src1, double[] src2, double[] result, double minvalue, double safetymin, double maxvalue, double safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            double v = src1[x] * src2[x];
            result[x] = v < minvalue ? safetymin : (maxvalue < v ? safetymax : v);
        }
    }

    public static short[] MultiplyUnsigned(byte[] src1, short[] src2, int maxvalue, int safetymax) {
        short[] res = new short[src2.length];
        ArrayArithmetic.MultiplyUnsigned(src1, src2, res, maxvalue, safetymax);
        return res;
    }

    public static void MultiplyUnsigned(byte[] src1, short[] src2, short[] result, int maxvalue, int safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            int v = (src1[x] & 0xFF) * (src2[x] & 0xFFFF);
            result[x] = maxvalue < v ? (short)safetymax : (short)v;
        }
    }

    public static void MultiplyUnsigned(byte[] src1, byte[] src2, short[] result, int maxvalue, int safetymax) {
        for (int x = 0; x < src1.length; ++x) {
            int v = (src1[x] & 0xFF) * (src2[x] & 0xFF);
            result[x] = maxvalue < v ? (short)safetymax : (short)v;
        }
    }

    public static int[] Multiply(int[] Tab1, int[] Tab2) {
        int[] res = new int[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, Tab2, res);
        return res;
    }

    public static void Multiply(int[] Tab1, int[] Tab2, int[] res) {
        if (Tab1.length != Tab2.length || res.length != Tab2.length) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            res[x] = Tab1[x] * Tab2[x];
        }
    }

    public static int[] Multiply(int[] Tab1, int val) {
        int[] res = new int[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(int[] Tab1, int val, int[] res) {
        if (!ArrayTools.areDimensionsEqual(Tab1, res)) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            res[x] = Tab1[x] * val;
        }
    }

    public static int[] Multiply(int[] Tab1, double val) {
        int[] res = new int[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(int[] Tab1, double val, int[] res) {
        if (!ArrayTools.areDimensionsEqual(Tab1, res)) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            res[x] = (int)((double)Tab1[x] * val);
        }
    }

    public static double[] Multiply(double[] Tab1, double[] Tab2) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        double[] res = new double[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, Tab2, res);
        return res;
    }

    public static void Multiply(double[] Tab1, double[] Tab2, double[] Res) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different lengths");
        }
        for (int x = 0; x < Tab1.length; ++x) {
            Res[x] = Tab1[x] * Tab2[x];
        }
    }

    public static int[][] Multiply(int[][] Tab1, int[][] Tab2) {
        int[][] res = new int[Tab1.length][Tab1[0].length];
        ArrayArithmetic.Multiply(Tab1, Tab2, res);
        return res;
    }

    public static void Multiply(int[][] Tab1, int[][] Tab2, int[][] Res) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2) || !ArrayTools.areDimensionsEqual(Tab1, Res)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Res[y][x] = Tab1[y][x] * Tab2[y][x];
            }
        }
    }

    public static double[][] Multiply(double[][] Tab1, double[][] Tab2) {
        double[][] res = new double[Tab1.length][Tab1[0].length];
        ArrayArithmetic.Multiply(Tab1, Tab2, res);
        return res;
    }

    public static void Multiply(double[][] Tab1, double[][] Tab2, double[][] Res) {
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2) || !ArrayTools.areDimensionsEqual(Tab1, Res)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Res[y][x] = Tab1[y][x] * Tab2[y][x];
            }
        }
    }

    public static double[][] Multiply(double[][] Tab1, double val) {
        double[][] res = new double[Tab1.length][Tab1[0].length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(double[][] Tab1, double val, double[][] res) {
        int width = Tab1[0].length;
        int height = Tab1.length;
        if (!ArrayTools.areDimensionsEqual(Tab1, res)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = Tab1[y][x] * val;
            }
        }
    }

    public static float[] Multiply(float[] Tab1, float val) {
        float[] res = new float[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(float[] Tab, float Value, float[] Res) {
        for (int x = 0; x < Tab.length; ++x) {
            Res[x] = Tab[x] * Value;
        }
    }

    public static double[] Multiply(double[] Tab1, double val) {
        double[] res = new double[Tab1.length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(double[] Tab, double Value, double[] Res) {
        for (int x = 0; x < Tab.length; ++x) {
            Res[x] = Tab[x] * Value;
        }
    }

    public static int[][] Multiply(int[][] Tab, int Value) {
        int[][] Res = new int[Tab.length][Tab[0].length];
        ArrayArithmetic.Multiply(Tab, Value, Res);
        return Res;
    }

    public static void Multiply(int[][] Tab, int Value, int[][] Res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Res[y][x] = Tab[y][x] * Value;
            }
        }
    }

    public static float[][] Multiply(float[][] Tab1, float val) {
        float[][] res = new float[Tab1.length][Tab1[0].length];
        ArrayArithmetic.Multiply(Tab1, val, res);
        return res;
    }

    public static void Multiply(float[][] Tab1, float val, float[][] res) {
        int width = Tab1[0].length;
        int height = Tab1.length;
        if (!ArrayTools.areDimensionsEqual(Tab1, res)) {
            throw new IllegalArgumentException("Arrays have different dimensions");
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = Tab1[y][x] * val;
            }
        }
    }

    public static byte[][] MultiplyUnsigned(byte[][] Tab1, byte[][] Tab2, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.SubtractUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void MultiplyUnsigned(byte[][] Tab1, byte[][] Tab2, byte[][] Result, int Threshold, int SafeValue) {
        int mult = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mult = (Tab1[y][x] & 0xFF) * (Tab2[y][x] & 0xFF);
                Result[y][x] = (byte)(Threshold < mult ? SafeValue : mult);
            }
        }
    }

    public static byte[][] MultiplyUnsigned(byte[][] Tab, int Value, int Threshold, int SafeValue) {
        byte[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.MultiplyUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void MultiplyUnsigned(byte[][] Tab, int Value, byte[][] Result, int Threshold, int SafeValue) {
        int mult = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mult = (Tab[y][x] & 0xFF) * Value;
                Result[y][x] = (byte)(Threshold < mult ? SafeValue : mult);
            }
        }
    }

    public static short[][] MultiplyUnsigned(short[][] Tab1, short[][] Tab2, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab1);
        ArrayArithmetic.MultiplyUnsigned(Tab1, Tab2, res, Threshold, SafeValue);
        return res;
    }

    public static void MultiplyUnsigned(short[][] Tab1, short[][] Tab2, short[][] Result, int Threshold, int SafeValue) {
        int mult = 0;
        if (!ArrayTools.areDimensionsEqual(Tab1, Tab2)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        if (!ArrayTools.areDimensionsEqual(Tab1, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab1[0].length;
        int height = Tab1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mult = (Tab1[y][x] & 0xFFFF) * (Tab2[y][x] & 0xFFFF);
                Result[y][x] = (short)(Threshold < mult ? SafeValue : mult);
            }
        }
    }

    public static short[][] MultiplyUnsigned(short[][] Tab, int Value, int Threshold, int SafeValue) {
        short[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.MultiplyUnsigned(Tab, Value, res, Threshold, SafeValue);
        return res;
    }

    public static void MultiplyUnsigned(short[][] Tab, int Value, short[][] Result, int Threshold, int SafeValue) {
        int mult = 0;
        if (!ArrayTools.areDimensionsEqual(Tab, Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mult = (Tab[y][x] & 0xFFFF) * Value;
                Result[y][x] = (short)(Threshold < mult ? SafeValue : mult);
            }
        }
    }

    public static float[] Divide(float[] Tab, float div) {
        float[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Divide(Tab, div, res);
        return res;
    }

    public static void Divide(float[] Tab, float div, float[] res) {
        for (int x = 0; x < Tab.length; ++x) {
            res[x] = Tab[x] / div;
        }
    }

    public static double[] Divide(double[] Tab, double div) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Divide(Tab, div, res);
        return res;
    }

    public static void Divide(double[] Tab, double div, double[] res) {
        for (int x = 0; x < Tab.length; ++x) {
            res[x] = Tab[x] / div;
        }
    }

    public static float[][] Divide(float[][] Tab, float div) {
        float[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Divide(Tab, div, res);
        return res;
    }

    public static void Divide(float[][] Tab, float div, float[][] res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = Tab[y][x] / div;
            }
        }
    }

    public static double[][] Divide(double[][] Tab, double div) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Divide(Tab, div, res);
        return res;
    }

    public static void Divide(double[][] Tab, double div, double[][] res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = Tab[y][x] / div;
            }
        }
    }

    public static double[] Invert(int[] Tab) {
        double[] res = new double[Tab.length];
        ArrayArithmetic.Invert(Tab, res);
        return res;
    }

    public static void Invert(int[] Tab, double[] Result) {
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = 1.0 / (double)Tab[x];
        }
    }

    public static double[] Invert(double[] Tab) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Invert(Tab, res);
        return res;
    }

    public static void Invert(double[] Tab, double[] Result) {
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = 1.0 / Tab[x];
        }
    }

    public static double[][] Invert(int[][] Tab) {
        double[][] res = new double[Tab.length][Tab[0].length];
        ArrayArithmetic.Invert(Tab, res);
        return res;
    }

    public static void Invert(int[][] Tab, double[][] res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = 1.0 / (double)Tab[y][x];
            }
        }
    }

    public static double[][] Invert(double[][] Tab) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Invert(Tab, res);
        return res;
    }

    public static void Invert(double[][] Tab, double[][] res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = 1.0 / Tab[y][x];
            }
        }
    }

    public static boolean[][] Invert(boolean[][] Tab) {
        boolean[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Invert(Tab, res);
        return res;
    }

    public static void Invert(boolean[][] Tab, boolean[][] res) {
        int width = Tab[0].length;
        int height = Tab.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                res[y][x] = !Tab[y][x];
            }
        }
    }

    public static int[] Opposite(int[] array) {
        int[] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(int[] array, int[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = -array[x];
        }
    }

    public static int[][] Opposite(int[][] array) {
        int[][] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(int[][] array, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = array[0].length;
        int height = array.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = -array[y][x];
            }
        }
    }

    public static double[] Opposite(double[] array) {
        double[] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(double[] array, double[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = -array[x];
        }
    }

    public static double[][] Opposite(double[][] array) {
        double[][] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(double[][] array, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = array[0].length;
        int height = array.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = -array[y][x];
            }
        }
    }

    public static float[] Opposite(float[] array) {
        float[] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(float[] array, float[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = -array[x];
        }
    }

    public static float[][] Opposite(float[][] array) {
        float[][] result = ArrayNew.Same(array);
        ArrayArithmetic.Opposite(array, result);
        return result;
    }

    public static void Opposite(float[][] array, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = array[0].length;
        int height = array.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = -array[y][x];
            }
        }
    }

    public static double[] Power(double[] Tab, double power) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Power(Tab, power, res);
        return res;
    }

    public static void Power(double[] Tab, double power, double[] Result) {
        for (int x = 0; x < Tab.length; ++x) {
            Result[x] = Math.pow(Tab[x], power);
        }
    }

    public static double[][] Power(double[][] Tab, double power) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Power(Tab, power, res);
        return res;
    }

    public static void Power(double[][] Tab, double power, double[][] result) {
        for (int y = 0; y < Tab.length; ++y) {
            for (int x = 0; x < Tab[0].length; ++x) {
                result[y][x] = Math.pow(Tab[y][x], power);
            }
        }
    }

    public static double[] Sqrt(double[] Tab) {
        double[] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Sqrt(Tab, res);
        return res;
    }

    public static void Sqrt(double[] Tab, double[] result) {
        for (int x = 0; x < Tab.length; ++x) {
            result[x] = Math.sqrt(Tab[x]);
        }
    }

    public static double[][] Sqrt(double[][] Tab) {
        double[][] res = ArrayNew.Same(Tab);
        ArrayArithmetic.Sqrt(Tab, res);
        return res;
    }

    public static void Sqrt(double[][] Tab, double[][] result) {
        for (int y = 0; y < Tab.length; ++y) {
            for (int x = 0; x < Tab[0].length; ++x) {
                result[y][x] = Math.sqrt(Tab[y][x]);
            }
        }
    }

    public static int[] Modulo(int[] array, int modulo) {
        int[] result = ArrayNew.Same(array);
        ArrayArithmetic.Modulo(array, modulo, result);
        return result;
    }

    public static void Modulo(int[] array, int modulo, int[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = Maths.Modulo(array[x], modulo);
        }
    }

    public static byte[] Modulo(byte[] array, byte modulo) {
        byte[] result = ArrayNew.Same(array);
        ArrayArithmetic.Modulo(array, modulo, result);
        return result;
    }

    public static void Modulo(byte[] array, byte modulo, byte[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = (byte)Maths.Modulo(array[x] & 0xFF, modulo);
        }
    }

    public static short[] Modulo(short[] array, short modulo) {
        short[] result = ArrayNew.Same(array);
        ArrayArithmetic.Modulo(array, modulo, result);
        return result;
    }

    public static void Modulo(short[] array, short modulo, short[] result) {
        if (!ArrayTools.areDimensionsEqual(array, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < array.length; ++x) {
            result[x] = (short)Maths.Modulo(array[x] & 0xFFFF, modulo);
        }
    }

    public static void AddUnsigned(byte[] Array1, int From1, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = (Array1[pos1] & 0xFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddUnsigned(short[] Array1, int From1, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = (Array1[pos1] & 0xFFFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Add(int[] Array1, int From1, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Add(float[] Array1, int From1, float[] Array2, int From2, float[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Add(double[] Array1, int From1, double[] Array2, int From2, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimesUnsigned(byte[] Array1, int From1, int Time, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * (Array1[pos1] & 0xFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimesUnsigned(short[] Array1, int From1, int Time, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * (Array1[pos1] & 0xFFFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimesUnsigned(byte[] Array1, int From1, double Time, double[] Array2, int From2, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * (double)(Array1[pos1] & 0xFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimesUnsigned(short[] Array1, int From1, double Time, double[] Array2, int From2, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * (double)(Array1[pos1] & 0xFFFF) + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimes(int[] Array1, int From1, int Time, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimes(float[] Array1, int From1, float Time, float[] Array2, int From2, float[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void AddTimes(double[] Array1, int From1, double Time, double[] Array2, int From2, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Time * Array1[pos1] + Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractUnsigned(int[] Array1, int From1, byte[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - (Array2[pos2] & 0xFF);
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractUnsigned(int[] Array1, int From1, short[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - (Array2[pos2] & 0xFFFF);
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Subtract(int[] Array1, int From1, int[] Array2, int From2, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Subtract(float[] Array1, int From1, float[] Array2, int From2, float[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Subtract(double[] Array1, int From1, double[] Array2, int From2, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractTimesUnsigned(int[] Array1, int From1, byte[] Array2, int From2, int Time, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Time * (Array2[pos2] & 0xFF);
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractTimesUnsigned(int[] Array1, int From1, short[] Array2, int From2, int Time, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Time * (Array2[pos2] & 0xFFFF);
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractTimes(int[] Array1, int From1, int[] Array2, int From2, int Time, int[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Time * Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractTimes(float[] Array1, int From1, float[] Array2, int From2, float Time, float[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Time * Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void SubtractTimes(double[] Array1, int From1, double[] Array2, int From2, double Time, double[] Result, int FromR, int Length) {
        int x = 0;
        int pos1 = From1;
        int pos2 = From2;
        int posR = FromR;
        while (x < Length) {
            Result[posR] = Array1[pos1] - Time * Array2[pos2];
            ++x;
            ++pos1;
            ++pos2;
            ++posR;
        }
    }

    public static void Not(boolean[] Array, boolean[] Result) {
        if (Array.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array.length; ++x) {
            Result[x] = !Array[x];
        }
    }

    public static void Or(boolean[] Array1, boolean[] Array2, boolean[] Result) {
        if (Array1.length != Array2.length || Array1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array1.length; ++x) {
            Result[x] = Array1[x] || Array2[x];
        }
    }

    public static void Nor(boolean[] Array1, boolean[] Array2, boolean[] Result) {
        if (Array1.length != Array2.length || Array1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array1.length; ++x) {
            Result[x] = !Array1[x] && !Array2[x];
        }
    }

    public static void And(boolean[] Array1, boolean[] Array2, boolean[] Result) {
        if (Array1.length != Array2.length || Array1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array1.length; ++x) {
            Result[x] = Array1[x] && Array2[x];
        }
    }

    public static void Nand(boolean[] Array1, boolean[] Array2, boolean[] Result) {
        if (Array1.length != Array2.length || Array1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array1.length; ++x) {
            Result[x] = !Array1[x] || !Array2[x];
        }
    }

    public static void XOR(boolean[] Array1, boolean[] Array2, boolean[] Result) {
        if (Array1.length != Array2.length || Array1.length != Result.length) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        for (int x = 0; x < Array1.length; ++x) {
            Result[x] = Array1[x] && !Array2[x] || !Array1[x] && Array2[x];
        }
    }
}

