/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayNew;
import java.util.Arrays;
import java.util.LinkedList;
import listTiTi.ListTools;
import mathematics.Maths;

public final class ArrayFeatures {
    private long Integral = -1L;
    private double IntegralDouble = -1.0;
    private long IntegralAbs = -1L;
    private double IntegralAbsDouble = -1.0;
    private int Size = 0;
    private double Average = 0.0;
    private double Variance = 0.0;
    private double UnbiasedVariance = 0.0;
    private double StandardDeviation = 0.0;
    private double SampleStandardDeviation = 0.0;
    private double UnbiasedStandardDeviation = 0.0;
    private double Kurtosis = 0.0;
    private double ExcessKurtosis = 0.0;
    private double Skewness = 0.0;
    private double SampleSkewness = 0.0;
    private double Contrast = 0.0;
    private double Michelson = 0.0;
    private int Minimum = 0;
    private double MinimumDouble = 0.0;
    private int Maximum = 0;
    private double MaximumDouble = 0.0;
    private int MinimumIndex = 0;
    private int MaximumIndex = 0;
    private double Rank005 = 0.0;
    private double Rank01 = 0.0;
    private double Rank025 = 0.0;
    private double Rank05 = 0.0;
    private double Rank10 = 0.0;
    private double Rank25 = 0.0;
    private double Rank50 = 0.0;
    private double Rank75 = 0.0;
    private double Rank90 = 0.0;
    private double Rank95 = 0.0;
    private double Rank975 = 0.0;
    private double Rank99 = 0.0;
    private double Rank995 = 0.0;
    public final int RANK90 = -5;
    public final int RANK95 = -4;
    public final int RANK975 = -3;
    public final int RANK99 = -2;
    public final int RANK995 = -1;
    private int nbFreeThreads = 0;
    private MomentsThread[] threads = null;

    public int Counter(boolean[] source) {
        return this.Sum(source);
    }

    public int Counter(double[][] source, double ForbiddenValue) {
        int width = source[0].length;
        int height = source.length;
        this.Size = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                ++this.Size;
            }
        }
        return this.Size;
    }

    public int Counter(float[][] source, float ForbiddenValue) {
        int width = source[0].length;
        int height = source.length;
        this.Size = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                ++this.Size;
            }
        }
        return this.Size;
    }

    public int Counter(boolean[][] source) {
        return this.Sum(source);
    }

    public int Counter(int[][] source, int ForbiddenValue) {
        int width = source[0].length;
        int height = source.length;
        this.Size = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                ++this.Size;
            }
        }
        return this.Size;
    }

    public long Integral(boolean[][] source) {
        return this.Sum(source);
    }

    public double Integral(double[][] source) {
        return this.Sum(source);
    }

    public float Integral(float[][] source) {
        return this.Sum(source);
    }

    public long Integral(int[][] source) {
        return this.Sum(source);
    }

    public int Integral(boolean[] source) {
        return this.Sum(source);
    }

    public int Sum(boolean[] source) {
        this.Integral = 0L;
        for (int x = 0; x < source.length; ++x) {
            if (!source[x]) continue;
            ++this.Integral;
        }
        return (int)this.Integral;
    }

    public int Sum(boolean[][] source) {
        this.Integral = 0L;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!source[y][x]) continue;
                ++this.Integral;
            }
        }
        return (int)this.Integral;
    }

    public double Sum(double[][] source) {
        this.IntegralDouble = 0.0;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.IntegralDouble += source[y][x];
            }
        }
        return this.IntegralDouble;
    }

    public float Sum(float[][] source) {
        float sum = 0.0f;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum += source[y][x];
            }
        }
        this.IntegralDouble = sum;
        return sum;
    }

    public long Sum(int[][] source) {
        this.Integral = 0L;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.Integral += (long)source[y][x];
            }
        }
        return this.Integral;
    }

    public double Integral(double[][] source, double ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public float Integral(float[][] source, float ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public double Sum(double[][] source, double ForbiddenValue) {
        this.IntegralDouble = 0.0;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                this.IntegralDouble += source[y][x];
            }
        }
        return this.IntegralDouble;
    }

    public float Sum(float[][] source, float ForbiddenValue) {
        float sum = 0.0f;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                sum += source[y][x];
            }
        }
        this.IntegralDouble = sum;
        return sum;
    }

    public long Integral(int[][] source, int ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public long Sum(int[][] source, int ForbiddenValue) {
        this.Integral = 0L;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (source[y][x] == ForbiddenValue) continue;
                this.Integral += (long)source[y][x];
            }
        }
        return this.Integral;
    }

    public long SumAbs(int[][] source) {
        this.IntegralAbs = 0L;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.IntegralAbs += (long)Math.abs(source[y][x]);
            }
        }
        return this.IntegralAbs;
    }

    public double SumAbs(double[][] source) {
        this.IntegralAbsDouble = 0.0;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.IntegralAbsDouble += Math.abs(source[y][x]);
            }
        }
        return this.IntegralAbsDouble;
    }

    public float SumAbs(float[][] source) {
        float sum = 0.0f;
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum += Math.abs(source[y][x]);
            }
        }
        this.IntegralAbsDouble = sum;
        return sum;
    }

    public double Average(int[][] array) {
        this.Average = (double)this.Sum(array) / (double)(array[0].length * array.length);
        return this.Average;
    }

    public double Average(int[][] array, int ForbiddenValue) {
        this.Average = (double)this.Integral(array, ForbiddenValue) / (double)this.Counter(array, ForbiddenValue);
        return this.Average;
    }

    public double Variance(int[][] array, int ForbiddenValue) {
        double sd = 0.0;
        this.Average(array, ForbiddenValue);
        int size = 0;
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (array1[x] == ForbiddenValue) continue;
                sd += Maths.Power((double)array1[x] - this.Average, 2);
                ++size;
            }
        }
        this.Variance = sd / (double)size;
        return this.Variance;
    }

    public double Variance(int[][] array) {
        double sd = 0.0;
        this.Average(array);
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                sd += Maths.Power((double)array1[x] - this.Average, 2);
            }
        }
        this.Variance = sd / (double)(array[0].length * array.length);
        return this.Variance;
    }

    public double StandardDeviation(int[][] array) {
        this.StandardDeviation = Math.sqrt(this.Variance(array));
        return this.StandardDeviation;
    }

    public double StandardDeviation(int[][] array, int ForbiddenValue) {
        this.StandardDeviation = Math.sqrt(this.Variance(array, ForbiddenValue));
        return this.StandardDeviation;
    }

    public double Skewness(int[][] array) {
        double skewness = 0.0;
        this.Average(array);
        int size = array[0].length * array.length;
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                skewness += Maths.Power((double)array1[x] - this.Average, 3);
            }
        }
        this.Skewness = skewness / (double)size / Maths.Power(this.Variance(array), 3);
        return this.Skewness;
    }

    public double Kurtosis(int[][] array) {
        double kurtosis = 0.0;
        this.Average(array);
        int size = array[0].length * array.length;
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                kurtosis += Maths.Power((double)array1[x] - this.Average, 4);
            }
        }
        this.Kurtosis = kurtosis / (double)size / Maths.Power(this.Variance(array), 4);
        return this.Kurtosis;
    }

    public double Average(double[][] array) {
        this.Average = this.Sum(array) / (double)(array[0].length * array.length);
        return this.Average;
    }

    public double Average(double[][] array, double ForbiddenValue) {
        this.Average = this.Integral(array, ForbiddenValue) / (double)this.Counter(array, ForbiddenValue);
        return this.Average;
    }

    public double Variance(double[][] array, double ForbiddenValue) {
        double sd = 0.0;
        this.Average(array, ForbiddenValue);
        int size = 0;
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (array1[x] == ForbiddenValue) continue;
                sd += Maths.Power(array1[x] - this.Average, 2);
                ++size;
            }
        }
        this.Variance = sd / (double)size;
        return this.Variance;
    }

    public double Variance(double[][] array) {
        double sd = 0.0;
        this.Average(array);
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                sd += Maths.Power(array1[x] - this.Average, 2);
            }
        }
        this.Variance = sd / (double)(array[0].length * array.length);
        return this.Variance;
    }

    public double StandardDeviation(double[][] array) {
        this.StandardDeviation = Math.sqrt(this.Variance(array));
        return this.StandardDeviation;
    }

    public double StandardDeviation(double[][] array, double ForbiddenValue) {
        this.StandardDeviation = Math.sqrt(this.Variance(array, ForbiddenValue));
        return this.StandardDeviation;
    }

    public double Skewness(double[][] array) {
        this.Skewness = 0.0;
        this.Average(array);
        int size = array[0].length * array.length;
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                this.Skewness += Maths.Power(array1[x] - this.Skewness, 3);
            }
        }
        this.Skewness /= (double)size * Maths.Power(this.Variance(array), 3);
        return this.Skewness;
    }

    public double Kurtosis(double[][] array) {
        this.Kurtosis = 0.0;
        this.Average(array);
        int size = array[0].length * array.length;
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                this.Kurtosis += Maths.Power(array1[x] - this.Average, 4);
            }
        }
        this.Kurtosis /= (double)size * Maths.Power(this.Variance(array), 4);
        return this.Kurtosis;
    }

    public float Average(float[][] array) {
        this.Average = this.Sum(array) / (float)(array[0].length * array.length);
        return (float)this.Average;
    }

    public float Average(float[][] array, float ForbiddenValue) {
        this.Average = this.Integral(array, ForbiddenValue) / (float)this.Counter(array, ForbiddenValue);
        return (float)this.Average;
    }

    public float Variance(float[][] array, float ForbiddenValue) {
        float sd = 0.0f;
        this.Average(array, ForbiddenValue);
        int size = 0;
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (array1[x] == ForbiddenValue) continue;
                sd = (float)((double)sd + Maths.Power((double)array1[x] - this.Average, 2));
                ++size;
            }
        }
        this.Variance = sd / (float)size;
        return (float)this.Variance;
    }

    public float Variance(float[][] array) {
        double sd = 0.0;
        double average = this.Average(array);
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                sd += Maths.Power((double)array1[x] - average, 2);
            }
        }
        this.Variance = (float)(sd / (double)(array[0].length * array.length));
        return (float)this.Variance;
    }

    public float StandardDeviation(float[][] array) {
        this.StandardDeviation = Math.sqrt(this.Variance(array));
        return (float)this.StandardDeviation;
    }

    public float StandardDeviation(float[][] array, float ForbiddenValue) {
        this.StandardDeviation = Math.sqrt(this.Variance(array, ForbiddenValue));
        return (float)this.StandardDeviation;
    }

    public float Skewness(float[][] array) {
        this.Skewness = 0.0;
        double average = this.Average(array);
        int size = array[0].length * array.length;
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                this.Skewness += Maths.Power((double)array1[x] - average, 3);
            }
        }
        this.Skewness /= (double)size * (double)Maths.Power(this.Variance(array), 3);
        return (float)this.Skewness;
    }

    public float Kurtosis(float[][] array) {
        this.Kurtosis = 0.0;
        double average = this.Average(array);
        int size = array[0].length * array.length;
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                this.Kurtosis += Maths.Power((double)array1[x] - average, 4);
            }
        }
        this.Kurtosis /= (double)size * (double)Maths.Power(this.Variance(array), 4);
        return (float)this.Kurtosis;
    }

    public short Minimum(short[][] array) {
        this.Minimum = array[0][0];
        for (short[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (this.Minimum <= array1[x]) continue;
                this.Minimum = array1[x];
            }
        }
        return (short)this.Minimum;
    }

    public int MinimumUShort(short[][] array) {
        this.Minimum = array[0][0] & 0xFFFF;
        for (short[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (this.Minimum <= (array1[x] & 0xFFFF)) continue;
                this.Minimum = array1[x] & 0xFFFF;
            }
        }
        return this.Minimum;
    }

    public int Minimum(int[][] array) {
        this.Minimum = array[0][0];
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (this.Minimum <= array1[x]) continue;
                this.Minimum = array1[x];
            }
        }
        return this.Minimum;
    }

    public double Minimum(double[][] array) {
        this.MinimumDouble = array[0][0];
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (!(this.MinimumDouble > array1[x])) continue;
                this.MinimumDouble = array1[x];
            }
        }
        return this.MinimumDouble;
    }

    public float Minimum(float[][] array) {
        this.MinimumDouble = array[0][0];
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (!((double)array1[x] < this.MinimumDouble)) continue;
                this.MinimumDouble = array1[x];
            }
        }
        return (float)this.MinimumDouble;
    }

    public int Maximum(int[][] array) {
        this.Maximum = array[0][0];
        for (int[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (this.Maximum >= array1[x]) continue;
                this.Maximum = array1[x];
            }
        }
        return this.Maximum;
    }

    public double Maximum(double[][] array) {
        this.MaximumDouble = array[0][0];
        for (double[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (!(this.MaximumDouble < array1[x])) continue;
                this.MaximumDouble = array1[x];
            }
        }
        return this.MaximumDouble;
    }

    public float Maximum(float[][] array) {
        this.MaximumDouble = array[0][0];
        for (float[] array1 : array) {
            for (int x = 0; x < array1.length; ++x) {
                if (!(this.MaximumDouble < (double)array1[x])) continue;
                this.MaximumDouble = array1[x];
            }
        }
        return (float)this.MaximumDouble;
    }

    public short Minimum(short[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Minimum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Minimum <= array[z][y][x]) continue;
                    this.Minimum = array[z][y][x];
                }
            }
        }
        return (short)this.Minimum;
    }

    public int MinimumUShort(short[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Minimum = array[0][0][0] & 0xFFFF;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Minimum <= (array[z][y][x] & 0xFFFF)) continue;
                    this.Minimum = array[z][y][x] & 0xFFFF;
                }
            }
        }
        return this.Minimum;
    }

    public byte Minimum(byte[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Minimum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Minimum <= array[z][y][x]) continue;
                    this.Minimum = array[z][y][x];
                }
            }
        }
        return (byte)this.Minimum;
    }

    public int MinimumUByte(byte[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        int min = array[0][0][0] & 0xFF;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (min <= (array[z][y][x] & 0xFF)) continue;
                    min = array[z][y][x] & 0xFF;
                }
            }
        }
        this.Minimum = min;
        return min;
    }

    public int Minimum(int[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Minimum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Minimum <= array[z][y][x]) continue;
                    this.Minimum = array[z][y][x];
                }
            }
        }
        return this.Minimum;
    }

    public float Minimum(float[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.MinimumDouble = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!(this.MinimumDouble > (double)array[z][y][x])) continue;
                    this.MinimumDouble = array[z][y][x];
                }
            }
        }
        return (float)this.MinimumDouble;
    }

    public double Minimum(double[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.MinimumDouble = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!(this.MinimumDouble > array[z][y][x])) continue;
                    this.MinimumDouble = array[z][y][x];
                }
            }
        }
        return this.MinimumDouble;
    }

    public short Maximum(short[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Maximum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Maximum >= array[z][y][x]) continue;
                    this.Maximum = array[z][y][x];
                }
            }
        }
        return (short)this.Maximum;
    }

    public int MaximumUShort(short[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Maximum = array[0][0][0] & 0xFFFF;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Maximum >= (array[z][y][x] & 0xFFFF)) continue;
                    this.Maximum = array[z][y][x] & 0xFFFF;
                }
            }
        }
        return this.Maximum;
    }

    public byte Maximum(byte[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Maximum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Maximum >= array[z][y][x]) continue;
                    this.Maximum = array[z][y][x];
                }
            }
        }
        return (byte)this.Maximum;
    }

    public int MaximumUByte(byte[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Maximum = array[0][0][0] & 0xFF;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Maximum >= (array[z][y][x] & 0xFF)) continue;
                    this.Maximum = array[z][y][x] & 0xFF;
                }
            }
        }
        return this.Maximum;
    }

    public int Maximum(int[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.Maximum = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.Maximum >= array[z][y][x]) continue;
                    this.Maximum = array[z][y][x];
                }
            }
        }
        return this.Maximum;
    }

    public float Maximum(float[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.MaximumDouble = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!(this.MaximumDouble < (double)array[z][y][x])) continue;
                    this.MaximumDouble = array[z][y][x];
                }
            }
        }
        return (float)this.MaximumDouble;
    }

    public double Maximum(double[][][] array) {
        int width = array[0][0].length;
        int height = array[0].length;
        int depth = array.length;
        this.MaximumDouble = array[0][0][0];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!(this.MaximumDouble < array[z][y][x])) continue;
                    this.MaximumDouble = array[z][y][x];
                }
            }
        }
        return this.MaximumDouble;
    }

    public double Contrast(double[][] array) {
        this.Contrast = (this.Maximum(array) - this.Minimum(array)) / this.Average(array);
        return this.Contrast;
    }

    public double Michelson(double[][] array) {
        double min = this.Minimum(array);
        double max = this.Maximum(array);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public float Contrast(float[][] array) {
        this.Contrast = (this.Maximum(array) - this.Minimum(array)) / this.Average(array);
        return (float)this.Contrast;
    }

    public float Michelson(float[][] array) {
        float min = this.Minimum(array);
        float max = this.Maximum(array);
        this.Michelson = (max - min) / (max + min);
        return (float)this.Michelson;
    }

    public void Nplex(int[] source, int width, int height, int[] result, int N) {
        int width1 = width - 1;
        int height1 = height - 1;
        int size = width * height;
        if (size != source.length) {
            throw new IllegalArgumentException("size != source.length");
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        int y = 1;
        int pos = width + 1;
        while (y < height1) {
            int x = 1;
            while (x < width1) {
                int v = source[pos];
                int posnei = pos - width - 1;
                int p = source[posnei];
                if (v != p && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[pos - 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[pos + 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[posnei = pos + width - 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                result[pos] = list.size() == N ? v : 0;
                list.clear();
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
    }

    public void Nplex(int[] source, int width, int height, int[] result) {
        int width1 = width - 1;
        int height1 = height - 1;
        LinkedList<Integer> list = new LinkedList<Integer>();
        int y = 1;
        int pos = width + 1;
        while (y < height1) {
            int x = 1;
            while (x < width1) {
                int v = source[pos];
                int posnei = pos - width - 1;
                int p = source[posnei];
                if (v != p && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[pos - 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[pos + 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[posnei = pos + width - 1]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                if (v != (p = source[++posnei]) && !ListTools.isInList(list, p)) {
                    list.add(p);
                }
                result[pos] = list.size();
                list.clear();
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
    }

    public void NplexStrict(int[] source, int width, int height, int[] result, int N) {
        this.NplexStrict(source, width, height, result);
        ArrayComparator.Compare(result, "==", N, source, 0, result);
    }

    public void NplexStrict(int[] source, int width, int height, int[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("Images source and result have different type and dimensions.");
        }
        int width1 = width - 1;
        int height1 = height - 1;
        int y = 1;
        int pos = width + 1;
        while (y < height1) {
            int x = 1;
            while (x < width1) {
                int v = source[pos];
                boolean found = false;
                int posnei = pos - width - 1;
                int first = source[posnei];
                int prev = source[posnei];
                int p = source[posnei];
                if (p == v) {
                    found = true;
                }
                int count = 1;
                if ((p = source[++posnei]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if ((p = source[++posnei]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if ((p = source[pos + 1]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if ((p = source[posnei = pos + width + 1]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if ((p = source[--posnei]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if ((p = source[--posnei]) == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                int last = p = source[pos - 1];
                if (p == v) {
                    found = true;
                }
                if (p != prev) {
                    ++count;
                    prev = p;
                }
                if (2 < count && last == first) {
                    --count;
                }
                result[pos] = !found ? 0 : count;
                ++x;
                ++pos;
            }
            ++y;
            pos += 2;
        }
    }

    public int Counter(int[] array, int ForbiddenValue) {
        return this.Counter(array, ForbiddenValue, 0, array.length);
    }

    public int Counter(int[] array, int ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            ++this.Size;
        }
        return this.Size;
    }

    public long Integral(int[] array) {
        return this.Integral(array, 0, array.length);
    }

    public long Integral(int[] array, int from, int to) {
        this.Integral = 0L;
        this.Size = to - from;
        for (int x = from; x < to; ++x) {
            this.Integral += (long)array[x];
        }
        return this.Integral;
    }

    public long Integral(int[] array, int ForbiddenValue) {
        return this.Integral(array, ForbiddenValue, 0, array.length);
    }

    public long Integral(int[] array, int ForbiddenValue, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            this.Integral += (long)array[x];
            ++this.Size;
        }
        return this.Integral;
    }

    public long Integral(int[] array, int[] mask) {
        return this.Integral(array, mask, 0, array.length);
    }

    public long Integral(int[] array, int[] mask, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            this.Integral += (long)array[x];
            ++this.Size;
        }
        return this.Integral;
    }

    public long IntegralAbs(int[] array) {
        this.IntegralAbs = 0L;
        for (int y = 0; y < array.length; ++y) {
            this.IntegralAbs += (long)Math.abs(array[y]);
        }
        return this.IntegralAbs;
    }

    public double Average(int[] array) {
        return this.Average(array, 0, array.length);
    }

    public double Average(int[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(int[] array, int ForbiddenValue) {
        return this.Average(array, ForbiddenValue, 0, array.length);
    }

    public double Average(int[] array, int ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(int[] array, int[] mask) {
        return this.Average(array, mask, 0, array.length);
    }

    public double Average(int[] array, int[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        return this.Average;
    }

    public void Moments(int[] array) {
        this.Moments(array, 0, array.length);
    }

    public void Moments(int[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(int[] array, int ForbiddenValue) {
        this.Moments(array, ForbiddenValue, 0, array.length);
    }

    public void Moments(int[] array, int ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(int[] array, int[] mask) {
        this.Moments(array, mask, 0, array.length);
    }

    public void Moments(int[] array, int[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(int[] array, int nbCPU) {
        this.MomentsParallelized(array, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(int[] array, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(int[] array, int ForbiddenValue, int nbCPU) {
        this.MomentsParallelized(array, ForbiddenValue, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(int[] array, int ForbiddenValue, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, ForbiddenValue, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, ForbiddenValue, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public int Minimum(int[] array) {
        return this.Minimum(array, 0, array.length);
    }

    public int Minimum(int[] array, int from, int to) {
        this.MinimumIndex = from;
        this.Minimum = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (this.Minimum <= array[x]) continue;
            this.Minimum = array[x];
            this.MinimumIndex = x;
        }
        return this.Minimum;
    }

    public int Minimum(int[] array, int ForbiddenValue) {
        return this.Minimum(array, ForbiddenValue, 0, array.length);
    }

    public int Minimum(int[] array, int ForbiddenValue, int from, int to) {
        int x;
        this.MinimumIndex = -1;
        this.Minimum = Integer.MAX_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Minimum = array[x];
            this.MinimumIndex = x++;
        } else {
            throw new IllegalStateException("No minimum found!");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Minimum > array[x]) {
                this.Minimum = array[x];
                this.MinimumIndex = x;
            }
            ++x;
        }
        return this.Minimum;
    }

    public int MinimumIndex(int[] array) {
        return this.MinimumIndex(array, 0, array.length);
    }

    public int MinimumIndex(int[] array, int from, int to) {
        this.Minimum = this.Minimum(array, from, to);
        return this.MinimumIndex;
    }

    public int MinimumIndex(int[] array, int ForbiddenValue) {
        return this.MinimumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MinimumIndex(int[] array, int ForbiddenValue, int from, int to) {
        this.Minimum = this.Minimum(array, ForbiddenValue, from, to);
        return this.MinimumIndex;
    }

    public int Maximum(int[] array) {
        return this.Maximum(array, 0, array.length);
    }

    public int Maximum(int[] array, int from, int to) {
        this.MaximumIndex = from;
        this.Maximum = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (this.Maximum >= array[x]) continue;
            this.Maximum = array[x];
            this.MaximumIndex = x;
        }
        return this.Maximum;
    }

    public int Maximum(int[] array, int ForbiddenValue) {
        return this.Maximum(array, ForbiddenValue, 0, array.length);
    }

    public int Maximum(int[] array, int ForbiddenValue, int from, int to) {
        int x;
        this.MaximumIndex = -1;
        this.Maximum = Integer.MIN_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Maximum = array[x];
            this.MaximumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Maximum < array[x]) {
                this.Maximum = array[x];
                this.MaximumIndex = x;
            }
            ++x;
        }
        return this.Maximum;
    }

    public int MaximumIndex(int[] array) {
        return this.MaximumIndex(array, 0, array.length);
    }

    public int MaximumIndex(int[] array, int from, int to) {
        this.Maximum = this.Maximum(array, from, to);
        return this.MaximumIndex;
    }

    public int MaximumIndex(int[] array, int ForbiddenValue) {
        return this.MaximumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MaximumIndex(int[] array, int ForbiddenValue, int from, int to) {
        this.Maximum = this.Maximum(array, ForbiddenValue, from, to);
        return this.MaximumIndex;
    }

    public void Ranks(int[] array) {
        this.Ranks(array, 0, array.length);
    }

    public void Ranks(int[] array, int from, int to) {
        int[] buffer = Arrays.copyOfRange(array, from, to);
        Arrays.sort(buffer);
        this.Size = buffer.length;
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public void Ranks(int[] array, int ForbiddenValue) {
        this.Ranks(array, ForbiddenValue, 0, array.length);
    }

    public void Ranks(int[] array, int ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            ++this.Size;
        }
        int[] buffer = new int[this.Size];
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            buffer[this.Size++] = array[x];
        }
        Arrays.sort(buffer);
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public void RanksFromHistogram(int[] array) {
        this.RanksFromHistogram(array, 0, array.length);
    }

    public void RanksFromHistogram(int[] array, int from, int to) {
        int size = (int)this.Integral(array, from, to);
        int[] buffer = new int[size];
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i]; ++j) {
                buffer[pos++] = i;
            }
        }
        this.Size = buffer.length;
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public double Contrast(int[] array) {
        return this.Contrast(array, 0, array.length);
    }

    public double Contrast(int[] array, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, from, to) - this.Minimum(array, from, to)) / this.Average(array, from, to);
        return this.Contrast;
    }

    public double Contrast(int[] array, int ForbiddenValue) {
        return this.Contrast(array, ForbiddenValue, 0, array.length);
    }

    public double Contrast(int[] array, int ForbiddenValue, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, ForbiddenValue, from, to) - this.Minimum(array, ForbiddenValue, from, to)) / this.Average(array, ForbiddenValue, from, to);
        return this.Contrast;
    }

    public double Michelson(int[] array) {
        return this.Michelson(array, 0, array.length);
    }

    public double Michelson(int[] array, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(int[] array, int ForbiddenValue) {
        return this.Michelson(array, ForbiddenValue, 0, array.length);
    }

    public double Michelson(int[] array, int ForbiddenValue, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(int[] array, int ranksup) {
        return this.MichelsonFromRanks(array, ranksup, 0, array.length);
    }

    public double MichelsonFromRanks(int[] array, int ranksup, int from, int to) {
        this.Ranks(array, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(int[] array, int ranksup, int ForbiddenValue) {
        return this.MichelsonFromRanks(array, ranksup, ForbiddenValue, 0, array.length);
    }

    public double MichelsonFromRanks(int[] array, int ranksup, int ForbiddenValue, int from, int to) {
        this.Ranks(array, ForbiddenValue, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public int Counter(double[] array, double ForbiddenValue) {
        return this.Counter(array, ForbiddenValue, 0, array.length);
    }

    public int Counter(double[] array, double ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Double.compare(array[x], ForbiddenValue) == 0) continue;
            ++this.Size;
        }
        return this.Size;
    }

    public double Integral(double[] array) {
        return this.Integral(array, 0, array.length);
    }

    public double Integral(double[] array, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = to - from;
        for (int x = from; x < to; ++x) {
            this.IntegralDouble += array[x];
        }
        return this.IntegralDouble;
    }

    public double Integral(double[] array, double ForbiddenValue) {
        return this.Integral(array, ForbiddenValue, 0, array.length);
    }

    public double Integral(double[] array, double ForbiddenValue, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Double.compare(array[x], ForbiddenValue) == 0) continue;
            this.IntegralDouble += array[x];
            ++this.Size;
        }
        return this.IntegralDouble;
    }

    public double Integral(double[] array, double[] mask) {
        return this.Integral(array, mask, 0, array.length);
    }

    public double Integral(double[] array, double[] mask, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0.0) continue;
            this.IntegralDouble += array[x];
            ++this.Size;
        }
        return this.IntegralDouble;
    }

    public double IntegralAbs(double[] array) {
        this.IntegralAbsDouble = 0.0;
        for (int x = 0; x < array.length; ++x) {
            this.IntegralAbsDouble += Math.abs(array[x]);
        }
        return this.IntegralAbsDouble;
    }

    public double Average(double[] array) {
        return this.Average(array, 0, array.length);
    }

    public double Average(double[] array, int from, int to) {
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(double[] array, double ForbiddenValue) {
        return this.Average(array, ForbiddenValue, 0, array.length);
    }

    public double Average(double[] array, double ForbiddenValue, int from, int to) {
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(double[] array, double[] mask) {
        return this.Average(array, mask, 0, array.length);
    }

    public double Average(double[] array, double[] mask, int from, int to) {
        this.Average = this.Integral(array, mask, from, to) / (double)this.Size;
        return this.Average;
    }

    public void Moments(double[] array) {
        this.Moments(array, 0, array.length);
    }

    public void Moments(double[] array, int from, int to) {
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            double v = array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(double[] array, double ForbiddenValue) {
        this.Moments(array, ForbiddenValue, 0, array.length);
    }

    public void Moments(double[] array, double ForbiddenValue, int from, int to) {
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (Double.compare(array[x], ForbiddenValue) == 0) continue;
            double v = array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.Kurtosis -= 3.0;
    }

    public void Moments(double[] array, double[] mask) {
        this.Moments(array, mask, 0, array.length);
    }

    public void Moments(double[] array, double[] mask, int from, int to) {
        this.Average = this.Integral(array, mask, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0.0) continue;
            double v = array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.Kurtosis -= 3.0;
    }

    public void MomentsParallelized(double[] array, int nbCPU) {
        this.MomentsParallelized(array, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(double[] array, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(double[] array, double ForbiddenValue, int nbCPU) {
        this.MomentsParallelized(array, ForbiddenValue, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(double[] array, double ForbiddenValue, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, ForbiddenValue, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, ForbiddenValue, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public double Minimum(double[] array) {
        return this.Minimum(array, 0, array.length);
    }

    public double Minimum(double[] array, int from, int to) {
        this.MinimumIndex = from;
        this.MinimumDouble = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (!(this.MinimumDouble > array[x])) continue;
            this.MinimumDouble = array[x];
            this.MinimumIndex = x;
        }
        return this.MinimumDouble;
    }

    public double Minimum(double[] array, double ForbiddenValue) {
        return this.Minimum(array, ForbiddenValue, 0, array.length);
    }

    public double Minimum(double[] array, double ForbiddenValue, int from, int to) {
        int x;
        this.MinimumIndex = -1;
        this.MinimumDouble = Double.MAX_VALUE;
        for (x = from; x < to && Double.compare(array[x], ForbiddenValue) == 0; ++x) {
        }
        if (x < to) {
            this.MinimumDouble = array[x];
            this.MinimumIndex = x++;
        } else {
            throw new IllegalStateException("No minimum found!");
        }
        while (x < to) {
            if (Double.compare(array[x], ForbiddenValue) != 0 && this.MinimumDouble > array[x]) {
                this.MinimumDouble = array[x];
                this.MinimumIndex = x;
            }
            ++x;
        }
        return this.MinimumDouble;
    }

    public int MinimumIndex(double[] array) {
        return this.MinimumIndex(array, 0, array.length);
    }

    public int MinimumIndex(double[] array, int from, int to) {
        this.MinimumDouble = this.Minimum(array, from, to);
        return this.MinimumIndex;
    }

    public int MinimumIndex(double[] array, double ForbiddenValue) {
        return this.MinimumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MinimumIndex(double[] array, double ForbiddenValue, int from, int to) {
        this.MinimumDouble = this.Minimum(array, ForbiddenValue, from, to);
        return this.MinimumIndex;
    }

    public double Maximum(double[] array) {
        return this.Maximum(array, 0, array.length);
    }

    public double Maximum(double[] array, int from, int to) {
        this.MaximumIndex = from;
        this.MaximumDouble = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (!(this.MaximumDouble < array[x])) continue;
            this.MaximumDouble = array[x];
            this.MaximumIndex = x;
        }
        return this.MaximumDouble;
    }

    public double Maximum(double[] array, double ForbiddenValue) {
        return this.Maximum(array, ForbiddenValue, 0, array.length);
    }

    public double Maximum(double[] array, double ForbiddenValue, int from, int to) {
        int x;
        this.MaximumIndex = -1;
        this.MaximumDouble = -1.7976931348623157E308;
        for (x = from; x < to && Double.compare(array[x], ForbiddenValue) == 0; ++x) {
        }
        if (x < to) {
            this.MaximumDouble = array[x];
            this.MaximumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (Double.compare(array[x], ForbiddenValue) != 0 && this.MaximumDouble < array[x]) {
                this.MaximumDouble = array[x];
                this.MaximumIndex = x;
            }
            ++x;
        }
        return this.MaximumDouble;
    }

    public int MaximumIndex(double[] array) {
        return this.MaximumIndex(array, 0, array.length);
    }

    public int MaximumIndex(double[] array, int from, int to) {
        this.MaximumDouble = this.Maximum(array, from, to);
        return this.MaximumIndex;
    }

    public int MaximumIndex(double[] array, double ForbiddenValue) {
        return this.MaximumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MaximumIndex(double[] array, double ForbiddenValue, int from, int to) {
        this.MaximumDouble = this.Maximum(array, ForbiddenValue, from, to);
        return this.MaximumIndex;
    }

    public void Ranks(double[] array) {
        this.Ranks(array, 0, array.length);
    }

    public void Ranks(double[] array, int from, int to) {
        double[] buffer = Arrays.copyOfRange(array, from, to);
        Arrays.sort(buffer);
        this.Size = buffer.length;
        this.MinimumDouble = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.MaximumDouble = buffer[this.Size - 1];
        buffer = null;
    }

    public void Ranks(double[] array, double ForbiddenValue) {
        this.Ranks(array, ForbiddenValue, 0, array.length);
    }

    public void Ranks(double[] array, double ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Double.compare(array[x], ForbiddenValue) == 0) continue;
            ++this.Size;
        }
        double[] buffer = new double[this.Size];
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Double.compare(array[x], ForbiddenValue) == 0) continue;
            buffer[this.Size++] = array[x];
        }
        Arrays.sort(buffer);
        int size = this.Size - 1;
        this.MinimumDouble = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)size * 0.05)];
        this.Rank10 = buffer[(int)((double)size * 0.1)];
        this.Rank25 = buffer[(int)((double)size * 0.25)];
        this.Rank50 = buffer[size >> 1];
        this.Rank75 = buffer[(int)((double)size * 0.75)];
        this.Rank90 = buffer[(int)((double)size * 0.9)];
        this.Rank95 = buffer[(int)((double)size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.MaximumDouble = buffer[size - 1];
        buffer = null;
    }

    public double Contrast(double[] array) {
        return this.Contrast(array, 0, array.length);
    }

    public double Contrast(double[] array, int from, int to) {
        this.Contrast = (this.Maximum(array, from, to) - this.Minimum(array, from, to)) / this.Average(array, from, to);
        return this.Contrast;
    }

    public double Contrast(double[] array, double ForbiddenValue) {
        return this.Contrast(array, ForbiddenValue, 0, array.length);
    }

    public double Contrast(double[] array, double ForbiddenValue, int from, int to) {
        this.Contrast = (this.Maximum(array, ForbiddenValue, from, to) - this.Minimum(array, ForbiddenValue, from, to)) / this.Average(array, ForbiddenValue, from, to);
        return this.Contrast;
    }

    public double Michelson(double[] array) {
        return this.Michelson(array, 0, array.length);
    }

    public double Michelson(double[] array, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(double[] array, double ForbiddenValue) {
        return this.Michelson(array, ForbiddenValue, 0, array.length);
    }

    public double Michelson(double[] array, double ForbiddenValue, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(double[] array, int ranksup) {
        return this.MichelsonFromRanks(array, ranksup, 0, array.length);
    }

    public double MichelsonFromRanks(double[] array, int ranksup, int from, int to) {
        this.Ranks(array, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(double[] array, int ranksup, double ForbiddenValue) {
        return this.MichelsonFromRanks(array, ranksup, ForbiddenValue, 0, array.length);
    }

    public double MichelsonFromRanks(double[] array, int ranksup, double ForbiddenValue, int from, int to) {
        this.Ranks(array, ForbiddenValue, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public int Counter(float[] array, float ForbiddenValue) {
        return this.Counter(array, ForbiddenValue, 0, array.length);
    }

    public int Counter(float[] array, float ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Float.compare(array[x], ForbiddenValue) == 0) continue;
            ++this.Size;
        }
        return this.Size;
    }

    public double Integral(float[] array) {
        return this.Integral(array, 0, array.length);
    }

    public double Integral(float[] array, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = to - from;
        for (int x = from; x < to; ++x) {
            this.IntegralDouble += (double)array[x];
        }
        return this.IntegralDouble;
    }

    public double Integral(float[] array, float ForbiddenValue) {
        return this.Integral(array, ForbiddenValue, 0, array.length);
    }

    public double Integral(float[] array, float ForbiddenValue, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Float.compare(array[x], ForbiddenValue) == 0) continue;
            this.IntegralDouble += (double)array[x];
            ++this.Size;
        }
        return this.IntegralDouble;
    }

    public double Integral(float[] array, float[] mask) {
        return this.Integral(array, mask, 0, array.length);
    }

    public double Integral(float[] array, float[] mask, int from, int to) {
        this.IntegralDouble = 0.0;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0.0f) continue;
            this.IntegralDouble += (double)array[x];
            ++this.Size;
        }
        return this.IntegralDouble;
    }

    public double IntegralAbs(float[] array) {
        this.IntegralAbsDouble = 0.0;
        for (int x = 0; x < array.length; ++x) {
            this.IntegralAbsDouble += (double)Math.abs(array[x]);
        }
        return this.IntegralAbsDouble;
    }

    public double Average(float[] array) {
        return this.Average(array, 0, array.length);
    }

    public double Average(float[] array, int from, int to) {
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(float[] array, float ForbiddenValue) {
        return this.Average(array, ForbiddenValue, 0, array.length);
    }

    public double Average(float[] array, float ForbiddenValue, int from, int to) {
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(float[] array, float[] mask) {
        return this.Average(array, mask, 0, array.length);
    }

    public double Average(float[] array, float[] mask, int from, int to) {
        this.Average = this.Integral(array, mask, from, to) / (double)this.Size;
        return this.Average;
    }

    public void Moments(float[] array) {
        this.Moments(array, 0, array.length);
    }

    public void Moments(float[] array, int from, int to) {
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(float[] array, float ForbiddenValue) {
        this.Moments(array, ForbiddenValue, 0, array.length);
    }

    public void Moments(float[] array, float ForbiddenValue, int from, int to) {
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (Float.compare(array[x], ForbiddenValue) == 0) continue;
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(float[] array, float[] mask) {
        this.Moments(array, mask, 0, array.length);
    }

    public void Moments(float[] array, float[] mask, int from, int to) {
        this.Average = this.Integral(array, mask, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0.0f) continue;
            double v = (double)array[x] - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(float[] array, int nbCPU) {
        this.MomentsParallelized(array, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(float[] array, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = this.Integral(array, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(float[] array, float ForbiddenValue, int nbCPU) {
        this.MomentsParallelized(array, ForbiddenValue, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(float[] array, float ForbiddenValue, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, ForbiddenValue, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, ForbiddenValue, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public double Minimum(float[] array) {
        return this.Minimum(array, 0, array.length);
    }

    public double Minimum(float[] array, int from, int to) {
        this.MinimumIndex = from;
        this.MinimumDouble = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (!(this.MinimumDouble > (double)array[x])) continue;
            this.MinimumDouble = array[x];
            this.MinimumIndex = x;
        }
        return this.MinimumDouble;
    }

    public double Minimum(float[] array, float ForbiddenValue) {
        return this.Minimum(array, ForbiddenValue, 0, array.length);
    }

    public double Minimum(float[] array, float ForbiddenValue, int from, int to) {
        int x;
        this.MinimumIndex = -1;
        this.MinimumDouble = 3.4028234663852886E38;
        for (x = from; x < to && Float.compare(array[x], ForbiddenValue) == 0; ++x) {
        }
        if (x < to) {
            this.MinimumDouble = array[x];
            this.MinimumIndex = x++;
        } else {
            throw new IllegalStateException("No minimum found!");
        }
        while (x < to) {
            if (Float.compare(array[x], ForbiddenValue) != 0 && this.MinimumDouble > (double)array[x]) {
                this.MinimumDouble = array[x];
                this.MinimumIndex = x;
            }
            ++x;
        }
        return (float)this.MinimumDouble;
    }

    public int MinimumIndex(float[] array) {
        return this.MinimumIndex(array, 0, array.length);
    }

    public int MinimumIndex(float[] array, int from, int to) {
        this.MinimumDouble = this.Minimum(array, from, to);
        return this.MinimumIndex;
    }

    public int MinimumIndex(float[] array, float ForbiddenValue) {
        return this.MinimumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MinimumIndex(float[] array, float ForbiddenValue, int from, int to) {
        this.MinimumDouble = this.Minimum(array, ForbiddenValue, from, to);
        return this.MinimumIndex;
    }

    public double Maximum(float[] array) {
        return this.Maximum(array, 0, array.length);
    }

    public double Maximum(float[] array, int from, int to) {
        this.MaximumIndex = from;
        this.MaximumDouble = array[from];
        for (int x = from + 1; x < to; ++x) {
            if (!(this.MaximumDouble < (double)array[x])) continue;
            this.MaximumDouble = array[x];
            this.MaximumIndex = x;
        }
        return this.MaximumDouble;
    }

    public double Maximum(float[] array, float ForbiddenValue) {
        return this.Maximum(array, ForbiddenValue, 0, array.length);
    }

    public double Maximum(float[] array, float ForbiddenValue, int from, int to) {
        int x;
        this.MaximumIndex = -1;
        this.MaximumDouble = -1.7976931348623157E308;
        for (x = from; x < to && Float.compare(array[x], ForbiddenValue) == 0; ++x) {
        }
        if (x < to) {
            this.MaximumDouble = array[x];
            this.MaximumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (Float.compare(array[x], ForbiddenValue) != 0 && this.MaximumDouble < (double)array[x]) {
                this.MaximumDouble = array[x];
                this.MaximumIndex = x;
            }
            ++x;
        }
        return this.MaximumDouble;
    }

    public int MaximumIndex(float[] array) {
        return this.MaximumIndex(array, 0, array.length);
    }

    public int MaximumIndex(float[] array, int from, int to) {
        this.MaximumDouble = this.Maximum(array, from, to);
        return this.MaximumIndex;
    }

    public int MaximumIndex(float[] array, float ForbiddenValue) {
        return this.MaximumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MaximumIndex(float[] array, float ForbiddenValue, int from, int to) {
        this.MaximumDouble = this.Maximum(array, ForbiddenValue, from, to);
        return this.MaximumIndex;
    }

    public void Ranks(float[] array) {
        this.Ranks(array, 0, array.length);
    }

    public void Ranks(float[] array, int from, int to) {
        float[] buffer = Arrays.copyOfRange(array, from, to);
        Arrays.sort(buffer);
        this.Size = buffer.length;
        this.MinimumDouble = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.MaximumDouble = buffer[this.Size - 1];
        buffer = null;
    }

    public void Ranks(float[] array, float ForbiddenValue) {
        this.Ranks(array, ForbiddenValue, 0, array.length);
    }

    public void Ranks(float[] array, float ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Float.compare(array[x], ForbiddenValue) == 0) continue;
            ++this.Size;
        }
        double[] buffer = new double[this.Size];
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (Float.compare(array[x], ForbiddenValue) == 0) continue;
            buffer[this.Size++] = array[x];
        }
        Arrays.sort(buffer);
        int size = this.Size - 1;
        this.MinimumDouble = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.MaximumDouble = buffer[size - 1];
        buffer = null;
    }

    public double Contrast(float[] array) {
        return this.Contrast(array, 0, array.length);
    }

    public double Contrast(float[] array, int from, int to) {
        this.Contrast = (this.Maximum(array, from, to) - this.Minimum(array, from, to)) / this.Average(array, from, to);
        return this.Contrast;
    }

    public double Contrast(float[] array, float ForbiddenValue) {
        return this.Contrast(array, ForbiddenValue, 0, array.length);
    }

    public double Contrast(float[] array, float ForbiddenValue, int from, int to) {
        this.Contrast = (this.Maximum(array, ForbiddenValue, from, to) - this.Minimum(array, ForbiddenValue, from, to)) / this.Average(array, ForbiddenValue, from, to);
        return this.Contrast;
    }

    public double Michelson(float[] array) {
        return this.Michelson(array, 0, array.length);
    }

    public double Michelson(float[] array, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(float[] array, float ForbiddenValue) {
        return this.Michelson(array, ForbiddenValue, 0, array.length);
    }

    public double Michelson(float[] array, float ForbiddenValue, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(float[] array, int ranksup) {
        return this.MichelsonFromRanks(array, ranksup, 0, array.length);
    }

    public double MichelsonFromRanks(float[] array, int ranksup, int from, int to) {
        this.Ranks(array, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(float[] array, int ranksup, float ForbiddenValue) {
        return this.MichelsonFromRanks(array, ranksup, ForbiddenValue, 0, array.length);
    }

    public double MichelsonFromRanks(float[] array, int ranksup, float ForbiddenValue, int from, int to) {
        this.Ranks(array, ForbiddenValue, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public int Counter(byte[] array, byte ForbiddenValue) {
        return this.Counter(array, ForbiddenValue, 0, array.length);
    }

    public int Counter(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            ++this.Size;
        }
        return this.Size;
    }

    public long Integral(byte[] array) {
        return this.Integral(array, 0, array.length);
    }

    public long Integral(byte[] array, int from, int to) {
        this.Integral = 0L;
        this.Size = to - from;
        for (int x = from; x < to; ++x) {
            this.Integral += (long)(array[x] & 0xFF);
        }
        return this.Integral;
    }

    public long Integral(byte[] array, byte ForbiddenValue) {
        return this.Integral(array, ForbiddenValue, 0, array.length);
    }

    public long Integral(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            this.Integral += (long)(array[x] & 0xFF);
            ++this.Size;
        }
        return this.Integral;
    }

    public long Integral(byte[] array, byte[] mask) {
        return this.Integral(array, mask, 0, array.length);
    }

    public long Integral(byte[] array, byte[] mask, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            this.Integral += (long)(array[x] & 0xFF);
            ++this.Size;
        }
        return this.Integral;
    }

    public double Average(byte[] array) {
        return this.Average(array, 0, array.length);
    }

    public double Average(byte[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(byte[] array, byte ForbiddenValue) {
        return this.Average(array, ForbiddenValue, 0, array.length);
    }

    public double Average(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(byte[] array, byte[] mask) {
        return this.Average(array, mask, 0, array.length);
    }

    public double Average(byte[] array, byte[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        return this.Average;
    }

    public void Moments(byte[] array) {
        this.Moments(array, 0, array.length);
    }

    public void Moments(byte[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            double v = (double)(array[x] & 0xFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(byte[] array, byte ForbiddenValue) {
        this.Moments(array, ForbiddenValue, 0, array.length);
    }

    public void Moments(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            double v = (double)(array[x] & 0xFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(byte[] array, byte[] mask) {
        this.Moments(array, mask, 0, array.length);
    }

    public void Moments(byte[] array, byte[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            double v = (double)(array[x] & 0xFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(byte[] array, int nbCPU) {
        this.MomentsParallelized(array, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(byte[] array, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(byte[] array, byte ForbiddenValue, int nbCPU) {
        this.MomentsParallelized(array, ForbiddenValue, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(byte[] array, byte ForbiddenValue, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, (int)ForbiddenValue, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, (int)ForbiddenValue, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public int Minimum(byte[] array) {
        return this.Minimum(array, 0, array.length);
    }

    public int Minimum(byte[] array, int from, int to) {
        this.MinimumIndex = from;
        this.Minimum = array[from] & 0xFF;
        for (int x = from + 1; x < to; ++x) {
            if (this.Minimum <= (array[x] & 0xFF)) continue;
            this.Minimum = array[x] & 0xFF;
            this.MinimumIndex = x;
        }
        return this.Minimum;
    }

    public int Minimum(byte[] array, byte ForbiddenValue) {
        return this.Minimum(array, ForbiddenValue, 0, array.length);
    }

    public int Minimum(byte[] array, byte ForbiddenValue, int from, int to) {
        int x;
        this.MinimumIndex = -1;
        this.Minimum = Integer.MAX_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Minimum = array[x] & 0xFF;
            this.MinimumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Minimum > (array[x] & 0xFF)) {
                this.Minimum = array[x] & 0xFF;
                this.MinimumIndex = x;
            }
            ++x;
        }
        return this.Minimum;
    }

    public int MinimumIndex(byte[] array) {
        return this.MinimumIndex(array, 0, array.length);
    }

    public int MinimumIndex(byte[] array, int from, int to) {
        this.Minimum = this.Minimum(array, from, to);
        return this.MinimumIndex;
    }

    public int MinimumIndex(byte[] array, byte ForbiddenValue) {
        return this.MinimumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MinimumIndex(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Minimum = this.Minimum(array, ForbiddenValue, from, to);
        return this.MinimumIndex;
    }

    public int Maximum(byte[] array) {
        return this.Maximum(array, 0, array.length);
    }

    public int Maximum(byte[] array, int from, int to) {
        this.MaximumIndex = from;
        this.Maximum = array[from] & 0xFF;
        for (int x = from + 1; x < to; ++x) {
            if (this.Maximum >= (array[x] & 0xFF)) continue;
            this.Maximum = array[x] & 0xFF;
            this.MaximumIndex = x;
        }
        return this.Maximum;
    }

    public int Maximum(byte[] array, byte ForbiddenValue) {
        return this.Maximum(array, ForbiddenValue, 0, array.length);
    }

    public int Maximum(byte[] array, byte ForbiddenValue, int from, int to) {
        int x;
        this.MaximumIndex = -1;
        this.Maximum = Integer.MIN_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Maximum = array[x] & 0xFF;
            this.MaximumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Maximum < (array[x] & 0xFF)) {
                this.Maximum = array[x] & 0xFF;
                this.MaximumIndex = x;
            }
            ++x;
        }
        return this.Maximum;
    }

    public int MaximumIndex(byte[] array) {
        return this.MaximumIndex(array, 0, array.length);
    }

    public int MaximumIndex(byte[] array, int from, int to) {
        this.Maximum = this.Maximum(array, from, to);
        return this.MaximumIndex;
    }

    public int MaximumIndex(byte[] array, byte ForbiddenValue) {
        return this.MaximumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MaximumIndex(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Maximum = this.Maximum(array, ForbiddenValue, from, to);
        return this.MaximumIndex;
    }

    public void Ranks(byte[] array) {
        this.Ranks(array, 0, array.length);
    }

    public void Ranks(byte[] array, int from, int to) {
        int[] buffer = new int[to - from];
        this.Size = buffer.length;
        ArrayNew.CopyUnsigned(array, from, buffer, 0, buffer.length);
        Arrays.sort(buffer);
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public void Ranks(byte[] array, byte ForbiddenValue) {
        this.Ranks(array, ForbiddenValue, 0, array.length);
    }

    public void Ranks(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            ++this.Size;
        }
        int[] buffer = new int[this.Size];
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            buffer[this.Size++] = array[x] & 0xFF;
        }
        Arrays.sort(buffer);
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public double Contrast(byte[] array) {
        return this.Contrast(array, 0, array.length);
    }

    public double Contrast(byte[] array, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, from, to) - this.Minimum(array, from, to)) / this.Average(array, from, to);
        return this.Contrast;
    }

    public double Contrast(byte[] array, byte ForbiddenValue) {
        return this.Contrast(array, ForbiddenValue, 0, array.length);
    }

    public double Contrast(byte[] array, byte ForbiddenValue, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, ForbiddenValue, from, to) - this.Minimum(array, ForbiddenValue, from, to)) / this.Average(array, ForbiddenValue, from, to);
        return this.Contrast;
    }

    public double Michelson(byte[] array) {
        return this.Michelson(array, 0, array.length);
    }

    public double Michelson(byte[] array, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(byte[] array, byte ForbiddenValue) {
        return this.Michelson(array, ForbiddenValue, 0, array.length);
    }

    public double Michelson(byte[] array, byte ForbiddenValue, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(byte[] array, int ranksup) {
        return this.MichelsonFromRanks(array, ranksup, 0, array.length);
    }

    public double MichelsonFromRanks(byte[] array, int ranksup, int from, int to) {
        this.Ranks(array, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(byte[] array, int ranksup, byte ForbiddenValue) {
        return this.MichelsonFromRanks(array, ranksup, ForbiddenValue, 0, array.length);
    }

    public double MichelsonFromRanks(byte[] array, int ranksup, byte ForbiddenValue, int from, int to) {
        this.Ranks(array, ForbiddenValue, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public int Counter(short[] array, short ForbiddenValue) {
        return this.Counter(array, ForbiddenValue, 0, array.length);
    }

    public int Counter(short[] array, short ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if ((array[x] & 0xFFFF) == ForbiddenValue) continue;
            ++this.Size;
        }
        return this.Size;
    }

    public long Integral(short[] array) {
        return this.Integral(array, 0, array.length);
    }

    public long Integral(short[] array, int from, int to) {
        this.Integral = 0L;
        this.Size = to - from;
        for (int x = from; x < to; ++x) {
            this.Integral += (long)(array[x] & 0xFFFF);
        }
        return this.Integral;
    }

    public long Integral(short[] array, short ForbiddenValue) {
        return this.Integral(array, ForbiddenValue, 0, array.length);
    }

    public long Integral(short[] array, short ForbiddenValue, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            this.Integral += (long)(array[x] & 0xFFFF);
            ++this.Size;
        }
        return this.Integral;
    }

    public long Integral(short[] array, short[] mask) {
        return this.Integral(array, mask, 0, array.length);
    }

    public long Integral(short[] array, short[] mask, int from, int to) {
        this.Integral = 0L;
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            this.Integral += (long)(array[x] & 0xFFFF);
            ++this.Size;
        }
        return this.Integral;
    }

    public double Average(short[] array) {
        return this.Average(array, 0, array.length);
    }

    public double Average(short[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(short[] array, short ForbiddenValue) {
        return this.Average(array, ForbiddenValue, 0, array.length);
    }

    public double Average(short[] array, short ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        return this.Average;
    }

    public double Average(short[] array, short[] mask) {
        return this.Average(array, mask, 0, array.length);
    }

    public double Average(short[] array, short[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        return this.Average;
    }

    public void Moments(short[] array) {
        this.Moments(array, 0, array.length);
    }

    public void Moments(short[] array, int from, int to) {
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            double v = (double)(array[x] & 0xFFFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(short[] array, short ForbiddenValue) {
        this.Moments(array, ForbiddenValue, 0, array.length);
    }

    public void Moments(short[] array, short ForbiddenValue, int from, int to) {
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            double v = (double)(array[x] & 0xFFFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void Moments(short[] array, short[] mask) {
        this.Moments(array, mask, 0, array.length);
    }

    public void Moments(short[] array, short[] mask, int from, int to) {
        this.Average = (double)this.Integral(array, mask, from, to) / (double)this.Size;
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (int x = from; x < to; ++x) {
            if (mask[x] == 0) continue;
            double v = (double)(array[x] & 0xFFFF) - this.Average;
            double tmp = v * v;
            this.Variance += tmp;
            this.Skewness += (tmp *= v);
            this.Kurtosis += tmp * v;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(short[] array, int nbCPU) {
        this.MomentsParallelized(array, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(short[] array, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public void MomentsParallelized(short[] array, short ForbiddenValue, int nbCPU) {
        this.MomentsParallelized(array, ForbiddenValue, 0, array.length, nbCPU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MomentsParallelized(short[] array, short ForbiddenValue, int from, int to, int nbCPU) {
        Object e2;
        int i;
        this.Average = (double)this.Integral(array, ForbiddenValue, from, to) / (double)this.Size;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MomentsThread[nbCPU];
            for (i = 0; i < nbCPU; ++i) {
                this.threads[i] = new MomentsThread();
                this.threads[i].start();
            }
            ArrayFeatures arrayFeatures = this;
            synchronized (arrayFeatures) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = array.length / nbCPU;
        for (i = 0; i < nbCPU - 1; ++i) {
            this.threads[i].Parameters(array, (int)ForbiddenValue, i * step, (i + 1) * step);
            e2 = this.threads[i].lock;
            synchronized (e2) {
                this.threads[i].lock.notify();
                continue;
            }
        }
        this.threads[i].Parameters(array, (int)ForbiddenValue, i * step, array.length);
        e2 = this.threads[i].lock;
        synchronized (e2) {
            this.threads[i].lock.notify();
        }
        e2 = this;
        synchronized (e2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.Kurtosis = 0.0;
        this.Skewness = 0.0;
        this.Variance = 0.0;
        for (i = 0; i < nbCPU; ++i) {
            MomentsThread thread = this.threads[i];
            this.Variance += thread.variance;
            this.Skewness += thread.skewness;
            this.Kurtosis += thread.kurtosis;
        }
        this.UnbiasedVariance = this.Variance / (double)(this.Size - 1);
        this.Variance /= (double)this.Size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.SampleStandardDeviation = Math.sqrt(this.UnbiasedVariance);
        this.SampleSkewness = this.Skewness / ((double)this.Size * this.SampleStandardDeviation * this.SampleStandardDeviation * this.SampleStandardDeviation);
        this.Skewness /= (double)this.Size * this.StandardDeviation * this.StandardDeviation * this.StandardDeviation;
        this.Kurtosis /= (double)this.Size * this.Variance * this.Variance;
        this.ExcessKurtosis = this.Kurtosis - 3.0;
        this.UnbiasedStandardDeviation = Math.sqrt(this.Variance * (double)this.Size / ((double)this.Size - 1.5 - this.ExcessKurtosis / 4.0));
    }

    public int Minimum(short[] array) {
        return this.Minimum(array, 0, array.length);
    }

    public int Minimum(short[] array, int from, int to) {
        this.MinimumIndex = from;
        this.Minimum = array[from] & 0xFFFF;
        for (int x = from + 1; x < to; ++x) {
            if (this.Minimum <= (array[x] & 0xFFFF)) continue;
            this.Minimum = array[x] & 0xFFFF;
            this.MinimumIndex = x;
        }
        return this.Minimum;
    }

    public int Minimum(short[] array, short ForbiddenValue) {
        return this.Minimum(array, ForbiddenValue, 0, array.length);
    }

    public int Minimum(short[] array, short ForbiddenValue, int from, int to) {
        int x;
        this.MinimumIndex = -1;
        this.Minimum = Integer.MAX_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Minimum = array[x] & 0xFFFF;
            this.MinimumIndex = x++;
        } else {
            throw new IllegalStateException("No minimum found!");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Minimum > (array[x] & 0xFFFF)) {
                this.Minimum = array[x] & 0xFFFF;
                this.MinimumIndex = x;
            }
            ++x;
        }
        return this.Minimum;
    }

    public int MinimumIndex(short[] array) {
        return this.MinimumIndex(array, 0, array.length);
    }

    public int MinimumIndex(short[] array, int from, int to) {
        this.Minimum = this.Minimum(array, from, to);
        return this.MinimumIndex;
    }

    public int MinimumIndex(short[] array, short ForbiddenValue) {
        return this.MinimumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MinimumIndex(short[] array, short ForbiddenValue, int from, int to) {
        this.Minimum = this.Minimum(array, ForbiddenValue, from, to);
        return this.MinimumIndex;
    }

    public int Maximum(short[] array) {
        return this.Maximum(array, 0, array.length);
    }

    public int Maximum(short[] array, int from, int to) {
        this.MaximumIndex = from;
        this.Maximum = array[from] & 0xFFFF;
        for (int x = from + 1; x < to; ++x) {
            if (this.Maximum >= (array[x] & 0xFFFF)) continue;
            this.Maximum = array[x] & 0xFFFF;
            this.MaximumIndex = x;
        }
        return this.Maximum;
    }

    public int Maximum(short[] array, short ForbiddenValue) {
        return this.Maximum(array, ForbiddenValue, 0, array.length);
    }

    public int Maximum(short[] array, short ForbiddenValue, int from, int to) {
        int x;
        this.MaximumIndex = -1;
        this.Maximum = Integer.MIN_VALUE;
        for (x = from; x < to && array[x] == ForbiddenValue; ++x) {
        }
        if (x < to) {
            this.Maximum = array[x] & 0xFFFF;
            this.MaximumIndex = x++;
        } else {
            throw new IllegalStateException("No valid value found.");
        }
        while (x < to) {
            if (array[x] != ForbiddenValue && this.Maximum < (array[x] & 0xFFFF)) {
                this.Maximum = array[x] & 0xFFFF;
                this.MaximumIndex = x;
            }
            ++x;
        }
        return this.Maximum;
    }

    public int MaximumIndex(short[] array) {
        return this.MaximumIndex(array, 0, array.length);
    }

    public int MaximumIndex(short[] array, int from, int to) {
        this.Maximum = this.Maximum(array, from, to);
        return this.MaximumIndex;
    }

    public int MaximumIndex(short[] array, short ForbiddenValue) {
        return this.MaximumIndex(array, ForbiddenValue, 0, array.length);
    }

    public int MaximumIndex(short[] array, short ForbiddenValue, int from, int to) {
        this.Maximum = this.Maximum(array, ForbiddenValue, from, to);
        return this.MaximumIndex;
    }

    public void Ranks(short[] array) {
        this.Ranks(array, 0, array.length);
    }

    public void Ranks(short[] array, int from, int to) {
        int[] buffer = new int[to - from];
        this.Size = buffer.length;
        ArrayNew.CopyUnsigned(array, from, buffer, 0, buffer.length);
        Arrays.sort(buffer);
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[(int)((double)this.Size * 0.25)];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[(int)((double)this.Size * 0.75)];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public void Ranks(short[] array, short ForbiddenValue) {
        this.Ranks(array, ForbiddenValue, 0, array.length);
    }

    public void Ranks(short[] array, short ForbiddenValue, int from, int to) {
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            ++this.Size;
        }
        int[] buffer = new int[this.Size];
        this.Size = 0;
        for (int x = from; x < to; ++x) {
            if (array[x] == ForbiddenValue) continue;
            buffer[this.Size++] = array[x] & 0xFFFF;
        }
        Arrays.sort(buffer);
        this.Minimum = buffer[0];
        this.Rank005 = buffer[(int)((double)this.Size * 0.005)];
        this.Rank01 = buffer[(int)((double)this.Size * 0.01)];
        this.Rank025 = buffer[(int)((double)this.Size * 0.025)];
        this.Rank05 = buffer[(int)((double)this.Size * 0.05)];
        this.Rank10 = buffer[(int)((double)this.Size * 0.1)];
        this.Rank25 = buffer[this.Size >> 2];
        this.Rank50 = buffer[this.Size >> 1];
        this.Rank75 = buffer[3 * this.Size >> 2];
        this.Rank90 = buffer[(int)((double)this.Size * 0.9)];
        this.Rank95 = buffer[(int)((double)this.Size * 0.95)];
        this.Rank975 = buffer[(int)((double)this.Size * 0.975)];
        this.Rank99 = buffer[(int)((double)this.Size * 0.99)];
        this.Rank995 = buffer[(int)((double)this.Size * 0.995)];
        this.Maximum = buffer[this.Size - 1];
        buffer = null;
    }

    public double Contrast(short[] array) {
        return this.Contrast(array, 0, array.length);
    }

    public double Contrast(short[] array, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, from, to) - this.Minimum(array, from, to)) / this.Average(array, from, to);
        return this.Contrast;
    }

    public double Contrast(short[] array, short ForbiddenValue) {
        return this.Contrast(array, ForbiddenValue, 0, array.length);
    }

    public double Contrast(short[] array, short ForbiddenValue, int from, int to) {
        this.Contrast = (double)(this.Maximum(array, ForbiddenValue, from, to) - this.Minimum(array, ForbiddenValue, from, to)) / this.Average(array, ForbiddenValue, from, to);
        return this.Contrast;
    }

    public double Michelson(short[] array) {
        return this.Michelson(array, 0, array.length);
    }

    public double Michelson(short[] array, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(short[] array, short ForbiddenValue) {
        return this.Michelson(array, ForbiddenValue, 0, array.length);
    }

    public double Michelson(short[] array, short ForbiddenValue, int from, int to) {
        double min = this.Minimum(array, from, to);
        double max = this.Maximum(array, from, to);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(short[] array, int ranksup) {
        return this.MichelsonFromRanks(array, ranksup, 0, array.length);
    }

    public double MichelsonFromRanks(short[] array, int ranksup, int from, int to) {
        this.Ranks(array, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(short[] array, int ranksup, short ForbiddenValue) {
        return this.MichelsonFromRanks(array, ranksup, ForbiddenValue, 0, array.length);
    }

    public double MichelsonFromRanks(short[] array, int ranksup, short ForbiddenValue, int from, int to) {
        this.Ranks(array, ForbiddenValue, from, to);
        switch (ranksup) {
            case -5: {
                this.Michelson = (this.Rank90 - this.Rank10) / (this.Rank90 + this.Rank10);
                break;
            }
            case -4: {
                this.Michelson = (this.Rank95 - this.Rank05) / (this.Rank95 + this.Rank05);
                break;
            }
            case -3: {
                this.Michelson = (this.Rank975 - this.Rank025) / (this.Rank975 + this.Rank025);
                break;
            }
            case -2: {
                this.Michelson = (this.Rank99 - this.Rank01) / (this.Rank99 + this.Rank01);
                break;
            }
            case -1: {
                this.Michelson = (this.Rank995 - this.Rank005) / (this.Rank995 + this.Rank005);
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank not supported/unknown.");
            }
        }
        return this.Michelson;
    }

    private synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public int Counter(double[][][] source, double ForbiddenValue) {
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        boolean SIze = false;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    ++this.Size;
                }
            }
        }
        return this.Size;
    }

    public int Counter(float[][][] source, float ForbiddenValue) {
        this.Size = 0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    ++this.Size;
                }
            }
        }
        return this.Size;
    }

    public int Counter(boolean[][][] source) {
        return this.Sum(source);
    }

    public int Counter(int[][][] source, int ForbiddenValue) {
        this.Size = 0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    ++this.Size;
                }
            }
        }
        return this.Size;
    }

    public int Integral(boolean[][][] source) {
        return this.Sum(source);
    }

    public float Integral(float[][][] source) {
        return this.Sum(source);
    }

    public long Integral(int[][][] source) {
        return this.Sum(source);
    }

    public double Integral(double[][][] source) {
        return this.Sum(source);
    }

    public long Integral(short[][][] source) {
        return this.Sum(source);
    }

    public int Sum(boolean[][][] source) {
        this.Integral = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!source[z][y][x]) continue;
                    ++this.Integral;
                }
            }
        }
        return (int)this.Integral;
    }

    public long Sum(int[][][] source) {
        this.Integral = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.Integral += (long)source[z][y][x];
                }
            }
        }
        return this.Integral;
    }

    public float Sum(float[][][] source) {
        this.IntegralDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.IntegralDouble += (double)source[z][y][x];
                }
            }
        }
        return (float)this.IntegralDouble;
    }

    public double Sum(double[][][] source) {
        this.IntegralDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.IntegralDouble += source[z][y][x];
                }
            }
        }
        return this.IntegralDouble;
    }

    public long Sum(byte[][][] source) {
        this.Integral = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.Integral += (long)(source[z][y][x] & 0xFF);
                }
            }
        }
        return this.Integral;
    }

    public long Sum(short[][][] source) {
        this.Integral = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.Integral += (long)(source[z][y][x] & 0xFFFF);
                }
            }
        }
        return this.Integral;
    }

    public double Integral(double[][][] source, double ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public float Integral(float[][][] source, float ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public double Sum(double[][][] source, double ForbiddenValue) {
        this.IntegralDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    this.IntegralDouble += source[z][y][x];
                }
            }
        }
        return this.IntegralDouble;
    }

    public float Sum(float[][][] source, float ForbiddenValue) {
        this.IntegralDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    this.IntegralDouble += (double)source[z][y][x];
                }
            }
        }
        return (float)this.IntegralDouble;
    }

    public long Integral(int[][][] source, int ForbiddenValue) {
        return this.Sum(source, ForbiddenValue);
    }

    public long Sum(int[][][] source, int ForbiddenValue) {
        this.Integral = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (source[z][y][x] == ForbiddenValue) continue;
                    this.Integral += (long)source[z][y][x];
                }
            }
        }
        return this.Integral;
    }

    public long SumAbs(int[][][] source) {
        this.IntegralAbs = 0L;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.IntegralAbs += (long)Math.abs(source[z][y][x]);
                }
            }
        }
        return this.IntegralAbs;
    }

    public float SumAbs(float[][][] source) {
        this.IntegralAbsDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.IntegralAbsDouble += (double)Math.abs(source[z][y][x]);
                }
            }
        }
        return (float)this.IntegralAbsDouble;
    }

    public double SumAbs(double[][][] source) {
        this.IntegralAbsDouble = 0.0;
        int width = source[0][0].length;
        int height = source[0].length;
        int depth = source.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.IntegralAbsDouble += Math.abs(source[z][y][x]);
                }
            }
        }
        return this.IntegralAbsDouble;
    }

    public int Counter(double[] source, int SizeX, int SizeY, int SizeZ, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Size = 0;
        int layer = SizeX * SizeY;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Size;
    }

    public int Counter(float[] source, int SizeX, int SizeY, int SizeZ, float ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Size = 0;
        int layer = SizeX * SizeY;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Size;
    }

    public int Counter(byte[] source, int SizeX, int SizeY, int SizeZ, byte ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Size = 0;
        int layer = SizeX * SizeY;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Size;
    }

    public int Counter(short[] source, int SizeX, int SizeY, int SizeZ, short ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Size = 0;
        int layer = SizeX * SizeY;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Size;
    }

    public int Counter(int[] source, int SizeX, int SizeY, int SizeZ, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Size = 0;
        int layer = SizeX * SizeY;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Size;
    }

    public long Integral(int[] source, int SizeX, int SizeY, int SizeZ, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Size = 0;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        this.Integral += (long)source[pos];
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Integral;
    }

    public long Integral(byte[] source, int SizeX, int SizeY, int SizeZ, byte ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Size = 0;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        this.Integral += (long)(source[pos] & 0xFF);
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Integral;
    }

    public long Integral(short[] source, int SizeX, int SizeY, int SizeZ, short ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Size = 0;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        this.Integral += (long)(source[pos] & 0xFFFF);
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.Integral;
    }

    public double Integral(float[] source, int SizeX, int SizeY, int SizeZ, float ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Size = 0;
        this.IntegralDouble = 0.0;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        this.IntegralDouble += (double)source[pos];
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.IntegralDouble;
    }

    public double Integral(double[] source, int SizeX, int SizeY, int SizeZ, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Size = 0;
        this.IntegralDouble = 0.0;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    if (source[pos] != ForbiddenValue) {
                        this.IntegralDouble += source[pos];
                        ++this.Size;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        return this.IntegralDouble;
    }

    public long Integral(int[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    this.Integral += (long)source[pos];
                    ++x;
                    ++pos;
                }
            }
        }
        this.Size = (EndX - FromX) * (EndY - FromY) * (EndZ - FromZ);
        return this.Integral;
    }

    public long Integral(byte[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    this.Integral += (long)(source[pos] & 0xFF);
                    ++x;
                    ++pos;
                }
            }
        }
        this.Size = (EndX - FromX) * (EndY - FromY) * (EndZ - FromZ);
        return this.Integral;
    }

    public long Integral(short[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.Integral = 0L;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    this.Integral += (long)(source[pos] & 0xFFFF);
                    ++x;
                    ++pos;
                }
            }
        }
        this.Size = (EndX - FromX) * (EndY - FromY) * (EndZ - FromZ);
        return this.Integral;
    }

    public double Integral(float[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.IntegralDouble = 0.0;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    this.IntegralDouble += (double)source[pos];
                    ++x;
                    ++pos;
                }
            }
        }
        this.Size = (EndX - FromX) * (EndY - FromY) * (EndZ - FromZ);
        return this.IntegralDouble;
    }

    public double Integral(double[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int layer = SizeX * SizeY;
        this.IntegralDouble = 0.0;
        for (int z = FromZ; z < EndZ; ++z) {
            for (int y = FromY; y < EndY; ++y) {
                int x = FromX;
                int pos = x + y * SizeX + z * layer;
                while (x < EndX) {
                    this.IntegralDouble += source[pos];
                    ++x;
                    ++pos;
                }
            }
        }
        this.Size = (EndX - FromX) * (EndY - FromY) * (EndZ - FromZ);
        return this.IntegralDouble;
    }

    public double Average(double[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = this.IntegralDouble / (double)this.Size;
        return this.Average;
    }

    public double Average(float[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = this.IntegralDouble / (double)this.Size;
        return this.Average;
    }

    public double Average(int[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public double Average(byte[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public double Average(short[] source, int SizeX, int SizeY, int SizeZ, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public double Average(double[] source, int SizeX, int SizeY, int SizeZ, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = this.IntegralDouble / (double)this.Size;
        return this.Average;
    }

    public double Average(float[] source, int SizeX, int SizeY, int SizeZ, float ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = this.IntegralDouble / (double)this.Size;
        return this.Average;
    }

    public double Average(int[] source, int SizeX, int SizeY, int SizeZ, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public double Average(byte[] source, int SizeX, int SizeY, int SizeZ, byte ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public double Average(short[] source, int SizeX, int SizeY, int SizeZ, short ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        this.Integral(source, SizeX, SizeY, SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
        this.Average = (double)this.Integral / (double)this.Size;
        return this.Average;
    }

    public long Integral() {
        return this.Integral;
    }

    public double IntegralDouble() {
        return this.IntegralDouble;
    }

    public long IntegralAbs() {
        return this.IntegralAbs;
    }

    public double IntegralAbsDouble() {
        return this.IntegralAbsDouble;
    }

    public int Size() {
        return this.Size;
    }

    public double Average() {
        return this.Average;
    }

    public double Variance() {
        return this.Variance;
    }

    public double UnbiasedVariance() {
        return this.UnbiasedVariance;
    }

    public double StandardDeviation() {
        return this.StandardDeviation;
    }

    public double SampleStandardDeviation() {
        return this.SampleStandardDeviation;
    }

    public double UnbiasedStandardDeviation() {
        return this.UnbiasedStandardDeviation;
    }

    public double Kurtosis() {
        return this.Kurtosis;
    }

    public double ExcessKurtosis() {
        return this.ExcessKurtosis;
    }

    public double Skewness() {
        return this.Skewness;
    }

    public double SampleSkewness() {
        return this.SampleSkewness;
    }

    public double Contrast() {
        return this.Contrast;
    }

    public double Michelson() {
        return this.Michelson;
    }

    public int Minimum() {
        return this.Minimum;
    }

    public double MinimumDouble() {
        return this.MinimumDouble;
    }

    public int Maximum() {
        return this.Maximum;
    }

    public double MaximumDouble() {
        return this.MaximumDouble;
    }

    public int MinimumIndex() {
        return this.MinimumIndex;
    }

    public int MaximumIndex() {
        return this.MaximumIndex;
    }

    public double Rank005() {
        return this.Rank005;
    }

    public double Rank01() {
        return this.Rank01;
    }

    public double Rank025() {
        return this.Rank025;
    }

    public double Rank05() {
        return this.Rank05;
    }

    public double Rank10() {
        return this.Rank10;
    }

    public double Rank25() {
        return this.Rank25;
    }

    public double Rank50() {
        return this.Rank50;
    }

    public double Rank75() {
        return this.Rank75;
    }

    public double Rank90() {
        return this.Rank90;
    }

    public double Rank95() {
        return this.Rank95;
    }

    public double Rank975() {
        return this.Rank975;
    }

    public double Rank99() {
        return this.Rank99;
    }

    public double Rank995() {
        return this.Rank995;
    }

    private class MomentsThread
    extends Thread {
        private byte[] bytearray = null;
        private double[] doublearray = null;
        private float[] floatarray = null;
        private int[] intarray = null;
        private short[] shortarray = null;
        private double average;
        public double variance;
        public double skewness;
        public double kurtosis;
        private int from;
        private int to;
        private int fvi;
        private double fvd;
        private float fvf;
        private final Object lock = new Object();
        private int type = -1;
        private final int TypeByte = 0;
        private final int TypeByteFv = 1;
        private final int TypeDouble = 2;
        private final int TypeDoubleFv = 3;
        private final int TypeFloat = 4;
        private final int TypeFloatFv = 5;
        private final int TypeInt = 6;
        private final int TypeIntFv = 7;
        private final int TypeShort = 8;
        private final int TypeShortFv = 9;

        public void Parameters(byte[] array, int from, int to) {
            this.from = from;
            this.to = to;
            this.bytearray = array;
            this.type = 0;
        }

        public void Parameters(byte[] array, int fv, int from, int to) {
            this.from = from;
            this.to = to;
            this.fvi = fv;
            this.bytearray = array;
            this.type = 1;
        }

        public void Parameters(short[] array, int from, int to) {
            this.from = from;
            this.to = to;
            this.shortarray = array;
            this.type = 8;
        }

        public void Parameters(short[] array, int fv, int from, int to) {
            this.from = from;
            this.to = to;
            this.fvi = fv;
            this.shortarray = array;
            this.type = 9;
        }

        public void Parameters(double[] array, int from, int to) {
            this.from = from;
            this.to = to;
            this.doublearray = array;
            this.type = 2;
        }

        public void Parameters(double[] array, double fv, int from, int to) {
            this.from = from;
            this.to = to;
            this.fvd = fv;
            this.doublearray = array;
            this.type = 3;
        }

        public void Parameters(float[] array, int from, int to) {
            this.from = from;
            this.to = to;
            this.floatarray = array;
            this.type = 4;
        }

        public void Parameters(float[] array, float fv, int from, int to) {
            this.from = from;
            this.to = to;
            this.fvf = fv;
            this.floatarray = array;
            this.type = 5;
        }

        public void Parameters(int[] array, int from, int to) {
            this.from = from;
            this.to = to;
            this.intarray = array;
            this.type = 6;
        }

        public void Parameters(int[] array, int fv, int from, int to) {
            this.from = from;
            this.to = to;
            this.fvi = fv;
            this.intarray = array;
            this.type = 7;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ArrayFeatures.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.average = ArrayFeatures.this.Average;
                this.kurtosis = 0.0;
                this.skewness = 0.0;
                this.variance = 0.0;
                switch (this.type) {
                    case 0: {
                        double tmp;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double v = (double)(this.bytearray[x] & 0xFF) - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                            ++x;
                        }
                    }
                    case 1: {
                        double tmp;
                        double v;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            int vali = this.bytearray[x] & 0xFF;
                            if (vali != this.fvi) {
                                v = (double)vali - this.average;
                                tmp = v * v;
                                this.variance += tmp;
                                this.skewness += (tmp *= v);
                                this.kurtosis += (tmp *= v);
                            }
                            ++x;
                        }
                    }
                    case 8: {
                        double tmp;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double v = (double)(this.shortarray[x] & 0xFFFF) - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                            ++x;
                        }
                    }
                    case 9: {
                        double tmp;
                        double v;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            int vali = this.shortarray[x] & 0xFFFF;
                            if (vali != this.fvi) {
                                v = (double)vali - this.average;
                                tmp = v * v;
                                this.variance += tmp;
                                this.skewness += (tmp *= v);
                                this.kurtosis += (tmp *= v);
                            }
                            ++x;
                        }
                    }
                    case 2: {
                        double tmp;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double v = this.doublearray[x] - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                            ++x;
                        }
                    }
                    case 3: {
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double vald = this.doublearray[x];
                            if (Double.compare(vald, this.fvd) != 0) {
                                double v = vald - this.average;
                                double tmp = v * v;
                                this.variance += tmp;
                                this.skewness += (tmp *= v);
                                this.kurtosis += (tmp *= v);
                            }
                            ++x;
                        }
                    }
                    case 4: {
                        double tmp;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double v = (double)this.floatarray[x] - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                            ++x;
                        }
                    }
                    case 5: {
                        double tmp;
                        double v;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            float valf = this.floatarray[x];
                            if (Float.compare(valf, this.fvf) != 0) {
                                v = (double)valf - this.average;
                                tmp = v * v;
                                this.variance += tmp;
                                this.skewness += (tmp *= v);
                                this.kurtosis += (tmp *= v);
                            }
                            ++x;
                        }
                    }
                    case 6: {
                        double tmp;
                        int x = this.from;
                        while (true) {
                            if (x >= this.to) continue block17;
                            double v = (double)this.intarray[x] - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                            ++x;
                        }
                    }
                    case 7: {
                        double tmp;
                        double v;
                        for (int x = this.from; x < this.to; ++x) {
                            int vali = this.intarray[x] & 0xFF;
                            if (vali == this.fvi) continue;
                            v = (double)vali - this.average;
                            tmp = v * v;
                            this.variance += tmp;
                            this.skewness += (tmp *= v);
                            this.kurtosis += (tmp *= v);
                        }
                        continue block17;
                    }
                }
            }
        }
    }
}

