/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import arrayTiTi.ArrayTools;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import utils.memory.Allocator;

public final class ArrayNew {
    public static byte[] Same(byte[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newByteArray(source.length);
    }

    public static byte[][] Same(byte[][] source) {
        byte[][] result = new byte[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new byte[source[i].length];
        }
        return result;
    }

    public static byte[][][] Same(byte[][][] source) {
        byte[][][] result = new byte[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new byte[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new byte[source[z][y].length];
            }
        }
        return result;
    }

    public static short[] Same(short[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newShortArray(source.length);
    }

    public static short[][] Same(short[][] source) {
        short[][] result = new short[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new short[source[i].length];
        }
        return result;
    }

    public static short[][][] Same(short[][][] source) {
        short[][][] result = new short[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new short[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new short[source[z][y].length];
            }
        }
        return result;
    }

    public static int[] Same(int[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newIntArray(source.length);
    }

    public static int[][] Same(int[][] source) {
        int[][] result = new int[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new int[source[i].length];
        }
        return result;
    }

    public static int[][][] Same(int[][][] source) {
        int[][][] result = new int[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new int[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new int[source[z][y].length];
            }
        }
        return result;
    }

    public static float[] Same(float[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newFloatArray(source.length);
    }

    public static float[][] Same(float[][] source) {
        float[][] result = new float[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new float[source[i].length];
        }
        return result;
    }

    public static float[][][] Same(float[][][] source) {
        float[][][] result = new float[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new float[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new float[source[z][y].length];
            }
        }
        return result;
    }

    public static double[] Same(double[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newDoubleArray(source.length);
    }

    public static double[][] Same(double[][] source) {
        double[][] result = new double[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new double[source[i].length];
        }
        return result;
    }

    public static double[][][] Same(double[][][] source) {
        double[][][] result = new double[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new double[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new double[source[z][y].length];
            }
        }
        return result;
    }

    public static boolean[] Same(boolean[] source) {
        Allocator allocator = Allocator.Instance();
        return allocator.newBooleanArray(source.length);
    }

    public static boolean[][] Same(boolean[][] source) {
        boolean[][] result = new boolean[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new boolean[source[i].length];
        }
        return result;
    }

    public static boolean[][][] Same(boolean[][][] source) {
        boolean[][][] result = new boolean[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new boolean[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new boolean[source[z][y].length];
            }
        }
        return result;
    }

    public static String[] Same(String[] source) {
        return new String[source.length];
    }

    public static String[][] Same(String[][] source) {
        String[][] result = new String[source.length][];
        for (int i = 0; i < source.length; ++i) {
            result[i] = new String[source[i].length];
        }
        return result;
    }

    public static String[][][] Same(String[][][] source) {
        String[][][] result = new String[source.length][][];
        for (int z = 0; z < source.length; ++z) {
            result[z] = new String[source[z].length][];
            for (int y = 0; y < source[z].length; ++y) {
                result[z][y] = new String[source[z][y].length];
            }
        }
        return result;
    }

    public static void Copy(short[][] source, short[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(byte[][] source, byte[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(double[][] source, double[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(float[][] source, float[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(int[][] source, int[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(boolean[][] source, boolean[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(String[][] source, String[][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void CopyRough(byte[][] source, byte[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(short[][] source, short[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(double[][] source, double[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(float[][] source, float[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(int[][] source, int[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(boolean[][] source, boolean[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void CopyRough(String[][] source, String[][] result) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, result[y], 0, source[y].length);
        }
    }

    public static void Copy(short[][][] source, short[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(byte[][][] source, byte[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(double[][][] source, double[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(float[][][] source, float[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(int[][][] source, int[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(boolean[][][] source, boolean[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void Copy(String[][][] source, String[][][] result) {
        if (!ArrayTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        ArrayNew.CopyRough(source, result);
    }

    public static void CopyRough(byte[][][] source, byte[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(short[][][] source, short[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(double[][][] source, double[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(float[][][] source, float[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(int[][][] source, int[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(boolean[][][] source, boolean[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyRough(String[][][] source, String[][][] result) {
        for (int z = 0; z < source.length; ++z) {
            for (int y = 0; y < source[z].length; ++y) {
                System.arraycopy(source[z][y], 0, result[z][y], 0, source[z][y].length);
            }
        }
    }

    public static void CopyUnsigned(byte[] src, int[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(byte[] src, int startsrc, int[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFF;
        }
    }

    public static void CopyUnsigned(short[] src, int[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(short[] src, int startsrc, int[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFFFF;
        }
    }

    public static void CopyUnsigned(byte[] src, float[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(byte[] src, int startsrc, float[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFF;
        }
    }

    public static void CopyUnsigned(byte[] src, double[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(byte[] src, int startsrc, double[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFF;
        }
    }

    public static void CopyUnsigned(short[] src, float[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(short[] src, int startsrc, float[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFFFF;
        }
    }

    public static void CopyUnsigned(short[] src, double[] dest) {
        ArrayNew.CopyUnsigned(src, 0, dest, 0, src.length);
    }

    public static void CopyUnsigned(short[] src, int startsrc, double[] dest, int startdest, int length) {
        int possrc = startsrc;
        int posdest = startdest;
        for (int x = 0; x < length; ++x) {
            dest[posdest++] = src[possrc++] & 0xFFFF;
        }
    }

    public static byte[][] Clone(byte[][] source) {
        byte[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static boolean[][] Clone(boolean[][] source) {
        boolean[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static short[][] Clone(short[][] source) {
        short[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static int[][] Clone(int[][] source) {
        int[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static double[][] Clone(double[][] source) {
        double[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static String[][] Clone(String[][] source) {
        String[][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static byte[][][] Clone(byte[][][] source) {
        byte[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static boolean[][][] Clone(boolean[][][] source) {
        boolean[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static short[][][] Clone(short[][][] source) {
        short[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static int[][][] Clone(int[][][] source) {
        int[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static double[][][] Clone(double[][][] source) {
        double[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static float[][][] Clone(float[][][] source) {
        float[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static String[][][] Clone(String[][][] source) {
        String[][][] clone = ArrayNew.Same(source);
        ArrayNew.Copy(source, clone);
        return clone;
    }

    public static int[][] Random(int[][] source) {
        ArrayFeatures af = new ArrayFeatures();
        return ArrayNew.Random(source[0].length, source.length, af.Minimum(source), af.Maximum(source));
    }

    public static int[][] Random(int[][] source, int min, int max) {
        return ArrayNew.Random(source[0].length, source.length, min, max);
    }

    public static int[][] Random(int width, int height, int min, int max) {
        int[][] result = new int[height][width];
        double size = max - min;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (int)(Math.random() * size) + min;
            }
        }
        return result;
    }

    public static double[][] Random(double[][] source) {
        return ArrayNew.Random(source[0].length, source.length);
    }

    public static double[][] Random(int width, int height) {
        double[][] result = new double[height][width];
        ArrayNew.Random(result);
        return result;
    }

    public static int[] RandomInt(int length, int min, int max) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(length);
        allocator = null;
        ArrayOperations.FillRandomly(result, min, max);
        return result;
    }

    public static double[] RandomDouble(int length, double min, double max) {
        Allocator allocator = Allocator.Instance();
        double[] result = allocator.newDoubleArray(length);
        allocator = null;
        ArrayOperations.FillRandomly(result, min, max);
        return result;
    }

    public static float[] RandomFloat(int length, float min, float max) {
        Allocator allocator = Allocator.Instance();
        float[] result = allocator.newFloatArray(length);
        allocator = null;
        ArrayOperations.FillRandomly(result, min, max);
        return result;
    }

    public static byte[] RandomByte(int length, int min, int max) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(length);
        allocator = null;
        ArrayOperations.FillRandomly(result, min, max);
        return result;
    }

    public static short[] RandomShort(int length, int min, int max) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(length);
        ArrayOperations.FillRandomly(result, min, max);
        return result;
    }

    public static String[] RandomAlphanumericString(int length, int min, int max) {
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = RandomStringUtils.randomAlphanumeric(min, max + 1);
        }
        return result;
    }

    public static String[] RandomAlphabeticString(int length, int min, int max) {
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = RandomStringUtils.randomAlphabetic(min, max + 1);
        }
        return result;
    }

    public static String[] RandomNumericString(int length, int min, int max) {
        int gap = max - min + 1;
        Random random = new Random();
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = RandomStringUtils.randomNumeric(min, max + 1);
        }
        return result;
    }

    public static int[] IncreasingInt(int length, int start) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(length);
        allocator = null;
        ArrayNew.FillIncreasing(result, start);
        return result;
    }

    public static void FillIncreasing(int[] array, int start) {
        int v = start;
        for (int i = 0; i < array.length; ++i) {
            array[i] = v++;
        }
    }

    public static byte[] IncreasingByte(int length, int start) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(length);
        allocator = null;
        ArrayNew.FillIncreasing(result, start);
        return result;
    }

    public static void FillIncreasing(byte[] array, int start) {
        int i = 0;
        int v = start;
        while (i < array.length) {
            array[i] = (byte)v;
            ++i;
            ++v;
        }
    }

    public static short[] IncreasingShort(int length, int start) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(length);
        allocator = null;
        ArrayNew.FillIncreasing(result, start);
        return result;
    }

    public static void FillIncreasing(short[] array, int start) {
        int i = 0;
        int v = start;
        while (i < array.length) {
            array[i] = (short)v;
            ++i;
            ++v;
        }
    }
}

