/*
 * Decompiled with CFR 0.152.
 */
package arrayTiTi;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mathematics.primitives.pointsTiTi.Coordinates;
import utils.memory.Allocator;

public class ArrayOperations {
    public static void Fill(int[][] Tab, int Value) {
        for (int[] Tab1 : Tab) {
            Arrays.fill(Tab1, Value);
        }
    }

    public static void Fill(int[][][] Tab, int Value) {
        for (int[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(long[][] Tab, long Value) {
        for (long[] Tab1 : Tab) {
            Arrays.fill(Tab1, Value);
        }
    }

    public static void Fill(long[][][] Tab, long Value) {
        for (long[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(float[][] Tab, float Value) {
        for (float[] Tab1 : Tab) {
            Arrays.fill(Tab1, Value);
        }
    }

    public static void Fill(float[][][] Tab, float Value) {
        for (float[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(double[][] Tab, double Value) {
        for (double[] Tab1 : Tab) {
            Arrays.fill(Tab1, Value);
        }
    }

    public static void Fill(double[][][] Tab, double Value) {
        for (double[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(boolean[][] Tab, boolean Value) {
        for (boolean[] Tab1 : Tab) {
            Arrays.fill(Tab1, Value);
        }
    }

    public static void Fill(boolean[][][] Tab, boolean Value) {
        for (boolean[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(String[][] Tab, String Value) {
        for (Object[] objectArray : Tab) {
            Arrays.fill(objectArray, Value);
        }
    }

    public static void Fill(String[][][] Tab, String Value) {
        for (String[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, Value);
        }
    }

    public static void Fill(byte[][] Tab, int Value) {
        for (byte[] Tab1 : Tab) {
            Arrays.fill(Tab1, (byte)Value);
        }
    }

    public static void Fill(byte[][][] Tab, int Value) {
        for (byte[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, (int)((byte)Value));
        }
    }

    public static void Fill(short[][] Tab, int Value) {
        for (short[] Tab1 : Tab) {
            Arrays.fill(Tab1, (short)Value);
        }
    }

    public static void Fill(short[][][] Tab, int Value) {
        for (short[][] Tab1 : Tab) {
            ArrayOperations.Fill(Tab1, (int)((short)Value));
        }
    }

    public static void FillRandomly(byte[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (byte)(Math.random() * 256.0);
        }
    }

    public static void FillRandomly(short[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (short)(Math.random() * 65536.0);
        }
    }

    public static void FillRandomly(int[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (int)(Math.random() < 0.5 ? Math.random() * -2.147483648E9 : Math.random() * 2.147483647E9);
        }
    }

    public static void FillRandomly(float[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (float)Math.random();
        }
    }

    public static void FillRandomly(double[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = Math.random();
        }
    }

    public static void FillRandomly(int[] array, int min, int max) {
        if (min < 0 && max <= 0 || 0 <= min && 0 < max) {
            int size = max - min;
            for (int x = 0; x < array.length; ++x) {
                array[x] = (int)(Math.random() * (double)size) + min;
            }
        } else {
            for (int x = 0; x < array.length; ++x) {
                array[x] = (int)(Math.random() < 0.5 ? Math.random() * (double)min : Math.random() * (double)max);
            }
        }
    }

    public static void FillRandomly(double[] array, double min, double max) {
        if (min < 0.0 && max <= 0.0 || 0.0 <= min && 0.0 < max) {
            double size = max - min;
            for (int x = 0; x < array.length; ++x) {
                array[x] = Math.random() * size + min;
            }
        } else {
            for (int x = 0; x < array.length; ++x) {
                array[x] = Math.random() < 0.5 ? Math.random() * min : Math.random() * max;
            }
        }
    }

    public static void FillRandomly(float[] array, float min, float max) {
        double size = max - min;
        for (int x = 0; x < array.length; ++x) {
            array[x] = (float)(Math.random() * size) + min;
        }
    }

    public static void FillRandomly(byte[] array, int min, int max) {
        double size = max - min;
        for (int x = 0; x < array.length; ++x) {
            array[x] = (byte)((int)(Math.random() * size) + min);
        }
    }

    public static void FillRandomly(short[] array, int min, int max) {
        double size = max - min;
        for (int x = 0; x < array.length; ++x) {
            array[x] = (byte)((int)(Math.random() * size) + min);
        }
    }

    public static void FillGaussianRandomly(byte[] array, double sd) {
        Random random = new Random();
        for (int x = 0; x < array.length; ++x) {
            double v = 128.0 + random.nextGaussian() * sd;
            array[x] = v < 0.0 ? 0 : (255.0 < v ? -1 : (byte)v);
        }
        random = null;
    }

    public static void FillGaussianRandomly(short[] array, double sd) {
        Random random = new Random();
        for (int x = 0; x < array.length; ++x) {
            double v = 32768.0 + random.nextGaussian() * sd;
            array[x] = v < 0.0 ? 0 : (65535.0 < v ? -1 : (short)v);
        }
        random = null;
    }

    public static void FillGaussianRandomly(int[] array, double sd) {
        Random random = new Random();
        for (int x = 0; x < array.length; ++x) {
            array[x] = (int)(random.nextGaussian() * sd);
        }
        random = null;
    }

    public static void FillGaussianRandomly(float[] array, double sd) {
        Random random = new Random();
        for (int x = 0; x < array.length; ++x) {
            array[x] = (float)(random.nextGaussian() * sd);
        }
        random = null;
    }

    public static void FillGaussianRandomly(double[] array, double sd) {
        Random random = new Random();
        for (int x = 0; x < array.length; ++x) {
            array[x] = random.nextGaussian() * sd;
        }
        random = null;
    }

    public static void FillIncreasingly(double[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = x;
        }
    }

    public static void FillIncreasingly(float[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = x;
        }
    }

    public static void FillIncreasingly(byte[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (byte)x;
        }
    }

    public static void FillIncreasingly(short[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = (short)x;
        }
    }

    public static void FillIncreasingly(int[] array) {
        for (int x = 0; x < array.length; ++x) {
            array[x] = x;
        }
    }

    public static void DrawBorder(int[][] array, int Value) {
        int width = array[0].length - 1;
        int height = array.length - 1;
        for (int y = 0; y <= height; ++y) {
            int n = Value;
            array[y][width] = n;
            array[y][0] = n;
        }
        for (int x = 0; x <= width; ++x) {
            int n = Value;
            array[height][x] = n;
            array[0][x] = n;
        }
    }

    public static void DrawBorder(double[][] array, double Value) {
        int width = array[0].length - 1;
        int height = array.length - 1;
        for (int y = 0; y <= height; ++y) {
            double d = Value;
            array[y][width] = d;
            array[y][0] = d;
        }
        for (int x = 0; x <= width; ++x) {
            double d = Value;
            array[height][x] = d;
            array[0][x] = d;
        }
    }

    public static void Stretch(int[][] tab, int min, int max) {
        ArrayFeatures af = new ArrayFeatures();
        int OldLandMarkSup = af.Maximum(tab);
        int OldLandMarkInf = af.Minimum(tab);
        double a = (double)(max - min) / (double)(OldLandMarkSup - OldLandMarkInf);
        double b = (double)min - a * (double)OldLandMarkInf;
        int height = tab.length;
        int width = tab[0].length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                tab[y][x] = (int)(a * (double)tab[y][x] + b);
            }
        }
    }

    public static void Stretch(int[][] tab, int[][] result, int min, int max) {
        ArrayFeatures af = new ArrayFeatures();
        int OldLandMarkSup = af.Maximum(tab);
        int OldLandMarkInf = af.Minimum(tab);
        double a = (double)(max - min) / (double)(OldLandMarkSup - OldLandMarkInf);
        double b = (double)min - a * (double)OldLandMarkInf;
        int height = tab.length;
        int width = tab[0].length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (int)(a * (double)tab[y][x] + b);
            }
        }
    }

    public static void Stretch(double[][] tab, double min, double max) {
        ArrayFeatures af = new ArrayFeatures();
        double OldLandMarkSup = af.Maximum(tab);
        double OldLandMarkInf = af.Minimum(tab);
        double a = (max - min) / (OldLandMarkSup - OldLandMarkInf);
        double b = min - a * OldLandMarkInf;
        int height = tab.length;
        int width = tab[0].length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                tab[y][x] = (int)(a * tab[y][x] + b);
            }
        }
    }

    public static void Stretch(double[][] tab, double[][] result, double min, double max) {
        ArrayFeatures af = new ArrayFeatures();
        double OldLandMarkSup = af.Maximum(tab);
        double OldLandMarkInf = af.Minimum(tab);
        double a = (max - min) / (OldLandMarkSup - OldLandMarkInf);
        double b = min - a * OldLandMarkInf;
        int height = tab.length;
        int width = tab[0].length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (int)(a * tab[y][x] + b);
            }
        }
    }

    public static byte[] Lut(byte[] array, int[] lut) {
        Allocator allocator = Allocator.Instance();
        byte[] result = allocator.newByteArray(array.length);
        allocator = null;
        ArrayOperations.Lut(array, lut, result);
        return result;
    }

    public static void Lut(byte[] array, int[] lut, byte[] result) {
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)lut[array[i] & 0xFF];
        }
    }

    public static short[] Lut(short[] array, int[] lut) {
        Allocator allocator = Allocator.Instance();
        short[] result = allocator.newShortArray(array.length);
        allocator = null;
        ArrayOperations.Lut(array, lut, result);
        return result;
    }

    public static void Lut(short[] array, int[] lut, short[] result) {
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)lut[array[i] & 0xFFFF];
        }
    }

    public static int[] Lut(int[] array, int[] lut) {
        Allocator allocator = Allocator.Instance();
        int[] result = allocator.newIntArray(array.length);
        allocator = null;
        ArrayOperations.Lut(array, lut, result);
        return result;
    }

    public static void Lut(int[] array, int[] lut, int[] result) {
        if (array.length != result.length) {
            throw new IllegalArgumentException("array.length != result.length.");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = lut[array[i]];
        }
    }

    public static void Reverse(int[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            int tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static void Reverse(long[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            long tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static void Reverse(float[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            float tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static void Reverse(double[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            double tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static void Reverse(byte[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            byte tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static void Reverse(short[] array, int first, int last) {
        int f = first;
        for (int l = last - 1; f < l; ++f, --l) {
            short tmp = array[f];
            array[f] = array[l];
            array[l] = tmp;
        }
    }

    public static byte[] DifferencesUnsigned(byte[] array1, byte[] array2) {
        byte[] result = ArrayNew.Same(array1);
        ArrayOperations.DifferencesUnsigned(array1, array2, result);
        return result;
    }

    public static void DifferencesUnsigned(byte[] array1, byte[] array2, byte[] result) {
        for (int x = 0; x < result.length; ++x) {
            result[x] = (byte)Math.abs((array1[x] & 0xFF) - (array2[x] & 0xFF));
        }
    }

    public static short[] DifferencesUnsigned(short[] array1, short[] array2) {
        short[] result = ArrayNew.Same(array1);
        ArrayOperations.DifferencesUnsigned(array1, array2, result);
        return result;
    }

    public static void DifferencesUnsigned(short[] array1, short[] array2, short[] result) {
        for (int x = 0; x < result.length; ++x) {
            result[x] = (short)Math.abs((array1[x] & 0xFFFF) - (array2[x] & 0xFFFF));
        }
    }

    public static int[] Differences(int[] array1, int[] array2) {
        int[] result = ArrayNew.Same(array1);
        ArrayOperations.Differences(array1, array2, result);
        return result;
    }

    public static void Differences(int[] array1, int[] array2, int[] result) {
        for (int x = 0; x < result.length; ++x) {
            result[x] = Math.abs(array1[x] - array2[x]);
        }
    }

    public static float[] Differences(float[] array1, float[] array2) {
        float[] result = ArrayNew.Same(array1);
        ArrayOperations.Differences(array1, array2, result);
        return result;
    }

    public static void Differences(float[] array1, float[] array2, float[] result) {
        for (int x = 0; x < result.length; ++x) {
            result[x] = Math.abs(array1[x] - array2[x]);
        }
    }

    public static double[] Differences(double[] array1, double[] array2) {
        double[] result = ArrayNew.Same(array1);
        ArrayOperations.Differences(array1, array2, result);
        return result;
    }

    public static void Differences(double[] array1, double[] array2, double[] result) {
        for (int x = 0; x < result.length; ++x) {
            result[x] = Math.abs(array1[x] - array2[x]);
        }
    }

    public static void Shift(byte[] arrayin, byte[] arrayout, int length, int shift, byte borderValue) {
        ArrayOperations.Shift(arrayin, 0, arrayout, 0, length, shift, borderValue);
    }

    public static void Shift(short[] arrayin, short[] arrayout, int length, int shift, short borderValue) {
        ArrayOperations.Shift(arrayin, 0, arrayout, 0, length, shift, borderValue);
    }

    public static void Shift(int[] arrayin, int[] arrayout, int length, int shift, int borderValue) {
        ArrayOperations.Shift(arrayin, 0, arrayout, 0, length, shift, borderValue);
    }

    public static void Shift(float[] arrayin, float[] arrayout, int length, int shift, float borderValue) {
        ArrayOperations.Shift(arrayin, 0, arrayout, 0, length, shift, borderValue);
    }

    public static void Shift(double[] arrayin, double[] arrayout, int length, int shift, double borderValue) {
        ArrayOperations.Shift(arrayin, 0, arrayout, 0, length, shift, borderValue);
    }

    public static void Shift(byte[] arrayin, int posin, byte[] arrayout, int posout, int length, int shift, byte borderValue) {
        if (shift == 0) {
            System.arraycopy(arrayin, posin, arrayout, posout, length);
        } else if (shift > 0) {
            Arrays.fill(arrayout, posout, posout + shift, borderValue);
            System.arraycopy(arrayin, posin, arrayout, posout + shift, length - shift);
        } else {
            Arrays.fill(arrayout, posout + length + shift, length, borderValue);
            System.arraycopy(arrayin, posin - shift, arrayout, posout, length + shift);
        }
    }

    public static void Shift(short[] arrayin, int posin, short[] arrayout, int posout, int length, int shift, short borderValue) {
        if (shift == 0) {
            System.arraycopy(arrayin, posin, arrayout, posout, length);
        } else if (shift > 0) {
            Arrays.fill(arrayout, posout, posout + shift, borderValue);
            System.arraycopy(arrayin, posin, arrayout, posout + shift, length - shift);
        } else {
            Arrays.fill(arrayout, posout + length + shift, length, borderValue);
            System.arraycopy(arrayin, posin - shift, arrayout, posout, length + shift);
        }
    }

    public static void Shift(int[] arrayin, int posin, int[] arrayout, int posout, int length, int shift, int borderValue) {
        if (shift == 0) {
            System.arraycopy(arrayin, posin, arrayout, posout, length);
        } else if (shift > 0) {
            Arrays.fill(arrayout, posout, posout + shift, borderValue);
            System.arraycopy(arrayin, posin, arrayout, posout + shift, length - shift);
        } else {
            Arrays.fill(arrayout, posout + length + shift, length, borderValue);
            System.arraycopy(arrayin, posin - shift, arrayout, posout, length + shift);
        }
    }

    public static void Shift(float[] arrayin, int posin, float[] arrayout, int posout, int length, int shift, float borderValue) {
        if (shift == 0) {
            System.arraycopy(arrayin, posin, arrayout, posout, length);
        } else if (shift > 0) {
            Arrays.fill(arrayout, posout, posout + shift, borderValue);
            System.arraycopy(arrayin, posin, arrayout, posout + shift, length - shift);
        } else {
            Arrays.fill(arrayout, posout + length + shift, length, borderValue);
            System.arraycopy(arrayin, posin - shift, arrayout, posout, length + shift);
        }
    }

    public static void Shift(double[] arrayin, int posin, double[] arrayout, int posout, int length, int shift, double borderValue) {
        if (shift == 0) {
            System.arraycopy(arrayin, posin, arrayout, posout, length);
        } else if (shift > 0) {
            Arrays.fill(arrayout, posout, posout + shift, borderValue);
            System.arraycopy(arrayin, posin, arrayout, posout + shift, length - shift);
        } else {
            Arrays.fill(arrayout, posout + length + shift, length, borderValue);
            System.arraycopy(arrayin, posin - shift, arrayout, posout, length + shift);
        }
    }

    public static void Shuffle(int[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            int value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(float[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            float value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(double[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            double value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(byte[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            byte value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(short[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            short value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(File[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            File value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static void Shuffle(Object[] array) {
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            int pos = random.nextInt(array.length);
            Object value = array[pos];
            array[pos] = array[i];
            array[i] = value;
        }
    }

    public static List<Coordinates> Contour(byte[] array, int width, int height, boolean EightConnex, int label, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if ((array[pos] & 0xFF) == label) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && (array[pos + -1] & 0xFF) != label || x < w1 && (array[pos + 1] & 0xFF) != label || 0 < y && (array[pos + p2] & 0xFF) != label || y < h1 && (array[pos + p6] & 0xFF) != label) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && (array[pos + p1] & 0xFF) != label || x < w1 && 0 < y && (array[pos + p3] & 0xFF) != label || x < w1 && y < h1 && (array[pos + p5] & 0xFF) != label || 0 < x && y < h1 && (array[pos + p7] & 0xFF) != label)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(short[] array, int width, int height, boolean EightConnex, int label, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if ((array[pos] & 0xFFFF) == label) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && (array[pos + -1] & 0xFFFF) != label || x < w1 && (array[pos + 1] & 0xFFFF) != label || 0 < y && (array[pos + p2] & 0xFFFF) != label || y < h1 && (array[pos + p6] & 0xFFFF) != label) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && (array[pos + p1] & 0xFFFF) != label || x < w1 && 0 < y && (array[pos + p3] & 0xFFFF) != label || x < w1 && y < h1 && (array[pos + p5] & 0xFFFF) != label || 0 < x && y < h1 && (array[pos + p7] & 0xFFFF) != label)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(int[] array, int width, int height, boolean EightConnex, int label, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if (array[pos] == label) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && array[pos + -1] != label || x < w1 && array[pos + 1] != label || 0 < y && array[pos + p2] != label || y < h1 && array[pos + p6] != label) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && array[pos + p1] != label || x < w1 && 0 < y && array[pos + p3] != label || x < w1 && y < h1 && array[pos + p5] != label || 0 < x && y < h1 && array[pos + p7] != label)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(byte[] array, int width, int height, boolean EightConnex, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if ((array[pos] & 0xFF) != 0) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && (array[pos + -1] & 0xFF) == 0 || x < w1 && (array[pos + 1] & 0xFF) == 0 || 0 < y && (array[pos + p2] & 0xFF) == 0 || y < h1 && (array[pos + p6] & 0xFF) == 0) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && (array[pos + p1] & 0xFF) == 0 || x < w1 && 0 < y && (array[pos + p3] & 0xFF) == 0 || x < w1 && y < h1 && (array[pos + p5] & 0xFF) == 0 || 0 < x && y < h1 && (array[pos + p7] & 0xFF) == 0)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(short[] array, int width, int height, boolean EightConnex, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if ((array[pos] & 0xFFFF) != 0) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && (array[pos + -1] & 0xFFFF) == 0 || x < w1 && (array[pos + 1] & 0xFFFF) == 0 || 0 < y && (array[pos + p2] & 0xFFFF) == 0 || y < h1 && (array[pos + p6] & 0xFFFF) == 0) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && (array[pos + p1] & 0xFFFF) == 0 || x < w1 && 0 < y && (array[pos + p3] & 0xFFFF) == 0 || x < w1 && y < h1 && (array[pos + p5] & 0xFFFF) == 0 || 0 < x && y < h1 && (array[pos + p7] & 0xFFFF) == 0)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(int[] array, int width, int height, boolean EightConnex, int minx, int miny, int maxx, int maxy) {
        int w1 = width - 1;
        int h1 = height - 1;
        int p0 = -1;
        int p1 = -width - 1;
        int p2 = -width;
        int p3 = -width + 1;
        boolean p4 = true;
        int p5 = width + 1;
        int p6 = width;
        int p7 = width - 1;
        LinkedList<Coordinates> result = new LinkedList<Coordinates>();
        for (int y = miny; y <= maxy; ++y) {
            int x = minx;
            int pos = y * width + x;
            while (x <= maxx) {
                if (array[pos] != 0) {
                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (0 < x && array[pos + -1] == 0 || x < w1 && array[pos + 1] == 0 || 0 < y && array[pos + p2] == 0 || y < h1 && array[pos + p6] == 0) {
                        result.add(new Coordinates(x, y, 0, pos));
                    } else if (!EightConnex && (0 < x && 0 < y && array[pos + p1] == 0 || x < w1 && 0 < y && array[pos + p3] == 0 || x < w1 && y < h1 && array[pos + p5] == 0 || 0 < x && y < h1 && array[pos + p7] == 0)) {
                        result.add(new Coordinates(x, y, 0, pos));
                    }
                }
                ++x;
                ++pos;
            }
        }
        return result;
    }
}

