/*
 * Decompiled with CFR 0.152.
 */
package dv;

public class DV {
    public final int Type;
    public static final int TYPE_INT_GRAY = 32;
    public static final int TYPE_BYTE_GRAY = 8;
    public static final int TYPE_SHORT_GRAY = 16;
    public static final int TYPE_FLOAT_GRAY = -32;
    public static final int TYPE_DOUBLE_GRAY = 64;
    public final int SizeX;
    public final int SizeY;
    public final int SizeZ;
    public final int Channel;
    public final int LayerSize;
    public final int Length;
    private Object[] Data = null;

    public DV(int SizeX, int SizeY, int SizeZ, int Channel2, int Type2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0 || Channel2 <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + ", " + SizeY + ", " + SizeZ + ", " + Channel2 + ".");
        }
        long length = SizeX * SizeY * SizeZ;
        if (Integer.MAX_VALUE < length) {
            throw new IllegalArgumentException("Too big dimensions: Integer.MAX_VALUE < Length.");
        }
        this.Type = Type2;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Channel2;
        this.LayerSize = SizeX * SizeY;
        this.Length = this.LayerSize * SizeZ;
        this.Data = new Object[Channel2];
        switch (Type2) {
            case 32: {
                for (int c = 0; c < Channel2; ++c) {
                    this.Data[c] = new int[this.Length];
                }
                break;
            }
            case 8: {
                for (int c = 0; c < Channel2; ++c) {
                    this.Data[c] = new byte[this.Length];
                }
                break;
            }
            case 16: {
                for (int c = 0; c < Channel2; ++c) {
                    this.Data[c] = new short[this.Length];
                }
                break;
            }
            case -32: {
                for (int c = 0; c < Channel2; ++c) {
                    this.Data[c] = new float[this.Length];
                }
                break;
            }
            case 64: {
                for (int c = 0; c < Channel2; ++c) {
                    this.Data[c] = new double[this.Length];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DV type.");
            }
        }
    }

    public DV(int SizeX, int SizeY, int SizeZ, int[][] Data) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != Data[0].length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data[0].length");
        }
        this.Data = new Object[Data.length];
        System.arraycopy(Data, 0, this.Data, 0, Data.length);
        this.Type = 32;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Data.length;
        this.LayerSize = SizeX * SizeY;
        this.Length = Data[0].length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, byte[][] Data) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != Data[0].length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data[0].length");
        }
        this.Data = new Object[Data.length];
        System.arraycopy(Data, 0, this.Data, 0, Data.length);
        this.Type = 8;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Data.length;
        this.LayerSize = SizeX * SizeY;
        this.Length = Data[0].length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, short[][] Data) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != Data[0].length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data[0].length");
        }
        this.Data = new Object[Data.length];
        System.arraycopy(Data, 0, this.Data, 0, Data.length);
        this.Type = 16;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Data.length;
        this.LayerSize = SizeX * SizeY;
        this.Length = Data[0].length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, float[][] Data) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != Data[0].length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data[0].length");
        }
        this.Data = new Object[Data.length];
        System.arraycopy(Data, 0, this.Data, 0, Data.length);
        this.Type = -32;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Data.length;
        this.LayerSize = SizeX * SizeY;
        this.Length = Data[0].length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, double[][] Data) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != Data[0].length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data[0].length");
        }
        this.Data = new Object[Data.length];
        System.arraycopy(Data, 0, this.Data, 0, Data.length);
        this.Type = 64;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = Data.length;
        this.LayerSize = SizeX * SizeY;
        this.Length = Data[0].length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, int[] DataBuffer2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != DataBuffer2.length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data.length");
        }
        this.Data = new Object[1];
        this.Data[0] = DataBuffer2;
        this.Type = 32;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = 1;
        this.LayerSize = this.Length = this.Data.length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, byte[] DataBuffer2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != DataBuffer2.length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data.length");
        }
        this.Data = new Object[1];
        this.Data[0] = DataBuffer2;
        this.Type = 8;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = 1;
        this.LayerSize = this.Length = this.Data.length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, short[] DataBuffer2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != DataBuffer2.length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data.length");
        }
        this.Data = new Object[1];
        this.Data[0] = DataBuffer2;
        this.Type = 16;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = 1;
        this.LayerSize = this.Length = this.Data.length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, double[] DataBuffer2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != DataBuffer2.length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data.length");
        }
        this.Data = new Object[1];
        this.Data[0] = DataBuffer2;
        this.Type = 64;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = 1;
        this.LayerSize = this.Length = this.Data.length;
    }

    public DV(int SizeX, int SizeY, int SizeZ, float[] DataBuffer2) {
        if (SizeX <= 0 || SizeY <= 0 || SizeZ <= 0) {
            throw new IllegalArgumentException("Incorrect dimensions: " + SizeX + "," + SizeY + "," + SizeZ);
        }
        if (SizeX * SizeY * SizeZ != DataBuffer2.length) {
            throw new IllegalArgumentException("SizeX*SizeY*SizeZ != Data.length");
        }
        this.Data = new Object[1];
        this.Data[0] = DataBuffer2;
        this.Type = -32;
        this.SizeX = SizeX;
        this.SizeY = SizeY;
        this.SizeZ = SizeZ;
        this.Channel = 1;
        this.LayerSize = this.Length = this.Data.length;
    }

    public synchronized void Kill() {
        for (int i = 0; i < this.Data.length; ++i) {
            this.Data[i] = null;
        }
        this.Data = null;
    }

    public Object[] getDataBuffer() {
        return this.Data;
    }

    public int[] getDataBufferInt(int channel) {
        return (int[])this.Data[channel];
    }

    public byte[] getDataBufferByte(int channel) {
        return (byte[])this.Data[channel];
    }

    public short[] getDataBufferShort(int channel) {
        return (short[])this.Data[channel];
    }

    public float[] getDataBufferFloat(int channel) {
        return (float[])this.Data[channel];
    }

    public double[] getDataBufferDouble(int channel) {
        return (double[])this.Data[channel];
    }

    public int getVoxel(int x, int y, int z, int channel) {
        switch (this.Type) {
            case 8: {
                return ((byte[])this.Data[channel])[this.Position(x, y, z)] & 0xFF;
            }
            case 32: {
                return ((int[])this.Data[channel])[this.Position(x, y, z)];
            }
            case 16: {
                return ((short[])this.Data[channel])[this.Position(x, y, z)] & 0xFFFF;
            }
        }
        throw new IllegalArgumentException("This method does not support (yet) this DV type.");
    }

    public double getVoxelReal(int x, int y, int z, int channel) {
        switch (this.Type) {
            case -32: {
                return ((float[])this.Data[channel])[this.Position(x, y, z)];
            }
            case 64: {
                return ((double[])this.Data[channel])[this.Position(x, y, z)];
            }
        }
        throw new IllegalArgumentException("This method does not support (yet) this DV type.");
    }

    public int getVoxelInt(int x, int y, int z, int channel) {
        return ((int[])this.Data[channel])[this.Position(x, y, z)];
    }

    public byte getVoxelByte(int x, int y, int z, int channel) {
        return ((byte[])this.Data[channel])[this.Position(x, y, z)];
    }

    public short getVoxelShort(int x, int y, int z, int channel) {
        return ((short[])this.Data[channel])[this.Position(x, y, z)];
    }

    public float getVoxelFloat(int x, int y, int z, int channel) {
        return ((float[])this.Data[channel])[this.Position(x, y, z)];
    }

    public double getVoxelDouble(int x, int y, int z, int channel) {
        return ((double[])this.Data[channel])[this.Position(x, y, z)];
    }

    public int getVoxel(int channel, int pos) {
        switch (this.Type) {
            case 8: {
                return ((byte[])this.Data[channel])[pos] & 0xFF;
            }
            case 32: {
                return ((int[])this.Data[channel])[pos];
            }
            case 16: {
                return ((short[])this.Data[channel])[pos] & 0xFFFF;
            }
        }
        throw new IllegalArgumentException("This method does not support (yet) this DV type.");
    }

    public double getVoxelReal(int channel, int pos) {
        switch (this.Type) {
            case -32: {
                return ((float[])this.Data[channel])[pos];
            }
            case 64: {
                return ((double[])this.Data[channel])[pos];
            }
        }
        throw new IllegalArgumentException("This method does not support (yet) this DV type.");
    }

    public byte getVoxelByte(int channel, int pos) {
        return ((byte[])this.Data[channel])[pos];
    }

    public short getVoxelShort(int channel, int pos) {
        return ((short[])this.Data[channel])[pos];
    }

    public int getVoxelInt(int channel, int pos) {
        return ((int[])this.Data[channel])[pos];
    }

    public float getVoxelFloat(int channel, int pos) {
        return ((float[])this.Data[channel])[pos];
    }

    public double getVoxelDouble(int channel, int pos) {
        return ((double[])this.Data[channel])[pos];
    }

    public void setVoxelUniversal(int x, int y, int z, int channel, int v) {
        switch (this.Type) {
            case 8: {
                ((byte[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = (byte)v;
                break;
            }
            case 32: {
                ((int[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
                break;
            }
            case 16: {
                ((short[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = (short)v;
                break;
            }
            default: {
                throw new IllegalArgumentException("This method does not support (yet) this DV type.");
            }
        }
    }

    public void setVoxelUniversal(int x, int y, int z, int channel, double v) {
        switch (this.Type) {
            case -32: {
                ((float[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = (float)v;
                break;
            }
            case 64: {
                ((double[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
                break;
            }
            default: {
                throw new IllegalArgumentException("This method does not support (yet) this DV type.");
            }
        }
    }

    public void setVoxel(int x, int y, int z, int channel, int v) {
        ((int[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
    }

    public void setVoxel(int x, int y, int z, int channel, byte v) {
        ((byte[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
    }

    public void setVoxel(int x, int y, int z, int channel, short v) {
        ((short[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
    }

    public void setVoxel(int x, int y, int z, int channel, double v) {
        ((double[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
    }

    public void setVoxel(int x, int y, int z, int channel, float v) {
        ((float[])this.Data[channel])[this.Position((int)x, (int)y, (int)z)] = v;
    }

    public int Position(int x, int y, int z) {
        return z * this.LayerSize + y * this.SizeX + x;
    }
}

