/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayComparator;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import utils.strings.StringToolsImageDV;

public class DvComparator {
    public static final String EQUALS = "==";
    public static final String DIFFERENT = "!=";
    public static final String SUP = ">";
    public static final String SUPOREQUAL = ">=";
    public static final String INF = "<";
    public static final String INFOREQUAL = "<=";

    private static String MessageError(DV source, String operation, Object ... objects) {
        if (objects.length != 4) {
            throw new IllegalArgumentException("Bug, must not occured:  objects.length != 4.");
        }
        StringBuilder message = new StringBuilder(13);
        message.append("Configuration not supported: Compare(").append(StringToolsImageDV.NameOfType(source.Type)).append(",");
        switch (operation) {
            case "==": {
                message.append(" == ");
                break;
            }
            case "!=": {
                message.append(" != ");
                break;
            }
            case ">": {
                message.append(" > ");
                break;
            }
            case ">=": {
                message.append(" >= ");
                break;
            }
            case "<": {
                message.append(" < ");
                break;
            }
            case "<=": {
                message.append(" <= ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation: " + operation);
            }
        }
        message.append(", ");
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof DV) {
                message.append(StringToolsImageDV.NameOfType(((DV)objects[i]).Type));
                message.append(", ");
                continue;
            }
            if (objects[i] instanceof Integer) {
                message.append("int, ");
                continue;
            }
            throw new IllegalArgumentException("Bug:  parameter " + i + " is not neither DV, neither Integer.");
        }
        message.setCharAt(message.length() - 2, ')');
        message.setCharAt(message.length() - 1, ';');
        return message.toString();
    }

    public static DV Compare(DV source, String operation, DV comparison, DV thenvalues, DV elsevalues) {
        DV result = DvNew.Same(source);
        DvComparator.Compare(source, operation, comparison, thenvalues, elsevalues, result);
        return result;
    }

    public static void Compare(DV source, String operation, DV comparison, DV thenvalues, DV elsevalues, DV result) {
        if (!DvTools.areDimensionsEqual(source, comparison)) {
            throw new IllegalArgumentException("source and comparison DVs must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues DVs must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, elsevalues)) {
            throw new IllegalArgumentException("source and elsevalues DVs must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result DVs must have identic dimensions.");
        }
        block0 : switch (source.Type) {
            case 8: {
                switch (comparison.Type) {
                    case 8: {
                        if (thenvalues.Type != 8 || elsevalues.Type != 8 || result.Type != 8) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison.getDataBufferByte(c), thenvalues.getDataBufferByte(c), elsevalues.getDataBufferByte(c), result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    case 16: {
                        if (thenvalues.Type != 8 || elsevalues.Type != 16 || result.Type != 16) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison.getDataBufferShort(c), thenvalues.getDataBufferByte(c), elsevalues.getDataBufferShort(c), result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 16: {
                if (comparison.Type != 16 || thenvalues.Type != 16 || elsevalues.Type != 16 || result.Type != 16) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison.getDataBufferShort(c), thenvalues.getDataBufferShort(c), elsevalues.getDataBufferShort(c), result.getDataBufferShort(c));
                }
                break;
            }
            case 32: {
                if (comparison.Type != 32 || thenvalues.Type != 32 || elsevalues.Type != 32 || result.Type != 32) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayComparator.Compare(source.getDataBufferInt(c), operation, comparison.getDataBufferInt(c), thenvalues.getDataBufferInt(c), elsevalues.getDataBufferInt(c), result.getDataBufferInt(c));
                }
                break;
            }
            case -32: {
                if (comparison.Type != -32 || thenvalues.Type != -32 || elsevalues.Type != -32 || result.Type != -32) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayComparator.Compare(source.getDataBufferFloat(c), operation, comparison.getDataBufferFloat(c), thenvalues.getDataBufferFloat(c), elsevalues.getDataBufferFloat(c), result.getDataBufferFloat(c));
                }
                break;
            }
            case 64: {
                if (comparison.Type != 64 || thenvalues.Type != 64 || elsevalues.Type != 64 || result.Type != 64) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayComparator.Compare(source.getDataBufferDouble(c), operation, comparison.getDataBufferDouble(c), thenvalues.getDataBufferDouble(c), elsevalues.getDataBufferDouble(c), result.getDataBufferDouble(c));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static DV Compare(DV source, String operation, int comparison, DV thenvalues, int elsevalues) {
        int max = 0;
        switch (thenvalues.Type) {
            case 8: {
                max = 255;
                break;
            }
            case 16: {
                max = 65535;
                break;
            }
            case 32: {
                max = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot not generate result DV, thenvalues type not supported (yet).");
            }
        }
        if (max < elsevalues) {
            max = elsevalues;
        }
        DV result = null;
        switch (max) {
            case 255: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 8);
                break;
            }
            case 65535: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 16);
                break;
            }
            case 0x7FFFFFFF: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 32);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot generate result DV, thenvalues type or ElseValues not supported (yet).");
            }
        }
        DvComparator.Compare(source, operation, comparison, thenvalues, elsevalues, result);
        return result;
    }

    public static void Compare(DV source, String operation, int comparison, DV thenvalues, int elsevalues, DV result) {
        if (!DvTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues DV must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result DV must have identic dimensions.");
        }
        block0 : switch (source.Type) {
            case 8: {
                switch (thenvalues.Type) {
                    case 8: {
                        if (result.Type != 8) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, thenvalues.getDataBufferByte(c), (byte)elsevalues, result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    case 16: {
                        if (result.Type != 16) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, thenvalues.getDataBufferShort(c), (short)elsevalues, result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    case 32: {
                        if (result.Type != 32) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, thenvalues.getDataBufferInt(c), elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 16: {
                switch (thenvalues.Type) {
                    case 16: {
                        if (result.Type != 16) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison, thenvalues.getDataBufferShort(c), (short)elsevalues, result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 32: {
                switch (thenvalues.Type) {
                    case 32: {
                        if (result.Type != 32) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.Compare(source.getDataBufferInt(c), operation, comparison, thenvalues.getDataBufferInt(c), elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static DV Compare(DV source, String operation, DV comparison, DV thenvalues, int elsevalues) {
        int max = 0;
        switch (thenvalues.Type) {
            case 8: {
                max = 255;
                break;
            }
            case 16: {
                max = 65535;
                break;
            }
            case 32: {
                max = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot not generate result DV, thenvalues type not supported (yet).");
            }
        }
        if (max < elsevalues) {
            max = elsevalues;
        }
        DV result = null;
        switch (max) {
            case 255: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 8);
                break;
            }
            case 65535: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 16);
                break;
            }
            case 0x7FFFFFFF: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 32);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot generate result DV, thenvalues type or ElseValues not supported (yet).");
            }
        }
        DvComparator.Compare(source, operation, comparison, thenvalues, elsevalues, result);
        return result;
    }

    public static void Compare(DV source, String operation, DV comparison, DV thenvalues, int elsevalues, DV result) {
        if (!DvTools.areDimensionsEqual(source, comparison)) {
            throw new IllegalArgumentException("source and comparison DV must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, thenvalues)) {
            throw new IllegalArgumentException("source and thenvalues DV must have identic dimensions.");
        }
        if (!DvTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result DV must have identic dimensions.");
        }
        block0 : switch (source.Type) {
            case 8: {
                if (comparison.Type != 8) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                switch (thenvalues.Type) {
                    case 8: {
                        if (result.Type != 8) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison.getDataBufferByte(c), thenvalues.getDataBufferByte(c), (byte)elsevalues, result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 16: {
                if (comparison.Type != 16) {
                    throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                }
                switch (thenvalues.Type) {
                    case 16: {
                        if (result.Type != 16) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison.getDataBufferShort(c), thenvalues.getDataBufferShort(c), (short)elsevalues, result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 32: {
                switch (comparison.Type) {
                    case 8: {
                        if (thenvalues.Type != 32 || result.Type != 32) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferInt(c), operation, comparison.getDataBufferByte(c), thenvalues.getDataBufferInt(c), elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    case 32: {
                        if (thenvalues.Type != 32 || result.Type != 32) {
                            throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                        }
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.Compare(source.getDataBufferInt(c), operation, comparison.getDataBufferInt(c), thenvalues.getDataBufferInt(c), elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }

    public static DV Compare(DV source, String operation, int comparison, int thenvalues, int elsevalues) {
        int max = thenvalues;
        if (max < elsevalues) {
            max = elsevalues;
        }
        DV result = null;
        switch (max) {
            case 255: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 8);
                break;
            }
            case 65535: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 16);
                break;
            }
            default: {
                result = new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 32);
            }
        }
        DvComparator.Compare(source, operation, comparison, thenvalues, elsevalues, result);
        return result;
    }

    public static void Compare(DV source, String operation, int comparison, int thenvalues, int elsevalues, DV result) {
        if (!DvTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("source and result DV must have identic dimensions.");
        }
        block0 : switch (source.Type) {
            case 8: {
                switch (result.Type) {
                    case 8: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, (byte)thenvalues, (byte)elsevalues, result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    case 16: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, (short)thenvalues, (short)elsevalues, result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    case 32: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferByte(c), operation, comparison, thenvalues, elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 16: {
                switch (result.Type) {
                    case 8: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison, (byte)thenvalues, (byte)elsevalues, result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    case 16: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison, (short)thenvalues, (short)elsevalues, result.getDataBufferShort(c));
                        }
                        break block0;
                    }
                    case 32: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.CompareUnsigned(source.getDataBufferShort(c), operation, comparison, thenvalues, elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            case 32: {
                switch (result.Type) {
                    case 8: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.Compare(source.getDataBufferInt(c), operation, comparison, (byte)thenvalues, (byte)elsevalues, result.getDataBufferByte(c));
                        }
                        break block0;
                    }
                    case 32: {
                        for (int c = 0; c < source.Channel; ++c) {
                            ArrayComparator.Compare(source.getDataBufferInt(c), operation, comparison, thenvalues, elsevalues, result.getDataBufferInt(c));
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(DvComparator.MessageError(source, operation, comparison, thenvalues, elsevalues, result));
            }
        }
    }
}

