/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayFeatures;
import dv.DV;

public final class DvFeatures {
    public long Integral = -1L;
    public double IntegralDouble = -1.0;
    public long IntegralAbs = -1L;
    public double IntegralAbsDouble = -1.0;
    public int Size = 0;
    public double Average = 0.0;
    public double Variance = 0.0;
    public double StandardDeviation = 0.0;
    public double Kurtosis = 0.0;
    public double Skewness = 0.0;
    public double Contrast = 0.0;
    public double Michelson = 0.0;
    public double Minimum = 0.0;
    public double Maximum = 0.0;
    public int MinimumIndex = 0;
    public int MaximumIndex = 0;
    public double Rank01 = 0.0;
    public double Rank025 = 0.0;
    public double Rank05 = 0.0;
    public double Rank10 = 0.0;
    public double Rank25 = 0.0;
    public double Rank50 = 0.0;
    public double Rank75 = 0.0;
    public double Rank90 = 0.0;
    public double Rank95 = 0.0;
    public double Rank975 = 0.0;
    public double Rank99 = 0.0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public int Counter(DV dv, int channel, int ForbiddenValue) {
        this.Size = 0;
        switch (dv.Type) {
            case 8: {
                this.Size = this.AF.Counter(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.Size = this.AF.Counter(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.Size = this.AF.Counter(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Size;
    }

    public int Counter(DV dv, int channel, double ForbiddenValue) {
        this.Size = 0;
        switch (dv.Type) {
            case 64: {
                this.Size = this.AF.Counter(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            case -32: {
                this.Size = this.AF.Counter(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Size;
    }

    public long Integral(DV dv, int channel) {
        this.Size = 0;
        this.Integral = 0;
        this.IntegralDouble = 0.0;
        switch (dv.Type) {
            case 8: {
                this.Integral = this.AF.Integral(dv.getDataBufferByte(channel));
                break;
            }
            case 16: {
                this.Integral = this.AF.Integral(dv.getDataBufferShort(channel));
                break;
            }
            case 32: {
                this.Integral = this.AF.Integral(dv.getDataBufferInt(channel));
                break;
            }
            case 64: {
                this.IntegralDouble = this.AF.Integral(dv.getDataBufferDouble(channel));
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = dv.Length;
        return this.Integral;
    }

    public long Integral(DV dv, int channel, int ForbiddenValue) {
        this.Size = 0;
        this.Integral = 0;
        this.IntegralDouble = 0.0;
        switch (dv.Type) {
            case 8: {
                this.Integral = this.AF.Integral(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.Integral = this.AF.Integral(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.Integral = this.AF.Integral(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Integral;
    }

    public double Integral(DV dv, int channel, double ForbiddenValue) {
        this.Size = 0;
        this.Integral = 0;
        this.IntegralDouble = this.Integral;
        switch (dv.Type) {
            case -32: {
                this.IntegralDouble = this.AF.Integral(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            case 64: {
                this.IntegralDouble = this.AF.Integral(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.IntegralDouble;
    }

    public double Average(DV dv, int channel) {
        switch (dv.Type) {
            case 8: {
                this.Average = this.AF.Average(dv.getDataBufferByte(channel));
                this.Integral = this.AF.Integral();
                break;
            }
            case 16: {
                this.Average = this.AF.Average(dv.getDataBufferShort(channel));
                this.Integral = this.AF.Integral();
                break;
            }
            case 32: {
                this.Average = this.AF.Average(dv.getDataBufferInt(channel));
                this.Integral = this.AF.Integral();
                break;
            }
            case -32: {
                this.Average = this.AF.Average(dv.getDataBufferFloat(channel));
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            case 64: {
                this.Average = this.AF.Average(dv.getDataBufferDouble(channel));
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(DV dv, int channel, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.Average = this.AF.Average(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                this.Integral = this.AF.Integral();
                break;
            }
            case 16: {
                this.Average = this.AF.Average(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                this.Integral = this.AF.Integral();
                break;
            }
            case 32: {
                this.Average = this.AF.Average(dv.getDataBufferInt(channel), ForbiddenValue);
                this.Integral = this.AF.Integral();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(DV dv, int channel, double ForbiddenValue) {
        switch (dv.Type) {
            case -32: {
                this.Average = this.AF.Average(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            case 64: {
                this.Average = this.AF.Average(dv.getDataBufferDouble(channel), ForbiddenValue);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(DV dv, int channel, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        switch (dv.Type) {
            case 8: {
                this.Average = this.AF.Average(dv.getDataBufferByte(channel), dv.SizeX, dv.SizeY, dv.SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            case 16: {
                this.Average = this.AF.Average(dv.getDataBufferShort(channel), dv.SizeX, dv.SizeY, dv.SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            case 32: {
                this.Average = this.AF.Average(dv.getDataBufferInt(channel), dv.SizeX, dv.SizeY, dv.SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            case -32: {
                this.Average = this.AF.Average(dv.getDataBufferFloat(channel), dv.SizeX, dv.SizeY, dv.SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            case 64: {
                this.Average = this.AF.Average(dv.getDataBufferDouble(channel), dv.SizeX, dv.SizeY, dv.SizeZ, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(DV dv, int channel, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        switch (dv.Type) {
            case 8: {
                this.Average = this.AF.Average(dv.getDataBufferByte(channel), dv.SizeX, dv.SizeY, dv.SizeZ, (byte)ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            case 16: {
                this.Average = this.AF.Average(dv.getDataBufferShort(channel), dv.SizeX, dv.SizeY, dv.SizeZ, (short)ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            case 32: {
                this.Average = this.AF.Average(dv.getDataBufferInt(channel), dv.SizeX, dv.SizeY, dv.SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.Integral = this.AF.Integral();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public double Average(DV dv, int channel, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        switch (dv.Type) {
            case -32: {
                this.Average = this.AF.Average(dv.getDataBufferFloat(channel), dv.SizeX, dv.SizeY, dv.SizeZ, (float)ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            case 64: {
                this.Average = this.AF.Average(dv.getDataBufferDouble(channel), dv.SizeX, dv.SizeY, dv.SizeZ, ForbiddenValue, FromX, EndX, FromY, EndY, FromZ, EndZ);
                this.IntegralDouble = this.AF.IntegralDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        return this.Average;
    }

    public void Moments(DV dv, int channel) {
        switch (dv.Type) {
            case 8: {
                this.AF.Moments(dv.getDataBufferByte(channel));
                break;
            }
            case 16: {
                this.AF.Moments(dv.getDataBufferShort(channel));
                break;
            }
            case 32: {
                this.AF.Moments(dv.getDataBufferInt(channel));
                break;
            }
            case -32: {
                this.AF.Moments(dv.getDataBufferFloat(channel));
                break;
            }
            case 64: {
                this.AF.Moments(dv.getDataBufferDouble(channel));
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        this.Integral = this.AF.Integral();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Moments(DV dv, int channel, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.AF.Moments(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.AF.Moments(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.AF.Moments(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Integral = this.AF.Integral();
        this.Size = this.AF.Size();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Moments(DV dv, int channel, double ForbiddenValue) {
        switch (dv.Type) {
            case -32: {
                this.AF.Moments(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            case 64: {
                this.AF.Moments(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.IntegralDouble = this.AF.IntegralDouble();
        this.Size = this.AF.Size();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void MomentsParallelized(DV dv, int channel, int nbCPU) {
        switch (dv.Type) {
            case 8: {
                this.AF.MomentsParallelized(dv.getDataBufferByte(channel), nbCPU);
                break;
            }
            case 16: {
                this.AF.MomentsParallelized(dv.getDataBufferShort(channel), nbCPU);
                break;
            }
            case 32: {
                this.AF.MomentsParallelized(dv.getDataBufferInt(channel), nbCPU);
                break;
            }
            case -32: {
                this.AF.MomentsParallelized(dv.getDataBufferFloat(channel), nbCPU);
                break;
            }
            case 64: {
                this.AF.MomentsParallelized(dv.getDataBufferDouble(channel), nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Size = this.AF.Size();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void MomentsParallelized(DV dv, int channel, int ForbiddenValue, int nbCPU) {
        switch (dv.Type) {
            case 8: {
                this.AF.MomentsParallelized(dv.getDataBufferByte(channel), (byte)ForbiddenValue, nbCPU);
                break;
            }
            case 16: {
                this.AF.MomentsParallelized(dv.getDataBufferShort(channel), (short)ForbiddenValue, nbCPU);
                break;
            }
            case 32: {
                this.AF.MomentsParallelized(dv.getDataBufferInt(channel), ForbiddenValue, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Integral = this.AF.Integral();
        this.Size = this.AF.Size();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void MomentsParallelized(DV dv, int channel, double ForbiddenValue, int nbCPU) {
        switch (dv.Type) {
            case -32: {
                this.AF.MomentsParallelized(dv.getDataBufferFloat(channel), (float)ForbiddenValue, nbCPU);
                break;
            }
            case 64: {
                this.AF.MomentsParallelized(dv.getDataBufferDouble(channel), ForbiddenValue, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.IntegralDouble = this.AF.IntegralDouble();
        this.Size = this.AF.Size();
        this.Average = this.AF.Average();
        this.Variance = this.AF.Variance();
        this.StandardDeviation = this.AF.StandardDeviation();
        this.Skewness = this.AF.Skewness();
        this.Kurtosis = this.AF.Kurtosis();
    }

    public void Ranks(DV dv, int channel) {
        switch (dv.Type) {
            case 8: {
                this.AF.Ranks(dv.getDataBufferByte(channel));
                break;
            }
            case 16: {
                this.AF.Ranks(dv.getDataBufferShort(channel));
                break;
            }
            case 32: {
                this.AF.Ranks(dv.getDataBufferInt(channel));
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Minimum = this.AF.Minimum();
        this.MinimumIndex = this.AF.MinimumIndex();
        this.Rank01 = this.AF.Rank01();
        this.Rank025 = this.AF.Rank025();
        this.Rank05 = this.AF.Rank05();
        this.Rank10 = this.AF.Rank10();
        this.Rank25 = this.AF.Rank25();
        this.Rank50 = this.AF.Rank50();
        this.Rank75 = this.AF.Rank75();
        this.Rank90 = this.AF.Rank90();
        this.Rank95 = this.AF.Rank95();
        this.Rank975 = this.AF.Rank975();
        this.Rank99 = this.AF.Rank99();
        this.Maximum = this.AF.Maximum();
        this.MaximumIndex = this.AF.MaximumIndex();
    }

    public void Ranks(DV dv, int channel, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.AF.Ranks(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.AF.Ranks(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.AF.Ranks(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Minimum = this.AF.Minimum();
        this.MinimumIndex = this.AF.MinimumIndex();
        this.Rank01 = this.AF.Rank01();
        this.Rank025 = this.AF.Rank025();
        this.Rank05 = this.AF.Rank05();
        this.Rank10 = this.AF.Rank10();
        this.Rank25 = this.AF.Rank25();
        this.Rank50 = this.AF.Rank50();
        this.Rank75 = this.AF.Rank75();
        this.Rank90 = this.AF.Rank90();
        this.Rank95 = this.AF.Rank95();
        this.Rank975 = this.AF.Rank975();
        this.Rank99 = this.AF.Rank99();
        this.Maximum = this.AF.Maximum();
        this.MaximumIndex = this.AF.MaximumIndex();
    }

    public void Ranks(DV dv, int channel, double ForbiddenValue) {
        switch (dv.Type) {
            case 64: {
                this.AF.Ranks(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            case -32: {
                this.AF.Ranks(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.Minimum = this.AF.Minimum();
        this.MinimumIndex = this.AF.MinimumIndex();
        this.Rank01 = this.AF.Rank01();
        this.Rank025 = this.AF.Rank025();
        this.Rank05 = this.AF.Rank05();
        this.Rank10 = this.AF.Rank10();
        this.Rank25 = this.AF.Rank25();
        this.Rank50 = this.AF.Rank50();
        this.Rank75 = this.AF.Rank75();
        this.Rank90 = this.AF.Rank90();
        this.Rank95 = this.AF.Rank95();
        this.Rank975 = this.AF.Rank975();
        this.Rank99 = this.AF.Rank99();
        this.Maximum = this.AF.Maximum();
        this.MaximumIndex = this.AF.MaximumIndex();
    }

    public double Minimum(DV dv, int channel) {
        switch (dv.Type) {
            case 8: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferByte(channel));
                break;
            }
            case 16: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferShort(channel));
                break;
            }
            case 32: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferInt(channel));
                break;
            }
            case -32: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferFloat(channel));
                break;
            }
            case 64: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferDouble(channel));
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.MinimumIndex = this.AF.MinimumIndex();
        return this.Minimum;
    }

    public double Maximum(DV dv, int channel) {
        switch (dv.Type) {
            case 8: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferByte(channel));
                break;
            }
            case 16: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferShort(channel));
                break;
            }
            case 32: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferInt(channel));
                break;
            }
            case -32: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferFloat(channel));
                break;
            }
            case 64: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferDouble(channel));
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Minimum(DV dv, int channel, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Minimum;
    }

    public double Minimum(DV dv, int channel, double ForbiddenValue) {
        switch (dv.Type) {
            case 64: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            case -32: {
                this.Minimum = this.AF.Minimum(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Minimum;
    }

    public double Maximum(DV dv, int channel, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferByte(channel), (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferShort(channel), (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferInt(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Maximum(DV dv, int channel, double ForbiddenValue) {
        switch (dv.Type) {
            case -32: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferFloat(channel), (float)ForbiddenValue);
                break;
            }
            case 64: {
                this.Maximum = this.AF.Maximum(dv.getDataBufferDouble(channel), ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.MaximumIndex = this.AF.MaximumIndex();
        return this.Maximum;
    }

    public double Contrast(DV dv, int channel) {
        this.Contrast = (this.Maximum(dv, channel) - this.Minimum(dv, channel)) / this.Average(dv, channel);
        return this.Contrast;
    }

    public double Michelson(DV dv, int channel) {
        double min = this.Minimum(dv, channel);
        double max = this.Maximum(dv, channel);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(DV dv, int channel, int ranksup) {
        switch (dv.Type) {
            case 8: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferByte(channel), ranksup);
                break;
            }
            case 16: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferShort(channel), ranksup);
                break;
            }
            case 32: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferInt(channel), ranksup);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Michelson;
    }

    public double Contrast(DV dv, int channel, int ForbiddenValue) {
        this.Contrast = (this.Maximum(dv, channel, ForbiddenValue) - this.Minimum(dv, channel, ForbiddenValue)) / this.Average(dv, channel, ForbiddenValue);
        return this.Contrast;
    }

    public double Contrast(DV dv, int channel, double ForbiddenValue) {
        this.Contrast = (this.Maximum(dv, channel, ForbiddenValue) - this.Minimum(dv, channel, ForbiddenValue)) / this.Average(dv, channel, ForbiddenValue);
        return this.Contrast;
    }

    public double Michelson(DV dv, int channel, int ForbiddenValue) {
        double min = this.Minimum(dv, channel, ForbiddenValue);
        double max = this.Maximum(dv, channel, ForbiddenValue);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double Michelson(DV dv, int channel, double ForbiddenValue) {
        double min = this.Minimum(dv, channel, ForbiddenValue);
        double max = this.Maximum(dv, channel, ForbiddenValue);
        this.Michelson = (max - min) / (max + min);
        return this.Michelson;
    }

    public double MichelsonFromRanks(DV dv, int channel, int ranksup, int ForbiddenValue) {
        switch (dv.Type) {
            case 8: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferByte(channel), ranksup, (byte)ForbiddenValue);
                break;
            }
            case 16: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferShort(channel), ranksup, (short)ForbiddenValue);
                break;
            }
            case 32: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferInt(channel), ranksup, ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Michelson;
    }

    public double MichelsonFromRanks(DV dv, int channel, int ranksup, double ForbiddenValue) {
        switch (dv.Type) {
            case -32: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferFloat(channel), ranksup, (float)ForbiddenValue);
                break;
            }
            case 64: {
                this.Michelson = this.AF.MichelsonFromRanks(dv.getDataBufferDouble(channel), ranksup, ForbiddenValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        return this.Michelson;
    }
}

