/*
 * Decompiled with CFR 0.152.
 */
package dv;

import dv.DV;
import dv.DvOperations;
import dv.DvTools;
import java.awt.image.BufferedImage;

public class DvNew {
    public static DV Same(DV dv) {
        return new DV(dv.SizeX, dv.SizeY, dv.SizeZ, dv.Channel, dv.Type);
    }

    public static DV Same(DV dv, int type) {
        return new DV(dv.SizeX, dv.SizeY, dv.SizeZ, dv.Channel, type);
    }

    public static DV Same(BufferedImage image, int depth) {
        switch (image.getType()) {
            case 10: {
                return new DV(image.getWidth(), image.getHeight(), depth, 1, 8);
            }
            case 11: {
                return new DV(image.getWidth(), image.getHeight(), depth, 1, 16);
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        return new DV(image.getWidth(), image.getHeight(), depth, 1, 32);
                    }
                    case 4: {
                        return new DV(image.getWidth(), image.getHeight(), depth, 1, -32);
                    }
                    case 5: {
                        return new DV(image.getWidth(), image.getHeight(), depth, 1, 64);
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
        }
        throw new IllegalArgumentException("Image type not supported.");
    }

    public static DV Clone(DV dv) {
        DV clone = DvNew.Same(dv);
        DvNew.Copy(dv, clone);
        return clone;
    }

    public static void Copy(DV source, DV target) {
        if (!DvTools.areDimensionsAndTypeEqual(source, target)) {
            throw new IllegalArgumentException("Source and Target have different type or dimensions.");
        }
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferByte(c), 0, target.getDataBufferByte(c), 0, target.Length);
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferShort(c), 0, target.getDataBufferShort(c), 0, target.Length);
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferInt(c), 0, target.getDataBufferInt(c), 0, target.Length);
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferFloat(c), 0, target.getDataBufferFloat(c), 0, target.Length);
                }
                break;
            }
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferDouble(c), 0, target.getDataBufferDouble(c), 0, target.Length);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DV type.");
            }
        }
    }

    public static void CopyIntoBigger(DV source, DV target, int sx, int sy, int sz) {
        if (target.SizeX < source.SizeX || target.SizeY < source.SizeY || target.SizeZ < source.SizeZ) {
            throw new IllegalArgumentException("Target has a smaller dimension than source.");
        }
        if (target.Channel != source.Channel || target.Type != source.Type) {
            throw new IllegalArgumentException("Source and Target have different number of channel or type.");
        }
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] bbsrc = source.getDataBufferByte(c);
                    byte[] bbtar = target.getDataBufferByte(c);
                    int possrc = 0;
                    for (int z = 0; z < source.SizeZ; ++z) {
                        int y = 0;
                        int postar = target.Position(sx, sy + y, sz + z);
                        while (y < source.SizeY) {
                            System.arraycopy(bbsrc, possrc, bbtar, postar, source.SizeX);
                            ++y;
                            possrc += source.SizeX;
                            postar += target.SizeX;
                        }
                    }
                    bbtar = null;
                    bbsrc = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    short[] sbsrc = source.getDataBufferShort(c);
                    short[] sbtar = target.getDataBufferShort(c);
                    int possrc = 0;
                    for (int z = 0; z < source.SizeZ; ++z) {
                        int y = 0;
                        int postar = target.Position(sx, sy + y, sz + z);
                        while (y < source.SizeY) {
                            System.arraycopy(sbsrc, possrc, sbtar, postar, source.SizeX);
                            ++y;
                            possrc += source.SizeX;
                            postar += target.SizeX;
                        }
                    }
                    sbtar = null;
                    sbsrc = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    int[] ibsrc = source.getDataBufferInt(c);
                    int[] ibtar = target.getDataBufferInt(c);
                    int possrc = 0;
                    for (int z = 0; z < source.SizeZ; ++z) {
                        int y = 0;
                        int postar = target.Position(sx, sy + y, sz + z);
                        while (y < source.SizeY) {
                            System.arraycopy(ibsrc, possrc, ibtar, postar, source.SizeX);
                            ++y;
                            possrc += source.SizeX;
                            postar += target.SizeX;
                        }
                    }
                    ibtar = null;
                    ibsrc = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    float[] fbsrc = source.getDataBufferFloat(c);
                    float[] fbtar = target.getDataBufferFloat(c);
                    int possrc = 0;
                    for (int z = 0; z < source.SizeZ; ++z) {
                        int y = 0;
                        int postar = target.Position(sx, sy + y, sz + z);
                        while (y < source.SizeY) {
                            System.arraycopy(fbsrc, possrc, fbtar, postar, source.SizeX);
                            ++y;
                            possrc += source.SizeX;
                            postar += target.SizeX;
                        }
                    }
                    fbtar = null;
                    fbsrc = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    double[] dbsrc = source.getDataBufferDouble(c);
                    double[] dbtar = target.getDataBufferDouble(c);
                    int possrc = 0;
                    for (int z = 0; z < source.SizeZ; ++z) {
                        int y = 0;
                        int postar = target.Position(sx, sy + y, sz + z);
                        while (y < source.SizeY) {
                            System.arraycopy(dbsrc, possrc, dbtar, postar, source.SizeX);
                            ++y;
                            possrc += source.SizeX;
                            postar += target.SizeX;
                        }
                    }
                    dbtar = null;
                    dbsrc = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static DV Random(int width, int height, int depth, int channel, int type) {
        DV dv = new DV(width, height, depth, channel, type);
        DvOperations.FillRandomly(dv);
        return dv;
    }

    public static DV Increasing(int width, int height, int depth, int channel, int type) {
        DV dv = new DV(width, height, depth, channel, type);
        DvOperations.FillIncreasingly(dv);
        return dv;
    }

    public static DV DuplicateChannels(DV source, int num) {
        DV result = new DV(source.SizeX, source.SizeY, source.SizeZ, num, source.Type);
        DvNew.DuplicateChannels(source, result);
        return result;
    }

    public static void DuplicateChannels(DV source, DV result) {
        if (source.Type != result.Type) {
            throw new IllegalArgumentException("DVs have different types.");
        }
        if (source.SizeX != result.SizeX || source.SizeY != result.SizeY || source.SizeZ != result.SizeZ) {
            throw new IllegalArgumentException("DVs have different dimensions.");
        }
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < result.Channel; ++c) {
                    System.arraycopy(source.getDataBufferByte(0), 0, result.getDataBufferByte(c), 0, source.Length);
                }
                break;
            }
            case 16: {
                for (int c = 0; c < result.Channel; ++c) {
                    System.arraycopy(source.getDataBufferShort(0), 0, result.getDataBufferShort(c), 0, source.Length);
                }
                break;
            }
            case 32: {
                for (int c = 0; c < result.Channel; ++c) {
                    System.arraycopy(source.getDataBufferInt(0), 0, result.getDataBufferInt(c), 0, source.Length);
                }
                break;
            }
            case -32: {
                for (int c = 0; c < result.Channel; ++c) {
                    System.arraycopy(source.getDataBufferFloat(0), 0, result.getDataBufferFloat(c), 0, source.Length);
                }
                break;
            }
            case 64: {
                for (int c = 0; c < result.Channel; ++c) {
                    System.arraycopy(source.getDataBufferDouble(0), 0, result.getDataBufferDouble(c), 0, source.Length);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DV type.");
            }
        }
    }

    public static DV Crop(DV src, int startx, int starty, int startz, int sizex, int sizey, int sizez) {
        DV result = new DV(sizex, sizey, sizez, src.Channel, src.Type);
        DvNew.Crop(src, startx, starty, startz, result);
        return result;
    }

    public static void Crop(DV src, int startx, int starty, int startz, DV res) {
        if (src.Channel != res.Channel || src.Type != res.Type) {
            throw new IllegalArgumentException("src.Channel != res.Channel || src.Type != res.Type");
        }
        int endy = starty + res.SizeY;
        int endz = startz + res.SizeZ;
        switch (src.Type) {
            case 8: {
                for (int c = 0; c < src.Channel; ++c) {
                    byte[] bbsrc = src.getDataBufferByte(c);
                    byte[] bbres = res.getDataBufferByte(c);
                    int posres = 0;
                    for (int z = startz; z < endz; ++z) {
                        int y = starty;
                        int possrc = z * src.LayerSize + y * src.SizeX + startx;
                        while (y < endy) {
                            System.arraycopy(bbsrc, possrc, bbres, posres, res.SizeX);
                            ++y;
                            possrc += src.SizeX;
                            posres += res.SizeX;
                        }
                    }
                    bbres = null;
                    bbsrc = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < src.Channel; ++c) {
                    short[] sbsrc = src.getDataBufferShort(c);
                    short[] sbres = res.getDataBufferShort(c);
                    int posres = 0;
                    for (int z = startz; z < endz; ++z) {
                        int y = starty;
                        int possrc = z * src.LayerSize + y * src.SizeX + startx;
                        while (y < endy) {
                            System.arraycopy(sbsrc, possrc, sbres, posres, res.SizeX);
                            ++y;
                            possrc += src.SizeX;
                            posres += res.SizeX;
                        }
                    }
                    sbres = null;
                    sbsrc = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < src.Channel; ++c) {
                    int[] ibsrc = src.getDataBufferInt(c);
                    int[] ibres = res.getDataBufferInt(c);
                    int posres = 0;
                    for (int z = startz; z < endz; ++z) {
                        int y = starty;
                        int possrc = z * src.LayerSize + y * src.SizeX + startx;
                        while (y < endy) {
                            System.arraycopy(ibsrc, possrc, ibres, posres, res.SizeX);
                            ++y;
                            possrc += src.SizeX;
                            posres += res.SizeX;
                        }
                    }
                    ibres = null;
                    ibsrc = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < src.Channel; ++c) {
                    float[] fbsrc = src.getDataBufferFloat(c);
                    float[] fbres = res.getDataBufferFloat(c);
                    int posres = 0;
                    for (int z = startz; z < endz; ++z) {
                        int y = starty;
                        int possrc = z * src.LayerSize + y * src.SizeX + startx;
                        while (y < endy) {
                            System.arraycopy(fbsrc, possrc, fbres, posres, res.SizeX);
                            ++y;
                            possrc += src.SizeX;
                            posres += res.SizeX;
                        }
                    }
                    fbres = null;
                    fbsrc = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < src.Channel; ++c) {
                    double[] dbsrc = src.getDataBufferDouble(c);
                    double[] dbres = res.getDataBufferDouble(c);
                    int posres = 0;
                    for (int z = startz; z < endz; ++z) {
                        int y = starty;
                        int possrc = z * src.LayerSize + y * src.SizeX + startx;
                        while (y < endy) {
                            System.arraycopy(dbsrc, possrc, dbres, posres, res.SizeX);
                            ++y;
                            possrc += src.SizeX;
                            posres += res.SizeX;
                        }
                    }
                    dbres = null;
                    dbsrc = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type unknown.");
            }
        }
    }
}

