/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayOperations;
import dv.DV;
import dv.DvComparator;
import dv.DvNew;
import dv.DvTools;
import java.util.Arrays;

public class DvOperations {
    public static void Fill(DV dv, int v) {
        switch (dv.Type) {
            case 8: {
                DvOperations.Fill(dv, (byte)v);
                break;
            }
            case 16: {
                DvOperations.Fill(dv, (short)v);
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    DvOperations.Fill(dv, c, v);
                }
                break;
            }
            case -32: {
                DvOperations.Fill(dv, (float)v);
                break;
            }
            case 64: {
                DvOperations.Fill(dv, (double)v);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void Fill(DV dv, int channel, int v) {
        switch (dv.Type) {
            case 8: {
                DvOperations.Fill(dv, channel, (byte)v);
                break;
            }
            case 16: {
                DvOperations.Fill(dv, channel, (short)v);
                break;
            }
            case 32: {
                Arrays.fill(dv.getDataBufferInt(channel), v);
                break;
            }
            case -32: {
                DvOperations.Fill(dv, channel, (float)v);
                break;
            }
            case 64: {
                DvOperations.Fill(dv, channel, (double)v);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void Fill(DV dv, short v) {
        for (int c = 0; c < dv.Channel; ++c) {
            DvOperations.Fill(dv, c, v);
        }
    }

    public static void Fill(DV dv, byte v) {
        for (int c = 0; c < dv.Channel; ++c) {
            DvOperations.Fill(dv, c, v);
        }
    }

    public static void Fill(DV dv, float v) {
        for (int c = 0; c < dv.Channel; ++c) {
            DvOperations.Fill(dv, c, v);
        }
    }

    public static void Fill(DV dv, double v) {
        for (int c = 0; c < dv.Channel; ++c) {
            DvOperations.Fill(dv, c, v);
        }
    }

    public static void Fill(DV dv, int channel, short v) {
        Arrays.fill(dv.getDataBufferShort(channel), v);
    }

    public static void Fill(DV dv, int channel, byte v) {
        Arrays.fill(dv.getDataBufferByte(channel), v);
    }

    public static void Fill(DV dv, int channel, float v) {
        Arrays.fill(dv.getDataBufferFloat(channel), v);
    }

    public static void Fill(DV dv, int channel, double v) {
        Arrays.fill(dv.getDataBufferDouble(channel), v);
    }

    public static void FillRandomly(DV dv) {
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillRandomly(dv.getDataBufferByte(c));
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillRandomly(dv.getDataBufferShort(c));
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillRandomly(dv.getDataBufferInt(c));
                }
                break;
            }
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillRandomly(dv.getDataBufferFloat(c));
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillRandomly(dv.getDataBufferDouble(c));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void FillGaussianRandomly(DV dv, double sd) {
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillGaussianRandomly(dv.getDataBufferByte(c), sd);
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillGaussianRandomly(dv.getDataBufferShort(c), sd);
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillGaussianRandomly(dv.getDataBufferInt(c), sd);
                }
                break;
            }
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillGaussianRandomly(dv.getDataBufferFloat(c), sd);
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillGaussianRandomly(dv.getDataBufferDouble(c), sd);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void FillIncreasingly(DV dv) {
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillIncreasingly(dv.getDataBufferByte(c));
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillIncreasingly(dv.getDataBufferShort(c));
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillIncreasingly(dv.getDataBufferInt(c));
                }
                break;
            }
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillIncreasingly(dv.getDataBufferFloat(c));
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    ArrayOperations.FillIncreasingly(dv.getDataBufferDouble(c));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static DV Minimize(DV dv, int margin) {
        int y;
        int z;
        int c;
        int minx = dv.SizeX;
        int miny = dv.SizeY;
        int minz = dv.SizeZ;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        switch (dv.Type) {
            case 8: {
                int x;
                int pos;
                for (c = 0; c < dv.Channel; ++c) {
                    byte[] bb = dv.getDataBufferByte(c);
                    pos = 0;
                    for (z = 0; z < dv.SizeZ; ++z) {
                        for (y = 0; y < dv.SizeY; ++y) {
                            x = 0;
                            while (x < dv.SizeX) {
                                if (0 != bb[pos]) {
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (maxx < x) {
                                        maxx = x;
                                    }
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (maxy < y) {
                                        maxy = y;
                                    }
                                    if (z < minz) {
                                        minz = z;
                                    }
                                    if (maxz < z) {
                                        maxz = z;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    bb = null;
                }
                break;
            }
            case 16: {
                int x;
                int pos;
                for (c = 0; c < dv.Channel; ++c) {
                    short[] sb = dv.getDataBufferShort(c);
                    pos = 0;
                    for (z = 0; z < dv.SizeZ; ++z) {
                        for (y = 0; y < dv.SizeY; ++y) {
                            x = 0;
                            while (x < dv.SizeX) {
                                if (0 != sb[pos]) {
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (maxx < x) {
                                        maxx = x;
                                    }
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (maxy < y) {
                                        maxy = y;
                                    }
                                    if (z < minz) {
                                        minz = z;
                                    }
                                    if (maxz < z) {
                                        maxz = z;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    sb = null;
                }
                break;
            }
            case 32: {
                int x;
                int pos;
                for (c = 0; c < dv.Channel; ++c) {
                    int[] ib = dv.getDataBufferInt(c);
                    pos = 0;
                    for (z = 0; z < dv.SizeZ; ++z) {
                        for (y = 0; y < dv.SizeY; ++y) {
                            x = 0;
                            while (x < dv.SizeX) {
                                if (0 != ib[pos]) {
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (maxx < x) {
                                        maxx = x;
                                    }
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (maxy < y) {
                                        maxy = y;
                                    }
                                    if (z < minz) {
                                        minz = z;
                                    }
                                    if (maxz < z) {
                                        maxz = z;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    ib = null;
                }
                break;
            }
            case -32: {
                int x;
                int pos;
                for (c = 0; c < dv.Channel; ++c) {
                    float[] fb = dv.getDataBufferFloat(c);
                    pos = 0;
                    for (z = 0; z < dv.SizeZ; ++z) {
                        for (y = 0; y < dv.SizeY; ++y) {
                            x = 0;
                            while (x < dv.SizeX) {
                                if (0.0f != fb[pos]) {
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (maxx < x) {
                                        maxx = x;
                                    }
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (maxy < y) {
                                        maxy = y;
                                    }
                                    if (z < minz) {
                                        minz = z;
                                    }
                                    if (maxz < z) {
                                        maxz = z;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    fb = null;
                }
                break;
            }
            case 64: {
                int x;
                int pos;
                for (c = 0; c < dv.Channel; ++c) {
                    double[] db = dv.getDataBufferDouble(c);
                    pos = 0;
                    for (z = 0; z < dv.SizeZ; ++z) {
                        for (y = 0; y < dv.SizeY; ++y) {
                            x = 0;
                            while (x < dv.SizeX) {
                                if (0.0 != db[pos]) {
                                    if (x < minx) {
                                        minx = x;
                                    }
                                    if (maxx < x) {
                                        maxx = x;
                                    }
                                    if (y < miny) {
                                        miny = y;
                                    }
                                    if (maxy < y) {
                                        maxy = y;
                                    }
                                    if (z < minz) {
                                        minz = z;
                                    }
                                    if (maxz < z) {
                                        maxz = z;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    db = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        int dx = maxx - minx + 1;
        int dy = maxy - miny + 1;
        int dz = maxz - minz + 1;
        int m2 = margin << 1;
        DV shrunk = new DV(m2 + dx, m2 + dy, m2 + dz, dv.Channel, dv.Type);
        int start = margin + margin * shrunk.SizeX + margin * shrunk.LayerSize;
        int masx = margin * shrunk.SizeX;
        switch (dv.Type) {
            case 8: {
                for (c = 0; c < dv.Channel; ++c) {
                    byte[] bbin = dv.getDataBufferByte(c);
                    byte[] bbout = shrunk.getDataBufferByte(c);
                    z = minz;
                    while (z <= maxz) {
                        y = miny;
                        while (y <= maxy) {
                            System.arraycopy(bbin, minx + y * dv.SizeX + z * dv.LayerSize, bbout, start, dx);
                            ++y;
                            start += shrunk.SizeX;
                        }
                        ++z;
                        start += masx;
                    }
                    bbout = null;
                    bbin = null;
                }
                break;
            }
            case 16: {
                for (c = 0; c < dv.Channel; ++c) {
                    short[] sbin = dv.getDataBufferShort(c);
                    short[] sbout = shrunk.getDataBufferShort(c);
                    z = minz;
                    while (z <= maxz) {
                        y = miny;
                        while (y <= maxy) {
                            System.arraycopy(sbin, minx + y * dv.SizeX + z * dv.LayerSize, sbout, start, dx);
                            ++y;
                            start += shrunk.SizeX;
                        }
                        ++z;
                        start += masx;
                    }
                    sbout = null;
                    sbin = null;
                }
                break;
            }
            case 32: {
                for (c = 0; c < dv.Channel; ++c) {
                    int[] ibin = dv.getDataBufferInt(c);
                    int[] ibout = shrunk.getDataBufferInt(c);
                    z = minz;
                    while (z <= maxz) {
                        y = miny;
                        while (y <= maxy) {
                            System.arraycopy(ibin, minx + y * dv.SizeX + z * dv.LayerSize, ibout, start, dx);
                            ++y;
                            start += shrunk.SizeX;
                        }
                        ++z;
                        start += masx;
                    }
                    ibout = null;
                    ibin = null;
                }
                break;
            }
            case -32: {
                for (c = 0; c < dv.Channel; ++c) {
                    float[] fbin = dv.getDataBufferFloat(c);
                    float[] fbout = shrunk.getDataBufferFloat(c);
                    z = minz;
                    while (z <= maxz) {
                        y = miny;
                        while (y <= maxy) {
                            System.arraycopy(fbin, minx + y * dv.SizeX + z * dv.LayerSize, fbout, start, dx);
                            ++y;
                            start += shrunk.SizeX;
                        }
                        ++z;
                        start += masx;
                    }
                    fbout = null;
                    fbin = null;
                }
                break;
            }
            case 64: {
                for (c = 0; c < dv.Channel; ++c) {
                    double[] bbin = dv.getDataBufferDouble(c);
                    double[] bbout = shrunk.getDataBufferDouble(c);
                    z = minz;
                    while (z <= maxz) {
                        y = miny;
                        while (y <= maxy) {
                            System.arraycopy(bbin, minx + y * dv.SizeX + z * dv.LayerSize, bbout, start, dx);
                            ++y;
                            start += shrunk.SizeX;
                        }
                        ++z;
                        start += masx;
                    }
                    bbout = null;
                    bbin = null;
                }
                break;
            }
        }
        return shrunk;
    }

    public static void Minimum(DV dv1, DV dv2, DV result) {
        DvComparator.Compare(dv1, "<=", dv2, dv1, dv2, result);
    }

    public static void Maximum(DV dv1, DV dv2, DV result) {
        DvComparator.Compare(dv1, ">=", dv2, dv1, dv2, result);
    }

    public static DV Differences(DV dv1, DV dv2) {
        DV result = DvNew.Same(dv1);
        DvOperations.Differences(dv1, dv2, result);
        return result;
    }

    public static void Differences(DV dv1, DV dv2, DV result) {
        if (!DvTools.areDimensionsAndTypeEqual(dv1, dv2) || !DvTools.areDimensionsAndTypeEqual(dv1, result)) {
            throw new IllegalArgumentException("The DVs do not have the same type and/or dimensions.");
        }
        block7: for (int c = 0; c < dv1.Channel; ++c) {
            switch (dv1.Type) {
                case 8: {
                    ArrayOperations.DifferencesUnsigned(dv1.getDataBufferByte(c), dv2.getDataBufferByte(c), result.getDataBufferByte(c));
                    continue block7;
                }
                case 16: {
                    ArrayOperations.DifferencesUnsigned(dv1.getDataBufferShort(c), dv2.getDataBufferShort(c), result.getDataBufferShort(c));
                    continue block7;
                }
                case 32: {
                    ArrayOperations.Differences(dv1.getDataBufferInt(c), dv2.getDataBufferInt(c), result.getDataBufferInt(c));
                    continue block7;
                }
                case -32: {
                    ArrayOperations.Differences(dv1.getDataBufferFloat(c), dv2.getDataBufferFloat(c), result.getDataBufferFloat(c));
                    continue block7;
                }
                case 64: {
                    ArrayOperations.Differences(dv1.getDataBufferDouble(c), dv2.getDataBufferDouble(c), result.getDataBufferDouble(c));
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
        }
    }

    public static DV Move(DV source, int deltax, int deltay, int deltaz, int filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.Move(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void Move(DV source, DV result, int deltax, int deltay, int deltaz, int filledvalue) {
        if (0 == deltax && 0 == deltay) {
            DvNew.Copy(source, result);
            if (deltaz < 0) {
                DvOperations.MoveDown(result, filledvalue);
            } else {
                DvOperations.MoveUp(result, filledvalue);
            }
        } else if (0 <= deltax && 0 <= deltay && 0 <= deltaz) {
            DvOperations.MoveForward(source, result, deltax, deltay, deltaz, filledvalue);
        } else if (deltax <= 0 && deltay <= 0 && deltaz <= 0) {
            DvOperations.MoveBackward(source, result, -deltax, -deltay, -deltaz, filledvalue);
        } else {
            DvNew.Copy(source, result);
            if (0 < deltax) {
                DvOperations.MoveForward(result, result, deltax, 0, 0, filledvalue);
            } else if (deltax < 0) {
                DvOperations.MoveBackward(result, result, -deltax, 0, 0, filledvalue);
            }
            if (0 < deltay) {
                DvOperations.MoveBackward(result, result, 0, deltay, 0, filledvalue);
            } else if (deltay < 0) {
                DvOperations.MoveBackward(result, result, 0, -deltay, 0, filledvalue);
            }
            if (0 < deltaz) {
                DvOperations.MoveBackward(result, result, 0, 0, deltaz, filledvalue);
            } else if (deltaz < 0) {
                DvOperations.MoveBackward(result, result, 0, 0, -deltaz, filledvalue);
            }
        }
    }

    public static DV Move(DV source, int deltax, int deltay, int deltaz, double filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.Move(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void Move(DV source, DV result, int deltax, int deltay, int deltaz, double filledvalue) {
        if (0 == deltax && 0 == deltay) {
            DvNew.Copy(source, result);
            if (deltaz < 0) {
                DvOperations.MoveDown(result, filledvalue);
            } else {
                DvOperations.MoveUp(result, filledvalue);
            }
        } else if (0 <= deltax && 0 <= deltay && 0 <= deltaz) {
            DvOperations.MoveForward(source, result, deltax, deltay, deltaz, filledvalue);
        } else if (deltax <= 0 && deltay <= 0 && deltaz <= 0) {
            DvOperations.MoveBackward(source, result, -deltax, -deltay, -deltaz, filledvalue);
        } else {
            DvNew.Copy(source, result);
            if (0 < deltax) {
                DvOperations.MoveForward(result, result, deltax, 0, 0, filledvalue);
            } else if (deltax < 0) {
                DvOperations.MoveBackward(result, result, -deltax, 0, 0, filledvalue);
            }
            if (0 < deltay) {
                DvOperations.MoveBackward(result, result, 0, deltay, 0, filledvalue);
            } else if (deltay < 0) {
                DvOperations.MoveBackward(result, result, 0, -deltay, 0, filledvalue);
            }
            if (0 < deltaz) {
                DvOperations.MoveBackward(result, result, 0, 0, deltaz, filledvalue);
            } else if (deltaz < 0) {
                DvOperations.MoveBackward(result, result, 0, 0, -deltaz, filledvalue);
            }
        }
    }

    public static DV MoveBackward(DV source, int deltax, int deltay, int deltaz, int filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.MoveBackward(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void MoveBackward(DV source, DV result, int deltax, int deltay, int deltaz, int filledvalue) {
        if (!DvTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("DV source and result have different dimensions or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        if (deltaz < 0) {
            throw new IllegalArgumentException("Delta Z < 0");
        }
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int channel = source.Channel;
        int layer = source.LayerSize;
        int w = width - deltax;
        int h = height - deltay;
        int d = depth - deltaz;
        int gap = deltax + deltay * width + deltaz * source.LayerSize;
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < channel; ++c) {
                    byte[] bbin = source.getDataBufferByte(c);
                    byte[] bbout = result.getDataBufferByte(c);
                    for (int z = 0; z < d; ++z) {
                        int y = 0;
                        int pos = z * layer;
                        while (y < h) {
                            System.arraycopy(bbin, pos + gap, bbout, pos, w);
                            Arrays.fill(bbout, pos + w, pos + width, (byte)filledvalue);
                            ++y;
                            pos += width;
                        }
                        Arrays.fill(bbout, pos, (z + 1) * layer, (byte)filledvalue);
                    }
                    Arrays.fill(bbout, d * layer, bbin.length, (byte)filledvalue);
                    bbout = null;
                    bbin = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < channel; ++c) {
                    short[] sbin = source.getDataBufferShort(c);
                    short[] sbout = result.getDataBufferShort(c);
                    for (int z = 0; z < d; ++z) {
                        int y = 0;
                        int pos = z * layer;
                        while (y < h) {
                            System.arraycopy(sbin, pos + gap, sbout, pos, w);
                            Arrays.fill(sbout, pos + w, pos + width, (short)filledvalue);
                            ++y;
                            pos += width;
                        }
                        Arrays.fill(sbout, pos, (z + 1) * layer, (short)filledvalue);
                    }
                    Arrays.fill(sbout, d * layer, sbin.length, (short)filledvalue);
                    sbout = null;
                    sbin = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < channel; ++c) {
                    int[] ibin = source.getDataBufferInt(c);
                    int[] ibout = result.getDataBufferInt(c);
                    for (int z = 0; z < d; ++z) {
                        int y = 0;
                        int pos = z * layer;
                        while (y < h) {
                            System.arraycopy(ibin, pos + gap, ibout, pos, w);
                            Arrays.fill(ibout, pos + w, pos + width, filledvalue);
                            ++y;
                            pos += width;
                        }
                        Arrays.fill(ibout, pos, (z + 1) * layer, filledvalue);
                    }
                    Arrays.fill(ibout, d * layer, ibin.length, filledvalue);
                    ibout = null;
                    ibin = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static DV MoveBackward(DV source, int deltax, int deltay, int deltaz, double filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.MoveBackward(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void MoveBackward(DV source, DV result, int deltax, int deltay, int deltaz, double filledvalue) {
        if (!DvTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("DV source and result have different dimensions or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        if (deltaz < 0) {
            throw new IllegalArgumentException("Delta Z < 0");
        }
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int channel = source.Channel;
        int layer = source.LayerSize;
        int w = width - deltax;
        int h = height - deltay;
        int d = depth - deltaz;
        int gap = deltax + deltay * width + deltaz * source.LayerSize;
        switch (source.Type) {
            case -32: {
                for (int c = 0; c < channel; ++c) {
                    float[] fbin = source.getDataBufferFloat(c);
                    float[] fbout = result.getDataBufferFloat(c);
                    for (int z = 0; z < d; ++z) {
                        int y = 0;
                        int pos = z * layer;
                        while (y < h) {
                            System.arraycopy(fbin, pos + gap, fbout, pos, w);
                            Arrays.fill(fbout, pos + w, pos + width, (float)filledvalue);
                            ++y;
                            pos += width;
                        }
                        Arrays.fill(fbout, pos, (z + 1) * layer, (float)filledvalue);
                    }
                    Arrays.fill(fbout, d * layer, fbin.length, (float)filledvalue);
                    fbout = null;
                    fbin = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < channel; ++c) {
                    double[] dbin = source.getDataBufferDouble(c);
                    double[] dbout = result.getDataBufferDouble(c);
                    for (int z = 0; z < d; ++z) {
                        int y = 0;
                        int pos = z * layer;
                        while (y < h) {
                            System.arraycopy(dbin, pos + gap, dbout, pos, w);
                            Arrays.fill(dbout, pos + w, pos + width, filledvalue);
                            ++y;
                            pos += width;
                        }
                        Arrays.fill(dbout, pos, (z + 1) * layer, filledvalue);
                    }
                    Arrays.fill(dbout, d * layer, dbin.length, filledvalue);
                    dbout = null;
                    dbin = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static DV MoveForward(DV source, int deltax, int deltay, int deltaz, int filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.MoveForward(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void MoveForward(DV source, DV result, int deltax, int deltay, int deltaz, int filledvalue) {
        if (!DvTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("DV source and result have different dimension or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        if (deltaz < 0) {
            throw new IllegalArgumentException("Delta Z < 0");
        }
        int pos = 0;
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int channel = source.Channel;
        int layer = source.LayerSize;
        int gap = deltax + deltay * width + deltaz * layer;
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < channel; ++c) {
                    byte[] bbin = source.getDataBufferByte(c);
                    byte[] bbout = result.getDataBufferByte(c);
                    for (int z = depth - 1; z >= deltaz; --z) {
                        int y;
                        for (y = height - 1; y >= deltay; --y) {
                            int x = width - 1;
                            pos = x + y * width + z * layer;
                            int p2 = pos - gap;
                            while (x >= deltax) {
                                bbout[pos] = bbin[p2];
                                --x;
                                --pos;
                                --p2;
                            }
                            while (x >= 0) {
                                bbout[pos] = (byte)filledvalue;
                                --x;
                                --pos;
                                --p2;
                            }
                        }
                        while (y >= 0) {
                            Arrays.fill(bbout, pos - width + 1, pos + 1, (byte)filledvalue);
                            --y;
                            pos -= width;
                        }
                    }
                    Arrays.fill(bbout, 0, pos + 1, (byte)filledvalue);
                    bbout = null;
                    bbin = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < channel; ++c) {
                    short[] sbin = source.getDataBufferShort(c);
                    short[] sbout = result.getDataBufferShort(c);
                    for (int z = depth - 1; z >= deltaz; --z) {
                        int y;
                        for (y = height - 1; y >= deltay; --y) {
                            int x = width - 1;
                            pos = x + y * width + z * layer;
                            int p2 = pos - gap;
                            while (x >= deltax) {
                                sbout[pos] = sbin[p2];
                                --x;
                                --pos;
                                --p2;
                            }
                            while (x >= 0) {
                                sbout[pos] = (short)filledvalue;
                                --x;
                                --pos;
                                --p2;
                            }
                        }
                        while (y >= 0) {
                            Arrays.fill(sbout, pos - width + 1, pos + 1, (short)filledvalue);
                            --y;
                            pos -= width;
                        }
                    }
                    Arrays.fill(sbout, 0, pos + 1, (short)filledvalue);
                    sbout = null;
                    sbin = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < channel; ++c) {
                    int[] ibin = source.getDataBufferInt(c);
                    int[] ibout = result.getDataBufferInt(c);
                    for (int z = depth - 1; z >= deltaz; --z) {
                        int y;
                        for (y = height - 1; y >= deltay; --y) {
                            int x = width - 1;
                            pos = x + y * width + z * layer;
                            int p2 = pos - gap;
                            while (x >= deltax) {
                                ibout[pos] = ibin[p2];
                                --x;
                                --pos;
                                --p2;
                            }
                            while (x >= 0) {
                                ibout[pos] = filledvalue;
                                --x;
                                --pos;
                                --p2;
                            }
                        }
                        while (y >= 0) {
                            Arrays.fill(ibout, pos - width + 1, pos + 1, filledvalue);
                            --y;
                            pos -= width;
                        }
                    }
                    Arrays.fill(ibout, 0, pos + 1, filledvalue);
                    ibout = null;
                    ibin = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static DV MoveForward(DV source, int deltax, int deltay, int deltaz, double filledvalue) {
        DV result = DvNew.Same(source);
        DvOperations.MoveForward(source, result, deltax, deltay, deltaz, filledvalue);
        return result;
    }

    public static void MoveForward(DV source, DV result, int deltax, int deltay, int deltaz, double filledvalue) {
        if (!DvTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("DV source and result have different dimension or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        if (deltaz < 0) {
            throw new IllegalArgumentException("Delta Z < 0");
        }
        int pos = 0;
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int channel = source.Channel;
        int layer = source.LayerSize;
        int gap = deltax + deltay * width + deltaz * layer;
        switch (source.Type) {
            case -32: {
                for (int c = 0; c < channel; ++c) {
                    float[] fbin = source.getDataBufferFloat(c);
                    float[] fbout = result.getDataBufferFloat(c);
                    for (int z = depth - 1; z >= deltaz; --z) {
                        int y;
                        for (y = height - 1; y >= deltay; --y) {
                            int x = width - 1;
                            pos = x + y * width + z * layer;
                            int p2 = pos - gap;
                            while (x >= deltax) {
                                fbout[pos] = fbin[p2];
                                --x;
                                --pos;
                                --p2;
                            }
                            while (x >= 0) {
                                fbout[pos] = (float)filledvalue;
                                --x;
                                --pos;
                                --p2;
                            }
                        }
                        while (y >= 0) {
                            Arrays.fill(fbout, pos - width + 1, pos + 1, (float)filledvalue);
                            --y;
                            pos -= width;
                        }
                    }
                    Arrays.fill(fbout, 0, pos + 1, (float)filledvalue);
                    fbout = null;
                    fbin = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < channel; ++c) {
                    double[] dbin = source.getDataBufferDouble(c);
                    double[] dbout = result.getDataBufferDouble(c);
                    for (int z = depth - 1; z >= deltaz; --z) {
                        int y;
                        for (y = height - 1; y >= deltay; --y) {
                            int x = width - 1;
                            pos = x + y * width + z * layer;
                            int p2 = pos - gap;
                            while (x >= deltax) {
                                dbout[pos] = dbin[p2];
                                --x;
                                --pos;
                                --p2;
                            }
                            while (x >= 0) {
                                dbout[pos] = filledvalue;
                                --x;
                                --pos;
                                --p2;
                            }
                        }
                        while (y >= 0) {
                            Arrays.fill(dbout, pos - width + 1, pos + 1, filledvalue);
                            --y;
                            pos -= width;
                        }
                    }
                    Arrays.fill(dbout, 0, pos + 1, filledvalue);
                    dbout = null;
                    dbin = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void MoveUp(DV dv, int v) {
        int length = dv.LayerSize;
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    byte[] bb = dv.getDataBufferByte(c);
                    int s2 = bb.length - length;
                    for (int s1 = s2 - length; 0 <= s1; s1 -= length) {
                        System.arraycopy(bb, s1, bb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(bb, 0, length, (byte)v);
                    bb = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    short[] sb = dv.getDataBufferShort(c);
                    int s2 = sb.length - length;
                    for (int s1 = s2 - length; 0 <= s1; s1 -= length) {
                        System.arraycopy(sb, s1, sb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(sb, 0, length, (short)v);
                    sb = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    int[] ib = dv.getDataBufferInt(c);
                    int s2 = ib.length - length;
                    for (int s1 = s2 - length; 0 <= s1; s1 -= length) {
                        System.arraycopy(ib, s1, ib, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(ib, 0, length, v);
                    ib = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void MoveUp(DV dv, double v) {
        int length = dv.LayerSize;
        switch (dv.Type) {
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    float[] fb = dv.getDataBufferFloat(c);
                    int s2 = fb.length - length;
                    for (int s1 = s2 - length; 0 <= s1; s1 -= length) {
                        System.arraycopy(fb, s1, fb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(fb, 0, length, (float)v);
                    fb = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    double[] db = dv.getDataBufferDouble(c);
                    int s2 = db.length - length;
                    for (int s1 = s2 - length; 0 <= s1; s1 -= length) {
                        System.arraycopy(db, s1, db, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(db, 0, length, v);
                    db = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void MoveDown(DV dv, int v) {
        int length = dv.LayerSize;
        switch (dv.Type) {
            case 8: {
                for (int c = 0; c < dv.Channel; ++c) {
                    byte[] bb = dv.getDataBufferByte(c);
                    int s2 = 0;
                    for (int s1 = length; s1 < dv.Length; s1 += length) {
                        System.arraycopy(bb, s1, bb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(bb, s2, dv.Length, (byte)v);
                    bb = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < dv.Channel; ++c) {
                    short[] sb = dv.getDataBufferShort(c);
                    int s2 = 0;
                    for (int s1 = length; s1 < dv.Length; s1 += length) {
                        System.arraycopy(sb, s1, sb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(sb, s2, dv.Length, (short)v);
                    sb = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    int[] ib = dv.getDataBufferInt(c);
                    int s2 = 0;
                    for (int s1 = length; s1 < dv.Length; s1 += length) {
                        System.arraycopy(ib, s1, ib, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(ib, s2, dv.Length, v);
                    ib = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static void MoveDown(DV dv, double v) {
        int length = dv.LayerSize;
        switch (dv.Type) {
            case -32: {
                for (int c = 0; c < dv.Channel; ++c) {
                    float[] fb = dv.getDataBufferFloat(c);
                    int s2 = 0;
                    for (int s1 = length; s1 < dv.Length; s1 += length) {
                        System.arraycopy(fb, s1, fb, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(fb, s2, dv.Length, (float)v);
                    fb = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < dv.Channel; ++c) {
                    double[] db = dv.getDataBufferDouble(c);
                    int s2 = 0;
                    for (int s1 = length; s1 < dv.Length; s1 += length) {
                        System.arraycopy(db, s1, db, s2, length);
                        s2 = s1;
                    }
                    Arrays.fill(db, s2, dv.Length, v);
                    db = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }
}

