/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.PlotCanvas;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.YesNoCancelDialog;
import ij.io.FileSaver;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PointToolOptions;
import ij.plugin.frame.Channels;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener,
WindowStateListener,
MouseWheelListener {
    public static final int MIN_WIDTH = 128;
    public static final int MIN_HEIGHT = 32;
    public static final int HGAP = 5;
    public static final int VGAP = 5;
    private static final String LOC_KEY = "image.loc";
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private double initialMagnification = 1.0;
    private int newWidth;
    private int newHeight;
    protected boolean closed;
    private boolean newCanvas;
    private boolean unzoomWhenMinimizing = true;
    Rectangle maxWindowBounds;
    Rectangle maxBounds;
    long setMaxBoundsTime;
    private boolean firstSmallWindow;
    private int sliderHeight;
    private static final int XINC = 12;
    private static final int YINC = 16;
    private static final int TEXT_GAP = 10;
    private static int xbase = -1;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    private static boolean centerOnScreen;
    private static Point nextLocation;
    public static long setMenuBarTime;
    private int textGap;
    public boolean running;
    public boolean running2;

    public ImageWindow(String title) {
        super(title);
        this.textGap = centerOnScreen ? 0 : 10;
    }

    public ImageWindow(ImagePlus imp) {
        this(imp, null);
    }

    public ImageWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp.getTitle());
        int n = this.textGap = centerOnScreen ? 0 : 10;
        if (Prefs.blackCanvas && this.getClass().getName().equals("ij.gui.ImageWindow")) {
            this.setForeground(Color.white);
            this.setBackground(Color.black);
        } else {
            this.setForeground(Color.black);
            if (IJ.isLinux()) {
                this.setBackground(ImageJ.backgroundColor);
            } else {
                this.setBackground(Color.white);
            }
        }
        boolean openAsHyperStack = imp.getOpenAsHyperStack();
        this.ij = IJ.getInstance();
        this.imp = imp;
        if (ic == null) {
            ic = this instanceof PlotWindow ? new PlotCanvas(imp) : new ImageCanvas(imp);
            this.newCanvas = true;
        }
        this.ic = ic;
        ImageWindow previousWindow = imp.getWindow();
        this.setLayout(new ImageLayout(ic));
        this.add(ic);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.addWindowStateListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
        if (!(this instanceof StackWindow)) {
            this.addMouseWheelListener(this);
        }
        this.setResizable(true);
        if (!(this instanceof HistogramWindow && IJ.isMacro() && Interpreter.isBatchMode())) {
            WindowManager.addWindow(this);
            imp.setWindow(this);
        }
        if (previousWindow != null) {
            if (this.newCanvas) {
                this.setLocationAndSize(false);
            } else {
                ic.update(previousWindow.getCanvas());
            }
            Point loc = previousWindow.getLocation();
            this.setLocation(loc.x, loc.y);
            if (!(this instanceof StackWindow) && !(this instanceof PlotWindow)) {
                this.pack();
                this.show();
            }
            if (ic.getMagnification() != 0.0) {
                imp.setTitle(imp.getTitle());
            }
            boolean unlocked = imp.lockSilently();
            boolean changes = imp.changes;
            imp.changes = false;
            previousWindow.close();
            imp.changes = changes;
            if (unlocked) {
                imp.unlock();
            }
            if (this.imp != null) {
                this.imp.setOpenAsHyperStack(openAsHyperStack);
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image img;
            this.setLocationAndSize(false);
            if (this.ij != null && !IJ.isMacintosh() && (img = this.ij.getIconImage()) != null) {
                try {
                    this.setIconImage(img);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (nextLocation != null) {
                this.setLocation(nextLocation);
            } else if (centerOnScreen) {
                GUI.center(this);
            }
            nextLocation = null;
            centerOnScreen = false;
            if (Interpreter.isBatchMode() || IJ.getInstance() == null && this instanceof HistogramWindow) {
                WindowManager.setTempCurrentImage(imp);
                Interpreter.addBatchModeImage(imp);
            } else {
                this.show();
            }
        }
    }

    private void setLocationAndSize(boolean updating) {
        double mag2;
        if (this.imp == null) {
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        Rectangle maxWindow = this.getMaxWindow(0, 0);
        if (WindowManager.getWindowCount() <= 1) {
            xbase = -1;
        }
        if (width > maxWindow.width / 2 && xbase > maxWindow.x + 5 + 72) {
            xbase = -1;
        }
        if (xbase == -1) {
            count = 0;
            xbase = maxWindow.x + (maxWindow.width > 1800 ? 24 : 12);
            if (width * 2 <= maxWindow.width) {
                Point loc = Prefs.getLocation(LOC_KEY);
                if (loc != null && loc.x < maxWindow.width * 2 / 3 && loc.y < maxWindow.height / 3) {
                    xbase = loc.x;
                    ybase = loc.y;
                } else {
                    xbase = maxWindow.x + maxWindow.width / 2 - width / 2;
                    ybase = maxWindow.y;
                }
                this.firstSmallWindow = true;
                if (IJ.debugMode) {
                    IJ.log("ImageWindow.xbase: " + xbase + " " + loc);
                }
            } else {
                ybase = maxWindow.y;
            }
            xloc = xbase;
            yloc = ybase;
        }
        int x = xloc;
        int y = yloc;
        xloc += 12;
        yloc += 16;
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int screenHeight = maxWindow.y + maxWindow.height - this.sliderHeight;
        double mag = 1.0;
        while (((double)xbase + (double)width * mag > (double)(maxWindow.x + maxWindow.width) || (double)ybase + (double)height * mag >= (double)screenHeight) && (mag2 = ImageCanvas.getLowerZoomLevel(mag)) != mag) {
            mag = mag2;
        }
        if (mag < 1.0) {
            this.initialMagnification = mag;
            this.ic.setSize((int)((double)width * mag), (int)((double)height * mag));
        }
        this.ic.setMagnification(mag);
        if ((double)y + (double)height * mag > (double)screenHeight) {
            y = ybase;
        }
        if (Prefs.open100Percent && this.ic.getMagnification() < 1.0) {
            while (this.ic.getMagnification() < 1.0) {
                this.ic.zoomIn(0, 0);
            }
            this.setSize(Math.min(width, maxWindow.width - x), Math.min(height, screenHeight - y));
            this.validate();
        } else {
            this.pack();
        }
        if (!updating) {
            this.setLocation(x, y);
        }
    }

    Rectangle getMaxWindow(int xloc, int yloc) {
        Dimension ijSize;
        Rectangle bounds2;
        Rectangle bounds = GUI.getMaxWindowBounds();
        if ((xloc > bounds.x + bounds.width || yloc > bounds.y + bounds.height) && (bounds2 = this.getSecondaryMonitorBounds(xloc, yloc)) != null) {
            return bounds2;
        }
        Dimension dimension = ijSize = this.ij != null ? this.ij.getSize() : new Dimension(0, 0);
        if (bounds.height > 600) {
            bounds.y += ijSize.height;
            bounds.height -= ijSize.height;
        }
        return bounds;
    }

    private Rectangle getSecondaryMonitorBounds(int xloc, int yloc) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle bounds = null;
        block0: for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle bounds2 = gc[i].getBounds();
                if (bounds2 == null || !bounds2.contains(xloc, yloc)) continue;
                bounds = bounds2;
                continue block0;
            }
        }
        if (IJ.debugMode) {
            IJ.log("getSecondaryMonitorBounds: " + bounds);
        }
        return bounds;
    }

    public double getInitialMagnification() {
        return this.initialMagnification;
    }

    @Override
    public Insets getInsets() {
        int extraHeight;
        Insets insets = super.getInsets();
        if (this.imp == null) {
            return insets;
        }
        double mag = this.ic.getMagnification();
        int extraWidth = (int)((128.0 - (double)this.imp.getWidth() * mag) / 2.0);
        if (extraWidth < 0) {
            extraWidth = 0;
        }
        if ((extraHeight = (int)((32.0 - (double)this.imp.getHeight() * mag) / 2.0)) < 0) {
            extraHeight = 0;
        }
        insets = new Insets(insets.top + this.textGap + extraHeight, insets.left + extraWidth, insets.bottom + extraHeight, insets.right + extraWidth);
        return insets;
    }

    public void drawInfo(Graphics g) {
        if (this.imp == null) {
            return;
        }
        if (this.textGap != 0) {
            CompositeImage ci;
            Insets insets = super.getInsets();
            if (this.imp.isComposite() && (ci = (CompositeImage)this.imp).getMode() == 1) {
                Color c = ci.getChannelColor();
                if (Color.green.equals(c)) {
                    c = new Color(0, 180, 0);
                }
                g.setColor(c);
            }
            Java2.setAntialiasedText(g, true);
            g.drawString(this.createSubtitle(), insets.left + 5, insets.top + 10);
        }
    }

    public String createSubtitle() {
        String s = "";
        if (this.imp == null) {
            return s;
        }
        int nSlices = this.imp.getStackSize();
        if (nSlices > 1) {
            ImageStack stack = this.imp.getStack();
            int currentSlice = this.imp.getCurrentSlice();
            s = s + currentSlice + "/" + nSlices;
            String label = stack.getShortSliceLabel(currentSlice);
            if (label != null && label.length() > 0) {
                if (this.imp.isHyperStack()) {
                    label = label.replace(';', ' ');
                }
                s = s + " (" + label + ")";
            }
            if (this instanceof StackWindow && this.running2) {
                return s;
            }
            s = s + "; ";
        } else {
            String label = (String)this.imp.getProperty("Label");
            if (label != null) {
                int len;
                int newline = label.indexOf(10);
                if (newline > 0) {
                    label = label.substring(0, newline);
                }
                if ((len = label.length()) > 4 && label.charAt(len - 4) == '.' && !Character.isDigit(label.charAt(len - 1))) {
                    label = label.substring(0, len - 4);
                }
                if (label.length() > 60) {
                    label = label.substring(0, 60);
                }
                s = label + "; ";
            }
        }
        int type = this.imp.getType();
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            double cheight;
            boolean unitsMatch = cal.getXUnit().equals(cal.getYUnit());
            double cwidth = (double)this.imp.getWidth() * cal.pixelWidth;
            int digits = Tools.getDecimalPlaces(cwidth, cheight = (double)this.imp.getHeight() * cal.pixelHeight);
            if (digits > 2) {
                digits = 2;
            }
            s = unitsMatch ? s + IJ.d2s(cwidth, digits) + "x" + IJ.d2s(cheight, digits) + " " + cal.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : s + this.d2s(cwidth) + " " + cal.getXUnit() + " x " + this.d2s(cheight) + " " + cal.getYUnit() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); ";
        } else {
            s = s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        }
        switch (type) {
            case 0: 
            case 3: {
                s = s + "8-bit";
                break;
            }
            case 1: {
                s = s + "16-bit";
                break;
            }
            case 2: {
                s = s + "32-bit";
                break;
            }
            case 4: {
                s = s + "RGB";
            }
        }
        if (this.imp.isInvertedLut()) {
            s = s + " (inverting LUT)";
        }
        return s + "; " + ImageWindow.getImageSize(this.imp);
    }

    public static String getImageSize(ImagePlus imp) {
        if (imp == null) {
            return null;
        }
        double size = imp.getSizeInBytes() / 1024.0;
        String s2 = null;
        String s3 = null;
        if (size < 1024.0) {
            s2 = IJ.d2s(size, 0);
            s3 = "K";
        } else if (size < 10000.0) {
            s2 = IJ.d2s(size / 1024.0, 1);
            s3 = "MB";
        } else if (size < 1048576.0) {
            s2 = IJ.d2s(Math.round(size / 1024.0), 0);
            s3 = "MB";
        } else {
            s2 = IJ.d2s(size / 1048576.0, 1);
            s3 = "GB";
        }
        if (s2.endsWith(".0")) {
            s2 = s2.substring(0, s2.length() - 2);
        }
        return s2 + s3;
    }

    private String d2s(double n) {
        int digits = Tools.getDecimalPlaces(n);
        if (digits > 2) {
            digits = 2;
        }
        return IJ.d2s(n, digits);
    }

    @Override
    public void paint(Graphics g) {
        this.drawInfo(g);
        Rectangle r = this.ic.getBounds();
        int extraWidth = 128 - r.width;
        int extraHeight = 32 - r.height;
        if (extraWidth <= 0 && extraHeight <= 0 && !Prefs.noBorder && !IJ.isLinux()) {
            g.drawRect(r.x - 1, r.y - 1, r.width + 1, r.height + 1);
        }
    }

    public boolean close() {
        boolean virtual;
        boolean isRunning = this.running || this.running2;
        this.running2 = false;
        this.running = false;
        if (this.imp == null) {
            return true;
        }
        boolean bl = virtual = this.imp.getStackSize() > 1 && this.imp.getStack().isVirtual();
        if (isRunning) {
            IJ.wait(500);
        }
        if (this.imp == null) {
            return true;
        }
        boolean changes = this.imp.changes;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi instanceof PointRoi && ((PointRoi)roi).promptBeforeDeleting()) {
            changes = true;
        }
        if (this.ij == null || this.ij.quittingViaMacro() || IJ.getApplet() != null || Interpreter.isBatchMode() || IJ.macroRunning() || virtual) {
            changes = false;
        }
        if (changes) {
            FileSaver fs;
            String name = this.imp.getTitle();
            String msg = name.length() > 22 ? "Save changes to\n\"" + name + "\"?" : "Save changes to \"" + name + "\"?";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ImageJ", msg);
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !(fs = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        this.closed = true;
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        if (this.firstSmallWindow) {
            Prefs.saveLocation(LOC_KEY, this.getLocation());
        }
        WindowManager.removeWindow(this);
        if (this.ij != null && this.ij.quitting()) {
            return true;
        }
        this.dispose();
        if (this.imp != null) {
            this.imp.flush();
        }
        this.imp = null;
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public void setImage(ImagePlus imp2) {
        ImageCanvas ic = this.getCanvas();
        if (ic == null || imp2 == null) {
            return;
        }
        this.imp = imp2;
        this.imp.setWindow(this);
        ic.updateImage(this.imp);
        ic.setImageUpdated();
        ic.repaint();
        this.repaint();
    }

    public void updateImage(ImagePlus imp) {
        if (imp != this.imp) {
            throw new IllegalArgumentException("imp!=this.imp");
        }
        this.imp = imp;
        this.ic.updateImage(imp);
        this.setLocationAndSize(true);
        if (this instanceof StackWindow) {
            StackWindow sw = (StackWindow)this;
            int stackSize = imp.getStackSize();
            int nScrollbars = sw.getNScrollbars();
            if (stackSize == 1 && nScrollbars > 0) {
                sw.removeScrollbars();
            } else if (stackSize > 1 && nScrollbars == 0) {
                sw.addScrollbars(imp);
            }
        }
        this.pack();
        this.repaint();
        this.maxBounds = this.getMaximumBounds();
        this.setMaximizedBounds(this.maxBounds);
        this.setMaxBoundsTime = System.currentTimeMillis();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return ImagePlus.getClipboard();
    }

    public Rectangle getMaximumBounds() {
        int wHeight;
        int wWidth;
        Rectangle maxWindow = GUI.getMaxWindowBounds();
        if (this.imp == null) {
            return maxWindow;
        }
        double width = this.imp.getWidth();
        double height = this.imp.getHeight();
        double iAspectRatio = width / height;
        this.maxWindowBounds = maxWindow;
        if (iAspectRatio / ((double)maxWindow.width / (double)maxWindow.height) > 0.75) {
            maxWindow.y += 22;
            maxWindow.height -= 22;
        }
        Dimension extraSize = this.getExtraSize();
        double maxWidth = maxWindow.width - extraSize.width;
        double maxHeight = maxWindow.height - extraSize.height;
        double mAspectRatio = maxWidth / maxHeight;
        if (iAspectRatio >= mAspectRatio) {
            double mag = maxWidth / width;
            wWidth = maxWindow.width;
            wHeight = (int)(height * mag + (double)extraSize.height);
        } else {
            double mag = maxHeight / height;
            wHeight = maxWindow.height;
            wWidth = (int)(width * mag + (double)extraSize.width);
        }
        int xloc = (int)(maxWidth - (double)wWidth) / 2;
        if (xloc < 0) {
            xloc = 0;
        }
        return new Rectangle(xloc, maxWindow.y, wWidth, wHeight);
    }

    Dimension getExtraSize() {
        Insets insets = this.getInsets();
        int extraWidth = insets.left + insets.right + 10;
        int extraHeight = insets.top + insets.bottom + 10;
        if (extraHeight == 20) {
            extraHeight = 42;
        }
        int members = this.getComponentCount();
        for (int i = 1; i < members; ++i) {
            Component m = this.getComponent(i);
            Dimension d = m.getPreferredSize();
            extraHeight += d.height + 5;
            if (!IJ.debugMode) continue;
            IJ.log(i + "  " + d.height + " " + extraHeight);
        }
        return new Dimension(extraWidth, extraHeight);
    }

    @Override
    public Component add(Component comp) {
        comp = super.add(comp);
        this.maxBounds = this.getMaximumBounds();
        this.setMaximizedBounds(this.maxBounds);
        this.setMaxBoundsTime = System.currentTimeMillis();
        return comp;
    }

    public void maximize() {
        if (GenericDialog.getInstance() != null) {
            return;
        }
        Rectangle rect = this.getMaximumBounds();
        if (IJ.debugMode) {
            IJ.log("maximize: " + rect);
        }
        this.setLocationAndSize(rect.x, rect.y, rect.width, rect.height);
    }

    public void minimize() {
        if (IJ.debugMode) {
            IJ.log("minimize: " + this.unzoomWhenMinimizing);
        }
        if (this.unzoomWhenMinimizing) {
            this.ic.unzoom();
        }
        this.unzoomWhenMinimizing = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!Interpreter.isBatchMode() && this.ij != null && !this.ij.quitting() && this.imp != null) {
            if (IJ.debugMode) {
                IJ.log("focusGained: " + this.imp);
            }
            WindowManager.setCurrentWindow(this);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Roi roi;
        if (IJ.debugMode) {
            IJ.log("windowActivated: " + this.imp.getTitle());
        }
        if (IJ.isMacOSX()) {
            ImageWindow.setImageJMenuBar(this);
        }
        if (this.imp == null) {
            return;
        }
        ImageJ ij = IJ.getInstance();
        if (!(ij == null || this.closed || ij.quitting() || Interpreter.isBatchMode())) {
            WindowManager.setCurrentWindow(this);
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof PointRoi) {
            PointToolOptions.update();
        }
        if (this.imp.isComposite()) {
            Channels.updateChannels();
        }
        this.imp.setActivated();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.closed) {
            return;
        }
        if (this.ij != null) {
            WindowManager.setCurrentWindow(this);
            IJ.doCommand("Close");
        } else {
            this.dispose();
            WindowManager.removeWindow(this);
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        int oldState = e.getOldState();
        int newState = e.getNewState();
        if (IJ.debugMode) {
            IJ.log("windowStateChanged: " + oldState + " " + newState);
        }
        if ((oldState & 6) == 0 && (newState & 6) != 0) {
            this.maximize();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public synchronized void mouseWheelMoved(MouseWheelEvent e) {
        boolean ctrl;
        int rotation = e.getWheelRotation();
        int amount = e.getScrollAmount();
        boolean bl = ctrl = (e.getModifiers() & 2) != 0;
        if (IJ.debugMode) {
            IJ.log("mouseWheelMoved: " + e);
            IJ.log("  type: " + e.getScrollType());
            IJ.log("  ctrl: " + ctrl);
            IJ.log("  rotation: " + rotation);
            IJ.log("  amount: " + amount);
        }
        if (amount < 1) {
            amount = 1;
        }
        if (rotation == 0) {
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        Rectangle srcRect = this.ic.getSrcRect();
        int xstart = srcRect.x;
        int ystart = srcRect.y;
        if ((ctrl || IJ.shiftKeyDown()) && this.ic != null) {
            Point loc = this.ic.getCursorLoc();
            int x = this.ic.screenX(loc.x);
            int y = this.ic.screenY(loc.y);
            if (rotation < 0) {
                this.ic.zoomIn(x, y);
            } else {
                this.ic.zoomOut(x, y);
            }
            return;
        }
        if (IJ.spaceBarDown() || srcRect.height == height) {
            srcRect.x += rotation * amount * Math.max(width / 200, 1);
            if (srcRect.x < 0) {
                srcRect.x = 0;
            }
            if (srcRect.x + srcRect.width > width) {
                srcRect.x = width - srcRect.width;
            }
        } else {
            srcRect.y += rotation * amount * Math.max(height / 200, 1);
            if (srcRect.y < 0) {
                srcRect.y = 0;
            }
            if (srcRect.y + srcRect.height > height) {
                srcRect.y = height - srcRect.height;
            }
        }
        if (srcRect.x != xstart || srcRect.y != ystart) {
            this.ic.repaint();
        }
    }

    public void copy(boolean cut) {
        this.imp.copy(cut);
    }

    public void paste() {
        this.imp.paste();
    }

    public void mouseMoved(int x, int y) {
        this.imp.mouseMoved(x, y);
    }

    @Override
    public String toString() {
        return this.imp != null ? this.imp.getTitle() : "";
    }

    public static void centerNextImage() {
        centerOnScreen = true;
    }

    public static void setNextLocation(Point loc) {
        nextLocation = loc;
    }

    public static void setNextLocation(int x, int y) {
        nextLocation = new Point(x, y);
    }

    public void setLocationAndSize(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
        this.getCanvas().fitToWindow();
        this.pack();
    }

    public void setSliderHeight(int height) {
        this.sliderHeight = height;
    }

    public int getSliderHeight() {
        return this.sliderHeight;
    }

    public static void setImageJMenuBar(ImageWindow win) {
        MenuBar mb;
        ImageJ ij = IJ.getInstance();
        boolean setMenuBar = true;
        ImagePlus imp = win.getImagePlus();
        if (imp != null) {
            setMenuBar = imp.setIJMenuBar();
        }
        if ((mb = Menus.getMenuBar()) != null && mb == win.getMenuBar()) {
            setMenuBar = false;
        }
        setMenuBarTime = 0L;
        if (setMenuBar && ij != null && !ij.quitting() && !Interpreter.nonBatchMacroRunning()) {
            long time;
            IJ.wait(10);
            long t0 = System.currentTimeMillis();
            win.setMenuBar(mb);
            setMenuBarTime = time = System.currentTimeMillis() - t0;
            ++Menus.setMenuBarCount;
            if (IJ.debugMode) {
                IJ.log("setMenuBar: " + time + "ms (" + Menus.setMenuBarCount + ")");
            }
            if (time > 2000L) {
                Prefs.setIJMenuBar = false;
            }
        }
        if (imp != null) {
            imp.setIJMenuBar(true);
        }
    }
}

