/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageLayout;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotCanvas;
import ij.gui.PlotContentsDialog;
import ij.gui.PlotDialog;
import ij.gui.PlotMaker;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.RoiListener;
import ij.gui.TextRoi;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ItemListener,
ClipboardOwner,
ImageListener,
RoiListener,
Runnable {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    public static boolean saveXValues = true;
    public static boolean autoClose;
    public static boolean listValues;
    public static boolean interpolate;
    private static final int WIDTH = 530;
    private static final int HEIGHT = 300;
    private static final int FONT_SIZE = 12;
    public static int plotWidth;
    public static int plotHeight;
    public static int fontSize;
    public static boolean noGridLines;
    public static boolean noTicks;
    private static final String PREFS_WIDTH = "pp.width";
    private static final String PREFS_HEIGHT = "pp.height";
    private static final String PREFS_FONT_SIZE = "pp.fontsize";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private static final int NO_TICKS = 32;
    private static String moreButtonLabel;
    private static String dataButtonLabel;
    boolean wasActivated;
    private Button list;
    private Button data;
    private Button more;
    private Button live;
    private PopupMenu dataPopupMenu;
    private PopupMenu morePopupMenu;
    private static final int NUM_MENU_ITEMS = 18;
    private MenuItem[] menuItems = new MenuItem[18];
    private Label coordinates;
    private static String defaultDirectory;
    private static int options;
    private int defaultDigits = -1;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    private String blankLabel = "                       ";
    private PlotMaker plotMaker;
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    private Roi[] rangeArrowRois;
    private boolean rangeArrowsVisible;
    private int activeRangeArrow = -1;
    private static int SAVE;
    private static int COPY;
    private static int COPY_ALL;
    private static int ADD_FROM_TABLE;
    private static int ADD_FROM_PLOT;
    private static int ADD_FIT;
    private static int SET_RANGE;
    private static int PREV_RANGE;
    private static int RESET_RANGE;
    private static int FIT_RANGE;
    private static int ZOOM_SELECTION;
    private static int AXIS_OPTIONS;
    private static int LEGEND;
    private static int STYLE;
    private static int RESET_PLOT;
    private static int FREEZE;
    private static int HI_RESOLUTION;
    private static int PROFILE_PLOT_OPTIONS;
    private static int[] DISABLED_WHEN_FROZEN;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(PlotWindow.createImage(title, xLabel, yLabel, xValues, yValues));
        this.plot = staticPlot;
        ((PlotCanvas)this.getCanvas()).setPlot(this.plot);
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
    }

    public PlotWindow(ImagePlus imp, Plot plot) {
        super(imp);
        ((PlotCanvas)this.getCanvas()).setPlot(plot);
        this.plot = plot;
        this.draw();
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        ((PlotCanvas)this.getCanvas()).setPlot(plot);
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        staticPlot = new Plot(title, xLabel, yLabel, xValues, yValues);
        return new ImagePlus(title, staticPlot.getBlankProcessor());
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.plot.setLimits(xMin, xMax, yMin, yMax);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.plot.addPoints(x, y, shape);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addErrorBars(float[] errorBars) {
        this.plot.addErrorBars(errorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.plot.addLabel(x, y, label);
    }

    public void setColor(Color c) {
        this.plot.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.plot.setLineWidth(lineWidth);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel bottomPanel = new Panel();
        int hgap = IJ.isMacOSX() ? 1 : 5;
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        bottomPanel.add(this.list);
        bottomPanel.setLayout(new FlowLayout(2, hgap, 0));
        this.data = new Button(dataButtonLabel);
        this.data.addActionListener(this);
        bottomPanel.add(this.data);
        this.more = new Button(moreButtonLabel);
        this.more.addActionListener(this);
        bottomPanel.add(this.more);
        if (this.plot != null && this.plot.getPlotMaker() != null) {
            this.live = new Button("Live");
            this.live.addActionListener(this);
            bottomPanel.add(this.live);
        }
        this.coordinates = new Label(this.blankLabel);
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        this.coordinates.setBackground(new Color(220, 220, 220));
        bottomPanel.add(this.coordinates);
        this.add(bottomPanel);
        this.data.add(this.getDataPopupMenu());
        this.more.add(this.getMorePopupMenu());
        this.plot.draw();
        LayoutManager lm = this.getLayout();
        if (lm instanceof ImageLayout) {
            ((ImageLayout)lm).ignoreNonImageWidths(true);
        }
        this.pack();
        ImageProcessor ip = this.plot.getProcessor();
        boolean ipIsColor = ip instanceof ColorProcessor;
        boolean impIsColor = this.imp.getProcessor() instanceof ColorProcessor;
        if (ipIsColor != impIsColor) {
            this.imp.setProcessor(null, ip);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        } else {
            this.ic.requestFocus();
        }
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
        ((PlotCanvas)this.getCanvas()).setPlot(plot);
    }

    @Override
    public void dispose() {
        if (this.plot != null) {
            this.plot.dispose();
        }
        this.disableLivePlot();
        this.plot = null;
        this.plotMaker = null;
        this.srcImp = null;
        super.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        if (!this.wasActivated) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IJ.wait(50);
                    PlotWindow.this.wasActivated = true;
                }
            }).start();
        }
    }

    void updateMinimumSize() {
        if (this.plot == null) {
            return;
        }
        Dimension d1 = this.getExtraSize();
        Dimension d2 = this.plot.getMinimumSize();
        this.setMinimumSize(new Dimension(d1.width + d2.width, d1.height + d2.height));
    }

    PopupMenu getDataPopupMenu() {
        this.dataPopupMenu = new PopupMenu();
        this.menuItems[PlotWindow.SAVE] = this.addPopupItem(this.dataPopupMenu, "Save Data...");
        this.menuItems[PlotWindow.COPY] = this.addPopupItem(this.dataPopupMenu, "Copy 1st Data Set");
        this.menuItems[PlotWindow.COPY_ALL] = this.addPopupItem(this.dataPopupMenu, "Copy All Data");
        this.dataPopupMenu.addSeparator();
        this.menuItems[PlotWindow.ADD_FROM_TABLE] = this.addPopupItem(this.dataPopupMenu, "Add from Table...");
        this.menuItems[PlotWindow.ADD_FROM_PLOT] = this.addPopupItem(this.dataPopupMenu, "Add from Plot...");
        this.menuItems[PlotWindow.ADD_FIT] = this.addPopupItem(this.dataPopupMenu, "Add Fit...");
        return this.dataPopupMenu;
    }

    PopupMenu getMorePopupMenu() {
        this.morePopupMenu = new PopupMenu();
        this.menuItems[PlotWindow.SET_RANGE] = this.addPopupItem(this.morePopupMenu, "Set Range...");
        this.menuItems[PlotWindow.PREV_RANGE] = this.addPopupItem(this.morePopupMenu, "Previous Range");
        this.menuItems[PlotWindow.RESET_RANGE] = this.addPopupItem(this.morePopupMenu, "Reset Range");
        this.menuItems[PlotWindow.FIT_RANGE] = this.addPopupItem(this.morePopupMenu, "Set Range to Fit All");
        this.menuItems[PlotWindow.ZOOM_SELECTION] = this.addPopupItem(this.morePopupMenu, "Zoom to Selection");
        this.morePopupMenu.addSeparator();
        this.menuItems[PlotWindow.AXIS_OPTIONS] = this.addPopupItem(this.morePopupMenu, "Axis Options...");
        this.menuItems[PlotWindow.LEGEND] = this.addPopupItem(this.morePopupMenu, "Legend...");
        this.menuItems[PlotWindow.STYLE] = this.addPopupItem(this.morePopupMenu, "Contents Style...");
        this.menuItems[PlotWindow.RESET_PLOT] = this.addPopupItem(this.morePopupMenu, "Reset Format");
        this.menuItems[PlotWindow.FREEZE] = this.addPopupItem(this.morePopupMenu, "Freeze Plot", true);
        this.menuItems[PlotWindow.HI_RESOLUTION] = this.addPopupItem(this.morePopupMenu, "High-Resolution Plot...");
        this.morePopupMenu.addSeparator();
        this.menuItems[PlotWindow.PROFILE_PLOT_OPTIONS] = this.addPopupItem(this.morePopupMenu, "Plot Options...");
        return this.morePopupMenu;
    }

    MenuItem addPopupItem(PopupMenu popupMenu, String s) {
        return this.addPopupItem(popupMenu, s, false);
    }

    MenuItem addPopupItem(PopupMenu popupMenu, String s, boolean isCheckboxItem) {
        MenuItem mi = null;
        if (isCheckboxItem) {
            mi = new CheckboxMenuItem(s);
            ((CheckboxMenuItem)mi).addItemListener(this);
        } else {
            mi = new MenuItem(s);
            mi.addActionListener(this);
        }
        popupMenu.add(mi);
        return mi;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object b = e.getSource();
            if (b == this.live) {
                this.toggleLiveProfiling();
            } else if (b == this.list) {
                this.showList();
            } else if (b == this.data) {
                this.enableDisableMenuItems();
                this.dataPopupMenu.show((Component)b, 1, 1);
            } else if (b == this.more) {
                this.enableDisableMenuItems();
                this.morePopupMenu.show((Component)b, 1, 1);
            } else if (b == this.menuItems[SAVE]) {
                this.saveAsText();
            } else if (b == this.menuItems[COPY]) {
                this.copyToClipboard(false);
            } else if (b == this.menuItems[COPY_ALL]) {
                this.copyToClipboard(true);
            } else if (b == this.menuItems[ADD_FROM_TABLE]) {
                new PlotContentsDialog(this.plot, 2).showDialog(this);
            } else if (b == this.menuItems[ADD_FROM_PLOT]) {
                new PlotContentsDialog(this.plot, 1).showDialog(this);
            } else if (b == this.menuItems[ADD_FIT]) {
                new PlotContentsDialog(this.plot, 4).showDialog(this);
            } else if (b == this.menuItems[ZOOM_SELECTION]) {
                if (this.imp != null && this.imp.getRoi() != null && this.imp.getRoi().isArea()) {
                    this.plot.zoomToRect(this.imp.getRoi().getBounds());
                }
            } else if (b == this.menuItems[SET_RANGE]) {
                new PlotDialog(this.plot, 0).showDialog(this);
            } else if (b == this.menuItems[PREV_RANGE]) {
                this.plot.setPreviousMinMax();
            } else if (b == this.menuItems[RESET_RANGE]) {
                this.plot.setLimitsToDefaults(true);
            } else if (b == this.menuItems[FIT_RANGE]) {
                this.plot.setLimitsToFit(true);
            } else if (b == this.menuItems[AXIS_OPTIONS]) {
                new PlotDialog(this.plot, 1).showDialog(this);
            } else if (b == this.menuItems[LEGEND]) {
                new PlotDialog(this.plot, 2).showDialog(this);
            } else if (b == this.menuItems[STYLE]) {
                new PlotContentsDialog(this.plot, 0).showDialog(this);
            } else if (b == this.menuItems[RESET_PLOT]) {
                this.plot.setFont(0, Prefs.getInt(PREFS_FONT_SIZE, 12));
                this.plot.setAxisLabelFont(0, Prefs.getInt(PREFS_FONT_SIZE, 12));
                this.plot.setFormatFlags(Plot.getDefaultFlags());
                this.plot.setFrameSize(plotWidth, plotHeight);
                this.plot.updateImage();
            } else if (b == this.menuItems[HI_RESOLUTION]) {
                new PlotDialog(this.plot, 3).showDialog(this);
            } else if (b == this.menuItems[PROFILE_PLOT_OPTIONS]) {
                IJ.doCommand("Plots...");
            }
            this.ic.requestFocus();
        }
        catch (Exception ex) {
            IJ.handleException(ex);
        }
    }

    private void enableDisableMenuItems() {
        boolean frozen = this.plot.isFrozen();
        ((CheckboxMenuItem)this.menuItems[FREEZE]).setState(frozen);
        for (int i : DISABLED_WHEN_FROZEN) {
            this.menuItems[i].setEnabled(!frozen);
        }
        if (!PlotContentsDialog.tableWindowExists()) {
            this.menuItems[ADD_FROM_TABLE].setEnabled(false);
        }
        if (this.plot.getDataObjectDesignations().length == 0) {
            this.menuItems[ADD_FIT].setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.menuItems[FREEZE]) {
            boolean frozen = ((CheckboxMenuItem)this.menuItems[FREEZE]).getState();
            this.plot.setFrozen(frozen);
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.plot == null) {
            return;
        }
        if (this.coordinates != null) {
            String coords = this.plot.getCoordinates(x, y) + this.blankLabel;
            this.coordinates.setText(coords.substring(0, this.blankLabel.length()));
        }
        if (this.plot == null) {
            return;
        }
        if (x < this.plot.leftMargin || y > this.plot.topMargin + this.plot.frameHeight) {
            int i;
            if (!this.rangeArrowsVisible && !this.plot.isFrozen()) {
                this.showRangeArrows();
            }
            if (this.activeRangeArrow == 8) {
                this.coordinates.setText("Reset Range");
            } else if (this.activeRangeArrow == 9) {
                this.coordinates.setText("Full Range (Fit All)");
            } else if (this.activeRangeArrow >= 10) {
                this.coordinates.setText("Set limit...");
            }
            if (this.activeRangeArrow >= 0 && !this.rangeArrowRois[this.activeRangeArrow].contains(x, y)) {
                if (this.activeRangeArrow >= 10) {
                    this.rangeArrowRois[this.activeRangeArrow].setFillColor(new Color(235, 235, 235));
                } else {
                    this.rangeArrowRois[this.activeRangeArrow].setFillColor(Color.GRAY);
                }
                this.ic.repaint();
                this.activeRangeArrow = -1;
            }
            if (this.activeRangeArrow < 0 && (i = this.getRangeArrowIndex(x, y)) >= 0) {
                this.rangeArrowRois[i].setFillColor(Color.RED);
                this.activeRangeArrow = i;
                this.ic.repaint();
            }
        } else if (this.rangeArrowsVisible) {
            this.hideRangeArrows();
        }
    }

    void mouseExited(MouseEvent e) {
        if (this.rangeArrowsVisible) {
            this.hideRangeArrows();
        }
    }

    @Override
    public synchronized void mouseWheelMoved(MouseWheelEvent e) {
        boolean ctrl;
        if (this.plot.isFrozen() || !(this.ic instanceof PlotCanvas)) {
            super.mouseWheelMoved(e);
            return;
        }
        int rotation = e.getWheelRotation();
        int amount = e.getScrollAmount();
        if (e.getX() < this.plot.leftMargin || e.getX() > this.plot.leftMargin + this.plot.frameWidth) {
            return;
        }
        if (e.getY() < this.plot.topMargin || e.getY() > this.plot.topMargin + this.plot.frameHeight) {
            return;
        }
        boolean bl = ctrl = (e.getModifiers() & 2) != 0;
        if (amount < 1) {
            amount = 1;
        }
        if (rotation == 0) {
            return;
        }
        if (ctrl || IJ.shiftKeyDown()) {
            double zoomFactor = rotation < 0 ? Math.pow(2.0, 0.2) : Math.pow(0.5, 0.2);
            Point loc = this.ic.getCursorLoc();
            int x = this.ic.screenX(loc.x);
            int y = this.ic.screenY(loc.y);
            ((PlotCanvas)this.ic).zoom(x, y, zoomFactor);
        } else if (IJ.spaceBarDown()) {
            this.plot.scroll(rotation * amount * Math.max(this.ic.imageWidth / 50, 1), 0);
        } else {
            this.plot.scroll(0, rotation * amount * Math.max(this.ic.imageHeight / 50, 1));
        }
    }

    void showRangeArrows() {
        if (this.imp == null) {
            return;
        }
        this.hideRangeArrows();
        this.rangeArrowRois = new Roi[14];
        int i = 0;
        int height = this.imp.getHeight();
        int arrowH = this.plot.topMargin < 14 ? 6 : 8;
        float[] yP = new float[]{height - arrowH / 2, height - 3 * arrowH / 2, (float)(height - 5 * arrowH / 2) - 0.1f};
        for (float x : new float[]{this.plot.leftMargin, this.plot.leftMargin + this.plot.frameWidth}) {
            float[] x0 = new float[]{x - (float)(arrowH / 2), x - (float)(3 * arrowH / 2) - 0.1f, x - (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(x0, yP, 3, 2);
            float[] x1 = new float[]{x + (float)(arrowH / 2), x + (float)(3 * arrowH / 2) + 0.1f, x + (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(x1, yP, 3, 2);
        }
        float[] xP = new float[]{(float)(arrowH / 2) - 0.1f, 3 * arrowH / 2, (float)(5 * arrowH / 2) + 0.1f};
        for (float y : new float[]{this.plot.topMargin + this.plot.frameHeight, this.plot.topMargin}) {
            float[] y0 = new float[]{y + (float)(arrowH / 2), y + (float)(3 * arrowH / 2) + 0.1f, y + (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(xP, y0, 3, 2);
            float[] y1 = new float[]{y - (float)(arrowH / 2), y - (float)(3 * arrowH / 2) - 0.1f, y - (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(xP, y1, 3, 2);
        }
        Font theFont = new Font("SansSerif", 1, 13);
        TextRoi txtRoi = new TextRoi(1, height - 19, "\u2009R\u2009", theFont);
        this.rangeArrowRois[8] = txtRoi;
        TextRoi txtRoi2 = new TextRoi(20, height - 19, "\u2009F\u2009", theFont);
        this.rangeArrowRois[9] = txtRoi2;
        this.rangeArrowRois[10] = new Roi(this.plot.leftMargin - arrowH / 2 + 1, height - 5 * arrowH / 2, arrowH - 2, arrowH * 2);
        this.rangeArrowRois[11] = new Roi(this.plot.leftMargin + this.plot.frameWidth - arrowH / 2 + 1, height - 5 * arrowH / 2, arrowH - 2, arrowH * 2);
        this.rangeArrowRois[12] = new Roi(arrowH / 2, this.plot.topMargin + this.plot.frameHeight - arrowH / 2 + 1, arrowH * 2, arrowH - 2);
        this.rangeArrowRois[13] = new Roi(arrowH / 2, this.plot.topMargin - arrowH / 2 + 1, arrowH * 2, arrowH - 2);
        Overlay ovly = this.imp.getOverlay();
        if (ovly == null) {
            ovly = new Overlay();
        }
        for (Roi roi : this.rangeArrowRois) {
            if (roi instanceof PolygonRoi) {
                roi.setFillColor(Color.GRAY);
            } else if (roi instanceof TextRoi) {
                roi.setStrokeColor(Color.WHITE);
                roi.setFillColor(Color.GRAY);
            } else {
                roi.setFillColor(new Color(235, 235, 235));
            }
            ovly.add(roi);
        }
        this.imp.setOverlay(ovly);
        this.ic.repaint();
        this.rangeArrowsVisible = true;
    }

    void hideRangeArrows() {
        if (this.imp == null || this.rangeArrowRois == null) {
            return;
        }
        Overlay ovly = this.imp.getOverlay();
        if (ovly == null) {
            return;
        }
        for (Roi roi : this.rangeArrowRois) {
            ovly.remove(roi);
        }
        this.ic.repaint();
        this.rangeArrowsVisible = false;
        this.activeRangeArrow = -1;
    }

    int getRangeArrowIndex(int x, int y) {
        if (!this.rangeArrowsVisible) {
            return -1;
        }
        for (int i = 0; i < this.rangeArrowRois.length; ++i) {
            if (!this.rangeArrowRois[i].getBounds().contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    void showList() {
        ResultsTable rt = this.plot.getResultsTable(saveXValues);
        if (rt == null) {
            return;
        }
        rt.show("Plot Values");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public ResultsTable getResultsTable() {
        return this.plot.getResultsTable(saveXValues);
    }

    private String getValuesAsString() {
        ResultsTable rt = this.getResultsTable();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rt.size(); ++i) {
            sb.append(rt.getRowAsString(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    void saveAsText() {
        if (this.plot.getXValues() == null) {
            IJ.error("Plot has no data");
            return;
        }
        SaveDialog sd = new SaveDialog("Save as Text", "Values", Prefs.defaultResultsExtension());
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        ResultsTable rt = this.getResultsTable();
        try {
            rt.saveAs(directory + name);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard(boolean writeAllColumns) {
        float[] xValues = this.plot.getXValues();
        float[] yValues = this.plot.getYValues();
        if (xValues == null) {
            return;
        }
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter aw = new CharArrayWriter(10 * xValues.length);
        PrintWriter pw = new PrintWriter(aw);
        if (writeAllColumns) {
            ResultsTable rt = this.plot.getResultsTable(true);
            if (!Prefs.dontSaveHeaders) {
                String headings = rt.getColumnHeadings();
                pw.println(headings);
            }
            for (int i = 0; i < rt.size(); ++i) {
                pw.println(rt.getRowAsString(i));
            }
        } else {
            int xdigits = 0;
            if (saveXValues) {
                xdigits = Plot.getPrecision(xValues);
            }
            int ydigits = Plot.getPrecision(yValues);
            for (int i = 0; i < Math.min(xValues.length, yValues.length); ++i) {
                if (saveXValues) {
                    pw.println(IJ.d2s(xValues[i], xdigits) + "\t" + IJ.d2s(yValues[i], ydigits));
                    continue;
                }
                pw.println(IJ.d2s(yValues[i], ydigits));
            }
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public float[] getXValues() {
        return this.plot.getXValues();
    }

    public float[] getYValues() {
        return this.plot.getYValues();
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        if (this.imp != null) {
            if (this.ic instanceof PlotCanvas) {
                ((PlotCanvas)this.ic).setPlot(plot);
            }
            this.imp.setProcessor(null, plot.getProcessor());
            plot.setImagePlus(this.imp);
        }
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if (plotWidth != 530 || plotHeight != 300) {
            prefs.put(PREFS_WIDTH, Integer.toString(plotWidth));
            prefs.put(PREFS_HEIGHT, Integer.toString(plotHeight));
            prefs.put(PREFS_FONT_SIZE, Integer.toString(fontSize));
        }
        int options = 0;
        if (autoClose && !listValues) {
            options |= 2;
        }
        if (listValues) {
            options |= 4;
        }
        if (!interpolate) {
            options |= 8;
        }
        if (noGridLines) {
            options |= 0x10;
        }
        if (noTicks) {
            options |= 0x20;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    private void toggleLiveProfiling() {
        boolean liveMode;
        boolean bl = liveMode = this.bgThread != null;
        if (liveMode) {
            this.disableLivePlot();
        } else {
            this.enableLivePlot();
        }
    }

    private void enableLivePlot() {
        if (this.plotMaker == null) {
            PlotMaker plotMaker = this.plotMaker = this.plot != null ? this.plot.getPlotMaker() : null;
        }
        if (this.plotMaker == null) {
            return;
        }
        this.srcImp = this.plotMaker.getSourceImage();
        if (this.srcImp == null) {
            return;
        }
        if (this.bgThread == null) {
            this.bgThread = new Thread((Runnable)this, "Live Plot");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.doUpdate = true;
            this.bgThread.start();
        }
        if (IJ.debugMode) {
            IJ.log("PlotWindow.createListeners");
        }
        ImagePlus.addImageListener(this);
        Roi.addRoiListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 1, font.getSize()));
        this.live.setForeground(Color.red);
    }

    private void disableLivePlot() {
        if (IJ.debugMode) {
            IJ.log("PlotWindow.disableLivePlot: " + this.srcImp);
        }
        if (this.srcImp == null) {
            return;
        }
        if (this.bgThread != null) {
            this.bgThread.interrupt();
        }
        this.bgThread = null;
        ImagePlus.removeImageListener(this);
        Roi.removeRoiListener(this);
        if (this.live != null) {
            Font font = this.live.getFont();
            this.live.setFont(new Font(font.getName(), 0, font.getSize()));
            this.live.setForeground(Color.black);
        }
    }

    @Override
    public synchronized void roiModified(ImagePlus img, int id) {
        if (IJ.debugMode) {
            IJ.log("PlotWindow.roiModified: " + img + "  " + id);
        }
        if (img == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    @Override
    public void imageOpened(ImagePlus imp) {
    }

    @Override
    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    @Override
    public void imageClosed(ImagePlus imp) {
        if (imp == this.srcImp || imp == this.imp) {
            this.disableLivePlot();
            this.srcImp = null;
            this.plotMaker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Plot plot;
            IJ.wait(50);
            Plot plot2 = plot = this.plotMaker != null ? this.plotMaker.getPlot() : null;
            if (this.doUpdate && plot != null && plot.getNumPlotObjects() > 0) {
                plot.useTemplate(this.plot, this.plot.templateFlags);
                plot.setPlotMaker(this.plotMaker);
                this.plot = plot;
                ((PlotCanvas)this.ic).setPlot(plot);
                ImageProcessor ip = plot.getProcessor();
                if (ip != null && this.imp != null) {
                    this.imp.setProcessor(null, ip);
                    plot.setImagePlus(this.imp);
                }
            }
            PlotWindow plotWindow = this;
            synchronized (plotWindow) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    public Plot getPlot() {
        return this.plot;
    }

    public static void freeze() {
        Window win = WindowManager.getActiveWindow();
        if (win != null && win instanceof PlotWindow) {
            ((PlotWindow)win).getPlot().setFrozen(true);
        }
    }

    static {
        plotWidth = 530;
        plotHeight = 300;
        fontSize = 12;
        moreButtonLabel = "More \u00bb";
        dataButtonLabel = "Data \u00bb";
        defaultDirectory = null;
        options = Prefs.getInt(OPTIONS, 1);
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PREFS_WIDTH, 530);
        plotHeight = Prefs.getInt(PREFS_HEIGHT, 300);
        fontSize = Prefs.getInt(PREFS_FONT_SIZE, 12);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
        noTicks = (options & 0x20) != 0;
        SAVE = 0;
        COPY = 1;
        COPY_ALL = 2;
        ADD_FROM_TABLE = 3;
        ADD_FROM_PLOT = 4;
        ADD_FIT = 5;
        SET_RANGE = 6;
        PREV_RANGE = 7;
        RESET_RANGE = 8;
        FIT_RANGE = 9;
        ZOOM_SELECTION = 10;
        AXIS_OPTIONS = 11;
        LEGEND = 12;
        STYLE = 13;
        RESET_PLOT = 14;
        FREEZE = 15;
        HI_RESOLUTION = 16;
        PROFILE_PLOT_OPTIONS = 17;
        DISABLED_WHEN_FROZEN = new int[]{ADD_FROM_TABLE, ADD_FROM_PLOT, ADD_FIT, SET_RANGE, PREV_RANGE, RESET_RANGE, FIT_RANGE, ZOOM_SELECTION, AXIS_OPTIONS, LEGEND, STYLE, RESET_PLOT};
    }
}

