/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class ShapeRoi
extends Roi {
    static final int NO_TYPE = 128;
    static final double MAXERROR = 0.001;
    static final double FLATNESS = 0.1;
    private static final int MAXPOLY = 10;
    private static final int OR = 0;
    private static final int AND = 1;
    private static final int XOR = 2;
    private static final int NOT = 3;
    private static final double SHAPE_TO_ROI = -1.0;
    private Shape shape;
    private double maxerror = 0.001;
    private double flatness = 0.1;
    private int maxPoly = 10;
    private boolean flatten;
    private boolean forceTrace = false;
    private boolean forceAngle = false;
    private Vector savedRois;
    private static Stroke defaultStroke = new BasicStroke();
    private double paPerim;

    public ShapeRoi(Roi r) {
        this(r, 0.1, 0.001, false, false, false, 10);
    }

    public ShapeRoi(Shape s) {
        super(s.getBounds());
        AffineTransform at = new AffineTransform();
        at.translate(-this.x, -this.y);
        this.shape = new GeneralPath(at.createTransformedShape(s));
        this.type = 9;
    }

    public ShapeRoi(int x, int y, Shape s) {
        super(x, y, s.getBounds().width, s.getBounds().height);
        this.shape = new GeneralPath(s);
        this.type = 9;
    }

    ShapeRoi(Roi r, double flatness, double maxerror, boolean forceAngle, boolean forceTrace, boolean flatten, int maxPoly) {
        super(r.startX, r.startY, r.width, r.height);
        this.type = 9;
        this.flatness = flatness;
        this.maxerror = maxerror;
        this.forceAngle = forceAngle;
        this.forceTrace = forceTrace;
        this.maxPoly = maxPoly;
        this.flatten = flatten;
        this.shape = this.roiToShape((Roi)r.clone());
    }

    public ShapeRoi(float[] shapeArray) {
        super(0, 0, null);
        this.shape = this.makeShapeFromArray(shapeArray);
        Rectangle r = this.shape.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.state = 3;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        AffineTransform at = new AffineTransform();
        at.translate(-this.x, -this.y);
        this.shape = new GeneralPath(at.createTransformedShape(this.shape));
        this.flatness = 0.1;
        this.maxerror = 0.001;
        this.maxPoly = 10;
        this.flatten = false;
        this.type = 9;
    }

    @Override
    public synchronized Object clone() {
        ShapeRoi sr = (ShapeRoi)super.clone();
        sr.type = 9;
        sr.flatness = this.flatness;
        sr.maxerror = this.maxerror;
        sr.forceAngle = this.forceAngle;
        sr.forceTrace = this.forceTrace;
        sr.setShape(ShapeRoi.cloneShape(this.shape));
        return sr;
    }

    static Shape cloneShape(Shape rhs) {
        if (rhs == null) {
            return null;
        }
        if (rhs instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)((Rectangle2D.Double)rhs).clone();
        }
        if (rhs instanceof Ellipse2D.Double) {
            return (Ellipse2D.Double)((Ellipse2D.Double)rhs).clone();
        }
        if (rhs instanceof Line2D.Double) {
            return (Line2D.Double)((Line2D.Double)rhs).clone();
        }
        if (rhs instanceof Polygon) {
            return new Polygon(((Polygon)rhs).xpoints, ((Polygon)rhs).ypoints, ((Polygon)rhs).npoints);
        }
        if (rhs instanceof GeneralPath) {
            return (GeneralPath)((GeneralPath)rhs).clone();
        }
        return new GeneralPath();
    }

    public ShapeRoi or(ShapeRoi sr) {
        return this.unaryOp(sr, 0);
    }

    public ShapeRoi and(ShapeRoi sr) {
        return this.unaryOp(sr, 1);
    }

    public ShapeRoi xor(ShapeRoi sr) {
        return this.unaryOp(sr, 2);
    }

    public ShapeRoi not(ShapeRoi sr) {
        return this.unaryOp(sr, 3);
    }

    ShapeRoi unaryOp(ShapeRoi sr, int op) {
        AffineTransform at = new AffineTransform();
        at.translate(this.x, this.y);
        Area a1 = new Area(at.createTransformedShape(this.getShape()));
        at = new AffineTransform();
        at.translate(sr.x, sr.y);
        Area a2 = new Area(at.createTransformedShape(sr.getShape()));
        try {
            switch (op) {
                case 0: {
                    a1.add(a2);
                    break;
                }
                case 1: {
                    a1.intersect(a2);
                    break;
                }
                case 2: {
                    a1.exclusiveOr(a2);
                    break;
                }
                case 3: {
                    a1.subtract(a2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle r = a1.getBounds();
        at = new AffineTransform();
        at.translate(-r.x, -r.y);
        this.setShape(new GeneralPath(at.createTransformedShape(a1)));
        this.x = r.x;
        this.y = r.y;
        this.cachedMask = null;
        return this;
    }

    private Shape roiToShape(Roi roi) {
        Shape shape = null;
        Rectangle r = roi.getBounds();
        int[] xCoords = null;
        int[] yCoords = null;
        int nCoords = 0;
        switch (roi.getType()) {
            case 5: {
                Line line = (Line)roi;
                shape = new Line2D.Double(line.x1 - r.x, line.y1 - r.y, line.x2 - r.x, line.y2 - r.y);
                break;
            }
            case 0: {
                int arcSize = roi.getCornerDiameter();
                if (arcSize > 0) {
                    shape = new RoundRectangle2D.Float(0.0f, 0.0f, r.width, r.height, arcSize, arcSize);
                    break;
                }
                shape = new Rectangle2D.Double(0.0, 0.0, r.width, r.height);
                break;
            }
            case 1: {
                Polygon p = roi.getPolygon();
                int i = 0;
                while (i < p.npoints) {
                    int n = i;
                    p.xpoints[n] = p.xpoints[n] - r.x;
                    int n2 = i++;
                    p.ypoints[n2] = p.ypoints[n2] - r.y;
                }
                shape = new Polygon(p.xpoints, p.ypoints, p.npoints);
                break;
            }
            case 2: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new Polygon(xCoords, yCoords, nCoords);
                break;
            }
            case 3: 
            case 4: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(0, nCoords);
                ((GeneralPath)shape).moveTo(xCoords[0], yCoords[0]);
                for (int i = 1; i < nCoords; ++i) {
                    ((GeneralPath)shape).lineTo(xCoords[i], yCoords[i]);
                }
                ((GeneralPath)shape).closePath();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nCoords = ((PolygonRoi)roi).getNCoordinates();
                xCoords = ((PolygonRoi)roi).getXCoordinates();
                yCoords = ((PolygonRoi)roi).getYCoordinates();
                shape = new GeneralPath(1, nCoords);
                ((GeneralPath)shape).moveTo(xCoords[0], yCoords[0]);
                for (int i = 1; i < nCoords; ++i) {
                    ((GeneralPath)shape).lineTo(xCoords[i], yCoords[i]);
                }
                break;
            }
            case 10: {
                ImageProcessor mask = roi.getMask();
                byte[] maskPixels = (byte[])mask.getPixels();
                Rectangle maskBounds = roi.getBounds();
                int maskWidth = mask.getWidth();
                Area area = new Area();
                for (int y = 0; y < mask.getHeight(); ++y) {
                    int yOffset = y * maskWidth;
                    for (int x = 0; x < maskWidth; ++x) {
                        if (maskPixels[x + yOffset] == 0) continue;
                        area.add(new Area(new Rectangle(x + maskBounds.x, y + maskBounds.y, 1, 1)));
                    }
                }
                shape = area;
                break;
            }
            case 9: {
                shape = ShapeRoi.cloneShape(((ShapeRoi)roi).getShape());
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        if (shape != null) {
            this.x = roi.x;
            this.y = roi.y;
            Rectangle bounds = shape.getBounds();
            this.width = bounds.width;
            this.height = bounds.height;
            this.startX = this.x;
            this.startY = this.y;
        }
        return shape;
    }

    Shape makeShapeFromArray(float[] array) {
        int len;
        if (array == null) {
            return null;
        }
        GeneralPath s = new GeneralPath(0);
        int index = 0;
        float[] seg = new float[7];
        block7: while ((len = this.getSegment(array, seg, index)) >= 0) {
            index += len;
            int type = (int)seg[0];
            switch (type) {
                case 0: {
                    s.moveTo(seg[1], seg[2]);
                    continue block7;
                }
                case 1: {
                    s.lineTo(seg[1], seg[2]);
                    continue block7;
                }
                case 2: {
                    s.quadTo(seg[1], seg[2], seg[3], seg[4]);
                    continue block7;
                }
                case 3: {
                    s.curveTo(seg[1], seg[2], seg[3], seg[4], seg[5], seg[6]);
                    continue block7;
                }
                case 4: {
                    s.closePath();
                    continue block7;
                }
            }
        }
        return s;
    }

    private int getSegment(float[] array, float[] seg, int index) {
        int len = array.length;
        if (index >= len) {
            return -1;
        }
        seg[0] = array[index++];
        int type = (int)seg[0];
        if (type == 4) {
            return 1;
        }
        if (index >= len) {
            return -1;
        }
        seg[1] = array[index++];
        if (index >= len) {
            return -1;
        }
        seg[2] = array[index++];
        if (type == 0 || type == 1) {
            return 3;
        }
        if (index >= len) {
            return -1;
        }
        seg[3] = array[index++];
        if (index >= len) {
            return -1;
        }
        seg[4] = array[index++];
        if (type == 2) {
            return 5;
        }
        if (index >= len) {
            return -1;
        }
        seg[5] = array[index++];
        if (index >= len) {
            return -1;
        }
        seg[6] = array[index++];
        if (type == 3) {
            return 7;
        }
        return -1;
    }

    void saveRoi(Roi roi) {
        if (this.savedRois == null) {
            this.savedRois = new Vector();
        }
        this.savedRois.addElement(roi);
    }

    public Roi[] getRois() {
        Roi r;
        if (this.shape == null) {
            return new Roi[0];
        }
        if (this.savedRois != null) {
            return this.getSavedRois();
        }
        Vector<Roi> rois = new Vector<Roi>();
        if (this.shape instanceof Rectangle2D.Double) {
            r = new Roi((int)((Rectangle2D.Double)this.shape).getX(), (int)((Rectangle2D.Double)this.shape).getY(), (int)((Rectangle2D.Double)this.shape).getWidth(), (int)((Rectangle2D.Double)this.shape).getHeight());
            rois.addElement(r);
        } else if (this.shape instanceof Ellipse2D.Double) {
            r = new OvalRoi((int)((Ellipse2D.Double)this.shape).getX(), (int)((Ellipse2D.Double)this.shape).getY(), (int)((Ellipse2D.Double)this.shape).getWidth(), (int)((Ellipse2D.Double)this.shape).getHeight());
            rois.addElement(r);
        } else if (this.shape instanceof Line2D.Double) {
            r = new Line((int)((Line2D.Double)this.shape).getX1(), (int)((Line2D.Double)this.shape).getY1(), (int)((Line2D.Double)this.shape).getX2(), (int)((Line2D.Double)this.shape).getY2());
            rois.addElement(r);
        } else if (this.shape instanceof Polygon) {
            r = new PolygonRoi(((Polygon)this.shape).xpoints, ((Polygon)this.shape).ypoints, ((Polygon)this.shape).npoints, 2);
            rois.addElement(r);
        } else if (this.shape instanceof GeneralPath) {
            PathIterator pIter = this.flatten ? this.getFlatteningPathIterator(this.shape, this.flatness) : this.shape.getPathIterator(new AffineTransform());
            this.parsePath(pIter, null, null, rois, null);
        }
        Object[] array = new Roi[rois.size()];
        rois.copyInto(array);
        return array;
    }

    Roi[] getSavedRois() {
        Object[] array = new Roi[this.savedRois.size()];
        this.savedRois.copyInto(array);
        return array;
    }

    public Roi shapeToRoi() {
        Vector rois;
        double[] params;
        if (this.shape == null || !(this.shape instanceof GeneralPath)) {
            return null;
        }
        PathIterator pIter = this.shape.getPathIterator(new AffineTransform());
        if (!this.parsePath(pIter, params = new double[]{-1.0}, null, rois = new Vector(), null)) {
            return null;
        }
        if (rois.size() == 1) {
            return (Roi)rois.elementAt(0);
        }
        return null;
    }

    private int guessType(int segments, boolean linesOnly, boolean curvesOnly, boolean closed) {
        closed = true;
        int roiType = 0;
        if (linesOnly) {
            switch (segments) {
                case 0: {
                    roiType = 128;
                    break;
                }
                case 1: {
                    roiType = 128;
                    break;
                }
                case 2: {
                    roiType = closed ? 128 : 5;
                    break;
                }
                case 3: {
                    roiType = closed ? 2 : (this.forceAngle ? 8 : 6);
                    break;
                }
                case 4: {
                    roiType = closed ? 0 : 6;
                    break;
                }
                default: {
                    if (segments <= 10) {
                        roiType = closed ? 2 : 6;
                        break;
                    }
                    roiType = closed ? (this.forceTrace ? 4 : 3) : 7;
                    break;
                }
            }
        } else {
            roiType = segments >= 2 ? 9 : 128;
        }
        return roiType;
    }

    private Roi createRoi(Vector xCoords, Vector yCoords, int roiType) {
        if (roiType == 128) {
            return null;
        }
        Roi roi = null;
        if (xCoords.size() != yCoords.size() || xCoords.size() == 0) {
            return null;
        }
        int[] xPoints = new int[xCoords.size()];
        int[] yPoints = new int[yCoords.size()];
        for (int i = 0; i < xPoints.length; ++i) {
            xPoints[i] = (Integer)xCoords.elementAt(i) + this.x;
            yPoints[i] = (Integer)yCoords.elementAt(i) + this.y;
        }
        int startX = 0;
        int startY = 0;
        int width = 0;
        int height = 0;
        switch (roiType) {
            case 9: {
                roi = this;
                break;
            }
            case 1: {
                startX = xPoints[xPoints.length - 4];
                startY = yPoints[yPoints.length - 3];
                width = this.max(xPoints) - this.min(xPoints);
                height = this.max(yPoints) - this.min(yPoints);
                roi = new OvalRoi(startX, startY, width, height);
                break;
            }
            case 0: {
                startX = xPoints[0];
                startY = yPoints[0];
                width = this.max(xPoints) - this.min(xPoints);
                height = this.max(yPoints) - this.min(yPoints);
                roi = new Roi(startX, startY, width, height);
                break;
            }
            case 5: {
                roi = new Line(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                break;
            }
            default: {
                int n = xPoints.length;
                roi = new PolygonRoi(xPoints, yPoints, n, roiType);
                if (roiType != 3) break;
                double length = ((Roi)roi).getLength();
                double mag = this.ic != null ? this.ic.getMagnification() : 1.0;
                if (!((length *= mag) / (double)n >= 15.0)) break;
                roi = new PolygonRoi(xPoints, yPoints, n, 2);
            }
        }
        return roi;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null) {
            return false;
        }
        return this.shape.contains(x - this.x, y - this.y);
    }

    @Override
    public double[] getFeretValues() {
        Roi[] rois = this.getRois();
        if (rois != null && rois.length == 1) {
            rois[0].setImage(this.imp);
            return rois[0].getFeretValues();
        }
        double min = Double.MAX_VALUE;
        double diameter = 0.0;
        double angle = 0.0;
        boolean p1 = false;
        boolean p2 = false;
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        Shape shape = this.getShape();
        Shape s = null;
        Rectangle2D r = shape.getBounds2D();
        double cx = r.getX() + r.getWidth() / 2.0;
        double cy = r.getY() + r.getHeight() / 2.0;
        AffineTransform at = new AffineTransform();
        if (pw != ph) {
            at.scale(1.0, ph / pw);
        }
        at.translate(-cx, -cy);
        double angleInc = 0.5;
        AffineTransform rotator = AffineTransform.getRotateInstance(angleInc * Math.PI / 180.0);
        for (double rotAngle = 0.0; rotAngle < 90.0; rotAngle += angleInc) {
            if (rotAngle > 0.0) {
                at.preConcatenate(rotator);
            }
            if ((r = (s = at.createTransformedShape(shape)).getBounds2D()).getWidth() > diameter) {
                diameter = r.getWidth();
                angle = rotAngle;
            }
            if (r.getHeight() > diameter) {
                diameter = r.getHeight();
                angle = rotAngle + 90.0;
            }
            double min2 = Math.min(r.getWidth(), r.getHeight());
            min = Math.min(min, min2);
        }
        double[] a = new double[]{diameter *= pw, angle, min *= pw, 0.0, 0.0};
        return a;
    }

    @Override
    public double getLength() {
        if (this.width == 0 && this.height == 0) {
            return 0.0;
        }
        if (this.paPerim > 0.0) {
            return this.paPerim;
        }
        double length = 0.0;
        Roi[] rois = this.getRois();
        ImagePlus imp2 = this.getImage();
        if (rois != null) {
            for (int i = 0; i < rois.length; ++i) {
                Roi roi = rois[i];
                if (roi instanceof ShapeRoi) {
                    return 0.0;
                }
                roi.setImage(imp2);
                length += roi.getLength();
                roi.setImage(null);
            }
        }
        return length;
    }

    FlatteningPathIterator getFlatteningPathIterator(Shape s, double fl) {
        return (FlatteningPathIterator)s.getPathIterator(new AffineTransform(), fl);
    }

    double cplength(CubicCurve2D.Double c) {
        double result = Math.sqrt(Math.pow(c.ctrlx1 - c.x1, 2.0) + Math.pow(c.ctrly1 - c.y1, 2.0));
        result += Math.sqrt(Math.pow(c.ctrlx2 - c.ctrlx1, 2.0) + Math.pow(c.ctrly2 - c.ctrly1, 2.0));
        return result += Math.sqrt(Math.pow(c.x2 - c.ctrlx2, 2.0) + Math.pow(c.y2 - c.ctrly2, 2.0));
    }

    double qplength(QuadCurve2D.Double c) {
        double result = Math.sqrt(Math.pow(c.ctrlx - c.x1, 2.0) + Math.pow(c.ctrly - c.y1, 2.0));
        return result += Math.sqrt(Math.pow(c.x2 - c.ctrlx, 2.0) + Math.pow(c.y2 - c.ctrly, 2.0));
    }

    double cclength(CubicCurve2D.Double c) {
        return Math.sqrt(Math.pow(c.x2 - c.x1, 2.0) + Math.pow(c.y2 - c.y1, 2.0));
    }

    double qclength(QuadCurve2D.Double c) {
        return Math.sqrt(Math.pow(c.x2 - c.x1, 2.0) + Math.pow(c.y2 - c.y1, 2.0));
    }

    double cBezLength(CubicCurve2D.Double c) {
        double l = 0.0;
        double cl = this.cclength(c);
        double pl = this.cplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            CubicCurve2D.Double[] cc = this.cBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.cBezLength(cc[i]);
            }
            return l;
        }
        l = 0.5 * pl + 0.5 * cl;
        return l;
    }

    double qBezLength(QuadCurve2D.Double c) {
        double l = 0.0;
        double cl = this.qclength(c);
        double pl = this.qplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            QuadCurve2D.Double[] cc = this.qBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.qBezLength(cc[i]);
            }
            return l;
        }
        l = (2.0 * pl + cl) / 3.0;
        return l;
    }

    CubicCurve2D.Double[] cBezSplit(CubicCurve2D.Double c) {
        CubicCurve2D.Double[] cc = new CubicCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new CubicCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    QuadCurve2D.Double[] qBezSplit(QuadCurve2D.Double c) {
        QuadCurve2D.Double[] cc = new QuadCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new QuadCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    void scaleCoords(double[] c, double pw, double ph) {
        int k = c.length / 2;
        if (2 * k != c.length) {
            return;
        }
        for (int i = 0; i < c.length; i += 2) {
            int n = i;
            c[n] = c[n] * pw;
            int n2 = i + 1;
            c[n2] = c[n2] * ph;
        }
    }

    Vector parseSegments(PathIterator pI) {
        Vector v = new Vector();
        if (this.parsePath(pI, null, v, null, null)) {
            return v;
        }
        return null;
    }

    public float[] getShapeAsArray() {
        Vector h;
        Vector s;
        if (this.shape == null) {
            return null;
        }
        PathIterator pIt = this.shape.getPathIterator(new AffineTransform());
        if (!this.parsePath(pIt, null, s = new Vector(), null, h = new Vector())) {
            return null;
        }
        float[] result = new float[7 * s.size()];
        boolean k = false;
        int j = 0;
        int index = 0;
        block6: for (int i = 0; i < s.size(); ++i) {
            int segType = (Integer)s.elementAt(i);
            switch (segType) {
                case 0: 
                case 1: {
                    result[index++] = segType;
                    Point2D.Double p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    continue block6;
                }
                case 2: {
                    result[index++] = segType;
                    Point2D.Double p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    continue block6;
                }
                case 3: {
                    result[index++] = segType;
                    Point2D.Double p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    p = (Point2D.Double)h.elementAt(j++);
                    result[index++] = (float)p.getX() + (float)this.x;
                    result[index++] = (float)p.getY() + (float)this.y;
                    continue block6;
                }
                case 4: {
                    result[index++] = segType;
                    continue block6;
                }
            }
        }
        float[] result2 = new float[index];
        System.arraycopy(result, 0, result2, 0, result2.length);
        return result2;
    }

    boolean parsePath(PathIterator pIter, double[] params, Vector segments, Vector rois, Vector handles) {
        if (pIter == null || pIter.isDone()) {
            return false;
        }
        boolean result = true;
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        Vector<Integer> xCoords = new Vector<Integer>();
        Vector<Integer> yCoords = new Vector<Integer>();
        if (segments == null) {
            segments = new Vector<Integer>();
        }
        if (handles == null) {
            handles = new Vector<Point2D.Double>();
        }
        if (params == null) {
            params = new double[1];
        }
        boolean shapeToRoi = params[0] == -1.0;
        int subPaths = 0;
        int count = 0;
        int roiType = 0;
        boolean closed = false;
        boolean linesOnly = true;
        boolean curvesOnly = true;
        double sX = Double.NaN;
        double sY = Double.NaN;
        double x0 = Double.NaN;
        double y0 = Double.NaN;
        double usX = Double.NaN;
        double usY = Double.NaN;
        double ux0 = Double.NaN;
        double uy0 = Double.NaN;
        double pathLength = 0.0;
        boolean done = false;
        while (!done) {
            Roi r;
            double[] coords = new double[6];
            double[] ucoords = new double[6];
            int segType = pIter.currentSegment(coords);
            segments.add(new Integer(segType));
            ++count;
            System.arraycopy(coords, 0, ucoords, 0, coords.length);
            this.scaleCoords(coords, pw, ph);
            switch (segType) {
                case 0: {
                    if (subPaths > 0) {
                        boolean bl = closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                        if (closed && (int)ux0 != (int)usX && (int)uy0 != (int)usY) {
                            xCoords.add(new Integer((Integer)xCoords.elementAt(0)));
                            yCoords.add(new Integer((Integer)yCoords.elementAt(0)));
                        }
                        if (rois != null && (r = this.createRoi(xCoords, yCoords, roiType = this.guessType(count, linesOnly, curvesOnly, closed))) != null) {
                            rois.addElement(r);
                        }
                        xCoords = new Vector();
                        yCoords = new Vector();
                        count = 1;
                    }
                    ++subPaths;
                    usX = ucoords[0];
                    usY = ucoords[1];
                    ux0 = ucoords[0];
                    uy0 = ucoords[1];
                    sX = coords[0];
                    sY = coords[1];
                    x0 = coords[0];
                    y0 = coords[1];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    xCoords.add(new Integer((int)ucoords[0]));
                    yCoords.add(new Integer((int)ucoords[1]));
                    closed = false;
                    break;
                }
                case 1: {
                    linesOnly &= true;
                    curvesOnly &= false;
                    pathLength += Math.sqrt(Math.pow(y0 - coords[1], 2.0) + Math.pow(x0 - coords[0], 2.0));
                    ux0 = ucoords[0];
                    uy0 = ucoords[1];
                    x0 = coords[0];
                    y0 = coords[1];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    xCoords.add(new Integer((int)ucoords[0]));
                    yCoords.add(new Integer((int)ucoords[1]));
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 2: {
                    linesOnly &= false;
                    curvesOnly &= true;
                    Shape curve = new QuadCurve2D.Double(x0, y0, coords[0], coords[2], coords[2], coords[3]);
                    pathLength += this.qBezLength((QuadCurve2D.Double)curve);
                    ux0 = ucoords[2];
                    uy0 = ucoords[3];
                    x0 = coords[2];
                    y0 = coords[3];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    handles.add(new Point2D.Double(ucoords[2], ucoords[3]));
                    xCoords.add(new Integer((int)ucoords[2]));
                    yCoords.add(new Integer((int)ucoords[3]));
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 3: {
                    linesOnly &= false;
                    curvesOnly &= true;
                    Shape curve = new CubicCurve2D.Double(x0, y0, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    pathLength += this.cBezLength((CubicCurve2D.Double)curve);
                    ux0 = ucoords[4];
                    uy0 = ucoords[5];
                    x0 = coords[4];
                    y0 = coords[5];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    handles.add(new Point2D.Double(ucoords[2], ucoords[3]));
                    handles.add(new Point2D.Double(ucoords[4], ucoords[5]));
                    xCoords.add(new Integer((int)ucoords[4]));
                    yCoords.add(new Integer((int)ucoords[5]));
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 4: {
                    if ((int)ux0 != (int)usX && (int)uy0 != (int)usY) {
                        pathLength += Math.sqrt(Math.pow(x0 - sX, 2.0) + Math.pow(y0 - sY, 2.0));
                    }
                    closed = true;
                    break;
                }
            }
            pIter.next();
            done = pIter.isDone() || shapeToRoi && rois != null && rois.size() == 1;
            if (!done) continue;
            if (closed && (int)x0 != (int)sX && (int)y0 != (int)sY) {
                xCoords.add(new Integer((Integer)xCoords.elementAt(0)));
                yCoords.add(new Integer((Integer)yCoords.elementAt(0)));
            }
            if (rois == null || (r = this.createRoi(xCoords, yCoords, roiType = shapeToRoi ? 4 : this.guessType(count + 1, linesOnly, curvesOnly, closed))) == null) continue;
            rois.addElement(r);
        }
        params[0] = pathLength;
        return result;
    }

    @Override
    public void draw(Graphics g) {
        boolean isActiveOverlayRoi;
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean bl = isActiveOverlayRoi = !this.overlay && this.isActiveOverlayRoi();
        if (isActiveOverlayRoi) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        g.setColor(color);
        AffineTransform aTx = ((Graphics2D)g).getDeviceConfiguration().getDefaultTransform();
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null && !isActiveOverlayRoi) {
            g2d.setStroke(this.ic != null && this.ic.getCustomRoi() || this.isCursor() ? this.stroke : this.getScaledStroke());
        }
        this.mag = this.getMagnification();
        int basex = 0;
        int basey = 0;
        if (this.ic != null) {
            Rectangle r = this.ic.getSrcRect();
            basex = r.x;
            basey = r.y;
        }
        aTx.setTransform(this.mag, 0.0, 0.0, this.mag, (double)(-basex) * this.mag, (double)(-basey) * this.mag);
        aTx.translate(this.getXBase(), this.getYBase());
        if (this.fillColor != null) {
            if (isActiveOverlayRoi) {
                g2d.setColor(Color.cyan);
                g2d.draw(aTx.createTransformedShape(this.shape));
            } else {
                g2d.fill(aTx.createTransformedShape(this.shape));
            }
        } else {
            g2d.draw(aTx.createTransformedShape(this.shape));
        }
        if (this.stroke != null) {
            g2d.setStroke(defaultStroke);
        }
        if (Toolbar.getToolId() == 1) {
            this.drawRoiBrush(g);
        }
        if (this.state != 3 && this.imp != null && this.imp.getRoi() != null) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawRoiBrush(Graphics g) {
        g.setColor(ROIColor);
        int size = Toolbar.getBrushSize();
        if (size == 0 || this.ic == null) {
            return;
        }
        int flags = this.ic.getModifiers();
        if ((flags & 0x10) == 0) {
            return;
        }
        size = (int)((double)size * this.mag);
        Point p = this.ic.getCursorLoc();
        int sx = this.ic.screenX(p.x);
        int sy = this.ic.screenY(p.y);
        g.drawOval(sx - size / 2, sy - size / 2, size, size);
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        PathIterator pIter = this.shape.getPathIterator(new AffineTransform(), this.flatness);
        float[] coords = new float[6];
        float sx = 0.0f;
        float sy = 0.0f;
        while (!pIter.isDone()) {
            int segType = pIter.currentSegment(coords);
            switch (segType) {
                case 0: {
                    sx = coords[0];
                    sy = coords[1];
                    ip.moveTo(this.x + (int)sx, this.y + (int)sy);
                    break;
                }
                case 1: {
                    ip.lineTo(this.x + (int)coords[0], this.y + (int)coords[1]);
                    break;
                }
                case 4: {
                    ip.lineTo(this.x + (int)sx, this.y + (int)sy);
                    break;
                }
            }
            pIter.next();
        }
    }

    @Override
    public ImageProcessor getMask() {
        if (this.shape == null) {
            return null;
        }
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        BufferedImage bi = new BufferedImage(this.width, this.height, 10);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(Color.white);
        g2d.fill(this.shape);
        WritableRaster raster = bi.getRaster();
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        byte[] mask = buffer.getData();
        this.cachedMask = new ByteProcessor(this.width, this.height, mask, null);
        this.cachedMask.setThreshold(255.0, 255.0, 2);
        return this.cachedMask;
    }

    public Shape getShape() {
        return this.shape;
    }

    boolean setShape(Shape rhs) {
        boolean result = true;
        if (rhs == null) {
            return false;
        }
        if (this.shape.equals(rhs)) {
            return false;
        }
        this.shape = rhs;
        this.type = 9;
        Rectangle rect = this.shape.getBounds();
        this.width = rect.width;
        this.height = rect.height;
        return true;
    }

    private int min(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.min(val, array[i]);
        }
        return val;
    }

    private int max(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.max(val, array[i]);
        }
        return val;
    }

    static ShapeRoi getCircularRoi(int x, int y, int width) {
        return new ShapeRoi(new OvalRoi(x - width / 2, y - width / 2, width, width));
    }

    @Override
    public int isHandle(int sx, int sy) {
        return -1;
    }

    @Override
    public Polygon getConvexHull() {
        Roi[] rois = this.getRois();
        if (rois != null && rois.length == 1) {
            return rois[0].getConvexHull();
        }
        return null;
    }

    @Override
    public Polygon getPolygon() {
        Roi[] rois = this.getRois();
        if (rois != null && rois.length == 1) {
            return rois[0].getPolygon();
        }
        return super.getPolygon();
    }

    @Override
    public FloatPolygon getFloatPolygon() {
        Roi[] rois = this.getRois();
        if (rois != null && rois.length == 1) {
            return rois[0].getFloatPolygon();
        }
        return super.getFloatPolygon();
    }

    public void setPaPerim(double perim) {
        this.paPerim = perim;
    }

    @Override
    public int size() {
        return this.getPolygon().npoints;
    }
}

