/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Memory
implements PlugIn {
    String s;
    int index1;
    int index2;
    File f;
    boolean fileMissing;
    boolean sixtyFourBit;

    @Override
    public void run(String arg) {
        this.changeMemoryAllocation();
    }

    void changeMemoryAllocation() {
        boolean unableToSet;
        IJ.maxMemory();
        int max = (int)(this.getMemorySetting() / 0x100000L);
        boolean bl = unableToSet = max == 0;
        if (max == 0) {
            max = (int)(this.maxMemory() / 0x100000L);
        }
        String title = "Memory " + (IJ.is64Bit() ? "(64-bit)" : "(32-bit)");
        GenericDialog gd = new GenericDialog(title);
        gd.addNumericField("Maximum memory:", max, 0, 5, "MB");
        gd.addNumericField("Parallel threads:", Prefs.getThreads(), 0, 5, "");
        gd.setInsets(12, 0, 0);
        gd.addCheckbox("Keep multiple undo buffers", Prefs.keepUndoBuffers);
        gd.setInsets(12, 0, 0);
        gd.addCheckbox("Run garbage collector on status bar click", !Prefs.noClickToGC);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#memory");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int max2 = (int)gd.getNextNumber();
        Prefs.setThreads((int)gd.getNextNumber());
        Prefs.keepUndoBuffers = gd.getNextBoolean();
        boolean bl2 = Prefs.noClickToGC = !gd.getNextBoolean();
        if (gd.invalidNumber()) {
            IJ.showMessage("Memory", "The number entered was invalid.");
            return;
        }
        if (unableToSet && max2 != max) {
            this.showError();
            return;
        }
        if (IJ.isMacOSX() && max2 < 256) {
            max2 = 256;
        } else if (max2 < 32) {
            max2 = 32;
        }
        if (max2 == max) {
            return;
        }
        int limit = IJ.isWindows() ? 1600 : 1700;
        String OSXInfo = "";
        if (max2 >= limit && !IJ.is64Bit()) {
            if (!IJ.showMessageWithCancel(title, "Note: setting the memory limit to a value\ngreater than " + limit + "MB on a 32-bit system\nmay cause ImageJ to fail to start. The title of\nthe Edit>Options>Memory & Threads dialog\nbox changes to \"Memory (64-bit)\" when ImageJ\nis running on a 64-bit version of Java.")) {
                // empty if block
            }
            return;
        }
        try {
            String s2 = this.s.substring(this.index2);
            if (s2.startsWith("g")) {
                s2 = "m" + s2.substring(1);
            }
            String s3 = this.s.substring(0, this.index1) + max2 + s2;
            FileOutputStream fos = new FileOutputStream(this.f);
            PrintWriter pw = new PrintWriter(fos);
            pw.print(s3);
            pw.close();
        }
        catch (IOException e) {
            String error = e.getMessage();
            if (error == null || error.equals("")) {
                error = "" + e;
            }
            String name = IJ.isMacOSX() ? "Info.plist" : "ImageJ.cfg";
            String msg = "Unable to update the file \"" + name + "\".\n \n\"" + error + "\"";
            IJ.showMessage("Memory", msg);
            return;
        }
        String hint = "";
        if (IJ.isWindows() && max2 > 640 && max2 > max) {
            hint = "\nDelete the \"ImageJ.cfg\" file, located in the ImageJ folder,\nif ImageJ fails to start.";
        }
        IJ.showMessage("Memory", "The new " + max2 + "MB limit will take effect after ImageJ is restarted." + hint);
    }

    public long getMemorySetting() {
        if (IJ.getApplet() != null) {
            return 0L;
        }
        long max = 0L;
        if (IJ.isMacOSX()) {
            String appPath = System.getProperty("java.class.path");
            if (appPath == null) {
                return 0L;
            }
            int index = appPath.indexOf(".app/");
            if (index == -1) {
                return 0L;
            }
            appPath = appPath.substring(0, index + 5);
            max = this.getMemorySetting(appPath + "Contents/Info.plist");
        } else {
            max = this.getMemorySetting("ImageJ.cfg");
        }
        return max;
    }

    void showError() {
        int max = (int)(this.maxMemory() / 0x100000L);
        String msg = "ImageJ is unable to change the memory limit. For \nmore information, refer to the installation notes at\n \n    http://imagej.nih.gov/ij/docs/install/\n \n";
        if (this.fileMissing) {
            if (IJ.isMacOSX()) {
                msg = msg + "The ImageJ application (ImageJ.app) was not found.\n \n";
            } else if (IJ.isWindows()) {
                msg = msg + "ImageJ.cfg not found.\n \n";
            }
            this.fileMissing = false;
        }
        if (max > 0) {
            msg = msg + "Current limit: " + max + "MB";
        }
        IJ.showMessage("Memory", msg);
    }

    long getMemorySetting(String file) {
        String path;
        String string = path = file.startsWith("/") ? file : Prefs.getImageJDir() + file;
        if (IJ.debugMode) {
            IJ.log("getMemorySetting: " + path);
        }
        this.f = new File(path);
        if (!this.f.exists()) {
            this.fileMissing = true;
            return 0L;
        }
        long max = 0L;
        try {
            int size = (int)this.f.length();
            byte[] buffer = new byte[size];
            FileInputStream in = new FileInputStream(this.f);
            in.read(buffer, 0, size);
            this.s = new String(buffer, 0, size, "ISO8859_1");
            in.close();
            this.index1 = this.s.indexOf("-mx");
            if (this.index1 == -1) {
                this.index1 = this.s.indexOf("-Xmx");
            }
            if (this.index1 == -1) {
                return 0L;
            }
            this.index1 = this.s.charAt(this.index1 + 1) == 'X' ? (this.index1 += 4) : (this.index1 += 3);
            this.index2 = this.index1;
            while (this.index2 < this.s.length() - 1 && Character.isDigit(this.s.charAt(++this.index2))) {
            }
            String s2 = this.s.substring(this.index1, this.index2);
            max = (long)Tools.parseDouble(s2, 0.0) * 1024L * 1024L;
            if (this.index2 < this.s.length() && this.s.charAt(this.index2) == 'g') {
                max *= 1024L;
            }
        }
        catch (Exception e) {
            IJ.log("" + e);
            return 0L;
        }
        return max;
    }

    public long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }
}

