/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class Rotator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32863;
    private static double angle = 15.0;
    private static boolean fillWithBackground;
    private static boolean enlarge;
    private static int gridLines;
    private ImagePlus imp;
    private int bitDepth;
    private boolean canEnlarge;
    private boolean isEnlarged;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private static int interpolationMethod;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null) {
            this.bitDepth = imp.getBitDepth();
            Roi roi = imp.getRoi();
            Rectangle r = roi != null ? roi.getBounds() : null;
            boolean bl = this.canEnlarge = r == null || r.x == 0 && r.y == 0 && r.width == imp.getWidth() && r.height == imp.getHeight();
            if (imp.getDisplayMode() == 1) {
                Undo.setup(6, imp);
                this.flags |= 0x80000;
            }
        }
        return this.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ImageProcessor ip) {
        if (enlarge && this.gd.wasOKed()) {
            Rotator rotator = this;
            synchronized (rotator) {
                if (!this.isEnlarged) {
                    this.enlargeCanvas();
                    this.isEnlarged = true;
                }
            }
        }
        if (this.isEnlarged) {
            int slice = this.pfr.getSliceNumber();
            ip = this.imp.getStackSize() == 1 ? this.imp.getProcessor() : this.imp.getStack().getProcessor(slice);
        }
        ip.setInterpolationMethod(interpolationMethod);
        if (fillWithBackground) {
            Color bgc = Toolbar.getBackgroundColor();
            if (this.bitDepth == 8) {
                ip.setBackgroundValue(ip.getBestIndex(bgc));
            } else if (this.bitDepth == 24) {
                ip.setBackgroundValue(bgc.getRGB());
            }
        } else {
            ip.setBackgroundValue(0.0);
        }
        ip.rotate(angle);
        if (!this.gd.wasOKed()) {
            this.drawGridLines(gridLines);
        }
        if (this.isEnlarged && this.imp.getStackSize() == 1) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
            Undo.setup(5, this.imp);
        }
    }

    void enlargeCanvas() {
        this.imp.unlock();
        IJ.run("Select All");
        IJ.run("Rotate...", "angle=" + angle);
        Roi roi = this.imp.getRoi();
        Rectangle r = roi.getBounds();
        if (r.width < this.imp.getWidth()) {
            r.width = this.imp.getWidth();
        }
        if (r.height < this.imp.getHeight()) {
            r.height = this.imp.getHeight();
        }
        IJ.showStatus("Rotate: Enlarging...");
        if (this.imp.getStackSize() == 1) {
            Undo.setup(4, this.imp);
        }
        IJ.run("Canvas Size...", "width=" + r.width + " height=" + r.height + " position=Center " + (fillWithBackground ? "" : "zero"));
        IJ.showStatus("Rotating...");
    }

    void drawGridLines(int lines) {
        ImageCanvas ic = this.imp.getCanvas();
        if (ic == null) {
            return;
        }
        if (lines == 0) {
            ic.setDisplayList(null);
            return;
        }
        GeneralPath path = new GeneralPath();
        float width = this.imp.getWidth();
        float height = this.imp.getHeight();
        float xinc = width / (float)lines;
        float yinc = height / (float)lines;
        float xstart = xinc / 2.0f;
        float ystart = yinc / 2.0f;
        for (int i = 0; i < lines; ++i) {
            path.moveTo(xstart + xinc * (float)i, 0.0f);
            path.lineTo(xstart + xinc * (float)i, height);
            path.moveTo(0.0f, ystart + yinc * (float)i);
            path.lineTo(width, ystart + yinc * (float)i);
        }
        ic.setDisplayList(path, null, null);
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            if (macroOptions.indexOf(" interpolate") != -1) {
                macroOptions.replaceAll(" interpolate", " interpolation=Bilinear");
            } else if (macroOptions.indexOf(" interpolation=") == -1) {
                macroOptions = macroOptions + " interpolation=None";
            }
            Macro.setOptions(macroOptions);
        }
        this.gd = new GenericDialog("Rotate");
        this.gd.addSlider("Angle:", -90.0, 90.0, angle);
        this.gd.addNumericField("Grid lines:", gridLines, 0);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            this.gd.addCheckbox("Fill with background color", fillWithBackground);
        }
        if (this.canEnlarge) {
            this.gd.addCheckbox("Enlarge image", enlarge);
        } else {
            enlarge = false;
        }
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        this.drawGridLines(0);
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        if (!enlarge) {
            this.flags |= 0x1000000;
        } else if (imp.getStackSize() == 1) {
            this.flags |= 0x80;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        angle = gd.getNextNumber();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Angle is invalid.");
            }
            return false;
        }
        gridLines = (int)gd.getNextNumber();
        interpolationMethod = gd.getNextChoiceIndex();
        if (this.bitDepth == 8 || this.bitDepth == 24) {
            fillWithBackground = gd.getNextBoolean();
        }
        if (this.canEnlarge) {
            enlarge = gd.getNextBoolean();
        }
        return true;
    }

    @Override
    public void setNPasses(int nPasses) {
    }

    static {
        gridLines = 1;
        interpolationMethod = 1;
    }
}

