/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class ThresholdToSelection
implements PlugInFilter {
    ImagePlus image;
    ImageProcessor ip;
    float min;
    float max;
    int w;
    int h;
    boolean showStatus;
    static final double PROGRESS_FRACTION_OUTLINING = 0.9;

    @Override
    public void run(ImageProcessor ip) {
        this.showStatus = true;
        this.image.setRoi(this.convert(ip));
    }

    public static Roi run(ImagePlus imp) {
        ThresholdToSelection tts = new ThresholdToSelection();
        return tts.convert(imp.getProcessor());
    }

    public Roi convert(ImageProcessor ip) {
        this.ip = ip;
        this.min = (float)ip.getMinThreshold();
        this.max = (float)ip.getMaxThreshold();
        this.w = ip.getWidth();
        this.h = ip.getHeight();
        return this.getRoi();
    }

    final boolean selected(int x, int y) {
        float v = this.ip.getf(x, y);
        return v >= this.min && v <= this.max;
    }

    Roi getRoi() {
        Roi roi;
        if (this.showStatus) {
            IJ.showStatus("Converting threshold to selection");
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        int progressInc = Math.max(this.h / 50, 1);
        boolean[] prevRow = new boolean[this.w + 2];
        boolean[] thisRow = new boolean[this.w + 2];
        Outline[] outline = new Outline[this.w + 1];
        for (int y = 0; y <= this.h; ++y) {
            boolean[] b = prevRow;
            prevRow = thisRow;
            thisRow = b;
            int xAfterLowerRightCorner = -1;
            Outline oAfterLowerRightCorner = null;
            thisRow[1] = y < this.h ? this.selected(0, y) : false;
            for (int x = 0; x <= this.w; ++x) {
                int x1;
                if (y < this.h && x < this.w - 1) {
                    thisRow[x + 2] = this.selected(x + 1, y);
                } else if (x < this.w - 1) {
                    thisRow[x + 2] = false;
                }
                if (thisRow[x + 1]) {
                    if (!prevRow[x + 1]) {
                        if (outline[x] == null) {
                            if (outline[x + 1] == null) {
                                outline[x + 1] = outline[x] = new Outline();
                                outline[x].append(x + 1, y);
                                outline[x].append(x, y);
                            } else {
                                outline[x] = outline[x + 1];
                                outline[x + 1] = null;
                                outline[x].append(x, y);
                            }
                        } else if (outline[x + 1] == null) {
                            if (x == xAfterLowerRightCorner) {
                                outline[x + 1] = outline[x];
                                outline[x] = oAfterLowerRightCorner;
                                outline[x].append(x, y);
                                outline[x + 1].prepend(x + 1, y);
                            } else {
                                outline[x + 1] = outline[x];
                                outline[x] = null;
                                outline[x + 1].prepend(x + 1, y);
                            }
                        } else if (outline[x + 1] == outline[x]) {
                            if (x < this.w - 1 && y < this.h && x != xAfterLowerRightCorner && !thisRow[x + 2] && prevRow[x + 2]) {
                                outline[x] = null;
                                outline[x + 1].prepend(x + 1, y);
                                xAfterLowerRightCorner = x + 1;
                                oAfterLowerRightCorner = outline[x + 1];
                            } else {
                                polygons.add(outline[x].getPolygon());
                                outline[x + 1] = null;
                                outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                            }
                        } else {
                            outline[x].prepend(outline[x + 1]);
                            for (x1 = 0; x1 <= this.w; ++x1) {
                                if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                                outline[x1] = outline[x];
                                outline[x + 1] = null;
                                outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                                break;
                            }
                            if (outline[x + 1] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (thisRow[x]) continue;
                    if (outline[x] == null) {
                        throw new RuntimeException("assertion failed");
                    }
                    outline[x].append(x, y + 1);
                    continue;
                }
                if (prevRow[x + 1]) {
                    if (outline[x] == null) {
                        if (outline[x + 1] == null) {
                            Outline outline2 = new Outline();
                            outline[x + 1] = outline2;
                            outline[x] = outline2;
                            outline[x].append(x, y);
                            outline[x].append(x + 1, y);
                        } else {
                            outline[x] = outline[x + 1];
                            outline[x + 1] = null;
                            outline[x].prepend(x, y);
                        }
                    } else if (outline[x + 1] == null) {
                        if (x == xAfterLowerRightCorner) {
                            outline[x + 1] = outline[x];
                            outline[x] = oAfterLowerRightCorner;
                            outline[x].prepend(x, y);
                            outline[x + 1].append(x + 1, y);
                        } else {
                            outline[x + 1] = outline[x];
                            outline[x] = null;
                            outline[x + 1].append(x + 1, y);
                        }
                    } else if (outline[x + 1] == outline[x]) {
                        if (x < this.w - 1 && y < this.h && x != xAfterLowerRightCorner && thisRow[x + 2] && !prevRow[x + 2]) {
                            outline[x] = null;
                            outline[x + 1].append(x + 1, y);
                            xAfterLowerRightCorner = x + 1;
                            oAfterLowerRightCorner = outline[x + 1];
                        } else {
                            polygons.add(outline[x].getPolygon());
                            outline[x + 1] = null;
                            outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                        }
                    } else if (x < this.w - 1 && y < this.h && x != xAfterLowerRightCorner && thisRow[x + 2] && !prevRow[x + 2]) {
                        outline[x].append(x + 1, y);
                        outline[x + 1].prepend(x + 1, y);
                        xAfterLowerRightCorner = x + 1;
                        oAfterLowerRightCorner = outline[x];
                        outline[x] = null;
                    } else {
                        outline[x].append(outline[x + 1]);
                        for (x1 = 0; x1 <= this.w; ++x1) {
                            if (x1 == x + 1 || outline[x1] != outline[x + 1]) continue;
                            outline[x1] = outline[x];
                            outline[x + 1] = null;
                            outline[x] = x == xAfterLowerRightCorner ? oAfterLowerRightCorner : null;
                            break;
                        }
                        if (outline[x + 1] != null) {
                            throw new RuntimeException("assertion failed");
                        }
                    }
                }
                if (!thisRow[x]) continue;
                if (outline[x] == null) {
                    throw new RuntimeException("assertion failed");
                }
                outline[x].prepend(x, y + 1);
            }
            if (y % progressInc != 0) continue;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (!this.showStatus) continue;
            IJ.showProgress((double)y * (0.9 / (double)this.h));
        }
        if (polygons.size() == 0) {
            return null;
        }
        if (this.showStatus) {
            IJ.showStatus("Converting threshold to selection...");
        }
        GeneralPath path = new GeneralPath(0);
        progressInc = Math.max(polygons.size() / 10, 1);
        for (int i = 0; i < polygons.size(); ++i) {
            path.append((Polygon)polygons.get(i), false);
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (!this.showStatus || i % progressInc != 0) continue;
            IJ.showProgress(0.9 + (double)i * 0.09999999999999998 / (double)polygons.size());
        }
        ShapeRoi shape = new ShapeRoi(path);
        Roi roi2 = roi = shape != null ? shape.shapeToRoi() : null;
        if (this.showStatus) {
            IJ.showProgress(1.0);
        }
        if (roi != null) {
            return roi;
        }
        return shape;
    }

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 141;
    }

    public void showStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int neededAtBegin, int neededAtEnd) {
            if (neededAtBegin > this.first || neededAtEnd > this.reserved - this.last) {
                int extraSpace = Math.max(10, Math.abs(this.x[this.last - 1] - this.x[this.first]));
                int newSize = this.reserved + neededAtBegin + neededAtEnd + extraSpace;
                int newFirst = neededAtBegin + extraSpace / 2;
                int[] newX = new int[newSize];
                int[] newY = new int[newSize];
                System.arraycopy(this.x, this.first, newX, newFirst, this.last - this.first);
                System.arraycopy(this.y, this.first, newY, newFirst, this.last - this.first);
                this.x = newX;
                this.y = newY;
                this.last += newFirst - this.first;
                this.first = newFirst;
                this.reserved = newSize;
            }
        }

        public void append(int x, int y) {
            if (this.last - this.first >= 2 && this.collinear(this.x[this.last - 2], this.y[this.last - 2], this.x[this.last - 1], this.y[this.last - 1], x, y)) {
                this.x[this.last - 1] = x;
                this.y[this.last - 1] = y;
            } else {
                this.needs(0, 1);
                this.x[this.last] = x;
                this.y[this.last] = y;
                ++this.last;
            }
        }

        public void prepend(int x, int y) {
            if (this.last - this.first >= 2 && this.collinear(this.x[this.first + 1], this.y[this.first + 1], this.x[this.first], this.y[this.first], x, y)) {
                this.x[this.first] = x;
                this.y[this.first] = y;
            } else {
                this.needs(1, 0);
                --this.first;
                this.x[this.first] = x;
                this.y[this.first] = y;
            }
        }

        public void append(Outline o) {
            int size = this.last - this.first;
            int oSize = o.last - o.first;
            if (size <= o.first && oSize > this.reserved - this.last) {
                System.arraycopy(this.x, this.first, o.x, o.first - size, size);
                System.arraycopy(this.y, this.first, o.y, o.first - size, size);
                this.x = o.x;
                this.y = o.y;
                this.first = o.first - size;
                this.last = o.last;
                this.reserved = o.reserved;
            } else {
                this.needs(0, oSize);
                System.arraycopy(o.x, o.first, this.x, this.last, oSize);
                System.arraycopy(o.y, o.first, this.y, this.last, oSize);
                this.last += oSize;
            }
        }

        public void prepend(Outline o) {
            int size = this.last - this.first;
            int oSize = o.last - o.first;
            if (size <= o.reserved - o.last && oSize > this.first) {
                System.arraycopy(this.x, this.first, o.x, o.last, size);
                System.arraycopy(this.y, this.first, o.y, o.last, size);
                this.x = o.x;
                this.y = o.y;
                this.first = o.first;
                this.last = o.last + size;
                this.reserved = o.reserved;
            } else {
                this.needs(oSize, 0);
                this.first -= oSize;
                System.arraycopy(o.x, o.first, this.x, this.first, oSize);
                System.arraycopy(o.y, o.first, this.y, this.first, oSize);
            }
        }

        public Polygon getPolygon() {
            int j = this.first + 1;
            int i = this.first + 1;
            while (i + 1 < this.last) {
                if (this.collinear(this.x[j - 1], this.y[j - 1], this.x[j], this.y[j], this.x[j + 1], this.y[j + 1])) {
                    --this.last;
                } else {
                    if (i != j) {
                        this.x[i] = this.x[j];
                        this.y[i] = this.y[j];
                    }
                    ++i;
                }
                ++j;
            }
            if (this.collinear(this.x[j - 1], this.y[j - 1], this.x[j], this.y[j], this.x[this.first], this.y[this.first])) {
                --this.last;
            } else {
                this.x[i] = this.x[j];
                this.y[i] = this.y[j];
            }
            if (this.last - this.first > 2 && this.collinear(this.x[this.last - 1], this.y[this.last - 1], this.x[this.first], this.y[this.first], this.x[this.first + 1], this.y[this.first + 1])) {
                ++this.first;
            }
            int count = this.last - this.first;
            int[] xNew = new int[count];
            int[] yNew = new int[count];
            System.arraycopy(this.x, this.first, xNew, 0, count);
            System.arraycopy(this.y, this.first, yNew, 0, count);
            return new Polygon(xNew, yNew, count);
        }

        boolean collinear(int x1, int y1, int x2, int y2, int x3, int y3) {
            return (x2 - x1) * (y3 - y2) == (y2 - y1) * (x3 - x2);
        }

        public String toString() {
            String res = "[first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            int nmax = 10;
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                if (this.last - this.first > nmax && i - this.first > nmax / 2) {
                    i = this.last - nmax / 2;
                    res = res + "...";
                    nmax = this.last - this.first;
                    continue;
                }
                res = res + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return res + "]";
        }
    }
}

