/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import imageTiTi.colorSpace.HLS;
import imageTiTi.colorSpace.HSB;
import imageTiTi.colorSpace.HSV;
import imageTiTi.colorSpace.Lab;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import utils.memory.Allocator;

public final class ImageConverter {
    public static final int CIE601 = 0;
    public static final int CIE709 = 1;
    public static final int CHEAPGREEN = 2;
    private static final double Epsilon = 1.0E-4;

    public static BufferedImage BooleanToBinaryImage(boolean[][] source) {
        int largeur = source[0].length;
        int hauteur = source.length;
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(largeur, hauteur, 12);
        allocator = null;
        WritableRaster wrr = result.getRaster();
        for (int y = 0; y < hauteur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                wrr.setSample(x, y, 0, source[y][x] ? 255 : 0);
            }
        }
        return result;
    }

    public static byte[][] BinaryImageToByte(BufferedImage source) {
        if (source.getType() != 12) {
            throw new IllegalArgumentException("TYPE_BYTE_BINARY required.");
        }
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        byte[][] resultat = new byte[hauteur][largeur];
        WritableRaster wr = source.getRaster();
        for (int y = 0; y < hauteur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                resultat[y][x] = (byte)wr.getSample(x, y, 0);
            }
        }
        wr = null;
        return resultat;
    }

    public static BufferedImage ByteToImage(byte[] tab, int width, int height) {
        if (width * height != tab.length) {
            throw new IllegalArgumentException("Arguments incompatibles : " + tab.length + "!=" + width + "x" + height);
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, 10);
        allocator = null;
        WritableRaster wrr = result.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int b = tab[y * width + x];
                wrr.setSample(x, y, 0, b < 0 ? 256 + b : b);
            }
        }
        return result;
    }

    public static BufferedImage ByteToBinaryImage(byte[][] tab) {
        int width = tab[0].length;
        int height = tab.length;
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, 12);
        allocator = null;
        WritableRaster wrr = result.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wrr.setSample(x, y, 0, tab[y][x] == 0 ? 0 : 1);
            }
        }
        return result;
    }

    public static BufferedImage ByteToImage(byte[][] tab) {
        int width = tab[0].length;
        int height = tab.length;
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, 10);
        allocator = null;
        WritableRaster wrr = result.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int b = tab[y][x];
                wrr.setSample(x, y, 0, b < 0 ? 256 + b : b);
            }
        }
        return result;
    }

    public static BufferedImage FloatToImage(float[] tab, int width, int height) {
        if (width * height != tab.length) {
            throw new IllegalArgumentException("Arguments incompatibles : " + tab.length + "!=" + width + "x" + height);
        }
        ArrayFeatures af = new ArrayFeatures();
        double max = af.Maximum(tab);
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        if (max <= 255.0) {
            result = allocator.newBufferedImage(width, height, 10);
        } else if (max <= 65535.0) {
            result = allocator.newBufferedImage(width, height, 11);
        } else {
            throw new IllegalArgumentException("Max value greatter than 65535.");
        }
        allocator = null;
        af = null;
        ImageConverter.FloatToImage(tab, result);
        return result;
    }

    public static void FloatToImage(float[] tab, BufferedImage result) {
        int height;
        int width = result.getWidth();
        if (width * (height = result.getHeight()) != tab.length) {
            throw new IllegalArgumentException("Arguments incompatibles : " + tab.length + "!=" + width + "x" + height);
        }
        block0 : switch (result.getType()) {
            case 10: {
                ArrayConverter.FloatToByte(tab, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.FloatToShort(tab, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        System.arraycopy(tab, 0, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage FloatNormalizedToImage(float[] tab, int width, int height) {
        if (width * height != tab.length) {
            throw new IllegalArgumentException("Arguments incompatibles : " + tab.length + "!=" + width + "x" + height);
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, 10);
        allocator = null;
        byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < bb.length; ++x) {
            bb[x] = (byte)(tab[x] * 255.0f + 0.5f);
        }
        bb = null;
        return result;
    }

    public static boolean[][] ImageToBoolean(BufferedImage source) {
        boolean[][] result = new boolean[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToBoolean(source, result);
        return result;
    }

    public static void ImageToBoolean(BufferedImage source, boolean[][] result) {
        if (source.getWidth() != result[0].length || source.getHeight() != result.length) {
            throw new IllegalArgumentException("Image and array have different dimensions.");
        }
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        WritableRaster wr = source.getRaster();
        switch (source.getType()) {
            case 10: 
            case 11: 
            case 12: {
                for (int y = 0; y < hauteur; ++y) {
                    for (int x = 0; x < largeur; ++x) {
                        result[y][x] = wr.getSample(x, y, 0) != 0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level or binaries images supported.");
            }
        }
        wr = null;
    }

    public static int[] ImageToIntsRGB1D(BufferedImage source) {
        switch (source.getType()) {
            case 5: 
            case 10: 
            case 12: {
                int height = source.getHeight();
                int width = source.getWidth();
                int[] tab = new int[source.getWidth() * source.getHeight()];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        tab[y * width + x] = source.getRGB(x, y);
                    }
                }
                return tab;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int[][] ImageToInt(BufferedImage source) {
        int[][] tab = new int[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToInt(source, tab);
        return tab;
    }

    public static void ImageToInt(BufferedImage source, int[][] Tab) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int height = source.getHeight();
        int width = source.getWidth();
        if (Tab.length != height || Tab[0].length != width) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Tab[y][x] = wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = bytebuffer[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = shortbuffer[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static float[][] ImageToFloat(BufferedImage source) {
        float[][] tab = new float[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToFloat(source, tab);
        return tab;
    }

    public static void ImageToFloat(BufferedImage source, float[][] Tab) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int height = source.getHeight();
        int width = source.getWidth();
        if (Tab.length != height || Tab[0].length != width) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Tab[y][x] = wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = bytebuffer[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = shortbuffer[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static double[] ImageToDouble1D(BufferedImage source) {
        double[] tab = new double[source.getWidth() * source.getHeight()];
        ImageConverter.ImageToDouble(source, tab);
        return tab;
    }

    public static double[][] ImageToDouble(BufferedImage source) {
        double[][] tab = new double[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToDouble(source, tab);
        return tab;
    }

    public static void ImageToDouble(BufferedImage source, double[] Tab) {
        int height = source.getHeight();
        int width = source.getWidth();
        int size = width * height;
        if (Tab.length != size) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[pos] = wr.getSample(x, y, 0);
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < size; ++pos) {
                    Tab[pos] = bytebuffer[pos] & 0xFF;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < size; ++pos) {
                    Tab[pos] = shortbuffer[pos] & 0xFFFF;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void ImageToDouble(BufferedImage source, double[][] Tab) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int height = source.getHeight();
        int width = source.getWidth();
        if (Tab.length != height || Tab[0].length != width) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Tab[y][x] = wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = bytebuffer[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = shortbuffer[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static byte[][] ImageToByte2D(BufferedImage source) {
        byte[][] tab = new byte[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToByte2D(source, tab);
        return tab;
    }

    public static void ImageToByte2D(BufferedImage source, byte[][] Tab) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int height = source.getHeight();
        int width = source.getWidth();
        if (Tab.length != height || Tab[0].length != width) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Tab[y][x] = (byte)wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = bytebuffer[pos];
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = (byte)(shortbuffer[pos] & 0xFFFF);
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static short[][] ImageToShort2D(BufferedImage source) {
        short[][] tab = new short[source.getHeight()][source.getWidth()];
        ImageConverter.ImageToShort2D(source, tab);
        return tab;
    }

    public static void ImageToShort2D(BufferedImage source, short[][] Tab) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        int height = source.getHeight();
        int width = source.getWidth();
        if (Tab.length != height || Tab[0].length != width) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Tab[y][x] = (short)wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = (short)(bytebuffer[pos] & 0xFF);
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[y][x] = shortbuffer[pos];
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage IntToBinaryImage(int[][] tab) {
        BufferedImage result = new BufferedImage(tab[0].length, tab.length, 12);
        ImageConverter.IntToBinaryImage(tab, result);
        return result;
    }

    public static void IntToBinaryImage(int[][] tab, BufferedImage image) {
        int width = tab[0].length;
        int height = tab.length;
        if (height != image.getHeight() || width != image.getWidth()) {
            throw new IllegalArgumentException("Image and array have different dimensions.");
        }
        WritableRaster wrr = image.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wrr.setSample(x, y, 0, tab[y][x] == 0 ? 0 : 1);
            }
        }
    }

    public static BufferedImage IntToImageRGB(int[][] tab) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        int max = af.Maximum(tab);
        af = null;
        if (max > 255) {
            throw new IllegalArgumentException("MaxValue(array) > 255.");
        }
        result = allocator.newBufferedImage(tab[0].length, tab.length, 5);
        allocator = null;
        ImageConverter.IntToImageRGB(tab, result);
        return result;
    }

    public static void IntToImageRGB(int[][] tab, BufferedImage result) {
        switch (result.getType()) {
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        int height = tab.length;
        int width = tab[0].length;
        if (result.getHeight() != height || result.getWidth() != width) {
            throw new IllegalArgumentException("Array and image have different dimensions.");
        }
        WritableRaster wrr = result.getRaster();
        int channel = wrr.getNumBands();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int c = 0; c < channel; ++c) {
                    wrr.setSample(x, y, c, tab[y][x]);
                }
            }
        }
        wrr = null;
    }

    public static BufferedImage UShortGrayToGray(BufferedImage ushort, boolean scale) {
        BufferedImage gray = ImageNew.Same(ushort, 10);
        ImageConverter.UShortGrayToGray(ushort, scale, gray);
        return gray;
    }

    public static void UShortGrayToGray(BufferedImage ushort, boolean scale, BufferedImage gray) {
        if (ushort.getType() != 11) {
            throw new IllegalArgumentException("Input/ushort must be TYPE_USHORT_GRAY.");
        }
        if (gray.getType() != 10) {
            throw new IllegalArgumentException("Output/gray must be TYPE_BYTE_GRAY.");
        }
        byte[] bytebuffer = ((DataBufferByte)gray.getRaster().getDataBuffer()).getData();
        short[] shortbuffer = ((DataBufferUShort)ushort.getRaster().getDataBuffer()).getData();
        if (scale) {
            for (int i = 0; i < bytebuffer.length; ++i) {
                bytebuffer[i] = (byte)((shortbuffer[i] & 0xFFFF) >> 8);
            }
        } else {
            for (int i = 0; i < bytebuffer.length; ++i) {
                bytebuffer[i] = (byte)(shortbuffer[i] & 0xFFFF);
            }
        }
        bytebuffer = null;
        shortbuffer = null;
    }

    public static BufferedImage UShortGrayToBinary(BufferedImage ushort) {
        if (ushort.getType() != 11) {
            throw new IllegalArgumentException("Only TYPE_USHORT_GRAY supported.");
        }
        BufferedImage gray = ImageNew.Same(ushort, 12);
        WritableRaster raster = gray.getRaster();
        short[] shortbuffer = ((DataBufferUShort)ushort.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < ushort.getHeight(); ++y) {
            int x = 0;
            while (x < ushort.getWidth()) {
                raster.setSample(x, y, 0, shortbuffer[pos] == 0 ? 0 : 1);
                ++x;
                ++pos;
            }
        }
        shortbuffer = null;
        raster = null;
        return gray;
    }

    public static BufferedImage BinaryToGray(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 10);
        allocator = null;
        ImageConverter.BinaryToGray(source, result);
        return result;
    }

    public static BufferedImage BinaryToUShortGray(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 11);
        allocator = null;
        ImageConverter.BinaryToGray(source, result);
        return result;
    }

    public static BufferedImage BinaryToGray(BufferedImage source, BufferedImage result) {
        if (source.getType() != 12) {
            throw new IllegalArgumentException("TYPE_BYTE_BINARY required for the source image.");
        }
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        switch (result.getType()) {
            case 10: {
                ImageComparator.Compare(source, "==", 0, 0, 255, result);
                break;
            }
            case 11: {
                ImageComparator.Compare(source, "==", 0, 0, 65535, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Result image type not supported.");
            }
        }
        return result;
    }

    public static BufferedImage BinaryToColor(BufferedImage source) {
        BufferedImage result = ImageNew.Same(source, 5);
        ImageConverter.BinaryToColor(source, result);
        return result;
    }

    public static void BinaryToColor(BufferedImage source, BufferedImage result) {
        if (source.getType() != 12) {
            throw new IllegalArgumentException("TYPE_BYTE_BINARY required.");
        }
        if (!ImageTools.isColored(result)) {
            throw new IllegalArgumentException("Result image is not colored.");
        }
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        WritableRaster wr = source.getRaster();
        WritableRaster wrr = result.getRaster();
        int channel = wrr.getNumBands();
        for (int y = 0; y < hauteur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                int i;
                if (wr.getSample(x, y, 0) == 1) {
                    for (i = 0; i < channel; ++i) {
                        wrr.setSample(x, y, i, 255);
                    }
                    continue;
                }
                for (i = 0; i < channel; ++i) {
                    wrr.setSample(x, y, i, 0);
                }
            }
        }
        wrr = null;
        wr = null;
    }

    public static int[] sRGB_To_RGB(int Color2) {
        return new int[]{(Color2 & 0xFF0000) >> 16, (Color2 & 0xFF00) >> 8, Color2 & 0xFF};
    }

    public static int[] sRGB_To_BGR(int Color2) {
        return new int[]{Color2 & 0xFF, (Color2 & 0xFF00) >> 8, (Color2 & 0xFF0000) >> 16};
    }

    public static int Int_To_sRGB(int Color2) {
        return 0xFF000000 | Color2 << 16 | Color2 << 8 | Color2;
    }

    public static int Rgb_To_GrayLevel(int R, int G, int B, int Recommandation) {
        switch (Recommandation) {
            case 0: {
                return (int)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B + 0.5);
            }
            case 1: {
                return (int)(0.2125 * (double)R + 0.7154 * (double)G + 0.0721 * (double)B + 0.5);
            }
            case 2: {
                return R + (G << 1) + B >> 2;
            }
        }
        throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
    }

    public static double RGB_To_GrayLevel(double R, double G, double B, int Recommandation) {
        switch (Recommandation) {
            case 0: {
                return 0.299 * R + 0.587 * G + 0.114 * B;
            }
            case 1: {
                return 0.2125 * R + 0.7154 * G + 0.0721 * B;
            }
            case 2: {
                return (R + 2.0 * G + B) / 4.0;
            }
        }
        throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
    }

    public static BufferedImage RGB_To_Binary(BufferedImage RGB) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(RGB.getWidth(), RGB.getHeight(), 12);
        allocator = null;
        ImageConverter.RGB_To_Binary(RGB, result);
        return result;
    }

    public static void RGB_To_Binary(BufferedImage RGB, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(RGB, result)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (result.getType() != 12) {
            throw new IllegalArgumentException("Result image is not binary.");
        }
        WritableRaster wr = RGB.getRaster();
        WritableRaster wrr = result.getRaster();
        int height = RGB.getHeight();
        int width = RGB.getWidth();
        switch (RGB.getType()) {
            case 1: 
            case 4: 
            case 5: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrr.setSample(x, y, 0, wr.getSample(x, y, 0) + wr.getSample(x, y, 1) + wr.getSample(x, y, 2) > 0 ? 1 : 0);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: RGB or BGR image required.");
            }
        }
    }

    public static BufferedImage RGB_To_GrayLevel(BufferedImage RGB, int Recommandation) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(RGB.getWidth(), RGB.getHeight(), 10);
        allocator = null;
        ImageConverter.RGB_To_GrayLevel(RGB, result, Recommandation);
        return result;
    }

    public static void RGB_To_GrayLevel(BufferedImage RGB, BufferedImage result, int Recommandation) {
        double Wb;
        double Wg;
        double Wr;
        if (!ImageTools.areDimensionsEqual(RGB, result)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (result.getType() != 10) {
            throw new IllegalArgumentException("Result image is not byte gray level.");
        }
        int channel = RGB.getRaster().getNumBands();
        switch (Recommandation) {
            case 0: {
                Wr = 0.299;
                Wg = 0.587;
                Wb = 0.114;
                break;
            }
            case 1: {
                Wr = 0.2125;
                Wg = 0.7154;
                Wb = 0.0721;
                break;
            }
            case 2: {
                Wb = 0.0;
                Wg = 0.0;
                Wr = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
        int height = RGB.getHeight();
        int width = RGB.getWidth();
        switch (RGB.getType()) {
            case 5: 
            case 6: {
                int posrgb = channel == 3 ? 0 : 1;
                byte[] bbin = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                if (Recommandation == 2) {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            bbout[pos] = (byte)((bbin[posrgb] & 0xFF) + ((bbin[posrgb + 1] & 0xFF) << 1) + (bbin[posrgb + 2] & 0xFF) >> 2);
                            ++x;
                            ++pos;
                            posrgb += channel;
                        }
                    }
                } else {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            bbout[pos] = (byte)(Wb * (double)(bbin[posrgb] & 0xFF) + Wg * (double)(bbin[posrgb + 1] & 0xFF) + Wr * (double)(bbin[posrgb + 2] & 0xFF) + 0.5);
                            ++x;
                            ++pos;
                            posrgb += channel;
                        }
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 1: 
            case 4: {
                WritableRaster wr = RGB.getRaster();
                WritableRaster wrr = result.getRaster();
                if (Recommandation == 2) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            wrr.setSample(x, y, 0, wr.getSample(x, y, 0) + (wr.getSample(x, y, 1) << 1) + wr.getSample(x, y, 2) >> 2);
                        }
                    }
                } else {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            wrr.setSample(x, y, 0, (int)(Wr * (double)wr.getSample(x, y, 0) + Wg * (double)wr.getSample(x, y, 1) + Wb * (double)wr.getSample(x, y, 2) + 0.5));
                        }
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: RGB or BGR image required.");
            }
        }
    }

    public static void RGB_To_YCbCr(double[] RGB, double[] YCbCr, int Recommandation) {
        switch (Recommandation) {
            case 0: {
                YCbCr[0] = 0.299 * RGB[0] + 0.587 * RGB[1] + 0.114 * RGB[2];
                break;
            }
            case 1: {
                YCbCr[0] = 0.2126 * RGB[0] + 0.7152 * RGB[1] + 0.0722 * RGB[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
        YCbCr[1] = RGB[2] - YCbCr[0];
        YCbCr[2] = RGB[0] - YCbCr[0];
    }

    public static void RGB_To_YCbCr(int[] RGB, double[] YCbCr, int Recommandation) {
        switch (Recommandation) {
            case 0: {
                YCbCr[0] = 0.299 * (double)RGB[0] + 0.587 * (double)RGB[1] + 0.114 * (double)RGB[2];
                YCbCr[1] = -0.168736 * (double)RGB[0] - 0.331264 * (double)RGB[1] + 0.5 * (double)RGB[2];
                YCbCr[2] = 0.5 * (double)RGB[0] - 0.418688 * (double)RGB[1] - 0.081312 * (double)RGB[2];
                break;
            }
            case 1: {
                YCbCr[0] = 0.2126 * (double)RGB[0] + 0.7152 * (double)RGB[1] + 0.0722 * (double)RGB[2];
                YCbCr[1] = -0.114572 * (double)RGB[0] - 0.385427 * (double)RGB[1] + 0.5 * (double)RGB[2];
                YCbCr[2] = 0.5 * (double)RGB[0] - 0.454152 * (double)RGB[1] - 0.045847 * (double)RGB[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
    }

    public static void RGB_To_YCbCr(double R, double G, double B, double[] YCbCr, int Recommandation) {
        switch (Recommandation) {
            case 0: {
                YCbCr[0] = 0.299 * R + 0.587 * G + 0.114 * B;
                break;
            }
            case 1: {
                YCbCr[0] = 0.2126 * R + 0.7152 * G + 0.0722 * B;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
        YCbCr[1] = B - YCbCr[0];
        YCbCr[2] = R - YCbCr[0];
    }

    public static BufferedImage RGB_To_YCbCr(BufferedImage RGB, int Recommandation) {
        BufferedImage YCbCr = null;
        switch (Recommandation) {
            case 0: {
                YCbCr = ImageNew.YCbCr601(RGB.getWidth(), RGB.getHeight());
                break;
            }
            case 1: {
                YCbCr = ImageNew.YCbCr709(RGB.getWidth(), RGB.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
        int width = RGB.getWidth();
        int height = RGB.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                YCbCr.setRGB(x, y, RGB.getRGB(x, y));
            }
        }
        return YCbCr;
    }

    public static void YCbCr_To_RGB(double[] YCbCr, double[] RGB, int Recommandation) {
        RGB[0] = YCbCr[0] + YCbCr[2];
        RGB[2] = YCbCr[0] + YCbCr[1];
        switch (Recommandation) {
            case 0: {
                RGB[1] = YCbCr[0] - 0.19420783646 * YCbCr[1] - 0.50936967632 * YCbCr[2];
                break;
            }
            case 1: {
                RGB[1] = YCbCr[0] - 0.100950783 * YCbCr[1] - 0.29725950783 * YCbCr[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknow recommandation : " + Recommandation);
            }
        }
    }

    public static BufferedImage YCbCr_To_RGB(BufferedImage YCbCr) {
        int width = YCbCr.getWidth();
        int height = YCbCr.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage RGB = new BufferedImage(width, height, 1);
        allocator = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB.setRGB(x, y, YCbCr.getRGB(x, y));
            }
        }
        return RGB;
    }

    public static BufferedImage RGB_To_HSV(BufferedImage RGB) {
        float[] array = new float[3];
        BufferedImage reshsv = ImageNew.HSV(RGB.getWidth(), RGB.getHeight());
        HSV hsv = new HSV();
        switch (RGB.getType()) {
            case 5: {
                byte[] bbrgb = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                float[] bbhls = ((DataBufferFloat)reshsv.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbrgb.length; x += 3) {
                    array[2] = (float)(bbrgb[x] & 0xFF) / 255.0f;
                    array[1] = (float)(bbrgb[x + 1] & 0xFF) / 255.0f;
                    array[0] = (float)(bbrgb[x + 2] & 0xFF) / 255.0f;
                    float[] res = hsv.fromRGB(array);
                    bbhls[x] = res[0];
                    bbhls[x + 1] = res[1];
                    bbhls[x + 2] = res[2];
                }
                bbrgb = null;
                bbhls = null;
                break;
            }
            default: {
                int width = RGB.getWidth();
                int height = RGB.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        reshsv.setRGB(x, y, RGB.getRGB(x, y));
                    }
                }
            }
        }
        return reshsv;
    }

    public static void HSV_To_RGB(double[] HSV2, double[] RGB) {
        int hi = (int)(HSV2[0] / 60.0) % 6;
        double f = HSV2[0] / 60.0 - (double)hi;
        double p = HSV2[2] * (1.0 - HSV2[1]);
        double q = HSV2[2] * (1.0 - f * HSV2[1]);
        double t = HSV2[2] * (1.0 - (1.0 - f) * HSV2[1]);
        switch (hi) {
            case 0: {
                RGB[0] = HSV2[2];
                RGB[1] = t;
                RGB[2] = p;
                break;
            }
            case 1: {
                RGB[0] = q;
                RGB[1] = HSV2[2];
                RGB[2] = p;
                break;
            }
            case 2: {
                RGB[0] = p;
                RGB[1] = HSV2[2];
                RGB[2] = t;
                break;
            }
            case 3: {
                RGB[0] = p;
                RGB[1] = q;
                RGB[2] = HSV2[2];
                break;
            }
            case 4: {
                RGB[0] = t;
                RGB[1] = p;
                RGB[2] = HSV2[2];
                break;
            }
            case 5: {
                RGB[0] = HSV2[2];
                RGB[1] = p;
                RGB[2] = q;
                break;
            }
            default: {
                throw new Error("Default, must not occured.");
            }
        }
    }

    public static BufferedImage HSV_To_RGB(BufferedImage HSV2) {
        int width = HSV2.getWidth();
        int height = HSV2.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage RGB = allocator.newBufferedImage(width, height, 1);
        allocator = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB.setRGB(x, y, HSV2.getRGB(x, y));
            }
        }
        return RGB;
    }

    public static BufferedImage RGB_To_HSB(BufferedImage RGB) {
        float[] array = new float[3];
        BufferedImage reshsb = ImageNew.HSB(RGB.getWidth(), RGB.getHeight());
        HSB hsb = new HSB();
        switch (RGB.getType()) {
            case 5: {
                byte[] bbrgb = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                float[] bbhls = ((DataBufferFloat)reshsb.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbrgb.length; x += 3) {
                    array[2] = (float)(bbrgb[x] & 0xFF) / 255.0f;
                    array[1] = (float)(bbrgb[x + 1] & 0xFF) / 255.0f;
                    array[0] = (float)(bbrgb[x + 2] & 0xFF) / 255.0f;
                    float[] res = hsb.fromRGB(array);
                    bbhls[x] = res[0];
                    bbhls[x + 1] = res[1];
                    bbhls[x + 2] = res[2];
                }
                bbrgb = null;
                bbhls = null;
                break;
            }
            default: {
                int width = RGB.getWidth();
                int height = RGB.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        reshsb.setRGB(x, y, RGB.getRGB(x, y));
                    }
                }
            }
        }
        return reshsb;
    }

    public static BufferedImage HSB_To_RGB(BufferedImage HSB2) {
        int width = HSB2.getWidth();
        int height = HSB2.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage RGB = allocator.newBufferedImage(width, height, 1);
        allocator = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB.setRGB(x, y, HSB2.getRGB(x, y));
            }
        }
        return RGB;
    }

    public static void RGB_To_HLS(double[] RGB, double[] HLS2) {
        double min;
        double max = RGB[0] >= RGB[1] && RGB[0] >= RGB[2] ? RGB[0] : (RGB[1] >= RGB[0] && RGB[1] >= RGB[2] ? RGB[1] : RGB[2]);
        if (Math.abs(max - (min = RGB[0] <= RGB[1] && RGB[0] <= RGB[2] ? RGB[0] : (RGB[1] <= RGB[0] && RGB[1] <= RGB[2] ? RGB[1] : RGB[2]))) < 1.0E-4) {
            HLS2[0] = 0.0;
        } else if (Math.abs(max - RGB[0]) < 1.0E-4) {
            HLS2[0] = (60.0 * (RGB[1] - RGB[2]) / (max - min) + 360.0) % 360.0;
        } else if (Math.abs(max - RGB[1]) < 1.0E-4) {
            HLS2[0] = 60.0 * (RGB[2] - RGB[0]) / (max - min) + 120.0;
        } else if (Math.abs(max - RGB[2]) < 1.0E-4) {
            HLS2[0] = 60.0 * (RGB[0] - RGB[1]) / (max - min) + 240.0;
        }
        HLS2[1] = (max + min) / 2.0;
        HLS2[2] = Math.abs(max - min) < 1.0E-4 ? 0.0 : (HLS2[1] > 0.5 ? (max - min) / (2.0 - 2.0 * HLS2[1]) : (max - min) / (2.0 * HLS2[1]));
    }

    public static BufferedImage RGB_To_HLS(BufferedImage RGB) {
        float[] array = new float[3];
        BufferedImage reshls = ImageNew.HLS(RGB.getWidth(), RGB.getHeight());
        HLS hls = new HLS();
        switch (RGB.getType()) {
            case 5: {
                byte[] bbrgb = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                float[] bbhls = ((DataBufferFloat)reshls.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbrgb.length; x += 3) {
                    array[2] = (float)(bbrgb[x] & 0xFF) / 255.0f;
                    array[1] = (float)(bbrgb[x + 1] & 0xFF) / 255.0f;
                    array[0] = (float)(bbrgb[x + 2] & 0xFF) / 255.0f;
                    float[] res = hls.fromRGB(array);
                    bbhls[x] = res[0];
                    bbhls[x + 1] = res[1];
                    bbhls[x + 2] = res[2];
                }
                bbrgb = null;
                bbhls = null;
                break;
            }
            default: {
                int width = RGB.getWidth();
                int height = RGB.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        reshls.setRGB(x, y, RGB.getRGB(x, y));
                    }
                }
            }
        }
        return reshls;
    }

    public static void HLS_To_RGB(double[] HLS2, double[] RGB) {
        int i;
        double q = HLS2[1] < 0.5 ? HLS2[1] * (1.0 + HLS2[2]) : HLS2[1] + HLS2[2] - HLS2[1] * HLS2[2];
        double p = 2.0 * HLS2[1] - q;
        double h = HLS2[0] / 360.0;
        double[] T = new double[]{h + 0.3333333, h, h - 0.3333333};
        for (i = 0; i < 3; ++i) {
            if (T[i] < 0.0) {
                int n = i;
                T[n] = T[n] + 1.0;
                continue;
            }
            if (!(T[i] > 1.0)) continue;
            int n = i;
            T[n] = T[n] - 1.0;
        }
        for (i = 0; i < 3; ++i) {
            if (T[i] < 0.16666666666666666) {
                RGB[i] = p + (q - p) * 6.0 * T[i];
                continue;
            }
            if (T[i] < 0.5) {
                RGB[i] = q;
                continue;
            }
            if (T[i] < 0.666666) {
                RGB[i] = p + (q - p) * 6.0 * (0.666666 - T[i]);
                continue;
            }
            T[i] = p;
        }
    }

    public static BufferedImage HLS_To_RGB(BufferedImage HLS2) {
        int width = HLS2.getWidth();
        int height = HLS2.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage RGB = allocator.newBufferedImage(width, height, 1);
        allocator = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB.setRGB(x, y, HLS2.getRGB(x, y));
            }
        }
        return RGB;
    }

    public static void RGB_To_YIQ(double[] RGB, double[] YIQ2) {
        YIQ2[0] = 0.299 * RGB[0] + 0.587 * RGB[1] + 0.114 * RGB[2];
        YIQ2[1] = 0.595716 * RGB[0] - 0.27453 * RGB[1] - 0.321263 * RGB[2];
        YIQ2[2] = 0.211456 * RGB[0] - 0.522591 * RGB[1] + 0.311135 * RGB[2];
    }

    public static BufferedImage RGB_To_YIQ(BufferedImage RGB) {
        BufferedImage YIQ2 = ImageNew.YIQ(RGB.getWidth(), RGB.getHeight());
        int width = RGB.getWidth();
        int height = RGB.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                YIQ2.setRGB(x, y, RGB.getRGB(x, y));
            }
        }
        return YIQ2;
    }

    public static void YIQ_To_RGB(double[] YIQ2, double[] RGB) {
        RGB[0] = YIQ2[0] + 0.9563 * YIQ2[1] + 0.621 * YIQ2[2];
        RGB[1] = YIQ2[0] - 0.2721 * YIQ2[1] - 0.6474 * YIQ2[2];
        RGB[2] = YIQ2[0] - 1.107 * YIQ2[1] + 1.7046 * YIQ2[2];
    }

    public static BufferedImage YIQ_To_RGB(BufferedImage YIQ2) {
        int width = YIQ2.getWidth();
        int height = YIQ2.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage RGB = allocator.newBufferedImage(width, height, 1);
        allocator = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB.setRGB(x, y, YIQ2.getRGB(x, y));
            }
        }
        return RGB;
    }

    public static void RGB_To_nRGB(double[] RGB, double[] nRGB) {
        double sum = RGB[0] + RGB[1] + RGB[2];
        nRGB[0] = RGB[0] / sum;
        nRGB[1] = RGB[1] / sum;
        nRGB[2] = RGB[2] / sum;
    }

    public static BufferedImage RGB_To_nRGB(BufferedImage RGB) {
        BufferedImage nRGB = ImageNew.NormalizedRGB(RGB.getWidth(), RGB.getHeight());
        int width = RGB.getWidth();
        int height = RGB.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                nRGB.setRGB(x, y, RGB.getRGB(x, y));
            }
        }
        return nRGB;
    }

    public static BufferedImage AddAlphaToColorImage(BufferedImage source, int Alpha) {
        if (!ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Source image must be a colored image.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        WritableRaster wr = source.getRaster();
        WritableRaster wrr = result.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wrr.setSample(x, y, 0, wr.getSample(x, y, 0));
                wrr.setSample(x, y, 1, wr.getSample(x, y, 1));
                wrr.setSample(x, y, 2, wr.getSample(x, y, 2));
                wrr.setSample(x, y, 3, Alpha);
            }
        }
        return result;
    }

    public static BufferedImage RGB_To_Lab(BufferedImage RGB) {
        float[] array = new float[3];
        BufferedImage reslab = ImageNew.Lab(RGB.getWidth(), RGB.getHeight());
        Lab lab = new Lab();
        switch (RGB.getType()) {
            case 5: {
                byte[] bbrgb = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                float[] bbhls = ((DataBufferFloat)reslab.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbrgb.length; x += 3) {
                    array[2] = (float)(bbrgb[x] & 0xFF) / 255.0f;
                    array[1] = (float)(bbrgb[x + 1] & 0xFF) / 255.0f;
                    array[0] = (float)(bbrgb[x + 2] & 0xFF) / 255.0f;
                    float[] res = lab.fromRGB(array);
                    bbhls[x] = res[0];
                    bbhls[x + 1] = res[1];
                    bbhls[x + 2] = res[2];
                }
                bbrgb = null;
                bbhls = null;
                break;
            }
            default: {
                int width = RGB.getWidth();
                int height = RGB.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        reslab.setRGB(x, y, RGB.getRGB(x, y));
                    }
                }
            }
        }
        return reslab;
    }

    public static BufferedImage GrayToBinary(BufferedImage source) {
        switch (source.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                BufferedImage result = ImageNew.Same(source, 12);
                WritableRaster wrr = result.getRaster();
                int pos = 0;
                for (int y = 0; y < source.getHeight(); ++y) {
                    int x = 0;
                    while (x < source.getWidth()) {
                        wrr.setSample(x, y, 0, bb[pos] == 0 ? 0 : 1);
                        ++x;
                        ++pos;
                    }
                }
                wrr = null;
                return result;
            }
            case 11: {
                return ImageConverter.UShortGrayToBinary(source);
            }
        }
        throw new IllegalArgumentException("Gray level (BYTE_GRAY or USHORT_GRAY) image required.");
    }

    public static BufferedImage GrayToUShort(BufferedImage source, boolean scale) {
        if (source.getType() != 10) {
            throw new IllegalArgumentException("8 bits image required.");
        }
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 11);
        ImageConverter.GrayToUShort(source, scale, result);
        return result;
    }

    public static void GrayToUShort(BufferedImage source, boolean scale, BufferedImage result) {
        if (source.getType() != 10) {
            throw new IllegalArgumentException("8 bits input/source image required.");
        }
        if (result.getType() != 11) {
            throw new IllegalArgumentException("16 bits output/result image required.");
        }
        int s = scale ? 8 : 0;
        byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
        short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < bbin.length; ++x) {
            sbout[x] = (short)((bbin[x] & 0xFF) << s);
        }
        ImageComparator.Compare(source, "!=", 255, result, 65535, result);
    }

    public static BufferedImage GrayToColor(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 5);
        allocator = null;
        ImageConverter.GrayToColor(source, result);
        return result;
    }

    public static void GrayToColor(BufferedImage source, BufferedImage result) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Gray level or binary image required.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        byte[] resbuf = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        block0 : switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (wr.getSample(x, y, 0) == 1) {
                            Arrays.fill(resbuf, pos, pos + 3, (byte)-1);
                        } else {
                            Arrays.fill(resbuf, pos, pos + 3, (byte)0);
                        }
                        ++x;
                        pos += 3;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] imbuf = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int posres = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Arrays.fill(resbuf, posres, posres + 3, imbuf[pos]);
                        ++x;
                        ++pos;
                        posres += 3;
                    }
                }
                imbuf = null;
                break;
            }
            case 11: {
                short[] imsbuf = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int posres = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Arrays.fill(resbuf, posres, posres + 3, (byte)((imsbuf[pos] & 0xFFFF) >> 8));
                        ++x;
                        ++pos;
                        posres += 3;
                    }
                }
                imsbuf = null;
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] imintbuf = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int posres = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                Arrays.fill(resbuf, posres, posres + 3, (byte)imintbuf[pos]);
                                ++x;
                                ++pos;
                                posres += 3;
                            }
                        }
                        imintbuf = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("This error must not occured.");
            }
        }
    }

    public static BufferedImage GrayToColorWithAlpha(BufferedImage source, int Alpha) {
        if (ImageTools.isColored(source)) {
            throw new IllegalArgumentException("Gray level or binary image required.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(width, height, 2);
        allocator = null;
        WritableRaster wr = source.getRaster();
        WritableRaster wrr = result.getRaster();
        switch (source.getType()) {
            case 12: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) == 1) {
                            wrr.setSample(x, y, 0, 255);
                            wrr.setSample(x, y, 1, 255);
                            wrr.setSample(x, y, 2, 255);
                            wrr.setSample(x, y, 3, Alpha);
                            continue;
                        }
                        wrr.setSample(x, y, 0, 0);
                        wrr.setSample(x, y, 1, 0);
                        wrr.setSample(x, y, 2, 0);
                        wrr.setSample(x, y, 3, Alpha);
                    }
                }
                break;
            }
            case 10: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int p = wr.getSample(x, y, 0);
                        wrr.setSample(x, y, 0, p);
                        wrr.setSample(x, y, 1, p);
                        wrr.setSample(x, y, 2, p);
                        wrr.setSample(x, y, 3, Alpha);
                    }
                }
                break;
            }
            case 11: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int p = (int)((double)wr.getSample(x, y, 0) / 255.0);
                        wrr.setSample(x, y, 0, p);
                        wrr.setSample(x, y, 1, p);
                        wrr.setSample(x, y, 2, p);
                        wrr.setSample(x, y, 3, Alpha);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("This error must not occured.");
            }
        }
        return result;
    }

    public static BufferedImage Channel(BufferedImage RGB, int channel) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        switch (RGB.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                result = allocator.newBufferedImage(RGB.getWidth(), RGB.getHeight(), 10);
                break;
            }
            case 5: {
                result = allocator.newBufferedImageDouble(RGB.getWidth(), RGB.getHeight(), 1);
                break;
            }
            case 4: {
                result = allocator.newBufferedImageFloat(RGB.getWidth(), RGB.getHeight(), 1);
                break;
            }
            case 3: {
                result = allocator.newBufferedImageInt(RGB.getWidth(), RGB.getHeight(), 1);
                break;
            }
            case 2: {
                result = allocator.newBufferedImage(RGB.getWidth(), RGB.getHeight(), 11);
                break;
            }
            case 1: {
                result = allocator.newBufferedImage(RGB.getWidth(), RGB.getHeight(), 11);
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer not supported (yet).");
            }
        }
        allocator = null;
        ImageConverter.Channel(RGB, channel, result);
        return result;
    }

    public static void Channel(BufferedImage RGB, int channel, BufferedImage result) {
        int nbchannel = RGB.getRaster().getNumBands();
        if (!ImageTools.areDimensionsEqual(RGB, result)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (RGB.getRaster().getDataBuffer().getDataType() != result.getRaster().getDataBuffer().getDataType()) {
            throw new IllegalArgumentException("Images have different DataBufferType.");
        }
        if (!ImageTools.isColored(RGB)) {
            throw new IllegalArgumentException("The RGB image is not a color image.");
        }
        block0 : switch (RGB.getType()) {
            case 5: 
            case 6: {
                byte[] rgbbbuffer = ((DataBufferByte)RGB.getRaster().getDataBuffer()).getData();
                byte[] resbbuffer = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i = channel;
                int n = 0;
                while (i < rgbbbuffer.length) {
                    resbbuffer[n] = rgbbbuffer[i];
                    i += nbchannel;
                    ++n;
                }
                resbbuffer = null;
                rgbbbuffer = null;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                WritableRaster wrrgb = RGB.getRaster();
                WritableRaster wrres = result.getRaster();
                int width = RGB.getWidth();
                int height = RGB.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrres.setSample(x, y, 0, wrrgb.getSample(x, y, channel));
                    }
                }
                wrres = null;
                wrrgb = null;
                break;
            }
            case 0: {
                switch (RGB.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] rgbdbuffer = ((DataBufferDouble)RGB.getRaster().getDataBuffer()).getData();
                        double[] resdbuffer = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                        int i = channel;
                        int n = 0;
                        while (i < rgbdbuffer.length) {
                            resdbuffer[n] = rgbdbuffer[i];
                            i += nbchannel;
                            ++n;
                        }
                        resdbuffer = null;
                        rgbdbuffer = null;
                        break block0;
                    }
                    case 4: {
                        float[] rgbfbuffer = ((DataBufferFloat)RGB.getRaster().getDataBuffer()).getData();
                        float[] resfbuffer = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                        int i = channel;
                        int n = 0;
                        while (i < rgbfbuffer.length) {
                            resfbuffer[n] = rgbfbuffer[i];
                            i += nbchannel;
                            ++n;
                        }
                        resfbuffer = null;
                        rgbfbuffer = null;
                        break block0;
                    }
                    case 3: {
                        WritableRaster wrrgb = RGB.getRaster();
                        WritableRaster wrres = result.getRaster();
                        int w = RGB.getWidth();
                        int h = RGB.getHeight();
                        for (int y = 0; y < h; ++y) {
                            for (int x = 0; x < w; ++x) {
                                wrres.setSample(x, y, 0, wrrgb.getSample(x, y, channel));
                            }
                        }
                        wrres = null;
                        wrrgb = null;
                        break block0;
                    }
                    case 1: {
                        short[] rgbsbuffer = ((DataBufferUShort)RGB.getRaster().getDataBuffer()).getData();
                        short[] ressbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                        int i = channel;
                        int n = 0;
                        while (i < rgbsbuffer.length) {
                            ressbuffer[n] = rgbsbuffer[i];
                            i += nbchannel;
                            ++n;
                        }
                        ressbuffer = null;
                        rgbsbuffer = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void SetChannel(BufferedImage source, int channel, BufferedImage rgb) {
        int nbchannel = rgb.getRaster().getNumBands();
        if (!ImageTools.areDimensionsEqual(source, rgb)) {
            throw new IllegalArgumentException("Images have different dimensions.");
        }
        if (source.getRaster().getDataBuffer().getDataType() != rgb.getRaster().getDataBuffer().getDataType()) {
            throw new IllegalArgumentException("Images have different DataBufferType.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                switch (rgb.getType()) {
                    case 5: 
                    case 6: {
                        byte[] srcbbuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                        byte[] rgbbbuffer = ((DataBufferByte)rgb.getRaster().getDataBuffer()).getData();
                        int x = 0;
                        int rgbpos = channel;
                        while (x < srcbbuffer.length) {
                            rgbbbuffer[rgbpos] = srcbbuffer[x];
                            ++x;
                            rgbpos += nbchannel;
                        }
                        rgbbbuffer = null;
                        srcbbuffer = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("The destination/RGB image DataBuffer type does not match the source image DataBuffer type.");
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public static BufferedImage[] Channel(BufferedImage[] RGB, int channel) {
        BufferedImage[] result = new BufferedImage[RGB.length];
        for (int i = 0; i < RGB.length; ++i) {
            result[i] = ImageConverter.Channel(RGB[i], channel);
        }
        return result;
    }

    public static void Channel(BufferedImage[] RGB, int channel, BufferedImage[] result) {
        if (RGB.length != result.length) {
            throw new IllegalArgumentException("RGB.length != result.length");
        }
        for (int i = 0; i < RGB.length; ++i) {
            ImageConverter.Channel(RGB[i], channel, result[i]);
        }
    }

    public static List<Coordinates> ImageToListOfPoints(BufferedImage source) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1000);
        ImageConverter.ImageToListOfPoints(source, list);
        return list;
    }

    public static void ImageToListOfPoints(BufferedImage source, List<Coordinates> list) {
        int height = source.getHeight();
        int width = source.getWidth();
        list.clear();
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < wr.getSample(x, y, 0)) {
                            list.add(new Coordinates(x, y, pos));
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < (bytebuffer[pos] & 0xFF)) {
                            list.add(new Coordinates(x, y, pos));
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < (shortbuffer[pos] & 0xFFFF)) {
                            list.add(new Coordinates(x, y, pos));
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static List<CoordinatesWeighted> ImageToListOfWeightedPoints(BufferedImage source) {
        ArrayList<CoordinatesWeighted> list = new ArrayList<CoordinatesWeighted>(1000);
        ImageConverter.ImageToListOfWeightedPoints(source, list);
        return list;
    }

    public static void ImageToListOfWeightedPoints(BufferedImage source, List<CoordinatesWeighted> list) {
        int height = source.getHeight();
        int width = source.getWidth();
        list.clear();
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < wr.getSample(x, y, 0)) {
                            list.add(new CoordinatesWeighted(x, y, 0, pos, 1));
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < (bytebuffer[pos] & 0xFF)) {
                            list.add(new CoordinatesWeighted(x, y, 0, pos, bytebuffer[pos] & 0xFF));
                        }
                        ++x;
                        ++pos;
                    }
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < (shortbuffer[pos] & 0xFFFF)) {
                            list.add(new CoordinatesWeighted(x, y, 0, pos, shortbuffer[pos] & 0xFFFF));
                        }
                        ++x;
                        ++pos;
                    }
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void ListOfPointsToImage(List<Coordinates> list, BufferedImage result) {
        WritableRaster wr = result.getRaster();
        for (Coordinates coord : list) {
            wr.setSample(coord.X, coord.Y, 0, 1);
        }
        wr = null;
    }

    public static BufferedImage IntToByte(BufferedImage source) {
        BufferedImage result;
        Allocator allocator = Allocator.Instance();
        block0 : switch (source.getType()) {
            case 2: {
                result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 6);
                break;
            }
            case 1: 
            case 4: {
                result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 5);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        if (source.getRaster().getNumBands() != 1) {
                            throw new IllegalArgumentException("Single channel/band required to convert CUSTOM images.");
                        }
                        result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 10);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (wished 'BufferedImage.TYPE_INT_'");
            }
        }
        allocator = null;
        ImageConverter.IntToByte(source, result);
        return result;
    }

    public static void IntToByte(BufferedImage source, BufferedImage result) {
        byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        int[] ib = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
        block0 : switch (source.getType()) {
            case 2: {
                if (result.getType() != 6) {
                    throw new IllegalArgumentException("Result image type does not match.");
                }
                if (bb.length != ib.length << 2) {
                    throw new IllegalArgumentException("Images dimensions do not match.");
                }
                int i = 0;
                int b = 0;
                while (i < ib.length) {
                    int p = ib[i];
                    bb[b] = (byte)((p & 0xFF000000) >> 24);
                    bb[b + 3] = (byte)((p & 0xFF0000) >> 16);
                    bb[b + 2] = (byte)((p & 0xFF00) >> 8);
                    bb[b + 1] = (byte)(p & 0xFF);
                    ++i;
                    b += 4;
                }
                break;
            }
            case 4: {
                if (result.getType() != 5) {
                    throw new IllegalArgumentException("Result image type does not match.");
                }
                if (bb.length != 3 * ib.length) {
                    throw new IllegalArgumentException("Images dimensions do not match.");
                }
                int i = 0;
                int b = 0;
                while (i < ib.length) {
                    int p = ib[i];
                    bb[b] = (byte)((p & 0xFF0000) >> 16);
                    bb[b + 1] = (byte)((p & 0xFF00) >> 8);
                    bb[b + 2] = (byte)(p & 0xFF);
                    ++i;
                    b += 3;
                }
                break;
            }
            case 1: {
                if (result.getType() != 5) {
                    throw new IllegalArgumentException("Result image type does not match.");
                }
                if (bb.length != 3 * ib.length) {
                    throw new IllegalArgumentException("Images dimensions do not match.");
                }
                int i = 0;
                int b = 0;
                while (i < ib.length) {
                    int p = ib[i];
                    bb[b + 2] = (byte)((p & 0xFF0000) >> 16);
                    bb[b + 1] = (byte)((p & 0xFF00) >> 8);
                    bb[b] = (byte)(p & 0xFF);
                    ++i;
                    b += 3;
                }
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        if (result.getType() != 10 || source.getRaster().getNumBands() != 1) {
                            throw new IllegalArgumentException("Result image type does not match.");
                        }
                        ArrayConverter.IntToByte(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (wished 'BufferedImage.TYPE_INT_'");
            }
        }
    }

    public static BufferedImage ByteToInt(BufferedImage source) {
        BufferedImage result = ImageNew.Integer(source.getWidth(), source.getHeight(), 1);
        ImageConverter.ByteToInt(source, result);
        return result;
    }

    public static void ByteToInt(BufferedImage source, BufferedImage result) {
        if (source.getType() != 10) {
            throw new IllegalArgumentException("source.getType() != BufferedImage.TYPE_USHORT_GRAY");
        }
        if (result.getType() != 0 && result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("result.getType() != BufferedImage.TYPE_CUSTOM && getDataType() != DataBuffer.TYPE_INT");
        }
        ArrayConverter.UnsignedByteToInt(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
    }

    public static BufferedImage IntToShort(BufferedImage source) {
        BufferedImage result;
        block0 : switch (source.getType()) {
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        if (source.getRaster().getNumBands() != 1) {
                            throw new IllegalArgumentException("Single channel/band required to convert CUSTOM images.");
                        }
                        Allocator allocator = Allocator.Instance();
                        result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), 11);
                        allocator = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (wished 'BufferedImage.TYPE_INT_'");
            }
        }
        ImageConverter.IntToShort(source, result);
        return result;
    }

    public static void IntToShort(BufferedImage source, BufferedImage result) {
        block0 : switch (source.getType()) {
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        if (result.getType() != 11 || source.getRaster().getNumBands() != 1) {
                            throw new IllegalArgumentException("Result image type does not match.");
                        }
                        ArrayConverter.IntToShort(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported;");
            }
        }
    }

    public static BufferedImage ShortToInt(BufferedImage source) {
        BufferedImage result = ImageNew.Integer(source.getWidth(), source.getHeight(), 1);
        ImageConverter.ShortToInt(source, result);
        return result;
    }

    public static void ShortToInt(BufferedImage source, BufferedImage result) {
        if (source.getType() != 11) {
            throw new IllegalArgumentException("source.getType() != BufferedImage.TYPE_USHORT_GRAY");
        }
        if (result.getType() != 0 && result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("result.getType() != BufferedImage.TYPE_CUSTOM && getDataType() != DataBuffer.TYPE_INT");
        }
        ArrayConverter.UnsignedShortToInt(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
    }

    public static BufferedImage Universal(BufferedImage source, int type) {
        Allocator allocator = Allocator.Instance();
        BufferedImage result = allocator.newBufferedImage(source.getWidth(), source.getHeight(), type);
        allocator = null;
        ImageConverter.Universal(source, result);
        return result;
    }

    public static void Universal(BufferedImage source, BufferedImage result) {
        if (!ImageTools.areDimensionsEqual(source, result)) {
            throw new IllegalArgumentException("Images have differents dimensions.");
        }
        WritableRaster wrs = source.getRaster();
        WritableRaster wrr = result.getRaster();
        if (wrs.getNumBands() != wrr.getNumBands()) {
            throw new IllegalArgumentException("Images have differents number of bands/channels.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int channel = result.getRaster().getNumBands();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int c = 0; c < channel; ++c) {
                    wrr.setSample(x, y, c, wrs.getSample(x, y, c));
                }
            }
        }
    }

    public static int[] ImageToIntArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        int[] tab = allocator.newIntArray(source.getWidth() * source.getHeight());
        allocator = null;
        ImageConverter.ImageToArray1D(source, tab);
        return tab;
    }

    public static void ImageToArray1D(BufferedImage source, int[] Tab) {
        int height = source.getHeight();
        int width = source.getWidth();
        int size = width * height;
        if (Tab.length != size) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[pos] = wr.getSample(x, y, 0);
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                ArrayConverter.UnsignedByteToInt(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            case 11: {
                ArrayConverter.UnsignedShortToInt(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static byte[] ImageToByteArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        byte[] tab = allocator.newByteArray(source.getHeight() * source.getWidth());
        allocator = null;
        ImageConverter.ImageToArray1D(source, tab);
        return tab;
    }

    public static void ImageToArray1D(BufferedImage source, byte[] Tab) {
        if (Tab.length != source.getRaster().getDataBuffer().getSize()) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 10: {
                System.arraycopy(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), 0, Tab, 0, Tab.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static byte[] ImageToShortArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        byte[] tab = allocator.newByteArray(source.getHeight() * source.getWidth());
        allocator = null;
        ImageConverter.ImageToArray1D(source, tab);
        return tab;
    }

    public static void ImageToArray1D(BufferedImage source, short[] Tab) {
        if (Tab.length != source.getRaster().getDataBuffer().getSize()) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 11: {
                System.arraycopy(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), 0, Tab, 0, Tab.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static boolean[] ImageToBooleanArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        boolean[] result = allocator.newBooleanArray(source.getHeight() * source.getWidth());
        allocator = null;
        ImageConverter.ImageToArray1D(source, result);
        return result;
    }

    public static void ImageToArray1D(BufferedImage source, boolean[] result) {
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        if (hauteur * largeur != result.length) {
            throw new IllegalArgumentException("Image and array have different dimensions.");
        }
        switch (source.getType()) {
            case 10: 
            case 11: 
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < hauteur; ++y) {
                    int x = 0;
                    while (x < largeur) {
                        result[pos] = wr.getSample(x, y, 0) != 0;
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level or binaries images supported.");
            }
        }
    }

    public static float[] ImageToFoatArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        float[] tab = allocator.newFloatArray(source.getWidth() * source.getHeight());
        allocator = null;
        ImageConverter.ImageToArray1D(source, tab);
        return tab;
    }

    public static void ImageToArray1D(BufferedImage source, float[] Tab) {
        int height = source.getHeight();
        int width = source.getWidth();
        int length = width * height;
        if (Tab.length != length) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[pos] = wr.getSample(x, y, 0);
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                ArrayConverter.UnsignedByteToFloat(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            case 11: {
                ArrayConverter.UnsignedShortToFloat(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static double[] ImageToDoubleArray1D(BufferedImage source) {
        Allocator allocator = Allocator.Instance();
        double[] tab = allocator.newDoubleArray(source.getWidth() * source.getHeight());
        allocator = null;
        ImageConverter.ImageToArray1D(source, tab);
        return tab;
    }

    public static void ImageToArray1D(BufferedImage source, double[] Tab) {
        int height = source.getHeight();
        int width = source.getWidth();
        int length = width * height;
        if (Tab.length != length) {
            throw new IllegalArgumentException("BufferedImage and array have different dimensions.");
        }
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Tab[pos] = wr.getSample(x, y, 0);
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                ArrayConverter.UnsignedByteToDouble(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            case 11: {
                ArrayConverter.UnsignedShortToDouble(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), Tab);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage ArrayToImage(double[] tab, int width, int height) {
        if (tab.length != width * height) {
            throw new IllegalArgumentException("tab.length != width * height.");
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        double min = af.Minimum(tab);
        double max = af.Maximum(tab);
        result = min < 0.0 ? ImageNew.Double(width, height, 1) : (max <= 1.0 ? allocator.newBufferedImage(width, height, 12) : (max <= 255.0 ? allocator.newBufferedImage(width, height, 10) : (max <= 65535.0 ? allocator.newBufferedImage(width, height, 11) : ImageNew.Double(width, height, 1))));
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(double[] tab, BufferedImage result) {
        if (result.getRaster().getDataBuffer().getSize() != tab.length) {
            throw new IllegalArgumentException("result.getHeight()*result.getWidth() != tab.length.");
        }
        block0 : switch (result.getType()) {
            case 10: {
                ArrayConverter.DoubleToByte(tab, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.DoubleToShort(tab, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        System.arraycopy(tab, 0, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                        break block0;
                    }
                    case 4: {
                        ArrayConverter.DoubleToFloat(tab, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        ArrayConverter.DoubleToInt(tab, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(double[][] tab) {
        int width = tab[0].length;
        int height = tab.length;
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        double min = af.Minimum(tab);
        double max = af.Maximum(tab);
        result = min < 0.0 ? ImageNew.Double(width, height, 1) : (max <= 1.0 ? allocator.newBufferedImage(width, height, 12) : (max <= 255.0 ? allocator.newBufferedImage(width, height, 10) : (max <= 65535.0 ? allocator.newBufferedImage(width, height, 11) : ImageNew.Double(width, height, 1))));
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(double[][] tab, BufferedImage result) {
        int width = result.getWidth();
        int height = result.getHeight();
        if (width != tab[0].length || height != tab.length) {
            throw new IllegalArgumentException("Array and image have different dimensions.");
        }
        block0 : switch (result.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        bb[pos] = (byte)tab[y][x];
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        sb[pos] = (short)tab[y][x];
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        int y = 0;
                        int pos = 0;
                        while (y < height) {
                            System.arraycopy(tab[y], 0, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), pos, width);
                            ++y;
                            pos += width;
                        }
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                fb[pos] = (float)tab[y][x];
                                ++x;
                                ++pos;
                            }
                        }
                        fb = null;
                        break block0;
                    }
                    case 3: {
                        int[] ib = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                ib[pos] = (int)tab[y][x];
                                ++x;
                                ++pos;
                            }
                        }
                        ib = null;
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported (yet)");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(float[] tab, int width, int height) {
        if (tab.length != width * height) {
            throw new IllegalArgumentException("tab.length != width * height.");
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        float min = (float)af.Minimum(tab);
        float max = (float)af.Maximum(tab);
        result = (double)min < 0.0 ? ImageNew.Float(width, height, 1) : ((double)max <= 1.0 ? allocator.newBufferedImage(width, height, 12) : ((double)max <= 255.0 ? allocator.newBufferedImage(width, height, 10) : ((double)max <= 65535.0 ? allocator.newBufferedImage(width, height, 11) : ImageNew.Float(width, height, 1))));
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(float[] tab, BufferedImage result) {
        if (result.getHeight() * result.getWidth() != tab.length) {
            throw new IllegalArgumentException("result.getHeight()*result.getWidth() != tab.length.");
        }
        block0 : switch (result.getType()) {
            case 10: {
                ArrayConverter.FloatToByte(tab, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.FloatToShort(tab, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        System.arraycopy(tab, 0, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                        break block0;
                    }
                    case 5: {
                        ArrayConverter.FloatToDouble(tab, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        ArrayConverter.FloatToInt(tab, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(int[] tab, int width, int height) {
        if (tab.length != width * height) {
            throw new IllegalArgumentException("tab.length != width * height.");
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        int min = af.Minimum(tab);
        int max = af.Maximum(tab);
        result = min < 0 ? ImageNew.Integer(width, height, 1) : (max <= 1 ? allocator.newBufferedImage(width, height, 12) : (max <= 255 ? allocator.newBufferedImage(width, height, 10) : (max <= 65535 ? allocator.newBufferedImage(width, height, 11) : ImageNew.Integer(width, height, 1))));
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(int[] tab, BufferedImage result) {
        if (result.getHeight() * result.getWidth() != tab.length) {
            throw new IllegalArgumentException("result.getHeight()*result.getWidth() != tab.length.");
        }
        block0 : switch (result.getType()) {
            case 12: {
                int pos = 0;
                for (int y = 0; y < result.getHeight(); ++y) {
                    int x = 0;
                    while (x < result.getWidth()) {
                        result.getRaster().setSample(x, y, 0, tab[pos]);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 10: {
                ArrayConverter.IntToByte(tab, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayConverter.IntToShort(tab, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        System.arraycopy(tab, 0, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                        break block0;
                    }
                    case 4: {
                        ArrayConverter.IntToFloat(tab, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        ArrayConverter.IntToDouble(tab, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(int[][] tab) {
        int width = tab[0].length;
        int height = tab.length;
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        int min = af.Minimum(tab);
        int max = af.Maximum(tab);
        result = min < 0 ? ImageNew.Integer(width, height, 1) : (max <= 1 ? allocator.newBufferedImage(width, height, 12) : (max <= 255 ? allocator.newBufferedImage(width, height, 10) : (max <= 65535 ? allocator.newBufferedImage(width, height, 11) : ImageNew.Integer(width, height, 1))));
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(int[][] tab, BufferedImage result) {
        int width = result.getWidth();
        int height = result.getHeight();
        if (width != tab[0].length || height != tab.length) {
            throw new IllegalArgumentException("Array and image have different dimensions.");
        }
        block0 : switch (result.getType()) {
            case 12: {
                WritableRaster wr = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, tab[y][x] != 0 ? 1 : 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        bb[pos] = (byte)tab[y][x];
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        sb[pos] = (short)tab[y][x];
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int y = 0;
                        int pos = 0;
                        while (y < height) {
                            System.arraycopy(tab[y], 0, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), pos, width);
                            ++y;
                            pos += width;
                        }
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                fb[pos] = tab[y][x];
                                ++x;
                                ++pos;
                            }
                        }
                        fb = null;
                        break block0;
                    }
                    case 5: {
                        double[] db = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                db[pos] = tab[y][x];
                                ++x;
                                ++pos;
                            }
                        }
                        db = null;
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported (yet)");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(byte[] tab, int width, int height) {
        if (tab.length != width * height) {
            throw new IllegalArgumentException("tab.length != width * height.");
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        int max = af.Maximum(tab);
        if (max <= 1) {
            result = allocator.newBufferedImage(width, height, 12);
        } else if (max <= 255) {
            result = allocator.newBufferedImage(width, height, 10);
        } else {
            throw new Error("Must not occured.");
        }
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(byte[] tab, BufferedImage result) {
        if (result.getHeight() * result.getWidth() != tab.length) {
            throw new IllegalArgumentException("result.getHeight()*result.getWidth() != tab.length.");
        }
        block0 : switch (result.getType()) {
            case 10: {
                System.arraycopy(tab, 0, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                break;
            }
            case 11: {
                ArrayConverter.UnsignedByteToShort(tab, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayConverter.UnsignedByteToInt(tab, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayConverter.UnsignedByteToFloat(tab, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        ArrayConverter.UnsignedByteToDouble(tab, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage ArrayToImage(short[] tab, int width, int height) {
        if (tab.length != width * height) {
            throw new IllegalArgumentException("tab.length != width * height.");
        }
        Allocator allocator = Allocator.Instance();
        BufferedImage result = null;
        ArrayFeatures af = new ArrayFeatures();
        int max = af.Maximum(tab);
        if (max <= 1) {
            result = allocator.newBufferedImage(width, height, 12);
        } else if (max <= 255) {
            result = allocator.newBufferedImage(width, height, 10);
        } else if (max <= 65535) {
            result = allocator.newBufferedImage(width, height, 11);
        } else {
            throw new Error("Must not occured.");
        }
        allocator = null;
        af = null;
        ImageConverter.ArrayToImage(tab, result);
        return result;
    }

    public static void ArrayToImage(short[] tab, BufferedImage result) {
        if (result.getHeight() * result.getWidth() != tab.length) {
            throw new IllegalArgumentException("result.getHeight()*result.getWidth() != tab.length.");
        }
        block0 : switch (result.getType()) {
            case 10: {
                ArrayConverter.UnsignedShortToByte(tab, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                System.arraycopy(tab, 0, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), 0, tab.length);
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayConverter.UnsignedShortToInt(tab, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayConverter.UnsignedShortToFloat(tab, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        ArrayConverter.UnsignedShortToDouble(tab, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet)");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
    }

    public static BufferedImage CustomTo(BufferedImage source, int type) {
        BufferedImage result = ImageNew.Same(source, type);
        ImageConverter.CustomTo(source, result);
        return result;
    }

    public static void CustomTo(BufferedImage source, BufferedImage result) {
        if (source.getType() != 0) {
            throw new IllegalArgumentException("A TYPE_CUSTOM image is required.");
        }
        if (source.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only images with a single channel supported (yet).");
        }
        switch (result.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < bb.length; ++i) {
                            bb[i] = (byte)db[i];
                        }
                        db = null;
                        break;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < bb.length; ++i) {
                            bb[i] = (byte)fb[i];
                        }
                        fb = null;
                        break;
                    }
                    case 3: {
                        int[] ib = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < bb.length; ++i) {
                            bb[i] = (byte)ib[i];
                        }
                        ib = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Source image DataBuffer type not supported (yet).");
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < sb.length; ++i) {
                            sb[i] = (short)db[i];
                        }
                        db = null;
                        break;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < sb.length; ++i) {
                            sb[i] = (short)fb[i];
                        }
                        fb = null;
                        break;
                    }
                    case 3: {
                        int[] ib = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < sb.length; ++i) {
                            sb[i] = (short)ib[i];
                        }
                        ib = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Source image DataBuffer type not supported (yet).");
                    }
                }
                sb = null;
                break;
            }
            case 12: {
                ImageConverter.Universal(source, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Resulting type not supported (yet).");
            }
        }
    }

    public static BufferedImage ToCustomInt(BufferedImage source) {
        BufferedImage result = ImageNew.Integer(source.getWidth(), source.getHeight(), source.getRaster().getNumBands());
        ImageConverter.ToCustomInt(source, result);
        return result;
    }

    public static void ToCustomInt(BufferedImage source, BufferedImage result) {
        if (source.getRaster().getNumBands() != result.getRaster().getNumBands()) {
            throw new IllegalArgumentException("Images don't have the same number of channels.");
        }
        int[] bres = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        switch (source.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bb.length; ++i) {
                    bres[i] = bb[i] & 0xFF;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < sb.length; ++i) {
                    bres[i] = sb[i] & 0xFFFF;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public static BufferedImage ToCustomFloat(BufferedImage source) {
        BufferedImage result = ImageNew.Float(source.getWidth(), source.getHeight(), source.getRaster().getNumBands());
        ImageConverter.ToCustomFloat(source, result);
        return result;
    }

    public static void ToCustomFloat(BufferedImage source, BufferedImage result) {
        if (source.getRaster().getNumBands() != result.getRaster().getNumBands()) {
            throw new IllegalArgumentException("Images don't have the same number of channels.");
        }
        float[] bres = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
        switch (source.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bb.length; ++i) {
                    bres[i] = bb[i] & 0xFF;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < sb.length; ++i) {
                    bres[i] = sb[i] & 0xFFFF;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public static BufferedImage ToCustomDouble(BufferedImage source) {
        BufferedImage result = ImageNew.Float(source.getWidth(), source.getHeight(), source.getRaster().getNumBands());
        ImageConverter.ToCustomDouble(source, result);
        return result;
    }

    public static void ToCustomDouble(BufferedImage source, BufferedImage result) {
        if (source.getRaster().getNumBands() != result.getRaster().getNumBands()) {
            throw new IllegalArgumentException("Images don't have the same number of channels.");
        }
        double[] bres = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
        switch (source.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bb.length; ++i) {
                    bres[i] = bb[i] & 0xFF;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < sb.length; ++i) {
                    bres[i] = sb[i] & 0xFFFF;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Source image type not supported (yet).");
            }
        }
    }

    public static BufferedImage IntToABGR(BufferedImage source) {
        BufferedImage result = ImageNew.Same(source, 6);
        ImageConverter.IntToABGR(source, result);
        return result;
    }

    public static void IntToABGR(BufferedImage source, BufferedImage result) {
        if (source.getType() != 0 || source.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The source image is not TYPE_CUSTOM with TYPE_INT DataBuffer");
        }
        if (source.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The source image has more than 1 channel.");
        }
        if (result.getType() != 6) {
            throw new IllegalArgumentException("The result image is not TYPE_4BYTE_ABGR");
        }
        int[] ib = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
        byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        int i = 0;
        int b = 0;
        while (i < ib.length) {
            int val = ib[i];
            bb[b] = (byte)(val >> 24 & 0xFF);
            bb[b + 1] = (byte)(val >> 16 & 0xFF);
            bb[b + 2] = (byte)(val >> 8 & 0xFF);
            bb[b + 3] = (byte)(val & 0xFF);
            ++i;
            b += 4;
        }
    }

    public static BufferedImage RGBtoInt(BufferedImage source) {
        BufferedImage result = ImageNew.Integer(source.getWidth(), source.getHeight(), 1);
        ImageConverter.RGBtoInt(source, result);
        return result;
    }

    public static void RGBtoInt(BufferedImage source, BufferedImage result) {
        if (result.getType() != 0 && result.getRaster().getDataBuffer().getDataType() != 3) {
            throw new IllegalArgumentException("The result image is not TYPE_CUSTOM with TYPE_INT DataBuffer");
        }
        if (result.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("The result image has more than 1 channel.");
        }
        byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
        int[] ib = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        switch (source.getType()) {
            case 5: {
                int i = 0;
                int b = 0;
                while (i < ib.length) {
                    int val = bb[b + 2] & 0xFF;
                    val |= (bb[b + 1] & 0xFF) << 8;
                    ib[i] = val |= (bb[b] & 0xFF) << 16;
                    ++i;
                    b += 3;
                }
                break;
            }
            case 6: {
                int i = 0;
                int b = 0;
                while (i < ib.length) {
                    int val = bb[b + 3] & 0xFF;
                    val |= (bb[b + 2] & 0xFF) << 8;
                    val |= (bb[b + 1] & 0xFF) << 16;
                    ib[i] = val |= (bb[b] & 0xFF) << 24;
                    ++i;
                    b += 4;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The source image is not TYPE_3BYTE_BGR neither TYPE_4BYTE_ABGR");
            }
        }
    }

    public static BufferedImage RemoveAlpha(BufferedImage source) {
        if (source.getType() != 6) {
            throw new IllegalArgumentException("source.getType() != BufferedImage.TYPE_4BYTE_ABGR");
        }
        BufferedImage result = ImageNew.Same(source, 5);
        ImageConverter.RemoveAlpha(source, result);
        return result;
    }

    public static void RemoveAlpha(BufferedImage source, BufferedImage result) {
        if (source.getType() != 6) {
            throw new IllegalArgumentException("source.getType() != BufferedImage.TYPE_4BYTE_ABGR");
        }
        if (result.getType() != 5) {
            throw new IllegalArgumentException("result.getType() != BufferedImage.TYPE_3BYTE_BGR");
        }
        byte[] bbsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
        byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        int bgr = 0;
        for (int abgr = 0; abgr < bbsrc.length; abgr += 4) {
            bbres[bgr] = bbsrc[abgr + 1];
            bbres[bgr + 1] = bbsrc[abgr + 2];
            bbres[bgr + 2] = bbsrc[abgr + 3];
            bgr += 3;
        }
    }
}

