/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayOperations;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import utils.memory.Allocator;

public final class ImageOperations {
    public static BufferedImage Maximum(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same(Original1);
        ImageOperations.Maximum(Original1, Original2, result);
        return result;
    }

    public static void Maximum(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (!ImageTools.areDimensionsAndTypeEqual(Original1, Original2) || !ImageTools.areDimensionsAndTypeEqual(Original1, Result)) {
            throw new IllegalArgumentException("Images must have same dimensions and type.");
        }
        switch (Original1.getType()) {
            case 12: {
                byte[] buffer1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] buffer2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareBinaries(buffer1, ">=", buffer2, buffer1, buffer2, bufferout, Original1.getWidth(), Original1.getHeight());
                bufferout = null;
                buffer2 = null;
                buffer1 = null;
                break;
            }
            case 11: {
                short[] shortbuffer1 = ((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData();
                short[] shortbuffer2 = ((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned(shortbuffer1, ">=", shortbuffer2, shortbuffer1, shortbuffer2, shortbufferout);
                shortbufferout = null;
                shortbuffer2 = null;
                shortbuffer1 = null;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebuffer1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] bytebuffer2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned(bytebuffer1, ">=", bytebuffer2, bytebuffer1, bytebuffer2, bytebufferout);
                bytebufferout = null;
                bytebuffer2 = null;
                bytebuffer1 = null;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                int width = Original1.getWidth();
                int height = Original1.getHeight();
                WritableRaster wr1 = Original1.getRaster();
                WritableRaster wr2 = Original2.getRaster();
                WritableRaster wrr = Result.getRaster();
                int channel = wrr.getNumBands();
                for (int c = 0; c < channel; ++c) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            if (wr1.getSample(x, y, c) <= wr2.getSample(x, y, c)) {
                                wrr.setSample(x, y, c, wr2.getSample(x, y, c));
                                continue;
                            }
                            wrr.setSample(x, y, c, wr1.getSample(x, y, c));
                        }
                    }
                }
                wrr = null;
                wr2 = null;
                wr1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage Minimum(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same(Original1);
        ImageOperations.Minimum(Original1, Original2, result);
        return result;
    }

    public static void Minimum(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (!ImageTools.areDimensionsAndTypeEqual(Original1, Original2) || !ImageTools.areDimensionsAndTypeEqual(Original1, Result)) {
            throw new IllegalArgumentException("Images must have same dimensions and type.");
        }
        switch (Original1.getType()) {
            case 12: {
                byte[] buffer1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] buffer2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareBinaries(buffer1, "<=", buffer2, buffer1, buffer2, bufferout, Original1.getWidth(), Original1.getHeight());
                bufferout = null;
                buffer2 = null;
                buffer1 = null;
                break;
            }
            case 11: {
                short[] shortbuffer1 = ((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData();
                short[] shortbuffer2 = ((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned(shortbuffer1, "<=", shortbuffer2, shortbuffer1, shortbuffer2, shortbufferout);
                shortbufferout = null;
                shortbuffer2 = null;
                shortbuffer1 = null;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebuffer1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] bytebuffer2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.CompareUnsigned(bytebuffer1, "<=", bytebuffer2, bytebuffer1, bytebuffer2, bytebufferout);
                bytebufferout = null;
                bytebuffer2 = null;
                bytebuffer1 = null;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                int[] intbuffer1 = ((DataBufferInt)Original1.getRaster().getDataBuffer()).getData();
                int[] intbuffer2 = ((DataBufferInt)Original2.getRaster().getDataBuffer()).getData();
                int[] intbufferout = ((DataBufferInt)Result.getRaster().getDataBuffer()).getData();
                ArrayComparator.Compare(intbuffer1, "<=", intbuffer2, intbuffer1, intbuffer2, intbufferout);
                intbufferout = null;
                intbuffer2 = null;
                intbuffer1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage Differences(BufferedImage im1, BufferedImage im2) {
        BufferedImage result = ImageNew.Same(im1);
        ImageOperations.Differences(im1, im2, result);
        return result;
    }

    public static void Differences(BufferedImage im1, BufferedImage im2, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual(im1, im2)) {
            throw new IllegalArgumentException("Differents images types or dimensions.");
        }
        block0 : switch (im1.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 12: {
                int width = im1.getWidth();
                int height = im1.getHeight();
                WritableRaster wr1 = im1.getRaster();
                WritableRaster wr2 = im2.getRaster();
                WritableRaster wrd = result.getRaster();
                int channel = wr1.getNumBands();
                for (int c = 0; c < channel; ++c) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            wrd.setSample(x, y, c, Math.abs(wr1.getSample(x, y, c) - wr2.getSample(x, y, c)));
                        }
                    }
                }
                wrd = null;
                wr2 = null;
                wr1 = null;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebuffer1 = ((DataBufferByte)im1.getRaster().getDataBuffer()).getData();
                byte[] bytebuffer2 = ((DataBufferByte)im2.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                ArrayOperations.DifferencesUnsigned(bytebuffer1, bytebuffer2, bytebufferout);
                bytebufferout = null;
                bytebuffer2 = null;
                bytebuffer1 = null;
                break;
            }
            case 11: {
                short[] shortbuffer1 = ((DataBufferUShort)im1.getRaster().getDataBuffer()).getData();
                short[] shortbuffer2 = ((DataBufferUShort)im2.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                ArrayOperations.DifferencesUnsigned(shortbuffer1, shortbuffer2, shortbufferout);
                shortbufferout = null;
                shortbuffer2 = null;
                shortbuffer1 = null;
                break;
            }
            case 0: {
                switch (im1.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] intbuffer1 = ((DataBufferInt)im1.getRaster().getDataBuffer()).getData();
                        int[] intbuffer2 = ((DataBufferInt)im2.getRaster().getDataBuffer()).getData();
                        int[] intbufferout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        ArrayOperations.Differences(intbuffer1, intbuffer2, intbufferout);
                        intbufferout = null;
                        intbuffer2 = null;
                        intbuffer1 = null;
                        break block0;
                    }
                    case 4: {
                        float[] floatbuffer1 = ((DataBufferFloat)im1.getRaster().getDataBuffer()).getData();
                        float[] floatbuffer2 = ((DataBufferFloat)im2.getRaster().getDataBuffer()).getData();
                        float[] floatbufferout = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                        ArrayOperations.Differences(floatbuffer1, floatbuffer2, floatbufferout);
                        floatbufferout = null;
                        floatbuffer2 = null;
                        floatbuffer1 = null;
                        break block0;
                    }
                    case 5: {
                        double[] doublebuffer1 = ((DataBufferDouble)im1.getRaster().getDataBuffer()).getData();
                        double[] doublebuffer2 = ((DataBufferDouble)im2.getRaster().getDataBuffer()).getData();
                        double[] doublebufferout = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                        ArrayOperations.Differences(doublebuffer1, doublebuffer2, doublebufferout);
                        doublebufferout = null;
                        doublebuffer2 = null;
                        doublebuffer1 = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void Fill(BufferedImage image, int Value) {
        block0 : switch (image.getType()) {
            case 12: {
                Arrays.fill(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), Value == 0 ? (byte)0 : -1);
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                Arrays.fill(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), (byte)Value);
                break;
            }
            case 11: {
                Arrays.fill(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), (short)Value);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                Arrays.fill(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), Value);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        Arrays.fill(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), Value);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void Fill(BufferedImage image, float Value) {
        if (image.getType() != 0) {
            throw new IllegalArgumentException("A float value can be set only in a TYPE_CUSTOM image with a DataBufferFloat.");
        }
        if (image.getRaster().getDataBuffer().getDataType() != 4) {
            throw new IllegalArgumentException("TYPE_FLOAT DataBuffer required.");
        }
        Arrays.fill(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), Value);
    }

    public static void Fill(BufferedImage image, double Value) {
        if (image.getType() != 0) {
            throw new IllegalArgumentException("A double value can be set only in a TYPE_CUSTOM image with a DataBufferDouble.");
        }
        if (image.getRaster().getDataBuffer().getDataType() != 5) {
            throw new IllegalArgumentException("TYPE_DOUBLE DataBuffer required.");
        }
        Arrays.fill(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), Value);
    }

    public static void Fill(BufferedImage image, int R, int G, int B) {
        int channel = 3;
        switch (image.getType()) {
            case 5: {
                byte[] bytebuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bytebuffer.length; i += 3) {
                    bytebuffer[i] = (byte)B;
                    bytebuffer[i + 1] = (byte)G;
                    bytebuffer[i + 2] = (byte)R;
                }
                bytebuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void FillChannel(BufferedImage image, int channel, int value) {
        int nbchannel = image.getRaster().getNumBands();
        if (channel >= nbchannel) {
            throw new IllegalArgumentException("This channel doesn't exist in this image");
        }
        block0 : switch (image.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i = channel; i < bytebuffer.length; i += nbchannel) {
                    bytebuffer[i] = (byte)value;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int i = channel; i < shortbuffer.length; i += nbchannel) {
                    shortbuffer[i] = (short)value;
                }
                shortbuffer = null;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                int[] intbuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i = channel; i < intbuffer.length; i += nbchannel) {
                    intbuffer[i] = value;
                }
                intbuffer = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        for (int i = channel; i < fb.length; i += nbchannel) {
                            fb[i] = value;
                        }
                        fb = null;
                        break block0;
                    }
                    case 3: {
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        for (int i = channel; i < ib.length; i += nbchannel) {
                            ib[i] = value;
                        }
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void FillRandomly(BufferedImage image) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillRandomly(bb);
                bb = null;
                break;
            }
            case 1: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillRandomly(sb);
                sb = null;
                break;
            }
            case 3: {
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillRandomly(ib);
                ib = null;
                break;
            }
            case 4: {
                float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillRandomly(fb, 0.0f, 1.0f);
                fb = null;
                break;
            }
            case 5: {
                double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillRandomly(db, 0.0, 1.0);
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
    }

    public static void FillGaussianRandomly(BufferedImage image, double sd) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillGaussianRandomly(bb, sd);
                bb = null;
                break;
            }
            case 1: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillGaussianRandomly(sb, sd);
                sb = null;
                break;
            }
            case 3: {
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillGaussianRandomly(ib, sd);
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
    }

    public static void FillIncreasingly(BufferedImage image) {
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillIncreasingly(bb);
                bb = null;
                break;
            }
            case 1: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillIncreasingly(sb);
                sb = null;
                break;
            }
            case 3: {
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                ArrayOperations.FillIncreasingly(ib);
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
    }

    public static BufferedImage Contour(BufferedImage image, boolean EightConnex) {
        BufferedImage result = ImageNew.Same(image);
        ImageOperations.Contour(image, EightConnex, result);
        return result;
    }

    public static void Contour(BufferedImage image, boolean EightConnex, BufferedImage result) {
        int width = image.getWidth();
        int height = image.getHeight();
        int w1 = width - 1;
        int h1 = height - 1;
        if (!ImageTools.areDimensionsAndTypeEqual(image, result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        ImageOperations.Fill(result, 0);
        block0 : switch (image.getType()) {
            case 12: {
                if (result.getType() != 12) {
                    throw new IllegalArgumentException("The resulting image is not binary.");
                }
                WritableRaster wro = image.getRaster();
                WritableRaster wrr = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wro.getSample(x, y, 0) == 0) continue;
                        if (x == 0 || y == 0 || x == w1 || y == h1) {
                            wrr.setSample(x, y, 0, 1);
                            continue;
                        }
                        if (wro.getSample(x - 1, y, 0) == 0 || wro.getSample(x + 1, y, 0) == 0 || wro.getSample(x, y - 1, 0) == 0 || wro.getSample(x, y + 1, 0) == 0) {
                            wrr.setSample(x, y, 0, 1);
                            continue;
                        }
                        if (EightConnex || wro.getSample(x - 1, y - 1, 0) != 0 && wro.getSample(x + 1, y - 1, 0) != 0 && wro.getSample(x - 1, y + 1, 0) != 0 && wro.getSample(x + 1, y + 1, 0) != 0) continue;
                        wrr.setSample(x, y, 0, 1);
                    }
                }
                wrr = null;
                wro = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((bb[pos] & 0xFF) != 0) {
                            if (x == 0 || y == 0 || x == w1 || y == h1) {
                                bbres[pos] = -1;
                            } else if ((bb[pos - 1] & 0xFF) == 0 || (bb[pos + 1] & 0xFF) == 0 || (bb[pos - width] & 0xFF) == 0 || (bb[pos + width] & 0xFF) == 0) {
                                bbres[pos] = -1;
                            } else if (!(EightConnex || (bb[pos - width - 1] & 0xFF) != 0 && (bb[pos - width + 1] & 0xFF) != 0 && (bb[pos + width - 1] & 0xFF) != 0 && (bb[pos + width + 1] & 0xFF) != 0)) {
                                bbres[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                bbres = null;
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((sb[pos] & 0xFFFF) != 0) {
                            if (x == 0 || y == 0 || x == w1 || y == h1) {
                                sbres[pos] = -1;
                            } else if ((sb[pos - 1] & 0xFFFF) == 0 || (sb[pos + 1] & 0xFFFF) == 0 || (sb[pos - width] & 0xFFFF) == 0 || (sb[pos + width] & 0xFFFF) == 0) {
                                sbres[pos] = -1;
                            } else if (!(EightConnex || (sb[pos - width - 1] & 0xFFFF) != 0 && (sb[pos - width + 1] & 0xFFFF) != 0 && (sb[pos + width - 1] & 0xFFFF) != 0 && (sb[pos + width + 1] & 0xFFFF) != 0)) {
                                sbres[pos] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                sbres = null;
                sb = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                        int[] ibres = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if (ib[pos] != 0) {
                                    if (x == 0 || y == 0 || x == w1 || y == h1) {
                                        ibres[pos] = Integer.MAX_VALUE;
                                    } else if (ib[pos - 1] == 0 || ib[pos + 1] == 0 || ib[pos - width] == 0 || ib[pos + width] == 0) {
                                        ibres[pos] = Integer.MAX_VALUE;
                                    } else if (!(EightConnex || ib[pos - width - 1] != 0 && ib[pos - width + 1] != 0 && ib[pos + width - 1] != 0 && ib[pos + width + 1] != 0)) {
                                        ibres[pos] = Integer.MAX_VALUE;
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        ibres = null;
                        ib = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static List<Coordinates> Contour(BufferedImage image, boolean EightConnex, int label, int minx, int miny, int maxx, int maxy) {
        int width = image.getWidth();
        int height = image.getHeight();
        List<Coordinates> result = null;
        block0 : switch (image.getType()) {
            case 10: {
                result = ArrayOperations.Contour(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, label, minx, miny, maxx, maxy);
                break;
            }
            case 11: {
                result = ArrayOperations.Contour(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, label, minx, miny, maxx, maxy);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        result = ArrayOperations.Contour(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, label, minx, miny, maxx, maxy);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return result;
    }

    public static List<Coordinates> Contour(BufferedImage image, boolean EightConnex, int minx, int miny, int maxx, int maxy) {
        int width = image.getWidth();
        int height = image.getHeight();
        List<Coordinates> result = null;
        block0 : switch (image.getType()) {
            case 10: {
                result = ArrayOperations.Contour(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, minx, miny, maxx, maxy);
                break;
            }
            case 11: {
                result = ArrayOperations.Contour(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, minx, miny, maxx, maxy);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        result = ArrayOperations.Contour(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width, height, EightConnex, minx, miny, maxx, maxy);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return result;
    }

    public static BufferedImage Resize(BufferedImage source, int Width, int Height) {
        Allocator allocator = Allocator.Instance();
        BufferedImage imout = allocator.newBufferedImage(Width, Height, source.getType());
        allocator = null;
        WritableRaster wrout = imout.getRaster();
        WritableRaster wrin = source.getRaster();
        int width = source.getWidth() < Width ? source.getWidth() : Width;
        int height = source.getHeight() < Height ? source.getHeight() : Height;
        switch (source.getType()) {
            case 10: 
            case 11: 
            case 12: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrout.setSample(x, y, 0, wrin.getSample(x, y, 0));
                    }
                }
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        for (int c = 0; c < 3; ++c) {
                            wrout.setSample(x, y, c, wrin.getSample(x, y, c));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
        wrout = null;
        wrin = null;
        return imout;
    }

    public static BufferedImage Padding(BufferedImage bufferIn, int width, int height, int Val) {
        BufferedImage result = ImageNew.New(width, height, bufferIn);
        ImageOperations.Padding(bufferIn, result, Val);
        return result;
    }

    public static void Padding(BufferedImage bufferIn, BufferedImage bufferOut, int Val) {
        int W = bufferIn.getWidth();
        int H = bufferIn.getHeight();
        int NewW = bufferOut.getWidth();
        int NewH = bufferOut.getHeight();
        int dx = NewW - W >> 1;
        int dy = NewH - H >> 1;
        WritableRaster wrin = bufferIn.getRaster();
        WritableRaster wrout = bufferOut.getRaster();
        ImageOperations.Fill(bufferOut, Val);
        for (int y = 0; y < H; ++y) {
            for (int x = 0; x < W; ++x) {
                wrout.setSample(x + dx, y + dy, 0, wrin.getSample(x, y, 0));
            }
        }
        wrout = null;
        wrin = null;
    }

    public static void UnPadding(BufferedImage bufferIn, BufferedImage bufferOut) {
        int W = bufferIn.getWidth();
        int H = bufferIn.getHeight();
        int NewW = bufferOut.getWidth();
        int NewH = bufferOut.getHeight();
        int dx = W - NewW >> 1;
        int dy = H - NewH >> 1;
        WritableRaster wrin = bufferIn.getRaster();
        WritableRaster wrout = bufferOut.getRaster();
        for (int y = 0; y < NewH; ++y) {
            for (int x = 0; x < NewW; ++x) {
                wrout.setSample(x, y, 0, wrin.getSample(x + dx, y + dy, 0));
            }
        }
        wrout = null;
        wrin = null;
    }

    public static BufferedImage Move(BufferedImage source, int deltax, int deltay, int filledvalue) {
        BufferedImage result = ImageNew.Same(source);
        ImageOperations.Move(source, result, deltax, deltay, filledvalue);
        return result;
    }

    public static void Move(BufferedImage source, BufferedImage result, int deltax, int deltay, int filledvalue) {
        if (0 <= deltax && 0 <= deltay) {
            ImageOperations.MoveForward(source, result, deltax, deltay, filledvalue);
        } else if (deltax <= 0 && deltay <= 0) {
            ImageOperations.MoveBackward(source, result, -deltax, -deltay, filledvalue);
        } else {
            ImageNew.Copy(source, result);
            if (0 < deltax) {
                ImageOperations.MoveForward(result, result, deltax, 0, filledvalue);
            } else if (deltax < 0) {
                ImageOperations.MoveBackward(result, result, -deltax, 0, filledvalue);
            }
            if (0 < deltay) {
                ImageOperations.MoveBackward(result, result, 0, deltay, filledvalue);
            } else if (deltay < 0) {
                ImageOperations.MoveBackward(result, result, 0, -deltay, filledvalue);
            }
        }
    }

    public static BufferedImage MoveBackward(BufferedImage source, int deltax, int deltay, int filledvalue) {
        BufferedImage result = ImageNew.Same(source);
        ImageOperations.MoveBackward(source, result, deltax, deltay, filledvalue);
        return result;
    }

    public static void MoveBackward(BufferedImage source, BufferedImage result, int deltax, int deltay, int filledvalue) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int w = width - deltax;
        int h = height - deltay;
        switch (source.getType()) {
            case 12: {
                int x;
                int y;
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                for (y = 0; y < h; ++y) {
                    for (x = 0; x < w; ++x) {
                        wrr.setSample(x, y, 0, wr.getSample(x + deltax, y + deltay, 0));
                    }
                }
                for (y = h; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        wrr.setSample(x, y, 0, filledvalue);
                    }
                }
                for (y = 0; y < height; ++y) {
                    for (x = w; x < width; ++x) {
                        wrr.setSample(x, y, 0, filledvalue);
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            case 10: {
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int gap = deltax + deltay * width;
                int pos = 0;
                int y = 0;
                while (y < h) {
                    System.arraycopy(bbin, pos + gap, bbout, pos, w);
                    Arrays.fill(bbout, pos + w, pos + width, (byte)filledvalue);
                    ++y;
                    pos += width;
                }
                Arrays.fill(bbout, pos, bbin.length, (byte)filledvalue);
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int gap = deltax + deltay * width;
                int pos = 0;
                int y = 0;
                while (y < h) {
                    System.arraycopy(sbin, pos + gap, sbout, pos, w);
                    Arrays.fill(sbout, pos + w, pos + width, (short)filledvalue);
                    ++y;
                    pos += width;
                }
                Arrays.fill(sbout, pos, sbin.length, (short)filledvalue);
                sbout = null;
                sbin = null;
                break;
            }
            case 5: 
            case 6: {
                byte[] cbbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] cbbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int channel = source.getRaster().getNumBands();
                int gap = channel * (deltax + deltay * width);
                w *= channel;
                int wc = width * channel;
                int pos = 0;
                int y = 0;
                while (y < h) {
                    System.arraycopy(cbbin, pos + gap, cbbout, pos, w);
                    Arrays.fill(cbbout, pos + w, pos + wc, (byte)filledvalue);
                    ++y;
                    pos += wc;
                }
                Arrays.fill(cbbout, pos, cbbin.length, (byte)filledvalue);
                cbbout = null;
                cbbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage MoveForward(BufferedImage source, int deltax, int deltay, int filledvalue) {
        BufferedImage result = ImageNew.Same(source);
        ImageOperations.MoveForward(source, result, deltax, deltay, filledvalue);
        return result;
    }

    public static void MoveForward(BufferedImage source, BufferedImage result, int deltax, int deltay, int filledvalue) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        if (deltax < 0) {
            throw new IllegalArgumentException("Delta X < 0");
        }
        if (deltay < 0) {
            throw new IllegalArgumentException("Delta Y < 0");
        }
        int pos = 0;
        int width = source.getWidth();
        int height = source.getHeight();
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                for (int y = height - 1; y >= deltay; --y) {
                    for (int x = width - 1; x >= deltax; --x) {
                        wrr.setSample(x, y, 0, wr.getSample(x - deltax, y - deltay, 0));
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            case 10: {
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int gap = deltax + deltay * width;
                for (int y = height - 1; y >= deltay; --y) {
                    int x = width - 1;
                    pos = x + y * width;
                    int p2 = pos - gap;
                    while (x >= deltax) {
                        bbout[pos] = bbin[p2];
                        --x;
                        --pos;
                        --p2;
                    }
                    while (x >= 0) {
                        bbout[pos] = (byte)filledvalue;
                        --x;
                        --pos;
                        --p2;
                    }
                }
                while (pos >= 0) {
                    bbout[pos] = (byte)filledvalue;
                    --pos;
                }
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int gap = deltax + deltay * width;
                for (int y = height - 1; y >= deltay; --y) {
                    int x = width - 1;
                    pos = x + y * width;
                    int p2 = pos - gap;
                    while (x >= deltax) {
                        sbout[pos] = sbin[p2];
                        --x;
                        --pos;
                        --p2;
                    }
                    while (x >= 0) {
                        sbout[pos] = (short)filledvalue;
                        --x;
                        --pos;
                    }
                }
                while (pos >= 0) {
                    sbout[pos] = (short)filledvalue;
                    --pos;
                }
                break;
            }
            case 5: 
            case 6: {
                byte[] cbbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] cbbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int channel = source.getRaster().getNumBands();
                int gap = channel * (deltax + deltay * width);
                for (int y = height - 1; y >= deltay; --y) {
                    int stop = channel * (y * width + deltax);
                    pos = channel * ((y + 1) * width) - 1;
                    int p2 = pos - gap;
                    while (pos >= stop) {
                        cbbout[pos] = cbbin[p2];
                        --pos;
                        --p2;
                    }
                    stop = channel * y * width;
                    while (pos >= stop) {
                        cbbout[pos] = (byte)filledvalue;
                        --pos;
                    }
                }
                while (pos >= 0) {
                    cbbout[pos] = (byte)filledvalue;
                    --pos;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void MoveCircularHorizontal(BufferedImage source, BufferedImage result, int delta) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int widthdelta = width + delta;
        int gap = source.getWidth() - Math.abs(delta);
        switch (source.getType()) {
            case 10: {
                byte[] srcbb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                if (0 < delta) {
                    int p = 0;
                    int posdel = 0;
                    int y = 0;
                    int pos = delta;
                    int pgap = gap;
                    while (y < height) {
                        int x = delta;
                        while (x < width) {
                            resbb[pos] = srcbb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                        x = 0;
                        while (x < delta) {
                            resbb[p] = srcbb[pgap];
                            ++x;
                            ++p;
                            ++pgap;
                        }
                        ++y;
                        pos += delta;
                        posdel += delta;
                        p += gap;
                        pgap += gap;
                    }
                } else {
                    int pgap = 0;
                    int pos = 0;
                    int y = 0;
                    int posdel = -delta;
                    int p = widthdelta;
                    while (y < height) {
                        int x = 0;
                        while (x < widthdelta) {
                            resbb[pos] = srcbb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                        x = widthdelta;
                        while (x < width) {
                            resbb[p] = srcbb[pgap];
                            ++x;
                            ++p;
                            ++pgap;
                        }
                        ++y;
                        pos -= delta;
                        posdel -= delta;
                        p += gap;
                        pgap += gap;
                    }
                }
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                short[] srcsb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ressb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                if (0 < delta) {
                    int p = 0;
                    int posdel = 0;
                    int y = 0;
                    int pos = delta;
                    int pgap = gap;
                    while (y < height) {
                        int x = delta;
                        while (x < width) {
                            ressb[pos] = srcsb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                        x = 0;
                        while (x < delta) {
                            ressb[p] = srcsb[pgap];
                            ++x;
                            ++p;
                            ++pgap;
                        }
                        ++y;
                        pos += delta;
                        posdel += delta;
                        p += gap;
                        pgap += gap;
                    }
                } else {
                    int pgap = 0;
                    int pos = 0;
                    int y = 0;
                    int posdel = -delta;
                    int p = widthdelta;
                    while (y < height) {
                        int x = 0;
                        while (x < widthdelta) {
                            ressb[pos] = srcsb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                        x = widthdelta;
                        while (x < width) {
                            ressb[p] = srcsb[pgap];
                            ++x;
                            ++p;
                            ++pgap;
                        }
                        ++y;
                        pos -= delta;
                        posdel -= delta;
                        p += gap;
                        pgap += gap;
                    }
                }
                ressb = null;
                srcsb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public static void MoveCircularVertical(BufferedImage source, BufferedImage result, int delta) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int gap = source.getHeight() - Math.abs(delta);
        switch (source.getType()) {
            case 10: {
                byte[] srcbb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                if (0 < delta) {
                    int x;
                    int y;
                    int heightdelta = height - delta;
                    int posdel = 0;
                    int pos = delta * width;
                    for (y = 0; y < heightdelta; ++y) {
                        x = 0;
                        while (x < width) {
                            resbb[pos] = srcbb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                    posdel = 0;
                    pos = gap * width;
                    for (y = 0; y < delta; ++y) {
                        x = 0;
                        while (x < width) {
                            resbb[posdel] = srcbb[pos];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                } else {
                    int x;
                    int y;
                    delta = -delta;
                    int heightdelta = height - delta;
                    int posdel = 0;
                    int pos = delta * width;
                    for (y = 0; y < heightdelta; ++y) {
                        x = 0;
                        while (x < width) {
                            resbb[posdel] = srcbb[pos];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                    posdel = 0;
                    pos = gap * width;
                    for (y = 0; y < delta; ++y) {
                        x = 0;
                        while (x < width) {
                            resbb[pos] = srcbb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                }
                resbb = null;
                srcbb = null;
                break;
            }
            case 11: {
                short[] srcsb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ressb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                if (0 < delta) {
                    int x;
                    int y;
                    int heightdelta = height - delta;
                    int posdel = 0;
                    int pos = delta * width;
                    for (y = 0; y < heightdelta; ++y) {
                        x = 0;
                        while (x < width) {
                            ressb[pos] = srcsb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                    posdel = 0;
                    pos = gap * width;
                    for (y = 0; y < delta; ++y) {
                        x = 0;
                        while (x < width) {
                            ressb[posdel] = srcsb[pos];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                } else {
                    int x;
                    int y;
                    delta = -delta;
                    int heightdelta = height - delta;
                    int posdel = 0;
                    int pos = delta * width;
                    for (y = 0; y < heightdelta; ++y) {
                        x = 0;
                        while (x < width) {
                            ressb[posdel] = srcsb[pos];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                    posdel = 0;
                    pos = gap * width;
                    for (y = 0; y < delta; ++y) {
                        x = 0;
                        while (x < width) {
                            ressb[pos] = srcsb[posdel];
                            ++x;
                            ++pos;
                            ++posdel;
                        }
                    }
                }
                ressb = null;
                srcsb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public static BufferedImage Lut(BufferedImage source, int[] lut) {
        BufferedImage result = ImageNew.Same(source);
        ImageOperations.Lut(source, lut, result);
        return result;
    }

    public static void Lut(BufferedImage source, int[] lut, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual(source, result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        block0 : switch (source.getType()) {
            case 10: {
                if (lut.length != 256) {
                    throw new IllegalArgumentException("lut.length != 256");
                }
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                ArrayOperations.Lut(bbin, lut, bbout);
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                if (lut.length != 65536) {
                    throw new IllegalArgumentException("lut.length != 65536");
                }
                short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                ArrayOperations.Lut(sbin, lut, sbout);
                sbout = null;
                sbin = null;
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibin = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int[] ibout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        ArrayOperations.Lut(ibin, lut, ibout);
                        ibout = null;
                        ibin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }
}

