/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import mathematics.primitives.pointsTiTi.Coordinates;

public class ImageTools {
    public static boolean areEqual(BufferedImage image1, BufferedImage image2) {
        if (!ImageTools.areDimensionsAndTypeEqual(image1, image2)) {
            return false;
        }
        switch (image1.getType()) {
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                return ArrayTools.AreEqual(((DataBufferByte)image1.getRaster().getDataBuffer()).getData(), ((DataBufferByte)image2.getRaster().getDataBuffer()).getData());
            }
            case 11: {
                return ArrayTools.AreEqual(((DataBufferUShort)image1.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData());
            }
            case 1: 
            case 2: 
            case 4: {
                return ArrayTools.AreEqual(((DataBufferInt)image1.getRaster().getDataBuffer()).getData(), ((DataBufferInt)image2.getRaster().getDataBuffer()).getData());
            }
            case 0: {
                switch (image1.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        return ArrayTools.AreEqual(((DataBufferDouble)image1.getRaster().getDataBuffer()).getData(), ((DataBufferDouble)image2.getRaster().getDataBuffer()).getData());
                    }
                    case 4: {
                        return ArrayTools.AreEqual(((DataBufferFloat)image1.getRaster().getDataBuffer()).getData(), ((DataBufferFloat)image2.getRaster().getDataBuffer()).getData());
                    }
                    case 3: {
                        return ArrayTools.AreEqual(((DataBufferInt)image1.getRaster().getDataBuffer()).getData(), ((DataBufferInt)image2.getRaster().getDataBuffer()).getData());
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
        }
        throw new IllegalArgumentException("Image type not supported.");
    }

    public static boolean areDimensionsAndValuesEqual(BufferedImage image1, BufferedImage image2) {
        if (!ImageTools.areDimensionsEqual(image1, image2)) {
            return false;
        }
        WritableRaster wr1 = image1.getRaster();
        WritableRaster wr2 = image2.getRaster();
        if (wr1.getNumBands() != wr2.getNumBands()) {
            throw new IllegalArgumentException("Images have differents number of bands/channels.");
        }
        int width = wr1.getWidth();
        int height = wr1.getHeight();
        int channel = wr1.getNumBands();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int c = 0; c < channel; ++c) {
                    if (wr1.getSample(x, y, c) == wr2.getSample(x, y, c)) continue;
                    return false;
                }
            }
        }
        wr2 = null;
        wr1 = null;
        return true;
    }

    public static boolean areDimensionsEqual(BufferedImage im1, BufferedImage im2) {
        return im1.getWidth() == im2.getWidth() && im1.getHeight() == im2.getHeight();
    }

    public static boolean areDimensionsAndTypeEqual(BufferedImage im1, BufferedImage im2) {
        if (im1.getType() != im2.getType()) {
            return false;
        }
        if (im1.getType() == 0 && im1.getRaster().getDataBuffer().getDataType() != im2.getRaster().getDataBuffer().getDataType()) {
            return false;
        }
        return ImageTools.areDimensionsEqual(im1, im2);
    }

    public static boolean isMinimumLocalStrict(BufferedImage source, int x, int y) {
        int width = source.getWidth();
        int pos = y * width + x;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int v = bytebuffer[pos] & 0xFF;
                if ((bytebuffer[pos - 1] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos + 1] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos - width] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos + width] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos - width - 1] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos - width + 1] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos + width - 1] & 0xFF) <= v) {
                    return false;
                }
                if ((bytebuffer[pos + width + 1] & 0xFF) <= v) {
                    return false;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int v = shortbuffer[pos] & 0xFFFF;
                if ((shortbuffer[pos - 1] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos + 1] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos - width] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos + width] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos - width - 1] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos - width + 1] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos + width - 1] & 0xFFFF) <= v) {
                    return false;
                }
                if ((shortbuffer[pos + width + 1] & 0xFFFF) <= v) {
                    return false;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        return true;
    }

    public static boolean isMaximumLocalStrict(BufferedImage source, int x, int y) {
        int width = source.getWidth();
        int pos = y * width + x;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int v = bytebuffer[pos] & 0xFF;
                if ((bytebuffer[pos - 1] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos + 1] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos - width] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos + width] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos - width - 1] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos - width + 1] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos + width - 1] & 0xFF) >= v) {
                    return false;
                }
                if ((bytebuffer[pos + width + 1] & 0xFF) >= v) {
                    return false;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int v = shortbuffer[pos] & 0xFFFF;
                if ((shortbuffer[pos - 1] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos + 1] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos - width] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos + width] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos - width - 1] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos - width + 1] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos + width - 1] & 0xFFFF) >= v) {
                    return false;
                }
                if ((shortbuffer[pos + width + 1] & 0xFFFF) >= v) {
                    return false;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        return true;
    }

    public static boolean isExtremumLocalStrict(BufferedImage source, int x, int y) {
        return ImageTools.isMinimumLocalStrict(source, x, y) || ImageTools.isMaximumLocalStrict(source, x, y);
    }

    public static boolean isMinimumLocal(BufferedImage source, int x, int y) {
        int width = source.getWidth();
        int pos = y * width + x;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int val = bytebuffer[pos] & 0xFF;
                boolean ok = false;
                int v = bytebuffer[pos - 1] & 0xFF;
                if (v < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + 1] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width - 1] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width + 1] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width - 1] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width + 1] & 0xFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if (!ok) {
                    return false;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int val = shortbuffer[pos] & 0xFFFF;
                boolean ok = false;
                int v = shortbuffer[pos - 1] & 0xFFFF;
                if (v < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + 1] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width - 1] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width + 1] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width - 1] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width + 1] & 0xFFFF) < val) {
                    return false;
                }
                if (v > val) {
                    ok = true;
                }
                if (ok) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        return true;
    }

    public static boolean isMaximumLocal(BufferedImage source, int x, int y) {
        int width = source.getWidth();
        int pos = y * width + x;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int val = bytebuffer[pos] & 0xFF;
                boolean ok = false;
                int v = bytebuffer[pos - 1] & 0xFF;
                if (v > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + 1] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width - 1] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos - width + 1] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width - 1] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = bytebuffer[pos + width + 1] & 0xFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if (!ok) {
                    return false;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int val = shortbuffer[pos] & 0xFFFF;
                boolean ok = false;
                int v = shortbuffer[pos - 1] & 0xFFFF;
                if (v > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + 1] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width - 1] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos - width + 1] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width - 1] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if ((v = shortbuffer[pos + width + 1] & 0xFFFF) > val) {
                    return false;
                }
                if (v < val) {
                    ok = true;
                }
                if (ok) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        return true;
    }

    public static boolean isExtremumLocal(BufferedImage source, int x, int y) {
        return ImageTools.isMinimumLocal(source, x, y) || ImageTools.isMaximumLocal(source, x, y);
    }

    public static boolean isBlack(BufferedImage source) {
        switch (source.getType()) {
            case 5: 
            case 10: 
            case 12: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bytebuffer.length; ++x) {
                    if (bytebuffer[x] == 0) continue;
                    return false;
                }
                break;
            }
            case 6: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int x = 1; x < bb.length; x += 4) {
                    if (bb[x] == 0 && bb[x + 1] == 0 && bb[x + 2] == 0) continue;
                    return false;
                }
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < shortbuffer.length; ++x) {
                    if (shortbuffer[x] == 0) continue;
                    return false;
                }
                break;
            }
            default: {
                int width = source.getWidth();
                int height = source.getHeight();
                WritableRaster w = source.getRaster();
                int channel = w.getNumBands();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        for (int c = 0; c < channel; ++c) {
                            if (w.getSample(x, y, c) == 0) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public static Coordinates isBlack(BufferedImage source, int startx, int starty, int width, int height) {
        int imwidth = source.getWidth();
        int ex = startx + width;
        int ey = starty + height;
        int extra = 0;
        switch (source.getType()) {
            case 10: 
            case 12: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int y = starty; y < ey; ++y) {
                    int x = startx;
                    int pos = y * imwidth + x;
                    while (x < ex) {
                        if (bytebuffer[pos] != 0) {
                            return new Coordinates(x, y, pos);
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 6: {
                extra = 1;
            }
            case 5: {
                int channel = 3 + extra;
                byte[] bbrgb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int y = starty; y < ey; ++y) {
                    int x = startx;
                    int pos = channel * (y * imwidth + x) + extra;
                    while (x < ex) {
                        if (bbrgb[pos] != 0 || bbrgb[pos + 1] != 0 || bbrgb[pos + 2] != 0) {
                            return new Coordinates(x, y, pos);
                        }
                        ++x;
                        pos += channel;
                    }
                }
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int y = starty; y < ey; ++y) {
                    int x = startx;
                    int pos = y * imwidth + x;
                    while (x < ex) {
                        if (shortbuffer[pos] != 0) {
                            return new Coordinates(x, y, pos);
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                WritableRaster w = source.getRaster();
                int channel = w.getNumBands();
                for (int y = starty; y < ey; ++y) {
                    for (int x = startx; x < ex; ++x) {
                        for (int c = 0; c < channel; ++c) {
                            if (w.getSample(x, y, c) == 0) continue;
                            return new Coordinates(x, y, channel * (y * imwidth + x));
                        }
                    }
                }
            }
        }
        return null;
    }

    public static boolean isWhite(BufferedImage source) {
        int width = source.getWidth();
        int height = source.getHeight();
        WritableRaster wr = source.getRaster();
        switch (source.getType()) {
            case 12: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) == 1) continue;
                        return false;
                    }
                }
                break;
            }
            case 5: 
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bytebuffer.length; ++x) {
                    if (bytebuffer[x] == -1) continue;
                    return false;
                }
                break;
            }
            case 6: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int x = 1; x < bb.length; x += 4) {
                    if (bb[x] == -1 && bb[x + 1] == -1 && bb[x + 2] == -1) continue;
                    return false;
                }
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < shortbuffer.length; ++x) {
                    if (shortbuffer[x] == -1) continue;
                    return false;
                }
                break;
            }
            default: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) == 255 && wr.getSample(x, y, 1) == 255 && wr.getSample(x, y, 2) == 255) continue;
                        return false;
                    }
                }
            }
        }
        wr = null;
        return true;
    }

    public static boolean isGrayLevel(BufferedImage image) {
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return image.getRaster().getNumBands() == 1;
    }

    public static boolean isColored(BufferedImage image) {
        if (ImageTools.isGrayLevel(image)) {
            return false;
        }
        return image.getRaster().getNumBands() > 1;
    }

    public static int Miror(int x, int Size) {
        if (x < 0) {
            x = -x;
        }
        if (x >= Size) {
            x = Size - (x - Size + 1);
        }
        return x;
    }

    public static int PixelMiror(BufferedImage image, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= image.getWidth()) {
            x = image.getWidth() - (x - image.getWidth() + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= image.getHeight()) {
            y = image.getHeight() - (y - image.getHeight() + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(image, x, y, c);
        }
        return image.getRaster().getSample(x, y, c);
    }

    public static double PixelMirorDouble(BufferedImage image, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= image.getWidth()) {
            x = image.getWidth() - (x - image.getWidth() + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= image.getHeight()) {
            y = image.getHeight() - (y - image.getHeight() + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMirorDouble(image, x, y, c);
        }
        return image.getRaster().getSampleDouble(x, y, c);
    }

    public static int PixelMiror(WritableRaster wr, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= wr.getWidth()) {
            x = wr.getWidth() - (x - wr.getWidth() + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= wr.getHeight()) {
            y = wr.getHeight() - (y - wr.getHeight() + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(wr, x, y, c);
        }
        return wr.getSample(x, y, c);
    }

    public static double PixelMirorDouble(WritableRaster wr, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= wr.getWidth()) {
            x = wr.getWidth() - (x - wr.getWidth() + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= wr.getHeight()) {
            y = wr.getHeight() - (y - wr.getHeight() + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMirorDouble(wr, x, y, c);
        }
        return wr.getSampleDouble(x, y, c);
    }

    public static int PixelMiror(byte[] data, int width, int height, int x, int y) {
        if (x < 0) {
            x = -x;
        }
        if (x >= width) {
            x = width - (x - width + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= height) {
            y = height - (y - height + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(data, width, height, x, y);
        }
        return data[y * width + x] & 0xFF;
    }

    public static int PixelMiror(byte[] data, int width, int height, int channel, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= width) {
            x = width - (x - width + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= height) {
            y = height - (y - height + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(data, width, height, channel, x, y, c);
        }
        return data[(y * width + x) * channel + c] & 0xFF;
    }

    public static int PixelMiror(short[] data, int width, int height, int x, int y) {
        if (x < 0) {
            x = -x;
        }
        if (x >= width) {
            x = width - (x - width + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= height) {
            y = height - (y - height + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(data, width, height, x, y);
        }
        return data[y * width + x] & 0xFFFF;
    }

    public static int PixelMiror(short[] data, int width, int height, int channel, int x, int y, int c) {
        if (x < 0) {
            x = -x;
        }
        if (x >= width) {
            x = width - (x - width + 1);
        }
        if (y < 0) {
            y = -y;
        }
        if (y >= height) {
            y = height - (y - height + 1);
        }
        if (x < 0 || y < 0) {
            return ImageTools.PixelMiror(data, width, height, channel, x, y, c);
        }
        return data[(y * width + x) * channel + c] & 0xFFFF;
    }
}

