/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import measures.cclh.ConnectedComponentLabeling;

public class SubImage {
    private BufferedImage parent = null;
    private BufferedImage image = null;
    public final int minx;
    public final int miny;
    public final int maxx;
    public final int maxy;

    public SubImage(BufferedImage parent, int minx, int miny, int maxx, int maxy) {
        this.minx = minx < 0 ? 0 : minx;
        this.miny = miny < 0 ? 0 : miny;
        this.maxx = maxx < parent.getWidth() ? maxx : parent.getWidth() - 1;
        this.maxy = maxy < parent.getHeight() ? maxy : parent.getHeight() - 1;
        this.parent = parent;
        this.image = new BufferedImage(this.maxx - this.minx + 1, this.maxy - this.miny + 1, parent.getType());
        int Width = parent.getWidth();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        block0 : switch (parent.getType()) {
            case 10: {
                byte[] bbima = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
                byte[] bbpar = ((DataBufferByte)parent.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                int y = 0;
                int pos = this.minx + this.miny * Width;
                while (y < height) {
                    System.arraycopy(bbpar, pos, bbima, pos2, width);
                    ++y;
                    pos += Width;
                    pos2 += width;
                }
                bbpar = null;
                bbima = null;
                break;
            }
            case 11: {
                short[] sbima = ((DataBufferUShort)this.image.getRaster().getDataBuffer()).getData();
                short[] sbpar = ((DataBufferUShort)parent.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                int y = 0;
                int pos = this.minx + this.miny * Width;
                while (y < height) {
                    System.arraycopy(sbpar, pos, sbima, pos2, width);
                    ++y;
                    pos += Width;
                    pos2 += width;
                }
                sbpar = null;
                sbima = null;
                break;
            }
            case 0: {
                switch (parent.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibima = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
                        int[] ibpar = ((DataBufferInt)parent.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        int y = 0;
                        int pos = this.minx + this.miny * Width;
                        while (y < height) {
                            System.arraycopy(ibpar, pos, ibima, pos2, width);
                            ++y;
                            pos += Width;
                            pos2 += width;
                        }
                        ibpar = null;
                        ibima = null;
                        break block0;
                    }
                    case 4: {
                        float[] fbima = ((DataBufferFloat)this.image.getRaster().getDataBuffer()).getData();
                        float[] fbpar = ((DataBufferFloat)parent.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        int y = 0;
                        int pos = this.minx + this.miny * Width;
                        while (y < height) {
                            System.arraycopy(fbpar, pos, fbima, pos2, width);
                            ++y;
                            pos += Width;
                            pos2 += width;
                        }
                        fbpar = null;
                        fbima = null;
                        break block0;
                    }
                    case 5: {
                        double[] dbima = ((DataBufferDouble)this.image.getRaster().getDataBuffer()).getData();
                        double[] dbpar = ((DataBufferDouble)parent.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        int y = 0;
                        int pos = this.minx + this.miny * Width;
                        while (y < height) {
                            System.arraycopy(dbpar, pos, dbima, pos2, width);
                            ++y;
                            pos += Width;
                            pos2 += width;
                        }
                        dbpar = null;
                        dbima = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public SubImage(BufferedImage parent, int minx, int miny, int maxx, int maxy, int[] labels, int num) {
        this(parent, minx, miny, maxx, maxy);
        int width = parent.getWidth();
        block0 : switch (parent.getType()) {
            case 12: {
                WritableRaster wr = this.image.getRaster();
                for (int y = this.miny; y <= this.maxy; ++y) {
                    int x = this.minx;
                    int pos = y * width + x;
                    while (x <= this.maxx) {
                        if (labels[pos] != num) {
                            wr.setSample(x - minx, y - miny, 0, 0);
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bbima = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                for (int y = this.miny; y <= this.maxy; ++y) {
                    int x = this.minx;
                    int pos = y * width + x;
                    while (x <= this.maxx) {
                        if (labels[pos] != num) {
                            bbima[pos2] = 0;
                        }
                        ++x;
                        ++pos;
                        ++pos2;
                    }
                }
                bbima = null;
                break;
            }
            case 11: {
                short[] sbima = ((DataBufferUShort)this.image.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                for (int y = this.miny; y <= this.maxy; ++y) {
                    int x = this.minx;
                    int pos = y * width + x;
                    while (x <= this.maxx) {
                        if (labels[pos] != num) {
                            sbima[pos2] = 0;
                        }
                        ++x;
                        ++pos;
                        ++pos2;
                    }
                }
                sbima = null;
                break;
            }
            case 0: {
                switch (this.image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibima = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        for (int y = this.miny; y <= this.maxy; ++y) {
                            int x = this.minx;
                            int pos = y * width + x;
                            while (x <= this.maxx) {
                                if (labels[pos] != num) {
                                    ibima[pos2] = 0;
                                }
                                ++x;
                                ++pos;
                                ++pos2;
                            }
                        }
                        ibima = null;
                        break block0;
                    }
                    case 4: {
                        float[] fbima = ((DataBufferFloat)this.image.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        for (int y = this.miny; y <= this.maxy; ++y) {
                            int x = this.minx;
                            int pos = y * width + x;
                            while (x <= this.maxx) {
                                if (labels[pos] != num) {
                                    fbima[pos2] = 0.0f;
                                }
                                ++x;
                                ++pos;
                                ++pos2;
                            }
                        }
                        fbima = null;
                        break block0;
                    }
                    case 5: {
                        double[] dbima = ((DataBufferDouble)this.image.getRaster().getDataBuffer()).getData();
                        int pos2 = 0;
                        for (int y = this.miny; y <= this.maxy; ++y) {
                            int x = this.minx;
                            int pos = y * width + x;
                            while (x <= this.maxx) {
                                if (labels[pos] != num) {
                                    dbima[pos2] = 0.0;
                                }
                                ++x;
                                ++pos;
                                ++pos2;
                            }
                        }
                        dbima = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Colored images not supported.");
            }
        }
    }

    public SubImage(BufferedImage parent, ConnectedComponentLabeling ccl, int num, int margin) {
        this(parent, ccl.minx()[num] - margin, ccl.miny()[num] - margin, ccl.maxx()[num] + margin, ccl.maxy()[num] + margin, ccl.Labels1D(), num);
    }

    public BufferedImage SubImage() {
        return this.image;
    }

    public BufferedImage Parent() {
        return this.parent;
    }

    public int getMaxx() {
        return this.maxx;
    }

    public int getMaxy() {
        return this.maxy;
    }

    public int getMinx() {
        return this.minx;
    }

    public int getMiny() {
        return this.miny;
    }
}

