/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi.colorSpace;

import java.awt.Color;
import java.awt.color.ColorSpace;

public class HSB
extends ColorSpace {
    private static final long serialVersionUID = -7713114653902159981L;
    private ColorSpace rgb = ColorSpace.getInstance(1000);

    public HSB() {
        super(7, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] pixel) {
        return this.fromRGB(this.rgb.fromCIEXYZ(pixel));
    }

    @Override
    public float[] fromRGB(float[] RGB) {
        float[] hsb = new float[3];
        return Color.RGBtoHSB((int)(RGB[0] * 255.0f + 0.5f), (int)(RGB[1] * 255.0f + 0.5f), (int)(RGB[2] * 255.0f + 0.5f), hsb);
    }

    @Override
    public float[] toCIEXYZ(float[] pixel) {
        return this.rgb.toCIEXYZ(this.toRGB(pixel));
    }

    @Override
    public float[] toRGB(float[] HSB2) {
        int color = Color.HSBtoRGB(HSB2[0], HSB2[1], HSB2[2]);
        return new float[]{(float)((color & 0xFF0000) >> 16) / 255.0f, (float)((color & 0xFF00) >> 8) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }
}

