/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi.colorSpace;

import java.awt.color.ColorSpace;

public class HSV
extends ColorSpace {
    private static final long serialVersionUID = -7713114653902159981L;
    private ColorSpace rgb = ColorSpace.getInstance(1000);
    private int hi;
    private float min;
    private float max;
    private float f;
    private float p;
    private float q;
    private float t;
    private float R;
    private float G;
    private float B;
    private float H;
    private float S;
    private float V;
    private static final float Epsilon = 1.0E-6f;

    public HSV() {
        super(7, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] pixel) {
        return this.fromRGB(this.rgb.fromCIEXYZ(pixel));
    }

    @Override
    public float[] fromRGB(float[] RGB) {
        this.min = Math.min(RGB[0], Math.min(RGB[1], RGB[2]));
        this.max = Math.max(RGB[0], Math.max(RGB[1], RGB[2]));
        if (Math.abs(this.max - this.min) < 1.0E-6f) {
            this.H = 0.0f;
        } else if (Math.abs(this.max - RGB[0]) < 1.0E-6f) {
            this.H = (60.0f * (RGB[1] - RGB[2]) / (this.max - this.min) + 360.0f) % 360.0f;
        } else if (Math.abs(this.max - RGB[1]) < 1.0E-6f) {
            this.H = 60.0f * (RGB[2] - RGB[0]) / (this.max - this.min) + 120.0f;
        } else if (Math.abs(this.max - RGB[2]) < 1.0E-6f) {
            this.H = 60.0f * (RGB[0] - RGB[1]) / (this.max - this.min) + 240.0f;
        }
        this.S = this.max < 1.0E-6f ? 0.0f : 1.0f - this.min / this.max;
        this.V = this.max;
        return new float[]{this.H, this.S, this.V};
    }

    @Override
    public float[] toCIEXYZ(float[] pixel) {
        return this.rgb.toCIEXYZ(this.toRGB(pixel));
    }

    @Override
    public float[] toRGB(float[] HSV2) {
        this.hi = (int)((double)HSV2[0] / 60.0) % 6;
        this.f = HSV2[0] / 60.0f - (float)this.hi;
        this.p = HSV2[2] * (1.0f - HSV2[1]);
        this.q = HSV2[2] * (1.0f - this.f * HSV2[1]);
        this.t = HSV2[2] * (1.0f - (1.0f - this.f) * HSV2[1]);
        switch (this.hi) {
            case 0: {
                this.R = HSV2[2];
                this.G = this.t;
                this.B = this.p;
                break;
            }
            case 1: {
                this.R = this.q;
                this.G = HSV2[2];
                this.B = this.p;
                break;
            }
            case 2: {
                this.R = this.p;
                this.G = HSV2[2];
                this.B = this.t;
                break;
            }
            case 3: {
                this.R = this.p;
                this.G = this.q;
                this.B = HSV2[2];
                break;
            }
            case 4: {
                this.R = this.t;
                this.G = this.p;
                this.B = HSV2[2];
                break;
            }
            case 5: {
                this.R = HSV2[2];
                this.G = this.p;
                this.B = this.q;
                break;
            }
            default: {
                throw new Error("Default, must not occured.");
            }
        }
        return new float[]{this.R, this.G, this.B};
    }
}

