/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi.colorSpace;

import java.awt.color.ColorSpace;

public class Lab
extends ColorSpace {
    private static final long serialVersionUID = 5223948728536448266L;
    private final float REF_X = 0.95047f;
    private final float REF_Y = 1.0f;
    private final float REF_Z = 1.08883f;
    private ColorSpace rgb = ColorSpace.getInstance(1000);
    private float[] xyz = null;

    public Lab() {
        super(1, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] pixel) {
        return this.fromRGB(this.rgb.fromCIEXYZ(pixel));
    }

    @Override
    public float[] fromRGB(float[] RGB) {
        float[] xyz = this.rgb.toCIEXYZ(RGB);
        float x = xyz[0] / 0.95047f;
        float y = xyz[1] / 1.0f;
        float z = xyz[2] / 1.08883f;
        xyz = null;
        x = (double)x > 0.008856 ? (float)Math.pow(x, 0.3333333) : 7.787f * x + 0.13793103f;
        y = (double)y > 0.008856 ? (float)Math.pow(y, 0.3333333) : 7.787f * y + 0.13793103f;
        z = (double)z > 0.008856 ? (float)Math.pow(z, 0.333333) : 7.787f * z + 0.13793103f;
        return new float[]{116.0f * y - 16.0f, 500.0f * (x - y), 200.0f * (y - z)};
    }

    @Override
    public float[] toCIEXYZ(float[] pixel) {
        return this.rgb.toCIEXYZ(this.toRGB(pixel));
    }

    @Override
    public float[] toRGB(float[] Lab2) {
        float y = (Lab2[0] + 16.0f) / 116.0f;
        float x = Lab2[1] / 500.0f + y;
        float z = y - Lab2[2] / 200.0f;
        y = Math.pow(y, 3.0) > 0.008856 ? (float)Math.pow(y, 3.0) : (y - 0.13793103f) / 7.787f;
        x = Math.pow(x, 3.0) > 0.008856 ? (float)Math.pow(x, 3.0) : (x - 0.13793103f) / 7.787f;
        z = Math.pow(z, 3.0) > 0.008856 ? (float)Math.pow(z, 3.0) : (z - 0.13793103f) / 7.787f;
        float[] xyz = new float[]{x * 0.95047f, y * 1.0f, z * 1.08883f};
        return this.rgb.fromCIEXYZ(xyz);
    }
}

