/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

public final class Maths {
    public static final double LOG2 = Math.log(2.0);
    public static double Epsilon = 1.0E-6;

    public static double Hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double Log2(double a) {
        if (a < 0.0) {
            throw new IllegalArgumentException("Argument is negative.");
        }
        return Math.log(a) / LOG2;
    }

    public static double xLog2x(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("Argument is negative.");
        }
        if (c == 0) {
            return 0.0;
        }
        return (double)c * Maths.Log2(c);
    }

    public static double xLog2x(double c) {
        if (c < 0.0) {
            throw new IllegalArgumentException("Argument is negative.");
        }
        if (Math.abs(c) < Epsilon) {
            return 0.0;
        }
        return c * Maths.Log2(c);
    }

    public static boolean isPowerOf(int X, int n) {
        int x;
        if (n == 2) {
            return Maths.isPowerOf2(x);
        }
        for (x = X; x > 1; x /= n) {
            if (x % n == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isPowerOf2(int x) {
        if (x <= 0) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    public static int isDyadic(int T) {
        if (!Maths.isPowerOf2(T)) {
            return -1;
        }
        return (int)Maths.Log2(T);
    }

    public static int NextPower2(int X) {
        int x = X;
        if (x < 1) {
            return -1;
        }
        if (0x3FFFFFFF < x) {
            return -1;
        }
        if ((x & x - 1) == 0) {
            return x;
        }
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        return x + 1;
    }

    public static int PreviousPower2(int T) {
        int TT;
        if (T <= 0) {
            return -1;
        }
        int max = 0x3FFFFFFF;
        for (TT = 1; TT <= T; TT <<= 1) {
            if (max >= TT) continue;
            return TT;
        }
        return TT >> 1;
    }

    public static int Factorial(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("Negative number.");
        }
        if (x == 0) {
            return 1;
        }
        return x * Maths.Factorial(x - 1);
    }

    public static void DecimalToBase(int decimal, int base, int[] result) {
        int d = decimal;
        int pos = result.length - 1;
        switch (base) {
            case 2: {
                do {
                    result[pos--] = d % base;
                } while (base <= (d >>= 1));
                break;
            }
            case 4: {
                do {
                    result[pos--] = d % base;
                } while (base <= (d >>= 2));
                break;
            }
            case 8: {
                do {
                    result[pos--] = d % base;
                } while (base <= (d >>= 3));
                break;
            }
            case 16: {
                do {
                    result[pos--] = d % base;
                } while (base <= (d >>= 4));
                break;
            }
            default: {
                do {
                    result[pos--] = d % base;
                } while (base <= (d /= base));
            }
        }
        result[pos--] = d;
        while (0 <= pos) {
            result[pos--] = 0;
        }
    }

    public static int BaseToDecimal(int[] array, int base) {
        int val = array[0];
        switch (base) {
            case 2: {
                for (int x = 1; x < array.length; ++x) {
                    val <<= 1;
                    val += array[x];
                }
                break;
            }
            case 4: {
                for (int x = 1; x < array.length; ++x) {
                    val <<= 2;
                    val += array[x];
                }
                break;
            }
            case 8: {
                for (int x = 1; x < array.length; ++x) {
                    val <<= 3;
                    val += array[x];
                }
                break;
            }
            case 16: {
                for (int x = 1; x < array.length; ++x) {
                    val <<= 4;
                    val += array[x];
                }
                break;
            }
            default: {
                for (int x = 1; x < array.length; ++x) {
                    val *= base;
                    val += array[x];
                }
            }
        }
        return val;
    }

    public static int PowerBig(int x, int pow) {
        int result = 1;
        int p = pow;
        int v = x;
        while (p != 0) {
            if ((p & 1) != 0) {
                result *= v;
            }
            p >>= 1;
            v *= v;
        }
        return result;
    }

    public static float PowerBig(float x, int pow) {
        float result = 1.0f;
        int p = pow;
        float v = x;
        while (p != 0) {
            if ((p & 1) != 0) {
                result *= v;
            }
            p >>= 1;
            v *= v;
        }
        return result;
    }

    public static double PowerBig(double x, int pow) {
        float result = 1.0f;
        int p = pow;
        double v = x;
        while (p != 0) {
            if ((p & 1) != 0) {
                result = (float)((double)result * v);
            }
            p >>= 1;
            v *= v;
        }
        return result;
    }

    public static int Power(int x, int pow) {
        if (pow <= 0) {
            return 1;
        }
        if (19 <= pow) {
            return Maths.PowerBig(x, pow);
        }
        int v = x;
        for (int i = 1; i < pow; ++i) {
            v *= x;
        }
        return v;
    }

    public static float Power(float x, int pow) {
        if (pow <= 0) {
            return 1.0f;
        }
        if (20 <= pow) {
            return Maths.PowerBig(x, pow);
        }
        float v = x;
        for (int i = 1; i < pow; ++i) {
            v *= x;
        }
        return v;
    }

    public static double Power(double x, int pow) {
        if (pow <= 0) {
            return 1.0;
        }
        if (20 <= pow) {
            return Maths.PowerBig(x, pow);
        }
        double v = x;
        for (int i = 1; i < pow; ++i) {
            v *= x;
        }
        return v;
    }

    public static int ModuloDyadic(int n, int m) {
        return n & m - 1;
    }

    public static int Modulo(int n, int m) {
        if (Maths.isPowerOf2(m)) {
            return Maths.ModuloDyadic(n, m);
        }
        return n % m;
    }

    public static int Sign(byte a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public static int Sign(short a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public static int Sign(int a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public static int Sign(float a) {
        return a < 0.0f ? -1 : (a == 0.0f ? 0 : 1);
    }

    public static int Sign(double a) {
        return a < 0.0 ? -1 : (a == 0.0 ? 0 : 1);
    }
}

