/*
 * Decompiled with CFR 0.152.
 */
package measures.cclh;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import imageTiTi.SubImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import measures.cclh.ConnectedComponentLabeling;
import utils.memory.Allocator;

public class UnionFindCcl
implements ConnectedComponentLabeling {
    private final Allocator allocator = Allocator.Instance();
    private int Width;
    private int Height;
    private int Depth;
    private int Length = -1;
    private int[] Labels1D = null;
    private int[] Sizes = null;
    private Object Colors = null;
    private int Counter = -1;
    private final int BACKGROUND = -2;
    private final int NOROOT = -1;
    private int[] minx;
    private int[] miny;
    private int[] maxx;
    private int[] maxy;
    private ArrayFeatures AF = new ArrayFeatures();

    @Override
    public void Kill() {
        this.Labels1D = this.allocator.Release(this.Labels1D);
        this.Sizes = this.allocator.Release(this.Sizes);
        this.Colors = null;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        this.AF = null;
    }

    @Override
    public void ImportLabels(BufferedImage Original) {
        switch (Original.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                this.ImportLabels(((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            case 1: {
                this.ImportLabels(((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            case 3: {
                this.ImportLabels(((DataBufferInt)Original.getRaster().getDataBuffer()).getData(), Original.getWidth(), Original.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer encoding not supported.");
            }
        }
    }

    @Override
    public void ImportLabels(byte[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    @Override
    public void ImportLabels(byte[] Labels, int Width, int Height, int Depth) {
        int i;
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        for (i = 0; i < this.Length; ++i) {
            this.Labels1D[i] = Labels[i] & 0xFF;
        }
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        }
        Arrays.fill(this.Sizes, 0);
        for (i = 0; i < this.Length; ++i) {
            int n = this.Labels1D[i];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    @Override
    public void ImportLabels(short[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    @Override
    public void ImportLabels(short[] Labels, int Width, int Height, int Depth) {
        int i;
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        for (i = 0; i < this.Length; ++i) {
            this.Labels1D[i] = Labels[i] & 0xFFFF;
        }
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        }
        Arrays.fill(this.Sizes, 0);
        for (i = 0; i < this.Length; ++i) {
            int n = this.Labels1D[i];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    @Override
    public void ImportLabels(int[] Labels, int Width, int Height) {
        this.ImportLabels(Labels, Width, Height, 1);
    }

    @Override
    public void ImportLabels(int[] Labels, int Width, int Height, int Depth) {
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Labels.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        System.arraycopy(Labels, 0, this.Labels1D, 0, this.Length);
        this.Counter = this.AF.Maximum(Labels);
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        }
        Arrays.fill(this.Sizes, 0);
        for (int i = 0; i < this.Length; ++i) {
            int n = this.Labels1D[i];
            this.Sizes[n] = this.Sizes[n] + 1;
        }
    }

    public int Label(int[] Original, int Background) {
        int val;
        this.Width = this.Length = Original.length;
        this.Height = 1;
        this.Depth = 1;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int root = 0;
        int x = 0;
        this.Labels1D[x++] = Original[x] == Background ? 0 : ++root;
        while (x < this.Length) {
            val = Original[x];
            if (val == Background) {
                this.Labels1D[x++] = 0;
                continue;
            }
            if (val == Original[x - 1]) {
                this.Labels1D[x++] = root;
                continue;
            }
            this.Labels1D[x++] = ++root;
        }
        int max = this.AF.Maximum(this.Labels1D);
        if (this.Sizes == null || max + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(max + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new int[max + 1];
        int[] colors = (int[])this.Colors;
        for (x = 0; x < this.Length; ++x) {
            int n = val = this.Labels1D[x];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[val] = Original[val];
        }
        colors = null;
        this.Counter = this.Sizes.length - 1;
        return this.Counter;
    }

    @Override
    public int Label(BufferedImage Original, int Background, boolean EightConnex) {
        if (ImageTools.isColored(Original)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        this.Width = Original.getWidth();
        this.Height = Original.getHeight();
        this.Depth = 1;
        this.Length = this.Width * this.Height;
        switch (Original.getType()) {
            case 12: {
                int v;
                int x;
                int y;
                this.maxy = null;
                this.maxx = null;
                this.miny = null;
                this.minx = null;
                if (this.Labels1D == null || this.Labels1D.length != this.Length) {
                    this.Labels1D = this.allocator.Release(this.Labels1D);
                    this.Labels1D = this.allocator.newIntArray(this.Length);
                }
                Arrays.fill(this.Labels1D, 0);
                int pos = 0;
                int px = -1;
                int py = -this.Width;
                int pxy = -this.Width + 1;
                int pyx = -this.Width - 1;
                WritableRaster wr = Original.getRaster();
                pos = 0;
                for (y = 0; y < this.Height; ++y) {
                    x = 0;
                    while (x < this.Width) {
                        if (wr.getSample(x, y, 0) == Background) {
                            this.add(pos, -2);
                        } else {
                            int root = -1;
                            v = wr.getSample(x, y, 0);
                            if (x > 0 && wr.getSample(x - 1, y, 0) == v) {
                                root = this.union(this.find(px), root);
                            }
                            if (y > 0 && wr.getSample(x, y - 1, 0) == v) {
                                root = this.union(this.find(py), root);
                            }
                            if (EightConnex) {
                                if (x > 0 && y > 0 && wr.getSample(x - 1, y - 1, 0) == v) {
                                    root = this.union(this.find(pyx), root);
                                }
                                if (x < this.Width - 1 && y > 0 && wr.getSample(x + 1, y - 1, 0) == v) {
                                    root = this.union(this.find(pxy), root);
                                }
                            }
                            this.add(pos, root);
                        }
                        ++x;
                        ++pos;
                        ++px;
                        ++py;
                        ++pxy;
                        ++pyx;
                    }
                }
                this.Counter = this.BuildLabelArray();
                if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
                    this.Sizes = this.allocator.Release(this.Sizes);
                    this.Sizes = this.allocator.newIntArray(this.Counter + 1);
                } else {
                    Arrays.fill(this.Sizes, 0);
                }
                this.Colors = null;
                this.Colors = new byte[this.Sizes.length];
                byte[] colors = (byte[])this.Colors;
                pos = 0;
                for (y = 0; y < this.Height; ++y) {
                    x = 0;
                    while (x < this.Width) {
                        int n = v = this.Labels1D[pos];
                        this.Sizes[n] = this.Sizes[n] + 1;
                        colors[v] = (byte)wr.getSample(x, y, 0);
                        ++x;
                        ++pos;
                    }
                }
                colors = null;
                wr = null;
                return this.Counter;
            }
            case 10: {
                return this.Label(((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), this.Width, this.Height, (byte)Background, EightConnex);
            }
            case 11: {
                return this.Label(((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), this.Width, this.Height, (short)Background, EightConnex);
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        return this.Label(((DataBufferDouble)Original.getRaster().getDataBuffer()).getData(), this.Width, this.Height, (double)Background, EightConnex);
                    }
                    case 4: {
                        return this.Label(((DataBufferFloat)Original.getRaster().getDataBuffer()).getData(), this.Width, this.Height, (float)Background, EightConnex);
                    }
                    case 3: {
                        return this.Label(((DataBufferInt)Original.getRaster().getDataBuffer()).getData(), this.Width, this.Height, Background, EightConnex);
                    }
                }
                throw new IllegalArgumentException("Unsupported DataBuffer type.");
            }
        }
        throw new IllegalArgumentException("Unsupported image type.");
    }

    @Override
    public int Label(int[] Original, int Width, int Height, int Background, boolean EightConnex) {
        int x;
        if (Width * Height != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = -Width + 1;
        int pyx = -Width - 1;
        for (int y = 0; y < Height; ++y) {
            x = 0;
            while (x < Width) {
                if (Original[pos] == Background) {
                    this.add(pos, -2);
                } else {
                    int root = -1;
                    int v = Original[pos];
                    if (0 < x && Original[px] == v) {
                        root = this.union(this.find(px), root);
                    }
                    if (0 < y && Original[py] == v) {
                        root = this.union(this.find(py), root);
                    }
                    if (EightConnex) {
                        if (0 < x && 0 < y && Original[pyx] == v) {
                            root = this.union(this.find(pyx), root);
                        }
                        if (x < Width - 1 && 0 < y && Original[pxy] == v) {
                            root = this.union(this.find(pxy), root);
                        }
                    }
                    this.add(pos, root);
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new int[this.Sizes.length];
        int[] colors = (int[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    @Override
    public int Label(byte[] Original, int Width, int Height, byte Background, boolean EightConnex) {
        int x;
        if (Width * Height != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = -Width + 1;
        int pyx = -Width - 1;
        for (int y = 0; y < Height; ++y) {
            x = 0;
            while (x < Width) {
                if (Original[pos] == Background) {
                    this.add(pos, -2);
                } else {
                    int root = -1;
                    byte v = Original[pos];
                    if (0 < x && Original[px] == v) {
                        root = this.union(this.find(px), root);
                    }
                    if (0 < y && Original[py] == v) {
                        root = this.union(this.find(py), root);
                    }
                    if (EightConnex) {
                        if (0 < x && 0 < y && Original[pyx] == v) {
                            root = this.union(this.find(pyx), root);
                        }
                        if (x < Width - 1 && 0 < y && Original[pxy] == v) {
                            root = this.union(this.find(pxy), root);
                        }
                    }
                    this.add(pos, root);
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new byte[this.Sizes.length];
        byte[] colors = (byte[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    @Override
    public int Label(short[] Original, int Width, int Height, short Background, boolean EightConnex) {
        int x;
        if (Width * Height != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = -Width + 1;
        int pyx = -Width - 1;
        for (int y = 0; y < Height; ++y) {
            x = 0;
            while (x < Width) {
                if (Original[pos] == Background) {
                    this.add(pos, -2);
                } else {
                    int root = -1;
                    short v = Original[pos];
                    if (0 < x && Original[px] == v) {
                        root = this.union(this.find(px), root);
                    }
                    if (0 < y && Original[py] == v) {
                        root = this.union(this.find(py), root);
                    }
                    if (EightConnex) {
                        if (0 < x && 0 < y && Original[pyx] == v) {
                            root = this.union(this.find(pyx), root);
                        }
                        if (x < Width - 1 && 0 < y && Original[pxy] == v) {
                            root = this.union(this.find(pxy), root);
                        }
                    }
                    this.add(pos, root);
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new short[this.Sizes.length];
        short[] colors = (short[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    public int Label(double[] Original, int Width, int Height, double Background, boolean EightConnex) {
        int x;
        if (Width * Height != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = -Width + 1;
        int pyx = -Width - 1;
        for (int y = 0; y < Height; ++y) {
            x = 0;
            while (x < Width) {
                if (Original[pos] == Background) {
                    this.add(pos, -2);
                } else {
                    int root = -1;
                    double v = Original[pos];
                    if (0 < x && Original[px] == v) {
                        root = this.union(this.find(px), root);
                    }
                    if (0 < y && Original[py] == v) {
                        root = this.union(this.find(py), root);
                    }
                    if (EightConnex) {
                        if (0 < x && 0 < y && Original[pyx] == v) {
                            root = this.union(this.find(pyx), root);
                        }
                        if (x < Width - 1 && 0 < y && Original[pxy] == v) {
                            root = this.union(this.find(pxy), root);
                        }
                    }
                    this.add(pos, root);
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new double[this.Sizes.length];
        double[] colors = (double[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    public int Label(float[] Original, int Width, int Height, float Background, boolean EightConnex) {
        int x;
        if (Width * Height != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = 1;
        this.Length = Original.length;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = -Width + 1;
        int pyx = -Width - 1;
        for (int y = 0; y < Height; ++y) {
            x = 0;
            while (x < Width) {
                if (Original[pos] == Background) {
                    this.add(pos, -2);
                } else {
                    int root = -1;
                    float v = Original[pos];
                    if (0 < x && Original[px] == v) {
                        root = this.union(this.find(px), root);
                    }
                    if (0 < y && Original[py] == v) {
                        root = this.union(this.find(py), root);
                    }
                    if (EightConnex) {
                        if (0 < x && 0 < y && Original[pyx] == v) {
                            root = this.union(this.find(pyx), root);
                        }
                        if (x < Width - 1 && 0 < y && Original[pxy] == v) {
                            root = this.union(this.find(pxy), root);
                        }
                    }
                    this.add(pos, root);
                }
                ++x;
                ++pos;
                ++px;
                ++py;
                ++pxy;
                ++pyx;
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new float[this.Sizes.length];
        float[] colors = (float[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    @Override
    public int Label(DV Original, int Background, boolean TwentySixConnex) {
        if (Original.Channel != 1) {
            throw new IllegalArgumentException("DV with multiple channels => Not supported.");
        }
        switch (Original.Type) {
            case 8: {
                return this.Label(Original.getDataBufferByte(0), Original.SizeX, Original.SizeY, Original.SizeZ, (byte)Background, TwentySixConnex);
            }
            case 16: {
                return this.Label(Original.getDataBufferShort(0), Original.SizeX, Original.SizeY, Original.SizeZ, (short)Background, TwentySixConnex);
            }
            case 32: {
                return this.Label(Original.getDataBufferInt(0), Original.SizeX, Original.SizeY, Original.SizeZ, Background, TwentySixConnex);
            }
        }
        throw new IllegalArgumentException("DV type not supported.");
    }

    @Override
    public int Label(int[] Original, int Width, int Height, int Depth, int Background, boolean TwentySixConnex) {
        if (Width * Height * Depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height * Depth != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Original.length;
        int wm1 = Width - 1;
        int hm1 = Height - 1;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int px = -1;
        int py = -Width;
        int pxy = py - px;
        int pyx = py + px;
        int pz = -Width * Height;
        int pzx = pz + px;
        int pzy = pz + py;
        int pzxy = pz + pxy;
        int pzyx = pz + pyx;
        int pxz = pz - px;
        int pyz = pz - py;
        int pxyz = pz - py + px;
        int pyxz = pz - py - px;
        int pos = 0;
        for (int z = 0; z < Depth; ++z) {
            for (int y = 0; y < Height; ++y) {
                int x = 0;
                while (x < Width) {
                    if (Original[pos] == Background) {
                        this.add(pos, -2);
                    } else {
                        int root = -1;
                        int v = Original[pos];
                        if (0 < x && Original[pos + px] == v) {
                            root = this.union(this.find(pos + px), root);
                        }
                        if (0 < y && Original[pos + py] == v) {
                            root = this.union(this.find(pos + py), root);
                        }
                        if (0 < z && Original[pos + pz] == v) {
                            root = this.union(this.find(pos + pz), root);
                        }
                        if (TwentySixConnex) {
                            if (0 < y) {
                                if (0 < x && Original[pos + pyx] == v) {
                                    root = this.union(this.find(pos + pyx), root);
                                }
                                if (x < wm1 && Original[pos + pxy] == v) {
                                    root = this.union(this.find(pos + pxy), root);
                                }
                            }
                            if (0 < z) {
                                if (0 < y) {
                                    if (0 < x && Original[pos + pzyx] == v) {
                                        root = this.union(this.find(pos + pzyx), root);
                                    }
                                    if (Original[pos + pzy] == v) {
                                        root = this.union(this.find(pos + pzy), root);
                                    }
                                    if (x < wm1 && Original[pos + pzxy] == v) {
                                        root = this.union(this.find(pos + pzxy), root);
                                    }
                                }
                                if (0 < x && Original[pos + pzx] == v) {
                                    root = this.union(this.find(pos + pzx), root);
                                }
                                if (x < wm1 && Original[pos + pxz] == v) {
                                    root = this.union(this.find(pos + pxz), root);
                                }
                                if (y < hm1) {
                                    if (0 < x && Original[pos + pxyz] == v) {
                                        root = this.union(this.find(pos + pxyz), root);
                                    }
                                    if (Original[pos + pyz] == v) {
                                        root = this.union(this.find(pos + pyz), root);
                                    }
                                    if (x < wm1 && Original[pos + pyxz] == v) {
                                        root = this.union(this.find(pos + pyxz), root);
                                    }
                                }
                            }
                        }
                        this.add(pos, root);
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new int[this.Sizes.length];
        int[] colors = (int[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    @Override
    public int Label(byte[] Original, int Width, int Height, int Depth, byte Background, boolean TwentySixConnex) {
        if (Width * Height * Depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height * Depth != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Original.length;
        int wm1 = Width - 1;
        int hm1 = Height - 1;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = py - px;
        int pyx = py + px;
        int pz = -Width * Height;
        int pzx = pz + px;
        int pzy = pz + py;
        int pzxy = pz + pxy;
        int pzyx = pz + pyx;
        int pxz = pz - px;
        int pyz = pz - py;
        int pxyz = pz - py + px;
        int pyxz = pz - py - px;
        for (int z = 0; z < Depth; ++z) {
            for (int y = 0; y < Height; ++y) {
                int x = 0;
                while (x < Width) {
                    if (Original[pos] == Background) {
                        this.add(pos, -2);
                    } else {
                        int root = -1;
                        byte v = Original[pos];
                        if (0 < x && Original[pos + px] == v) {
                            root = this.union(this.find(pos + px), root);
                        }
                        if (0 < y && Original[pos + py] == v) {
                            root = this.union(this.find(pos + py), root);
                        }
                        if (0 < z && Original[pos + pz] == v) {
                            root = this.union(this.find(pos + pz), root);
                        }
                        if (TwentySixConnex) {
                            if (0 < y) {
                                if (0 < x && Original[pos + pyx] == v) {
                                    root = this.union(this.find(pos + pyx), root);
                                }
                                if (x < wm1 && Original[pos + pxy] == v) {
                                    root = this.union(this.find(pos + pxy), root);
                                }
                            }
                            if (0 < z) {
                                if (0 < y) {
                                    if (0 < x && Original[pos + pzyx] == v) {
                                        root = this.union(this.find(pos + pzyx), root);
                                    }
                                    if (Original[pos + pzy] == v) {
                                        root = this.union(this.find(pos + pzy), root);
                                    }
                                    if (x < wm1 && Original[pos + pzxy] == v) {
                                        root = this.union(this.find(pos + pzxy), root);
                                    }
                                }
                                if (0 < x && Original[pos + pzx] == v) {
                                    root = this.union(this.find(pos + pzx), root);
                                }
                                if (x < wm1 && Original[pos + pxz] == v) {
                                    root = this.union(this.find(pos + pxz), root);
                                }
                                if (y < hm1) {
                                    if (0 < x && Original[pos + pxyz] == v) {
                                        root = this.union(this.find(pos + pxyz), root);
                                    }
                                    if (Original[pos + pyz] == v) {
                                        root = this.union(this.find(pos + pyz), root);
                                    }
                                    if (x < wm1 && Original[pos + pyxz] == v) {
                                        root = this.union(this.find(pos + pyxz), root);
                                    }
                                }
                            }
                        }
                        this.add(pos, root);
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new byte[this.Sizes.length];
        byte[] colors = (byte[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    @Override
    public int Label(short[] Original, int Width, int Height, int Depth, short Background, boolean TwentySixConnex) {
        if (Width * Height * Depth != Original.length) {
            throw new IllegalArgumentException("Wrong given dimensions <=> Width * Height * Depth != Original.length.");
        }
        this.Width = Width;
        this.Height = Height;
        this.Depth = Depth;
        this.Length = Original.length;
        int wm1 = Width - 1;
        int hm1 = Height - 1;
        this.maxy = null;
        this.maxx = null;
        this.miny = null;
        this.minx = null;
        if (this.Labels1D == null || this.Labels1D.length != this.Length) {
            this.Labels1D = this.allocator.Release(this.Labels1D);
            this.Labels1D = this.allocator.newIntArray(this.Length);
        }
        Arrays.fill(this.Labels1D, 0);
        int pos = 0;
        int px = -1;
        int py = -Width;
        int pxy = py - px;
        int pyx = py + px;
        int pz = -Width * Height;
        int pzx = pz + px;
        int pzy = pz + py;
        int pzxy = pz + pxy;
        int pzyx = pz + pyx;
        int pxz = pz - px;
        int pyz = pz - py;
        int pxyz = pz - py + px;
        int pyxz = pz - py - px;
        for (int z = 0; z < Depth; ++z) {
            for (int y = 0; y < Height; ++y) {
                int x = 0;
                while (x < Width) {
                    if (Original[pos] == Background) {
                        this.add(pos, -2);
                    } else {
                        int root = -1;
                        short v = Original[pos];
                        if (0 < x && Original[pos + px] == v) {
                            root = this.union(this.find(pos + px), root);
                        }
                        if (0 < y && Original[pos + py] == v) {
                            root = this.union(this.find(pos + py), root);
                        }
                        if (0 < z && Original[pos + pz] == v) {
                            root = this.union(this.find(pos + pz), root);
                        }
                        if (TwentySixConnex) {
                            if (0 < y) {
                                if (0 < x && Original[pos + pyx] == v) {
                                    root = this.union(this.find(pos + pyx), root);
                                }
                                if (x < wm1 && Original[pos + pxy] == v) {
                                    root = this.union(this.find(pos + pxy), root);
                                }
                            }
                            if (0 < z) {
                                if (0 < y) {
                                    if (0 < x && Original[pos + pzyx] == v) {
                                        root = this.union(this.find(pos + pzyx), root);
                                    }
                                    if (Original[pos + pzy] == v) {
                                        root = this.union(this.find(pos + pzy), root);
                                    }
                                    if (x < wm1 && Original[pos + pzxy] == v) {
                                        root = this.union(this.find(pos + pzxy), root);
                                    }
                                }
                                if (0 < x && Original[pos + pzx] == v) {
                                    root = this.union(this.find(pos + pzx), root);
                                }
                                if (x < wm1 && Original[pos + pxz] == v) {
                                    root = this.union(this.find(pos + pxz), root);
                                }
                                if (y < hm1) {
                                    if (0 < x && Original[pos + pxyz] == v) {
                                        root = this.union(this.find(pos + pxyz), root);
                                    }
                                    if (Original[pos + pyz] == v) {
                                        root = this.union(this.find(pos + pyz), root);
                                    }
                                    if (x < wm1 && Original[pos + pyxz] == v) {
                                        root = this.union(this.find(pos + pyxz), root);
                                    }
                                }
                            }
                        }
                        this.add(pos, root);
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        this.Counter = this.BuildLabelArray();
        if (this.Sizes == null || this.Counter + 1 != this.Sizes.length) {
            this.Sizes = this.allocator.Release(this.Sizes);
            this.Sizes = this.allocator.newIntArray(this.Counter + 1);
        } else {
            Arrays.fill(this.Sizes, 0);
        }
        this.Colors = null;
        this.Colors = new short[this.Sizes.length];
        short[] colors = (short[])this.Colors;
        for (pos = 0; pos < this.Length; ++pos) {
            int x;
            int n = x = this.Labels1D[pos];
            this.Sizes[n] = this.Sizes[n] + 1;
            colors[x] = Original[pos];
        }
        colors = null;
        return this.Counter;
    }

    private int find(int pos) {
        while (this.Labels1D[pos] != pos) {
            pos = this.Labels1D[pos];
        }
        return pos;
    }

    private int union(int root0, int root1) {
        if (root0 == root1) {
            return root0;
        }
        if (root0 == -1) {
            return root1;
        }
        if (root1 == -1) {
            return root0;
        }
        if (root0 < root1) {
            this.Labels1D[root1] = root0;
            return root0;
        }
        this.Labels1D[root0] = root1;
        return root1;
    }

    private void add(int pos, int root) {
        this.Labels1D[pos] = root == -1 ? pos : root;
    }

    private int BuildLabelArray() {
        for (int x = 0; x < this.Length; ++x) {
            if (this.Labels1D[x] == -2) continue;
            this.Labels1D[x] = this.find(x);
        }
        int label = 1;
        for (int x = 0; x < this.Length; ++x) {
            this.Labels1D[x] = this.Labels1D[x] == -2 ? 0 : (this.Labels1D[x] == x ? label++ : this.Labels1D[this.Labels1D[x]]);
        }
        return label - 1;
    }

    @Override
    public void ComputeBoundingBoxes() {
        if (this.minx != null) {
            return;
        }
        this.minx = new int[this.Counter + 1];
        this.maxx = new int[this.minx.length];
        this.miny = new int[this.minx.length];
        this.maxy = new int[this.minx.length];
        Arrays.fill(this.minx, this.Width);
        Arrays.fill(this.miny, this.Height);
        Arrays.fill(this.maxx, 0);
        Arrays.fill(this.maxy, 0);
        int pos = 0;
        for (int y = 0; y < this.Height; ++y) {
            int x = 0;
            while (x < this.Width) {
                if (0 < this.Labels1D[pos]) {
                    int v = this.Labels1D[pos];
                    if (x < this.minx[v]) {
                        this.minx[v] = x;
                    }
                    if (this.maxx[v] < x) {
                        this.maxx[v] = x;
                    }
                    if (y < this.miny[v]) {
                        this.miny[v] = y;
                    }
                    if (this.maxy[v] < y) {
                        this.maxy[v] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
    }

    @Override
    public BufferedImage[] SeparateAllComponents(BufferedImage Source, int Threshold, int Margin) {
        int channel;
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of method Label(Image, ***) required before this one.");
        }
        if (Source != null && (Source.getWidth() != this.Width || Source.getHeight() != this.Height)) {
            throw new IllegalArgumentException("This image must have identic dimensions than image used to label.");
        }
        BufferedImage[] list = new BufferedImage[this.Counter + 1];
        int margin = 2 * Margin + 1;
        this.ComputeBoundingBoxes();
        WritableRaster wrs = Source.getRaster();
        WritableRaster wri = null;
        switch (Source.getType()) {
            case 10: 
            case 11: 
            case 12: {
                channel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        for (int i = 1; i <= this.Counter; ++i) {
            if (this.Sizes[i] < Threshold) continue;
            int minix = this.minx[i];
            int miniy = this.miny[i];
            int maxix = this.maxx[i];
            int maxiy = this.maxy[i];
            BufferedImage image = list[i] = new BufferedImage(maxix - minix + margin, maxiy - miniy + margin, Source.getType());
            wri = image.getRaster();
            for (int y = miniy; y <= maxiy; ++y) {
                int x = minix;
                int pos = y * this.Width + x;
                while (x <= maxix) {
                    if (this.Labels1D[pos] == i) {
                        for (int c = 0; c < channel; ++c) {
                            wri.setSample(x - minix + Margin, y - miniy + Margin, c, wrs.getSample(x, y, c));
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
            image = null;
            wri = null;
        }
        return list;
    }

    @Override
    public BufferedImage[] SeparateComponents(BufferedImage Source, int Threshold, int Margin) {
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of Label(Image, ***) method required before this one.");
        }
        if (this.Width != Source.getWidth() || this.Height != Source.getHeight()) {
            throw new IllegalArgumentException("This image must have identic dimension than image used to label.");
        }
        BufferedImage[] list = new BufferedImage[this.Counter + 1];
        int marge = (Margin << 1) + 1;
        this.ComputeBoundingBoxes();
        WritableRaster wrs = Source.getRaster();
        WritableRaster wri = null;
        for (int i = 1; i <= this.Counter; ++i) {
            if (this.Sizes[i] < Threshold || this.minx[i] == 0 || this.miny[i] == 0 || this.maxx[i] == this.Width - 1 || this.maxy[i] == this.Height - 1) continue;
            int minix = this.minx[i];
            int miniy = this.miny[i];
            int maxix = this.maxx[i];
            int maxiy = this.maxy[i];
            BufferedImage image = list[i] = new BufferedImage(maxix - minix + marge, maxiy - miniy + marge, Source.getType());
            wri = image.getRaster();
            for (int y = miniy; y <= maxiy; ++y) {
                int x = minix;
                int pos = y * this.Width + x;
                while (x <= maxix) {
                    if (this.Labels1D[pos] == i) {
                        wri.setSample(x - minix + Margin, y - miniy + Margin, 0, wrs.getSample(x, y, 0));
                    }
                    ++x;
                    ++pos;
                }
            }
            image = null;
            wri = null;
        }
        return list;
    }

    @Override
    public List<SubImage> SeparateComponentsSub(BufferedImage Source, int Threshold, int Margin) {
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of Label(Image, ***) method required before this one.");
        }
        if (this.Width != Source.getWidth() || this.Height != Source.getHeight()) {
            throw new IllegalArgumentException("This image must have identic dimension than image used to label.");
        }
        ArrayList<SubImage> liste = new ArrayList<SubImage>(this.Counter);
        this.ComputeBoundingBoxes();
        for (int i = 1; i <= this.Counter; ++i) {
            if (this.Sizes[i] < Threshold || this.minx[i] == 0 || this.miny[i] == 0 || this.maxx[i] == this.Width - 1 || this.maxy[i] == this.Height - 1) continue;
            liste.add(new SubImage(Source, this, i, Margin));
        }
        return liste;
    }

    @Override
    public BufferedImage ExtractComponent(BufferedImage Source, int Number2, int Margin, int Background) {
        int width = Source.getWidth();
        int height = Source.getHeight();
        if (width != this.Width || height != this.Height) {
            throw new IllegalArgumentException("Source image and the image/array used to create the labeling have not identical dimensions");
        }
        this.ComputeBoundingBoxes();
        int minix = this.minx[Number2] - Margin <= 0 ? 0 : this.minx[Number2] - Margin;
        int miniy = this.miny[Number2] - Margin <= 0 ? 0 : this.miny[Number2] - Margin;
        int maxix = width <= this.maxx[Number2] + Margin ? width - 1 : this.maxx[Number2] + Margin;
        int maxiy = height <= this.maxy[Number2] + Margin ? height - 1 : this.maxy[Number2] + Margin;
        BufferedImage image = ImageNew.SubImage(Source, minix, miniy, maxix, maxiy);
        WritableRaster wri = image.getRaster();
        int channel = Source.getRaster().getNumBands();
        for (int y = miniy; y <= maxiy; ++y) {
            int x = minix;
            int pos = y * width + x;
            while (x <= maxix) {
                if (this.Labels1D[pos] != Number2) {
                    for (int c = 0; c < channel; ++c) {
                        wri.setSample(x - minix, y - miniy, c, Background);
                    }
                }
                ++x;
                ++pos;
            }
        }
        return image;
    }

    @Override
    public void DeleteSmallerThan(int Threshold) {
        for (int i = 1; i < this.Sizes.length; ++i) {
            if (this.Sizes[i] >= Threshold) continue;
            this.DeleteCC(i);
        }
    }

    @Override
    public void DeleteSmallerThan(BufferedImage Original, int Threshold) {
        for (int i = 1; i < this.Sizes.length; ++i) {
            if (this.Sizes[i] >= Threshold) continue;
            this.DeleteCC(Original, i);
        }
    }

    @Override
    public void DeleteBiggerThan(int Threshold) {
        for (int i = 1; i < this.Sizes.length; ++i) {
            if (Threshold >= this.Sizes[i]) continue;
            this.DeleteCC(i);
        }
    }

    @Override
    public void DeleteBiggerThan(BufferedImage Original, int Threshold) {
        for (int i = 1; i < this.Sizes.length; ++i) {
            if (Threshold >= this.Sizes[i]) continue;
            this.DeleteCC(Original, i);
        }
    }

    @Override
    public void DeleteCCs(List<Integer> numbers) {
        Iterator<Integer> iter = numbers.iterator();
        while (iter.hasNext()) {
            this.DeleteCC(iter.next());
        }
        iter = null;
    }

    @Override
    public void DeleteCC(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number <= 0. Number must be positive and connected component 0 (background) cannot be deleted.");
        }
        if (this.minx == null) {
            this.ComputeBoundingBoxes();
        }
        int xmin = this.minx[number];
        int xmax = this.maxx[number];
        int ymin = this.miny[number];
        int ymax = this.maxy[number];
        for (int y = ymin; y <= ymax; ++y) {
            int x = xmin;
            int pos = y * this.Width + x;
            while (x <= xmax) {
                if (this.Labels1D[pos] == number) {
                    this.Labels1D[pos] = 0;
                }
                ++x;
                ++pos;
            }
        }
        this.maxy[number] = -1;
        this.miny[number] = -1;
        this.maxx[number] = -1;
        this.minx[number] = -1;
        this.Sizes[0] = this.Sizes[0] + this.Sizes[number];
        this.Sizes[number] = 0;
    }

    @Override
    public void DeleteCCs(BufferedImage Original, List<Integer> numbers) {
        Iterator<Integer> iter = numbers.iterator();
        while (iter.hasNext()) {
            this.DeleteCC(Original, iter.next());
        }
        iter = null;
    }

    @Override
    public void DeleteCC(BufferedImage Original, int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("number <= 0. Number must be positive and connected component 0 (background) cannot be deleted.");
        }
        if (Original.getWidth() != this.Width || Original.getHeight() != this.Height) {
            throw new IllegalArgumentException("Image dimensions are different from image used for labelling.");
        }
        if (this.minx == null) {
            this.ComputeBoundingBoxes();
        }
        int xmin = this.minx[number];
        int xmax = this.maxx[number];
        int ymin = this.miny[number];
        int ymax = this.maxy[number];
        block0 : switch (Original.getType()) {
            case 12: {
                WritableRaster wr = Original.getRaster();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            wr.setSample(x, y, 0, 0);
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            bytebufferin[pos] = 0;
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                bytebufferin = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin;
                    int pos = y * this.Width + x;
                    while (x <= xmax) {
                        if (this.Labels1D[pos] == number) {
                            shortbufferin[pos] = 0;
                            this.Labels1D[pos] = 0;
                        }
                        ++x;
                        ++pos;
                    }
                }
                shortbufferin = null;
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] intbufferin = ((DataBufferInt)Original.getRaster().getDataBuffer()).getData();
                        for (int y = ymin; y <= ymax; ++y) {
                            int x = xmin;
                            int pos = y * this.Width + x;
                            while (x <= xmax) {
                                if (this.Labels1D[pos] == number) {
                                    this.Labels1D[pos] = 0;
                                    intbufferin[pos] = 0;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        intbufferin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported DataBuffer type.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type.");
            }
        }
        this.maxy[number] = -1;
        this.miny[number] = -1;
        this.maxx[number] = -1;
        this.minx[number] = -1;
        this.Sizes[0] = this.Sizes[0] + this.Sizes[number];
        this.Sizes[number] = 0;
    }

    @Override
    public void DeleteOnBorder(int ... Except) {
        boolean[] todelete = new boolean[this.Sizes.length];
        int y = 0;
        int pos = 0;
        int pos2 = this.Width - 1;
        while (y < this.Height) {
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            if (this.Labels1D[pos2] != 0) {
                todelete[this.Labels1D[pos2]] = true;
            }
            ++y;
            pos += this.Width;
            pos2 += this.Width;
        }
        int x = 0;
        pos = (this.Height - 1) * this.Width;
        while (x < this.Width) {
            if (this.Labels1D[x] != 0) {
                todelete[this.Labels1D[x]] = true;
            }
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            ++x;
            ++pos;
        }
        for (int i = 0; i < Except.length; ++i) {
            todelete[Except[i]] = false;
        }
        for (x = 1; x < todelete.length; ++x) {
            if (!todelete[x]) continue;
            this.DeleteCC(x);
        }
        todelete = null;
    }

    @Override
    public void DeleteOnBorder(BufferedImage Original, int ... Except) {
        if (Original.getWidth() != this.Width || Original.getHeight() != this.Height) {
            throw new IllegalArgumentException("Image dimensions are different from image used for labeling.");
        }
        boolean[] todelete = new boolean[this.Sizes.length];
        int y = 0;
        int pos = 0;
        int pos2 = this.Width - 1;
        while (y < this.Height) {
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            if (this.Labels1D[pos2] != 0) {
                todelete[this.Labels1D[pos2]] = true;
            }
            ++y;
            pos += this.Width;
            pos2 += this.Width;
        }
        int x = 0;
        pos = (this.Height - 1) * this.Width;
        while (x < this.Width) {
            if (this.Labels1D[x] != 0) {
                todelete[this.Labels1D[x]] = true;
            }
            if (this.Labels1D[pos] != 0) {
                todelete[this.Labels1D[pos]] = true;
            }
            ++x;
            ++pos;
        }
        for (int i = 0; i < Except.length; ++i) {
            todelete[Except[i]] = false;
        }
        for (x = 1; x < todelete.length; ++x) {
            if (!todelete[x]) continue;
            this.DeleteCC(Original, x);
        }
        todelete = null;
    }

    @Override
    public int ConnectedComponentsNumber(int Threshold) {
        if (this.Labels1D == null) {
            throw new NullPointerException("Execution of Label method required before this one.");
        }
        int nbccf = 0;
        for (int i = 1; i < this.Sizes.length; ++i) {
            if (this.Sizes[i] < Threshold) continue;
            ++nbccf;
        }
        return nbccf;
    }

    @Override
    public int ConnectedComponentsNumber() {
        return this.Sizes.length - 1;
    }

    @Override
    public int[] Sizes() {
        return this.Sizes;
    }

    @Override
    public Object Colors() {
        return this.Colors;
    }

    @Override
    public int[] Labels1D() {
        return this.Labels1D;
    }

    @Override
    public int Width() {
        return this.Width;
    }

    @Override
    public int Height() {
        return this.Height;
    }

    @Override
    public int Depth() {
        return this.Depth;
    }

    @Override
    public int[] minx() {
        return this.minx;
    }

    @Override
    public int[] miny() {
        return this.miny;
    }

    @Override
    public int[] maxx() {
        return this.maxx;
    }

    @Override
    public int[] maxy() {
        return this.maxy;
    }
}

