/*
 * Decompiled with CFR 0.152.
 */
package measures.histogram;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import utils.strings.StringToolsImageDV;

public class Histogram {
    private int[][] Values = null;
    private int GrayLevel = -1;
    private int nbChannel = -1;
    private int ForbidenColor = -1;
    private int MaxValue;
    private int[] MaxValues = null;
    private int MinColor;
    private int MaxColor;
    private int[] MaxColors = null;
    private int[] MinColors = null;

    public Histogram() {
    }

    public Histogram(BufferedImage source) {
        this.Fill(source);
    }

    public Histogram(DV source) {
        this.Fill(source);
    }

    public final void Fill(BufferedImage source) {
        this.Fill(source, -1);
    }

    public void Fill(BufferedImage source, int ForbidenColor) {
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        WritableRaster wr = source.getRaster();
        this.ForbidenColor = ForbidenColor;
        switch (source.getType()) {
            case 12: {
                this.Allocate(2, 1);
                for (int y = 0; y < hauteur; ++y) {
                    for (int x = 0; x < largeur; ++x) {
                        if (wr.getSample(x, y, 0) == ForbidenColor) continue;
                        int[] nArray = this.Values[0];
                        int n = wr.getSample(x, y, 0);
                        nArray[n] = nArray[n] + 1;
                    }
                }
                break;
            }
            case 10: {
                this.Fill(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), ForbidenColor);
                break;
            }
            case 11: {
                this.Fill(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), ForbidenColor);
                break;
            }
            case 5: 
            case 6: {
                int c;
                byte[] bytebufferin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int channel = wr.getNumBands();
                this.Allocate(256, channel);
                int pos = 0;
                do {
                    for (c = 0; c < channel; ++c) {
                        int[] nArray = this.Values[c];
                        int n = bytebufferin[pos++] & 0xFF;
                        nArray[n] = nArray[n] + 1;
                    }
                } while (pos < bytebufferin.length);
                if (0 > ForbidenColor) break;
                for (c = 0; c < channel; ++c) {
                    this.Values[c][ForbidenColor] = 0;
                }
                break;
            }
            case 1: 
            case 4: {
                this.Allocate(256, 3);
                for (int y = 0; y < hauteur; ++y) {
                    for (int x = 0; x < largeur; ++x) {
                        for (int c = 0; c < 3; ++c) {
                            if (wr.getSample(x, y, c) == ForbidenColor) continue;
                            int[] nArray = this.Values[c];
                            int n = wr.getSample(x, y, c);
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                }
                break;
            }
            case 0: {
                ArrayFeatures AF = new ArrayFeatures();
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] doublearray = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        this.Fill(doublearray, (int)AF.Maximum(doublearray), ForbidenColor);
                        doublearray = null;
                        break;
                    }
                    case 3: {
                        int[] intarray = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        this.Fill(intarray, AF.Maximum(intarray), ForbidenColor);
                        intarray = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: DataBuffer not supported (yet) for TYPE_CUSTOM images.");
                    }
                }
                AF = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: Format not supported (yet): " + source.getType() + " <=> " + StringToolsImageDV.NameOfType(source.getType()));
            }
        }
        this.FindMinMax();
    }

    public void Fill(BufferedImage source, int GrayLevel, int ForbidenColor) {
        this.ForbidenColor = ForbidenColor;
        block0 : switch (source.getType()) {
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] doublearray = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                        this.Fill(doublearray, GrayLevel, ForbidenColor);
                        doublearray = null;
                        break block0;
                    }
                    case 3: {
                        int[] intarray = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        this.Fill(intarray, GrayLevel, ForbidenColor);
                        intarray = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Default: DataBuffer not supported (yet) for TYPE_CUSTOM images.");
            }
            default: {
                throw new IllegalArgumentException("Default: Format not supported (yet): " + source.getType() + " <=> " + StringToolsImageDV.NameOfType(source.getType()));
            }
        }
        this.FindMinMax();
    }

    public final void Fill(DV source) {
        this.Fill(source, -1);
    }

    public void Fill(DV source, int ForbidenColor) {
        this.ForbidenColor = ForbidenColor;
        switch (source.Type) {
            case 8: {
                this.Allocate(256, source.Channel);
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] bb = source.getDataBufferByte(c);
                    int[] values = this.Values[c];
                    for (int x = 0; x < source.Length; ++x) {
                        int v = bb[x] & 0xFF;
                        if (v == ForbidenColor) continue;
                        int n = v;
                        values[n] = values[n] + 1;
                    }
                    bb = null;
                    values = null;
                }
                break;
            }
            case 16: {
                this.Allocate(65536, source.Channel);
                for (int c = 0; c < source.Channel; ++c) {
                    short[] bb = source.getDataBufferShort(c);
                    int[] values = this.Values[c];
                    for (int x = 0; x < source.Length; ++x) {
                        int v = bb[x] & 0xFFFF;
                        if (v == ForbidenColor) continue;
                        int n = v;
                        values[n] = values[n] + 1;
                    }
                    bb = null;
                    values = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: DV type not supported (yet).");
            }
        }
        this.FindMinMax();
    }

    public void Fill(byte[] Tab, int ForbiddenValue) {
        this.Allocate(256, 1);
        int[] values = this.Values[0];
        for (int x = 0; x < Tab.length; ++x) {
            int n = Tab[x] & 0xFF;
            values[n] = values[n] + 1;
        }
        if (0 <= ForbiddenValue) {
            values[ForbiddenValue] = 0;
        }
        this.FindMinMax();
    }

    public void Fill(short[] Tab, int ForbiddenValue) {
        this.Allocate(65536, 1);
        int[] values = this.Values[0];
        for (int x = 0; x < Tab.length; ++x) {
            int n = Tab[x] & 0xFFFF;
            values[n] = values[n] + 1;
        }
        if (0 <= ForbiddenValue) {
            values[ForbiddenValue] = 0;
        }
        this.FindMinMax();
    }

    public void Fill(int[] Tab, int GrayLevel, int ForbiddenValue) {
        this.Allocate(GrayLevel + 1, 1);
        int[] values = this.Values[0];
        for (int x = 0; x < Tab.length; ++x) {
            int n = Tab[x];
            values[n] = values[n] + 1;
        }
        if (0 <= ForbiddenValue) {
            values[ForbiddenValue] = 0;
        }
        this.FindMinMax();
    }

    public void Fill(int[][] Tab, int GrayLevel) {
        int TailleY = Tab.length;
        int TailleX = Tab[0].length;
        this.Allocate(GrayLevel + 1, 1);
        for (int y = 0; y < TailleY; ++y) {
            for (int x = 0; x < TailleX; ++x) {
                int[] nArray = this.Values[0];
                int n = Tab[y][x];
                nArray[n] = nArray[n] + 1;
            }
        }
        this.FindMinMax();
    }

    public void Fill(int[][][] Tab, int GrayLevel) {
        int TailleZ = Tab.length;
        int TailleY = Tab[0].length;
        int TailleX = Tab[0][0].length;
        this.Allocate(GrayLevel + 1, 1);
        for (int z = 0; z < TailleZ; ++z) {
            for (int y = 0; y < TailleY; ++y) {
                for (int x = 0; x < TailleX; ++x) {
                    int[] nArray = this.Values[0];
                    int n = Tab[z][y][x];
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.FindMinMax();
    }

    public void Fill(double[] Tab, int GrayLevel, int ForbiddenValue) {
        this.Allocate(GrayLevel + 1, 1);
        for (int x = 0; x < Tab.length; ++x) {
            int v = (int)Tab[x];
            if (v == ForbiddenValue) continue;
            int[] nArray = this.Values[0];
            int n = v;
            nArray[n] = nArray[n] + 1;
        }
        this.FindMinMax();
    }

    public void Fill(double[][] Tab, int GrayLevel) {
        int TailleY = Tab.length;
        int TailleX = Tab[0].length;
        this.Allocate(GrayLevel + 1, 1);
        for (int y = 0; y < TailleY; ++y) {
            for (int x = 0; x < TailleX; ++x) {
                int[] nArray = this.Values[0];
                int n = (int)Tab[y][x];
                nArray[n] = nArray[n] + 1;
            }
        }
        this.FindMinMax();
    }

    public void Fill(double[][][] Tab, int GrayLevel) {
        int TailleZ = Tab.length;
        int TailleY = Tab[0].length;
        int TailleX = Tab[0][0].length;
        this.Allocate(GrayLevel + 1, 1);
        for (int z = 0; z < TailleZ; ++z) {
            for (int y = 0; y < TailleY; ++y) {
                for (int x = 0; x < TailleX; ++x) {
                    int[] nArray = this.Values[0];
                    int n = (int)Tab[z][y][x];
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.FindMinMax();
    }

    private void FindMinMax() {
        Arrays.fill(this.MaxValues, -1);
        Arrays.fill(this.MaxColors, -1);
        Arrays.fill(this.MinColors, this.GrayLevel + 1);
        this.MinColor = this.GrayLevel + 1;
        this.MaxColor = -1;
        this.MaxValue = -1;
        for (int c = 0; c < this.nbChannel; ++c) {
            int[] values = this.Values[c];
            for (int g = 0; g < this.GrayLevel; ++g) {
                if (0 >= values[g] || g == this.ForbidenColor) continue;
                if (values[g] > this.MaxValues[c]) {
                    this.MaxValues[c] = values[g];
                }
                if (g < this.MinColors[c]) {
                    this.MinColors[c] = g;
                }
                if (g <= this.MaxColors[c]) continue;
                this.MaxColors[c] = g;
            }
            values = null;
            if (this.MaxValues[c] > this.MaxValue) {
                this.MaxValue = this.MaxValues[c];
            }
            if (this.MinColors[c] < this.MinColor) {
                this.MinColor = this.MinColors[c];
            }
            if (this.MaxColors[c] <= this.MaxColor) continue;
            this.MaxColor = this.MaxColors[c];
        }
    }

    protected void Allocate(int GrayLevel, int nbChannel) {
        if (this.GrayLevel != GrayLevel || this.nbChannel != nbChannel) {
            this.GrayLevel = GrayLevel;
            this.nbChannel = nbChannel;
            this.Values = null;
            this.Values = new int[nbChannel][GrayLevel];
            this.MaxValues = null;
            this.MaxValues = new int[nbChannel];
            this.MaxColors = null;
            this.MaxColors = new int[nbChannel];
            this.MinColors = null;
            this.MinColors = new int[nbChannel];
        }
        ArrayOperations.Fill(this.Values, 0);
    }

    public int getGrayLevel() {
        return this.GrayLevel;
    }

    public int getMaxValue() {
        return this.MaxValue;
    }

    public int getMinColor() {
        return this.MinColor;
    }

    public int getMaxColor() {
        return this.MaxColor;
    }

    public int[] getMaxValues() {
        return this.MaxValues;
    }

    public int[] getMinColors() {
        return this.MinColors;
    }

    public int[] getMaxColors() {
        return this.MaxColors;
    }

    public int[][] getValues() {
        return this.Values;
    }

    public int[] getValues(int index) {
        return this.Values[index];
    }
}

