/*
 * Decompiled with CFR 0.152.
 */
package morphee;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.Bresenham;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import mathematics.primitives.pointsTiTi.PointI;
import morphee.fastMorphee.DilateHexagon;
import morphee.fastMorphee.DilateOctagon;

public class StructuringElement {
    protected final double Epsilon = 0.001;
    public static final int SQUARE = -1;
    public static final int DISK = -2;
    public static final int DIAGONAL135 = -3;
    public static final int DIAGONAL45 = -4;
    public static final int HORIZONTAL = -5;
    public static final int VERTICAL = -6;
    public static final int CUSTOMIZED = -7;
    public static final int DIAMOND = -8;
    public static final int HEXAGON = -9;
    public static final int OCTAGON = -10;
    public static final int SEGMENT = -11;
    public static final int EMPTY = -12;
    public static final int LBP = -13;
    public static final int CHAMFER = -14;
    public static final int MONTANARI = -15;
    private int Order = 0;
    private int Type = 0;
    private int Orientation = -1;
    private int Size = 0;
    private int SizeX = 0;
    private int SizeY = 0;
    private double SumOfWeights = 0.0;
    private boolean[][] data = null;
    private int[][] dataint = null;
    private double[][] datadouble = null;
    private List<CoordinatesWeighted> list = new ArrayList<CoordinatesWeighted>(113);
    private CoordinatesWeighted[] se = null;
    private boolean Iterable = false;
    private boolean useFastestAlgorithmOC = false;
    private boolean IntWeights = false;
    private boolean Heavy = false;
    private CoordinatesWeighted[] forward = null;
    private CoordinatesWeighted[] backward = null;
    private int width = -1;
    private boolean Flat = true;

    public StructuringElement(Object ... parameters) {
        if (parameters.length != 2 && parameters.length != 3) {
            throw new IllegalArgumentException("2 or 3 parameters required.");
        }
        if ((Integer)parameters[1] != -14) {
            this.setOrder((Integer)parameters[0]);
        }
        switch ((Integer)parameters[1]) {
            case -8: {
                this.MakeDiamond();
                break;
            }
            case -2: {
                this.MakeDisk();
                break;
            }
            case -12: {
                this.Type = -12;
                this.Orientation = -1;
                this.Iterable = false;
                break;
            }
            case -9: {
                this.MakeHexagon();
                break;
            }
            case -10: {
                this.MakeOctagon();
                break;
            }
            case -1: {
                this.MakeSquare();
                break;
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: {
                if (parameters.length != 2) {
                    throw new IllegalArgumentException("Exactly 2 parameters required (int Order, int Type).");
                }
                this.Make((Integer)parameters[1]);
                break;
            }
            case -11: {
                if (parameters.length != 3) {
                    throw new IllegalArgumentException("Exactly 3 parameters required (int Order, int Type, int Orientation).");
                }
                this.MakeSegment((Integer)parameters[2]);
                break;
            }
            case -13: {
                if (parameters.length != 3) {
                    throw new IllegalArgumentException("Exactly 3 parameters required (int Order/Radius, int Type, int nbPoint).");
                }
                this.MakeLBP((Integer)parameters[2]);
                break;
            }
            case -14: {
                if (parameters.length != 2) {
                    throw new IllegalArgumentException("Exactly 2 parameters required (int[][] base, int Type).");
                }
                this.MakeChamfer((int[][])parameters[0]);
                break;
            }
            case -15: {
                if (parameters.length != 2) {
                    throw new IllegalArgumentException("Exactly 2 parameters required (int Order, int Type).");
                }
                this.MakeMontanari();
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, type not supported: " + this.Type);
            }
        }
    }

    public StructuringElement(int[][] Mask) {
        this.Iterable = false;
        this.Size = Math.max(Mask.length, Mask[0].length);
        this.Order = this.Size >> 1;
        this.Type = -7;
        this.data = new boolean[Mask.length][Mask[0].length];
        for (int y = 0; y < Mask.length; ++y) {
            for (int x = 0; x < Mask[0].length; ++x) {
                this.data[y][x] = 0 != Mask[y][x];
            }
        }
        this.Orientation = -1;
        this.BuildList(Mask);
    }

    public StructuringElement(double[][] Mask) {
        this.Iterable = false;
        this.Size = Math.max(Mask.length, Mask[0].length);
        this.Order = this.Size >> 1;
        this.Type = -7;
        this.data = new boolean[Mask.length][Mask[0].length];
        for (int y = 0; y < Mask.length; ++y) {
            for (int x = 0; x < Mask[0].length; ++x) {
                this.data[y][x] = 0.0 != Mask[y][x];
            }
        }
        this.Orientation = -1;
        this.BuildList(Mask);
    }

    public StructuringElement(boolean[][] Mask) {
        this.Iterable = false;
        this.Size = Math.max(Mask.length, Mask[0].length);
        this.Order = this.Size >> 1;
        this.Type = -7;
        this.data = Mask;
        this.Orientation = -1;
        this.BuildList();
    }

    public void Kill() {
        this.data = null;
        this.datadouble = null;
        this.list.clear();
        this.list = null;
        if (this.se != null) {
            Arrays.fill(this.se, null);
        }
        this.se = null;
        if (this.forward != null) {
            Arrays.fill(this.forward, null);
        }
        this.forward = null;
        if (this.backward != null) {
            Arrays.fill(this.backward, null);
        }
        this.backward = null;
    }

    private void setOrder(int Order) {
        if (Order <= 0) {
            throw new IllegalArgumentException("Order <= 0");
        }
        this.Order = Order;
        this.Size = (Order << 1) + 1;
        if (this.Type == -12 || this.Type == -15) {
            return;
        }
        this.data = new boolean[this.Size][this.Size];
        ArrayOperations.Fill(this.data, false);
    }

    private void MakeSquare() {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        ArrayOperations.Fill(this.data, true);
        this.Type = -1;
        this.Iterable = true;
        this.Orientation = -1;
        this.BuildList();
    }

    private void MakeDiamond() {
        int i;
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        ArrayOperations.Fill(this.data, false);
        for (i = 0; i < this.Order; ++i) {
            for (int j = -i; j <= i; ++j) {
                this.data[2 * this.Order - i][this.Order + j] = true;
                this.data[i][this.Order + j] = true;
            }
        }
        for (i = 0; i < this.Size; ++i) {
            this.data[this.Order][i] = true;
        }
        this.Type = -8;
        this.Iterable = true;
        this.Orientation = -1;
        this.BuildList();
    }

    private void MakeDisk() {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        Euclidian distances = new Euclidian();
        for (int i = 0; i < this.Size; ++i) {
            for (int j = 0; j < this.Size; ++j) {
                this.data[i][j] = distances.Distance(j, i, 0.0, this.Order, this.Order, 0.0) < (double)this.Order + 0.001;
            }
        }
        distances = null;
        this.Iterable = false;
        this.Type = -2;
        this.Orientation = -1;
        this.BuildList();
    }

    private void MakeOctagon() {
        int x;
        int y;
        DilateOctagon dilate = new DilateOctagon();
        int s = 5;
        BufferedImage im = new BufferedImage(s * this.Order * 2 + 1, s * this.Order * 2 + 1, 10);
        BufferedImage res = ImageNew.Same(im);
        im.getRaster().setSample(s * this.Order + 1, s * this.Order + 1, 0, 1);
        dilate.setStructuringElement(new StructuringElement(this.Order, -1));
        dilate.Filter(im, res, 1);
        ImageNew.Copy(res, im);
        dilate.setStructuringElement(new StructuringElement(this.Order, -3));
        dilate.Filter(im, res, 1);
        ImageNew.Copy(res, im);
        dilate.setStructuringElement(new StructuringElement(this.Order, -4));
        dilate.Filter(im, res, 1);
        ImageNew.Copy(res, im);
        int minx = im.getWidth();
        int miny = im.getHeight();
        int maxx = 0;
        int maxy = 0;
        for (y = 0; y < im.getHeight(); ++y) {
            for (x = 0; x < im.getWidth(); ++x) {
                if (im.getRaster().getSample(x, y, 0) != 1) continue;
                if (minx > x) {
                    minx = x;
                }
                if (miny > y) {
                    miny = y;
                }
                if (maxx < x) {
                    maxx = x;
                }
                if (maxy >= y) continue;
                maxy = y;
            }
        }
        this.data = null;
        this.data = new boolean[maxy - miny + 1][maxx - minx + 1];
        for (y = 0; y < this.data.length; ++y) {
            for (x = 0; x < this.data[0].length; ++x) {
                this.data[y][x] = im.getRaster().getSample(x + minx, y + miny, 0) == 1;
            }
        }
        this.Size = this.data.length;
        this.Iterable = true;
        this.Type = -10;
        this.Orientation = -1;
        this.BuildList();
        dilate = null;
        im = null;
    }

    private void MakeHexagon() {
        int x;
        int y;
        BufferedImage im = new BufferedImage((this.Order << 1) + 5, (this.Order << 1) + 5, 10);
        im.getRaster().setSample(im.getWidth() >> 1, im.getHeight() >> 1, 0, 1);
        BufferedImage res = ImageNew.Same(im);
        byte[] bbin = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
        byte[] bbres = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        DilateHexagon dilate = new DilateHexagon();
        dilate.Filter(new Object[]{bbin}, im.getWidth(), im.getHeight(), 1, -2, this.Order, new Object[]{bbres}, 1);
        dilate.Kill();
        dilate = null;
        int minx = im.getWidth();
        int miny = im.getHeight();
        int maxx = 0;
        int maxy = 0;
        int pos = 0;
        for (y = 0; y < im.getHeight(); ++y) {
            x = 0;
            while (x < im.getWidth()) {
                if (bbres[pos] != 0) {
                    if (minx > x) {
                        minx = x;
                    }
                    if (miny > y) {
                        miny = y;
                    }
                    if (maxx < x) {
                        maxx = x;
                    }
                    if (maxy < y) {
                        maxy = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        bbres = null;
        bbin = null;
        this.data = null;
        this.data = new boolean[maxy - miny + 1][maxx - minx + 1];
        for (y = 0; y < this.data.length; ++y) {
            for (x = 0; x < this.data[0].length; ++x) {
                this.data[y][x] = res.getRaster().getSample(x + minx, y + miny, 0) != 0;
            }
        }
        this.Type = -9;
        this.Size = Math.max(this.data.length, this.data[0].length);
        this.Iterable = true;
        this.Orientation = -1;
        this.BuildList();
        dilate = null;
        res = null;
        im = null;
    }

    private void Make(int Type2) {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        ArrayOperations.Fill(this.data, false);
        switch (Type2) {
            case -3: {
                this.Orientation = 135;
                for (int i = 0; i < this.Size; ++i) {
                    this.data[i][i] = true;
                }
                break;
            }
            case -4: {
                this.Orientation = 45;
                for (int i = 0; i < this.Size; ++i) {
                    this.data[i][this.Size - i - 1] = true;
                }
                break;
            }
            case -5: {
                this.Orientation = 0;
                for (int i = 0; i < this.Size; ++i) {
                    this.data[this.Order][i] = true;
                }
                break;
            }
            case -6: {
                this.Orientation = 90;
                for (int i = 0; i < this.Size; ++i) {
                    this.data[i][this.Order] = true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, bad type (only multiples of 45 degres are supported): " + Type2);
            }
        }
        this.Iterable = true;
        this.Type = Type2;
        this.BuildList();
    }

    private void MakeSegment(int Orientation) {
        if (Orientation < 0 || 180 <= Orientation) {
            throw new IllegalArgumentException("Orientation must be into [0, 180[.");
        }
        switch (Orientation) {
            case 0: {
                this.Make(-5);
                return;
            }
            case 45: {
                this.Make(-4);
                return;
            }
            case 90: {
                this.Make(-6);
                return;
            }
            case 135: {
                this.Make(-3);
                return;
            }
        }
        double angle = Math.toRadians(180 - Orientation);
        double x = (double)this.Size * Math.cos(angle);
        double y = (double)this.Size * Math.sin(angle);
        double round = Orientation == 60 ? 0.0 : 0.5;
        List<PointI> liste = Bresenham.Points(0, 0, (int)(x + round), (int)(y + round));
        for (int i = 0; i <= this.Order; ++i) {
            PointI p = liste.get(i);
            this.data[this.Order + p.getY()][this.Order + p.getX()] = true;
            this.data[this.Order - p.getY()][this.Order - p.getX()] = true;
            p = null;
        }
        this.Type = -11;
        this.Iterable = false;
        this.Orientation = Orientation;
        this.BuildList();
        liste = null;
    }

    private void MakeLBP(int nbPoints) {
        if (this.data == null) {
            throw new NullPointerException("Set dimensions before construction.");
        }
        switch (nbPoints) {
            case 8: {
                int diag = (int)((double)this.Order * Math.cos(0.7853981633974483) + 0.5);
                this.data[this.Order + diag][this.Order + diag] = true;
                this.data[this.Order + diag][this.Order - diag] = true;
                this.data[this.Order - diag][this.Order + diag] = true;
                this.data[this.Order - diag][this.Order - diag] = true;
            }
            case 4: {
                this.data[0][this.Order] = true;
                this.data[2 * this.Order][this.Order] = true;
                this.data[this.Order][0] = true;
                this.data[this.Order][2 * this.Order] = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of points not supported.");
            }
        }
        this.Iterable = false;
        this.Type = -13;
        this.Orientation = -1;
        this.IntWeights = true;
        this.BuildListLBP(nbPoints);
    }

    private void MakeChamfer(int[][] base) {
        CoordinatesWeighted coord;
        int i;
        if (base[0][0] != 1 || base[0][1] != 0) {
            throw new IllegalArgumentException("The base first element must be [1, 0, ].");
        }
        if (base[1][0] != 1 || base[1][1] != 1) {
            throw new IllegalArgumentException("The base second element must be [1, 1, ].");
        }
        int half = (base.length << 2) - 3;
        this.se = new CoordinatesWeighted[(base.length << 3) - 8];
        int pos = 0;
        for (i = 0; i < base.length; ++i) {
            this.se[pos++] = new CoordinatesWeighted(base[i][0], base[i][1], 0, -1, base[i][2]);
        }
        for (i = 2; i < base.length; ++i) {
            this.se[pos++] = new CoordinatesWeighted(base[i][1], base[i][0], 0, -1, base[i][2]);
        }
        this.se[pos++] = new CoordinatesWeighted(base[0][1], base[0][0], 0, -1, base[0][2]);
        for (i = pos - 2; i >= 0; --i) {
            coord = this.se[i];
            this.se[pos++] = new CoordinatesWeighted(-coord.X, coord.Y, 0, -1, coord.Wi);
            coord = null;
        }
        if (pos != half) {
            throw new Error("pos != half. Must not occur.");
        }
        for (i = half - 2; i >= 1; --i) {
            coord = this.se[i];
            this.se[pos++] = new CoordinatesWeighted(coord.X, -coord.Y, 0, -1, coord.Wi);
            coord = null;
        }
        if (pos != this.se.length) {
            throw new Error("pos != se.length (" + pos + " " + this.se.length + ". Must not occur.");
        }
        for (CoordinatesWeighted cw : this.se) {
            this.list.add(cw);
        }
        this.Iterable = false;
        this.Type = -14;
        this.Orientation = -1;
        this.IntWeights = true;
        this.BuildListChamfer();
    }

    private void MakeMontanari() {
        CoordinatesWeighted coord;
        int i;
        int x;
        int y;
        int basesize = 0;
        int Radius = this.Order + 1;
        boolean[][] visible = new boolean[Radius][Radius];
        Euclidian distances = new Euclidian();
        for (y = 0; y < Radius; ++y) {
            for (x = 0; x < Radius; ++x) {
                if (x >= y) {
                    visible[y][x] = true;
                    if (!(distances.Distance(0.0, 0.0, 0.0, x, y, 0.0) > (double)Radius + 0.001)) continue;
                    visible[y][x] = false;
                    continue;
                }
                visible[y][x] = false;
            }
        }
        for (x = 1; x < Radius; ++x) {
            for (y = 0; y <= x; ++y) {
                if (!visible[y][x]) continue;
                ++basesize;
                int i2 = 2;
                while (i2 * y < Radius && i2 * x < Radius) {
                    visible[i2 * y][i2 * x] = false;
                    ++i2;
                }
            }
        }
        visible[0][0] = false;
        int half = (basesize << 2) - 3;
        this.se = new CoordinatesWeighted[(basesize << 3) - 8];
        int pos = 0;
        for (y = 0; y < Radius; ++y) {
            for (x = 0; x < Radius; ++x) {
                if (!visible[y][x]) continue;
                this.se[pos++] = new CoordinatesWeighted(x, y, 0, -1, distances.Distance(0.0, 0.0, 0.0, x, y, 0.0));
            }
        }
        distances = null;
        for (i = 2; i < basesize; ++i) {
            coord = this.se[i];
            this.se[pos++] = new CoordinatesWeighted(coord.Y, coord.X, 0, -1, coord.Wd);
            coord = null;
        }
        this.se[pos++] = new CoordinatesWeighted(this.se[0].Y, this.se[0].X, 0, -1, this.se[0].Wd);
        for (i = pos - 2; i >= 0; --i) {
            coord = this.se[i];
            this.se[pos++] = new CoordinatesWeighted(-coord.X, coord.Y, 0, -1, coord.Wd);
            coord = null;
        }
        for (i = half - 2; i >= 1; --i) {
            coord = this.se[i];
            this.se[pos++] = new CoordinatesWeighted(coord.X, -coord.Y, 0, -1, coord.Wd);
            coord = null;
        }
        for (CoordinatesWeighted cw : this.se) {
            this.list.add(cw);
        }
        this.Iterable = false;
        this.Type = -15;
        this.Orientation = -1;
        this.IntWeights = false;
        this.BuildListChamfer();
    }

    private void BuildList() {
        int j;
        int j2;
        boolean[] data1;
        int n;
        int i;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.data);
        af = null;
        for (i = 0; i < this.data.length; ++i) {
            for (int j3 = 0; j3 < this.data[0].length; ++j3) {
                if (!this.data[i][j3]) continue;
                this.list.add(new CoordinatesWeighted(j3 - data0length2, i - datalength2, 0, -1, 1));
            }
        }
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            this.se[i] = cw;
        }
        this.SizeX = (this.SizeX << 1) + 1;
        this.SizeY = (this.SizeY << 1) + 1;
        int nb = 0;
        boolean[][] cw = this.data;
        int n2 = cw.length;
        for (n = 0; n < n2; ++n) {
            data1 = cw[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == data1.length - 1) {
                    ++nb;
                    continue;
                }
                if (data1[j2 + 1]) continue;
                ++nb;
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i2][j]) continue;
                if (j == this.data[0].length - 1) {
                    this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, 1);
                    continue;
                }
                if (this.data[i2][j + 1]) continue;
                this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, 1);
            }
        }
        nb = 0;
        boolean[][] i2 = this.data;
        j = i2.length;
        for (n = 0; n < j; ++n) {
            data1 = i2[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == 0) {
                    ++nb;
                    continue;
                }
                if (data1[j2 - 1]) continue;
                ++nb;
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i3][j]) continue;
                if (j == 0) {
                    this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, 1);
                    continue;
                }
                if (this.data[i3][j - 1]) continue;
                this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, 1);
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = true;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildList(int[][] weights) {
        int j;
        int j2;
        boolean[] data1;
        int n;
        int i;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(weights);
        af = null;
        for (i = 0; i < this.data.length; ++i) {
            for (int j3 = 0; j3 < this.data[0].length; ++j3) {
                if (!this.data[i][j3]) continue;
                this.list.add(new CoordinatesWeighted(j3 - data0length2, i - datalength2, 0, -1, weights[i][j3]));
            }
        }
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            this.se[i] = cw;
        }
        this.SizeX = (this.SizeX << 1) + 1;
        this.SizeY = (this.SizeY << 1) + 1;
        int nb = 0;
        boolean[][] cw = this.data;
        int n2 = cw.length;
        for (n = 0; n < n2; ++n) {
            data1 = cw[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == data1.length - 1) {
                    ++nb;
                    continue;
                }
                if (data1[j2 + 1]) continue;
                ++nb;
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i2][j]) continue;
                if (j == this.data[0].length - 1) {
                    this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, weights[i2][j]);
                    continue;
                }
                if (this.data[i2][j + 1]) continue;
                this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, weights[i2][j]);
            }
        }
        nb = 0;
        boolean[][] i2 = this.data;
        j = i2.length;
        for (n = 0; n < j; ++n) {
            data1 = i2[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == 0) {
                    ++nb;
                    continue;
                }
                if (data1[j2 - 1]) continue;
                ++nb;
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i3][j]) continue;
                if (j == 0) {
                    this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, weights[i3][j]);
                    continue;
                }
                if (this.data[i3][j - 1]) continue;
                this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, weights[i3][j]);
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = true;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildList(double[][] weights) {
        int j;
        int j2;
        boolean[] data1;
        int n;
        int i;
        int datalength2 = this.data.length >> 1;
        int data0length2 = this.data[0].length >> 1;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(weights);
        af = null;
        for (i = 0; i < this.data.length; ++i) {
            for (int j3 = 0; j3 < this.data[0].length; ++j3) {
                if (!this.data[i][j3]) continue;
                this.list.add(new CoordinatesWeighted(j3 - data0length2, i - datalength2, 0, -1, weights[i][j3]));
            }
        }
        this.SizeY = 0;
        this.SizeX = 0;
        this.se = new CoordinatesWeighted[this.list.size()];
        for (i = 0; i < this.se.length; ++i) {
            CoordinatesWeighted cw = this.list.get(i);
            if (this.SizeX < Math.abs(cw.X)) {
                this.SizeX = Math.abs(cw.X);
            }
            if (this.SizeY < Math.abs(cw.Y)) {
                this.SizeY = Math.abs(cw.Y);
            }
            this.se[i] = cw;
        }
        this.SizeX = (this.SizeX << 1) + 1;
        this.SizeY = (this.SizeY << 1) + 1;
        int nb = 0;
        boolean[][] cw = this.data;
        int n2 = cw.length;
        for (n = 0; n < n2; ++n) {
            data1 = cw[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == data1.length - 1) {
                    ++nb;
                    continue;
                }
                if (data1[j2 + 1]) continue;
                ++nb;
            }
        }
        this.forward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i2][j]) continue;
                if (j == this.data[0].length - 1) {
                    this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, weights[i2][j]);
                    continue;
                }
                if (this.data[i2][j + 1]) continue;
                this.forward[nb++] = new CoordinatesWeighted(j - data0length2, i2 - datalength2, 0, -1, weights[i2][j]);
            }
        }
        nb = 0;
        boolean[][] i2 = this.data;
        j = i2.length;
        for (n = 0; n < j; ++n) {
            data1 = i2[n];
            for (j2 = 0; j2 < data1.length; ++j2) {
                if (!data1[j2]) continue;
                if (j2 == 0) {
                    ++nb;
                    continue;
                }
                if (data1[j2 - 1]) continue;
                ++nb;
            }
        }
        this.backward = new CoordinatesWeighted[nb];
        nb = 0;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            for (j = 0; j < this.data[0].length; ++j) {
                if (!this.data[i3][j]) continue;
                if (j == 0) {
                    this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, weights[i3][j]);
                    continue;
                }
                if (this.data[i3][j - 1]) continue;
                this.backward[nb++] = new CoordinatesWeighted(j - data0length2 - 1, i3 - datalength2, 0, -1, weights[i3][j]);
            }
        }
        boolean bl = this.Heavy = this.se.length > this.forward.length + this.backward.length + 1;
        if (this.backward.length != this.forward.length) {
            throw new IllegalArgumentException("The structuring element is not symetric. Number of pixel in forward different of backward.");
        }
        this.IntWeights = false;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildListLBP(int nbPoints) {
        int anglestart;
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.data);
        af = null;
        switch (nbPoints) {
            case 4: {
                anglestart = 90;
                break;
            }
            case 8: {
                anglestart = 135;
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of points not supported.");
            }
        }
        int angle = anglestart;
        int step = 360 / nbPoints;
        this.se = new CoordinatesWeighted[nbPoints];
        int nb = 0;
        do {
            double dx = (double)this.Order * Math.cos(Math.toRadians(angle));
            double dy = (double)this.Order * Math.sin(Math.toRadians(angle));
            int x = (int)(dx < 0.0 ? dx - 0.5 : dx + 0.5);
            int y = (int)(dy < 0.0 ? dy - 0.5 : dy + 0.5);
            CoordinatesWeighted cw = new CoordinatesWeighted(x, y, 0, -1, 1);
            this.list.add(cw);
            this.se[nb] = cw;
            if ((angle -= step) < 0) {
                angle += 360;
            }
            ++nb;
            cw = null;
        } while (angle != anglestart);
        this.SizeX = this.SizeY = (this.Order << 1) + 1;
        this.Heavy = false;
        this.CheckIfFlat();
        this.data = null;
    }

    private void BuildListChamfer() {
        int half = this.se.length >> 1;
        this.backward = new CoordinatesWeighted[half];
        int x = 0;
        int pos = 0;
        while (x < this.backward.length) {
            this.backward[pos] = this.se[x];
            ++x;
            ++pos;
        }
        this.forward = new CoordinatesWeighted[half];
        x = half;
        pos = 0;
        while (x < this.se.length) {
            this.forward[pos] = this.se[x];
            ++x;
            ++pos;
        }
        this.Order = 0;
        for (CoordinatesWeighted cw : this.backward) {
            if (this.Order >= cw.X) continue;
            this.Order = cw.X;
        }
        this.SizeX = this.SizeY = (this.Order << 1) + 1;
        this.Heavy = false;
        this.Flat = false;
    }

    public void setLinearWeigths(int step) {
        int d;
        int max = 0;
        Euclidian metric = new Euclidian();
        for (CoordinatesWeighted cw : this.se) {
            d = (int)(metric.Distance(cw.X, cw.Y, 0.0, 0.0, 0.0, 0.0) + 0.5) + 1;
            if (max >= d) continue;
            max = d;
        }
        this.SumOfWeights = 0.0;
        int MAX = max * step + 1;
        for (CoordinatesWeighted cw : this.se) {
            d = (int)(metric.Distance(cw.X, cw.Y, 0.0, 0.0, 0.0, 0.0) + 0.5) + 1;
            cw.Wi = MAX - step * d;
            this.SumOfWeights += (double)cw.Wi;
        }
        metric = null;
        this.Flat = false;
    }

    public boolean CheckIfFlat() {
        double wd = this.se[0].Wd;
        int wi = this.se[0].Wi;
        for (int i = 1; i < this.se.length; ++i) {
            if (Double.compare(wd, this.se[i].Wd) == 0 && wi == this.se[i].Wi) continue;
            this.Flat = false;
            return this.Flat;
        }
        this.Flat = true;
        return this.Flat;
    }

    public void GenerateIntArray() {
        this.dataint = new int[this.SizeY][this.SizeX];
        int dx = this.SizeX >> 1;
        int dy = this.SizeY >> 1;
        for (CoordinatesWeighted cw : this.se) {
            this.dataint[dy + cw.Y][dx + cw.X] = cw.Wi;
        }
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.dataint);
        af = null;
    }

    public void GenerateDoubleArray() {
        this.datadouble = new double[this.SizeY][this.SizeX];
        int dx = this.SizeX >> 1;
        int dy = this.SizeY >> 1;
        for (CoordinatesWeighted cw : this.se) {
            this.datadouble[dy + cw.Y][dx + cw.X] = cw.Wd;
        }
        ArrayFeatures af = new ArrayFeatures();
        this.SumOfWeights = af.Integral(this.datadouble);
        af = null;
    }

    public void PreComputePositions(int width) {
        this.PreComputePositions(width, 1);
    }

    public void PreComputePositions(int width, int nbChannels) {
        if (this.width == width) {
            return;
        }
        for (CoordinatesWeighted cw : this.se) {
            cw.Pos = (cw.X + cw.Y * width) * nbChannels;
        }
        if (this.forward != null) {
            for (CoordinatesWeighted cw : this.forward) {
                cw.Pos = (cw.X + cw.Y * width) * nbChannels;
            }
            for (CoordinatesWeighted cw : this.backward) {
                cw.Pos = (cw.X + cw.Y * width) * nbChannels;
            }
        }
        this.width = width;
    }

    public int LastWidth() {
        return this.width;
    }

    public void ComputeSumOfWeights() {
        this.SumOfWeights = 0.0;
        for (CoordinatesWeighted cw : this.se) {
            this.SumOfWeights += cw.Wd;
        }
    }

    public List<CoordinatesWeighted> getList() {
        return this.list;
    }

    public CoordinatesWeighted getCoordinates(int i) {
        return this.list.get(i);
    }

    public Iterator<CoordinatesWeighted> getListIterator() {
        return this.list.iterator();
    }

    public CoordinatesWeighted[] getSE() {
        return this.se;
    }

    public CoordinatesWeighted[] getForward() {
        return this.forward;
    }

    public CoordinatesWeighted[] getBackward() {
        return this.backward;
    }

    public int getOrder() {
        return this.Order;
    }

    public int getType() {
        return this.Type;
    }

    public int getOrientation() {
        return this.Orientation;
    }

    public int getSizeX() {
        return this.SizeX;
    }

    public int getSizeY() {
        return this.SizeY;
    }

    public int getSize() {
        return this.Size;
    }

    public double getSumOfWeights() {
        return this.SumOfWeights;
    }

    public boolean isIterable() {
        return this.Iterable;
    }

    public boolean isHeavy() {
        return this.Heavy;
    }

    public boolean isFlat() {
        return this.Flat;
    }

    public boolean hasIntWeights() {
        return this.IntWeights;
    }

    public boolean useFastestAlgorithmOC() {
        return this.useFastestAlgorithmOC;
    }

    public void ForceNonIterable() {
        this.Iterable = false;
    }

    public void ForceNonHeavy() {
        this.Heavy = false;
    }

    public void FastestAlgorithmOC(boolean use) {
        this.useFastestAlgorithmOC = use;
    }

    public int[][] getWeightsInt() {
        if (this.dataint == null) {
            this.GenerateIntArray();
        }
        return this.dataint;
    }

    public double[][] getWeightsDouble() {
        if (this.datadouble == null) {
            this.GenerateDoubleArray();
        }
        return this.datadouble;
    }

    public void appendTo(Appendable out) throws IOException {
        out.append(this.Order + " ");
        switch (this.Type) {
            case -7: {
                out.append("CUSTOMIZED");
                break;
            }
            case -3: {
                out.append("SQUARE");
                break;
            }
            case -4: {
                out.append("DIAGONAL45");
                break;
            }
            case -8: {
                out.append("DIAMOND");
                break;
            }
            case -2: {
                out.append("DISK");
                break;
            }
            case -12: {
                out.append("EMPTY");
                break;
            }
            case -9: {
                out.append("HEXAGON");
                break;
            }
            case -5: {
                out.append("HORIZONTAL");
                break;
            }
            case -13: {
                out.append("LBP");
                break;
            }
            case -10: {
                out.append("OCTAGON");
                break;
            }
            case -11: {
                out.append("SEGMENT");
                break;
            }
            case -1: {
                out.append("SQUARE");
                break;
            }
            case -6: {
                out.append("VERTICAL");
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, type not supported: " + this.Type + ". Must not occured!");
            }
        }
        if (this.Type == -11) {
            out.append(" " + this.Orientation);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(113);
        try {
            this.appendTo(sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public StructuringElement Clone() {
        CoordinatesWeighted coord;
        CoordinatesWeighted coordclone;
        int i;
        StructuringElement clone = null;
        switch (this.Type) {
            case -15: 
            case -12: 
            case -10: 
            case -9: 
            case -8: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                clone = new StructuringElement(this.Order, this.Type);
                break;
            }
            case -11: {
                clone = new StructuringElement(this.Order, this.Type, this.Orientation);
                break;
            }
            case -13: {
                clone = new StructuringElement(this.Order, this.Type, this.se.length);
                break;
            }
            case -14: 
            case -7: {
                throw new IllegalStateException("Type not supported (yet): " + this.Type);
            }
            default: {
                throw new IllegalStateException("Default, unknown type: " + this.Type);
            }
        }
        CoordinatesWeighted[] seclone = clone.getSE();
        for (i = 0; i < this.se.length; ++i) {
            coordclone = seclone[i];
            coord = this.se[i];
            coordclone.Wi = coord.Wi;
            coordclone.Wd = coord.Wd;
            coordclone.Pos = coord.Pos;
            coord = null;
            coordclone = null;
        }
        if (this.forward != null) {
            seclone = clone.getForward();
            for (i = 0; i < this.forward.length; ++i) {
                coordclone = seclone[i];
                coord = this.forward[i];
                coordclone.Wi = coord.Wi;
                coordclone.Wd = coord.Wd;
                coordclone.Pos = coord.Pos;
                coord = null;
                coordclone = null;
            }
            seclone = clone.getBackward();
            for (i = 0; i < this.backward.length; ++i) {
                coordclone = seclone[i];
                coord = this.backward[i];
                coordclone.Wi = coord.Wi;
                coordclone.Wd = coord.Wd;
                coordclone.Pos = coord.Pos;
                coord = null;
                coordclone = null;
            }
        }
        clone.ComputeSumOfWeights();
        return clone;
    }
}

