/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayMM;
import java.util.Arrays;
import morphee.fastMorphee.FastMorphee;

public class DilateSegment45
implements FastMorphee {
    private DilatehistThread[] threadshist = null;
    private DilatefmThread[] threadsfm = null;
    private DilateavThread[] threadsav = null;
    private DilateInterhistThread[] threadsinterhist = null;
    private DilateInterfmThread[] threadsinterfm = null;
    private DilateInteravThread[] threadsinterav = null;
    private int nbFreeThreads = 0;
    private FastMorphee.Algorithm algo = FastMorphee.Algorithm.Histogram;
    private Object sigin;
    private Object sigout;
    private Object[] sigsin;
    private Object[] sigsout;
    private int Channel;
    private int SizeX;
    private int SizeY;
    private int Type;
    private int sewidth;

    @Override
    public synchronized void Kill() {
        int i;
        this.sigout = null;
        this.sigin = null;
        this.sigsout = null;
        this.sigsin = null;
        if (this.threadshist != null) {
            for (i = 0; i < this.threadshist.length; ++i) {
                this.threadshist[i].Kill();
                this.threadshist[i] = null;
            }
            this.threadshist = null;
        }
        if (this.threadsfm != null) {
            for (i = 0; i < this.threadsfm.length; ++i) {
                this.threadsfm[i].Kill();
                this.threadsfm[i] = null;
            }
            this.threadsfm = null;
        }
        if (this.threadsav != null) {
            for (i = 0; i < this.threadsav.length; ++i) {
                this.threadsav[i].Kill();
                this.threadsav[i] = null;
            }
            this.threadsav = null;
        }
        if (this.threadsinterhist != null) {
            for (i = 0; i < this.threadsinterhist.length; ++i) {
                this.threadsinterhist[i].Kill();
                this.threadsinterhist[i] = null;
            }
            this.threadsinterhist = null;
        }
        if (this.threadsinterfm != null) {
            for (i = 0; i < this.threadsinterfm.length; ++i) {
                this.threadsinterfm[i].Kill();
                this.threadsinterfm[i] = null;
            }
            this.threadsinterfm = null;
        }
        if (this.threadsinterav != null) {
            for (i = 0; i < this.threadsinterav.length; ++i) {
                this.threadsinterav[i].Kill();
                this.threadsinterav[i] = null;
            }
            this.threadsinterav = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void FilterInterlaced(Object source, int sizex, int sizey, int sizez, int channel, int type, int sewidth, Object result, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 4 || channel != 1) {
                    this.StartInterlacedAV(nbCPU);
                    break;
                }
                this.StartInterlacedFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigin = source;
        this.sigout = result;
        this.SizeX = sizex;
        this.SizeY = sizey;
        this.Channel = channel;
        this.Type = type;
        DilateSegment45 dilateSegment45 = this;
        synchronized (dilateSegment45) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                int step = sizey / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterav[i].lock;
                    synchronized (object2) {
                        this.threadsinterav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsinterav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                int step = (sizex + sizey) / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterfm[i].lock;
                    synchronized (object2) {
                        this.threadsinterfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterfm[nbCPUm1].setConditions(nbCPUm1 * step, sizex + sizey);
                Object i = this.threadsinterfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsinterfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                int step = (sizex + sizey) / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsinterhist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsinterhist[i].lock;
                    synchronized (object2) {
                        this.threadsinterhist[i].lock.notify();
                        continue;
                    }
                }
                this.threadsinterhist[nbCPUm1].setConditions(nbCPUm1 * step, sizex + sizey);
                object = this.threadsinterhist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadsinterhist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartInterlacedHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadsinterhist != null && this.threadsinterhist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterhist = new DilateInterhistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterhist[i] = new DilateInterhistThread();
            this.threadsinterhist[i].start();
        }
    }

    private void StartInterlacedFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsinterfm != null && this.threadsinterfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterfm = new DilateInterfmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterfm[i] = new DilateInterfmThread();
            this.threadsinterfm[i].start();
        }
    }

    private void StartInterlacedAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsinterav != null && this.threadsinterav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsinterav = new DilateInteravThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsinterav[i] = new DilateInteravThread();
            this.threadsinterav[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Filter(Object[] sources, int sizex, int sizey, int sizez, int type, int sewidth, Object[] results, int nbCPU) {
        Object object;
        if (sewidth < 1) {
            throw new IllegalArgumentException("The structuring element order must be positive.");
        }
        this.sewidth = sewidth;
        switch (type) {
            case -2: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartHist(nbCPU);
                break;
            }
            case -3: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            case -5: 
            case -4: 
            case -1: {
                if (sewidth <= 3) {
                    this.StartAV(nbCPU);
                    break;
                }
                this.StartFM(nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Object type unknown.");
            }
        }
        this.sigsin = sources;
        this.sigsout = results;
        this.SizeX = sizex;
        this.SizeY = sizey;
        this.Channel = sources.length;
        this.Type = type;
        DilateSegment45 dilateSegment45 = this;
        synchronized (dilateSegment45) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int nbCPUm1 = nbCPU - 1;
        this.nbFreeThreads = 0;
        switch (this.algo) {
            case AutoVectorization: {
                Object object2;
                int step = sizey / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsav[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsav[i].lock;
                    synchronized (object2) {
                        this.threadsav[i].lock.notify();
                        continue;
                    }
                }
                this.threadsav[nbCPUm1].setConditions(nbCPUm1 * step, sizey);
                Object i = this.threadsav[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsav[nbCPUm1].lock.notify();
                    break;
                }
            }
            case FastMorphM: {
                Object object2;
                int step = (sizex + sizey) / nbCPU;
                for (int i = 0; i < nbCPUm1; ++i) {
                    this.threadsfm[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadsfm[i].lock;
                    synchronized (object2) {
                        this.threadsfm[i].lock.notify();
                        continue;
                    }
                }
                this.threadsfm[nbCPUm1].setConditions(nbCPUm1 * step, sizex + sizey);
                Object i = this.threadsfm[nbCPUm1].lock;
                synchronized (i) {
                    this.threadsfm[nbCPUm1].lock.notify();
                    break;
                }
            }
            case Histogram: {
                Object object2;
                int step = (sizex + sizey) / nbCPU;
                for (int i = 0; i < nbCPU - 1; ++i) {
                    this.threadshist[i].setConditions(i * step, (i + 1) * step);
                    object2 = this.threadshist[i].lock;
                    synchronized (object2) {
                        this.threadshist[i].lock.notify();
                        continue;
                    }
                }
                this.threadshist[nbCPUm1].setConditions(nbCPUm1 * step, sizex + sizey);
                object = this.threadshist[nbCPUm1].lock;
                synchronized (object) {
                    this.threadshist[nbCPUm1].lock.notify();
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm.");
            }
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void StartHist(int nbCPU) {
        this.algo = FastMorphee.Algorithm.Histogram;
        if (this.threadshist != null && this.threadshist.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadshist = new DilatehistThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadshist[i] = new DilatehistThread();
            this.threadshist[i].start();
        }
    }

    private void StartFM(int nbCPU) {
        this.algo = FastMorphee.Algorithm.FastMorphM;
        if (this.threadsfm != null && this.threadsfm.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsfm = new DilatefmThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsfm[i] = new DilatefmThread();
            this.threadsfm[i].start();
        }
    }

    private void StartAV(int nbCPU) {
        this.algo = FastMorphee.Algorithm.AutoVectorization;
        if (this.threadsav != null && this.threadsav.length == nbCPU) {
            return;
        }
        this.Kill();
        this.nbFreeThreads = 0;
        this.threadsav = new DilateavThread[nbCPU];
        for (int i = 0; i < nbCPU; ++i) {
            this.threadsav[i] = new DilateavThread();
            this.threadsav[i].start();
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class DilateInteravThread
    extends Thread {
        private int miny;
        private int maxy;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int miny, int maxy) {
            this.miny = miny;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegment45.this.Type;
                int sizex = DilateSegment45.this.SizeX;
                int sizey = DilateSegment45.this.SizeY;
                int channel = DilateSegment45.this.Channel;
                int sizexchannel = sizex * channel;
                switch (type) {
                    case -2: {
                        byte[] bytebufferin = (byte[])DilateSegment45.this.sigin;
                        byte[] bytebufferout = (byte[])DilateSegment45.this.sigout;
                        int y = this.miny;
                        int pos = y * sizexchannel;
                        while (y < this.maxy) {
                            int p;
                            System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizexchannel);
                            int s = -1;
                            for (p = pos - sizexchannel; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizexchannel) {
                                ArrayMM.MaximumUnsigned(bytebufferin, p - s * channel, bytebufferout, pos, bytebufferout, pos, sizexchannel + s * channel);
                            }
                            s = 1;
                            p = pos + sizexchannel;
                            while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                ArrayMM.MaximumUnsigned(bytebufferin, p, bytebufferout, pos + s * channel, bytebufferout, pos + s * channel, sizexchannel - s * channel);
                                ++s;
                                p += sizexchannel;
                            }
                            ++y;
                            pos += sizexchannel;
                        }
                        bytebufferout = null;
                        bytebufferin = null;
                        continue block12;
                    }
                    case -3: {
                        short[] shortbufferin = (short[])DilateSegment45.this.sigin;
                        short[] shortbufferout = (short[])DilateSegment45.this.sigout;
                        int y = this.miny;
                        int pos = y * sizexchannel;
                        while (y < this.maxy) {
                            int p;
                            System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizexchannel);
                            int s = -1;
                            for (p = pos - sizexchannel; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizexchannel) {
                                ArrayMM.MaximumUnsigned(shortbufferin, p - s * channel, shortbufferout, pos, shortbufferout, pos, sizexchannel + s * channel);
                            }
                            s = 1;
                            p = pos + sizexchannel;
                            while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                ArrayMM.MaximumUnsigned(shortbufferin, p, shortbufferout, pos + s * channel, shortbufferout, pos + s * channel, sizexchannel - s * channel);
                                ++s;
                                p += sizexchannel;
                            }
                            ++y;
                            pos += sizexchannel;
                        }
                        shortbufferout = null;
                        shortbufferin = null;
                        continue block12;
                    }
                    case -5: {
                        double[] doublebufferin = (double[])DilateSegment45.this.sigin;
                        double[] doublebufferout = (double[])DilateSegment45.this.sigout;
                        int y = this.miny;
                        int pos = y * sizexchannel;
                        while (y < this.maxy) {
                            int p;
                            System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizexchannel);
                            int s = -1;
                            for (p = pos - sizexchannel; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizexchannel) {
                                ArrayMM.Maximum(doublebufferin, p - s * channel, doublebufferout, pos, doublebufferout, pos, sizexchannel + s * channel);
                            }
                            s = 1;
                            p = pos + sizexchannel;
                            while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                ArrayMM.Maximum(doublebufferin, p, doublebufferout, pos + s * channel, doublebufferout, pos + s * channel, sizexchannel - s * channel);
                                ++s;
                                p += sizexchannel;
                            }
                            ++y;
                            pos += sizexchannel;
                        }
                        doublebufferout = null;
                        doublebufferin = null;
                        continue block12;
                    }
                    case -4: {
                        float[] floatbufferin = (float[])DilateSegment45.this.sigin;
                        float[] floatbufferout = (float[])DilateSegment45.this.sigout;
                        int y = this.miny;
                        int pos = y * sizexchannel;
                        while (y < this.maxy) {
                            int p;
                            System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizexchannel);
                            int s = -1;
                            for (p = pos - sizexchannel; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizexchannel) {
                                ArrayMM.Maximum(floatbufferin, p - s * channel, floatbufferout, pos, floatbufferout, pos, sizexchannel + s * channel);
                            }
                            s = 1;
                            p = pos + sizexchannel;
                            while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                ArrayMM.Maximum(floatbufferin, p, floatbufferout, pos + s * channel, floatbufferout, pos + s * channel, sizexchannel - s * channel);
                                ++s;
                                p += sizexchannel;
                            }
                            ++y;
                            pos += sizexchannel;
                        }
                        floatbufferout = null;
                        floatbufferin = null;
                        continue block12;
                    }
                    case -1: {
                        int[] intbufferin = (int[])DilateSegment45.this.sigin;
                        int[] intbufferout = (int[])DilateSegment45.this.sigout;
                        int y = this.miny;
                        int pos = y * sizex;
                        while (y < this.maxy) {
                            int p;
                            System.arraycopy(intbufferin, pos, intbufferout, pos, sizexchannel);
                            int s = -1;
                            for (p = pos - sizexchannel; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizexchannel) {
                                ArrayMM.Maximum(intbufferin, p - s * channel, intbufferout, pos, intbufferout, pos, sizexchannel + s * channel);
                            }
                            s = 1;
                            p = pos + sizexchannel;
                            while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                ArrayMM.Maximum(intbufferin, p, intbufferout, pos + s * channel, intbufferout, pos + s * channel, sizexchannel - s * channel);
                                ++s;
                                p += sizexchannel;
                            }
                            ++y;
                            pos += sizex;
                        }
                        intbufferout = null;
                        intbufferin = null;
                        continue block12;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }
    }

    private class DilateInterfmThread
    extends Thread {
        private int min;
        private int max;
        private int[] buffer = null;
        private int[] lineIn = null;
        private int[] lineOut = null;
        private float[] bufferfloat = null;
        private float[] lineInF = null;
        private float[] lineOutF = null;
        private double[] bufferdouble = null;
        private double[] lineInD = null;
        private double[] lineOutD = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.lineOut = null;
            this.lineIn = null;
            this.buffer = null;
            this.lineOutF = null;
            this.lineInF = null;
            this.bufferfloat = null;
            this.lineOutD = null;
            this.lineInD = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max) {
            if (DilateSegment45.this.Channel != 1) {
                throw new IllegalArgumentException("Only single channel supported (so far).");
            }
            this.min = min;
            this.max = max;
            int length = Math.max(DilateSegment45.this.SizeX, DilateSegment45.this.SizeY);
            switch (DilateSegment45.this.Type) {
                case -3: 
                case -1: {
                    this.lineOutD = null;
                    this.lineInD = null;
                    this.bufferdouble = null;
                    this.lineOutF = null;
                    this.lineInF = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == length) break;
                    this.buffer = null;
                    this.buffer = new int[length];
                    this.lineIn = new int[length];
                    this.lineOut = new int[length];
                    break;
                }
                case -4: {
                    this.lineOut = null;
                    this.lineIn = null;
                    this.buffer = null;
                    this.lineOutD = null;
                    this.lineInD = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == length) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[length];
                    this.lineInF = new float[length];
                    this.lineOutF = new float[length];
                    break;
                }
                case -5: {
                    this.lineOut = null;
                    this.lineIn = null;
                    this.buffer = null;
                    this.lineOutF = null;
                    this.lineInF = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == length) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[length];
                    this.lineInD = new double[length];
                    this.lineOutD = new double[length];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                int type = DilateSegment45.this.Type;
                int sizex = DilateSegment45.this.SizeX;
                int sizey = DilateSegment45.this.SizeY;
                int sizex1 = sizex - 1;
                if (this.Kill) {
                    return;
                }
                switch (type) {
                    case -3: {
                        int Y;
                        short[] sbin = (short[])DilateSegment45.this.sigin;
                        short[] sbout = (short[])DilateSegment45.this.sigout;
                        int n = 0;
                        int y = sizey - 1;
                        int pos = sbin.length - 1;
                        while (y >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = sizex1;
                                int p2 = pos;
                                for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineIn[length++] = sbin[p2] & 0xFFFF;
                                    p2 += sizex1;
                                }
                                this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                int i = 0;
                                p2 = pos;
                                while (i < length) {
                                    sbout[p2] = (short)this.lineOut[i++];
                                    p2 += sizex1;
                                }
                            }
                            --y;
                            ++n;
                            pos -= sizex;
                        }
                        int x = sizex1;
                        while (x >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = x;
                                int p2 = x;
                                for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineIn[length++] = sbin[p2] & 0xFFFF;
                                    p2 += sizex1;
                                }
                                this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                int i = 0;
                                p2 = x;
                                while (i < length) {
                                    sbout[p2] = (short)this.lineOut[i++];
                                    p2 += sizex1;
                                }
                            }
                            --x;
                            ++n;
                        }
                        sbout = null;
                        sbin = null;
                        continue block11;
                    }
                    case -1: {
                        int Y;
                        int p23;
                        int[] ibin = (int[])DilateSegment45.this.sigin;
                        int[] ibout = (int[])DilateSegment45.this.sigout;
                        int n = 0;
                        int y = sizey - 1;
                        int pos = ibin.length - 1;
                        while (y >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = sizex1;
                                p23 = pos;
                                for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineIn[length++] = ibin[p23];
                                    p23 += sizex1;
                                }
                                this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                int i = 0;
                                p23 = pos;
                                while (i < length) {
                                    ibout[p23] = this.lineOut[i++];
                                    p23 += sizex1;
                                }
                            }
                            --y;
                            ++n;
                            pos -= sizex;
                        }
                        int x = sizex1;
                        while (x >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = x;
                                int p22 = x;
                                for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineIn[length++] = ibin[p22];
                                    p22 += sizex1;
                                }
                                this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                int i = 0;
                                p22 = x;
                                while (i < length) {
                                    ibout[p22] = this.lineOut[i++];
                                    p22 += sizex1;
                                }
                            }
                            --x;
                            ++n;
                        }
                        ibout = null;
                        ibin = null;
                        continue block11;
                    }
                    case -4: {
                        int Y;
                        int p2;
                        int p23;
                        float[] fbin = (float[])DilateSegment45.this.sigin;
                        float[] fbout = (float[])DilateSegment45.this.sigout;
                        int n = 0;
                        int y = sizey - 1;
                        int pos = fbin.length - 1;
                        while (y >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = sizex1;
                                p2 = pos;
                                for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineInF[length++] = fbin[p2];
                                    p2 += sizex1;
                                }
                                this.Process(this.lineInF, DilateSegment45.this.sewidth, this.lineOutF, length);
                                int i = 0;
                                p2 = pos;
                                while (i < length) {
                                    fbout[p2] = this.lineOutF[i++];
                                    p2 += sizex1;
                                }
                            }
                            --y;
                            ++n;
                            pos -= sizex;
                        }
                        int x = sizex1;
                        while (x >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = x;
                                p23 = x;
                                for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineInF[length++] = fbin[p23];
                                    p23 += sizex1;
                                }
                                this.Process(this.lineInF, DilateSegment45.this.sewidth, this.lineOutF, length);
                                int i = 0;
                                p23 = x;
                                while (i < length) {
                                    fbout[p23] = this.lineOutF[i++];
                                    p23 += sizex1;
                                }
                            }
                            --x;
                            ++n;
                        }
                        fbout = null;
                        fbin = null;
                        continue block11;
                    }
                    case -5: {
                        int Y;
                        int p2;
                        double[] dbin = (double[])DilateSegment45.this.sigin;
                        double[] dbout = (double[])DilateSegment45.this.sigout;
                        int n = 0;
                        int y = sizey - 1;
                        int pos = dbin.length - 1;
                        while (y >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = sizex1;
                                int p24 = pos;
                                for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineInD[length++] = dbin[p24];
                                    p24 += sizex1;
                                }
                                this.Process(this.lineInD, DilateSegment45.this.sewidth, this.lineOutD, length);
                                int i = 0;
                                p24 = pos;
                                while (i < length) {
                                    dbout[p24] = this.lineOutD[i++];
                                    p24 += sizex1;
                                }
                            }
                            --y;
                            ++n;
                            pos -= sizex;
                        }
                        int x = sizex1;
                        while (x >= 0) {
                            if (this.min <= n && n < this.max) {
                                int length = 0;
                                int X = x;
                                p2 = x;
                                for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                    this.lineInD[length++] = dbin[p2];
                                    p2 += sizex1;
                                }
                                this.Process(this.lineInD, DilateSegment45.this.sewidth, this.lineOutD, length);
                                int i = 0;
                                p2 = x;
                                while (i < length) {
                                    dbout[p2] = this.lineOutD[i++];
                                    p2 += sizex1;
                                }
                            }
                            --x;
                            ++n;
                        }
                        dbout = null;
                        dbin = null;
                        continue block11;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }

        private void Process(int[] in, int sewidth, int[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            int T = Integer.MIN_VALUE;
            int G = Integer.MIN_VALUE;
            for (int x = 0; x < length; ++x) {
                int T_pre = T;
                int G_pre = G;
                int rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : Integer.MIN_VALUE;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = Integer.MIN_VALUE;
                    nbprop = 0;
                }
                this.buffer[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = Integer.MIN_VALUE;
            G = Integer.MIN_VALUE;
            nbprop = 0;
            int rowval = Integer.MIN_VALUE;
            int rowval_pre = Integer.MIN_VALUE;
            for (int x = 0; x < length; ++x) {
                int T_pre = T;
                int G_pre = G;
                rowval_pre = rowval;
                rowval = this.buffer[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = Integer.MIN_VALUE;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.buffer[x - sewidth]);
            }
        }

        private void Process(double[] in, int sewidth, double[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            double T = -1.7976931348623157E308;
            double G = -1.7976931348623157E308;
            for (int x = 0; x < length; ++x) {
                double T_pre = T;
                double G_pre = G;
                double rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -1.7976931348623157E308;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = -1.7976931348623157E308;
                    nbprop = 0;
                }
                this.bufferdouble[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = -1.7976931348623157E308;
            G = -1.7976931348623157E308;
            nbprop = 0;
            double rowval = -1.7976931348623157E308;
            double rowval_pre = -1.7976931348623157E308;
            for (int x = 0; x < length; ++x) {
                double T_pre = T;
                double G_pre = G;
                rowval_pre = rowval;
                rowval = this.bufferdouble[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = -1.7976931348623157E308;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.bufferdouble[x - sewidth]);
            }
        }

        private void Process(float[] in, int sewidth, float[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            float T = -3.4028235E38f;
            float G = -3.4028235E38f;
            for (int x = 0; x < length; ++x) {
                float T_pre = T;
                float G_pre = G;
                float rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -3.4028235E38f;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = -3.4028235E38f;
                    nbprop = 0;
                }
                this.bufferfloat[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = -3.4028235E38f;
            G = -3.4028235E38f;
            nbprop = 0;
            float rowval = -3.4028235E38f;
            float rowval_pre = -3.4028235E38f;
            for (int x = 0; x < length; ++x) {
                float T_pre = T;
                float G_pre = G;
                rowval_pre = rowval;
                rowval = this.bufferfloat[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = -3.4028235E38f;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.bufferfloat[x - sewidth]);
            }
        }
    }

    private class DilateInterhistThread
    extends Thread {
        private int min;
        private int max;
        private int[] Hist = new int[256];
        private byte[] lineIn = null;
        private byte[] lineOut = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.lineOut = null;
            this.lineIn = null;
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max) {
            this.min = min;
            this.max = max;
            int length = Math.max(DilateSegment45.this.SizeX, DilateSegment45.this.SizeY);
            if (this.lineIn == null || this.lineIn.length != length) {
                this.lineOut = null;
                this.lineIn = null;
                this.lineIn = new byte[length];
                this.lineOut = new byte[length];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegment45.this.Type;
                int sizex = DilateSegment45.this.SizeX;
                int sizey = DilateSegment45.this.SizeY;
                int channel = DilateSegment45.this.Channel;
                int sizexchannel = sizex * channel;
                int sizex1channel = (sizex - 1) * channel;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        byte[] bbin = (byte[])DilateSegment45.this.sigin;
                        byte[] bbout = (byte[])DilateSegment45.this.sigout;
                        for (int c = 0; c < channel; ++c) {
                            int i;
                            int Y;
                            int p2;
                            int X;
                            int length;
                            int n = 0;
                            int y = sizey - 1;
                            int pos = bbin.length - channel + c;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = sizex - 1;
                                    p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = bbin[p2];
                                        p2 += sizex1channel;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        bbout[p2] = this.lineOut[i++];
                                        p2 += sizex1channel;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizexchannel;
                            }
                            int x = sizex - 1;
                            pos = sizex1channel + c;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = x;
                                    p2 = pos;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = bbin[p2];
                                        p2 += sizex1channel;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        bbout[p2] = this.lineOut[i++];
                                        p2 += sizex1channel;
                                    }
                                }
                                --x;
                                ++n;
                                pos -= channel;
                            }
                        }
                        bbout = null;
                        bbin = null;
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Type not supported (yet).");
        }

        private void Process(byte[] in, int sewidth, byte[] out, int length) {
            int aux;
            int i;
            if (length <= sewidth) {
                int i2;
                int maxi = 0;
                for (i2 = 0; i2 < length; ++i2) {
                    if (maxi >= (in[i2] & 0xFF)) continue;
                    maxi = in[i2] & 0xFF;
                }
                for (i2 = 0; i2 < length; ++i2) {
                    out[i2] = (byte)maxi;
                }
                return;
            }
            if (length <= sewidth << 1) {
                int aux2;
                int i3;
                int maxi = 0;
                for (i3 = 0; i3 < sewidth; ++i3) {
                    int n = aux2 = in[i3] & 0xFF;
                    this.Hist[n] = this.Hist[n] + 1;
                    if (maxi >= aux2) continue;
                    maxi = aux2;
                }
                i3 = 0;
                while (i3 + sewidth < length) {
                    int n = aux2 = in[i3 + sewidth] & 0xFF;
                    this.Hist[n] = this.Hist[n] + 1;
                    if (maxi < aux2) {
                        maxi = aux2;
                    }
                    out[i3] = (byte)maxi;
                    ++i3;
                }
                for (i3 = length - sewidth; i3 < sewidth && i3 < length; ++i3) {
                    out[i3] = (byte)maxi;
                }
                while (i3 < length) {
                    out[i3] = (byte)maxi;
                    int n = in[i3 - sewidth] & 0xFF;
                    this.Hist[n] = this.Hist[n] - 1;
                    while (this.Hist[maxi] == 0) {
                        --maxi;
                    }
                    ++i3;
                }
                for (i3 = length - sewidth; i3 < length; ++i3) {
                    int n = in[i3] & 0xFF;
                    this.Hist[n] = this.Hist[n] - 1;
                }
                return;
            }
            int maxi = 0;
            for (i = 0; i < sewidth; ++i) {
                int n = aux = in[i] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi >= aux) continue;
                maxi = aux;
            }
            for (i = 0; i < sewidth; ++i) {
                int n = aux = in[i + sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi < aux) {
                    maxi = aux;
                }
                out[i] = (byte)maxi;
            }
            while (i < length - sewidth) {
                int n = aux = in[i + sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi < aux) {
                    maxi = aux;
                }
                out[i] = (byte)maxi;
                int n2 = in[i - sewidth] & 0xFF;
                this.Hist[n2] = this.Hist[n2] - 1;
                while (this.Hist[maxi] == 0) {
                    --maxi;
                }
                ++i;
            }
            for (i = length - sewidth; i < length; ++i) {
                out[i] = (byte)maxi;
                int n = in[i - sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] - 1;
                while (this.Hist[maxi] == 0) {
                    --maxi;
                }
            }
            for (i = length - sewidth; i < length; ++i) {
                int n = in[i] & 0xFF;
                this.Hist[n] = this.Hist[n] - 1;
            }
        }
    }

    private class DilateavThread
    extends Thread {
        private int min;
        private int max;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max) {
            this.min = min;
            this.max = max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: while (true) lbl-1000:
            // 6 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                type = DilateSegment45.this.Type;
                sizex = DilateSegment45.this.SizeX;
                sizey = DilateSegment45.this.SizeY;
                channel = DilateSegment45.this.Channel;
                switch (type) {
                    case -2: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            bytebufferin = (byte[])DilateSegment45.this.sigsin[c];
                            bytebufferout = (byte[])DilateSegment45.this.sigsout[c];
                            y = this.min;
                            pos = y * sizex;
                            while (y < this.max) {
                                System.arraycopy(bytebufferin, pos, bytebufferout, pos, sizex);
                                s = -1;
                                for (p = pos - sizex; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizex) {
                                    ArrayMM.MaximumUnsigned(bytebufferin, p - s, bytebufferout, pos, bytebufferout, pos, sizex + s);
                                }
                                s = 1;
                                p = pos + sizex;
                                while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                    ArrayMM.MaximumUnsigned(bytebufferin, p, bytebufferout, pos + s, bytebufferout, pos + s, sizex - s);
                                    ++s;
                                    p += sizex;
                                }
                                ++y;
                                pos += sizex;
                            }
                            bytebufferout = null;
                            bytebufferin = null;
                            ++c;
                        }
                    }
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            shortbufferin = (short[])DilateSegment45.this.sigsin[c];
                            shortbufferout = (short[])DilateSegment45.this.sigsout[c];
                            y = this.min;
                            pos = y * sizex;
                            while (y < this.max) {
                                System.arraycopy(shortbufferin, pos, shortbufferout, pos, sizex);
                                s = -1;
                                for (p = pos - sizex; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizex) {
                                    ArrayMM.MaximumUnsigned(shortbufferin, p - s, shortbufferout, pos, shortbufferout, pos, sizex + s);
                                }
                                s = 1;
                                p = pos + sizex;
                                while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                    ArrayMM.MaximumUnsigned(shortbufferin, p, shortbufferout, pos + s, shortbufferout, pos + s, sizex - s);
                                    ++s;
                                    p += sizex;
                                }
                                ++y;
                                pos += sizex;
                            }
                            shortbufferout = null;
                            shortbufferin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            doublebufferin = (double[])DilateSegment45.this.sigsin[c];
                            doublebufferout = (double[])DilateSegment45.this.sigsout[c];
                            y = this.min;
                            pos = y * sizex;
                            while (y < this.max) {
                                System.arraycopy(doublebufferin, pos, doublebufferout, pos, sizex);
                                s = -1;
                                for (p = pos - sizex; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizex) {
                                    ArrayMM.Maximum(doublebufferin, p - s, doublebufferout, pos, doublebufferout, pos, sizex + s);
                                }
                                s = 1;
                                p = pos + sizex;
                                while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                    ArrayMM.Maximum(doublebufferin, p, doublebufferout, pos + s, doublebufferout, pos + s, sizex - s);
                                    ++s;
                                    p += sizex;
                                }
                                ++y;
                                pos += sizex;
                            }
                            doublebufferout = null;
                            doublebufferin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            floatbufferin = (float[])DilateSegment45.this.sigsin[c];
                            floatbufferout = (float[])DilateSegment45.this.sigsout[c];
                            y = this.min;
                            pos = y * sizex;
                            while (y < this.max) {
                                System.arraycopy(floatbufferin, pos, floatbufferout, pos, sizex);
                                s = -1;
                                for (p = pos - sizex; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizex) {
                                    ArrayMM.Maximum(floatbufferin, p - s, floatbufferout, pos, floatbufferout, pos, sizex + s);
                                }
                                s = 1;
                                p = pos + sizex;
                                while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                    ArrayMM.Maximum(floatbufferin, p, floatbufferout, pos + s, floatbufferout, pos + s, sizex - s);
                                    ++s;
                                    p += sizex;
                                }
                                ++y;
                                pos += sizex;
                            }
                            floatbufferout = null;
                            floatbufferin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block12;
                            intbufferin = (int[])DilateSegment45.this.sigsin[c];
                            intbufferout = (int[])DilateSegment45.this.sigsout[c];
                            y = this.min;
                            pos = y * sizex;
                            while (y < this.max) {
                                s = -1;
                                for (p = pos - sizex; -DilateSegment45.this.sewidth <= s && 0 <= p; --s, p -= sizex) {
                                    ArrayMM.Maximum(intbufferin, p - s, intbufferout, pos, intbufferout, pos, sizex + s);
                                }
                                s = 1;
                                p = pos + sizex;
                                while (s <= DilateSegment45.this.sewidth && y + s < sizey) {
                                    ArrayMM.Maximum(intbufferin, p, intbufferout, pos + s, intbufferout, pos + s, sizex - s);
                                    ++s;
                                    p += sizex;
                                }
                                ++y;
                                pos += sizex;
                            }
                            intbufferout = null;
                            intbufferin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }
    }

    private class DilatefmThread
    extends Thread {
        private int min;
        private int max;
        private int[] buffer = null;
        private int[] lineIn = null;
        private int[] lineOut = null;
        private float[] bufferfloat = null;
        private float[] lineInF = null;
        private float[] lineOutF = null;
        private double[] bufferdouble = null;
        private double[] lineInD = null;
        private double[] lineOutD = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.lineOut = null;
            this.lineIn = null;
            this.buffer = null;
            this.lineOutF = null;
            this.lineInF = null;
            this.bufferfloat = null;
            this.lineOutD = null;
            this.lineInD = null;
            this.bufferdouble = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max) {
            this.min = min;
            this.max = max;
            int length = Math.max(DilateSegment45.this.SizeX, DilateSegment45.this.SizeY);
            switch (DilateSegment45.this.Type) {
                case -3: 
                case -1: {
                    this.lineOutD = null;
                    this.lineInD = null;
                    this.bufferdouble = null;
                    this.lineOutF = null;
                    this.lineInF = null;
                    this.bufferfloat = null;
                    if (this.buffer != null && this.buffer.length == length) break;
                    this.buffer = null;
                    this.buffer = new int[length];
                    this.lineIn = new int[length];
                    this.lineOut = new int[length];
                    break;
                }
                case -4: {
                    this.lineOut = null;
                    this.lineIn = null;
                    this.buffer = null;
                    this.lineOutD = null;
                    this.lineInD = null;
                    this.bufferdouble = null;
                    if (this.bufferfloat != null && this.bufferfloat.length == length) break;
                    this.bufferfloat = null;
                    this.bufferfloat = new float[length];
                    this.lineInF = new float[length];
                    this.lineOutF = new float[length];
                    break;
                }
                case -5: {
                    this.lineOut = null;
                    this.lineIn = null;
                    this.buffer = null;
                    this.lineOutF = null;
                    this.lineInF = null;
                    this.bufferfloat = null;
                    if (this.bufferdouble != null && this.bufferdouble.length == length) break;
                    this.bufferdouble = null;
                    this.bufferdouble = new double[length];
                    this.lineInD = new double[length];
                    this.lineOutD = new double[length];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported (yet).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) lbl-1000:
            // 5 sources

            {
                var1_2 = this.lock;
                synchronized (var1_2) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                type = DilateSegment45.this.Type;
                sizex = DilateSegment45.this.SizeX;
                sizey = DilateSegment45.this.SizeY;
                channel = DilateSegment45.this.Channel;
                sizex1 = sizex - 1;
                if (this.Kill) {
                    return;
                }
                switch (type) {
                    case -3: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            sbin = (short[])DilateSegment45.this.sigsin[c];
                            sbout = (short[])DilateSegment45.this.sigsout[c];
                            n = 0;
                            y = sizey - 1;
                            pos = sbin.length - 1;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = sizex1;
                                    p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = sbin[p2] & 65535;
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        sbout[p2] = (short)this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizex;
                            }
                            x = sizex1;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = x;
                                    p2 = x;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = sbin[p2] & 65535;
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = x;
                                    while (i < length) {
                                        sbout[p2] = (short)this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --x;
                                ++n;
                            }
                            sbout = null;
                            sbin = null;
                            ++c;
                        }
                    }
                    case -1: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            ibin = (int[])DilateSegment45.this.sigsin[c];
                            ibout = (int[])DilateSegment45.this.sigsout[c];
                            n = 0;
                            y = sizey - 1;
                            pos = ibin.length - 1;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = sizex1;
                                    p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = ibin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        ibout[p2] = this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizex;
                            }
                            x = sizex1;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = x;
                                    p2 = x;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = ibin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    i = 0;
                                    p2 = x;
                                    while (i < length) {
                                        ibout[p2] = this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --x;
                                ++n;
                            }
                            ibout = null;
                            ibin = null;
                            ++c;
                        }
                    }
                    case -4: {
                        c = 0;
                        while (true) {
                            if (c >= channel) ** GOTO lbl-1000
                            fbin = (float[])DilateSegment45.this.sigsin[c];
                            fbout = (float[])DilateSegment45.this.sigsout[c];
                            n = 0;
                            y = sizey - 1;
                            pos = fbin.length - 1;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = sizex1;
                                    p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineInF[length++] = fbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineInF, DilateSegment45.this.sewidth, this.lineOutF, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        fbout[p2] = this.lineOutF[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizex;
                            }
                            x = sizex1;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = x;
                                    p2 = x;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineInF[length++] = fbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineInF, DilateSegment45.this.sewidth, this.lineOutF, length);
                                    i = 0;
                                    p2 = x;
                                    while (i < length) {
                                        fbout[p2] = this.lineOutF[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --x;
                                ++n;
                            }
                            fbout = null;
                            fbin = null;
                            ++c;
                        }
                    }
                    case -5: {
                        c = 0;
                        while (true) {
                            if (c >= channel) continue block11;
                            dbin = (double[])DilateSegment45.this.sigsin[c];
                            dbout = (double[])DilateSegment45.this.sigsout[c];
                            n = 0;
                            y = sizey - 1;
                            pos = dbin.length - 1;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = sizex1;
                                    p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineInD[length++] = dbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineInD, DilateSegment45.this.sewidth, this.lineOutD, length);
                                    i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        dbout[p2] = this.lineOutD[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizex;
                            }
                            x = sizex1;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    length = 0;
                                    X = x;
                                    p2 = x;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineInD[length++] = dbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineInD, DilateSegment45.this.sewidth, this.lineOutD, length);
                                    i = 0;
                                    p2 = x;
                                    while (i < length) {
                                        dbout[p2] = this.lineOutD[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --x;
                                ++n;
                            }
                            dbout = null;
                            dbin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }

        private void Process(int[] in, int sewidth, int[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            int T = Integer.MIN_VALUE;
            int G = Integer.MIN_VALUE;
            for (int x = 0; x < length; ++x) {
                int T_pre = T;
                int G_pre = G;
                int rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : Integer.MIN_VALUE;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = Integer.MIN_VALUE;
                    nbprop = 0;
                }
                this.buffer[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = Integer.MIN_VALUE;
            G = Integer.MIN_VALUE;
            nbprop = 0;
            int rowval = Integer.MIN_VALUE;
            int rowval_pre = Integer.MIN_VALUE;
            for (int x = 0; x < length; ++x) {
                int T_pre = T;
                int G_pre = G;
                rowval_pre = rowval;
                rowval = this.buffer[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = Integer.MIN_VALUE;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.buffer[x - sewidth]);
            }
        }

        private void Process(double[] in, int sewidth, double[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            double T = -1.7976931348623157E308;
            double G = -1.7976931348623157E308;
            for (int x = 0; x < length; ++x) {
                double T_pre = T;
                double G_pre = G;
                double rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -1.7976931348623157E308;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = -1.7976931348623157E308;
                    nbprop = 0;
                }
                this.bufferdouble[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = -1.7976931348623157E308;
            G = -1.7976931348623157E308;
            nbprop = 0;
            double rowval = -1.7976931348623157E308;
            double rowval_pre = -1.7976931348623157E308;
            for (int x = 0; x < length; ++x) {
                double T_pre = T;
                double G_pre = G;
                rowval_pre = rowval;
                rowval = this.bufferdouble[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = -1.7976931348623157E308;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.bufferdouble[x - sewidth]);
            }
        }

        private void Process(float[] in, int sewidth, float[] out, int length) {
            int nbprop = 0;
            int l1 = length - 1;
            int sizexsewidth1 = l1 - sewidth;
            float T = -3.4028235E38f;
            float G = -3.4028235E38f;
            for (int x = 0; x < length; ++x) {
                float T_pre = T;
                float G_pre = G;
                float rowval = in[x];
                T = x > sizexsewidth1 ? (T_pre < rowval ? rowval : T_pre) : -3.4028235E38f;
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = x > sizexsewidth1 && nbprop >= sewidth ? T : rowval;
                    T = -3.4028235E38f;
                    nbprop = 0;
                }
                this.bufferfloat[l1 - x] = x - sewidth < 0 ? G : Math.max(G, in[x - sewidth]);
            }
            T = -3.4028235E38f;
            G = -3.4028235E38f;
            nbprop = 0;
            float rowval = -3.4028235E38f;
            float rowval_pre = -3.4028235E38f;
            for (int x = 0; x < length; ++x) {
                float T_pre = T;
                float G_pre = G;
                rowval_pre = rowval;
                rowval = this.bufferfloat[x];
                T = x == 0 ? rowval : (rowval > rowval_pre && T < rowval ? rowval : T_pre);
                if (G_pre > rowval && nbprop < sewidth) {
                    G = G_pre;
                    ++nbprop;
                } else {
                    G = nbprop >= sewidth ? T : rowval;
                    T = -3.4028235E38f;
                    nbprop = 0;
                }
                out[l1 - x] = x < sewidth ? G : Math.max(G, this.bufferfloat[x - sewidth]);
            }
        }
    }

    private class DilatehistThread
    extends Thread {
        private int min;
        private int max;
        private int[] Hist = new int[256];
        private byte[] lineIn = null;
        private byte[] lineOut = null;
        public final Object lock = new Object();
        private boolean Kill = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.lineOut = null;
            this.lineIn = null;
            this.Hist = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max) {
            this.min = min;
            this.max = max;
            int length = Math.max(DilateSegment45.this.SizeX, DilateSegment45.this.SizeY);
            if (this.lineIn == null || this.lineIn.length != length) {
                this.lineOut = null;
                this.lineIn = null;
                this.lineIn = new byte[length];
                this.lineOut = new byte[length];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        DilateSegment45.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int type = DilateSegment45.this.Type;
                int sizex = DilateSegment45.this.SizeX;
                int sizey = DilateSegment45.this.SizeY;
                int channel = DilateSegment45.this.Channel;
                int sizex1 = sizex - 1;
                Arrays.fill(this.Hist, 0);
                switch (type) {
                    case -2: {
                        int c = 0;
                        while (true) {
                            int Y;
                            if (c >= channel) continue block8;
                            byte[] bbin = (byte[])DilateSegment45.this.sigsin[c];
                            byte[] bbout = (byte[])DilateSegment45.this.sigsout[c];
                            int n = 0;
                            int y = sizey - 1;
                            int pos = bbin.length - 1;
                            while (y >= 0) {
                                if (this.min <= n && n < this.max) {
                                    int length = 0;
                                    int X = sizex1;
                                    int p2 = pos;
                                    for (Y = y; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = bbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    int i = 0;
                                    p2 = pos;
                                    while (i < length) {
                                        bbout[p2] = this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --y;
                                ++n;
                                pos -= sizex;
                            }
                            int x = sizex1;
                            while (x >= 0) {
                                if (this.min <= n && n < this.max) {
                                    int length = 0;
                                    int X = x;
                                    int p2 = x;
                                    for (Y = 0; 0 <= X && Y < sizey; --X, ++Y) {
                                        this.lineIn[length++] = bbin[p2];
                                        p2 += sizex1;
                                    }
                                    this.Process(this.lineIn, DilateSegment45.this.sewidth, this.lineOut, length);
                                    int i = 0;
                                    p2 = x;
                                    while (i < length) {
                                        bbout[p2] = this.lineOut[i++];
                                        p2 += sizex1;
                                    }
                                }
                                --x;
                                ++n;
                            }
                            bbout = null;
                            bbin = null;
                            ++c;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported (yet).");
                    }
                }
                break;
            }
        }

        private void Process(byte[] in, int sewidth, byte[] out, int length) {
            int aux;
            int i;
            if (length <= sewidth) {
                int i2;
                int maxi = 0;
                for (i2 = 0; i2 < length; ++i2) {
                    if (maxi >= (in[i2] & 0xFF)) continue;
                    maxi = in[i2] & 0xFF;
                }
                for (i2 = 0; i2 < length; ++i2) {
                    out[i2] = (byte)maxi;
                }
                return;
            }
            if (length <= sewidth << 1) {
                int aux2;
                int i3;
                int maxi = 0;
                for (i3 = 0; i3 < sewidth; ++i3) {
                    int n = aux2 = in[i3] & 0xFF;
                    this.Hist[n] = this.Hist[n] + 1;
                    if (maxi >= aux2) continue;
                    maxi = aux2;
                }
                i3 = 0;
                while (i3 + sewidth < length) {
                    int n = aux2 = in[i3 + sewidth] & 0xFF;
                    this.Hist[n] = this.Hist[n] + 1;
                    if (maxi < aux2) {
                        maxi = aux2;
                    }
                    out[i3] = (byte)maxi;
                    ++i3;
                }
                for (i3 = length - sewidth; i3 < sewidth && i3 < length; ++i3) {
                    out[i3] = (byte)maxi;
                }
                while (i3 < length) {
                    out[i3] = (byte)maxi;
                    int n = in[i3 - sewidth] & 0xFF;
                    this.Hist[n] = this.Hist[n] - 1;
                    while (this.Hist[maxi] == 0) {
                        --maxi;
                    }
                    ++i3;
                }
                for (i3 = length - sewidth; i3 < length; ++i3) {
                    int n = in[i3] & 0xFF;
                    this.Hist[n] = this.Hist[n] - 1;
                }
                return;
            }
            int maxi = 0;
            for (i = 0; i < sewidth; ++i) {
                int n = aux = in[i] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi >= aux) continue;
                maxi = aux;
            }
            for (i = 0; i < sewidth; ++i) {
                int n = aux = in[i + sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi < aux) {
                    maxi = aux;
                }
                out[i] = (byte)maxi;
            }
            while (i < length - sewidth) {
                int n = aux = in[i + sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] + 1;
                if (maxi < aux) {
                    maxi = aux;
                }
                out[i] = (byte)maxi;
                int n2 = in[i - sewidth] & 0xFF;
                this.Hist[n2] = this.Hist[n2] - 1;
                while (this.Hist[maxi] == 0) {
                    --maxi;
                }
                ++i;
            }
            for (i = length - sewidth; i < length; ++i) {
                out[i] = (byte)maxi;
                int n = in[i - sewidth] & 0xFF;
                this.Hist[n] = this.Hist[n] - 1;
                while (this.Hist[maxi] == 0) {
                    --maxi;
                }
            }
            for (i = length - sewidth; i < length; ++i) {
                int n = in[i] & 0xFF;
                this.Hist[n] = this.Hist[n] - 1;
            }
        }
    }
}

