/*
 * Decompiled with CFR 0.152.
 */
package morphee.fastMorphee;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.fastMorphee.DilateSegmentX;
import morphee.fastMorphee.DilateSegmentY;
import morphee.fastMorphee.DilateSegmentZ;
import utils.memory.Allocator;

public class DilateSquare
implements MorphoFilter {
    private final Allocator allocator = Allocator.Instance();
    private final DilateSegmentX dsx = new DilateSegmentX();
    private final DilateSegmentY dsy = new DilateSegmentY();
    private final DilateSegmentZ dsz = new DilateSegmentZ();
    private int sewidth = 0;
    private DV tmpdv = null;
    private float[] tempfloat = null;

    @Override
    public synchronized void Kill() {
        this.dsx.Kill();
        this.dsy.Kill();
        this.dsz.Kill();
        if (this.tmpdv != null) {
            this.tmpdv.Kill();
        }
        this.tmpdv = null;
        this.tempfloat = null;
    }

    @Override
    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        this.setStructuringElement(se);
        return this.Filter(source, nbCPU);
    }

    @Override
    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same(source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    public void Filter(BufferedImage source, int sewidth, BufferedImage result, int nbCPU) {
        BufferedImage tmp = ImageNew.Same(source);
        this.sewidth = sewidth;
        Object[] src = new Object[1];
        Object[] res = new Object[1];
        block0 : switch (source.getType()) {
            case 10: {
                src[0] = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferByte)tmp.getRaster().getDataBuffer()).getData();
                this.dsx.Filter(src, source.getWidth(), source.getHeight(), 1, -2, sewidth, res, nbCPU);
                src[0] = ((DataBufferByte)tmp.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                this.dsy.Filter(src, source.getWidth(), source.getHeight(), 1, -2, sewidth, res, nbCPU);
                break;
            }
            case 11: {
                src[0] = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferUShort)tmp.getRaster().getDataBuffer()).getData();
                this.dsx.Filter(src, source.getWidth(), source.getHeight(), 1, -3, sewidth, res, nbCPU);
                src[0] = ((DataBufferUShort)tmp.getRaster().getDataBuffer()).getData();
                res[0] = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                this.dsy.Filter(src, source.getWidth(), source.getHeight(), 1, -3, sewidth, res, nbCPU);
                break;
            }
            case 5: 
            case 6: {
                this.dsx.FilterInterlaced(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, sewidth, ((DataBufferByte)tmp.getRaster().getDataBuffer()).getData(), nbCPU);
                this.dsy.FilterInterlaced(((DataBufferByte)tmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -2, sewidth, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), nbCPU);
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.dsx.FilterInterlaced(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, sewidth, ((DataBufferInt)tmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.dsy.FilterInterlaced(((DataBufferInt)tmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -1, sewidth, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                    case 4: {
                        this.dsx.FilterInterlaced(((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, sewidth, ((DataBufferFloat)tmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.dsy.FilterInterlaced(((DataBufferFloat)tmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -4, sewidth, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                    case 5: {
                        this.dsx.FilterInterlaced(((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, sewidth, ((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData(), nbCPU);
                        this.dsy.FilterInterlaced(((DataBufferDouble)tmp.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight(), 1, source.getRaster().getNumBands(), -5, sewidth, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), nbCPU);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        tmp = this.allocator.Release(tmp);
        res[0] = null;
        src[0] = null;
        res = null;
        src = null;
    }

    @Override
    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same(source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(DV source, DV result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, this.sewidth, result, nbCPU);
    }

    @Override
    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    @Override
    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(DV source, int sewidth, DV result, int nbCPU) {
        if (this.tmpdv == null || !DvTools.areDimensionsAndTypeEqual(source, this.tmpdv)) {
            this.tmpdv = null;
            this.tmpdv = DvNew.Same(source);
        }
        this.sewidth = sewidth;
        switch (source.Type) {
            case 8: {
                this.dsx.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -2, sewidth, result.getDataBuffer(), nbCPU);
                this.dsy.Filter(result.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -2, sewidth, this.tmpdv.getDataBuffer(), nbCPU);
                this.dsz.Filter(this.tmpdv.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -2, sewidth, result.getDataBuffer(), nbCPU);
                break;
            }
            case 16: {
                this.dsx.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -3, sewidth, result.getDataBuffer(), nbCPU);
                this.dsy.Filter(result.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -3, sewidth, this.tmpdv.getDataBuffer(), nbCPU);
                this.dsz.Filter(this.tmpdv.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -3, sewidth, result.getDataBuffer(), nbCPU);
                break;
            }
            case -32: {
                this.dsx.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -4, sewidth, result.getDataBuffer(), nbCPU);
                this.dsy.Filter(result.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -4, sewidth, this.tmpdv.getDataBuffer(), nbCPU);
                this.dsz.Filter(this.tmpdv.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -4, sewidth, result.getDataBuffer(), nbCPU);
                break;
            }
            case 64: {
                this.dsx.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -5, sewidth, result.getDataBuffer(), nbCPU);
                this.dsy.Filter(result.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -5, sewidth, this.tmpdv.getDataBuffer(), nbCPU);
                this.dsz.Filter(this.tmpdv.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -5, sewidth, result.getDataBuffer(), nbCPU);
                break;
            }
            case 32: {
                this.dsx.Filter(source.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -1, sewidth, result.getDataBuffer(), nbCPU);
                this.dsy.Filter(result.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -1, sewidth, this.tmpdv.getDataBuffer(), nbCPU);
                this.dsz.Filter(this.tmpdv.getDataBuffer(), source.SizeX, source.SizeY, source.SizeZ, -1, sewidth, result.getDataBuffer(), nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    @Override
    public StructuringElement3D getStructuringElement3D() {
        return null;
    }

    @Override
    public void setStructuringElement3D(StructuringElement3D se) {
        this.sewidth = se.getOrder();
    }

    public float[] Filter(float[] source, int width, int height, int nbCPU) {
        float[] result = ArrayNew.Same(source);
        this.Filter(source, width, height, result, nbCPU);
        return result;
    }

    public void Filter(float[] source, int width, int height, float[] result, int nbCPU) {
        if (this.sewidth == 0) {
            throw new IllegalArgumentException("Structuring element's width not defined or less/equals than 0.");
        }
        this.Filter(source, width, height, this.sewidth, result, nbCPU);
    }

    public void Filter(float[] source, int width, int height, int sewidth, float[] result, int nbCPU) {
        if (this.tempfloat == null || !ArrayTools.areDimensionsEqual(source, this.tempfloat)) {
            this.tempfloat = null;
            this.tempfloat = ArrayNew.Same(source);
        }
        this.sewidth = sewidth;
        Object[] src = new Object[1];
        Object[] res = new Object[1];
        src[0] = source;
        res[0] = this.tempfloat;
        this.dsx.Filter(src, width, height, 1, -4, sewidth, res, nbCPU);
        src[0] = this.tempfloat;
        res[0] = result;
        this.dsy.Filter(src, width, height, 1, -4, sewidth, res, nbCPU);
        res[0] = null;
        src[0] = null;
        res = null;
        src = null;
    }

    @Override
    public StructuringElement getStructuringElement() {
        return null;
    }

    @Override
    public void setStructuringElement(StructuringElement se) {
        this.sewidth = se.getOrder();
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.sewidth = (Integer)parameters[0];
    }

    @Override
    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.sewidth);
        return params;
    }

    @Override
    public int BorderEffectSizeX() {
        return this.sewidth;
    }

    @Override
    public int BorderEffectSizeY() {
        return this.sewidth;
    }

    @Override
    public int BorderEffectSizeZ() {
        return this.sewidth;
    }

    @Override
    public MorphoFilter Clone() {
        DilateSquare clone = new DilateSquare();
        clone.Parameters(this.sewidth);
        return clone;
    }
}

