/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import dv.DvFeatures;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.filters.SignalFilter;

public class DynamicExpansion
implements SignalFilter {
    private double NewInf = -1.0;
    private double NewSup = -1.0;
    private double OldInf = -1.0;
    private double OldSup = -1.0;
    private double A;
    private double B;
    private Histogram histogram = new Histogram();
    private ArrayFeatures AF = new ArrayFeatures();
    private DvFeatures DF = new DvFeatures();
    private ImageFeatures IF = new ImageFeatures();

    @Override
    public void Kill() {
        this.histogram = null;
        this.AF = null;
        this.DF = null;
        this.IF = null;
    }

    @Override
    public BufferedImage Filter(BufferedImage Original, int nbCPU) {
        BufferedImage result = ImageNew.Same(Original);
        this.Filter(Original, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage Original, int LandMarkInf, int LandMarkSup, int nbCPU) {
        this.histogram.Fill(Original);
        return this.Filter(Original, this.histogram, LandMarkInf, LandMarkSup, nbCPU);
    }

    public BufferedImage Filter(BufferedImage Original, Histogram histogram, int LandMarkInf, int LandMarkSup, int nbCPU) {
        BufferedImage result = ImageNew.Same(Original);
        this.Filter(Original, histogram, LandMarkInf, LandMarkSup, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage Original, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup, int nbCPU) {
        BufferedImage result = ImageNew.Same(Original);
        this.Filter(Original, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.NewInf == -1.0) {
            throw new Error("Landmarks must be set before the call of this method.");
        }
        this.histogram.Fill(Original);
        this.Filter(Original, this.histogram, (int)this.NewInf, (int)this.NewSup, Result, nbCPU);
    }

    public void Filter(BufferedImage Original, Histogram histogram, int LandMarkInf, int LandMarkSup, BufferedImage Result, int nbCPU) {
        this.Filter(Original, histogram.getMinColor(), histogram.getMaxColor(), LandMarkInf, LandMarkSup, Result, nbCPU);
    }

    public void Filter(BufferedImage Original, int LandMarkInf, int LandMarkSup, BufferedImage Result, int nbCPU) {
        this.Filter(Original, (int)this.IF.Minimum(Original), (int)this.IF.Maximum(Original), LandMarkInf, LandMarkSup, Result, nbCPU);
    }

    public void Filter(BufferedImage Original, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup, BufferedImage Result, int nbCPU) {
        if (Original.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only single channel images supported.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual(Original, Result)) {
            throw new IllegalArgumentException("Images source and result must have equal dimensions and types.");
        }
        switch (Original.getType()) {
            case 10: {
                this.Filter(((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), ((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                break;
            }
            case 11: {
                this.Filter(((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public BufferedImage Filter(BufferedImage Original, double LandMarkInf, double LandMarkSup, int nbCPU) {
        if (Original.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only single channel images supported.");
        }
        BufferedImage Result = null;
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        Result = ImageNew.Float(Original.getWidth(), Original.getHeight(), 1);
                        break block0;
                    }
                    case 5: {
                        Result = ImageNew.Double(Original.getWidth(), Original.getHeight(), 1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.Filter(Original, LandMarkInf, LandMarkSup, Result, nbCPU);
        return Result;
    }

    public void Filter(BufferedImage Original, double LandMarkInf, double LandMarkSup, BufferedImage Result, int nbCPU) {
        if (Original.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only single channel images supported.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual(Original, Result)) {
            throw new IllegalArgumentException("Images source and result must have equal dimensions and types.");
        }
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        float[] fbin = ((DataBufferFloat)Original.getRaster().getDataBuffer()).getData();
                        float[] fbout = ((DataBufferFloat)Result.getRaster().getDataBuffer()).getData();
                        this.Filter(fbin, fbout, (float)this.AF.Minimum(fbin), (float)this.AF.Maximum(fbin), (float)LandMarkInf, (float)LandMarkSup);
                        break block0;
                    }
                    case 5: {
                        double[] dbin = ((DataBufferDouble)Original.getRaster().getDataBuffer()).getData();
                        double[] dbout = ((DataBufferDouble)Result.getRaster().getDataBuffer()).getData();
                        this.Filter(dbin, dbout, this.AF.Minimum(dbin), this.AF.Maximum(dbin), LandMarkInf, LandMarkSup);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public BufferedImage Filter(BufferedImage Original, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup, int nbCPU) {
        if (Original.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only single channel images supported.");
        }
        BufferedImage Result = null;
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        Result = ImageNew.Float(Original.getWidth(), Original.getHeight(), 1);
                        break block0;
                    }
                    case 5: {
                        Result = ImageNew.Double(Original.getWidth(), Original.getHeight(), 1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.Filter(Original, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup, Result, nbCPU);
        return Result;
    }

    public void Filter(BufferedImage Original, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup, BufferedImage Result, int nbCPU) {
        if (Original.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only single channel images supported.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual(Original, Result)) {
            throw new IllegalArgumentException("Images source and result must have equal dimensions and types.");
        }
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        float[] fbin = ((DataBufferFloat)Original.getRaster().getDataBuffer()).getData();
                        float[] fbout = ((DataBufferFloat)Result.getRaster().getDataBuffer()).getData();
                        this.Filter(fbin, fbout, (float)OldLandMarkInf, (float)OldLandMarkSup, (float)LandMarkInf, (float)LandMarkSup);
                        break block0;
                    }
                    case 5: {
                        double[] dbin = ((DataBufferDouble)Original.getRaster().getDataBuffer()).getData();
                        double[] dbout = ((DataBufferDouble)Result.getRaster().getDataBuffer()).getData();
                        this.Filter(dbin, dbout, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public BufferedImage FilterWithConditions(BufferedImage Original, double LowerCut, double UpperCut, int ForbiddenValue, int RangeMin, int RangeMax, int nbCPU) {
        BufferedImage result = ImageNew.Same(Original);
        this.FilterWithConditions(Original, LowerCut, UpperCut, ForbiddenValue, RangeMin, RangeMax, result, nbCPU);
        return result;
    }

    public void FilterWithConditions(BufferedImage Original, double LowerCut, double UpperCut, int ForbiddenValue, int RangeMin, int RangeMax, BufferedImage Result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual(Original, Result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        if (LowerCut < 0.0 || 100.0 < LowerCut) {
            throw new IllegalArgumentException("LowerCut must be within range [0,100].");
        }
        if (UpperCut < 0.0 || 100.0 < UpperCut) {
            throw new IllegalArgumentException("UpperCut must be within range [0,100].");
        }
        this.histogram.Fill(Original, ForbiddenValue);
        int[] hist = this.histogram.getValues(0);
        int sum = (int)this.AF.Integral(hist);
        int minrange = 0;
        int nb = hist[minrange];
        while ((double)nb / (double)sum * 100.0 < LowerCut) {
            nb += hist[++minrange];
        }
        int maxrange = hist.length - 1;
        nb = hist[maxrange];
        while ((double)nb / (double)sum * 100.0 < UpperCut) {
            nb += hist[--maxrange];
        }
        hist = null;
        block0 : switch (Original.getType()) {
            case 10: 
            case 11: {
                this.Filter(Original, minrange, maxrange, RangeMin, RangeMax, Result, nbCPU);
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        this.Filter(Original, minrange, maxrange, RangeMin, RangeMax, Result, nbCPU);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Image type not supported.");
            }
            default: {
                throw new UnsupportedOperationException("Image type not supported.");
            }
        }
    }

    @Override
    public DV Filter(DV Original, int nbCPU) {
        DV result = DvNew.Same(Original);
        this.Filter(Original, result, nbCPU);
        return result;
    }

    public DV Filter(DV Original, int LandMarkInf, int LandMarkSup, int nbCPU) {
        this.histogram.Fill(Original);
        return this.Filter(Original, this.histogram, LandMarkInf, LandMarkSup, nbCPU);
    }

    public DV Filter(DV Original, Histogram histogram, int LandMarkInf, int LandMarkSup, int nbCPU) {
        DV result = DvNew.Same(Original);
        this.Filter(Original, result, histogram, LandMarkInf, LandMarkSup, nbCPU);
        return result;
    }

    public DV Filter(DV Original, int channel, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup, int nbCPU) {
        DV result = DvNew.Same(Original);
        this.Filter(Original, result, channel, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup, nbCPU);
        return result;
    }

    @Override
    public void Filter(DV Original, DV Result, int nbCPU) {
        this.histogram.Fill(Original);
        this.Filter(Original, Result, this.histogram, (int)this.NewInf, (int)this.NewSup, nbCPU);
    }

    public void Filter(DV Original, DV Result, Histogram histogram, int LandMarkInf, int LandMarkSup, int nbCPU) {
        for (int c = 0; c < Original.Channel; ++c) {
            this.Filter(Original, Result, c, histogram.getMinColors()[c], histogram.getMaxColors()[c], LandMarkInf, LandMarkSup, nbCPU);
        }
    }

    public void Filter(DV Original, DV Result, int channel, int LandMarkInf, int LandMarkSup, int nbCPU) {
        this.Filter(Original, Result, channel, (int)this.DF.Minimum(Original, channel), (int)this.DF.Maximum(Original, channel), LandMarkInf, LandMarkSup, nbCPU);
    }

    public void Filter(DV Original, DV Result, int channel, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup, int nbCPU) {
        if (!DvTools.areDimensionsAndTypeEqual(Original, Result)) {
            throw new IllegalArgumentException("DV source and result must have equal dimensions and types.");
        }
        switch (Original.Type) {
            case 8: {
                this.Filter(Original.getDataBufferByte(channel), Result.getDataBufferByte(channel), OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                break;
            }
            case 16: {
                this.Filter(Original.getDataBufferShort(channel), Result.getDataBufferShort(channel), OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                break;
            }
            case 32: {
                this.Filter(Original.getDataBufferInt(channel), Result.getDataBufferInt(channel), OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    private void ComputeCoefficients(double oldmin, double oldmax, double newmin, double newmax) {
        if (oldmin > oldmax) {
            throw new IllegalArgumentException("Old landmarks error: " + oldmin + " >= " + oldmax);
        }
        if (newmin > newmax) {
            throw new IllegalArgumentException("New landmarks error: " + newmin + " >= " + newmax);
        }
        this.OldInf = oldmin;
        this.OldSup = oldmax;
        this.NewInf = newmin;
        this.NewSup = newmax;
        if (oldmin == oldmax && newmin == newmax) {
            this.A = 1.0;
            this.B = 0.0;
            return;
        }
        this.A = (newmax - newmin) / (oldmax - oldmin);
        this.B = newmin - this.A * oldmin;
    }

    public int[] Filter(int[] Original, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        int[] result = new int[Original.length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(int[] Original, int[] Result, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Original and Result arrays have different dimensions.");
        }
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        for (int x = 0; x < Original.length; ++x) {
            double v = a * (double)Original[x] + b;
            Result[x] = (int)(v < 0.0 ? v - 0.5 : v + 0.5);
        }
    }

    public byte[] Filter(byte[] Original, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        byte[] result = new byte[Original.length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(byte[] Original, byte[] Result, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        int x;
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Original and Result arrays have different dimensions.");
        }
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        byte[] Lut = new byte[256];
        Arrays.fill(Lut, 0, OldLandMarkInf, (byte)LandMarkInf);
        for (x = OldLandMarkInf; x <= OldLandMarkSup; ++x) {
            Lut[x] = (byte)(a * (double)x + b + 0.5);
        }
        for (x = OldLandMarkSup + 1; x < Lut.length; ++x) {
            Lut[x] = (byte)LandMarkSup;
        }
        for (x = 0; x < Original.length; ++x) {
            Result[x] = Lut[Original[x] & 0xFF];
        }
    }

    public short[] Filter(short[] Original, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        short[] result = new short[Original.length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(short[] Original, short[] Result, int OldLandMarkInf, int OldLandMarkSup, int LandMarkInf, int LandMarkSup) {
        int x;
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Original and Result arrays have different dimensions.");
        }
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        short[] Lut = new short[65536];
        Arrays.fill(Lut, 0, OldLandMarkInf, (short)LandMarkInf);
        for (x = OldLandMarkInf; x <= OldLandMarkSup; ++x) {
            Lut[x] = (short)(a * (double)x + b + 0.5);
        }
        for (x = OldLandMarkSup + 1; x < Lut.length; ++x) {
            Lut[x] = (short)LandMarkSup;
        }
        for (x = 0; x < Original.length; ++x) {
            Result[x] = Lut[Original[x] & 0xFFFF];
        }
    }

    public float[] Filter(float[] Original, float OldLandMarkInf, float OldLandMarkSup, float LandMarkInf, float LandMarkSup) {
        float[] result = new float[Original.length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(float[] Original, float[] Result, float OldLandMarkInf, float OldLandMarkSup, float LandMarkInf, float LandMarkSup) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Original and Result arrays have different dimensions.");
        }
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        for (int x = 0; x < Original.length; ++x) {
            Result[x] = (float)(a * (double)Original[x] + b);
        }
    }

    public double[] Filter(double[] Original, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup) {
        double[] result = new double[Original.length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(double[] Original, double[] Result, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Original and Result arrays have different dimensions.");
        }
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        for (int x = 0; x < Original.length; ++x) {
            Result[x] = a * Original[x] + b;
        }
    }

    public double[][] Filter(double[][] Original, double LandMarkInf, double LandMarkSup) {
        return this.Filter(Original, this.AF.Minimum(Original), this.AF.Maximum(Original), LandMarkInf, LandMarkSup);
    }

    public void Filter(double[][] Original, double[][] Result, double LandMarkInf, double LandMarkSup) {
        this.Filter(Original, Result, this.AF.Minimum(Original), this.AF.Maximum(Original), LandMarkInf, LandMarkSup);
    }

    public double[][] Filter(double[][] Original, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup) {
        double[][] result = new double[Original.length][Original[0].length];
        this.Filter(Original, result, OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        return result;
    }

    public void Filter(double[][] Original, double[][] Result, double OldLandMarkInf, double OldLandMarkSup, double LandMarkInf, double LandMarkSup) {
        if (Original.length != Result.length || Original[0].length != Result[0].length) {
            throw new IllegalArgumentException("Original and Result arrays have various dimensions.");
        }
        int height = Original.length;
        int width = Original[0].length;
        this.ComputeCoefficients(OldLandMarkInf, OldLandMarkSup, LandMarkInf, LandMarkSup);
        double a = this.A;
        double b = this.B;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Result[y][x] = a * Original[y][x] + b;
            }
        }
    }

    public double A() {
        return this.A;
    }

    public double B() {
        return this.B;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.ComputeCoefficients((Double)parameters[0], (Double)parameters[1], (Double)parameters[2], (Double)parameters[3]);
    }

    @Override
    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.OldInf);
        params.add(this.OldSup);
        params.add(this.NewInf);
        params.add(this.NewSup);
        return params;
    }

    @Override
    public int BorderEffectSizeX() {
        return 0;
    }

    @Override
    public int BorderEffectSizeY() {
        return 0;
    }

    @Override
    public int BorderEffectSizeZ() {
        return 0;
    }

    @Override
    public SignalFilter Clone() {
        return new DynamicExpansion();
    }
}

